CHANGELOG for 3.1.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 3.1 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v3.1.0...v3.1.1

* 3.1.5 (2016-10-03)

 * bug #20102 [Validator] Url validator not validating hosts ending in a number (gwkunze)
 * bug #20132 Use "more entropy" option for uniqid() (javiereguiluz)
 * bug #20122 [Validator] Reset constraint options (ro0NL)
 * bug #20116 fixed AddConstraintValidatorsPass config (fabpot)
 * bug #20078 Fix #19943 Make sure to process each interface metadata only once (lemoinem)
 * bug #20080 [Form] compound forms without children should be considered rendered implicitly (backbone87)
 * bug #20087 [VarDumper] Fix PHP 7.1 compat (nicolas-grekas)
 * bug #20086 [VarDumper] Fix PHP 7.1 compat (nicolas-grekas)
 * bug #20077 [Process] silent file operation to avoid open basedir issues (xabbuh)
 * bug #20079 fixed Twig support for 1.26 and 2.0 (fabpot)
 * bug #20051 Fix indexBy type extraction (lemoinem)
 * bug #19951 [Finder] Trim trailing directory slash in ExcludeDirectoryFilterIterator (ro0NL)
 * bug #19980 [Ldap] Fixed issue with legacy find() method not working as expected (csarrazi)
 * bug #20026 [Cache] Fixed password used to make the redis connection. (ErikSaunier)
 * bug #20018 [VarDumper] Fix test (nicolas-grekas)
 * bug #20011 Use UUID for error codes for Form validator. (Koc)
 * bug #20010 [DX] Fixed regression when exception message swallowed when logging it. (Koc)
 * bug #19983 [TwigBridge] removed Twig null nodes (deprecated as of Twig 1.25) (fabpot)
 * bug #19946 [Console] Fix parsing optionnal options with empty value in argv (chalasr)
 * bug #19636 [Finder] no PHP warning on empty directory iteration (ggottwald)
 * bug #19784 [HttpKernel] Fixed the nullable support for php 7.1 and below (iltar)
 * bug #19923 [bugfix] [Console] Set `Input::$interactive` to `false` when command is executed with `--quiet` as verbosity level (phansys)
 * bug #19811 Fixed the nullable support for php 7.1 and below (2.7, 2.8, 3.0) (iltar)
 * bug #19853 [PropertyInfo] Make ReflectionExtractor compatible with ReflectionType changes in PHP 7.1 (teohhanhui)
 * bug #19904 [Form] Fixed collapsed ChoiceType options attributes (HeahDude)
 * bug #19872 [Filesystem] Consider the umask setting when dumping a file (leofeyer)
 * bug #19908 [Config] Handle open_basedir restrictions in FileLocator (Nicofuma)
 * bug #19893 [FrameworkBundle] Remove cache clearer default value in config (nicolas-grekas)
 * bug #19924 [DoctrineBridge][PropertyInfo] Treat Doctrine decimal type as string (teohhanhui)
 * bug #19932 Fixed bad merge (GrahamCampbell)
 * bug #19922 [Yaml][TwigBridge] Use JSON_UNESCAPED_SLASHES for lint commands output (chalasr)
 * bug #19928 [Validator] Update IpValidatorTest data set with a valid reserved IP (jakzal)
 * bug #19813 [Console] fixed PHP7 Errors are now handled and converted to Exceptions (fonsecas72)
 * bug #19879 [Form] Incorrect timezone with DateTimeLocalizedStringTransformer (mbeccati)
 * bug #19878 Fix translation:update command count (tgalopin)
 * bug #19859 [ClassLoader] Fix ClassCollectionLoader inlining with declare(strict_types=1) (nicolas-grekas)
 * bug #19780 [FrameworkBundle] Incorrect line break in exception message (500 debug page) (pedroresende)
 * bug #19595 [form] lazy trans `post_max_size_message`. (aitboudad)
 * bug #19870 [DI] Fix setting synthetic services on ContainerBuilder (nicolas-grekas)
 * bug #19848 Revert "minor #19689 [DI] Cleanup array_key_exists (ro0NL)" (nicolas-grekas)
 * bug #19842 [FrameworkBundle] Check for class existence before is_subclass_of (chalasr)
 * bug #19827 [BrowserKit] Fix cookie expiration on 32 bit systems (jameshalsall)

* 3.1.4 (2016-09-03)

 * bug #19812 [WebProfilerBundle] Fix margin on toolbar route panel when no route is found in the request (jameshalsall)
 * bug #19786 Update profiler's layout to use flexbox (javiereguiluz)
 * bug #19794 [VarDumper] Various minor fixes & cleanups (nicolas-grekas)
 * bug #19751 Fixes the calendar in constructor to handle null (wakqasahmed)
 * bug #19743 [symfony/symfony] add "provides" for psr/cache-implementation (alcohol)
 * bug #19388 [Validator][GroupSequence] fixed GroupSequence validation ignores PropetyMetadata of parent classes (Sandro Hopf)
 * bug #19729 Add symfony/inflector to composer.json "replaces" (teohhanhui)
 * bug #19601 [FrameworkBundle] Added friendly exception when constraint validator class does not exist (yceruto)
 * bug #19580 [Validator] fixed duplicate constraints with parent class interfaces (dmaicher)
 * bug #19647 [Debug] Swap dumper services at bootstrap (lyrixx)
 * bug #19685 [DI] Include dynamic services in alternatives (ro0NL)
 * bug #19702 [Debug][HttpKernel][VarDumper] Prepare for committed 7.2 changes (aka "small-bc-breaks") (nicolas-grekas)
 * bug #19704 [DependencyInjection] PhpDumper::isFrozen inconsistency (allflame)
 * bug #19643 [DependencyInjection] Fix service autowiring inheritance (chalasr)
 * bug #19649 [Serializer] Fix denormalization of arrays (dunglas)
 * bug #19667 [SecurityBundle] Add missing deprecation notice for form_login.intention (ro0NL)
 * bug #19666 Verify explicitly that the request IP is a valid IPv4 address (nesk)
 * bug #19660 Disable CLI color for Windows 10 greater than 10.0.10586 (mlocati)
 * bug #19663 Exception details break the layout (Dionysis Arvanitis)
 * bug #19651 [HttpKernel] Fix HttpCache validation HTTP method (tgalopin)
 * bug #19650 [FrameworkBundle] Fix default lifetime of cache pools (nicolas-grekas)
 * bug #19623 [VarDumper] Fix dumping continuations (nicolas-grekas)
 * bug #19437 [PropertyInfo] Fix an error in PropertyInfoCacheExtractor (Ener-Getick)
 * bug #19549 [HttpFoundation] fixed Request::getContent() reusage bug (1ma)
 * bug #19373 [Form] Skip CSRF validation on form when POST max size is exceeded (jameshalsall)
 * bug #19541 Fix #19531 [Form] DateType fails parsing when midnight is not a valid time (mbeccati)
 * bug #19567 [Cache] Handle unserialize() failures gracefully (nicolas-grekas)
 * bug #19579 [Process] Strengthen Windows pipe files opening (again...) (nicolas-grekas)
 * bug #19564 Added class existence check if is_subclass_of() fails in compiler passes (SCIF)
 * bug #19551 [Cache] Use SCAN instead of KEYS with Redis >= 2.8 (nicolas-grekas)
 * bug #19522 [SwiftMailerBridge] Fix flawed deprecation message (chalasr)
 * bug #19510 [Process] Fix double-fread() when reading unix pipes (nicolas-grekas)
 * bug #19508 [Process] Fix AbstractPipes::write() for a situation seen on HHVM (at least) (nicolas-grekas)
 * bug #19470 undefined offset fix (#19406) (ReenExe)

* 3.1.3 (2016-07-30)

 * bug #19300 [HttpKernel] Use flock() for HttpCache's lock files (mpdude)
 * bug #19428 [Process] Fix write access check for pipes on Windows (nicolas-grekas)
 * bug #19442 [Cache] Fix default lifetime being ignored (nicolas-grekas)
 * bug #19435 [Cache] Fix incorrect timestamps generated by FilesystemAdapter (nicolas-grekas)
 * bug #19434 [Serializer] enable property info in framework bundle (David Badura)
 * bug #19439 [DependencyInjection] Fixed deprecated default message template with XML (jeremyFreeAgent)
 * bug #19397  [HttpFoundation] HttpCache refresh stale responses containing an ETag (maennchen)
 * bug #19426 [Form] Fix the money form type render with Bootstrap3 (Th3Mouk)
 * bug #19422 [DomCrawler] Inherit the namespace cache in subcrawlers (stof)
 * bug #19425 [BrowserKit] Uppercase the "GET" method in redirects (jakzal)
 * bug #19384 Fix PHP 7.1 related failures (nicolas-grekas)
 * bug #19379 [VarDumper] Fix for PHP 7.1 (nicolas-grekas)
 * bug #19342 Added class existence check if is_subclass_of() fails in compiler passes (SCIF)
 * bug #19369 Fix the DBAL session handler version check for Postgresql (stof)
 * bug #19368 [VarDumper] Fix dumping jsons casted as arrays (nicolas-grekas)
 * bug #19334 [Security] Fix the retrieval of the last username when using forwarding (stof)
 * bug #19352 [Serializer] Include the format in the cache key (dunglas)
 * bug #19321 [HttpFoundation] Add OPTIONS and TRACE to the list of safe methods (dunglas)
 * bug #19317 [BrowserKit] Update Client::getAbsoluteUri() for query string only URIs (georaldc)
 * bug #19298 [ClassLoader] Fix declared classes being computed when not needed (nicolas-grekas)
 * bug #19316 [Validator] Added additional MasterCard range to the CardSchemeValidator (Dennis Væversted)
 * bug #19290 [HttpKernel] fixed internal subrequests having an if-modified-since-header (MalteWunsch)
 * bug #19307 [Security] Fix deprecated usage of DigestAuthenticationEntryPoint::getKey() in DigestAuthenticationListener (Maxime STEINHAUSSER)
 * bug #19309 [DoctrineBridge] added missing error code for constraint. (Koc)
 * bug #19306 [Form] fixed bug - name in ButtonBuilder (cheprasov)
 * bug #19292 [varDumper] Fix missing usage of ExceptionCaster::$traceArgs (nicolas-grekas)
 * bug #19288 [VarDumper] Fix indentation trimming in ExceptionCaster (nicolas-grekas)
 * bug #19267 [Validator] UuidValidator must accept a Uuid constraint. (hhamon)
 * bug #19272 [Security] fixed DebugAccessDecisionManager::setVoters() (HeahDude)
 * bug #19260 [Form] Fix depreciation triggers (tgalopin)
 * bug #19186 Fix for #19183 to add support for new PHP MongoDB extension in sessions. (omanizer)
 * bug #19253 [Console] Fix block() padding formatting after #19189 (chalasr)
 * bug #19218 [Security][Guard] check if session exist before using it (pasdeloup)

* 3.1.2 (2016-06-30)

 * bug #19227 [DoctrineBridge] fixed default parameter value in UniqueEntityValidator (HeahDude)
 * bug #18934 Fixed some issues of the AccessDecisionManager profiler (javiereguiluz)
 * bug #19217 [HttpKernel] Inline ValidateRequestListener logic into HttpKernel (nicolas-grekas)
 * bug #18688 [HttpFoundation] Warning when request has both Forwarded and X-Forwarded-For (magnusnordlander)
 * bug #19173 [Console] Decouple SymfonyStyle from TableCell (ro0NL)
 * bug #19204 [Security] Allow LDAP loadUser override (tucksaun)
 * bug #19189 [Console] Fix formatting of SymfonyStyle::comment() (chalasr)
 * bug #19211 [Form] fix post max size translation type extension for >= 2.8 (Tobion)
 * bug #17822 [WIP]  [Form] fix `empty_data` option in expanded `ChoiceType` (HeahDude)
 * bug #19159 [WebProfilerBundle] Added a conflict for Http-Kernel < 3.1 (HeahDude)
 * bug #19134 Distinguish between first and subsequent progress bar displays (rquadling)
 * bug #19061 [FORM] fix post_max_size_message translation (alt. 2) (David Badura)
 * bug #19100 [Console] Fixed SymfonyQuestionHelper multi-choice with defaults (sstok)
 * bug #18924 [DoctrineBridge] Don't use object IDs in DoctrineChoiceLoader when passing a value closure (webmozart)
 * bug #19138 [DomCrawler] No more exception on field name with strange format (guiled, fabpot)
 * bug #18935 [Form] Consider a violation even if the form is not submitted (egeloen)
 * bug #19127 [Form] Add exception to FormRenderer about non-unique block names (enumag)
 * bug #19118 [Process] Fix pipes cleaning on Windows (nicolas-grekas)
 * bug #19128 Avoid phpunit 5.4 warnings on getMock (2.7+) (iltar)
 * bug #19120 [FrameworkBundle] templating can be fully disabled (xabbuh)
 * bug #19114 [HttpKernel] Dont close the reponse stream in debug (nicolas-grekas)
 * bug #19101 [Session] fix PDO transaction aborted under PostgreSQL (Tobion)
 * bug #18501 [HttpFoundation] changed MERGE queries (hjkl)
 * bug #19081 [YAML] Fixed parsing problem with nested DateTime lists (jkphl, xabbuh)
 * bug #19062 [HttpFoundation] Fix UPSERT for PgSql >= 9.5 (nicolas-grekas)
 * bug #18548 [Form] minor fixes in DateTime transformers (HeahDude)
 * bug #18732 [PropertyAccess][DX] Enhance exception that say that some methods are missing if they don't (nykopol)

* 3.1.1 (2016-06-15)

 * bug #19048 [HttpFoundation] Use UPSERT for sessions stored in PgSql >= 9.5 (nicolas-grekas)
 * bug #19042 [Cache] Fix double fetch in ProxyAdapter (nicolas-grekas)
 * bug #19038 Fix feature detection for IE (Alsciende)
 * bug #18915 [DependencyInjection] force enabling the external XML entity loaders (xabbuh)
 * bug #19020 [Form] Fixed collapsed choice attributes (HeahDude)
 * bug #19028 [Yaml] properly count skipped comment lines (xabbuh)
 * bug #19009 [WebProfilerBundle] Fix invalid CSS style (romainneutron)
 * bug #17733 [Yaml] Fix wrong line number when comments are inserted in the middle of a block. (paradajozsef)
 * bug #18909 Fixed singular of committee (peterrehm)
 * bug #18911 Fixed singular of committee (peterrehm)
 * bug #18971 Do not inject web debug toolbar on attachments (peterrehm)
 * bug #18944 [Ldap] Fixed issue with legacy client initialisation (csarrazi)
 * bug #18974 Added missing APCU CacheProvider of doctrine/cache 1.6.x (Carsten Eilers)
 * bug #18954 [HttpKernel] Fix RequestDataCollector starting the session (romainneutron)
 * bug #18949 [Security] Fix DebugAccessDecisionManager when object is not a scalar (romainneutron)
 * bug #18959 [WebProfilerBundle] Fixed forwarded request data in templates (HeahDude)
 * bug #18943 [Ldap][Security] The Ldap user provider abstract service now has the correct number of arguments (csarrazi)
 * bug #18925 [Console] Fix BC break introduced by #18101 (dunglas)
 * bug #18908 [DependencyInjection] force enabling the external XML entity loaders (xabbuh)
 * bug #18893 [DependencyInjection] Skip deep reference check for 'service_container' (RobertMe)
 * bug #18812 Catch \Throwable (fprochazka)
 * bug #18821 [Form] Removed UTC specification with timestamp (francisbesset)
 * bug #18861 Fix for #18843 (inso)

* 3.1.0 (2016-05-30)

 * bug #18889 [Console] SymfonyStyle: Fix alignment/prefixing of multi-line comments (chalasr)
 * bug #18907 [Routing] Fix the annotation loader taking a class constant as a beginning of a class name (jakzal, nicolas-grekas)
 * bug #18899 [Yaml] search for colons in strings only (xabbuh)

* 3.1.0-RC1 (2016-05-26)

 * bug #18879 [Console] SymfonyStyle: Align multi-line/very-long-line blocks (chalasr)
 * bug #18881 [Security][Ldap] Fixed issue with password attribute containing an array of values. (csarrazi)
 * bug #18864 [Console][DX] Fixed ambiguous error message when using a duplicate option shortcut (peterrehm)
 * bug #18883 Fix js comment in profiler (linnaea)
 * feature #18867 [Cache] Drop counting hit/miss in ProxyAdapter (nicolas-grekas)
 * bug #18837 [Serializer] AbstractObjectNormalizer: be sure that isAllowedAttribute is called (dunglas)
 * bug #18838 [Serializer] ObjectNormalizer: add missing parameters (dunglas)
 * bug #18844 [Yaml] fix exception contexts (xabbuh)
 * bug #18840 [Yaml] properly handle unindented collections (xabbuh)
 * bug #18765 Catch \Throwable (fprochazka)
 * bug #18813 Catch \Throwable (fprochazka)
 * bug #18839 People - person singularization (Keeo)
 * bug #18820 [Config] Allow schemed paths in FileResource (nicolas-grekas)
 * bug #18828 [Yaml] chomp newlines only at the end of YAML documents (xabbuh)
 * bug #18814 Fixed server status command when port has been omitted (peterrehm)
 * bug #18759 [Validator] Support for DateTimeImmutable (krzysiekpiasecki)
 * bug #18799 Use levenshtein level for better Bundle matching (j0k3r)
 * bug #18413 [WebProfilerBundle] Fix CORS ajax security issues (romainneutron)

* 3.1.0-BETA1 (2016-05-13)

 * feature #18725 [Ldap] Added the possibility to configure all available Ldap options for connection (csarrazi)
 * feature #18715 [FrameworkBundle] Default to Apcu+Filesystem cache chain (nicolas-grekas)
 * feature #18184 [DomCrawler] Expose getter for uri (hason)
 * feature #18654 [Bridge/Doctrine] Use better exception in the register mapping pass (dantleech)
 * feature #18676 [HttpKernel] Add request method to logger messages (gnat42)
 * feature #18716 [Cache] Add nonce based cache invalidation to ApcuAdapter (nicolas-grekas)
 * feature #18762 [Translation] XLIFF Add `id` to meta data. (SpacePossum)
 * feature #18689 [Cache] Add support for Predis, RedisArray and RedisCluster (nicolas-grekas)
 * feature #18667 [FrameworkBundle] Semantic config for app/system/pool caches (tgalopin, nicolas-grekas)
 * feature #18685 move event listener method type hint docs to @Event annotations defau… (Haehnchen)
 * feature #18681 [Cache] Add DSN based Redis connection factory (nicolas-grekas)
 * feature #18656 Updating the error message of an AuthenticationEntryPointInterface (weaverryan)
 * feature #18069 [DoctrineBridge] deprecate `MergeDoctrineCollectionListener::onBind()` (HeahDude)
 * feature #18492 [LDAP] Check whether an entry attribute exists (hiddewie)
 * feature #18359 [Form] [DoctrineBridge] optimized LazyChoiceList and DoctrineChoiceLoader (HeahDude)
 * feature #18357 [Form] Let `TextType` implement `DataTransformerInterface` (HeahDude)
 * feature #18631 [FrameworkBundle] Add optional logger to cache pools (nicolas-grekas)
 * feature #18597 [Cache] Add CacheItem::validateKey utility method (nicolas-grekas)
 * feature #17660 	[Serializer] Integrate the PropertyInfo Component (recursive denormalization and hardening) (mihai-stancu, dunglas)
 * feature #18561 [FrameworkBundle] Fallback to default cache system in production for serializer (tgalopin)
 * feature #18567 [FrameworkBundle][Serializer] Fix APC cache service name (tgalopin)
 * feature #17959 [Serializer] Harden the ObjectNormalizer (dunglas)
 * feature #18547 DX: better error message if factory class is empty (dbu)
 * feature #18020 fix #17993 - Deprecated callable strings (hamza)
 * feature #18487 [Cache] Add DoctrineProvider, for using PSR-6 pools in Doctrine Cache (nicolas-grekas)
 * feature #18544 [FrameworkBundle] Fallback to default cache system in production for validation (tgalopin)
 * feature #18416 [FrameworkBundle] Calls support for debug:container (JhonnyL)
 * feature #18513 [Process] Turn getIterator() args to flags & add ITER_SKIP_OUT/ERR modes (nicolas-grekas)
 * feature #18371 [FrameworkBundle] integrate the Cache component (xabbuh, nicolas-grekas)
 * feature #18440 Add the kernel.controller_arguments event (stof)
 * feature #18308 Added an ArgumentResolver with clean extension point (iltar, HeahDude)
 * feature #18414 [Process] Implement IteratorAggregate to stream output (nicolas-grekas)
 * feature #18144 [DI] Only rebuild autowiring cache when actually needed (weaverryan)
 * feature #18386 [Process] Add InputStream to seamlessly feed running processes (nicolas-grekas)
 * feature #18167 [DependencyInjection] Fix a limitation of the PhpDumper (Ener-Getick)
 * feature #18387 [DX] [LDAP] Added default service name for the Security component's Ldap providers (csarrazi)
 * feature #18290 [Translation] deprecate the backup feature (xabbuh)
 * feature #18036 [Serializer] XmlEncoder: Make load flags configurable (dunglas)
 * feature #17589  [WebProfilerBundle] [DX] Feature allow forward and redirection detection in wdt (HeahDude)
 * feature #18260 Add Inflector component (from StringUtil of PropertyAccess) (teohhanhui)
 * feature #18356 [FrameworkBundle] Deprecated form types as services (HeahDude)
 * feature #17458 Add strict image validation (Koc)
 * feature #18350 [Process] Accept Traversable input (nicolas-grekas)
 * feature #18135 [Security] Deprecate onAuthenticationSuccess() (weaverryan)
 * feature #18294 [Yaml] dump non UTF-8 encoded strings as binary data (xabbuh)
 * feature #18215 [Cache] Add a Chain adapter (dunglas, nicolas-grekas)
 * feature #18242 [FrameworkBundle][TwigBundle] Make EngineInterface autowirable (dunglas)
 * feature #18197 Make Request::isFromTrustedProxy() public. (Peter Bex)
 * feature #18211 [Security] Use auth trust resolver to determine anonymous in ContextListener (WouterJ)
 * feature #18232 [Bridge\PhpUnit] Add "disabled" mode to SYMFONY_DEPRECATIONS_HELPER (nicolas-grekas)
 * feature #18181 [PhpUnitBridge] Mock DNS functions (nicolas-grekas)
 * feature #18176 [Cache] Restrict flushes to namespace scopes (nicolas-grekas)
 * feature #18172 [Cache] Redis adapter (gcds, nicolas-grekas)
 * feature #18101 [Console] Allow to register commands privately (Ener-Getick)
 * feature #18143 [DomCrawler] Exposed getter for baseHref (AAstakhov)
 * feature #18034 [FrameworkBundle] Deprecate absolute template paths (jakzal)
 * feature #18105 [HttpFoundation] Add support for sending raw cookies in the response (jakzal)
 * feature #17255 [Console] ApplicationTester - test stdout and stderr (SpacePossum)
 * feature #18024 [Cache] Add namespace handling to all adapters (nicolas-grekas)
 * feature #17734 [Cache] Count cache hits/misses in ProxyAdapter (nicolas-grekas)
 * feature #17887 Show more information in the security profiler (javiereguiluz)
 * feature #17642 [FrameworkBundle] [DX] Add `Controller::json` method to make it easy to send json (mcfedr)
 * feature #17484 [FrameworkBundle][DX] Add Levenshtein suggesters to AbstractConfigCommand (kix)
 * feature #17690 [FrameworkBundle] Use canBeEnabled() instead of canBeUnset() for consistency (Ener-Getick)
 * feature #17714 Adding new TargetPathTrait to get/set the authentication "target_path" (weaverryan)
 * feature #17852 Improved the logger panel when the log context is very long (javiereguiluz)
 * feature #17761 [Console] Add non-auto column width functionality (akeeman)
 * feature #17943 [Yaml] option to dump multi line strings as scalar blocks (xabbuh)
 * feature #17553 [Validator] Added a format option to the DateTime constraint. (dosten)
 * feature #17728 [Yaml] add option to dump objects as maps (xabbuh)
 * feature #17863 [Yaml] add support for parsing the !!binary tag (xabbuh)
 * feature #17738 [PropertyAccess] Throw an InvalidArgumentException when the type do not match (dunglas)
 * feature #17531 [PropertyInfo] Use last version of reflection docblock (joelwurtz)
 * feature #17782 Support autowiring for Doctrine\Common\Annotations\Reader (maryo)
 * feature #17603 [Serializer] Add a normalizer that support JsonSerializable objects (mcfedr)
 * feature #17630 [FrameworkBundle] Register the DateTimeNormalizer (dunglas)
 * feature #17631 [FrameworkBundle] Register the DataUriNormalizer (dunglas)
 * feature #17545 [Serializer] Add normalizer / denormalizer awarness (joelwurtz)
 * feature #17877 [DependencyInjection] Improving autowiring error messages (weaverryan)
 * feature #17732 [DEPRECATION] : deprecated support for Traversable in method ResizeFormListener::PreSubmit (ybensacq)
 * feature #17721 [Cache] Add FilesystemAdapter (nicolas-grekas)
 * feature #17836 [Yaml] support to parse and dump DateTime objects (xabbuh)
 * feature #17809 [Yaml] deprecate starting plain scalars with  characters (xabbuh)
 * feature #17817 [Ldap] Add write support for the Ldap component (csarrazi)
 * feature #17560 [Ldap] Improving the LDAP component (csarrazi)
 * feature #17726 [FrameworkBundle] Improve debug:container command (voronkovich)
 * feature #17743 [Yaml] dumper flag for enabling exceptions on invalid type (xabbuh)
 * feature #17746 [Yaml] deprecate the Dumper::setIndentation() method (xabbuh)
 * feature #17730 [Yaml] introduce flags to customize the parser behavior (xabbuh)
 * feature #17125 Webprofiler add status code to search form (oktapodia)
 * feature #17705 [TwigBridge] deprecate the boolean object support trigger (xabbuh)
 * feature #17578 [Yaml] dump customization option with dumper flags (xabbuh)
 * feature #17585  [DomCrawler] Abstract URI logic and crawl images (valeriangalliat)
 * feature #17654 [Cache] Don't clone, serialize (nicolas-grekas)
 * feature #16947 [FrameworkBundle] PropertyInfo: register the SerializerExtractor (dunglas)
 * feature #17611 [HttpKernel] Deprecate passing objects as URI attributes to the ESI and SSI renderers (jakzal)
 * feature #14288 [Console] Add getters for Application::$autoExit and $catchExceptions (VasekPurchart)
 * feature #17504 [Console] Show code when an exception is thrown (maidmaid)
 * feature #17540 [WebProfilerBundle] Add HTTP return code in the Ajax request list table (kucharovic)
 * feature #17446 [Serializer] Add PSR-6 adapter (dunglas)
 * feature #16917 [PropertyInfo] Cache support (dunglas)
 * feature #17532 [Asset] Version as service (ewgRa)
 * feature #17440 [Validator] Add a PSR-6 adapter (dunglas)
 * feature #17113 [Serializer] Add a MaxDepth option (dunglas)
 * feature #17530 [Cache] Handle and log errors properly (nicolas-grekas)
 * feature #17522 [Cache] Use generator in ArrayAdapter (gcds)
 * feature #16164 [Serializer] Add a data: URI normalizer (dunglas)
 * feature #15279 Added {{ value }} message placeholder to UniqueEntityValidator (jperovic)
 * feature #16652 [console] Add truncate method to FormatterHelper (mheki)
 * feature #17438 [Cache] Allow and use generators in AbstractAdapter (nicolas-grekas)
 * feature #17111 [HttpKernel] added a setter for the headers property in the HttpException (smatyas)
 * feature #17132 [DependencyInjection] Properly ignore invalid reference arguments in collection arguments (ogizanagi)
 * feature #17427 [Process] Allow a callback whenever the output is disabled (romainneutron)
 * feature #17327 Added support links to exception and toolbar (peterrehm)
 * feature #16909 Allows access to payload in callback validator (conradkleinespel)
 * feature #17402 [Profiler] make it possible to omit the link var (xabbuh)
 * feature #17411 [Serializer] Add a new DateTime normalizer (dunglas)
 * feature #17462 [Yaml] deprecate parsing the !!php/object tag (xabbuh)
 * feature #17408 [Cache] Symfony PSR-6 implementation (nicolas-grekas)
 * feature #17323 [DependencyInjection] Deprecate unsupported attributes/elements for alias (Ener-Getick)
 * feature #17305 [VarDumper] Add flags to allow fine tuning dumps representation (nicolas-grekas)
 * feature #17318 [HttpFoundation] Allow to get all the mime types associated to a format in the Request (Ener-Getick)
 * feature #17133 [DependencyInjection] Make YamlFileLoader raise a deprecation notice if a service definition contains unsupported keywords. (hhamon)
 * feature #17191 [Serializer] Move the normalization logic in an abstract class (dunglas)
 * feature #16994 [Form] Deprecate the "choices_as_values" option of ChoiceType (nicolas-grekas)
