CHANGELOG for 7.1.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 7.1 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v7.1.0...v7.1.1

* 7.1.6 (2024-10-27)

 * bug #58669 [Cache] Revert "Initialize RedisAdapter cursor to 0" (nicolas-grekas)
 * bug #58649 [TwigBridge] ensure compatibility with Twig 3.15 (xabbuh)
 * bug #58661 [Cache] Initialize RedisAdapter cursor to 0 (thomas-hiron)
 * bug #58593 [Mime] fix encoding issue with UTF-8 addresses containing doubles spaces (0xb4lint)
 * bug #58636 [Notifier] Improve Telegrams markdown escaping (codedge)
 * bug #58615 [Validator] [Choice] Fix callback option if not array returned (symfonyaml)
 * bug #58618 [DependencyInjection] Fix linting factories implemented via __callStatic (KevinVanSonsbeek)
 * bug #58619 [HttpFoundation][Lock] Ensure compatibility with ext-mongodb v2 (GromNaN)
 * bug #58627 Minor fixes around `parse_url()` checks (nicolas-grekas)
 * bug #58631 [DependencyInjection] Fix parsing nested AutowireInline attributes (nicolas-grekas)
 * bug #58617 [DependencyInjection] Fix replacing abstract arguments with bindings (nicolas-grekas)
 * bug #58623 [Intl] do not access typed property before initialization (xabbuh)
 * bug #58626 [BrowserKit][FrameworkBundle] do not access typed properties before initialization (xabbuh)
 * bug #58613 Symfony 5.4 LTS will get security fixes until Feb 2029 thanks to Ibexa' sponsoring (nicolas-grekas)
 * bug #58523 [DoctrineBridge] fix: DoctrineTokenProvider not oracle compatible (jjjb03)
 * bug #58569 [Mailer][MailJet] Fix parameters for TrackClicks and TrackOpens (torohill)
 * bug #58557 [Doctrine][Messenger] Oracle sequences are suffixed with `_seq` (clem-rwan)
 * bug #58525 [Notifier] silence warnings triggered when malformed XML is parsed (xabbuh)
 * bug #58550 [Scheduler] silence PHP warning when an invalid date interval format string is used (xabbuh)
 * bug #58387 [Validator][CidrValidator] Fix error message for `OutOfRangeNetmask` validation (Fabdouarrahmane)
 * bug #58492 [MonologBridge] Fix PHP deprecation with `preg_match()` (simoheinonen)
 * bug #58449 [Form] Support intl.use_exceptions/error_level in NumberToLocalizedStringTransformer (bram123)
 * bug #54566 [Doctrine][Messenger] Use common sequence name to get id from Oracle (rjd22)
 * bug #58459 [FrameworkBundle] Fix displayed stack trace when session is used on stateless routes (nicolas-grekas)
 * bug #58255 [Serializer] Fix `ObjectNormalizer` gives warnings on normalizing with public static property (André Laugks)
 * bug #58306 [Serializer] Collect denormalization errors for variadic params (mtarld)
 * bug #58376 [HttpKernel] Correctly merge `max-age`/`s-maxage` and `Expires` headers (aschempp)
 * bug #58299 [DependencyInjection] Fix `XmlFileLoader` not respecting when env for services (Bradley Zeggelaar)
 * bug #58332 [Console] Suppress `proc_open` errors within `Terminal::readFromProcess` (fritzmg)
 * bug #58343 [HttpClient] Add `crypto_method` to scoped client options (HypeMC)
 * bug #58395 [TwigBridge] Fixed a parameterized choice label translation (7-zete-7)
 * bug #58409 [Translation] Fix extracting of message from ->trans() method with named params (tugmaks)
 * bug #58404 [TwigBridge] Remove usage of `Node()` instantiations (fabpot)
 * bug #58377 [Emoji] Update data to support emoji 16 (lyrixx)
 * bug #58393 [Dotenv] Default value can be empty (HypeMC)
 * bug #58400 [Mailer] Fix exception message on invalid event in `SendgridPayloadConverter` (alexandre-daubois)
 * bug #58372 Tweak error/exception handler registration (nicolas-grekas)
 * bug #58368 [Serializer] Readd AdvancedNameConverterInterface to MetadataAwareNameConverter (aurimasrimkusnfq, aurimasrim)
 * bug #58371 [PropertyInfo] Fix bigint extraction with type info (mtarld)
 * bug #58365 [Cache] silence warnings issued by Redis Sentinel on connection issues (xabbuh)
 * bug #58339 [Notifier] allow the Novu bridge to be used with symfony/notifier 7.x (xabbuh)

* 7.1.5 (2024-09-21)

 * bug #58327 [FrameworkBundle] Do not access the container when the kernel is shut down (jderusse)
 * bug #58316 [Form] Don't call the constructor of LogicalOr (derrabus)
 * bug #58259 [TypeInfo] Return bound type as base type in `TemplateType` (valtzu)
 * bug #58290 [FrameworkBundle] fix XSD to allow to configure locks without resources (xabbuh)
 * bug #58291 [Process] Fix finding executables independently of open_basedir (BlackbitDevs)
 * bug #58279 [Yaml] parse empty sequence elements as null (xabbuh)
 * bug #58289 [HttpKernel] Skip logging uncaught exceptions in `ErrorHandler`, assume `$kernel->terminateWithException()` will do it (nicolas-grekas)
 * bug #58185 [Filesystem] make sure temp files can be cleaned up on Windows (xabbuh)
 * bug #58226 [Serializer] Fix for method named `get()` (mihai-stancu)
 * bug #58242 [Notifier][TurboSMS] Process partial accepted response from transport (ZhukV)
 * bug #58260 [Cache] Fix RedisSentinel param types (Paweł Stasicki)
 * bug #58278 [HttpClient] Fix setting `CURLMOPT_MAXCONNECTS` (HypeMC)
 * bug #58274 [Dotenv] throw a meaningful exception when parsing dotenv files with BOM (xabbuh)
 * bug #58240 [FrameworkBundle] Fix service reset between tests (HypeMC)
 * bug #58266 [HttpKernel] pass CSV escape characters explicitly (xabbuh)
 * bug #58181 [HttpFoundation] Update links for `X-Accel-Redirect` and fail properly when `X-Accel-Mapping` is missing (nicolas-grekas)
 * bug #58195 [Process] Fix the removal of host-specific configuration when managing the ini settings in `PhpSubprocess` (M-arcus)
 * bug #58218 Work around `parse_url()` bug (nicolas-grekas)
 * bug #58207 [TwigBridge] Avoid calling deprecated mergeGlobals() (derrabus)
 * bug #58198 [TwigBundle] Add support for resetting globals between HTTP requests (fabpot)
 * bug #58189 [Process] Fix backwards compatibility for invalid commands (ausi)
 * bug #58169 [Cache] Fix compatibility with Redis 6.1.0 pre-releases (cedric-anne)
 * bug #58143 [Ldap] Fix extension deprecation (alexandre-daubois)

* 7.1.4 (2024-08-30)

 * bug #58110 [PropertyAccess] Fix handling property names with a `.` (alexandre-daubois)
 * bug #58127 [Validator] synchronize IBAN formats (xabbuh)
 * bug #58112 fix Twig 3.12 compatibility (xabbuh)
 * bug #58078 [TwigBridge] Fix Twig deprecation notice (yceruto)
 * bug #58000 [DependencyInjection] Fix issue between decorator and service locator index (lyrixx)
 * bug #58044 [HttpClient] Do not overwrite the host to request when using option "resolve" (xabbuh)
 * bug #58046 [AssetMapper] Fix JsDeliver import regexp (smnandre)
 * bug #57298 [DependencyInjection] Fix handling of repeated `#[Autoconfigure]` attributes (alexandre-daubois)
 * bug #57493 [SecurityBundle] Make security schema deterministic (MatTheCat)
 * bug #58025 [Mailer] [Brevo] Support the `unique_proxy_open` event (richardhj)
 * bug #58015 [HttpKernel] ESI fragment content may be missing in conditional requests (mpdude)
 * bug #58017 [SecurityBundle] Revert adding `_stateless` attribute to the request when firewall is stateless and the attribute is not already set (MatTheCat)
 * bug #58020 [TwigBridge] fix compatibility with Twig 3.12 and 4.0 (xabbuh)
 * bug #58002 [Security] Revert stateless check for ContextListener (VincentLanglet)
 * bug #58010 [PsrHttpMessageBridge] Fix conversion of partitioned cookies in the PSR-7 bridge (stof)
 * bug #57853 [Console] Fix side-effects from running bash completions (Seldaek)
 * bug #57997 [Console][PhpUnitBridge][VarDumper] Fix handling NO_COLOR env var (nicolas-grekas)
 * bug #57928 [Serializer] fix denormalizing mixed collection values (rynhndrcksn)
 * bug #57944 [DoctrineBridge] Fix the `LockStoreSchemaListener` (MatTheCat)
 * bug #57984 [Validator] Add `D` regex modifier in relevant validators (alexandre-daubois)
 * bug #57981 [HttpClient] reject malformed URLs with a meaningful exception (xabbuh)
 * bug #57968 [Yaml] :bug: throw ParseException on invalid date (homersimpsons)
 * bug #57925 [Validator] reset the validation context after validating nested constraints (xabbuh)
 * bug #57933 [Messenger] Prevent waiting time to overflow when using long delays (alexandre-daubois)
 * bug #57920 [Form] Fix handling empty data in ValueToDuplicatesTransformer (xabbuh)
 * bug #57917 [HttpKernel] [WebProfileBundle] Fix Routing panel for URLs with a colon (akeylimepie)
 * bug #57885 [Cache] fix compatibility with redis extension 6.0.3+ (xabbuh)
 * bug #57861 [Form] NumberType: Fix parsing of numbers in exponential notation with negative exponent (jbtronics)
 * bug #57937 [DependencyInjection] Fix importing PHP configs in the prepend extension method (yceruto)
 * bug #57921 [Finder] do not duplicate directory separators (xabbuh)
 * bug #57875 [String] Fixed Quorum plural, and Quora singular in EnglishInflector (Dean151)
 * bug #57895 [Finder] do not duplicate directory separators (xabbuh)
 * bug #57905 [Validator] allow more unicode characters in URL paths (xabbuh)
 * bug #57899 [String] [EnglishInflector] Fix words ending with `le`, e.g., `articles` (aleho)
 * bug #57894 [Validator] Add `tldMessage` parameter to `Url` constraint constructor (syjust)
 * bug #57896 [Mime] Fix `RawMessage` constructor argument type (alexandre-daubois)
 * bug #57887 [Uid] Ensure UuidV1 is created in lowercase (smnandre)
 * bug #57870 [HttpClient] Disable HTTP/2 PUSH by default when using curl (nicolas-grekas)
 * bug #57625 [DoctrineBridge] Make `EntityValueResolver` return `null` if a composite ID value is `null` (MatTheCat)

* 7.1.3 (2024-07-26)

 * bug #57803 [FrameworkBundle] move adding detailed JSON error messages to the validate phase (xabbuh)
 * bug #57815 [Console][PhpUnitBridge][VarDumper] Fix `NO_COLOR` empty value handling (alexandre-daubois)
 * bug #57828 [Translation] Fix CSV escape char in `CsvFileLoader` on PHP >= 7.4 (alexandre-daubois)
 * bug #57812 [Validator] treat uninitialized properties referenced by property paths as null (xabbuh)
 * bug #57816 [DoctrineBridge] fix messenger bus dispatch inside an active transaction (IndraGunawan)
 * bug #57799 [ErrorHandler][VarDumper] Remove PHP 8.4 deprecations (alexandre-daubois)
 * bug #57772 [WebProfilerBundle] Add word wrap in tables in dialog to see all the text in workflow listeners dialog (SpartakusMd)
 * bug #57708 [PropertyInfo] Check if property is nullable when using `ReflectionExtractor` (benjilebon)
 * bug #57802 [PropertyInfo] Fix nullable value returned from extractFromMutator on CollectionType (benjilebon)
 * bug #57832 [DependencyInjection] Do not try to load default method name on interface (lyrixx)
 * bug #57748 [SecurityBundle] use firewall-specific user checkers when manually logging in users (xabbuh)
 * bug #57753 [ErrorHandler] restrict the maximum length of the X-Debug-Exception header (xabbuh)
 * bug #57646 [Serializer] Raise correct exception in `ArrayDenormalizer` when called without a nested denormalizer (derrabus)
 * bug #57674 [Cache] Improve `dbindex` DSN parameter parsing (constantable)
 * bug #57678 [Validator] Add `setGroupProvider` to `AttributeLoader` (Maximilian Zumbansen)
 * bug #57679 [WebProfilerBundle] Change incorrect check for the `stateless` request attribute (themasch)
 * bug #57663 [Cache] use copy() instead of rename() on Windows (xabbuh)
 * bug #57617 [PropertyInfo] Handle collection in PhpStan same as PhpDoc (mtarld)
 * bug #54057 [Messenger] Passing actual `Envelope` to `WorkerMessageRetriedEvent`  (daffoxdev)
 * bug #57645 [Routing] Discard in-memory cache of routes when writing the file-based cache (mpdude)
 * bug #57621 [Mailer]  force HTTP 1.1 for Mailgun API requests (xabbuh)
 * bug #57616 [String] Revert "Fixed u()->snake(), b()->snake() and s()->snake() methods" (nicolas-grekas)
 * bug #57593 [SecurityBundle] Compare paths after realpath() has been applied to both (xabbuh)
 * bug #57594 [String] Normalize underscores in snake() (xabbuh)
 * bug #57585 [HttpFoundation] Fix MockArraySessionStorage to generate more conform ids (Seldaek)
 * bug #57589 [FrameworkBundle] fix AssetMapper usage without assets enabled (xabbuh)

* 7.1.2 (2024-06-28)

 * bug #57345 [DependencyInjection] Fix regression in ordering service locators by priority (longwave)
 * bug #57553 [HttpKernel] Enable optional cache-warmers when cache-dir != build-dir (nicolas-grekas)
 * bug #57497 [String] Fixed u()->snake(), b()->snake() and s()->snake() methods (arczinosek)
 * bug #57574 [Filesystem] Fix Filesystem::remove() on Windows (nicolas-grekas)
 * bug #57572 [DoctrineBridge] Fix compat with DI >= 6.4 (nicolas-grekas)
 * bug #57541 [Serializer] [ObjectNormalizer] Use bool filter when FILTER_BOOL is set (Maximilian Zumbansen)
 * bug #57538 [String] Add `alias` case to `EnglishInflector` (alexandre-daubois)
 * bug #57533 [FrameworkBundle] Throw runtime exception when trying to use asset-mapper while http-client is disabled (nicolas-grekas)
 * bug #57520 [SecurityBundle] Remove unused memory users’ `name` attribute from the XSD (MatTheCat)
 * bug #57554 [FrameworkBundle] Fix warming up routes (nicolas-grekas)
 * feature #57557 Ibexa is sponsoring Symfony 5.4, thanks to them! \o/ (nicolas-grekas)
 * bug #57433 [Serializer] forward exceptions caught in the `AbstractObjectNormalizer` (HypeMC, xabbuh)
 * bug #57569 [HttpClient][Mailer] Revert "Let curl handle transfer encoding", use HTTP/1.1 for Mailgun (nicolas-grekas)
 * bug #57564 [HttpClient] Fix initializing InformationalChunk (nicolas-grekas)
 * bug #57289 [DependencyInjection] Fix phpdoc for $calls in class Autoconfigure (ThomasTr)
 * bug #57499 [Mailer] Add additional headers in Scaleway bridge (MrMicky-FR)
 * bug #57488 [Security] check token in payload instead just request (eltharin)
 * bug #57460 [VarExporter] fix contravariance problem with __unserialize() in lazy proxy (nikophil)
 * bug #57397 [VarDumper] Fix FFI caster test (alexandre-daubois)
 * bug #57453 [HttpClient] Fix parsing SSE (fancyweb)
 * bug #57467 [SecurityBundle] Add `provider` XML attribute to the authenticators it’s missing from (MatTheCat)
 * bug #57447 [Notifier] [Lox24] Fix request body format to JSON string (alebedev80)
 * bug #57434 [FrameworkBundle] inject the missing logger service (xabbuh)
 * bug #57384 [Notifier] Fix thread key in GoogleChat bridge (romain-jacquart)
 * bug #57372 [HttpKernel][Security] Fix accessing session for stateless request (VincentLanglet)
 * bug #57112 [Messenger] Handle `AMQPConnectionException` when publishing a message (jwage)
 * bug #57341 [Serializer] properly handle invalid data for false/true types (xabbuh)
 * bug #57187 [Serializer] Fix `ObjectNormalizer` with property path (HypeMC)
 * bug #57355 [ErrorHandler] Fix rendered exception code highlighting on PHP 8.3 (tscni)
 * bug #57310 [DependencyInjection] Fix ternary in `AutowireCallable` attribute (alamirault)
 * bug #57405 [DoctrineBridge] fix handling of special "value" constraint option (xabbuh)
 * bug #57273 [FrameworkBundle] Fix setting default context for certain normalizers (HypeMC)
 * bug #57395 [Notifier]  send the recipient phone number as an array (xabbuh)
 * bug #57378 [Security] Change to `BadCredentialsException` when empty username / password (llupa)
 * bug #52699 [Serializer] [PropertyAccessor] Ignore non-collection interface generics (mtarld)
 * bug #54634 [String] Fix #54611 pluralization of -on ending words + singularization of -a ending foreign words (Geordie, DesLynx)
 * bug #57213 [Validator] [UniqueValidator] Use correct variable as parameter in (custom) error message (seho-nl, Sebastien Hoek)
 * bug #54920 [Messenger] Comply with Amazon SQS requirements for message body (VincentLanglet)
 * bug #57348 [Notifier][Brevo] change type from chatter to texter (xabbuh)
 * bug #57321 [AssetMapper] fix npm version constraint conversion (Jean-Beru)
 * bug #57320 [Serializer] avoid calling undefined built-in is_*() functions (xabbuh)

* 7.1.1 (2024-06-04)

 * bug #57110 [PhpUnitBridge] Fix error handler triggered outside of tests (HypeMC)
 * bug #57305 [Validator] do not modify a constraint during validation to not leak its context (xabbuh)
 * bug #57297 [FrameworkBundle] not registered definitions must not be modified (xabbuh)
 * bug #57234 [String] Fix Inflector for 'hardware' (podhy)
 * bug #57224 [Mime] Use streams instead of loading raw message generator into memory (bytestream)
 * bug #57284 [Mime] Fix TextPart using an unknown File (fabpot)
 * bug #57282 [Scheduler] Throw an exception when no dispatcher has been passed to a Schedule (fabpot)
 * bug #57276 Fix autoload configs to avoid warnings when building optimized autoloaders (Seldaek)
 * bug #57275 Fix autoload configs to avoid warnings when building optimized autoloaders (Seldaek)
 * bug #57263 [SecurityBundle] Fix `container.build_hash` parameter binding (alexandre-daubois)
 * bug #57197 [Serializer] Fix denormalizing a collection of union types (HypeMC)
 * bug #57188 [DoctrineBridge] Fix `UniqueEntityValidator` with proxy object (HypeMC)

* 7.1.0 (2024-05-31)

 * bug #57248 [DoctrineBridge] Revert deprecating by-{id} mapping of entities (nicolas-grekas)
 * bug #54572 [Mailer] Fix sendmail transport failure handling and interactive mode (bobvandevijver)
 * bug #57228 [Mime] fix PHP 7 compatibility (xabbuh)
 * bug #57065 [Mime] Fixed `Mime\Message::ensureValidity()` when a required header is set, but has an empty body (rhertogh)
 * bug #57069 [Config] gracefully handle cases when no resolver is set (xabbuh)
 * bug #57109 [Notifier] keep boolean options when their value is false (xabbuh)
 * bug #56848 [DoctrineBridge] Undeprecate DoctrineExtractor::getTypes() (derrabus)
 * bug #54971 [Serializer] Cache readability/writability computation (mtarld)
 * bug #54979 [Cache] Fix irrelevant deprecation when connecting to Couchbase (derrabus)
 * bug #56827 Fix CharsetValidator with string encoding (alamirault)
 * bug #54977 [DependencyInjection] Fix prepending strategy for php config loader (yceruto)
 * bug #56488 [VarExporter] Fix exporting default values involving global constants (kylekatarnls)

* 7.1.0-RC1 (2024-05-17)

 * bug #54970 [DependencyInjection] Process PHP configs using the ContainerConfigurator (MatTheCat)
 * bug #49186 [Serializer] Improve exception message in UnwrappingDenormalizer (andersonamuller)
 * bug #54694 [PropertyInfo] Update DoctrineExtractor for new DBAL 4 BIGINT type (llupa)
 * bug #54851 [Serializer] Fixed "Warning: Attempt to read property "value" on string" (michaljusiega, xabbuh)
 * bug #54913 [Serializer] Fix CurrentType for missing property (ElisDN)
 * feature #54941 Les-Tilleuls.coop is sponsoring Symfony 7.1, thanks to them! \o/ (nicolas-grekas)
 * bug #54797 [PhpUnitBridge] Fix `DeprecationErrorHandler` with PhpUnit 10 (HypeMC)
 * bug #54878 [Filesystem] Fix dumpFile `stat failed` error hitting custom handler (acoulton)
 * bug #54924 [Validator] IBAN Check digits should always between 2 and 98 (karstennilsen)
 * bug #54919 [ErrorHandler] Do not call xdebug_get_function_stack() with xdebug >= 3.0 when not in develop mode (fmata)
 * bug #54910 [HttpFoundation]  filter out empty HTTP header parts (xabbuh)
 * bug #54888 [String] Fix folded in compat mode (smnandre)
 * bug #54925 [VarDumper]  adapt namespace changes for new DOM extension classes (xabbuh)
 * bug #54835 [DoctrineBridge]  fix setting validated fields not using the options array (xabbuh)
 * bug #54863 [Process] Return `false` when `open_basedir` prevents access to `/dev/tty` (mjauvin)
 * bug #54908 [DependencyInjection] Fix "Cannot replace arguments" errors caused by ResolveAutowireInlineAttributesPass (nicolas-grekas)
 * bug #54860 [HttpClient] Revert fixing curl default options (alexandre-daubois)
 * feature #54859 [Messenger] Don't mark `EnvelopeAwareExceptionInterface` internal (valtzu)
 * bug #54850 [VarExporter] fix `ProxyHelper::generateLazyProxy()` when a method returns null (nikophil)
 * bug #54842 [Messenger] Don't drop stamps when message validation fails (valtzu)
 * bug #54838 [WebProfilerBundle] Fix assignment to constant variable (HypeMC)
 * bug #54837 [Mailer] [Sendgrid] Use `DataPart::getContentId()` when `DataPart::setContentId()` is used (SherinBloemendaal)
 * bug #54839 Fix exception thrown during `LDAP_MODIFY_BATCH_REMOVE_ALL` batch operations (phasdev)
 * bug #54834 [Validator] Check `Locale` class existence before using it (alexandre-daubois)
 * bug #54830 [HttpClient] Fix cURL default options for PHP 8.4 (alexandre-daubois)
 * bug #54828 [Serializer] Fix `GetSetMethodNormalizer` not working with setters with optional args (HypeMC)
 * bug #54816 [Cache] Fix support for predis/predis:^2.0 (mfettig)

* 7.1.0-BETA1 (2024-05-02)

 * feature #54818 [Translation] Crowdin is backing its translation bridge, thanks to them! \o/ (nicolas-grekas)
 * feature #54806 [HttpClient]  deprecate setLogger() methods of decorating clients (xabbuh)
 * feature #54809 JoliCode is sponsoring Symfony 7.1, thanks to them! \o/ (nicolas-grekas)
 * feature #54657 [TwigBundle] Deprecate `base_template_class` option (Steveb-p)
 * feature #54663 [Serializer] Add `XmlEncoder::CDATA_WRAPPING_PATTERN` context option (alexpozzi)
 * feature #54666 [DependencyInjection] Reset env vars when resetting the container (faizanakram99)
 * feature #54455 [DoctrineBridge] Deprecate auto-mapping of entities in favor of mapped route parameters (nicolas-grekas)
 * feature #52820 [DependencyInjection] Add `#[AutowireInline]` attribute to allow service definition at the class level (DaDeather, nicolas-grekas)
 * feature #54720 [Routing] Add `{foo:bar}` syntax to define a mapping between a route parameter and its corresponding request attribute (nicolas-grekas)
 * feature #38662 [DoctrineBridge][Validator] Allow validating every class against unique entity constraint (wkania)
 * feature #54371 [DependencyInjection] Deprecate `#[TaggedIterator]` and `#[TaggedLocator]` (GromNaN)
 * feature #54674 [FrameworkBundle] revert implementing LoggerAwareInterface in HTTP client decorators (xabbuh)
 * feature #54670 [TypeInfo] Ease getting base type on nullable types (mtarld)
 * feature #54789 [PropertyInfo] remove deprecations, mark TypeInfo as experimental (soyuka)
 * feature #54788 [TypeInfo] mark classes as experimental (soyuka)
 * feature #54661 [TypeInfo] Handle custom collection objects properly (mtarld)
 * feature #53214 [DoctrineBridge] Idle connection listener for long running runtime (alli83)
 * feature #49978 [HttpKernel] Introduce `#[MapUploadedFile]` controller argument attribute (renedelima)
 * feature #53365 [DoctrineBridge] Allow `EntityValueResolver` to return a list of entities (HypeMC)
 * feature #54525 [Mailer] [Resend] Add Resend webhook signature verification (welcoMattic)
 * feature #54589 [Messenger] forward a Clock instance to the created InMemoryTransport (xabbuh)
 * feature #54604 [Ldap] Improve error reporting during LDAP bind (RoSk0)
 * feature #54356 [Notifier] LOX24 SMS bridge (alebedev80)
 * feature #54473 [Validator] Add support for types (`ALL*`, `LOCAL_*`, `UNIVERSAL_*`, `UNICAST_*`, `MULTICAST_*`, `BROADCAST`) in `MacAddress` constraint (Ninos)
 * feature #53971 Cast env vars to null or bool when referencing them using `#[Autowire(env: '...')]` depending on the signature of the corresponding parameter (ruudk)
 * feature #54535 [Validator] Deprecate `Bic::INVALID_BANK_CODE_ERROR` (MatTheCat)
 * feature #54044 [Mailer] Add support for allowing some users even if `recipients` is defined in `EnvelopeListener` (lyrixx)
 * feature #54442 [Clock] Add a polyfill for DateTimeImmutable::createFromTimestamp() (derrabus)
 * feature #53801 [HttpKernel] Deprecate `AddAnnotatedClassesToCachePass` and related code infrastructure (nicolas-grekas)
 * feature #54510 [Console] Handle SIGQUIT signal (ostrolucky)
 * feature #54385 [HttpKernel] Map a list of items with `MapRequestPayload` attribute (yceruto)
 * feature #54432 [TwigBridge] Add `emojify` twig filter (lyrixx)
 * feature #54496 [Contracts] Rename ServiceSubscriberTrait to ServiceMethodsSubscriberTrait (nicolas-grekas)
 * feature #54443 [Security] Add support for dynamic CSRF id with Expression in `#[IsCsrfTokenValid]` (yguedidi)
 * feature #53968 [Process] allow to ignore signals when executing a process (joelwurtz)
 * feature #54346 [Serializer] Fix: Report Xml warning/error instead of silently returning a wrong xml (VincentLanglet)
 * feature #54423 [WebProfilerBundle] Update the search links in the profiler layout (javiereguiluz)
 * feature #52986 [HttpFoundation] Similar locale selection (Spomky)
 * feature #53160 [PropertyInfo] Deprecate PropertyInfo Type (mtarld)
 * feature #54408 [Validator] Add a `requireTld` option to `Url` constraint (javiereguiluz)
 * feature #54470 [Emoji] Add the "text" locale (nicolas-grekas)
 * feature #54414 [DependencyInjection] Improve the error message when there is no extension to load some configuration (javiereguiluz)
 * feature #54479 [Validator] set the password strength as a violation parameter (xabbuh)
 * feature #52843 [DependencyInjection] Prepending extension configs with file loaders (yceruto)
 * feature #53682 [Security] Support RSA algorithm signature for OIDC tokens (Spomky)
 * feature #54441 [Emoji] Add the gitlab locale (alamirault)
 * feature #54420 [WebProfilerBundle] Update main menu to display active panels first (javiereguiluz)
 * feature #54381 [Messenger] Allow extending attribute class `AsMessageHandler` (GromNaN)
 * feature #54364 [WebProfilerBundle] [WebProfilerPanel] Update the design of the workflow profiler panel (javiereguiluz)
 * feature #54365 [DependencyInjection] Apply attribute configurator to child classes (GromNaN)
 * feature #54320 [VarDumper] Add support for new DOM extension classes in `DOMCaster` (alexandre-daubois)
 * feature #54344 [Workflow] Add EventNameTrait to compute event name strings in subscribers (squrious)
 * feature #54347 [Console] Allow to return all tokens after the command name (lyrixx)
 * feature #54135 [Console] Add a way to use custom lock factory in lockableTrait (VincentLanglet)
 * feature #51502 [HttpKernel] Add temporary URI signed (BaptisteContreras)
 * feature #53898 [Serializer] Add context for `CamelCaseToSnakeCaseNameConverter` (AurelienPillevesse)
 * feature #49184 [FrameworkBundle][HttpFoundation] reduce response constraints verbosity (Nicolas Appriou, Nicals)
 * feature #53901 [Mailer] [Amazon] Add support for X-SES-LIST-MANAGEMENT-OPTIONS header (sebschaefer)
 * feature #54153 [HttpKernel] allow boolean argument support for MapQueryString (Jean-Beru)
 * feature #53885 [WebProfilerBundle] Allow to search inside profiler tables (javiereguiluz)
 * feature #52950 [WebProfilerBundle] Set `XDEBUG_IGNORE` option for all XHR (adrolter)
 * feature #54173 [Filesystem] Add the `readFile()` method (derrabus)
 * feature #54313 [Mime] Update mime types (smnandre)
 * feature #54016 [DependencyInjection] Add `#[AutowireMethodOf]` attribute to autowire a method of a service as a callable (nicolas-grekas)
 * feature #54272 [Workflow] Add support for workflows that need to store many tokens in the marking (lyrixx)
 * feature #54238 [Console] Add `ArgvInput::getRawTokens()` (lyrixx)
 * feature #51227 [FrameworkBundle][Workflow] Attach the workflow's configuration to the `workflow` tag (lyrixx)
 * feature #54107 [HttpKernel] Improve error reporting when requiring the wrong Request class (ilyachase)
 * feature #53851 [Security] Ignore empty username or password login attempts (llupa)
 * feature #54125 [AssetMapper] Deprecate unused method `splitPackageNameAndFilePath` (smnandre)
 * feature #54084 [Lock] Make NoLock implement the SharedLockInterface (mbabker)
 * feature #53892 [Messenger][AMQP] Automatically reconnect on connection loss (ostrolucky)
 * feature #53734 [Notifier] Add SMSense bridge (jimiero)
 * feature #53942 [Clock] Add get/setMicroseconds() (nicolas-grekas)
 * feature #53986 [Console] Add descriptions to Fish completion output (adriaanzon)
 * feature #53927 [Notifier] Add new Pushy notifier bridge (stloyd)
 * feature #53866 [Workflow] determines places from transitions (lyrixx)
 * feature #53868 [Config] Allow custom meta location in `ConfigCache` (alamirault)
 * feature #48603 [Messenger][Amqp] Add config option 'arguments' for delay queues (Thomas Beaujean)
 * feature #50745 [DependencyInjection] Add `CheckAliasValidityPass` to check interface compatibility (n-valverde)
 * feature #53806 [ExpressionLanguage] Add more configurability to the parsing/linting methods (fabpot)
 * feature #49144 [HttpFoundation] Add support for `\SplTempFileObject` in `BinaryFileResponse` (alexandre-daubois)
 * feature #53706 [Mailer] Add timestamp to SMTP debug log (bytestream)
 * feature #53747 [Yaml] Revert "feature #48022  Fix Yaml Parser with quote end in a newline (maxbeckers)" (xabbuh)
 * feature #50864 [TwigBridge] Allow `twig:lint` to excludes dirs (94noni)
 * feature #48022 [Yaml] Fix Yaml Parser with quote end in a new line (maxbeckers)
 * feature #48803 [CssSelector] add support for :is() and :where() (Jean-Beru)
 * feature #52510 [TypeInfo] Introduce component (mtarld)
 * feature #52043 [Config] Allow custom meta location in `ResourceCheckerConfigCache` (ruudk)
 * feature #51343 [HttpFoundation] Add `HeaderRequestMatcher` (alexandre-daubois)
 * feature #51324 [HttpFoundation] Add `QueryParameterRequestMatcher` (alexandre-daubois)
 * feature #51514 [Serializer] Add Default and "class name" default groups (mtarld)
 * feature #52658 [Validator] Add additional versions  (`*_NO_PUBLIC`, `*_ONLY_PRIV` & `*_ONLY_RES`) in IP address & CIDR constraint (Ninos)
 * feature #52230 [Yaml] Allow to get all the enum cases (phansys)
 * feature #48276 [Security] add CAS 2.0 AccessToken handler (nacorp)
 * feature #52922 [DependencyInjection] Add Lazy attribute for classes and arguments (Tiriel)
 * feature #53056 [Serializer] Add `DateTimeNormalizer::CAST_KEY` context option (norkunas)
 * feature #53096 [Intl] [Emoji] Move emoji data in a new component (smnandre)
 * feature #53362 [PropertyInfo] Restrict access to `PhpStanExtractor` based on visibility (nikophil)
 * feature #53550 [FrameworkBundle][HttpClient] Add `ThrottlingHttpClient` to limit requests within a timeframe (HypeMC)
 * feature #53466 Add `SecretsRevealCommand` (danielburger1337)
 * feature #53740 Mailersend webhook remote event (doobas, fabpot)
 * feature #53728 [ExpressionLanguage] Add ``min`` and ``max`` php functions (maxbeckers)
 * feature #51562 [DoctrineBridge] Add `message` to #[MapEntity] for NotFoundHttpException (moesoha)
 * feature #53680 [DependencyInjection][Yaml] dump enums with the !php/enum tag (xabbuh)
 * feature #53621 [Mailer] [Smtp] Add DSN param 'auto_tls' to disable automatic STARTTLS (srsbiz)
 * feature #53554 [Mailer] Add Resend bridge (welcoMattic)
 * feature #53448 [Cache] Add support for using DSN with `PDOAdapter` (HypeMC)
 * feature #52447 [Form] Add option `separator` to `ChoiceType` to use a custom separator after preferred choices (mboultoureau)
 * feature #53080 [Clock] Return Symfony ClockInterface in ClockSensitiveTrait (ruudk)
 * feature #53328 [Messenger] Add jitter parameter to MultiplierRetryStrategy (rmikalkenas)
 * feature #53382 [Uid] Add `AbstractUid::toString()` (fancyweb)
 * feature #53374 [Validator] support `\Stringable` instances in all constraints (xabbuh)
 * feature #53163 [Contracts][DependencyInjection] Add `ServiceCollectionInterface` (kbond)
 * feature #52638 [Dotenv] Add `SYMFONY_DOTENV_PATH`, consumed by `debug:dotenv` for custom `.env` path (GromNaN)
 * feature #51862 [Validator] Add `MacAddress` constraint for validating MAC address (Ninos)
 * feature #52924 [FrameworkBundle] add a private_ranges shortcut for trusted_proxies (xabbuh)
 * feature #53209 [HttpKernel] Add support for custom HTTP status code for the `#[MapQueryParameter]` attribute (ovidiuenache)
 * feature #53151 mark classes implementing the `WarmableInterface` as `final` (xabbuh)
 * feature #53262 [Notifier] [OneSignal] Add support for sending to external user ids (KDederichs)
 * feature #51884 [Form] add "model_type" option to MoneyType (garak)
 * feature #52936 [Notifier] Add Seven.io bridge (NeoBlack)
 * feature #53249 [Validator] support `Stringable` instances in `CharsetValidator` (xabbuh)
 * feature #53251 [AssetMapper] Add integrity hash to the default es-module-shims script (smnandre)
 * feature #52976 [Notifier] Add sms-sluzba.cz bridge (dfridrich)
 * feature #53154 [Validator] Add the `Charset` constraint (alexandre-daubois)
 * feature #53191 [HttpKernel] Allow `#[WithHttpStatus]` and `#[WithLogLevel]` to take effect on interfaces (priyadi)
 * feature #53212 [HttpKernel] Add `HttpException::fromStatusCode()` (nicolas-grekas)
 * feature #53060 [Uid] Add `UuidV1::toV6()`, `UuidV1::toV7()` and `UuidV6::toV7()` (fancyweb, nicolas-grekas)
 * feature #53148 [Notifier] Add Smsbox notifier bridge (Alan ZARLI)
 * feature #52954 [Validator] Add `list` and `associative_array` types to `Type` constraint (Florian Hermann)
 * feature #53091 [FrameworkBundle][RateLimiter] add `rate_limiter` tag to rate limiter services (kbond)
 * feature #53123 [VarDumper] Added default message for dd function (Shamimul Alam)
 * feature #52948 Use faster hashing algorithms when possible (javiereguiluz)
 * feature #52970 [HttpClient] Add `JsonMockResponse::fromFile()` and `MockResponse::fromFile()` shortcuts (fancyweb)
 * feature #52989 allow Twig 4 (xabbuh)
 * feature #53092 [Notifier] Add Unifonic notifier bridge (seferov)
 * feature #53083 [Notifier] Add Bluesky notifier bridge (Nyholm)
 * feature #52775 [HttpClient] Allow mocking `start_time` info in `MockResponse` (fancyweb)
 * feature #52962 [FrameworkBundle] Move Router cache directory to `kernel.build_dir` (Okhoshi)
 * feature #52974 [Cache] Deprecate `CouchbaseBucketAdapter`, use `CouchbaseCollectionAdapter` (alexandre-daubois)
 * feature #52971 [Messenger] Make `#[AsMessageHandler]` final (Valmonzo)
 * feature #52961 [Security][SecurityBundle] Add `#[IsCsrfTokenValid]` attribute (yguedidi)
 * feature #39438 [Form] Errors Property Paths mismatch CollectionType children when removing an entry (cristoforocervino)
 * feature #52842 [Mailer] Add Azure bridge (hafael)
 * feature #52946 [HttpClient] Add HttpOptions->addHeader as a shortcut to add an header in an existing options object (Dean151)
 * feature #52893 [Cache][Messenger]  make both options redis_sentinel and sentinel_master available everywhere (xabbuh)
 * feature #52854 [Workflow] Add `getEnabledTransition()` method annotation to WorkflowInterface (alexandre-daubois)
 * feature #52916 [Mailer] Dispatch event for Postmark's "inactive recipient" API error (vicdelfant)
 * feature #52879 [PropertyAccess][Serializer] Fix "type unknown" on denormalize (seferov)
 * feature #52411 [Messenger] Add `--all` option to `messenger:consume` (javaDeveloperKid)
 * feature #52493 [HttpFoundation] Add `UploadedFile::getClientOriginalPath()` to support directory uploads (danielburger1337)
 * feature #52632 [PropertyInfo] Make `PhpDocExtractor::getDocBlock()` public (Nyholm)
 * feature #52730 [Serializer] Consider SerializedPath in debug command output (jschaedl)
 * feature #52128 [HttpKernel] Introduce `ExceptionEvent::isKernelTerminating()` to skip error rendering when kernel is terminating (VincentLanglet)
 * feature #52636 [DependencyInjection] Prepend extension config with `ContainerConfigurator` (yceruto)
 * feature #52198 [String] New locale aware casing methods (bram123)
 * feature #52369 [DependencyInjection] Add `urlencode` function to `EnvVarProcessor` (crtl)
 * feature #50922 [Form] Deprecate not configuring the `default_protocol` option of the `UrlType` (MatTheCat)
 * feature #52605 [Console] Support `ProgressBar::iterate()` on empty array (GromNaN)

