CHANGELOG for 4.0.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 4.0 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v4.0.0...v4.0.1

* 4.0.11 (2018-05-25)

 * bug #27364 [DI] Fix bad exception on uninitialized references to non-shared services (nicolas-grekas)
 * bug #27359 [HttpFoundation] Fix perf issue during MimeTypeGuesser intialization (nicolas-grekas)
 * security #cve-2018-11408 [SecurityBundle] Fail if security.http_utils cannot be configured
 * security #cve-2018-11406 clear CSRF tokens when the user is logged out
 * security #cve-2018-11385 migrating session for UsernamePasswordJsonAuthenticationListener
 * security #cve-2018-11385 Adding session authentication strategy to Guard to avoid session fixation
 * security #cve-2018-11385 Adding session strategy to ALL listeners to avoid *any* possible fixation
 * security #cve-2018-11386 [HttpFoundation] Break infinite loop in PdoSessionHandler when MySQL is in loose mode
 * bug #27341 [WebProfilerBundle] Fixed validator/dump trace CSS (yceruto)
 * bug #27337  [FrameworkBundle] fix typo in CacheClearCommand (emilielorenzo)

* 4.0.10 (2018-05-21)

 * bug #27264 [Validator] Use strict type in URL validator (mimol91)
 * bug #27267 [DependencyInjection] resolve array env vars (jamesthomasonjr)
 * bug #26781 [Form] Fix precision of MoneyToLocalizedStringTransformer's divisions on transform() (syastrebov)
 * bug #27286 [Translation] Add Occitan plural rule (kylekatarnls)
 * bug #27271 [DI] Allow defining bindings on ChildDefinition (nicolas-grekas)
 * bug #27246 Disallow invalid characters in session.name (ostrolucky)
 * bug #27287 [PropertyInfo] fix resolving parent|self type hints (nicolas-grekas)
 * bug #27281 [HttpKernel] Fix dealing with self/parent in ArgumentMetadataFactory (fabpot)
 * bug #24805 [Security] Fix logout (MatTheCat)
 * bug #27265 [DI] Shared services should not be inlined in non-shared ones (nicolas-grekas)
 * bug #27141 [Process] Suppress warnings when open_basedir is non-empty (cbj4074)
 * bug #27250 [Session] limiting :key for GET_LOCK to 64 chars (oleg-andreyev)
 * bug #27237 [Debug] Fix populating error_get_last() for handled silent errors (nicolas-grekas)
 * bug #27232 [Cache][Lock] Fix usages of error_get_last() (nicolas-grekas)
 * bug #27236 [Filesystem] Fix usages of error_get_last() (nicolas-grekas)
 * bug #27191 [DI] Display previous error messages when throwing unused bindings (nicolas-grekas)
 * bug #27231 [FrameworkBundle] Fix cache:clear on vagrant (nicolas-grekas)
 * bug #27222 [WebProfilerBundle][Cache] Fix misses calculation when calling getItems (fsevestre)
 * bug #27227 [HttpKernel] Handle NoConfigurationException "onKernelException()" (nicolas-grekas)
 * bug #27152 [HttpFoundation] use brace-style regex delimiters (xabbuh)
 * bug #27158 [Cache] fix logic for fetching tag versions on TagAwareAdapter (dmaicher)
 * bug #27143 [Console] By default hide the short exception trace line from exception messages in Symfony's commands (yceruto)
 * bug #27133 [Doctrine Bridge] fix priority for doctrine event listeners (dmaicher)
 * bug #27135 [FrameworkBundle] Use the correct service id for CachePoolPruneCommand in its compiler pass (DemonTPx)
 * feature #24896 Add CODE_OF_CONDUCT.md (egircys)

* 4.0.9 (2018-04-30)

 * bug #27074 [Debug][WebProfilerBundle] Fix setting file link format (lyrixx, nicolas-grekas)
 * bug #27088 ResolveBindingsPass: Don't throw error for unused service, missing parent class (weaverryan)
 * bug #27086 [PHPUnitBridge] Add an implementation just for php 7.0 (greg0ire)
 * bug #26138 [HttpKernel] Catch HttpExceptions when templating is not installed (cilefen)
 * bug #27007 [Cache] TagAwareAdapterInterface::invalidateTags() should commit deferred items (nicolas-grekas)
 * bug #27067 [HttpFoundation] Fix setting session-related ini settings (e-moe)
 * bug #27061 [HttpKernel] Don't clean legacy containers that are still loaded (nicolas-grekas)
 * bug #27064 [VarDumper] Fix HtmlDumper classes match (ogizanagi)
 * bug #27016 [Security][Guard] GuardAuthenticationProvider::authenticate cannot return null (biomedia-thomas)
 * bug #26831 [Bridge/Doctrine] count(): Parameter must be an array or an object that implements Countable (gpenverne)
 * bug #27044 [Security] Skip user checks if not implementing UserInterface (chalasr)
 * bug #27025 [DI] Add check of internal type to ContainerBuilder::getReflectionClass (upyx)
 * bug #26994 [PhpUnitBridge] Add type hints (greg0ire)
 * bug #26014 [Security] Fixed being logged out on failed attempt in guard (iltar)
 * bug #25348 [HttpFoundation] Send cookies using header() to fix "SameSite" ones (nicolas-grekas, cvilleger)
 * bug #26910 Use new PHP7.2 functions in hasColorSupport (johnstevenson)
 * bug #26999 [VarDumper] Fix dumping of SplObjectStorage (corphi)
 * bug #25841 [DoctrineBridge] Fix bug when indexBy is meta key in PropertyInfo\DoctrineExtractor (insekticid)
 * bug #26983 [TwigBridge] [Bootstrap 4] Fix PercentType error rendering. (alexismarquis)
 * bug #26980 [TwigBundle] fix formatting arguments in plaintext format (xabbuh)
 * bug #26886 Don't assume that file binary exists on *nix OS (teohhanhui)
 * bug #26959 [Console] Fix PSR exception context key (scaytrase)
 * bug #26899 [Routing] Fix loading multiple class annotations for invokable classes (1ed)
 * bug #26643 Fix that ESI/SSI processing can turn a "private" response "public" (mpdude)
 * bug #26932 [Form] Fixed trimming choice values (HeahDude)
 * bug #26922 [TwigBundle] fix rendering exception stack traces (xabbuh)
 * bug #26773 [HttpKernel] Make ServiceValueResolver work if controller namespace starts with a backslash in routing (mathieutu)
 * bug #26870 Add d-block to bootstrap 4 alerts (Normunds)
 * bug #26857 [HttpKernel] Dont create mock cookie for new sessions in tests (nicolas-grekas)
 * bug #26875 [Console] Don't go past exact matches when autocompleting (nicolas-grekas)
 * bug #26823 [Validator] Fix LazyLoadingMetadataFactory with PSR6Cache for non classname if tested values isn't existing class (Pascal Montoya, pmontoya)
 * bug #26834 [Yaml] Throw parse error on unfinished inline map (nicolas-grekas)

* 4.0.8 (2018-04-06)

 * bug #26802 [Security] register custom providers on ExpressionLanguage directly (dmaicher)
 * bug #26794 [PhpUnitBridge] Catch deprecation error handler (cvilleger)
 * bug #26788 [Security] Load the user before pre/post auth checks when needed (chalasr)
 * bug #26792 [Routing] Fix throwing NoConfigurationException instead of 405 (nicolas-grekas)
 * bug #26774 [SecurityBundle] Add missing argument to security.authentication.provider.simple (i3or1s, chalasr)
 * bug #26763 [Finder] Remove duplicate slashes in filenames (helhum)
 * bug #26758 [WebProfilerBundle][HttpKernel] Make FileLinkFormatter URL format generation lazy (nicolas-grekas)

* 4.0.7 (2018-04-03)

 * bug #26387 [Yaml] Fix regression when trying to parse multiline (antograssiot)
 * bug #26749 Add PHPDbg support to HTTP components (hkdobrev)
 * bug #26609 [Console] Fix check of color support on Windows (mlocati)
 * bug #26727 [HttpCache] Unlink tmp file on error (Chansig)
 * bug #26675 [HttpKernel] DumpDataCollector: do not flush when a dumper is provided (ogizanagi)
 * bug #26663 [TwigBridge] Fix rendering of currency by MoneyType (ro0NL)
 * bug #26595 [DI] Do not suggest writing an implementation when multiple exist (chalasr)
 * bug #26662 [DI] Fix hardcoded cache dir for warmups (nicolas-grekas)
 * bug #26677 Support phpdbg SAPI in Debug::enable() (hkdobrev)
 * bug #26600 [Routing] Fixed the importing of files using glob patterns that match multiple resources (skalpa)
 * bug #26589 [Ldap] cast to string when checking empty passwords (ismail1432)
 * bug #26626 [WebProfilerBundle] use the router to resolve file links (nicolas-grekas)
 * bug #26634 [DI] Cleanup remainings from autoregistration (nicolas-grekas)
 * bug #26635 [DI] Dont tell about autoregistration in strict autowiring mode (nicolas-grekas)
 * bug #26621 [Form] no type errors with invalid submitted data types (xabbuh)
 * bug #26612 [PHPunit] suite variable should be used (prisis)
 * bug #26337 [Finder] Fixed leading/trailing / in filename (lyrixx)
 * bug #26584 [TwigBridge] allow html5 compatible rendering of forms with null names (systemist)
 * bug #24401 [Form] Change datetime to datetime-local for HTML5 datetime input (pierredup)
 * bug #26513 [FrameworkBundle] Respect debug mode when warm up annotations (Strate)
 * bug #26370 [Security] added userChecker to SimpleAuthenticationProvider (i3or1s)
 * bug #26569 [BrowserKit] Fix cookie path handling when $domain is null (dunglas)
 * bug #26273 [Security][Profiler] Display the original expression in 'Access decision log' (lyrixx)
 * bug #26427 [DependencyInjection] fix regression when extending the Container class without a constructor (lsmith77)
 * bug #26562 [Bridge\PhpUnit] Cannot autoload class "\Symfony\Bridge\PhpUnit\SymfonyTestsListener" (Jake Bishop)
 * bug #26598 Fixes #26563 (open_basedir restriction in effect) (temperatur)
 * bug #26568 [Debug] Reset previous exception handler earlier to prevent infinite loop (nicolas-grekas)
 * bug #26590 Make sure form errors is valid HTML (Nyholm)
 * bug #26567 [DoctrineBridge] Don't rely on ClassMetadataInfo->hasField in DoctrineOrmTypeGuesser anymore (fancyweb)
 * feature #26408 Readd 'form_label_errors' block to disable errors on form labels (birkof)
 * bug #26591 [TwigBridge] Make sure we always render errors. Eventhough labels are disabled (Nyholm)
 * bug #26356 [FrameworkBundle] HttpCache is not longer abstract (lyrixx)
 * bug #26548 [DomCrawler] Change bad wording in ChoiceFormField::untick (dunglas)
 * bug #26482 [PhpUnitBridge] Ability to use different composer.json file (amcastror)
 * bug #26443 [Fix][HttpFoundation] Fix the updating of timestamp in the MemcachedSessionHandler (Alessandro Loffredo)
 * bug #26400 [Config] ReflectionClassResource check abstract class (andrey1s)
 * bug #26433 [DomCrawler] extract(): fix a bug when the attribute list is empty (dunglas)
 * bug #26041 Display the Welcome Page when there is no homepage defined (javiereguiluz)
 * bug #26452 [Intl] Load locale aliases to support alias fallbacks (jakzal)
 * bug #26450 [CssSelector] Fix CSS identifiers parsing - they can start with dash (jakubkulhan)

* 4.0.6 (2018-03-05)

 * bug #26393  [DI] Skip resource tracking if disabled (chalasr)
 * bug #26403 fix the handling of timestamp in the MongoDBSessionHandler (hjanuschka)
 * bug #26355 [DI] Fix missing "id" normalization when dumping the container (nicolas-grekas)
 * bug #26368 [WebProfilerBundle] Fix Debug toolbar breaks app (xkobal)
 * bug #26369 Use fill instead of style for svg colors (rpkamp)
 * bug #26358 [FrameworkBundle] Silence "Failed to remove directory" on cache:clear (nicolas-grekas)

* 4.0.5 (2018-03-01)

 * bug #26327 [Form][WCAG] Errors sign for people that do not see colors (Nyholm)
 * bug #26326 [Form][WCAG] Added role="presentation" on tables & removed bootstrap4 table (Nyholm)
 * bug #26325 [Form][WCAG] Add hidden labels on date and time fields (Nyholm)
 * bug #26338 [Debug] Keep previous errors of Error instances (Philipp91)
 * bug #26328 [Form][WCAG] Fixed HTML errors (Nyholm)
 * bug #26290 [FrameworkBundle] [Console][DX] add a warning when command is not found (Simperfit)
 * bug #26318 [Routing] Fix GC control of PHP-DSL (nicolas-grekas)
 * bug #26312 [Routing] Don't throw 405 when scheme requirement doesn't match (nicolas-grekas)
 * bug #26275 Set controller without __invoke method from invokable class (Tobion)
 * bug #26298 Fix ArrayInput::toString() for InputArgument::IS_ARRAY args (maximium)
 * bug #26177 Update excluded_ajax_paths for sf4 (jenaye)
 * bug #26289 [Security] Add missing use of Role (tony-tran)
 * bug #26286 [Security] Add missing use for RoleInterface (tony-tran)
 * bug #26265 [PropertyInfo] throw exception if docblock factory does not exist (xabbuh)
 * bug #26247 [Translation] Process multiple segments within a single unit. (timewasted)
 * bug #26254 fix custom radios/inputs for checkbox/radio type (mssimi)
 * bug #26234 [FrameworkBundle] Add missing XML config for circular_reference_handler (dunglas)
 * bug #26236 [PropertyInfo] ReflectionExtractor: give a chance to other extractors if no properties (dunglas)
 * bug #26227 Add support for URL-like DSNs for the PdoSessionHandler (stof)
 * bug #25557 [WebProfilerBundle] add a way to limit ajax request (Simperfit)
 * bug #26088 [FrameworkBundle] Fix using annotation_reader in compiler pass to inject configured cache provider (Laizerox)
 * bug #26157 [HttpKernel] Send new session cookie from AbstractTestSessionListener after session invalidation (rpkamp)
 * bug #26230 [WebProfilerBundle] Fix anchor CSS (ro0NL)
 * bug #26228 [HttpFoundation] Fix missing "throw" in JsonResponse (nicolas-grekas)
 * bug #26211 [Console] Suppress warning from sapi_windows_vt100_support (adawolfa)
 * bug #26176 Retro-fit proxy code to make it deterministic for older proxy manager implementations (lstrojny)
 * bug #25787 Yaml parser regression with comments and non-strings (alexpott)
 * bug #26156 Fixes #26136: Avoid emitting warning in hasParameterOption() (greg-1-anderson)
 * bug #26183 [DI] Add null check for removeChild (changmin.keum)
 * bug #26167 [TwigBridge] Apply some changes to support Bootstrap4-stable (mpiot, Nyholm)
 * bug #26173 [Security] fix accessing request values (xabbuh)
 * bug #26089 [PhpUnitBridge] Added support for PHPUnit 7 in Coverage Listener (lyrixx)
 * bug #26170 [PHPUnit bridge] Avoid running the remove command without any packages (stof)
 * bug #26159 created validator.tl.xlf for Form/Translations (ergiegonzaga)
 * bug #26100 [Routing] Throw 405 instead of 404 when redirect is not possible (nicolas-grekas)
 * bug #26119 [TwigBundle][WebProfilerBundle] Fix JS collision (ro0NL)
 * bug #26040 [Process] Check PHP_BINDIR before $PATH in PhpExecutableFinder (nicolas-grekas)
 * bug #26067 [YAML] Issue #26065: leading spaces in YAML multi-line string literals (tamc)
 * bug #26012 Exit as late as possible (greg0ire)
 * bug #26082 [Cache][WebProfiler] fix collecting cache stats with sub-requests + allow clearing calls (dmaicher)
 * bug #26024 [PhpBridge] add PHPUnit 7 support to SymfonyTestsListener (shieldo)
 * bug #26020 [Lock] Log already-locked errors as "notice" instead of "warning" (Simperfit)
 * bug #26043 [Serialized] add context to serialize and deserialize (andrey1s)
 * bug #26127 Deterministic time in cache items for reproducible builds (lstrojny)
 * bug #26128 Make kernel build time optionally deterministic (lstrojny)
 * bug #26117 isCsrfTokenValid() replace string  by ?string (GaylordP)
 * bug #26112 Env var maps to undefined constant. (dsmink)
 * bug #26111 [Security] fix merge of 2.7 into 2.8 + add test case (dmaicher)
 * bug #25893 [Console] Fix hasParameterOption / getParameterOption when used with multiple flags (greg-1-anderson)
 * bug #25756 [TwigBundle] Register TwigBridge extensions first (fancyweb)
 * bug #26051 [WebProfilerBundle] Fix sub request link (ro0NL)
 * bug #25947 PhpDocExtractor::getTypes() throws fatal error when type omitted (Jared Farrish)
 * bug #25940 [Form] keep the context when validating forms (xabbuh)
 * bug #26057 [SecurityBundle] use libsodium to run Argon2i related tests (xabbuh)
 * bug #25373 Use the PCRE_DOLLAR_ENDONLY modifier in route regexes (mpdude)
 * bug #24435 [Form] Make sure errors are a part of the label on bootstrap 4 - this is a requirement for WCAG2 (Nyholm)
 * bug #25762 [DependencyInjection] always call the parent class' constructor (xabbuh)
 * bug #25976 [Config] Handle Service/EventSubscriberInterface in ReflectionClassResource (nicolas-grekas)
 * bug #25989 [DI][Routing] Fix tracking of globbed resources (nicolas-grekas, sroze)
 * bug #26009 [SecurityBundle] Allow remember-me factory creation when multiple user providers are configured. (iisisrael)
 * bug #26010 [CssSelector] For AND operator, the left operand should have parentheses, not only right operand (Arnaud CHASSEUX)
 * bug #26000 Fixed issue #25985 (KevinFrantz)
 * bug #25996 Don't show wanna-be-private services as public in debug:container (chalasr)
 * bug #25914 [HttpKernel] collect extension information as late as possible (xabbuh)
 * bug #25981 [DI] Fix tracking of source class changes for lazy-proxies (nicolas-grekas)
 * bug #25971 [Debug] Fix bad registration of exception handler, leading to mem leak (nicolas-grekas)
 * bug #25962 [Routing] Fix trailing slash redirection for non-safe verbs (nicolas-grekas)
 * bug #25948 [Form] Fixed empty data on expanded ChoiceType and FileType (HeahDude)
 * bug #25978 Deterministic proxy names (lstrojny)
 * bug #25972 support sapi_windows_vt100_support for php 7.2+ (jhdxr)
 * bug #25744 [TwigBridge] Allow label translation to be safe (MatTheCat)
 * bug #25932 Don't stop PSR-4 service discovery if a parent class is missing (derrabus)

* 4.0.4 (2018-01-29)

 * bug #25922 [HttpFoundation] Use the correct syntax for session gc based on Pdo driver (tanasecosminromeo)
 * bug #25933 Disable CSP header on exception pages only in debug (ostrolucky)
 * bug #25926 [Form] Fixed Button::setParent() when already submitted (HeahDude)
 * bug #25927 [Form] Fixed submitting disabled buttons (HeahDude)
 * bug #25397 [Console] Provide a DX where an array could be passed (Simperfit)
 * bug #25858 [DI] Fix initialization of legacy containers by delaying include_once (nicolas-grekas)
 * bug #25891 [DependencyInjection] allow null values for root nodes in YAML configs (xabbuh)
 * bug #24864 Have weak_vendors ignore deprecations from outside (greg0ire)
 * bug #25873 [Console] Fix using finally where the catch can also fail (nicolas-grekas)
 * bug #25848 [Validator] add missing parent isset and add test (Simperfit)
 * bug #25869 [Process] Skip environment variables with false value in Process (francoispluchino)
 * bug #25864 [Yaml] don't split lines on carriage returns when dumping (xabbuh)
 * bug #25863 [Yaml] trim spaces from unquoted scalar values (xabbuh)
 * bug #25861 do not conflict with egulias/email-validator 2.0+ (xabbuh)
 * bug #25851 [Validator] Conflict with egulias/email-validator 2.0 (emodric)
 * bug #25837 [SecurityBundle] Don't register in memory users as services (chalasr)
 * bug #25835 [HttpKernel] DebugHandlersListener should always replace the existing exception handler (nicolas-grekas)
 * bug #25829 [Debug] Always decorate existing exception handlers to deal with fatal errors (nicolas-grekas)
 * bug #25823 [Security] Notify that symfony/expression-language is not installed if ExpressionLanguage is used (giovannialbero1992)
 * bug #25824 Fixing a bug where the dump() function depended on bundle ordering (weaverryan)
 * bug #25763 [OptionsResolver] Fix options resolver with array allowed types (mcg-web)
 * bug #25789  Enableable ArrayNodeDefinition is disabled for empty configuration (kejwmen)
 * bug #25822 [Cache] Fix handling of apcu_fetch() edgy behavior (nicolas-grekas)
 * bug #25816 Problem in phar see mergerequest #25579 (betzholz)
 * bug #25781 [Form] Disallow transform dates beyond the year 9999 (curry684)
 * bug #25287 [Serializer] DateTimeNormalizer handling of null and empty values (returning it instead of new object) (Simperfit)
 * bug #25249 [Form] Avoid button label translation when it's set to false (TeLiXj)
 * bug #25127 [TwigBridge] Pass the form-check-inline in parent (Simperfit)
 * bug #25812 Copied NO language files to the new NB locale (derrabus)
 * bug #25753 [Console] Fix restoring exception handler (nicolas-grekas, fancyweb)
 * bug #25801 [Router] Skip anonymous classes when loading annotated routes (pierredup)
 * bug #25508 [FrameworkBundle] Auto-enable CSRF if the component *+ session* are loaded (nicolas-grekas)
 * bug #25657 [Security] Fix fatal error on non string username (chalasr)
 * bug #25791 [Routing] Make sure we only build routes once (sroze)
 * bug #25799 Fixed Request::__toString ignoring cookies (Toflar)
 * bug #25755 [Debug] prevent infinite loop with faulty exception handlers (nicolas-grekas)
 * bug #25771 [Validator] 19 digits VISA card numbers are valid (xabbuh)
 * bug #25751 [FrameworkBundle] Add the missing `enabled` session attribute (sroze)
 * bug #25750 [HttpKernel] Turn bad hosts into 400 instead of 500 (nicolas-grekas)
 * bug #25699 [HttpKernel] Fix session handling: decouple "save" from setting response "private" (nicolas-grekas)
 * bug #25490 [Serializer] Fixed throwing exception with option JSON_PARTIAL_OUTPUT_ON_ERROR (diversantvlz)
 * bug #25737 [TwigBridge] swap filter/function and package names (xabbuh)
 * bug #25731 [HttpFoundation] Always call proxied handler::destroy() in StrictSessionHandler (nicolas-grekas)
 * bug #25733 [HttpKernel] Fix compile error when a legacy container is fresh again (nicolas-grekas)
 * bug #25709 Tweaked some styles in the profiler tables (javiereguiluz)
 * bug #25719 [HttpKernel] Uses cookies to track the requests redirection (sroze)
 * bug #25696 [FrameworkBundle] Fix using "annotations.cached_reader" in after-removing passes (nicolas-grekas)
 * feature #25669 [Security] Fail gracefully if the security token cannot be unserialized from the session (thewilkybarkid)
 * bug #25700 Run simple-phpunit with --no-suggest option (ro0NL)

* 4.0.3 (2018-01-05)

 * bug #25685 Use triggering file to determine weak vendors if when the test is run in a separate process (alexpott)
 * bug #25671 Remove randomness from dumped containers (nicolas-grekas)
 * bug #25532 [HttpKernel] Disable CSP header on exception pages (ostrolucky)
 * bug #25678 [WebProfilerBundle] set the var in the right scope (Jochen Mandl)
 * bug #25491 [Routing] Use the default host even if context is empty (sroze)
 * bug #25672 [WebServerBundle] use interface_exists instead of class_exists (kbond)
 * bug #25662 Dumper shouldn't use html format for phpdbg / cli-server (jhoff)
 * bug #25529 [Validator] Fix access to root object when using composite constraint (ostrolucky)
 * bug #25404 [Form] Remove group options without data on debug:form command (yceruto)
 * bug #25430 Fixes for Oracle in PdoSessionHandler (elislenio)
 * bug #25117 [FrameworkBundle] Make cache:clear "atomic" and consistent with cache:warmup (hkdobrev)
 * bug #25583 [HttpKernel] Call Response->setPrivate() instead of sending raw header() when session is started (Toflar)
 * bug #25601 [TwigBundle/Brige] catch missing requirements to throw meaningful exceptions (nicolas-grekas)
 * bug #25547 [DX][DependencyInjection] Suggest to write an implementation if the interface cannot be autowired (sroze)
 * bug #25599 Add application/ld+json format associated to json (vincentchalamon)
 * bug #25623 [HttpFoundation] Fix false-positive ConflictingHeadersException (nicolas-grekas)
 * bug #25624 [WebServerBundle] Fix escaping of php binary with arguments (nicolas-grekas)
 * bug #25604 Add check for SecurityBundle in createAccessDeniedException (FGM)
 * bug #25591 [HttpKernel] fix cleaning legacy containers (nicolas-grekas)
 * bug #25526 [WebProfilerBundle] Fix panel break when stopwatch component is not installed. (umulmrum, javiereguiluz)
 * bug #25606 Updating message to inform the user how to install the component (weaverryan)
 * bug #25571 [SecurityBundle] allow auto_wire for SessionAuthenticationStrategy class (xavren)
 * bug #25567 [Process] Fix setting empty env vars (nicolas-grekas)
 * bug #25407 [Console] Commands with an alias should not be recognized as ambiguous (Simperfit)
 * bug #25523 [WebServerBundle] fix a bug where require would not require the good file because of env (Simperfit)
 * bug #25559 [Process] Dont use getenv(), it returns arrays and can introduce subtle breaks accros PHP versions (nicolas-grekas)
 * bug #25552 [WebProfilerBundle] Let fetch() cast URL to string (ro0NL)
 * bug #25521 [Console] fix a bug when you are passing a default value and passing -n would output the index (Simperfit)

* 4.0.2 (2017-12-15)

 * bug #25489 [FrameworkBundle] remove esi/ssi renderers if inactive (dmaicher)
 * bug #25502 Fixing wrong class_exists on interface (weaverryan)
 * bug #25427 Preserve percent-encoding in URLs when performing redirects in the UrlMatcher (mpdude)
 * bug #25480 [FrameworkBundle] add missing validation options to XSD file (xabbuh)
 * bug #25487 [Console] Fix a bug when passing a letter that could be an alias (Simperfit)
 * bug #25425 When available use AnnotationRegistry::registerUniqueLoader (jrjohnson)
 * bug #25474 [DI] Optimize Container::get() for perf (nicolas-grekas)
 * bug #24594 [Translation] Fix InvalidArgumentException when using untranslated plural forms from .po files (BjornTwachtmann)
 * bug #25233 [TwigBridge][Form] Fix hidden currency element with Bootstrap 3 theme (julienfalque)
 * bug #25413 [HttpKernel] detect deprecations thrown by container initialization during tests (nicolas-grekas)
 * bug #25408 [Debug] Fix catching fatal errors in case of nested error handlers (nicolas-grekas)
 * bug #25330 [HttpFoundation] Support 0 bit netmask in IPv6 (`::/0`) (stephank)
 * bug #25378 [VarDumper] Fixed file links leave blank pages when ide is configured (antalaron)
 * bug #25410 [HttpKernel] Fix logging of post-terminate errors/exceptions (nicolas-grekas)
 * bug #25409 [Bridge/Doctrine] Drop "memcache" type (nicolas-grekas)
 * bug #25417 [Process] Dont rely on putenv(), it fails on ZTS PHP (nicolas-grekas)
 * bug #25333 [DI] Impossible to set an environment variable and then an array as container parameter (Phantas0s)
 * bug #25447 [Process] remove false-positive BC breaking exception on Windows (nicolas-grekas)
 * bug #25381 [DI] Add context to service-not-found exceptions thrown by service locators (nicolas-grekas)
 * bug #25438 [Yaml] empty lines don't count for indent detection (xabbuh)
 * bug #25412 Extend Argon2i support check to account for sodium_compat (mbabker)
 * bug #25392 [HttpFoundation] Fixed default user-agent (3.X -> 4.X) (lyrixx)
 * bug #25389 [Yaml] fix some edge cases with indented blocks (xabbuh)
 * bug #25396 [Form] Fix debug:form command definition (yceruto)
 * bug #25398 [HttpFoundation] don't prefix cookies with "Set-Cookie:" (pableu)
 * bug #25354 [DI] Fix non-string class handling in PhpDumper (nicolas-grekas, sroze)
 * bug #25340 [Serializer] Unset attributes when creating child context (dunglas)
 * bug #25325 [Yaml] do not evaluate PHP constant names (xabbuh)
 * bug #25380 [FrameworkBundle][Cache] register system cache clearer only if it's used (xabbuh)
 * bug #25323 [ExpressionLanguage] throw an SyntaxError instead of an undefined index notice (Simperfit)
 * bug #25363 [HttpKernel] Disable inlining on PHP 5 (nicolas-grekas)
 * bug #25364 [DependencyInjection] Prevent a loop in aliases within the `findDefinition` method (sroze)
 * bug #25337 Remove Exclusive Lock That Breaks NFS Caching (brianfreytag)

* 4.0.1 (2017-12-05)

 * bug #25304 [Bridge/PhpUnit] Prefer $_SERVER['argv'] over $argv (ricknox)
 * bug #25272 [SecurityBundle] fix setLogoutOnUserChange calls for context listeners (dmaicher)
 * bug #25282 [DI] Register singly-implemented interfaces when doing PSR-4 discovery (nicolas-grekas)
 * bug #25274 [Security] Adding a GuardAuthenticatorHandler alias (weaverryan)
 * bug #25308 [FrameworkBundle] Fix a bug where a color tag will be shown when passing an antislash (Simperfit)
 * bug #25278 Fix for missing whitespace control modifier in form layout (kubawerlos)
 * bug #25306 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25305 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25236 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25312 [DI] Fix deep-inlining of non-shared refs (nicolas-grekas)
 * bug #25309 [Yaml] parse newlines in quoted multiline strings (xabbuh)
 * bug #25313 [DI] Fix missing unset leading to false-positive circular ref (nicolas-grekas)
 * bug #25268 [DI] turn $private to protected in dumped container, to make cache:clear BC (nicolas-grekas)
 * bug #25285 [DI] Throw an exception if Expression Language is not installed (sroze)
 * bug #25241 [Yaml] do not eagerly filter comment lines (xabbuh)
 * bug #25284 [DI] Cast ids to string, as done on 3.4 (nicolas-grekas, sroze)
 * bug #25297 [Validator] Fixed the @Valid(groups={"group"}) against null exception case (vudaltsov)
 * bug #25255 [Console][DI] Fail gracefully (nicolas-grekas)
 * bug #25264 [DI] Trigger deprecation when setting a to-be-private synthetic service (nicolas-grekas)
 * bug #25258 [link] Prevent warnings when running link with 2.7 (dunglas)
 * bug #25244 [DI] Add missing deprecation when fetching private services from ContainerBuilder (nicolas-grekas)
 * bug #24750 [Validator] ExpressionValidator should use OBJECT_TO_STRING  (Simperfit)
 * bug #25247 [DI] Fix false-positive circular exception (nicolas-grekas)
 * bug #25226 [HttpKernel] Fix issue when resetting DumpDataCollector (Pierstoval)
 * bug #25230 Use a more specific file for detecting the bridge (greg0ire)
 * bug #25232 [WebProfilerBundle] [TwigBundle] Fix Profiler breaking XHTML pages (tistre)

* 4.0.0 (2017-11-30)

 * bug #25220 [HttpFoundation] Add Session::isEmpty(), fix MockFileSessionStorage to behave like the native one (nicolas-grekas)
 * bug #25209 [VarDumper] Dont use empty(), it chokes on eg GMP objects (nicolas-grekas)
 * bug #25200 [HttpKernel] Arrays with scalar values passed to ESI fragment renderer throw deprecation notice (Simperfit)
 * bug #25201 [HttpKernel] Add a better error messages when passing a private or non-tagged controller (Simperfit)
 * bug #25155 [DependencyInjection] Detect case mismatch in autowiring (Simperfit, sroze)
 * bug #25217 [Dotenv] Changed preg_match flags from null to 0 (deekthesqueak)
 * bug #25180 [DI] Fix circular reference when using setters (nicolas-grekas)
 * bug #25204 [DI] Clear service reference graph (nicolas-grekas)
 * bug #25203 [DI] Fix infinite loop in InlineServiceDefinitionsPass (nicolas-grekas)
 * bug #25185 [Serializer] Do not cache attributes if `attributes` in context (sroze)
 * bug #25190 [HttpKernel] Keep legacy container files for concurrent requests (nicolas-grekas)
 * bug #25182 [HttpFoundation] AutExpireFlashBag should not clear new flashes (Simperfit, sroze)
 * bug #25174 [Translation] modify definitions only if the do exist (xabbuh)
 * bug #25179 [FrameworkBundle][Serializer] Remove YamlEncoder definition if Yaml component isn't installed (ogizanagi)
 * bug #25160 [DI] Prevent a ReflectionException during cache:clear when the parent class doesn't exist (dunglas)
 * bug #25163 [DI] Fix tracking of env vars in exceptions (nicolas-grekas)
 * bug #25162 [HttpKernel] Read $_ENV when checking SHELL_VERBOSITY (nicolas-grekas)
 * bug #25158 [DI] Remove unreachable code (GawainLynch)
 * bug #25152 [Form] Don't rely on `Symfony\Component\HttpFoundation\File\File` if http-foundation isn't in FileType (issei-m)
 * bug #24987 [Console] Fix global console flag when used in chain (Simperfit)
 * bug #25137 Adding checks for the expression language (weaverryan)
 * bug #25151 [FrameworkBundle] Automatically enable the CSRF protection if CSRF manager exists (sroze)
 * bug #25043 [Yaml] added ability for substitute aliases when mapping is on single line (Michał Strzelecki, xabbuh)

* 4.0.0-RC2 (2017-11-24)

 * bug #25146 [DI] Dont resolve envs in service ids (nicolas-grekas)
 * bug #25113 [Routing] Fix "config-file-relative" annotation loader resources (nicolas-grekas, sroze)
 * bug #25065 [FrameworkBundle] Update translation commands to work with default paths (yceruto)
 * bug #25109 Make debug:container search command case-insensitive (jzawadzki)
 * bug #25121 [FrameworkBundle] Fix AssetsInstallCommand (nicolas-grekas)
 * bug #25102 [Form] Fixed ContextErrorException in FileType (chihiro-adachi)
 * bug #25130 [DI] Fix handling of inlined definitions by ContainerBuilder (nicolas-grekas)
 * bug #25119 [DI] Fix infinite loop when analyzing references (nicolas-grekas)
 * bug #25094 [FrameworkBundle][DX] Display a nice error message if an enabled component is missing (derrabus)
 * bug #25100 [SecurityBundle] providerIds is undefined error when firewall provider is not specified (karser)
 * bug #25100 [SecurityBundle] providerIds is undefined error when firewall provider is not specified (karser)
 * bug #25100 [SecurityBundle] providerIds is undefined error when firewall provider is not specified (karser)
 * bug #25097 [Bridge\PhpUnit] Turn "preserveGlobalState" to false by default, revert "Blacklist" removal (nicolas-grekas)

* 4.0.0-RC1 (2017-11-21)

 * bug #25077 [Bridge/Twig] Let getFlashes starts the session (MatTheCat)
 * bug #25082 [HttpKernel] Disable container inlining when legacy inlining has been used (nicolas-grekas)
 * bug #25022 [Filesystem] Updated Filesystem::makePathRelative (inso)
 * bug #25072 [Bridge/PhpUnit] Remove trailing "\n" from ClockMock::microtime(false) (joky)
 * bug #25069 [Debug] Fix undefined variable $lightTrace (nicolas-grekas)
 * bug #25053 [Serializer] Fixing PropertyNormalizer supports parent properties (Christopher Hertel)
 * bug #25055 [DI] Analyze setter-circular deps more precisely (nicolas-grekas)
 * feature #25056 [Bridge/PhpUnit] Sync the bridge version installed in vendor/ and in phpunit clone (nicolas-grekas)
 * bug #25048 Allow EnumNode name to be null (MatTheCat)
 * bug #25045 [SecurityBundle] Don't trigger auto-picking notice if provider is set per listener (chalasr)
 * bug #25033 [FrameworkBundle] Dont create empty bundles directory by default (ro0NL)
 * bug #25037 [DI] Skip hot_path tag for deprecated services as their class might also be (nicolas-grekas)
 * bug #25038 [Cache] Memcached options should ignore "lazy" (nicolas-grekas)
 * bug #25014 Move deprecation under use statements (greg0ire)
 * bug #25030 [Console] Fix ability to disable lazy commands (chalasr)
 * bug #25032 [Bridge\PhpUnit] Disable broken auto-require mechanism of phpunit (nicolas-grekas)
 * bug #25016 [HttpKernel] add type-hint for the requestType (Simperfit)
 * bug #25027 [FrameworkBundle] Hide server:log command based on deps (sroze)
 * bug #24991 [DependencyInjection] Single typed argument can be applied on multiple parameters (nicolas-grekas, sroze)
 * bug #24983 [Validator] enter the context in which to validate (xabbuh)
 * bug #24956 Fix ambiguous pattern (weltling)
 * bug #24732 [DependencyInjection] Prevent service:method factory notation in PHP config (vudaltsov)
 * bug #24979 [HttpKernel] remove services resetter even when it's an alias (xabbuh)
 * bug #24972 [HttpKernel] Fix service arg resolver for controllers as array callables (sroze, nicolas-grekas)
 * bug #24971 [FrameworkBundle] Empty event dispatcher earlier in CacheClearCommand (nicolas-grekas)
 * security #24995 Validate redirect targets using the session cookie domain (nicolas-grekas)
 * security #24994 Prevent bundle readers from breaking out of paths (xabbuh)
 * security #24993 Ensure that submitted data are uploaded files (xabbuh)
 * security #24992 Namespace generated CSRF tokens depending of the current scheme (dunglas)
 * bug #24975 [DomCrawler] Type fix Crawler:: discoverNamespace() (VolCh)
 * bug #24954 [DI] Fix dumping with custom base class (nicolas-grekas)
 * bug #24952 [HttpFoundation] Fix session-related BC break (nicolas-grekas, sroze)
 * bug #24943 [FrameworkBundle] Wire the translation.reader service instead of deprecated translation.loader in commands (ogizanagi)

* 4.0.0-BETA4 (2017-11-12)

 * bug #24874 [TwigBridge] Fixed the .form-check-input class in the bs4 templates (vudaltsov)
 * bug #24929 [Console] Fix traversable autocomplete values (ro0NL)
 * feature #24860 [FrameworkBundle] Add default translations path option and convention (yceruto)
 * bug #24921 [Debug] Remove false-positive deprecation from DebugClassLoader (nicolas-grekas)
 * bug #24856 [FrameworkBundle] Add default mapping path for validator component in bundle-less app (yceruto)
 * bug #24833 [FrameworkBundle] Add default mapping path for serializer component in bundle-less app (yceruto)
 * bug #24908 [WebServerBundle] Prevent console.terminate from being fired when server:start finishes (kbond)
 * bug #24888 [FrameworkBundle] Specifically inject the debug dispatcher in the collector (ogizanagi)
 * bug #24909 [Intl] Update ICU data to 60.1 (jakzal)
 * bug #24870 [YAML] Allow to parse custom tags when linting yaml files (pierredup)
 * bug #24910 [HttpKernel][Debug] Remove noise from stack frames of deprecations (nicolas-grekas)
 * bug #24906 [Bridge/ProxyManager] Remove direct reference to value holder property (nicolas-grekas)
 * feature #24887 [Cache][Lock] Add RedisProxy for lazy Redis connections (nicolas-grekas)
 * bug #24633 [Config] Fix cannotBeEmpty() (ro0NL)
 * bug #24900 [Validator] Fix Costa Rica IBAN format (Bozhidar Hristov)
 * bug #24904 [Validator] Add Belarus IBAN format (Bozhidar Hristov)
 * bug #24837 [TwigBridge] [Bootstrap 4] Fix validation error design for expanded choiceType (ostrolucky)
 * bug #24878 [HttpFoundation] Prevent PHP from sending Last-Modified on session start (nicolas-grekas)
 * bug #24881 [WebserverBundle] fixed the bug that caused that the webserver would … (Serkan Yildiz)
 * bug #24722 Replace more docblocks by type-hints (nicolas-grekas)
 * bug #24850 [DI] Fix cannot bind env var (ogizanagi)
 * bug #24851 [TwigBridge] Fix BC break due required twig environment (ro0NL)

* 4.0.0-BETA3 (2017-11-05)

 * bug #24531 [HttpFoundation] Fix forward-compat of NativeSessionStorage with PHP 7.2 (sroze)
 * bug #24828 [DI] Fix the "almost-circular refs" fix (nicolas-grekas)
 * bug #24665 Fix dump panel hidden when closing a dump (julienfalque)
 * bug #24802 [TwigBridge] [Bootstrap 4] Fix hidden errors (ostrolucky)
 * bug #24816 [Serializer] Fix extra attributes when no group specified (ogizanagi)
 * bug #24822 [DI] Fix "almost-circular" dependencies handling (nicolas-grekas)
 * bug #24821 symfony/form auto-enables symfony/validator, even when not present (weaverryan)
 * bug #24824 [FrameworkBundle][Config] fix: do not add resource checkers for no-debug (dmaicher)
 * bug #24814 [Intl] Make intl-data tests pass and save language aliases again (jakzal)
 * bug #24810 [Serializer] readd default argument value (xabbuh)
 * bug #24809 [Config] Fix dump of config references for deprecated nodes (chalasr)
 * bug #24796 [PhpUnitBridge] Fixed fatal error in CoverageListener when something goes wrong in Test::setUpBeforeClass (lyrixx)
 * bug #24774 [HttpKernel] Let the storage manage the session starts (sroze)
 * bug #24735 [VarDumper] fix trailling comma when dumping an exception (Simperfit)
 * bug #24770 [Validator] Fix TraceableValidator is reset on data collector instantiation (ogizanagi)
 * bug #24764 [HttpFoundation] add Early Hints to Reponse to fix test (Simperfit)
 * bug #24759 Removes \n or space when $context/$extra are empty (kirkmadera)
 * bug #24758 Throwing exception if redis and predis unavailable (aequasi)

* 4.0.0-BETA2 (2017-10-30)

 * bug #24728 [Bridge\Twig] fix bootstrap checkbox_row to render properly & remove spaceless (arkste)
 * bug #24709 [HttpKernel] Move services reset to Kernel::handle()+boot() (nicolas-grekas)
 * bug #24703 [TwigBridge] Bootstrap 4 form theme fixes (vudaltsov)
 * bug #24744 debug:container --types: Fix bug with non-existent classes (weaverryan)
 * bug #24747 [VarDumper] HtmlDumper: fix collapsing nodes with depth < maxDepth (ogizanagi)
 * bug #24743 [FrameworkBundle] Do not activate the cache if Doctrine's cache is not present (sroze)
 * bug #24605 [FrameworkBundle] Do not load property_access.xml if the component isn't installed (ogizanagi)
 * bug #24710 [TwigBridge] Fix template paths in profiler (ro0NL)
 * bug #24706 [DependencyInjection] Add the possibility to disable assets via xml (renatomefi)
 * bug #24696 Ensure DeprecationErrorHandler::collectDeprecations() is triggered (alexpott)
 * bug #24711 [TwigBridge] Re-add Bootstrap 3 Checkbox Layout (arkste)
 * bug #24713 [FrameworkBundle] fix CachePoolPrunerPass to use correct command service id (kbond)
 * bug #24686 Fix $_ENV/$_SERVER precedence in test framework (fabpot)
 * bug #24691 [HttpFoundation] Fix caching of session-enabled pages (nicolas-grekas)
 * feature #24677 [HttpFoundation] Allow DateTimeImmutable in Response setters (derrabus)
 * bug #24694 [Intl] Allow passing null as a locale fallback (jakzal)
 * bug #24606 [HttpFoundation] Fix FileBag issue with associative arrays (enumag)
 * bug #24673 [DI] Throw when a service name or an alias contains dynamic values (prevent an infinite loop) (dunglas)
 * bug #24684 [Security] remove invalid deprecation notice on AbstractGuardAuthenticator::supports() (kbond)
 * bug #24681 Fix isolated error handling (alexpott)
 * bug #24575 Ensure that PHPUnit's error handler is still working in isolated tests (alexpott)
 * bug #24597 [PhpUnitBridge] fix deprecation triggering test detection (xabbuh)
 * feature #24671 [DI] Handle container.autowiring.strict_mode to opt-out from legacy autowiring (nicolas-grekas)
 * bug #24660 Escape trailing \ in QuestionHelper autocompletion (kamazee)
 * bug #24624 [Security] Fix missing BC layer for AbstractGuardAuthenticator::getCredentials() (chalasr)
 * bug #24598 Prefer line formatter on missing cli dumper (greg0ire)
 * bug #24635 [DI] Register default env var provided types (ro0NL)
 * bug #24620 [FrameworkBundle][Workflow] Fix deprectation when checking workflow.registry service in dump command (Jean-Beru)
 * bug #24644 [Security] Fixed auth provider authenticate() cannot return void (glye)
 * bug #24642 [Routing] Fix resource miss (dunglas)
 * bug #24608 Adding the Form default theme files to be warmed up in Twig's cache (weaverryan)
 * bug #24626 streamed response should return $this (DQNEO)
 * feature #24631 [Form] Fix FormEvents::* constant and value matching (yceruto, javiereguiluz)
 * bug #24630 [WebServerBundle] Prevent commands from being registered by convention (chalasr)
 * bug #24589 Username and password in basic auth are allowed to contain '.' (Richard Quadling)
 * bug #24566 Fixed unsetting from loosely equal keys OrderedHashMap (maryo)
 * bug #24570 [Debug] Fix same vendor detection in class loader (Jean-Beru)
 * bug #24573  Fixed pathinfo calculation for requests starting with a question mark. (syzygymsu)
 * bug #24565 [Serializer] YamlEncoder: throw if the Yaml component isn't installed (dunglas)
 * bug #24563 [Serializer] ObjectNormalizer: throw if PropertyAccess isn't installed (dunglas)
 * bug #24571 [PropertyInfo] Add support for the iterable type (dunglas)
 * bug #24579 pdo session fix (mxp100)
 * bug #24536 [Security] Reject remember-me token if UserCheckerInterface::checkPostAuth() fails (kbond)

* 4.0.0-BETA1 (2017-10-19)

 * feature #24583 Adding a new debug:autowiring command (weaverryan)
 * feature #24523 [HttpFoundation] Make sessions secure and lazy (nicolas-grekas)
 * feature #22610 [Form] [TwigBridge] Added option to disable usage of default themes when rendering a form (emodric)
 * feature #23112 [OptionsResolver] Support array of types in allowed type (pierredup)
 * feature #24321 added ability to handle parent classes for PropertyNormalizer (ivoba)
 * feature #24505 [HttpKernel] implement reset() in DumpDataCollector (xabbuh)
 * feature #24425 [Console][HttpKernel] Handle new SHELL_VERBOSITY env var, also configures the default logger (nicolas-grekas)
 * feature #24503 [MonologBridge][EventDispatcher][HttpKernel] remove deprecated features (xabbuh)
 * feature #24387 [FORM] Prevent forms from extending itself as a parent (pierredup)
 * feature #24484 [DI] Throw accurate failures when accessing removed services (nicolas-grekas)
 * feature #24208 [Form] Display option definition from a given form type (yceruto, ogizanagi)
 * feature #22228 [HttpKernel] minor: add ability to construct with headers on http exceptions (gsdevme)
 * feature #24467 [Process] drop non-existent working directory support (xabbuh)
 * feature #23499 [Workflow] add guard is_valid() method support (alain-flaus, lyrixx)
 * feature #24364 [DependencyInjection][Filesystem][Security][SecurityBundle] remove deprecated features (xabbuh)
 * feature #24441 [Bridge\Doctrine][FrameworkBundle] Remove legacy uses of ContainerAwareInterface (nicolas-grekas)
 * feature #24388 [Security] Look at headers for switch_user username (chalasr)
 * feature #24447 [Session] remove deprecated session handlers (Tobion)
 * feature #24446 [Security] Remove GuardAuthenticatorInterface (chalasr)
 * feature #23708 Added deprecation to cwd not existing Fixes #18249 (alexbowers)
 * feature #24443 [Session] deprecate MemcacheSessionHandler (Tobion)
 * feature #24409 [Bridge\Doctrine][FrameworkBundle] Deprecate some remaining uses of ContainerAwareTrait (nicolas-grekas)
 * feature #24438 [Session][VarDumper] Deprecate accepting legacy mongo extension (Tobion)
 * feature #24389 [DoctrineBridge] Deprecate dbal session handler (Tobion)
 * feature #16835 [Security] Add Guard authenticator <supports> method (Amo, chalasr)
 * feature #24289 [FrameworkBundle][HttpKernel] Reset profiler (derrabus)
 * feature #24144 [FrameworkBundle] Expose dotenv in bin/console about (ro0NL)
 * feature #24403 [FrameworkBundle][Routing] Show welcome message if no routes are configured (yceruto)
 * feature #24398 [DI] Remove AutowireExceptionPass (ogizanagi)
 * feature #22679 [Form] Add tel and color types (apetitpa)
 * feature #23845 [Validator] Add unique entity violation cause (Ilya Vertakov)
 * feature #22132 [Lock] Automaticaly release lock when user forget it (jderusse)
 * feature #21751 Bootstrap4 support for Twig form theme (hiddewie, javiereguiluz)
 * feature #24383 [FrameworkBundle] Don't clear app pools on cache:clear (nicolas-grekas)
 * feature #24148 [Form] Hide label button when its setted to false (TeLiXj)
 * feature #24380 [SecurityBundle] Remove auto picking the first provider (ogizanagi)
 * feature #24378 [SecurityBundle] Deprecate auto picking the first provider (ogizanagi)
 * feature #24260 [Security] Add impersonation support for stateless authentication (chalasr)
 * feature #24300 [HttpKernel][FrameworkBundle] Add a minimalist default PSR-3 logger (dunglas)
 * feature #21604 [Security] Argon2i Password Encoder (zanbaldwin)
 * feature #24372 [DowCrawler] Default to UTF-8 when possible (nicolas-grekas)
 * feature #24264 [TwigBundle] Improve the overriding of bundle templates (yceruto)
 * feature #24197 [Translation] 	Moved PhpExtractor and PhpStringTokenParser to Translation component (Nyholm)
 * feature #24362 [HttpKernel] Deprecate some compiler passes in favor of tagged iterator args (nicolas-grekas)
 * feature #21027 [Asset] Provide default context (ro0NL)
 * feature #22200 [DI] Reference tagged services in config (ro0NL)
 * feature #24337 Adding a shortcuts for the main security functionality (weaverryan, javiereguiluz)
 * feature #24358 [TwigBundle] register an identity translator as fallback (xabbuh)
 * feature #24357 [Yaml] include file and line no in deprecation message (xabbuh)
 * feature #24330 [FrameworkBundle] register class metadata factory alias (xabbuh)
 * feature #24348 [SecurityBundle] Remove remaining ACL stuff from SecurityBundle (ogizanagi)
 * feature #24349 [SecurityBundle] Add missing AclSchemaListener deprecation (ogizanagi)
 * feature #24202 [Filesystem] deprecate relative paths in makePathRelative() (xabbuh)
 * feature #21716 [Serializer] Add Support for `object_to_populate` in CustomNormalizer (chrisguitarguy)
 * feature #21960 Remove Validator\TypeTestCase and add validator logic to base TypeTestCase (pierredup)
 * feature #24338 [HttpFoundation] Removed compatibility layer for PHP <5.4 sessions (afurculita)
 * feature #22113 [Lock] Include lock component in framework bundle (jderusse)
 * feature #24236 [WebProfilerBundle] Render file links for twig templates (ro0NL)
 * feature #21239 [Serializer] throw more specific exceptions (xabbuh)
 * feature #24341 [SecurityBundle] Remove ACL related code (chalasr)
 * feature #24256 CsvEncoder handling variable structures and custom header order (Oliver Hoff)
 * feature #23471 [Finder] Add a method to check if any results were found (duncan3dc)
 * feature #23149 [PhpUnitBridge] Added a CoverageListener to enhance the code coverage report (lyrixx)
 * feature #24161 [HttpKernel] Remove bundle inheritance (fabpot)
 * feature #24318 [SecurityBundle] Deprecate ACL related code (chalasr)
 * feature #24335 [Security][SecurityBundle] Deprecate the HTTP digest auth (ogizanagi)
 * feature #21951 [Security][Firewall] Passing the newly generated security token to the event during user switching (klandaika)
 * feature #23485 [Config] extracted the xml parsing from XmlUtils::loadFile into XmlUtils::parse (Basster)
 * feature #22890 [HttpKernel] Add ability to configure catching exceptions for Client (kbond)
 * feature #24239 [HttpFoundation] Deprecate compatibility with PHP <5.4 sessions (afurculita)
 * feature #23882 [Security] Deprecated not being logged out after user change (iltar)
 * feature #24200 Added an alias for FlashBagInterface in config (tifabien)
 * feature #24295 [DI][DX] Throw exception on some ContainerBuilder methods used from extensions (ogizanagi)
 * feature #24253 [Yaml] support parsing files (xabbuh)
 * feature #24290 Adding Definition::addError() and a compiler pass to throw errors as exceptions (weaverryan)
 * feature #24301 [DI] Add AutowireRequiredMethodsPass to fix bindings for `@required` methods (nicolas-grekas)
 * feature #24226 [Cache] Add ResettableInterface to allow resetting any pool's local state (nicolas-grekas)
 * feature #24303 [FrameworkBundle] allow forms without translations and validator (xabbuh)
 * feature #24291 [SecurityBundle] Reset the authentication token between requests (derrabus)
 * feature #24280 [VarDumper] Make `dump()` a little bit more easier to use (freekmurze)
 * feature #24277 [Serializer] Getter for extra attributes in ExtraAttributesException (mdeboer)
 * feature #24257 [HttpKernel][DI] Enable Kernel to implement CompilerPassInterface (nicolas-grekas)
 * feature #23834 [DI] Add "PHP fluent format" for configuring the container (nicolas-grekas)
 * feature #24180 [Routing] Add PHP fluent DSL for configuring routes (nicolas-grekas)
 * feature #24232 [Bridge\Doctrine] Add "DoctrineType::reset()" method (nicolas-grekas)
 * feature #24238 [DI] Turn services and aliases private by default, with BC layer (nicolas-grekas)
 * feature #24242 [Form] Remove deprecated ChoiceLoaderInterface implementation in TimezoneType (ogizanagi)
 * feature #23648 [Form] Add input  + regions options to TimezoneType (ro0NL)
 * feature #24185 [Form] Display general forms information on debug:form (yceruto)
 * feature #23747 [Serializer][FrameworkBundle] Add a DateInterval normalizer (Lctrs)
 * feature #24193 [FrameworkBundle] Reset stopwatch between requests (derrabus)
 * feature #24160 [HttpKernel] Deprecate bundle inheritance (fabpot)
 * feature #24159 Remove the profiler.matcher configuration (fabpot)
 * feature #24155 [FrameworkBundle][HttpKernel] Add DI tag for resettable services (derrabus)
 * feature #23625 Feature #23583  Add current and fallback locales in WDT / Profiler (nemoneph)
 * feature #24179 [TwigBundle] Add default templates directory and option to configure it (yceruto)
 * feature #24176 [Translation] drop MessageSelector support in the Translator (xabbuh)
 * feature #24104 Make as many services private as possible (nicolas-grekas)
 * feature #18314 [Translation] added support for adding custom message formatter (aitboudad)
 * feature #24158 deprecated profiler.matcher configuration (fabpot)
 * feature #23728 [WebProfilerBundle] Removed the deprecated web_profiler.position option (javiereguiluz)
 * feature #24131 [Console] Do not display short exception trace for common console exceptions (yceruto)
 * feature #24080 Deprecated the web_profiler.position option (javiereguiluz)
 * feature #24114 [SecurityBundle] Throw a meaningful exception when an undefined user provider is used inside a firewall (chalasr)
 * feature #24122 [DI] rename ResolveDefinitionTemplatesPass to ResolveChildDefinitionsPass (nicolas-grekas)
 * feature #23901 [DI] Allow processing env vars (nicolas-grekas)
 * feature #24093 [FrameworkBundle] be able to enable workflow support explicitly (xabbuh)
 * feature #24064 [TwigBridge] Show Twig's loader paths on debug:twig command (yceruto)
 * feature #23978 [Cache] Use options from Memcached DSN (Bukashk0zzz)
 * feature #24067 [HttpKernel] Dont register env parameter resource (ro0NL)
 * feature #24075 Implemented PruneableInterface on TagAwareAdapter (Toflar)
 * feature #23262 Add scalar typehints/return types (chalasr, xabbuh)
 * feature #21414 [Console] Display file and line on Exception (arno14)
 * feature #24068 [HttpKernel] Deprecate EnvParametersResource (ro0NL)
 * feature #22542 [Lock] Check TTL expiration in lock acquisition (jderusse)
 * feature #24031 [Routing] Add the possibility to define a prefix for all routes of a controller (fabpot)
 * feature #24052 [DI] Remove case insensitive parameter names (ro0NL)
 * feature #23967 [VarDumper] add force-collapse/expand + use it for traces (nicolas-grekas)
 * feature #24033 [DI] Add ContainerInterface::IGNORE_ON_UNINITIALIZED_REFERENCE (nicolas-grekas)
 * feature #24026 [Security] add impersonator_user to "User was reloaded" log message (gharlan)
 * feature #24014 [Translator] Remove deprecated feature (maidmaid)
 * feature #23603 [Cache] Add (pdo|chain) cache (adapter|simple) prune method (robfrawley)
 * feature #23694 [Form] Add debug:form command (yceruto)
 * feature #24028 [Yaml] mark some classes as final (xabbuh)
 * feature #22543 [Lock] Expose an expiringDate and isExpired method in Lock (jderusse)
 * feature #23667 [Translation] Create an TranslationReaderInterface and move TranslationLoader to TranslationComponent (Nyholm)
 * feature #24024 [config] Add ability to deprecate a node (sanpii)
 * feature #23668 [VarDumper] Add period caster (maidmaid)
 * feature #23991 [DI] Improve psr4-based service discovery (alternative implementation) (kbond)
 * feature #22382 [config] Add abbitily to deprecate a node (Nyholm, fabpot, sanpii)
 * feature #23947 [Translation] Adding the ability do load <notes> in xliff2.0 (Nyholm)
 * feature #23887 [Console] Allow commands to provide a default name for compile time registration (chalasr, nicolas-grekas)
 * feature #23874 [DI] Case sensitive parameter names (ro0NL)
 * feature #23936 Remove some sf2 references (fabpot)
 * feature #23680 [Webprofiler] Added blocks that allows extension of the profiler page. (Nyholm)
 * feature #23665 Create an interface for TranslationWriter (Nyholm)
 * feature #23890 [Translation] Adding the ability do dump <notes> in xliff2.0 (Nyholm)
 * feature #23862 [SecurityBundle] resolve class name parameter inside AddSecurityVotersPass (pjarmalavicius)
 * feature #23915 [DI] Allow get available services from service locator (Koc)
 * feature #23792 [HttpKernel][FrameworkBundle] Add RebootableInterface, fix and un-deprecate cache:clear with warmup (nicolas-grekas)
 * feature #23227 Add support for "controller" keyword for configuring routes controllers (voronkovich)
 * feature #23815 [FrameworkBundle][SecurityBundle][TwigBundle][Yaml] remove deprecated code (xabbuh)
 * feature #23857 [HttpKernel] Remove convention based commands registration (chalasr)
 * feature #23869 [Console] Made console command shortcuts case insensitive (thanosp)
 * feature #23855 [DI] Allow dumping inline services in Yaml (nicolas-grekas)
 * feature #23836 [FrameworkBundle] Catch Fatal errors in commands registration (chalasr)
 * feature #23805 [HttpKernel] Deprecated commands auto-registration (GuilhemN)
 * feature #23816 [Debug] Detect internal and deprecated methods (GuilhemN)
 * feature #23812 [FrameworkBundle] Allow micro kernel to subscribe events easily (ogizanagi)
 * feature #22187 [DependencyInjection] Support local binding (GuilhemN)
 * feature #23741 [DI] Generate one file per service factory (nicolas-grekas)
 * feature #23807 [Debug] Trigger a deprecation when using an internal class/trait/interface (GuilhemN)
 * feature #22587 [Workflow] Add transition completed event (izzyp)
 * feature #23624 [FrameworkBundle] Commands as a service (ro0NL)
 * feature #21111 [Validator] add groups support to the Valid constraint (xabbuh)
 * feature #20361 [Config] Enable cannotBeEmpty along with requiresAtLeastOneElement (ro0NL)
 * feature #23790 [Yaml] remove legacy php/const and php/object tag support (xabbuh)
 * feature #23754 [Lock] Remove Filesystem\LockHandler (jderusse)
 * feature #23712 [DependencyInjection] Deprecate autowiring service auto-registration (GuilhemN)
 * feature #23719 Autoconfigure instances of ArgumentValueResolverInterface (BPScott)
 * feature #23706 [Webprofiler] Improve sql explain table display (mimol91)
 * feature #23709 [VarDumper] Make dump() variadic (chalasr)
 * feature #23724 [Lock] Deprecate Filesystem/LockHandler (jderusse)
 * feature #23593 [Workflow] Adding workflow name to the announce event (Nyholm)
 * feature #20496 [Form] Allow pass filter callback to delete_empty option. (Koc)
 * feature #23451 [Cache] Add (filesystem|phpfiles) cache (adapter|simple) prune method and prune command (robfrawley)
 * feature #23519 [TwigBundle] Commands as a service (ro0NL)
 * feature #23591 [VarDumper] Add time zone caster (maidmaid)
 * feature #23614 [VarDumper] Remove low PHP version and hhvm compat in interval caster (maidmaid)
 * feature #22317 [Console] Make SymfonyQuestionHelper::ask optional by default (ro0NL)
 * feature #23510 [Console] Add a factory command loader for standalone application with lazy-loading needs (ogizanagi)
 * feature #23357 [VarDumper] Add interval caster (maidmaid)
 * feature #23550 [DebugBundle] Added min_depth to Configuration (james-johnston-thumbtack)
 * feature #23561 [DI] Optimize use of private and pre-defined services (nicolas-grekas)
 * feature #23569 Remove last legacy codes (nicolas-grekas)
 * feature #23570 [FrameworkBundle] Make RouterCacheWarmer implement ServiceSubscriberInterface (nicolas-grekas)
 * feature #22783 [TwigBridge] remove deprecated features (xabbuh)
 * feature #23437 [TwigBridge] deprecate TwigRenderer (Tobion)
 * feature #22801 [DI] Removed deprecated setting private/pre-defined services (ro0NL)
 * feature #23515 [VarDumper] Added setMinDepth to VarCloner (james-johnston-thumbtack)
 * feature #23484 [DI] Remove remaining deprecated features (nicolas-grekas)
 * feature #23404 [Serializer] AbstractObjectNormalizer: Allow to disable type enforcement (ogizanagi)
 * feature #23380 [Process] Remove enhanced sigchild compatibility (maidmaid)
 * feature #21086 [MonologBridge] Add TokenProcessor (maidmaid)
 * feature #22576 [Validator] Allow to use a property path to get value to compare in comparison constraints (ogizanagi)
 * feature #22689 [DoctrineBridge] Add support for doctrin/dbal v2.6 types (jvasseur)
 * feature #22734 [Console] Add support for command lazy-loading (chalasr)
 * feature #19034 [Security] make it possible to configure a custom access decision manager service (xabbuh)
 * feature #23037 [TwigBundle] Added a RuntimeExtensionInterface to take advantage of autoconfigure (lyrixx)
 * feature #22811 [DI] Remove deprecated case insensitive service ids (ro0NL)
 * feature #22176 [DI] Allow imports in string format for YAML (ro0NL)
 * feature #23295 [Security] Lazy load user providers (chalasr)
 * feature #23440 [Routing] Add matched and default parameters to redirect responses (artursvonda, Tobion)
 * feature #22804 [Debug] Removed ContextErrorException (mbabker)
 * feature #22762 [Yaml] Support tagged scalars (GuilhemN)
 * feature #22832 [Debug] Deprecate support for stacked errors (mbabker)
 * feature #21469 [HttpFoundation] Find the original request protocol version (thewilkybarkid)
 * feature #23431 [Validator] Add min/max amount of pixels to Image constraint (akeeman)
 * feature #23223 Add support for microseconds in Stopwatch (javiereguiluz)
 * feature #22341 [BrowserKit] Emulate back/forward browser navigation (e-moe)
 * feature #22619 [FrameworkBundle][Translation] Move translation compiler pass (lepiaf)
 * feature #22620 [FrameworkBundle][HttpKernel] Move httpkernel pass (lepiaf)
 * feature #23402 [Ldap] Remove the RenameEntryInterface interface (maidmaid)
 * feature #23337 [Component][Serializer][Normalizer] : Deal it with Has Method for the Normalizer/Denormalizer (jordscream)
 * feature #23391 [Validator] Remove support of boolean value for the checkDNS option (maidmaid)
 * feature #23376 [Process] Remove enhanced Windows compatibility (maidmaid)
 * feature #22588 [VarDumper] Add filter in VarDumperTestTrait (maidmaid)
 * feature #23288 [Yaml] deprecate the !str tag (xabbuh)
 * feature #23039 [Validator] Support for parsing PHP constants in yaml loader (mimol91)
 * feature #22431 [VarDumper] Add date caster (maidmaid)
 * feature #23285 [Stopwatch] Add a reset method (jmgq)
 * feature #23320 [WebServer] Allow * to bind all interfaces (as INADDR_ANY) (jpauli, fabpot)
 * feature #23272 [FrameworkBundle] disable unusable fragment renderers (xabbuh)
 * feature #23332 [Yaml] fix the displayed line number (fabpot, xabbuh)
 * feature #23324 [Security] remove support for defining voters that don't implement VoterInterface. (hhamon)
 * feature #23294 [Yaml][Lint] Add line numbers to JSON output. (WybrenKoelmans)
 * feature #22836 [Process] remove deprecated features (xabbuh)
 * feature #23286 [Yaml] remove deprecated unspecific tag behavior (xabbuh)
 * feature #23026 [SecurityBundle] Add user impersonation info and exit action to the profiler (yceruto)
 * feature #22863 [HttpFoundation] remove deprecated features (xabbuh)
 * feature #22932 [HttpFoundation] Adds support for the immutable directive in the cache-control header (twoleds)
 * feature #22554 [Profiler][Validator] Add a validator panel in profiler (ogizanagi)
 * feature #22124 Shift responsibility for keeping Date header to ResponseHeaderBag (mpdude)
 * feature #23122 Xml encoder optional type cast (ragboyjr)
 * feature #23207 [FrameworkBundle] Allow .yaml file extension everywhere (ogizanagi)
 * feature #23076 [Validator] Adds support to check specific DNS record type for URL (iisisrael)
 * feature #22629 [Security] Trigger a deprecation when a voter is missing the VoterInterface (iltar)
 * feature #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * feature #22909 [Yaml] Deprecate using the non-specific tag (GuilhemN)
 * feature #23184 [HttpFoundation] Remove obsolete ini settings for sessions (fabpot)
 * feature #23042 Consistent error handling in remember me services (lstrojny)
 * feature #22444 [Serializer] DateTimeNormalizer: allow to provide timezone (ogizanagi)
 * feature #23143 [DI] Reference instead of inline for array-params (nicolas-grekas)
 * feature #23154 [WebProfilerBundle] Sticky ajax window (ro0NL)
 * feature #23161 [FrameworkBundle] Deprecate useless --no-prefix option (chalasr)
 * feature #23169 [FrameworkBundle] Remove KernelTestCase deprecated code (ogizanagi)
 * feature #23105 [SecurityBundle][Profiler] Give info about called security listeners in profiler (chalasr)
 * feature #23148 [FrameworkBundle] drop hard dependency on the Stopwatch component (xabbuh)
 * feature #23131 [FrameworkBundle] Remove dependency on Doctrine cache (fabpot)
 * feature #23114 [SecurityBundle] Lazy load security listeners (chalasr)
 * feature #23111 [Process] Deprecate ProcessBuilder (nicolas-grekas)
 * feature #22675 [FrameworkBundle] KernelTestCase: deprecate not using KERNEL_CLASS (ogizanagi)
 * feature #22917 [VarDumper] Cycle prev/next searching in HTML dumps (ro0NL)
 * feature #23044 Automatically enable the routing annotation loader (GuilhemN)
 * feature #22696 [PropertyInfo] Made ReflectionExtractor's prefix lists instance variables (neemzy)
 * feature #23056 [WebProfilerBundle] Remove WebProfilerExtension::dumpValue() (ogizanagi)
 * feature #23035  Deprecate passing a concrete service in optional cache warmers (romainneutron)
 * feature #23036  Implement ServiceSubscriberInterface in optional cache warmers (romainneutron)
 * feature #23046 [Form] Missing deprecated paths removal (ogizanagi)
 * feature #23022 [Di] Remove closure-proxy arguments (nicolas-grekas)
 * feature #22758 Remove HHVM support (fabpot)
 * feature #22743 [Serializer] Remove support for deprecated signatures (dunglas)
 * feature #22907 [Serializer] remove remaining deprecated features (xabbuh)
 * feature #22886 [HttpKernel] remove deprecated features (xabbuh)
 * feature #22906 [Console] remove remaining deprecated features (xabbuh)
 * feature #22879 [Translation] remove deprecated features (xabbuh)
 * feature #22880 [Routing] remove deprecated features (xabbuh)
 * feature #22903 [DI] Deprecate XML services without ID (ro0NL)
 * feature #22770 [Yaml] remove deprecated features (xabbuh)
 * feature #22785 [ProxyManagerBridge] remove deprecated features (xabbuh)
 * feature #22800 [FrameworkBundle] Remove deprecated code (ogizanagi)
 * feature #22597 [Lock] Re-add the Lock component in 3.4 (jderusse)
 * feature #22860 [Form] remove deprecated features (xabbuh)
 * feature #22803 [DI] Deprecate Container::initialized() for privates (ro0NL)
 * feature #22773 [DependencyInjection] remove deprecated autowiring_types feature (hhamon)
 * feature #22809 [DI] Remove deprecated generating a dumped container without populating the method map (ro0NL)
 * feature #22764 [DI] Remove deprecated dumping an uncompiled container (ro0NL)
 * feature #22820 Remove PHP < 7.1.3 code (ogizanagi)
 * feature #22763 [DI] Remove deprecated isFrozen() (ro0NL)
 * feature #22837 [VarDumper] remove deprecated features (xabbuh)
 * feature #22777 [Console] Remove deprecated console.exception event (mbabker)
 * feature #22792 [PhpUnitBridge] remove deprecated features (xabbuh)
 * feature #22821 [Security] remove deprecated features (xabbuh)
 * feature #22750 [DependencyInjection] remove deprecated code in YamlFileLoader class (hhamon)
 * feature #22828 [Finder] Deprecate FilterIterator (ogizanagi)
 * feature #22791 [MonologBridge] remove deprecated features (xabbuh)
 * feature #22740 [SecurityBundle][Security][Finder] Remove deprecated code paths (ogizanagi)
 * feature #22823 [PropertyAccess] remove deprecated features (xabbuh)
 * feature #22826 [Validator] improve strict option value deprecation (xabbuh)
 * feature #22799 [Console] Remove deprecated features (chalasr)
 * feature #22786 [ClassLoader][HttpKernel] Remove ClassLoader component & Kernel::loadClassCache (ogizanagi, xabbuh)
 * feature #22795 [Validator] remove deprecated features (xabbuh)
 * feature #22784 [DoctrineBridge] remove deprecated features (xabbuh)
 * feature #22749 Remove deprecated container injections and compiler passes (chalasr)
 * feature #22796 [EventDispatcher] remove deprecated features (xabbuh)
 * feature #22797 [Ldap] remove deprecated features (xabbuh)
 * feature #22794 [ExpressionLanguage] remove deprecated features (xabbuh)
 * feature #22779 [BC Break] Removed BC layers for ControllerResolver::getArguments() (iltar)
 * feature #22782 [Debug][VarDumper] Remove the symfony_debug C extension (nicolas-grekas)
 * feature #22771 [Workflow] Removed deprecated features (lyrixx)
 * feature #22741 [Serializer] Remove deprecated DoctrineCache support (dunglas)
 * feature #22733 Bump minimum version to PHP 7.1 for Symfony 4 (fabpot, dunglas, nicolas-grekas)

