CHANGELOG for 2.6.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 2.6 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v2.6.0...v2.6.1

* 2.6.12 (2015-11-23)

 * security #16631 CVE-2015-8124: Session Fixation in the "Remember Me" Login Feature (xabbuh)
 * security #16630 CVE-2015-8125: Potential Remote Timing Attack Vulnerability in Security Remember-Me Service (xabbuh)

* 2.6.11 (2015-07-26)

 * bug #15361 [Yaml] throw a ParseException on invalid data type (xabbuh)
 * bug #15330 [Console] Fix console output with closed stdout (jakzal)
 * bug #15326 [Security] fix check for empty usernames (xabbuh)
 * bug #15291 [HttpFoundation] Fix Response::closeOutputBuffers() for HHVM 3.3 (nicolas-grekas)
 * bug #15249 [HttpFoundation] [PSR-7] Allow to use resources as content body and to return resources from string content (dunglas)
 * bug #15282 [HttpFoundation] Behaviour change in PHP7 for substr (Nicofuma)
 * bug #15250 [PropertyAccess] BC Break since 2.6.5 (Nicolas Macherey)

* 2.6.10 (2015-07-13)

 * bug #15248 Added 'default' color (jaytaph)
 * bug #15243 Reload the session after regenerating its id (jakzal)
 * bug #15202 [Security] allow to use `method` in XML configs (xabbuh)
 * bug #15218 [Twig][Bridge] replaced `extends` with `use` in bootstrap_3_horizontal_layout.html.twig (MatTheCat)
 * bug #15223 [Finder] Command::addAtIndex() fails with Command instance argument (thunderer)
 * bug #15220 [DependencyInjection] Freeze also FrozenParameterBag::remove (lyrixx)
 * bug #15110 Add a way to reset the singleton (dawehner)
 * bug #15115 [Validator] always evaluate binary format when changed (xabbuh)
 * bug #15163 Update DateTimeToArrayTransformer.php (zhil)
 * bug #15150 [Translation] Azerbaijani language pluralization rule is wrong (shehi)
 * bug #15159  Towards 100% HHVM compat (nicolas-grekas)
 * bug #15146 Towards 100% HHVM compat (nicolas-grekas)
 * bug #15069 [Form] Fixed: Data mappers always receive forms indexed by their names (webmozart)
 * bug #15137 [Security] Initialize SwitchUserEvent::targetUser on attemptExitUser (Rvanlaak, xabbuh)
 * bug #15126 [Validator] Fix BC for Validator's validate method (michalmarcinkowski)
 * bug #15083 [DependencyInjection] Fail when dumping a Definition with no class nor factory (nicolas-grekas)
 * bug #15127 [Validator] fix validation for Maestro UK card numbers (xabbuh)
 * bug #15128 DbalLogger: Small nonutf8 array fix (vpetrovych, weaverryan)
 * bug #15048 [Translation][Form][choice] empty_value shouldn't be translated when it has an empty value (Restless-ET)
 * bug #15117 [Form] fixed sending non array data on submit to ResizeListener (BruceWouaigne)
 * bug #15102 [Translation][debug cmd] fixed failing tests. (aitboudad)
 * bug #13750 [DependencyInjection] Fixed decoration of service for service with parent (hason)
 * bug #15086 Fixed the regexp for the validator of Maestro-based credit/debit cards (javiereguiluz)
 * bug #15058 [Console] Fix STDERR output text on IBM iSeries OS400 (johnkary)
 * bug #14853 [Validator] more strict e-mail validation regex (xabbuh)
 * bug #15065 [Form] Fixed: remove quoted strings from Intl date formats (e.g. es_ES full pattern) (webmozart)
 * bug #15039 [Translation][update cmd] taken account into bundle overrides path. (aitboudad)
 * bug #15038 [Translation][debug cmd] taken account into bundle overrides path. (aitboudad)
 * bug #14964 [bugfix][MonologBridge] WebProcessor: passing $extraFields to BaseWebProcessor (MacDada)
 * bug #15036 [VarDumper] Fix dump output for better readability (nicolas-grekas)
 * bug #15027 [Form] Fixed: Filter non-integers when selecting entities by int ID (webmozart, nicolas-grekas)
 * bug #15000 [Debug] Fix fatal-errors handling on HHVM (nicolas-grekas)
 * bug #14999 [Debug] Fix fatal-errors handling on HHVM (nicolas-grekas, digitalkaoz)
 * bug #14959 [Debug+VarDumper] Fix handling of PHP7 "Throwable" exceptions (nicolas-grekas)
 * bug #15010 [Debug] Fix log level of stacked errors (nicolas-grekas)
 * bug #15017 [VarDumper] Fix uninitialized id in HtmlDumper (nicolas-grekas)
 * bug #14980 Fixed fluent interface (jaytaph)
 * bug #14974 [Security][Translation] #14920 update translations (vincentaubert)
 * bug #14930 Bug #14836 [HttpFoundation] Moves default JSON encoding assignment fr… (Incognito)
 * bug #14897  Allow new lines in Messages translated with transchoice() (replacement for #14867)  (azine)
 * bug #14895 [Form] Support DateTimeImmutable in transform() (c960657)
 * bug #14891 without this change allways the legacy code get called (dominikzogg)
 * bug #14859 Improve the config validation in TwigBundle (stof)
 * bug #14785 [BrowserKit] Fix bug when uri starts with http. (amouhzi)
 * bug #14807 [Security][Acl] enforce string identifiers (xabbuh)
 * bug #14808 [WebProfilerBundle][logger] added missing deprecation message. (aitboudad)

* 2.6.9 (2015-05-30)

 * bug #14777 Avoid using the app global variable in the profiler templates (stof)
 * bug #14262 [REVERTED] [TwigBundle] Refresh twig paths when resources change. (aitboudad)

* 2.6.8 (2015-05-27)

 * security #14759 CVE-2015-4050 [HttpKernel] Do not call the FragmentListener if _controller is already defined (jakzal)
 * bug #14743 [DebugBundle] Fix config XSD (nicolas-grekas)
 * bug #14726 [Translation] fixed JSON loader on PHP 7 when file is empty (fabpot)
 * bug #14715 [Form] Check instance of FormBuilderInterface instead of FormBuilder (dosten)
 * bug #14678 [Security] AbstractRememberMeServices::encodeCookie() validates cookie parts (MacDada)
 * bug #14635 [HttpKernel] Handle an array vary header in the http cache store (jakzal)
 * bug #14513 [console][formater] allow format toString object. (aitboudad)
 * bug #14335 [HttpFoundation] Fix baseUrl when script filename is contained in pathInfo (danez)
 * bug #14593 [Security][Firewall] Avoid redirection to XHR URIs (asiragusa)
 * bug #14618 [DomCrawler] Throw an exception if a form field path is incomplete (jakzal)
 * bug #14699  Fix HTML escaping of to-source links (amenk, nicolas-grekas)
 * bug #14698  Fix HTML escaping of to-source links (nicolas-grekas)
 * bug #14690 [HttpFoundation] IpUtils::checkIp4() should allow `/0` networks (zerkms)
 * bug #14696 Fix the rendering of deprecation log messages (stof)
 * bug #14683 Fixed the indentation in the compiled template for the DumpNode (stof)
 * bug #14262 [TwigBundle] Refresh twig paths when resources change. (aitboudad)
 * bug #13633 [ServerBag] Handled bearer authorization header in REDIRECT_ form (Lance0312)
 * bug #13637 [CSS] WebProfiler break words (nicovak)
 * bug #14217 [WebProfilerBundle] Fix regexp (romqin)
 * bug #14644 [Bridge\Twig] Adding a space between the icon and the error message (zmikael, nicolas-grekas)
 * bug #14640 [DebugBundle] Allow alternative destination for dumps (nicolas-grekas)
 * bug #14633 [EventDispatcher] make listeners removable from an executed listener (xabbuh)
 * bug #14609 [DebugBundle] Remove inlined dumps on XHR (nicolas-grekas)
 * bug #14605 [PropertyAccess] Fix setting public property on a class having a magic getter (lolautruche)

* 2.6.7 (2015-05-11)

 * bug #14266 [HttpKernel] Check if "symfony/proxy-manager-bridge" package is installed (hason)
 * bug #14478 [DebugBundle] Fix dump() output in API / No-Toolbar context (nicolas-grekas)
 * bug #14501 [ProxyBridge] Fix proxy classnames generation (xphere)
 * bug #14527 Fix getOrigin (WouterJ)
 * bug #14498 [FrameworkBundle] Added missing log in server:run command (lyrixx)
 * bug #14503 [Finder] Only use GLOB_BRACE when available (dosten)
 * bug #14484 [SecurityBundle][WebProfiler] check authenticated user by tokenClass instead of username. (aitboudad)
 * bug #14497 [HttpFoundation] Allow curly braces in trusted host patterns (sgrodzicki)
 * bug #14480 [TwigBundle] Fix deprecated use of FlattenException (alOneh)
 * bug #14469 [Debug] BaseException compatibility for PHP7 (nicolas-grekas)
 * bug #14466 [WebProfiler] fix html syntax for input types (Tobion)
 * bug #14436 Show a better error when the port is in use (dosten)
 * bug #14463 [Validator] Fixed Choice when an empty array is used in the "choices" option (webmozart)
 * bug #14446 [DependencyInjection] resolve circular reference (xabbuh)
 * bug #14448 [Validator] Fixed Choice when an empty array is used in the "choices" option (webmozart)
 * bug #14451 [Debug] Fix ClassNotFoundFatalErrorHandler candidates lookups (nicolas-grekas)
 * bug #14355 [EventDispatcher] make listeners removable from an executed listener (xabbuh)
 * bug #14402 [FrameworkBundle][Translation] Check for 'xlf' instead of 'xliff' (xelaris)
 * bug #14272 [FrameworkBundle] Workaround php -S ignoring auto_prepend_file (nicolas-grekas)
 * bug #14362 [Debug] Scream as LogLevel::DEBUG (but for fatal errors / uncaught exceptions) (nicolas-grekas)
 * bug #14345 [FrameworkBundle] Fix Routing\DelegatingLoader resiliency to fatal errors (nicolas-grekas)
 * bug #14381 [FrameworkBundle] Initialize translator with the default locale. (aitboudad)
 * bug #14325 [Routing][DependencyInjection] Support .yaml extension in YAML loaders (thunderer)
 * bug #14344 [Translation][fixed test] refresh cache when resources are no longer fresh. (aitboudad)
 * bug #14346  [WebProfilerBundle] Fix resiliency to exceptions thrown by the url generator (nicolas-grekas)
 * bug #14338 [FrameworkBundle] improve usage of Table helper (xabbuh)
 * bug #14129 [FrameworkBundle] Fixed server:start --router relative path issue #14124 (abulford)
 * bug #14271 [VarDumper] Fix call site detection (nicolas-grekas)
 * bug #14277 [Translator] Cache does not take fallback locales into consideration (mpdude)
 * bug #14268 [Translator] Cache does not take fallback locales into consideration (sf2.3) (mpdude)
 * bug #14256 [Form] Fixed DateType/TimeType (webmozart)
 * bug #14226 [Profiler][Logger] fixed cycle odd/even. (aitboudad)
 * bug #14204 [VarDumper] Towards PHP7 support (nicolas-grekas)
 * bug #14205 Fix currently broken tests (mpdude)
 * bug #14192 [HttpKernel] Embed the original exception as previous to bounced exceptions (nicolas-grekas)
 * bug #14102 [Enhancement] netbeans - force interactive shell when limited detection (cordoval)
 * bug #14191 [StringUtil] Fixed singularification of 'movies' (GerbenWijnja)
 * bug #14182 [FrameworkBundle] fixes displaying of deprecation notices. (hhamon)
 * feature #14186 [Debug] Renamed "context" key to "scope_vars" to avoid any ambiguity (lyrixx)
 * bug #14170 Fix the AJAX profiling (stof)

* 2.6.6 (2015-04-01)

 * security #14167 CVE-2015-2308 (nicolas-grekas)
 * security #14166 CVE-2015-2309 (neclimdul)
 * bug #14126 [VarDumper] Fix toggle action to see source excerpt (nicolas-grekas)
 * bug #14114 [VarDumper] Fix dumping references as properties (nicolas-grekas)
 * bug #14074 [VarDumper] Fix dumping ThrowingCasterException (nicolas-grekas)
 * bug #12948 [Form] [TwigBridge] Bootstrap layout whitespace control (mvar)
 * bug #14046 [Security] StringUtils::equals() arguments in RememberMe Cookie based implementation are confused (zerkms)
 * bug #14010 Replace GET parameters when changed in form (WouterJ)
 * bug #13991 [Dependency Injection] Improve PhpDumper Performance for huge Containers (BattleRattle)
 * bug #13886 [FrameworkBundle][debug:config] added support for dynamic configurations... (aitboudad)
 * bug #14013 [DependencyInjection] prevent inlining service configurators (xabbuh)
 * bug #14012 [DomCrawler] Improve namespace discovery performance (jakzal)
 * bug #13997 [2.3+][Form][DoctrineBridge] Improved loading of entities and documents (guilhermeblanco)
 * bug #13978 [WebProfilerBundle] Fix javascript toolbar on IE8 (romainneutron)
 * bug #13987 [WebProfilerBundle] fixed undefined buttons variable. (aitboudad)
 * bug #13953 [Translation][MoFileLoader] fixed load empty translation. (aitboudad)
 * bug #13912 [DependencyInjection] Highest precedence for user parameters (lyrixx)

* 2.6.5 (2015-03-17)

 * bug #13944 [HttpKernel] UriSigner::buildUrl - default params for http_build_query  (Jakub Simon)
 * bug #13896 [ExpressionLanguage] fixed issues when parsing postfix expressions (zerustech)
 * bug #13914 [DependencyInjection] do not inline service factories (xabbuh)
 * bug #13924 [DependencyInjection] resolve class parameters in service factories (xabbuh)
 * bug #13927 Fixing wrong variable name from #13519 (weaverryan)
 * bug #13519 [DependencyInjection] fixed service resolution for factories (fabpot)
 * bug #13790 [acl][command][SecurityBundle] Fixed user input option mode to be an Array (benjaminlong)
 * bug #13902 [Debug] reintroduce charset param to ExceptionHandler (nicolas-grekas)
 * bug #13901 [Bundle] Fix charset config (nicolas-grekas, bamarni)
 * bug #13911 [HttpFoundation] MongoDbSessionHandler::read() now checks for valid session age (bzikarsky)
 * bug #13883 #13857 Added default button class (Piers Warmers)
 * bug #13890 Fix XSS in Debug exception handler (fabpot)
 * bug #13860 [VarDumper] Fix "next element is already occupied" (nicolas-grekas)
 * bug #13806 [TwigBridge] Bootstrap Layout - Fix the label of checkbox cannot be empty (ogizanagi)
 * bug #13835 [PropertyAccess] stop overwriting once a reference is reached (3rd) (bananer)
 * bug #13814 [Twig] bootstrap_3_layout.html.twig is traitable (Dusan Kasan)
 * bug #13816 [OptionsResolver] fix allowed values with null (Tobion)
 * bug #13744 minor #13377 [Console] Change greater by greater or equal for isFresh in FileResource (bijibox)
 * bug #13708  [HttpFoundation] fixed param order for Nginx's x-accel-mapping (phansys)
 * bug #13767 [HttpKernel] Throw double-bounce exceptions (nicolas-grekas)
 * bug #13785 [VarDumper] Workaround stringy numeric keys (nicolas-grekas)
 * bug #13769 [Form] NativeRequestHandler file handling fix (mpajunen)
 * bug #13779 [FrameworkBundle] silence E_USER_DEPRECATED in insulated clients (nicolas-grekas)
 * bug #13715 Enforce UTF-8 charset for core controllers (WouterJ)
 * bug #13683 [PROCESS] make sure /dev/tty is readable (staabm)
 * bug #13733 [Process] Fixed PhpProcess::getCommandLine() result (francisbesset)
 * bug #13729 Fix the toolbar JS for IE (stof)
 * bug #13693 [HttpKernel] Fixed DumpDataCollector: dump.name for Windows file paths (King2500)
 * bug #13618 [PropertyAccess] Fixed invalid feedback -> foodback singularization (WouterJ)
 * bug #13685 [WebProfilerBundle] Fix for broken profiler layout (kbond)
 * bug #13636 [WebProfilerBundle] Fixes event listener attaching error in IE (aik099)
 * bug #13630 [Console] fixed ArrayInput, if array contains 0 key. (arima-ryunosuke)
 * bug #13647 [FrameworkBundle] Fix title and placeholder rendering in php form templates (jakzal)
 * bug #13608 Fix form icon position in web profiler (sadikoff)
 * bug #13642 [Translator][Logging] implement TranslatorBagInterface. (aitboudad)
 * bug #13607 [Console] Fixed output bug, if escaped string in a formatted string. (tronsha)
 * bug #13611 [Console] “console help” ignores --raw option (c960657)
 * bug #13466 [Security] Remove ContextListener's onKernelResponse listener as it is used (davedevelopment)
 * bug #12864 [Console][Table] Fix cell padding with multi-byte (ttsuruoka)
 * bug #13201 [FrameworkBundle][config cmd] initialize extension. (aitboudad)
 * bug #13375 [YAML] Fix one-liners to work with multiple new lines (Alex Pott)
 * bug #13545 fixxed order of usage (OskarStark)
 * bug #13577 [HttpKernel] Added use of instantiateController method provided in (#12022) (stavichenko)
 * bug #13567 [Routing] make host matching case-insensitive (Tobion)

* 2.6.4 (2015-02-02)

 * bug #13489 [VarDumper] CSS fix (Arrilot)
 * bug #13441 [VarDumper] fix handling of non-UTF8 strings (nicolas-grekas)
 * bug #13528 [Validator] reject ill-formed strings (nicolas-grekas)
 * bug #13525 [Validator] UniqueEntityValidator - invalidValue fixed. (Dawid Sajdak)
 * bug #13549 [EventDispatcher] Wrong EventDispatcher instance injected in listeners (dosten)
 * bug #13527 [Validator] drop grapheme_strlen in LengthValidator (nicolas-grekas)
 * bug #12649 [Hackday] [Toolbar] Fix info position and icons on small screens (stefanosala)
 * bug #13376 [FrameworkBundle][config] allow multiple fallback locales. (aitboudad)
 * bug #13473 [FrameworkBundle][xsd] added missing logging attribute. (aitboudad)
 * bug #12972 Make the container considered non-fresh if the environment parameters are changed (thewilkybarkid)
 * bug #13309 [Console] fixed 10531 (nacmartin)
 * bug #13352 [Yaml] fixed parse shortcut Key after unindented collection. (aitboudad)
 * bug #13501 [TwigBridge] Fix bootstrap rendering when user explicitly use form_label (lyrixx)
 * bug #13487 [VarDumper] Fixed HtmlDumper with long string (alOneh)
 * bug #13343 [FrameworkBundle] FormDataCollector should be loaded only if form config is enabled (hason)
 * bug #12258 [FrameworkBundle] print error message if server couldn't be started (xabbuh)
 * bug #13039 [HttpFoundation] [Request] fix baseUrl parsing to fix wrong path_info (rk3rn3r)
 * bug #13250 [Twig][Bridge][TranslationDefaultDomain] add support of named arguments. (aitboudad)
 * bug #13332 [Console] ArgvInput and empty tokens (Taluu)
 * bug #13353 [DependencyInjection] Fix missing ExpressionLanguageProviders (szicsu)
 * bug #13293 [EventDispatcher] Add missing checks to RegisterListenersPass (znerol)
 * bug #13262 [Yaml] Improve YAML boolean escaping (petert82, larowlan)
 * bug #13420 [Debug] fix loading order for legacy classes (nicolas-grekas)
 * bug #13421 [FrameworkBundle] fix routing descriptor for options (Tobion)
 * bug #13405 [TwigBridge] exit when Twig environment is not set in the LintCommand (xabbuh)
 * bug #13351 [VarDumper] fix very special vars handling (nicolas-grekas)
 * bug #13371 fix missing comma in YamlDumper (garak)
 * bug #13365 [HttpFoundation] Make use of isEmpty() method (xelaris)
 * bug #13355 [Console] Helper\Table->addRow optimization (boekkooi)
 * bug #13347 [Console] Helper\TableHelper->addRow optimization (boekkooi)
 * bug #13346 [PropertyAccessor] Allow null value for a array (2.3) (boekkooi)
 * bug #13170 [Form] Set a child type to text if added to the form without a type. (jakzal)
 * bug #13334 [Yaml] Fixed #10597: Improved Yaml directive parsing (VictoriaQ)
 * bug #13198 [Form] Fixed check of violation constraint #12792 (xelaris)
 * bug #13316 [Form] fixed the CSRF extension to allow using only the new interfaces (fabpot)
 * bug #13307 added missing support for factories in console descriptions (fabpot)
 * bug #13305 [FrameworkBundle] fixed missing information in some descriptors (fabpot)

* 2.6.3 (2015-01-07)

 * bug #13286 [Security] Don't destroy the session on buggy php releases. (derrabus)

* 2.6.2 (2015-01-07)

 * feature #13241 [Form] add back model_timezone and view_timezone options (xabbuh)
 * bug #13297 [Process] Fix input reset in WindowsPipes (mpajunen)
 * bug #12417 [HttpFoundation] Fix an issue caused by php's Bug #66606. (wusuopu)
 * bug #13200 Don't add Accept-Range header on unsafe HTTP requests (jaytaph)
 * bug #12491 [Security] Don't send remember cookie for sub request (blanchonvincent)
 * bug #12574 [HttpKernel] Fix UriSigner::check when _hash is not at the end of the uri (nyroDev)
 * bug #13185 Fixes Issue #13184 - incremental output getters now return empty strings (Bailey Parker)
 * bug #13153 [TwigBridge] bootstrap_3_layout.html.twig inline form rendering button problem fix #13150  (edvinasme)
 * bug #13183 [DependencyInjection] force ExpressionLanguage version >= 2.6 (xabbuh)
 * bug #13173 [Debug] fixes ClassNotFoundFatalErrorHandler to correctly handle class not found errors with Symfony ClassLoader component autoloaders. (hhamon)
 * bug #13166 Fix a web profiler form issue with fields added to the form after the form was built (jakzal)
 * bug #12911 Fix wrong DateTransformer timezone param for non-UTC configuration (Soullivaneuh)
 * bug #13145 [DomCrawler] Fix behaviour with <base> tag (dkop, WouterJ)
 * bug #13027 fix #10054 - form data collector with dynamic fields (zulus)
 * bug #13141 [TwigBundle] Moved the setting of the default escaping strategy from the Twig engine to the Twig environment (fabpot)
 * bug #13114 [HttpFoundation] fixed error when an IP in the X-Forwarded-For HTTP head... (fabpot)
 * bug #12572 [HttpFoundation] fix checkip6 (Neime)
 * bug #13109 [Filesystem] restore ability to create broken symlinks (nicolas-grekas)
 * bug #13093 [TwigBundle] added missing absolute URL in Twig exceptions (fabpot)
 * bug #13087 [DependencyInjection] use/fix newest Definition::setFactory (nicolas-grekas)
 * bug #12975 [FrameworkBundle] Allow custom services for validator mapping cache. (jakzal)
 * bug #13068 Add LegacyPdoSessionHandler class (jeremylivingston)
 * bug #13075 [Config] fix error handler restoration in test (nicolas-grekas)
 * bug #13073 [VarDumper] fix and test PdoCaster (nicolas-grekas)
 * bug #13085 [FrameworkBundle] Fix dependency on ExtensionInterface over implementation (xphere)
 * bug #13081 [FrameworkBundle] forward error reporting level to insulated Client (nicolas-grekas)
 * bug #13053 [FrameworkBundle] Fixed Translation loader and update translation command. (saro0h)
 * bug #12900 [WebProfilerBundle] Fixed IE8 support (korotovsky)
 * bug #13047 [FrameworkBundle][Logging Translator] skip if param "translator.logging" doesn't exist. (aitboudad)
 * bug #13048 [Security] Delete old session on auth strategy migrate (xelaris)
 * bug #13035 Added the function providers as container resources (stof)
 * bug #13021 [FrameworkBundle] skip compiler pass if interface doesn't exist (xabbuh)
 * bug #12999 [FrameworkBundle] fix cache:clear command (nicolas-grekas)
 * bug #13004 add a limit and a test to FlattenExceptionTest. (Daniel Wehner)
 * bug #13013 Unify the way to provide expression functions for the DI container (stof)
 * bug #13009 [DebugBundle] fix link format handling with disabled templating (xabbuh)
 * bug #12996 [WebProfilerBundle] Fix placeholder date format (mvar)
 * bug #12961 fix session restart on PHP 5.3 (Tobion)
 * bug #12548 [Form] fixed a maxlength overring on a guessing (origaminal)
 * bug #12761 [Filesystem] symlink use RealPath instead LinkTarget (aitboudad)
 * bug #12848 [EventDispatcher] Fixed #12845 adding a listener to an event that is currently being dispatched (Pieter Jordaan)
 * bug #12935  [Security] Fixed ExpressionVoter - addExpressionLanguageProvider (Luca Genuzio)
 * bug #12855 [DependencyInjection] Perf php dumper (nicolas-grekas)
 * bug #12899 [WebProfiler] Tweaked ajax requests toolbar css reset (1ed)
 * bug #12913 Fix missing space in label_attr (garak)
 * bug #12894 [FrameworkBundle][Template name] avoid  error message for the shortcut n... (aitboudad)
 * bug #12806 [Console] Removed the use of $this->getHelperSet() as it is null by default (saro0h)
 * bug #12858 [ClassLoader] Fix undefined index in ClassCollectionLoader (szicsu)

* 2.6.1 (2014-12-03)

 * bug #12823 [DependencyInjection] fix PhpDumper (nicolas-grekas)
 * bug #12811 Configure firewall's kernel exception listener with configured entry point or a default entry point (rjkip)
 * bug #12770 [Filesystem] fix lock file permissions (nicolas-grekas)
 * bug #12784 [DependencyInjection] make paths relative to __DIR__ in the generated container (nicolas-grekas)
 * bug #12716 [ClassLoader] define constant only if it wasn't defined before (xabbuh)

* 2.6.0 (2014-11-28)

 * bug #12553 [Debug] fix error message on double exception (nicolas-grekas)
 * bug #12550 [FrameworkBundle] backport #12489 (xabbuh)
 * bug #12437  [Validator] make DateTime objects represented as strings in the violation message (hhamon)
 * bug #12575 [WebProfilerBundle] Remove usage of app.request in search bar template (jeromemacias)
 * bug #12570 Fix initialized() with aliased services (Daniel Wehner)

* 2.6.0-BETA2 (2014-11-23)

 * bug #12555 [Debug] fix ENT_SUBSTITUTE usage (nicolas-grekas)
 * feature #12538 [FrameworkBundle] be smarter when guessing the document root (xabbuh)
 * bug #12539 [TwigBundle] properly set request attributes in controller test (xabbuh)
 * bug #12267 [Form][WebProfiler] Empty form names fix (kix)
 * bug #12137 [FrameworkBundle] cache:clear command fills *.php.meta files with wrong data (Strate)
 * bug #12525 [Bundle][FrameworkBundle] be smarter when guessing the document root (xabbuh)
 * bug #12296 [SecurityBundle] Authentication entry point is only registered with firewall exception listener, not with authentication listeners (rjkip)
 * bug #12446 [Twig/DebugBundle] move dump extension registration (nicolas-grekas)
 * bug #12489 [FrameworkBundle] Fix server run in case the router script does not exist (romainneutron)
 * feature #12404 [Form] Remove timezone options from DateType and TimeType (jakzal)
 * bug #12487 [DomCrawler] Added support for 'link' tags in the Link class (StephaneSeng)
 * bug #12490 [FrameworkBundle] Fix server start in case the PHP binary is not found (romainneutron)
 * bug #12443 [HttpKernel] Adding support for invokable controllers in the RequestDataCollector (jameshalsall)
 * bug #12393 [DependencyInjection] inlined factory not referenced (boekkooi)
 * bug #12411 [VarDumper] Use Unicode Control Pictures (nicolas-grekas)
 * bug #12436 [Filesystem] Fixed case for empty folder (yosmanyga)

* 2.6.0-BETA1 (2014-11-03)

 * first beta release

