<p align="center"><a href="https://symfony.com" target="_blank">
    <img src="https://symfony.com/logos/symfony_black_02.svg">
</a></p>

[Symfony][1] is a **PHP framework** for web and console applications and a set
of reusable **PHP components**. Symfony is used by thousands of web
applications and most of the [popular PHP projects][2].

Installation
------------

* [Install Symfony][4] with Composer (see [requirements details][3]).
* Symfony follows the [semantic versioning][5] strictly, publishes "Long Term
  Support" (LTS) versions and has a [release process][6] that is predictable and
  business-friendly.

Sponsor
-------

Symfony 6.4 is [backed][27] by
- [SensioLabs][28]
- [packagist.com][29]

As the creator of Symfony, **SensioLabs** supports companies using Symfony,
with an offering encompassing consultancy, expertise, services, training, and
technical assistance to ensure the success of web application development projects.

Private **Packagist.com** is a fast, reliable, and secure Composer repository for
your private packages. It mirrors all your open-source dependencies for better
availability and monitors them for security vulnerabilities.

Help Symfony by [sponsoring][30] its development!

Documentation
-------------

* Read the [Getting Started guide][7] if you are new to Symfony.
* Try the [Symfony Demo application][23] to learn Symfony in practice.
* Discover Symfony ecosystem in detail with [Symfony The Fast Track][26].
* Master Symfony with the [Guides and Tutorials][8], the [Components docs][9]
  and the [Best Practices][10] reference.

Community
---------

* [Join the Symfony Community][11] and meet other members at the [Symfony events][12].
* [Get Symfony support][13] on GitHub Discussions, Slack, etc.
* Follow us on [GitHub][14], [Twitter][15] and [Facebook][16].
* Read our [Code of Conduct][24] and meet the [CARE Team][25].

Contributing
------------

Symfony is an Open Source, community-driven project with thousands of
[contributors][19]. Join them [contributing code][17] or [contributing documentation][18].

Security Issues
---------------

If you discover a security vulnerability within Symfony, please follow our
[disclosure procedure][20].

About Us
--------

Symfony development is led by the [Symfony Core Team][22]
and supported by [Symfony contributors][19].

[1]: https://symfony.com
[2]: https://symfony.com/projects
[3]: https://symfony.com/doc/current/reference/requirements.html
[4]: https://symfony.com/doc/current/setup.html
[5]: https://semver.org
[6]: https://symfony.com/doc/current/contributing/community/releases.html
[7]: https://symfony.com/doc/current/page_creation.html
[8]: https://symfony.com/doc/current/index.html
[9]: https://symfony.com/doc/current/components/index.html
[10]: https://symfony.com/doc/current/best_practices/index.html
[11]: https://symfony.com/community
[12]: https://symfony.com/events/
[13]: https://symfony.com/support
[14]: https://github.com/symfony
[15]: https://twitter.com/symfony
[16]: https://www.facebook.com/SymfonyFramework/
[17]: https://symfony.com/doc/current/contributing/code/index.html
[18]: https://symfony.com/doc/current/contributing/documentation/index.html
[19]: https://symfony.com/contributors
[20]: https://symfony.com/security
[22]: https://symfony.com/doc/current/contributing/code/core_team.html
[23]: https://github.com/symfony/symfony-demo
[24]: https://symfony.com/coc
[25]: https://symfony.com/doc/current/contributing/code_of_conduct/care_team.html
[26]: https://symfony.com/book
[27]: https://symfony.com/backers
[28]: https://sensiolabs.com
[29]: https://packagist.com
[30]: https://symfony.com/sponsor
