CHANGELOG for 3.3.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 3.3 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v3.3.0...v3.3.1

* 3.3.0 (2017-05-29)

 * bug #22940 [Config] Fallback to regular import when glob fails (nicolas-grekas)
 * bug #22847 [Console] ChoiceQuestion must have choices (ro0NL)
 * bug #22900 [FrameworkBundle][Console] Fix the override of a command registered by the kernel (aaa2000)
 * bug #22930 Revert "bug #22925 [PhpUnitBridge] Adjust PHPUnit class_alias check (nicolas-grekas)
 * bug #22910 [Filesystem] improve error handling in lock() (xabbuh)
 * bug #22924 [Cache] Dont use pipelining with RedisCluster (nicolas-grekas)
 * bug #22928 [WebProfilerBundle] Fixed options stub values display in form profiler (HeahDude)
 * feature #22838 Make the simple exception pages match the new style (javiereguiluz)
 * bug #22925 [PhpUnitBridge] Adjust PHPUnit class_alias check to also check for namespaced class (GawainLynch)
 * bug #22718 [Console] Fixed different behaviour of key and value user inputs in multiple choice question (borNfreee)
 * bug #22921 [FrameworkBundle] Only override getProjectDir if it exists in the kernel (aschempp)
 * feature #22905 [FrameworkBundle][Validator] Move the PSR-11 factory to the component (ogizanagi)
 * bug #22728 [HttpKernel] Fix kernel.project_dir extensibility (chalasr)
 * bug #22829 [Yaml] fix colon without space deprecation (xabbuh)
 * bug #22901 Fix missing abstract key in XmlDumper (weaverryan)
 * bug #22912 [DI] Avoid private call to Container::has() (ro0NL)
 * feature #22904 [HttpFoundation] Add Request::HEADER_X_FORWARDED_AWS_ELB const (nicolas-grekas)
 * bug #22878 [Yaml] parse PHP constants in mapping keys (xabbuh)
 * bug #22873 [HttpKernel] don't call getTrustedHeaderName() if possible (xabbuh)
 * feature #22892 [ProxyManager] Add FC layer (nicolas-grekas)
 * bug #22866 [DI] Check for privates before shared services (ro0NL)
 * feature #22884 [DI] Add missing deprecation on Extension::getClassesToCompile (nicolas-grekas)
 * bug #22874 [WebProfilerBundle] Fix sub-requests display in time profiler panel (nicolas-grekas)
 * bug #22853 [Yaml] fix multiline block handling (xabbuh)
 * bug #22872 [FrameworkBundle] Handle project dir in cache:clear command (nicolas-grekas)
 * feature #22808 [FrameworkBundle][Validator] Deprecate passing validator instances/aliases over using the service locator (ogizanagi)
 * bug #22857 [DI] Fix autowire error for inlined services (weaverryan)
 * bug #22858 [SecurityBundle] Prevent auto-registration of UserPasswordEncoderCommand (chalasr)
 * bug #22859 [Profiler][VarDumper] Fix searchbar css when in toolbar (ogizanagi)
 * bug #22614 [Process]  Fixed escaping arguments on Windows when inheritEnvironmentVariables is set to false (maryo)
 * bug #22817 [PhpUnitBridge] optional error handler arguments (xabbuh)
 * bug #22781 [DI][Serializer] Fix missing de(normalizer|coder) autoconfig (ogizanagi)
 * bug #22790 [DependencyInjection] Fix dumping of RewindableGenerator with empty IteratorArgument (meyerbaptiste)
 * bug #22787 [MonologBridge] Fix the Monlog ServerLogHandler from Hanging on Windows (ChadSikorra)
 * bug #22768 Use 0.0.0.0 as the server log command host default. (ChadSikorra)
 * bug #22752 Improved how profiler errors are displayed on small screens (javiereguiluz)

* 3.3.0-RC1 (2017-05-17)

 * bug #22715 [FrameworkBundle] remove Security deps from the require section (xabbuh)
 * bug #22613 [Process] Fix incorrectly calling PHP process when path contains space (maryo)
 * feature #22680 [DI] Fixing missing "exclude" functionality from PSR4 loader (weaverryan)
 * bug #22699 [TwigBundle] service workflow.twig_extension should stay public (ogizanagi)
 * feature #22708 Adding autowire alias for AuthenticationUtils (weaverryan)
 * bug #22695 [WebServerBundle] fix dependencies (xabbuh)
 * bug #22647 [VarDumper] Fix dumping of non-nested stubs (nicolas-grekas)
 * bug #22409 [Yaml] respect inline level when dumping objects as maps (goetas, xabbuh)
 * bug #22584 [Security] Avoid unnecessary route lookup for empty logout path (ro0NL)
 * bug #22642 [DX] Making the RegisterControllerArgumentLocatorsPass throw exception on bad types (weaverryan)
 * bug #22664 [Security] Fix TraceableAccessDecisionManager / DebugAccessDecisionManager BC layer (ogizanagi)
 * bug #22690 [Console] Fix errors not rethrown even if not handled by console.error listeners (chalasr)
 * bug #22681 Fixing a bug where abstract classes were wired with the prototype loader (weaverryan)
 * feature #22665 [DI] Do not throw autowiring exceptions for a service that will be removed (weaverryan)
 * bug #22669 [FrameworkBundle] AbstractConfigCommand: do not try registering bundles twice (ogizanagi)
 * bug #22676 [FrameworkBundle] Adding the extension XML (flug)
 * bug #22611 [FrameworkBundle] Fix "Locale class not found" in AboutCommand (rubenrua)
 * bug #22677 [DI] Fixed index args bug with ResolveNamedArgumentsPass (weaverryan)
 * bug #22652 [Workflow] Move twig extension registration to twig bundle (ogizanagi)
 * feature #22668 [FrameworkBundle] KernelTestCase: allow to provide the kernel class with a var (ogizanagi)
 * bug #22639 [WebLink][TwigBundle] Fix registration of the twig extension (ogizanagi)
 * bug #22658 Make the exception pages work when the WebProfilerBundle is not installed (javiereguiluz)
 * bug #22657 [DI] Fix Cannot declare class ...\DefinitionDecorator, because the name is already in use (ogizanagi)
 * feature #22624 debug:container --types (classes/interfaces) (weaverryan)
 * bug #22626 Fix missing parenthesis (yceruto)
 * bug #22621 [Config] Fix resource tracking with new GlobResource (nicolas-grekas)
 * feature #22385 [DX][FrameworkBundle] Show private aliases in debug:container (chalasr)
 * bug #22615 [DI] Defaults to public=false in all service config files (nicolas-grekas)

* 3.3.0-BETA1 (2017-05-01)

 * feature #22530 Making tags under _defaults always apply (weaverryan)
 * feature #22590 [Lock] remove the component from 3.3 (fabpot)
 * feature #22527 [DI] Throw useful exception on bad XML argument tags (nicolas-grekas)
 * feature #22537 [Serializer] Allow to pass csv encoder options in context (ogizanagi)
 * feature #22563 Not allowing autoconfigure, instanceofConditionals or defaults for ChildDefinition (weaverryan)
 * feature #22441 [Console] Review console.ERROR related behavior (nicolas-grekas)
 * feature #22234 [DI] Introducing autoconfigure: automatic _instanceof configuration (weaverryan)
 * feature #21502 Persist app bootstrapping logs for logger datacollector (ScullWM, nicolas-grekas)
 * feature #22459 [HttpKernel] Fix deprecation of Extension::addClassesToCompile() / AddClassesToCachePass (nicolas-grekas)
 * feature #22416 [FrameworkBundle][Workflow] Deprecate the default type of a workflow (lyrixx)
 * feature #22313 [Workflow] Move ValidateWorkflowsPass to the Workflow component (chalasr)
 * feature #22420 [DI] Make tagged abstract services throw earlier (nicolas-grekas)
 * feature #22384 [DI] Replace autowiring BC break by regular deprecation (nicolas-grekas)
 * feature #22383 added a more specialized exception for a better error message (fabpot)
 * feature #22356 [DI] Rework config hierarchy: defaults > instanceof > service config (weaverryan, nicolas-grekas)
 * feature #22362 [DI] Populate class of ChildDefinition when its id matches an existing FQCN (nicolas-grekas)
 * feature #22239 [Finder] Glob wildcard while using double-star without ending slash (sroze)
 * feature #22273 Add a new Link component (dunglas)
 * feature #22315 Add Kernel::getProjectDir() (fabpot)
 * feature #22314 [HttpKernel][FrameworkBundle] Dump container logs in Kernel, to have them also on errors (nicolas-grekas)
 * feature #22316 [WebServerBundle] added a way to dump current status host/port/address when getting the status (fabpot)
 * feature #22323 [DI] Report cascades of autowiring error messages (nicolas-grekas)
 * feature #22306 [DI] Restrict autowired registration to "same-vendor" namespaces (nicolas-grekas)
 * feature #22295 [BC BREAK][DI] Always autowire "by id" instead of using reflection against all existing services (nicolas-grekas)
 * feature #20951 Redesigned the exception pages (javiereguiluz)
 * feature #21919 [Form] Deprecated usage of "choices" option in sub types (HeahDude)
 * feature #22274 [Yaml] report deprecations when linting YAML files (xabbuh)
 * feature #22286 [DI/Yaml] Remove `@experimental` flag from "instanceof" and "prototype" (nicolas-grekas)
 * feature #22181 [Console] Allow to catch CommandNotFoundException (chalasr)
 * feature #22296 Bump monolog to 1.19 and use the agent regex const from parent (redthor)
 * feature #21437 [Security] Use IteratorArgument for voters (jvasseur)
 * feature #22277 [DI] Add "factory" support to named args and autowiring (nicolas-grekas)
 * feature #22276 [FrameworkBundle] Returns the kernel instance in KernelTestCase::bootKernel (lyrixx)
 * feature #22256 [DI] Reduce complexity of autowiring (nicolas-grekas)
 * feature #22238 [BC BREAK][HttpFoundation] Request::setTrustedProxies() takes a new required $trustedHeaderSet argument (nicolas-grekas)
 * feature #22175 [DI] add ServiceLocatorTagPass::register() to share service locators (nicolas-grekas)
 * feature #22180 [Workflow] Added 'workflow_marked_places' twig function (lyrixx)
 * feature #22185 [DI] Enhance DX by throwing instead of triggering a deprecation notice (nicolas-grekas)
 * feature #22060 [DI] Add "by-id" autowiring: a side-effect free variant of it based on the class<>id convention (nicolas-grekas)
 * feature #22158 Revert "feature #20973 [DI] Add getter injection (nicolas-grekas)" (nicolas-grekas)
 * feature #22157 [FrameworkBundle] Introduce AbstractController, replacing ControllerTrait (nicolas-grekas)
 * feature #22046 [Asset] Adding a new version strategy that reads from a manifest JSON file (weaverryan)
 * feature #22129 [WebProfilerBundle] Improve cache panel (ro0NL)
 * feature #21819 [Twig Bridge] A simpler way to retrieve flash messages (javiereguiluz)
 * feature #19026 [Security] Strengthen comparison of target_url vs login_path (mrzard)
 * feature #19496 [DX][Form][Validator] Add ability check if cocrete constraint fails. (Koc)
 * feature #18140 [Console] Add console.ERROR event and deprecate console.EXCEPTION (wouterj)
 * feature #22120 [FrameworkBundle] Multiple services on one Command class (SenseException)
 * feature #21771 [FrameworkBundle] Add new "controller.service_arguments" tag to inject services into actions (nicolas-grekas)
 * feature #22114 [lock] Rename Quorum into Strategy (jderusse)
 * feature #20516 [Security][SecurityBundle] Enhance automatic logout url generation (ogizanagi)
 * feature #22081 [FrameworkBundle][Validator] Move Validator passes to the component (chalasr)
 * feature #20567 [WebProfilerBundle] Improved cookie traffic (ro0NL)
 * feature #19887 Sort alternatives alphabetically when a command is not found (javiereguiluz)
 * feature #20851 [Cache] Add CacheItem::getPreviousTags() (nicolas-grekas)
 * feature #21830 [HttpFoundation] Add $trustedHeaderSet arg to Request::setTrustedProxies() - deprecate not setting it (nicolas-grekas)
 * feature #21924 [FrameworkBundle] Allow to configure Serializer mapping paths (chalasr)
 * feature #19278 [FrameworkBundle] Added about command (ro0NL)
 * feature #21708 [DI] Add and wire ServiceSubscriberInterface - aka explicit service locators (nicolas-grekas)
 * feature #22011 [FrameworkBundle][Serializer] Add option to register a circular_reference_handler (lyrixx)
 * feature #19673 [DI] Deprecate Container::isFrozen and introduce isCompiled (ro0NL)
 * feature #19954 [Console] Exclude empty namespaces in text descriptor (ro0NL)
 * feature #21093 [Lock] Create a lock component (jderusse)
 * feature #21007 [WebProfilerBundle] Improve AJAX toolbar panel (ro0NL)
 * feature #20642 [FrameworkBundle] Add project directory default for installing assets (Noah Heck)
 * feature #20365 [TwigBridge] Handle form label attributes like others (ro0NL)
 * feature #22010 [FrameworkBundle][Translator] Make the Translator works with any PSR-11 container (chalasr)
 * feature #21038 [FrameworkBundle] deprecated cache:clear with warmup (fabpot)
 * feature #22098 [*Bundle] Add autowiring aliases for common services (nicolas-grekas)
 * feature #22095 [DI] Add logging and better failure recovery to AutowirePass (nicolas-grekas)
 * feature #21889 Deprecate the special SYMFONY__ environment variables (javiereguiluz)
 * feature #22059 [Yaml] deprecate "? " starting unquoted strings (xabbuh)
 * feature #22030 [DI] Remove skipping magic for autowired methods (nicolas-grekas)
 * feature #22024 [DI] Introduce "container.service_locator" tag, replaces ServiceLocatorArgument (nicolas-grekas)
 * feature #21837 [FrameworkBundle] Lazy configuration of annotations' loader and `@required` (nicolas-grekas)
 * feature #21970 [DependencyInjection] Support anonymous services in Yaml (GuilhemN)
 * feature #21979 [FrameworkBundle][TwigBundle] Require PSR-11 container instead of Symfony container (enumag)
 * feature #21935 [FrameworkBundle][Workflow] Add a way to register a guard expression in the configuration (lyrixx)
 * feature #21080 [FrameworkBundle][Monolog] Added a new way to follow logs (lyrixx)
 * feature #21978 [DoctrineBridge][Routing] Require PSR-11 container instead of Symfony container (enumag)
 * feature #21950 [Workflow] Added fluent interface to the DefinitionBuilder (lyrixx)
 * feature #21933 [FrameworkBundle][Workflow] Add a way to enable the AuditTrail Logger (lyrixx)
 * feature #21925 [Workflow] Added the workflow name to all events dispatched (lyrixx)
 * feature #21774 [Yaml] deprecate implicit string casting of mapping keys (xabbuh)
 * feature #21780 [DX] [Form] Add helper method to register form extensions during unit testing (pierredup)
 * feature #21842 [HttpKernel] Allow signing URIs with a custom query string parameter (thewilkybarkid)
 * feature #21705 [Bridge/Monolog] Enhance the Console Handler (lyrixx)
 * feature #21893 Added a castToArray() config helper (javiereguiluz)
 * feature #21421 Use proper error message when session write fails #20807 (digilist)
 * feature #21770 [DI] Allow extensions to create ServiceLocator as services (nicolas-grekas)
 * feature #21767 [DI][Router][DX] Invalidate routing cache when container parameters changed (ogizanagi)
 * feature #21835 [FrameworkBundle][Routing] Move RoutingResolverPass to the Routing component (chalasr)
 * feature #21815 [FrameworkBundle][HttpKernel] Move ControllerArgumentValueResolverPass to the HttpKernel component (chalasr)
 * feature #21824 Add deprecation note on routing class parameters (lepiaf)
 * feature #21854 [Router] Follow symlinks and skip dots in the annotation directory loader (jakzal)
 * feature #18193 [FrameworkBundle] Introduce autowirable ControllerTrait (dunglas)
 * feature #20680 DoctrineDataCollector: taught sanitizeParam to support classes with __toString implemented. (FractalizeR)
 * feature #21828 [PhpUnitBridge] include expected deprecations in assertion counter (xabbuh)
 * feature #21763 [DI] Replace wildcard-based methods autowiring by `@required` annotation (nicolas-grekas)
 * feature #21730 [DependencyInjection] Use a service locator in AddConstraintValidatorsPass (GuilhemN)
 * feature #21118 [Yaml] parse omitted inlined mapping values as null (xabbuh)
 * feature #21806 [FrameworkBundle][PropertyInfo] Move PropertyInfoPass to the PropertyInfo component (chalasr)
 * feature #19822 [HttpKernel] Deprecate X-Status-Code for better alternative (jameshalsall)
 * feature #21228 [Console] Explicitly passed options without value (or empty) should remain empty (chalasr)
 * feature #21723 [Routing][DX] Add full route definition for invokable controller/class (yceruto)
 * feature #21768 [HttpKernel] Add a ContainerControllerResolver (psr-11) (ogizanagi)
 * feature #21690 [Form] allow form types + form type extensions + form type guessers to be private services (hhamon)
 * feature #21755 [Routing] Optimised dumped router matcher, prevent unneeded function calls. (frankdejonge)
 * feature #21375 [FrameworkBundle][Config] Move ConfigCachePass from FrameworkBundle to Config (Deamon)
 * feature #21786 [PhpUnitBridge] testing for deprecations is not risky (xabbuh)
 * feature #21792 [Security] deprecate multiple providers in context listener (xabbuh)
 * feature #21625 Remove some container injections in favor of service locators (nicolas-grekas, chalasr)
 * feature #21539 Introduce weak vendors mode (greg0ire)
 * feature #21638 [VarDumper] Allow seamless use of Data clones (nicolas-grekas)
 * feature #21164 [HttpKernel] Added the SessionValueResolver (iltar)
 * feature #21718 [SecurityBundle] Don't normalize username of in-memory users (chalasr)
 * feature #20107 Added a build method to the kernel to replace Bundle::build() (iltar)
 * feature #21694 [Bridge/PhpUnit] Add PHPUnit 6 support (nicolas-grekas)
 * feature #21122 [ExpressionLanguage] Create an ExpressionFunction from a PHP function name (maidmaid)
 * feature #21653 [VarDumper] Added a way to print or not comma separator and/or trailing comma (lyrixx)
 * feature #21471 [Yaml] Allow dumping empty array as YAML sequence (c960657)
 * feature #21478 [Asset] Add support for preloading with links and HTTP/2 push (dunglas)
 * feature #20632 [FrameworkBundle] Make use of stderr for non reliable output (chalasr, ogizanagi)
 * feature #21664 [Console] simplify the implementation of SymfonyStyle::comment() (fabpot)
 * feature #21578 [Translation] Added a lint:xliff command for XLIFF files (javiereguiluz)
 * feature #21635 added support for glob loaders in Config (fabpot)
 * feature #21654 [PropertyInfo] Use iterators for PropertyInfoExtractor (GuilhemN)
 * feature #21655 [PropertyInfo] Make classes final (GuilhemN)
 * feature #21530 [DependencyInjection] Add "instanceof" section for local interface-defined configs (nicolas-grekas, dunglas)
 * feature #21643 [Yaml] deprecate parsing mappings without keys (xabbuh)
 * feature #20677 [DX][SecurityBundle] UserPasswordEncoderCommand: ask user class choice question (ogizanagi)
 * feature #21283 [Form][FrameworkBundle] Move FormPass to the Form component (chalasr)
 * feature #21293 [FrameworkBundle][Serializer] Move SerializerPass to the Serializer (chalasr)
 * feature #21450 [Security] Lazy load guard authenticators and authentication providers (chalasr)
 * feature #21484 [DI] Deprecate underscore-services in YamlFileLoader (nicolas-grekas)
 * feature #21270 [DependencyInjection] Use glob pattern to load config files (pierredup)
 * feature #19815 [WebProfilerBundle] Make the IP address in the profiler header clickable (jameshalsall)
 * feature #21383 [DependencyInjection] Add support for named arguments (dunglas, nicolas-grekas)
 * feature #19371 [Serializer] Give access to the context to support* methods (dunglas)
 * feature #21553 [DI] Replace container injection by explicit service locators (chalasr)
 * feature #18834 [Serializer] Add the possibility to filter attributes (dunglas)
 * feature #20787 [Workflow] Added an entered event (Padam87)
 * feature #21289 [DI] Add prototype services for PSR4-based discovery and registration (nicolas-grekas)
 * feature #21465 [Debug] Support `@final` on methods (GuilhemN)
 * feature #21505 [Config][DI] Add ComposerResource to track the runtime engine + deps (nicolas-grekas)
 * feature #21533 [DI] Deprecate (un)setting pre-defined services (ro0NL)
 * feature #21194 [Yaml] Add tags support (GuilhemN)
 * feature #21460 [DI] ContainerBuilder::compile() can optionally resolve env vars in parameter bag (nicolas-grekas)
 * feature #21572 [Finder] Add double-star matching to Glob::toRegex() (nicolas-grekas)
 * feature #21265 [DI] Implement PSR-11 (greg0ire)
 * feature #21474 [Process] Accept command line arrays and per-run env vars, fixing signaling and escaping (nicolas-grekas)
 * feature #21517 [FrameworkBundle] Add missing autowiring aliases for common interfaces (chalasr)
 * feature #21516 [HttpKernel][FrameworkBundle] Lazy load argument value resolvers (chalasr)
 * feature #21031 [DI] Getter autowiring (dunglas)
 * feature #21419 [DI][Config] Add & use ReflectionClassResource (nicolas-grekas)
 * feature #21455 [DI] Allow to count on lazy collection arguments (ogizanagi)
 * feature #21408 [DI] Add ContainerBuilder::fileExists() for checking/tracking resource existence (chalasr)
 * feature #21470 [Process] Deprecate not inheriting env vars + compat related settings (nicolas-grekas)
 * feature #21494 [DI] Deprecate autowiring-types in favor of aliases (nicolas-grekas)
 * feature #21451 [SecurityBundle] Lazy load request matchers in FirewallMap (chalasr)
 * feature #20973 [DI] Add getter injection (nicolas-grekas)
 * feature #21396 [DI] Enhance logging in compiler passes (nicolas-grekas)
 * feature #21402 [Security] make LdapBindAuthenticationProvider capable of searching for the DN (lsmith77, nietonfir)
 * feature #21404 [DI] Generalize constructor autowiring to partial method calls (nicolas-grekas)
 * feature #21388 [Debug] Deprecate ContextErrorException (nicolas-grekas)
 * feature #20943 [DependencyInjection] Use current class as default class for factory declarations (ogizanagi)
 * feature #21003 [Console][FrameworkBundle] Log console exceptions (jameshalsall, chalasr)
 * feature #21313 [DI] Add Yaml syntax for short services definition (ogizanagi)
 * feature #20694 [Cache] Implement PSR-16 SimpleCache v1.0 (nicolas-grekas)
 * feature #21327 [DI] Factorize compiler passes around new AbstractRecursivePass (nicolas-grekas)
 * feature #19086 [FrameworkBundle] add "mapping" configuration key at validation secti… (davewwww)
 * feature #21350 [Yaml] Remove internal arguments from the api (GuilhemN)
 * feature #21353 [ClassLoader] Deprecated the component (nicolas-grekas)
 * feature #21334  [Workflow] Introduce concept of SupportStrategyInterface (andesk, lyrixx)
 * feature #20390 [Ldap] added Ldap entry rename for ExtLdap adapter (fruitwasp)
 * feature #21065 Added cache data collector and profiler page (Nyholm)
 * feature #21306 [DependencyInjection] Always autowire the constructor (dunglas)
 * feature #20493 [Debug] Trigger deprecation on `@final` annotation in DebugClassLoader - prepare making some classes final (GuilhemN)
 * feature #21244 [DI] Remove synthetic services from methodMap + generated methods (nicolas-grekas)
 * feature #21238 [VarDumper] Add search keyboard shortcuts (ogizanagi)
 * feature #21290 [FrameworkBundle] Fix debug:container --show-arguments missing cases (chalasr)
 * feature #21263 [DI] Mark generated containers as final (nicolas-grekas)
 * feature #21253 [TwigBridge][Worklow] Added a new workflow_has_place function (Padam87, lyrixx)
 * feature #21234 Add a new Dotenv component (fabpot)
 * feature #20861 Add a --show-arguments flag to the debug:container command (Cydonia7)
 * feature #21223 [DI] Deprecate case insentivity of service identifiers (nicolas-grekas)
 * feature #20887 [Form] DateIntervalType: Allow to configure labels & enhance form theme (ogizanagi)
 * feature #19443 [Console] Move AddConsoleCommandPass from FrameworkBundle to Console. (bcremer)
 * feature #21231 [FrameworkBundle] allow to reference files directly from kernel.root_dir (fabpot)
 * feature #20611 [DI] FileLoaders: Allow to explicit type to load (ogizanagi)
 * feature #20689 [Config][FrameworkBundle] Allow to dump extension config reference sub-path (ogizanagi)
 * feature #21188 [HttpFoundation] Add File\Stream for size-unknown BinaryFileResponse (nicolas-grekas)
 * feature #21214 [DI] Allow ~ instead of {} for services in Yaml (wouterj)
 * feature #20612 [Filesystem] Add appendToFile() (chalasr)
 * feature #20612 [Filesystem] Add appendToFile() (chalasr)
 * feature #21114 [Yaml] parse multi-line strings (xabbuh)
 * feature #21196 [FrameworkBundle] changed some default configs from canBeEnabled to canBeDisabled (fabpot)
 * feature #20937 [EventDispatcher] Deprecate ContainerAwareEventDispatcher (nicolas-grekas)
 * feature #21190 [WebServerBundle] Decouple server commands from the container (chalasr)
 * feature #21071 [DI] Add "inherit-tags" with configurable defaults + same for "public", "tags" & "autowire" (nicolas-grekas, ogizanagi)
 * feature #21133 [DI] Optional class for named services (hason, nicolas-grekas)
 * feature #20953 [DI][EventDispatcher] Add & wire closure-proxy argument type (nicolas-grekas)
 * feature #20586 [Console] Ease writing to stderr using SymfonyStyle (chalasr)
 * feature #20547 [FrameworkBundle] Allowed symlinks when searching for translation, searialization and validation files (tifabien)
 * feature #20735 Deprecate ClassCollectionLoader and Kernel::loadClassCache (dbrumann)
 * feature #21140 [PhpUnitBridge] deprecate the testLegacy test name prefix (xabbuh)
 * feature #21109 [Profiler][VarDumper] Add a search feature to the HtmlDumper (ogizanagi)
 * feature #21039 Web server bundle (fabpot)
 * feature #20907 [DependencyInjection] Implement lazy collection type using generators (tgalopin, nicolas-grekas)
 * feature #21075 [Console] Show hidden commands in json & xml descriptors (ogizanagi)
 * feature #21129 [FrameworkBundle] Display original definition for aliases in debug:container (chalasr)
 * feature #21108 [Cache] Add DSN, createClient & better error reporting to MemcachedAdapter (nicolas-grekas, robfrawley)
 * feature #21147 [PhpUnitBridger] Bump simple-phpunit to PHPUnit 5.7 by default (nicolas-grekas)
 * feature #21112 [PhpUnitBridge] run PHPUnit in the same process (xabbuh)
 * feature #21106 [Validator] support DateTimeInterface instances for times (xabbuh)
 * feature #20809 [FrameworkBundle] Display the controller class name in 'debug:router' (lyrixx)
 * feature #21082 [Cache] TraceableAdapter (Nyholm)
 * feature #20938 [DI] Prepare dropping "strict" handling in loaders (nicolas-grekas)
 * feature #20971 [WebProfilerBundle] Split PHP version if needed (ro0NL)
 * feature #20634 [DI] Deprecate dumping an uncompiled container (ro0NL)
 * feature #20923 #20921 [Config] Provide shorthand methods for ArrayNodeDefinition::pr… (skafandri)
 * feature #20569 [HttpFoundation] Create cookie from string + synchronize response cookies (ro0NL)
 * feature #20618 [DI] Make ContainerBuilder::resolveEnvPlaceholders() able to inline the values of referenced env vars. (nicolas-grekas)
 * feature #20962 Request exceptions (thewilkybarkid, fabpot)
 * feature #20928 [FrameworkBundle] don't load translator services if not required (xabbuh)
 * feature #20644 [HttpFoundation] Compute cookie max-age attribute (ro0NL)
 * feature #20167 [DependencyInjection] Make method (setter) autowiring configurable (dunglas)
 * feature #20663 [DependencyInjection] replace DefinitionDecorator by ChildDefinition (xabbuh)
 * feature #20197 [WebProfilerBundle] Improve Ajax Profiling Performance (javascript) (patrick-mcdougle)
 * feature #20487 [Console] Disallow inheritance from ProgressBar (a-ast)
 * feature #20651 [DependencyInjection] Added Yaml syntax shortcut for name-only tags (wouterj)
 * feature #20648 [DependencyInjection] Added a shortcut method for autowired definitions (wouterj)
 * feature #20697 Updated the "PHP config" panel in the profiler (javiereguiluz)
 * feature #20773 [FrameworkBundle] Added GlobalVariables::getToken() (HeahDude)
 * feature #20866 [Console] Improve markdown format (ro0NL)
 * feature #20867 [Console] Include application name/version in JSON descriptions (ro0NL)
 * feature #20869 [Console] Improve UX on not found namespace/command (Seldaek)
 * feature #20858 [Cache] Simple Memcached Adapter (robfrawley)
 * feature #20881 [VarDumper] Add SymfonyCaster::castRequest() (nicolas-grekas)
 * feature #20810 [FrameworkBundle] Allow clearing private cache pools in cache:pool:clear (chalasr)
 * feature #20417 [SecurityBundle] Rename FirewallContext#getContext() (chalasr)
 * feature #20801 [Security] deprecate the RoleInterface (xabbuh)
 * feature #20260 [DependencyInjection] Support autowiring for EventDispatcher/EventDispatcherInterface (chalasr)
 * feature #20777 [ClassLoader] Deprecate Apc/WinCache/Xcache class loaders (nicolas-grekas)
 * feature #20524 [Serializer][XmlEncoder] Allow removing empty tags in generated XML (amoiraud)
 * feature #19958 [Serializer] Throw exception when extra attributes are used during an object denor… (juliendidier)
 * feature #20310 [Ldap] Allow search scoping (xunto)
 * feature #18952 [Security] Add a JSON authentication listener (dunglas)
 * feature #20161 add toolbar & profiler SVG style classes (havvg)
 * feature #20467 [DomCrawler] Add support for formaction and formmethod attributes (stof)
 * feature #20509 [Serializer] Allow to specify a single value in @Groups (dunglas)
 * feature #20722 Updated the "Symfony Config" panel in the profiler (javiereguiluz)

