CHANGELOG for 2.7.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 2.7 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v2.7.0...v2.7.1

* 2.7.51 (2019-04-17)

 * security #cve-2019-10910 [DI] Check service IDs are valid (nicolas-grekas)
 * security #cve-2019-10909 [FrameworkBundle][Form] Fix XSS issues in the form theme of the PHP templating engine - CVE-2019-10909 (stof)
 * security #cve-2019-10911 [Security] Add a separator in the remember me cookie hash (pborreli)
 * security #cve-2019-10913 [HttpFoundation] reject invalid method override (nicolas-grekas)

* 2.7.50 (2018-12-06)

 * security #cve-2018-19790 [Security\Http] detect bad redirect targets using backslashes (xabbuh)
 * security #cve-2018-19789 [Form] Filter file uploads out of regular form types (nicolas-grekas)

* 2.7.49 (2018-08-01)

 * security #cve-2018-14774 [HttpKernel] fix trusted headers management in HttpCache and InlineFragmentRenderer (nicolas-grekas)
 * security #cve-2018-14773 [HttpFoundation] Remove support for legacy and risky HTTP headers (nicolas-grekas)

* 2.7.48 (2018-05-25)

 * bug #27359 [HttpFoundation] Fix perf issue during MimeTypeGuesser intialization (nicolas-grekas)
 * security #cve-2018-11408 [SecurityBundle] Fail if security.http_utils cannot be configured
 * security #cve-2018-11406 clear CSRF tokens when the user is logged out
 * security #cve-2018-11385 Adding session strategy to ALL listeners to avoid *any* possible fixation
 * security #cve-2018-11386 [HttpFoundation] Break infinite loop in PdoSessionHandler when MySQL is in loose mode

* 2.7.47 (2018-05-21)

 * bug #26781 [Form] Fix precision of MoneyToLocalizedStringTransformer's divisions on transform() (syastrebov)
 * bug #27286 [Translation] Add Occitan plural rule (kylekatarnls)
 * bug #27246 Disallow invalid characters in session.name (ostrolucky)
 * bug #24805 [Security] Fix logout (MatTheCat)
 * bug #27141 [Process] Suppress warnings when open_basedir is non-empty (cbj4074)
 * bug #27250 [Session] limiting :key for GET_LOCK to 64 chars (oleg-andreyev)
 * bug #27237 [Debug] Fix populating error_get_last() for handled silent errors (nicolas-grekas)
 * bug #27236 [Filesystem] Fix usages of error_get_last() (nicolas-grekas)
 * bug #27152 [HttpFoundation] use brace-style regex delimiters (xabbuh)
 * feature #24896 Add CODE_OF_CONDUCT.md (egircys)
 * bug #27067 [HttpFoundation] Fix setting session-related ini settings (e-moe)

* 2.7.46 (2018-04-27)

 * bug #26831 [Bridge/Doctrine] count(): Parameter must be an array or an object that implements Countable (gpenverne)
 * bug #27044 [Security] Skip user checks if not implementing UserInterface (chalasr)
 * bug #26910 Use new PHP7.2 functions in hasColorSupport (johnstevenson)
 * bug #26999 [VarDumper] Fix dumping of SplObjectStorage (corphi)
 * bug #26886 Don't assume that file binary exists on *nix OS (teohhanhui)
 * bug #26643 Fix that ESI/SSI processing can turn a "private" response "public" (mpdude)
 * bug #26932 [Form] Fixed trimming choice values (HeahDude)
 * bug #26875 [Console] Don't go past exact matches when autocompleting (nicolas-grekas)
 * bug #26823 [Validator] Fix LazyLoadingMetadataFactory with PSR6Cache for non classname if tested values isn't existing class (Pascal Montoya, pmontoya)
 * bug #26834 [Yaml] Throw parse error on unfinished inline map (nicolas-grekas)

* 2.7.45 (2018-04-06)

 * bug #26763 [Finder] Remove duplicate slashes in filenames (helhum)
 * bug #26749 Add PHPDbg support to HTTP components (hkdobrev)
 * bug #26609 [Console] Fix check of color support on Windows (mlocati)

* 2.7.44 (2018-04-02)

 * bug #26727 [HttpCache] Unlink tmp file on error (Chansig)
 * bug #26675 [HttpKernel] DumpDataCollector: do not flush when a dumper is provided (ogizanagi)
 * bug #26663 [TwigBridge] Fix rendering of currency by MoneyType (ro0NL)
 * bug #26677 Support phpdbg SAPI in Debug::enable() (hkdobrev)
 * bug #26621 [Form] no type errors with invalid submitted data types (xabbuh)
 * bug #26337 [Finder] Fixed leading/trailing / in filename (lyrixx)
 * bug #26584 [TwigBridge] allow html5 compatible rendering of forms with null names (systemist)
 * bug #24401 [Form] Change datetime to datetime-local for HTML5 datetime input (pierredup)
 * bug #26370 [Security] added userChecker to SimpleAuthenticationProvider (i3or1s)
 * bug #26569 [BrowserKit] Fix cookie path handling when $domain is null (dunglas)
 * bug #26598 Fixes #26563 (open_basedir restriction in effect) (temperatur)
 * bug #26568 [Debug] Reset previous exception handler earlier to prevent infinite loop (nicolas-grekas)
 * bug #26567 [DoctrineBridge] Don't rely on ClassMetadataInfo->hasField in DoctrineOrmTypeGuesser anymore (fancyweb)
 * bug #26356 [FrameworkBundle] HttpCache is not longer abstract (lyrixx)
 * bug #26548 [DomCrawler] Change bad wording in ChoiceFormField::untick (dunglas)
 * bug #26433 [DomCrawler] extract(): fix a bug when the attribute list is empty (dunglas)
 * bug #26452 [Intl] Load locale aliases to support alias fallbacks (jakzal)
 * bug #26450 [CssSelector] Fix CSS identifiers parsing - they can start with dash (jakubkulhan)

* 2.7.43 (2018-03-05)

 * bug #26368 [WebProfilerBundle] Fix Debug toolbar breaks app (xkobal)

* 2.7.42 (2018-02-28)

 * bug #26338 [Debug] Keep previous errors of Error instances (Philipp91)
 * bug #26312 [Routing] Don't throw 405 when scheme requirement doesn't match (nicolas-grekas)
 * bug #26298 Fix ArrayInput::toString() for InputArgument::IS_ARRAY args (maximium)
 * bug #25557 [WebProfilerBundle] add a way to limit ajax request (Simperfit)
 * bug #26228 [HttpFoundation] Fix missing "throw" in JsonResponse (nicolas-grekas)
 * bug #26211 [Console] Suppress warning from sapi_windows_vt100_support (adawolfa)
 * bug #26156 Fixes #26136: Avoid emitting warning in hasParameterOption() (greg-1-anderson)
 * bug #26183 [DI] Add null check for removeChild (changmin.keum)
 * bug #26159 created validator.tl.xlf for Form/Translations (ergiegonzaga)
 * bug #26100 [Routing] Throw 405 instead of 404 when redirect is not possible (nicolas-grekas)
 * bug #26040 [Process] Check PHP_BINDIR before $PATH in PhpExecutableFinder (nicolas-grekas)
 * bug #26012 Exit as late as possible (greg0ire)
 * bug #25893 [Console] Fix hasParameterOption / getParameterOption when used with multiple flags (greg-1-anderson)
 * bug #25940 [Form] keep the context when validating forms (xabbuh)
 * bug #25373 Use the PCRE_DOLLAR_ENDONLY modifier in route regexes (mpdude)
 * bug #26010 [CssSelector] For AND operator, the left operand should have parentheses, not only right operand (Arnaud CHASSEUX)
 * bug #25971 [Debug] Fix bad registration of exception handler, leading to mem leak (nicolas-grekas)
 * bug #25962 [Routing] Fix trailing slash redirection for non-safe verbs (nicolas-grekas)
 * bug #25948 [Form] Fixed empty data on expanded ChoiceType and FileType (HeahDude)
 * bug #25972 support sapi_windows_vt100_support for php 7.2+ (jhdxr)
 * bug #25744 [TwigBridge] Allow label translation to be safe (MatTheCat)

* 2.7.41 (2018-01-29)

 * bug #25922 [HttpFoundation] Use the correct syntax for session gc based on Pdo driver (tanasecosminromeo)
 * bug #25933 Disable CSP header on exception pages only in debug (ostrolucky)
 * bug #25926 [Form] Fixed Button::setParent() when already submitted (HeahDude)
 * bug #25927 [Form] Fixed submitting disabled buttons (HeahDude)
 * bug #25891 [DependencyInjection] allow null values for root nodes in YAML configs (xabbuh)
 * bug #25848 [Validator] add missing parent isset and add test (Simperfit)
 * bug #25861 do not conflict with egulias/email-validator 2.0+ (xabbuh)
 * bug #25851 [Validator] Conflict with egulias/email-validator 2.0 (emodric)
 * bug #25837 [SecurityBundle] Don't register in memory users as services (chalasr)
 * bug #25835 [HttpKernel] DebugHandlersListener should always replace the existing exception handler (nicolas-grekas)
 * bug #25829 [Debug] Always decorate existing exception handlers to deal with fatal errors (nicolas-grekas)
 * bug #25824 Fixing a bug where the dump() function depended on bundle ordering (weaverryan)
 * bug #25789  Enableable ArrayNodeDefinition is disabled for empty configuration (kejwmen)
 * bug #25816 Problem in phar see mergerequest #25579 (betzholz)
 * bug #25781 [Form] Disallow transform dates beyond the year 9999 (curry684)
 * bug #25812 Copied NO language files to the new NB locale (derrabus)
 * bug #25801 [Router] Skip anonymous classes when loading annotated routes (pierredup)
 * bug #25657 [Security] Fix fatal error on non string username (chalasr)
 * bug #25799 Fixed Request::__toString ignoring cookies (Toflar)
 * bug #25755 [Debug] prevent infinite loop with faulty exception handlers (nicolas-grekas)
 * bug #25771 [Validator] 19 digits VISA card numbers are valid (xabbuh)
 * bug #25751 [FrameworkBundle] Add the missing `enabled` session attribute (sroze)
 * bug #25750 [HttpKernel] Turn bad hosts into 400 instead of 500 (nicolas-grekas)
 * bug #25490 [Serializer] Fixed throwing exception with option JSON_PARTIAL_OUTPUT_ON_ERROR (diversantvlz)
 * feature #25669 [Security] Fail gracefully if the security token cannot be unserialized from the session (thewilkybarkid)

* 2.7.40 (2018-01-05)

 * bug #25532 [HttpKernel] Disable CSP header on exception pages (ostrolucky)
 * bug #25491 [Routing] Use the default host even if context is empty (sroze)
 * bug #25662 Dumper shouldn't use html format for phpdbg / cli-server (jhoff)
 * bug #25529 [Validator] Fix access to root object when using composite constraint (ostrolucky)
 * bug #25430 Fixes for Oracle in PdoSessionHandler (elislenio)
 * bug #25599 Add application/ld+json format associated to json (vincentchalamon)
 * bug #25407 [Console] Commands with an alias should not be recognized as ambiguous (Simperfit)
 * bug #25521 [Console] fix a bug when you are passing a default value and passing -n would output the index (Simperfit)
 * bug #25489 [FrameworkBundle] remove esi/ssi renderers if inactive (dmaicher)
 * bug #25427 Preserve percent-encoding in URLs when performing redirects in the UrlMatcher (mpdude)
 * bug #25480 [FrameworkBundle] add missing validation options to XSD file (xabbuh)
 * bug #25487 [Console] Fix a bug when passing a letter that could be an alias (Simperfit)
 * bug #25233 [TwigBridge][Form] Fix hidden currency element with Bootstrap 3 theme (julienfalque)
 * bug #25408 [Debug] Fix catching fatal errors in case of nested error handlers (nicolas-grekas)
 * bug #25330 [HttpFoundation] Support 0 bit netmask in IPv6 (`::/0`) (stephank)
 * bug #25410 [HttpKernel] Fix logging of post-terminate errors/exceptions (nicolas-grekas)
 * bug #25323 [ExpressionLanguage] throw an SyntaxError instead of an undefined index notice (Simperfit)

* 2.7.39 (2017-12-04)

 * bug #25278 Fix for missing whitespace control modifier in form layout (kubawerlos)
 * bug #25236 [Form][TwigBridge] Fix collision between view properties and form fields (yceruto)
 * bug #25258 [link] Prevent warnings when running link with 2.7 (dunglas)
 * bug #24750 [Validator] ExpressionValidator should use OBJECT_TO_STRING  (Simperfit)
 * bug #25182 [HttpFoundation] AutExpireFlashBag should not clear new flashes (Simperfit, sroze)
 * bug #25152 [Form] Don't rely on `Symfony\Component\HttpFoundation\File\File` if http-foundation isn't in FileType (issei-m)
 * bug #24987 [Console] Fix global console flag when used in chain (Simperfit)
 * bug #25043 [Yaml] added ability for substitute aliases when mapping is on single line (Michał Strzelecki, xabbuh)
 * bug #25102 [Form] Fixed ContextErrorException in FileType (chihiro-adachi)
 * bug #25130 [DI] Fix handling of inlined definitions by ContainerBuilder (nicolas-grekas)
 * bug #24956 Fix ambiguous pattern (weltling)

* 2.7.38 (2017-11-16)

 * security #24995 Validate redirect targets using the session cookie domain (nicolas-grekas)
 * security #24994 Prevent bundle readers from breaking out of paths (xabbuh)
 * security #24993 Ensure that submitted data are uploaded files (xabbuh)
 * security #24992 Namespace generated CSRF tokens depending of the current scheme (dunglas)

* 2.7.37 (2017-11-13)

 * bug #24952 [HttpFoundation] Fix session-related BC break (nicolas-grekas, sroze)
 * bug #24929 [Console] Fix traversable autocomplete values (ro0NL)

* 2.7.36 (2017-11-10)

 * bug #24888 [FrameworkBundle] Specifically inject the debug dispatcher in the collector (ogizanagi)
 * bug #24909 [Intl] Update ICU data to 60.1 (jakzal)
 * bug #24906 [Bridge/ProxyManager] Remove direct reference to value holder property (nicolas-grekas)
 * bug #24900 [Validator] Fix Costa Rica IBAN format (Bozhidar Hristov)
 * bug #24904 [Validator] Add Belarus IBAN format (Bozhidar Hristov)
 * bug #24531 [HttpFoundation] Fix forward-compat of NativeSessionStorage with PHP 7.2 (sroze)
 * bug #24814 [Intl] Make intl-data tests pass and save language aliases again (jakzal)
 * bug #24764 [HttpFoundation] add Early Hints to Reponse to fix test (Simperfit)
 * bug #24605 [FrameworkBundle] Do not load property_access.xml if the component isn't installed (ogizanagi)
 * bug #24606 [HttpFoundation] Fix FileBag issue with associative arrays (enumag)
 * bug #24660 Escape trailing \ in QuestionHelper autocompletion (kamazee)
 * bug #24644 [Security] Fixed auth provider authenticate() cannot return void (glye)
 * bug #24626 streamed response should return $this (DQNEO)
 * bug #24589 Username and password in basic auth are allowed to contain '.' (Richard Quadling)
 * bug #24566 Fixed unsetting from loosely equal keys OrderedHashMap (maryo)
 * bug #24570 [Debug] Fix same vendor detection in class loader (Jean-Beru)
 * bug #24563 [Serializer] ObjectNormalizer: throw if PropertyAccess isn't installed (dunglas)
 * bug #24579 pdo session fix (mxp100)
 * bug #24536 [Security] Reject remember-me token if UserCheckerInterface::checkPostAuth() fails (kbond)
 * bug #24519 [Validator] [Twig] added magic method __isset()  to File Constraint class (loru88)
 * bug #24532 [DI] Fix possible incorrect php-code when dumped strings contains newlines (Strate)
 * bug #24502 [HttpFoundation] never match invalid IP addresses (xabbuh)
 * bug #24460 [Form] fix parsing invalid floating point numbers (xabbuh)
 * bug #24490 [HttpFoundation] Combine Cache-Control headers (c960657)
 * bug #23711 Fix support for PHP 7.2 (Simperfit, nicolas-grekas)
 * bug #24494 [HttpFoundation] Add missing session.lazy_write config option (nicolas-grekas)
 * bug #24434 [Form] Use for=ID on radio/checkbox label. (Nyholm)
 * bug #24455 [Console] Escape command usage (sroze)

* 2.7.35 (2017-10-05)

 * bug #24448 [Session] fix MongoDb session handler to gc all expired sessions (Tobion)
 * bug #24417 [Yaml] parse references on merge keys (xabbuh)
 * bug #24421 [Config] Fix dumped files invalidation by OPCache (nicolas-grekas)
 * bug #23980 Tests and fix for issue in array model data in EntityType field with multiple=true (stoccc)
 * bug #22586 [Form] Fixed PercentToLocalizedStringTransformer to accept both comma and dot as decimal separator, if possible (aaa2000)
 * bug #24157 [Intl] Fixed support of Locale::getFallback (lyrixx)
 * bug #24198 [HttpFoundation] Fix file upload multiple with no files (enumag)
 * bug #24036 [Form] Fix precision of MoneyToLocalizedStringTransformer's divisions and multiplications (Rubinum)
 * bug #24367 PdoSessionHandler: fix advisory lock for pgsql (Tobion)
 * bug #24243 HttpCache does not consider ESI resources in HEAD requests (mpdude)
 * bug #24304 [FrameworkBundle] Fix Routing\DelegatingLoader (nicolas-grekas)
 * bug #24219 [Console] Preserving line breaks between sentences according to the exception message (yceruto)
 * bug #23722 [Form] Fixed GroupSequence with "constraints" option (HeahDude)
 * bug #22321 [Filesystem] Fixed makePathRelative (ausi)
 * bug #23473 [Filesystem] mirror - fix copying content with same name as source/target. (gitlost)
 * bug #24162 [WebProfilerBundle] fixed TemplateManager when using Twig 2 without compat interfaces (fabpot)
 * bug #24141 [DomCrawler] Fix conversion to int on GetPhpFiles (MaraBlaga)
 * bug #23853 Filtering empty uuids in ORMQueryBuilderLoader. (mlazovla)
 * bug #24101 [Security] Fix exception when use_referer option is true and referer is not set or empty (linniksa)
 * bug #24105 [Filesystem] check permissions if dump target dir is missing (xabbuh)
 * bug #24115 [FrameworkBundle] Get KERNEL_DIR through $_ENV too for KernelTestCase (yceruto)
 * bug #24041 [ExpressionLanguage] throws an exception on calling uncallable method (fmata)
 * bug #24096 Fix ArrayInput::toString() for VALUE_IS_ARRAY options/args (chalasr)
 * bug #23730 Fixed the escaping of back slashes and << in console output (javiereguiluz)

* 2.7.34 (2017-08-28)

 * bug #23989 [Debug] Remove false-positive check in DebugClassLoader (nicolas-grekas)
 * bug #23982 [VarDumper] Strengthen dumped JS (nicolas-grekas)
 * bug #23925 [Validator] Fix use of GroupSequenceProvider in child classes (linniksa)
 * bug #23945 [Validator] Fix Greek translation (azhurb)
 * bug #23909 [Console] Initialize lazily to render exceptions properly (nicolas-grekas)
 * bug #23856 [DI] Fix dumping abstract with YamlDumper (nicolas-grekas)
 * bug #23752 Ignore memcached missing key error on session destroy (jderusse)
 * bug #23658 [HttpFoundation] Generate safe fallback filename for wrongly encoded filename (xelaris)
 * bug #23783 Avoid infinite loops when profiler data is malformed (javiereguiluz)
 * bug #23729 [Bridge\ProxyManager] Dont call __destruct() on non-instantiated services (nicolas-grekas)

* 2.7.33 (2017-08-01)

 * bug #22244 [Console] Fix passing options with defaultCommand (Jakub Sacha)
 * bug #23684 [Debug] Missing escape in debug output (c960657)
 * bug #23662 [VarDumper] Adapt to php 7.2 changes (nicolas-grekas)
 * bug #23649 [Form][TwigBridge] Don't render _method in form_rest() for a child form (fmarchalemisys)
 * bug #23619 [Validator] Fix IbanValidator for ukrainian IBANs (paroe)
 * bug #23238 [Security] ensure the 'route' index is set before attempting to use it (gsdevme)
 * bug #23580 Fix login redirect when referer contains a query string (fabpot)
 * bug #23574 [VarDumper] Move locale sniffing to dump() time (nicolas-grekas)

* 2.7.32 (2017-07-17)

 * security #23507 [Security] validate empty passwords again (xabbuh)
 * bug #23526 [HttpFoundation] Set meta refresh time to 0 in RedirectResponse content (jnvsor)
 * bug #23468 [DI] Handle root namespace in service definitions (ro0NL)
 * bug #23256 [Security] Fix authentication.failure event not dispatched on AccountStatusException (chalasr)
 * bug #23461 Use rawurlencode() to transform the Cookie into a string (javiereguiluz)
 * bug #23459 [TwigBundle] allow to configure custom formats in XML configs (xabbuh)
 * bug #23261 Fixed absolute url generation for query strings and hash urls (alexander-schranz)
 * bug #23398 [Filesystem] Dont copy perms when origin is remote (nicolas-grekas)

* 2.7.31 (2017-07-05)

 * bug #23378 [FrameworkBundle] Do not remove files from assets dir (1ed)

* 2.7.30 (2017-07-03)

 * bug #23341 [DoctrineBridge][Security][Validator] do not validate empty values (xabbuh)
 * bug #23274 Display a better error design when the toolbar cannot be displayed (yceruto)
 * bug #23333 [PropertyAccess] Fix TypeError discard (dunglas)
 * bug #23345 [Console] fix description of INF default values (xabbuh)
 * bug #23279 Don't call count on non countable object (pierredup)
 * bug #23283 [TwigBundle] add back exception check (xabbuh)
 * bug #23268 Show exception is checked twice in ExceptionController of twig (gmponos)
 * bug #23266 Display a better error message when the toolbar cannot be displayed (javiereguiluz)
 * bug #23271 [FrameworkBundle] allow SSI fragments configuration in XML files (xabbuh)
 * bug #23254 [Form][TwigBridge] render hidden _method field in form_rest() (xabbuh)
 * bug #23250 [Translation] return fallback locales whenever possible (xabbuh)
 * bug #22732 [Security] fix switch user _exit without having current token (dmaicher)
 * bug #22730 [FrameworkBundle] Sessions: configurable "use_strict_mode" option for NativeSessionStorage (MacDada)
 * bug #23195 [FrameworkBundle] [Command] Clean bundle directory, fixes #23177 (NicolasPion)
 * bug #23052 [TwigBundle] Add Content-Type header for exception response (rchoquet)
 * bug #23199 Reset redirectCount when throwing exception (hvanoch)
 * bug #23186 [TwigBundle] Move template.xml loading to a compiler pass (ogizanagi)
 * bug #23130 Keep s-maxage when expiry and validation are used in combination (mpdude)
 * bug #23129 Fix two edge cases in ResponseCacheStrategy (mpdude)
 * feature #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * bug #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * bug #23057 [Translation][FrameworkBundle] Fix resource loading order inconsistency reported in #23034 (mpdude)
 * bug #23092 [Filesystem] added workaround in Filesystem::rename for PHP bug (VolCh)
 * bug #23128 [HttpFoundation] fix for Support for new 7.1 session options (vincentaubert)
 * bug #23176 [VarDumper] fixes (nicolas-grekas)
 * bug #23086 [FrameworkBundle] Fix perf issue in CacheClearCommand::warmup() (nicolas-grekas)
 * bug #23098 Cache ipCheck (2.7) (gonzalovilaseca)

* 2.7.29 (2017-06-07)

 * bug #23069 [SecurityBundle] Show unique Inherited roles in profile panel (yceruto)
 * bug #23073 [TwigBridge] Fix namespaced classes (ogizanagi)
 * bug #22936 [Form] Mix attr option between guessed options and user options (yceruto)
 * bug #23024 [EventDispatcher] Fix ContainerAwareEventDispatcher::hasListeners(null) (nicolas-grekas)
 * bug #22996 [Form] Fix \IntlDateFormatter timezone parameter usage to bypass PHP bug #66323 (romainneutron)
 * bug #22994 Harden the debugging of Twig filters and functions (stof)

* 2.7.28 (2017-05-29)

 * bug #22847 [Console] ChoiceQuestion must have choices (ro0NL)
 * bug #22900 [FrameworkBundle][Console] Fix the override of a command registered by the kernel (aaa2000)
 * bug #22910 [Filesystem] improve error handling in lock() (xabbuh)
 * bug #22718 [Console] Fixed different behaviour of key and value user inputs in multiple choice question (borNfreee)
 * bug #22901 Fix missing abstract key in XmlDumper (weaverryan)
 * bug #22817 [PhpUnitBridge] optional error handler arguments (xabbuh)
 * bug #22647 [VarDumper] Fix dumping of non-nested stubs (nicolas-grekas)
 * bug #22584 [Security] Avoid unnecessary route lookup for empty logout path (ro0NL)
 * bug #22690 [Console] Fix errors not rethrown even if not handled by console.error listeners (chalasr)
 * bug #22669 [FrameworkBundle] AbstractConfigCommand: do not try registering bundles twice (ogizanagi)
 * bug #22676 [FrameworkBundle] Adding the extension XML (flug)

* 2.7.27 (2017-05-01)

 * bug #22528 [Asset] Starting slash should indicate no basePath wanted (weaverryan)
 * bug #22526 [Asset] Preventing the base path or absolute URL from being prefixed incorrectly (weaverryan)
 * bug #22435 [Console] Fix dispatching throwables from ConsoleEvents::COMMAND (nicolas-grekas)
 * bug #22478 [Serializer] XmlEncoder: fix negative int and large numbers handling (dunglas)
 * bug #22424 [Debug] Set exit status to 255 on error (nicolas-grekas)
 * bug #22396 Prevent double registrations related to tag priorities (nicolas-grekas)
 * bug #22352 [HttpFoundation] Add `use_strict_mode` in validOptions for session (sstok)
 * bug #22351 [Yaml] don't keep internal state between parser runs (xabbuh)
 * bug #22307 [Debug] Fix php notice (enumag)
 * bug #22109 [Validator] check for empty host when calling checkdnsrr() (apetitpa)
 * bug #22280 [DI] Fix the xml schema (GuilhemN)
 * bug #22255 [Translation] avoid creating cache files for fallback locales. (aitboudad)
 * bug #22292 Fixes #22264 - add support for Chrome headless (redthor)

* 2.7.26 (2017-04-04)

 * bug #22229 [ExpressionLanguage] Provide the expression in syntax errors (k0pernikus, stof)
 * bug #22240 [DI] Fix fatal error at ContainerBuilder::compile() if config is not installed (chalasr)
 * bug #22140 [Form] Improve the exceptions when trying to get the data in a PRE_SET_DATA listener and the data has not already been set (fancyweb)
 * bug #22217 [Console] Fix table cell styling (ro0NL)
 * bug #22194 [Console] CommandTester: disable color support detection (julienfalque)
 * bug #22188 [Console] Revised exception rendering (ro0NL)
 * bug #22154 [WebProfilerBundle] Normalize whitespace in exceptions passed in headers (curry684)
 * bug #22142 [Console] Escape exception messages in renderException (chalasr)
 * bug #22172 Fix port usage in server:status command (alcaeus)
 * bug #22164 [Bridge\Doctrine] Fix change breaking doctrine-bundle test suite (nicolas-grekas)
 * bug #22133 [Filesystem] normalize paths before making them relative (xabbuh)
 * bug #22138 [HttpFoundation][bugfix] $bags should always be initialized (MacDada)
 * bug #21810 #21809 [SecurityBundle] bugfix: if security provider's name contains upper cases then container didn't compile (Antanas Arvasevicius)
 * bug #19778 [Security] Fixed roles serialization on token from user object (eko)
 * bug #22022 [Validator] fix URL validator to detect non supported chars according to RFC 3986 (e-moe)
 * bug #21968 Fixed pathinfo calculation for requests starting with a question mark. (syzygymsu)
 * bug #21846 [HttpFoundation] Fix Request::getHost() when having several hosts in X_FORWARDED_HOST (nicolas-grekas)
 * bug #21208 [Validator] Add object handling of invalid constraints in Composite (SenseException)
 * bug #22044 [Serializer] [XML] Ignore Process Instruction (jordscream)
 * bug #22079 [HttpKernel] Fixed bug with purging of HTTPS URLs (ausi)
 * bug #21523 #20411 fix Yaml parsing for very long quoted strings (RichardBradley)
 * bug #22001 [Doctrine Bridge] fix priority for doctrine event listeners (dmaicher)
 * bug #21981 [Console] Use proper line endings in BufferedOutput (julienfalque)
 * bug #21957 [Form] Choice type int values (BC Fix) (mcfedr)
 * bug #21923 [travis] Test with hhvm 3.18 (nicolas-grekas)
 * bug #21823 dumpFile(), preserve existing file permissions (chs2)
 * bug #21865 [Security] context listener: hardening user provider handling (xabbuh)
 * bug #21883 [HttpKernel] fix Kernel name when stored in a directory starting with a number (fabpot)

* 2.7.25 (2017-03-06)

 * bug #21671 [Serializer] Xml encoder throws exception for valid data (gr1ev0us)
 * bug #21805 Provide less state in getRequestFormat (dawehner)
 * bug #21832 [Routing] Ignore hidden directories when loading routes from annotations (jakzal)
 * bug #21769 [Form] Improve rounding precision (foaly-nr1)
 * bug #21267 [Form] Fix ChoiceType to ensure submitted data is not nested unnecessarily (issei-m)
 * bug #21731 Fix emacs link (rubenrua)
 * bug #21800  Fix issues reported by static analyze (romainneutron)
 * bug #21798 Revert "bug #21791 [SecurityBundle] only pass relevant user provider (xabbuh)" (xabbuh)
 * bug #21791 [SecurityBundle] only pass relevant user provider (xabbuh)
 * bug #21756 [Yaml] Stop replacing NULLs when merging (gadelat)
 * bug #21722 [ExpressionLanguage] Registering functions after calling evaluate(), compile() or parse() is not supported (maidmaid)
 * bug #21679 [SecurityBundle] fix priority ordering of security voters (xabbuh)
 * bug #21115 [Validator] do not guess getter method names (xabbuh)
 * bug #21661 Fix Composer constraints (fabpot)
 * bug #21582 [HttpCache] purge both http and https from http cache (dbu)
 * bug #21637 [FrameworkBundle] remove translation data collector when not usable (xabbuh)
 * bug #21634 [VarDumper] Added missing persistent stream cast (lyrixx)
 * bug #21436 [DependencyInjection] check for circular refs caused by method calls (xabbuh)
 * bug #21400 [Serializer] fix upper camel case conversion (see #21399) (markusu49)
 * bug #21599 [Console][Table] fixed render when using multiple rowspans. (aitboudad)
 * bug #21613 [Process] Permit empty suffix on Windows (Bilge)
 * bug #21057 [DI] Auto register extension configuration classes as a resource (ro0NL)
 * bug #21592 [Validator] property constraints can be added in child classes (angelk, xabbuh)
 * bug #21458 [Config] Early return for DirectoryResource (robfrawley)
 * bug #21562 [DoctrineBridge] make sure that null can be the invalid value (xabbuh)

* 2.7.24 (2017-02-06)

 * bug #21063 [Form] Fixed DateType format option for single text widget (HeahDude)
 * bug #21430 Casting TableCell value to string. (jaydiablo)
 * bug #21359 [FrameworkBundle] fixed custom domain for translations in php templates (robinlehrmann)
 * bug #21485 [Process] Non ASCII characters disappearing during the escapeshellarg (GuillaumeVerdon)
 * bug #21462 [BrowserKit] ignore invalid cookies expires date format (xabbuh)
 * bug #21438 [Console] Fix TableCell issues with decoration (ogizanagi)
 * bug #21431 [DoctrineBridge] always check for all fields to be mapped (xabbuh)
 * bug #21360 [PropertyAccess] Handle interfaces in the invalid argument exception (fancyweb)
 * bug #21401 [Debug] Workaround "null" $context (nicolas-grekas)
 * bug #21333 [HttpKernel] Fix ArgumentValueResolver for arguments default null (chalasr)
 * bug #20871 [HttpKernel] Give higher priority to adding request formats (akeeman)
 * bug #21285 [TwigBundle] do not lose already set method calls (xabbuh)
 * bug #21279 #20411 fix Yaml parsing for very long quoted strings (RichardBradley)

* 2.7.23 (2017-01-12)

 * bug #21218 [Form] DateTimeToLocalizedStringTransformer does not use timezone when using date only (magnetik)
 * bug #21104 [FrameworkBundle] fix IPv6 address handling in server commands (xabbuh)
 * bug #20793 [Validator] Fix caching of constraints derived from non-serializable parents (uwej711)
 * bug #19586 [TwigBundle] Fix bug where namespaced paths don't take parent bundles in account (wesleylancel)
 * bug #21237 [FrameworkBundle] Fix relative paths used as cache keys (nicolas-grekas)
 * bug #21183 [Validator] respect groups when merging constraints (xabbuh)
 * bug #21179 [TwigBundle] Fixing regression in TwigEngine exception handling (Bertalan Attila)
 * bug #21220 [DI] Fix missing new line after private alias (ogizanagi)
 * bug #21211 Classloader tmpname (lyrixx)
 * bug #21205 [TwigBundle] fixed usage when Templating is not installed (fabpot)
 * bug #21155 [Validator] Check cascasdedGroups for being countable (scaytrase)
 * bug #21200 [Filesystem] Check that directory is writable after created it in dumpFile() (chalasr)
 * bug #21113 [FrameworkBundle][HttpKernel] Fix resources loading for bundles with custom structure (chalasr)
 * bug #21084 [Yaml] handle empty lines inside unindented collection (xabbuh)
 * bug #20925 [HttpFoundation] Validate/cast cookie expire time (ro0NL)
 * bug #21032 [SecurityBundle] Made collection of user provider unique when injecting them to the RemberMeService (lyrixx)
 * bug #21078 [Console] Escape default value when dumping help (lyrixx)
 * bug #21076 [Console] OS X Can't call cli_set_process_title php without superuser (ogizanagi)
 * bug #20900 [Console] Descriptors should use Helper::strlen (ogizanagi)
 * bug #21064 [Debug] Wrap call to ->log in a try catch block (lyrixx)
 * bug #21010 [Debug] UndefinedMethodFatalErrorHandler - Handle anonymous classes (SpacePossum)
 * bug #20859 Avoid warning in PHP 7.2 because of non-countable data (wouterj)
 * bug #21053 [Validator] override property constraints in child class (xabbuh)
 * bug #20970 [Console] Fix question formatting using SymfonyStyle::ask() (chalasr, ogizanagi)
 * bug #20975 [Form] fix group sequence based validation (xabbuh)
 * bug #20599 [WebProfilerBundle] Display multiple HTTP headers in WDT (ro0NL)
 * bug #20799 [TwigBundle] do not try to register incomplete definitions (xabbuh)
 * bug #20961 [Validator] phpize default option values (xabbuh)
 * bug #20934 [FrameworkBundle] Fix PHP form templates on translatable attributes (ro0NL)
 * bug #20957 [FrameworkBundle] test for the Validator component to be present (xabbuh)
 * bug #20936 [DependencyInjection] Fix on-invalid attribute type in xsd (ogizanagi)
 * bug #20931 [VarDumper] Fix dumping by-ref variadics (nicolas-grekas)
 * bug #20734 [Security] AbstractVoter->supportsAttribute gives false positive if attribute is zero (0) (martynas-foodpanda)
 * bug #14082 [config] Fix issue when key removed and left value only (zerustech)

* 2.7.22 (2016-12-13)

 * bug #20714 [FrameworkBundle] Fix unresolved parameters from default configs in debug:config (chalasr)
 * bug #20442 [FrameworkBundle] Bundle commands are not available via find() (julienfalque)
 * bug #20840 [WebProfilerBundle] add dependency on Twig (xabbuh)
 * bug #20828 [Validator] Fix init of YamlFileLoader::$classes for empty files (nicolas-grekas)
 * bug #20539 Cast result to int before adding to it (alcaeus)
 * bug #20831 [Twig] Fix deprecations with Twig 1.29 (nicolas-grekas)
 * bug #20767 [Cache] Fix dumping SplDoublyLinkedList iter mode (nicolas-grekas)
 * bug #20736 [Console] fixed PHP7 Errors when not using Dispatcher (keradus)
 * bug #20755 [HttpKernel] Regression test for missing controller arguments (iltar)
 * bug #20418 [Form][DX] FileType "multiple" fixes (yceruto)
 * bug #19902 [DependencyInjection] PhpDumper.php: hasReference() shouldn't search references in lazy service. (antanas-arvasevicius)
 * bug #20704 [Console] Fix wrong handling of multiline arg/opt descriptions (ogizanagi)
 * bug #20712 [TwigBundle] Fix twig loader registered twice (ogizanagi)
 * bug #20671 [Config] ConfigCache::isFresh() should return false when unserialize() fails (nicolas-grekas)
 * bug #20676 [ClassLoader] Use only forward slashes in generated class map (nicolas-grekas)
 * bug #20664 [Validator] ensure the proper context for nested validations (xabbuh)
 * bug #20661 bug #20653 [WebProfilerBundle] Profiler includes ghost panels (jzawadzki)
 * bug #20374 [FrameworkBundle] Improve performance of ControllerNameParser (enumag)
 * bug #20474 [Routing] Fail properly when a route parameter name cannot be used as a PCRE subpattern name (fancyweb)
 * bug #20566 [DI] Initialize properties before method calls (ro0NL)
 * bug #20609 [DI] Fixed custom services definition BC break introduced in ec7e70fb… (kiler129)
 * bug #20598 [DI] Aliases should preserve the aliased invalid behavior (nicolas-grekas)
 * bug #20602 [HttpKernel] Revert BC breaking change of Request::isMethodSafe() (nicolas-grekas)
 * bug #20499 [Doctrine][Form] support large integers (xabbuh)
 * bug #20576 [Process] Do feat test before enabling TTY mode (nicolas-grekas)

* 2.7.21 (2016-11-21)

 * bug #20543 [DI] Fix error when trying to resolve a DefinitionDecorator (nicolas-grekas)
 * bug #20484 bumped min version of Twig to 1.28 (fabpot)
 * bug #20519 [Debug] Remove GLOBALS from exception context to avoid endless recursion (Seldaek)
 * bug #20455 [ClassLoader] Fix ClassCollectionLoader inlining with __halt_compiler (giosh94mhz)
 * bug #20307 [Form] Fix Date\TimeType marked as invalid on request with single_text and zero seconds (LuisDeimos)
 * bug #20466 [Translation] fixed nested fallback catalogue  using multiple locales. (aitboudad)
 * bug #20465 [#18637][TranslationDebug] workaround for getFallbackLocales. (aitboudad)
 * bug #20440 [TwigBridge][TwigBundle][HttpKernel] prefer getSourceContext() over getSource() (xabbuh)
 * bug #20422 [Translation][fallback] add missing resources in parent catalogues. (aitboudad)
 * bug #20378 [Form] Fixed show float values as choice value in ChoiceType (yceruto)
 * bug #20375 [HttpFoundation][Session] Fix memcache session handler (klandaika)
 * bug #20377 [Console] Fix infinite loop on missing input (chalasr)
 * bug #20342 [Form] Fix UrlType transforms valid protocols (ogizanagi)
 * bug #20292 Enhance GAE compat by removing some realpath() (nicolas-grekas)
 * bug #20321 Compatibility with Twig 1.27 (xkobal)

* 2.7.20 (2016-10-27)

 * bug #20289 Fix edge case with StreamedResponse where headers are sent twice (Nicofuma)
 * bug #20278 [DependencyInjection] merge tags instead of completely replacing them (xabbuh)
 * bug #20271 Changes related to Twig 1.27 (fabpot)
 * bug #20252 Trim constant values in XmlFileLoader (lstrojny)
 * bug #20253 [TwigBridge] Use non-deprecated Twig_Node::getTemplateLine() (fabpot)
 * bug #20235 [DomCrawler] Allow pipe (|) character in link tags when using Xpath expressions (klausi, nicolas-grekas)
 * bug #20224 [Twig] removed deprecations added in Twig 1.27 (fabpot)
 * bug #19478 fixed Filesystem:makePathRelative and added 2 more testcases (muhammedeminakbulut)
 * bug #20218 [HttpFoundation] no 304 response if method is not cacheable (xabbuh)
 * bug #20207 [DependencyInjection] move tags from decorated to decorating service (xabbuh)
 * bug #20205 [HttpCache] fix: do not cache OPTIONS request (dmaicher)
 * bug #20146 [Validator] Prevent infinite loop in PropertyMetadata (wesleylancel)
 * bug #20184 [FrameworkBundle] Convert null prefix to an empty string in translation:update (chalasr)
 * bug #19725 [Security] $attributes can be anything, but RoleVoter assumes strings (Jonatan Männchen)
 * bug #20127 [HttpFoundation] JSONP callback validation (ro0NL)
 * bug #20163 add missing use statement (xabbuh)
 * bug #19961 [Console] Escape question text and default value in SymfonyStyle::ask() (chalasr)
 * bug #20141 [Console] Fix validation of empty values using SymfonyQuestionHelper::ask() (chalasr)
 * bug #20147 [FrameworkBundle] Alter container class instead of kernel name in cache:clear command (nicolas-grekas)

* 2.7.19 (2016-10-03)

 * bug #20102 [Validator] Url validator not validating hosts ending in a number (gwkunze)
 * bug #20132 Use "more entropy" option for uniqid() (javiereguiluz)
 * bug #20122 [Validator] Reset constraint options (ro0NL)
 * bug #20116 fixed AddConstraintValidatorsPass config (fabpot)
 * bug #20078 Fix #19943 Make sure to process each interface metadata only once (lemoinem)
 * bug #20080 [Form] compound forms without children should be considered rendered implicitly (backbone87)
 * bug #20086 [VarDumper] Fix PHP 7.1 compat (nicolas-grekas)
 * bug #20077 [Process] silent file operation to avoid open basedir issues (xabbuh)
 * bug #20079 fixed Twig support for 1.26 and 2.0 (fabpot)
 * bug #19951 [Finder] Trim trailing directory slash in ExcludeDirectoryFilterIterator (ro0NL)
 * bug #20010 [DX] Fixed regression when exception message swallowed when logging it. (Koc)
 * bug #19983 [TwigBridge] removed Twig null nodes (deprecated as of Twig 1.25) (fabpot)
 * bug #19946 [Console] Fix parsing optionnal options with empty value in argv (chalasr)
 * bug #19636 [Finder] no PHP warning on empty directory iteration (ggottwald)
 * bug #19923 [bugfix] [Console] Set `Input::$interactive` to `false` when command is executed with `--quiet` as verbosity level (phansys)
 * bug #19811 Fixed the nullable support for php 7.1 and below (2.7, 2.8, 3.0) (iltar)
 * bug #19904 [Form] Fixed collapsed ChoiceType options attributes (HeahDude)
 * bug #19908 [Config] Handle open_basedir restrictions in FileLocator (Nicofuma)
 * bug #19922 [Yaml][TwigBridge] Use JSON_UNESCAPED_SLASHES for lint commands output (chalasr)
 * bug #19928 [Validator] Update IpValidatorTest data set with a valid reserved IP (jakzal)
 * bug #19813 [Console] fixed PHP7 Errors are now handled and converted to Exceptions (fonsecas72)
 * bug #19879 [Form] Incorrect timezone with DateTimeLocalizedStringTransformer (mbeccati)

* 2.7.18 (2016-09-07)

 * bug #19859 [ClassLoader] Fix ClassCollectionLoader inlining with declare(strict_types=1) (nicolas-grekas)
 * bug #19780 [FrameworkBundle] Incorrect line break in exception message (500 debug page) (pedroresende)
 * bug #19595 [form] lazy trans `post_max_size_message`. (aitboudad)
 * bug #19870 [DI] Fix setting synthetic services on ContainerBuilder (nicolas-grekas)
 * bug #19848 Revert "minor #19689 [DI] Cleanup array_key_exists (ro0NL)" (nicolas-grekas)
 * bug #19842 [FrameworkBundle] Check for class existence before is_subclass_of (chalasr)
 * bug #19827 [BrowserKit] Fix cookie expiration on 32 bit systems (jameshalsall)

* 2.7.17 (2016-09-02)

 * bug #19794 [VarDumper] Various minor fixes & cleanups (nicolas-grekas)
 * bug #19751 Fixes the calendar in constructor to handle null (wakqasahmed)
 * bug #19388 [Validator][GroupSequence] fixed GroupSequence validation ignores PropetyMetadata of parent classes (Sandro Hopf)
 * bug #19601 [FrameworkBundle] Added friendly exception when constraint validator class does not exist (yceruto)
 * bug #19580 [Validator] fixed duplicate constraints with parent class interfaces (dmaicher)
 * bug #19647 [Debug] Swap dumper services at bootstrap (lyrixx)
 * bug #19685 [DI] Include dynamic services in alternatives (ro0NL)
 * bug #19702 [Debug][HttpKernel][VarDumper] Prepare for committed 7.2 changes (aka "small-bc-breaks") (nicolas-grekas)
 * bug #19704 [DependencyInjection] PhpDumper::isFrozen inconsistency (allflame)
 * bug #19666 Verify explicitly that the request IP is a valid IPv4 address (nesk)
 * bug #19660 Disable CLI color for Windows 10 greater than 10.0.10586 (mlocati)
 * bug #19663 Exception details break the layout (Dionysis Arvanitis)
 * bug #19651 [HttpKernel] Fix HttpCache validation HTTP method (tgalopin)
 * bug #19623 [VarDumper] Fix dumping continuations (nicolas-grekas)
 * bug #19549 [HttpFoundation] fixed Request::getContent() reusage bug (1ma)
 * bug #19373 [Form] Skip CSRF validation on form when POST max size is exceeded (jameshalsall)
 * bug #19541 Fix #19531 [Form] DateType fails parsing when midnight is not a valid time (mbeccati)
 * bug #19579 [Process] Strengthen Windows pipe files opening (again...) (nicolas-grekas)
 * bug #19564 Added class existence check if is_subclass_of() fails in compiler passes (SCIF)
 * bug #19522 [SwiftMailerBridge] Fix flawed deprecation message (chalasr)
 * bug #19510 [Process] Fix double-fread() when reading unix pipes (nicolas-grekas)
 * bug #19508 [Process] Fix AbstractPipes::write() for a situation seen on HHVM (at least) (nicolas-grekas)

* 2.7.16 (2016-07-30)

 * bug #19470 undefined offset fix (#19406) (ReenExe)
 * bug #19300 [HttpKernel] Use flock() for HttpCache's lock files (mpdude)
 * bug #19428 [Process] Fix write access check for pipes on Windows (nicolas-grekas)
 * bug #19397  [HttpFoundation] HttpCache refresh stale responses containing an ETag (maennchen)
 * bug #19426 [Form] Fix the money form type render with Bootstrap3 (Th3Mouk)
 * bug #19425 [BrowserKit] Uppercase the "GET" method in redirects (jakzal)
 * bug #19384 Fix PHP 7.1 related failures (nicolas-grekas)
 * bug #19379 [VarDumper] Fix for PHP 7.1 (nicolas-grekas)
 * bug #19369 Fix the DBAL session handler version check for Postgresql (stof)
 * bug #19368 [VarDumper] Fix dumping jsons casted as arrays (nicolas-grekas)
 * bug #19334 [Security] Fix the retrieval of the last username when using forwarding (stof)
 * bug #19321 [HttpFoundation] Add OPTIONS and TRACE to the list of safe methods (dunglas)
 * bug #19317 [BrowserKit] Update Client::getAbsoluteUri() for query string only URIs (georaldc)
 * bug #19298 [ClassLoader] Fix declared classes being computed when not needed (nicolas-grekas)
 * bug #19316 [Validator] Added additional MasterCard range to the CardSchemeValidator (Dennis Væversted)
 * bug #19290 [HttpKernel] fixed internal subrequests having an if-modified-since-header (MalteWunsch)
 * bug #19306 [Form] fixed bug - name in ButtonBuilder (cheprasov)
 * bug #19267 [Validator] UuidValidator must accept a Uuid constraint. (hhamon)
 * bug #19186 Fix for #19183 to add support for new PHP MongoDB extension in sessions. (omanizer)

* 2.7.15 (2016-06-30)

 * bug #19217 [HttpKernel] Inline ValidateRequestListener logic into HttpKernel (nicolas-grekas)
 * bug #18688 [HttpFoundation] Warning when request has both Forwarded and X-Forwarded-For (magnusnordlander)
 * bug #19173 [Console] Decouple SymfonyStyle from TableCell (ro0NL)
 * bug #17822 [WIP]  [Form] fix `empty_data` option in expanded `ChoiceType` (HeahDude)
 * bug #19134 Distinguish between first and subsequent progress bar displays (rquadling)
 * bug #19061 [FORM] fix post_max_size_message translation (alt. 2) (David Badura)
 * bug #19100 [Console] Fixed SymfonyQuestionHelper multi-choice with defaults (sstok)
 * bug #18924 [DoctrineBridge] Don't use object IDs in DoctrineChoiceLoader when passing a value closure (webmozart)
 * bug #19138 [DomCrawler] No more exception on field name with strange format (guiled, fabpot)
 * bug #18935 [Form] Consider a violation even if the form is not submitted (egeloen)
 * bug #19127 [Form] Add exception to FormRenderer about non-unique block names (enumag)
 * bug #19118 [Process] Fix pipes cleaning on Windows (nicolas-grekas)
 * bug #19128 Avoid phpunit 5.4 warnings on getMock (2.7+) (iltar)
 * bug #19114 [HttpKernel] Dont close the reponse stream in debug (nicolas-grekas)
 * bug #19101 [Session] fix PDO transaction aborted under PostgreSQL (Tobion)
 * bug #18501 [HttpFoundation] changed MERGE queries (hjkl)
 * bug #19062 [HttpFoundation] Fix UPSERT for PgSql >= 9.5 (nicolas-grekas)
 * bug #18548 [Form] minor fixes in DateTime transformers (HeahDude)
 * bug #18732 [PropertyAccess][DX] Enhance exception that say that some methods are missing if they don't (nykopol)
 * bug #19048 [HttpFoundation] Use UPSERT for sessions stored in PgSql >= 9.5 (nicolas-grekas)
 * bug #19038 Fix feature detection for IE (Alsciende)
 * bug #18915 [DependencyInjection] force enabling the external XML entity loaders (xabbuh)
 * bug #19020 [Form] Fixed collapsed choice attributes (HeahDude)
 * bug #19028 [Yaml] properly count skipped comment lines (xabbuh)
 * bug #17733 [Yaml] Fix wrong line number when comments are inserted in the middle of a block. (paradajozsef)
 * bug #18911 Fixed singular of committee (peterrehm)
 * bug #18971 Do not inject web debug toolbar on attachments (peterrehm)

* 2.7.14 (2016-06-06)

 * bug #18908 [DependencyInjection] force enabling the external XML entity loaders (xabbuh)
 * bug #18893 [DependencyInjection] Skip deep reference check for 'service_container' (RobertMe)
 * bug #18812 Catch \Throwable (fprochazka)
 * bug #18821 [Form] Removed UTC specification with timestamp (francisbesset)
 * bug #18861 Fix for #18843 (inso)
 * bug #18907 [Routing] Fix the annotation loader taking a class constant as a beginning of a class name (jakzal, nicolas-grekas)
 * bug #18879 [Console] SymfonyStyle: Align multi-line/very-long-line blocks (chalasr)
 * bug #18864 [Console][DX] Fixed ambiguous error message when using a duplicate option shortcut (peterrehm)
 * bug #18883 Fix js comment in profiler (linnaea)
 * bug #18844 [Yaml] fix exception contexts (xabbuh)
 * bug #18840 [Yaml] properly handle unindented collections (xabbuh)
 * bug #18813 Catch \Throwable (fprochazka)
 * bug #18839 People - person singularization (Keeo)
 * bug #18828 [Yaml] chomp newlines only at the end of YAML documents (xabbuh)
 * bug #18814 Fixed server status command when port has been omitted (peterrehm)
 * bug #18799 Use levenshtein level for better Bundle matching (j0k3r)
 * bug #18413 [WebProfilerBundle] Fix CORS ajax security issues (romainneutron)
 * bug #18507 [BUG] Delete class 'control-group' in bootstrap 3 (Philippe Degeeter)
 * bug #18747  [Form] Modified iterator_to_array's 2nd parameter to false in ViolationMapper (issei-m)
 * bug #18635 [Console] Prevent fatal error when calling Command::getHelper without helperSet (chalasr)
 * bug #18686 [console][table] adjust width of colspanned cell. (aitboudad)
 * bug #18761  [Form] Modified iterator_to_array's 2nd parameter to false in ViolationMapper (issei-m)
 * bug #18737 [Debug] Fix fatal error handlers on PHP 7 (nicolas-grekas)

* 2.7.13 (2016-05-09)

 * security #18733 limited the maximum length of a submitted username (fabpot)
 * bug #18730 [FrameworkBundle] prevent calling get() for service_container service (xabbuh)
 * bug #18709 [DependencyInjection] top-level anonymous services must be public (xabbuh)
 * bug #18692 add @Event annotation for KernelEvents (Haehnchen)
 * bug #18246 [DependencyInjection] fix ambiguous services schema (backbone87)

* 2.7.12 (2016-04-29)

 * bug #18180 [Form] fixed BC break with pre selection of choices with `ChoiceType` and its children (HeahDude)
 * bug #18562 [WebProfilerBunde] Give an absolute url in case the request occured from another domain (romainneutron)
 * bug #18603 [PropertyAccess] ->getValue() should be read-only (nicolas-grekas)
 * bug #18593 [VarDumper] Fix dumping type hints for non-existing parent classes (nicolas-grekas)
 * bug #18581 [Console] [TableHelper] make it work with SymfonyStyle. (aitboudad)
 * bug #18280 [Routing] add query param if value is different from default (Tobion)
 * bug #18496 [Console] use ANSI escape sequences in ProgressBar overwrite method (alekitto)
 * bug #18491 [DependencyInjection] anonymous services are always private (xabbuh)
 * bug #18515 [Filesystem] Better error handling in remove() (nicolas-grekas)
 * bug #18449 [PropertyAccess] Fix regression (nicolas-grekas)
 * bug #18429 [Console] Correct time formatting. (camporter)
 * bug #18467 [DependencyInjection] Resolve aliases before removing abstract services + add tests (nicolas-grekas)
 * bug #18460 [DomCrawler] Fix select option with empty value (Matt Wells)
 * bug #18425 [Security] Fixed SwitchUserListener when exiting an impersonation with AnonymousToken (lyrixx)
 * bug #18317 [Form] fix "prototype" not required when parent form is not required (HeahDude)
 * bug #18439 [Logging] Add support for Firefox (43+) in ChromePhpHandler (arjenm)
 * bug #18385 Detect CLI color support for Windows 10 build 10586 (mlocati)
 * bug #18426 [EventDispatcher] Try first if the event is Stopped (lyrixx)
 * bug #18394 [FrameworkBundle] Return the invokable service if its name is the class name (dunglas)
 * bug #18265 Optimize ReplaceAliasByActualDefinitionPass (ajb-in)
 * bug #18349 [Process] Fix stream_select priority when writing to stdin (nicolas-grekas)
 * bug #18358 [Form] NumberToLocalizedStringTransformer should return floats when possible (nicolas-grekas)
 * bug #17926 [DependencyInjection] Enable alias for service_container (hason)
 * bug #18352 [Debug] Fix case sensitivity checks (nicolas-grekas)
 * bug #18336 [Debug] Fix handling of php7 throwables (nicolas-grekas)
 * bug #18354 [FrameworkBundle][TwigBridge] fix high deps tests (xabbuh)
 * bug #18312 [ClassLoader] Fix storing not-found classes in APC cache (nicolas-grekas)
 * bug #18298 [Validator] do not treat payload as callback (xabbuh)

* 2.7.11 (2016-03-25)

 * bug #18255 [HttpFoundation] Fix support of custom mime types with parameters (Ener-Getick)
 * bug #18272 [Bridge\PhpUnit] Workaround old phpunit bug, no colors in weak mode, add tests (nicolas-grekas)
 * bug #18259 [PropertyAccess] Backport fixes from 2.7 (nicolas-grekas)
 * bug #18261 [PropertyAccess] Fix isPropertyWritable not using the reflection cache (nicolas-grekas)
 * bug #18224 [PropertyAccess] Remove most ref mismatches to improve perf (nicolas-grekas)
 * bug #18210 [PropertyAccess] Throw an UnexpectedTypeException when the type do not match (dunglas, nicolas-grekas)
 * bug #18216 [Intl] Fix invalid numeric literal on PHP 7 (nicolas-grekas)
 * bug #18147 [Validator] EmailValidator cannot extract hostname if email contains multiple @ symbols (natechicago)
 * bug #18023 [Process] getIncrementalOutput should work without calling getOutput (romainneutron)
 * bug #18175 [Translation] Add support for fuzzy tags in PoFileLoader (nud)
 * bug #18179 [Form] Fix NumberToLocalizedStringTransformer::reverseTransform with big integers (ovrflo, nicolas-grekas)
 * bug #18164 [HttpKernel] set s-maxage only if all responses are cacheable (xabbuh)
 * bug #18150 [Process] Wait a bit less on Windows (nicolas-grekas)
 * bug #18130 [Debug] Replaced logic for detecting filesystem case sensitivity (Dan Blows)
 * bug #18080 [HttpFoundation] Set the Content-Range header if the requested Range is unsatisfied (jakzal)
 * bug #18084 [HttpFoundation] Avoid warnings when checking malicious IPs (jakzal)
 * bug #18066 [Process] Fix pipes handling (nicolas-grekas)
 * bug #18078 [Console] Fix an autocompletion question helper issue with non-sequentially indexed choices (jakzal)
 * bug #18048 [HttpKernel] Fix mem usage when stripping the prod container (nicolas-grekas)
 * bug #18065 [Finder] Partially revert #17134 to fix a regression (jakzal)
 * bug #18018 [HttpFoundation] exception when registering bags for started sessions (xabbuh)
 * bug #18054 [Filesystem] Fix false positive in ->remove() (nicolas-grekas)
 * bug #18049 [Validator] Fix the locale validator so it treats a locale alias as a valid locale (jakzal)
 * bug #18019 [Intl] Update ICU to version 55 (jakzal)
 * bug #18015 [Process] Fix memory issue when using large input streams (romainneutron)
 * bug #16656 [HttpFoundation] automatically generate safe fallback filename (xabbuh)
 * bug #15794 [Console] default to stderr in the console helpers (alcohol)
 * bug #17984 Allow to normalize \Traversable when serializing xml (Ener-Getick)
 * bug #17434 Improved the error message when a template is not found (rvanginneken, javiereguiluz)
 * bug #17687 Improved the error message when using "@" in a decorated service (javiereguiluz)
 * bug #17744 Improve error reporting in router panel of web profiler (javiereguiluz)
 * bug #17894 [FrameworkBundle] Fix a regression in handling absolute template paths (jakzal)
 * bug #17990 [DoctrineBridge][Form] Fix performance regression in EntityType (kimlai)
 * bug #17595 [HttpKernel] Remove _path from query parameters when fragment is a subrequest (cmenning)
 * bug #17986 [DomCrawler] Dont use LIBXML_PARSEHUGE by default (nicolas-grekas)
 * bug #17668 add 'guid' to list of exception to filter out (garak)
 * bug #17615 Ensure backend slashes for symlinks on Windows systems (cpsitgmbh)
 * bug #17626 Try to delete broken symlinks (IchHabRecht)
 * bug #17978 [Yaml] ensure dump indentation to be greather than zero (xabbuh)
 * bug #16886 [Form] [ChoiceType] Prefer placeholder to empty_value (boite)
 * bug #17976 [WebProfilerBundle] fix debug toolbar rendering by removing inadvertently added links (craue)
 * bug #17971 Variadic controller params (NiR-, fabpot)
 * bug #17568 Improved Bootstrap form theme for hidden fields (javiereguiluz)
 * bug #17925 [Bridge] The WebProcessor now forwards the client IP (magnetik)

* 2.7.10 (2016-02-28)

 * bug #17947 Fix - #17676 (backport #17919 to 2.3) (Ocramius)
 * bug #17942 Fix bug when using an private aliased factory service (WouterJ)
 * bug #17798  [Form] Fix BC break by allowing 'choice_label' option to be 'false' in ChoiceType (HeahDude)
 * bug #17542 ChoiceFormField of type "select" could be "disabled" (bouland)
 * bug #17602 [HttpFoundation] Fix BinaryFileResponse incorrect behavior with if-range header (bburnichon)
 * bug #17760  [Form] fix choice value "false" in ChoiceType (HeahDude)
 * bug #17914 [Console] Fix escaping of trailing backslashes (nicolas-grekas)
 * bug #17074 Fix constraint validator alias being required (Triiistan)
 * bug #17866 [DependencyInjection] replace alias in factories (xabbuh)
 * bug #17867 [DependencyInjection] replace alias in factory services (xabbuh)
 * bug #17569 [FrameworkBundle] read commands from bundles when accessing list (havvg)
 * bug #16987 [FileSystem] Windows fix (flip111)
 * bug #17787 [Form] Fix choice placeholder edge cases (Tobion)
 * bug #17835 [Yaml] fix default timezone to be UTC (xabbuh)
 * bug #17823 [DependencyInjection] fix dumped YAML string (xabbuh)
 * bug #17818 [Console] InvalidArgumentException is thrown under wrong condition (robinkanters)
 * bug #17819 [HttpKernel] Prevent a fatal error when DebugHandlersListener is used with a kernel with no terminateWithException() method (jakzal)
 * bug #17814 [DependencyInjection] fix dumped YAML snytax (xabbuh)
 * bug #17099 [Form] Fixed violation mapping if multiple forms are using the same (or part of the same) property path (alekitto)
 * bug #17694  [DoctrineBridge] [Form] fix choice_value in EntityType (HeahDude)
 * bug #17719 [DependencyInjection] fixed exceptions thrown by get method of ContainerBuilder (lukaszmakuch)
 * bug #17742 [DependencyInjection] Fix #16461 Container::set() replace aliases (mnapoli)
 * bug #17745 Added more exceptions to singularify method (javiereguiluz)
 * bug #17691 Fixed (string) catchable fatal error for PHP Incomplete Class instances (yceruto)
 * bug #17766 Fixed (string) catchable fatal error for PHP Incomplete Class instances (yceruto)
 * bug #17757 [HttpFoundation] BinaryFileResponse sendContent return as parent. (2.3) (SpacePossum)
 * bug #17702 [TwigBridge] forward compatibility with Yaml 3.1 (xabbuh)
 * bug #17672 [DependencyInjection][Routing] add files used in FileResource objects (xabbuh)
 * bug #17600 Fixed the Bootstrap form theme for inlined checkbox/radio (javiereguiluz)
 * bug #17596 [Translation] Add resources from fallback locale to parent catalogue (c960657)
 * bug #17605 [FrameworkBundle] remove default null value for asset version (xabbuh)
 * bug #17606 [DependencyInjection] pass triggerDeprecationError arg to parent class (xabbuh)
 * bug #16956 [DependencyInjection] XmlFileLoader: enforce tags to have a name (xabbuh)
 * bug #16265 [BrowserKit] Corrected HTTP_HOST logic (Naktibalda)
 * bug #17554 [DependencyInjection] resolve aliases in factories (xabbuh)
 * bug #17555 [DependencyInjection] resolve aliases in factory services (xabbuh)
 * bug #17511 [Form] ArrayChoiceList can now deal with a null in choices (issei-m)
 * bug #17430 [Serializer] Ensure that groups are strings (dunglas)
 * bug #15272 [FrameworkBundle] Fix template location for PHP templates (jakzal)
 * bug #11232 [Routing] Fixes fatal errors with object resources in AnnotationDirectoryLoader::supports (Tischoi)
 * bug #17526 Escape the delimiter in Glob::toRegex (javiereguiluz)
 * bug #17527 fixed undefined variable (fabpot)
 * bug #15706 [framework-bundle] Added support for the `0.0.0.0/0` trusted proxy (zerkms)
 * bug #16274 [HttpKernel] Lookup the response even if the lock was released after two second wait (jakzal)
 * bug #17355 [DoctrineBridge][Validator] >= 2.3 Pass association instead of ID as argument (xavismeh)
 * bug #17454 Allow absolute URLs to be displayed in the debug toolbar (javiereguiluz)
 * bug #16736 [Request] Ignore invalid IP addresses sent by proxies (GromNaN)
 * bug #17486 [FrameworkBundle] Throw for missing container extensions (kix)
 * bug #16873 Able to load big xml files with DomCrawler (zorn-v)
 * bug #16897 [Form] Fix constraints could be null if not set (DZunke)
 * bug #16912 [Translation][Writer] avoid calling setBackup if the dumper is not FileDumper (aitboudad)
 * bug #17505 sort bundles in config:dump-reference command (xabbuh)
 * bug #17514 [Asset] Add defaultNull to version configuration (ewgRa)
 * bug #16511 [Asset] Ability to set empty version strategy in packages (ewgRa)
 * bug #17503 [Asset] CLI: use request context to generate absolute URLs (xabbuh)
 * bug #17478 [HttpFoundation] Do not overwrite the Authorization header if it is already set (jakzal)
 * bug #17461 [Yaml] tag for dumped PHP objects must be a local one (xabbuh)
 * bug #17456 [DX] Remove default match from AbstractConfigCommand::findExtension (kix)
 * bug #17424 [Process] Update in 2.7 for stream-based output storage (romainneutron)
 * bug #17423 [Process] Use stream based storage to avoid memory issues (romainneutron)
 * bug #17406 [Form] ChoiceType: Fix a notice when 'choices' normalizer is replaced (paradajozsef)
 * bug #17433 [FrameworkBundle] Don't log twice with the error handler (nicolas-grekas)
 * bug #17418 Fixed Bootstrap form theme form "reset" buttons (javiereguiluz)
 * bug #17404 fix merge 2.3 into 2.7 for SecureRandom dependency (Tobion)
 * bug #17373 [SecurityBundle] fix SecureRandom service constructor args (Tobion)
 * bug #17380 [TwigBridge] Use label_format option for checkbox and radio labels (enumag)
 * bug #17377 Fix performance (PHP5) and memory (PHP7) issues when using token_get_all (nicolas-grekas, peteward)
 * bug #17389 [Routing] Fixed correct class name in thrown exception (fixes #17388) (robinvdvleuten)
 * bug #17358 [ClassLoader] Use symfony/polyfill-apcu (nicolas-grekas)
 * bug #17370 [HttpFoundation][Cookie] Cookie DateTimeInterface fix (wildewouter)

* 2.7.9 (2016-01-14)

 * security #17359 do not ship with a custom rng implementation (xabbuh, fabpot)
 * bug #17314 Fix max width for multibyte keys in choice question (mheki)
 * bug #17326 [Console] Display console application name even when no version set (polc)
 * bug #17328 [Serializer] Allow to use proxies in object_to_populate (dunglas)
 * bug #17347  Workaround https://bugs.php.net/63206 (nicolas-grekas)
 * bug #17140 [Serializer] Remove normalizer cache in Serializer class (jvasseur)
 * bug #17307 [FrameworkBundle] Fix paths with % in it (like urlencoded) (scaytrase)
 * bug #17078 [Bridge] [Doctrine] [Validator] Added support \IteratorAggregate for UniqueEntityValidator (Disparity)
 * bug #17298 [FrameworkBundle] Use proper class to fetch $versionStrategy property (dosten)
 * bug #17287 [HttpKernel] Forcing string comparison on query parameters sort in UriSigner (Tim van Densen)
 * bug #17279 [FrameworkBundle] Add case in Kernel directory guess for PHPUnit (tgalopin)
 * bug #17278 [FrameworkBundle] Add case in Kernel directory guess for PHPUnit (tgalopin)
 * bug #17275 [PhpUnitBridge] Re-enable the garbage collector (nicolas-grekas)
 * bug #17276 [Process] Fix potential race condition (nicolas-grekas)
 * bug #17183 [FrameworkBundle] Set the kernel.name properly after a cache warmup (jakzal)
 * bug #17159 [Yaml] recognize when a block scalar is left (xabbuh)
 * bug #17195 bug #14246 [Filesystem] dumpFile() non atomic (Hidde Boomsma)
 * feature #16747 [Form] Improved performance of ChoiceType and its subtypes (webmozart)
 * bug #17177 [Process] Fix potential race condition leading to transient tests (nicolas-grekas)
 * bug #17163 [Form] fix Catchable Fatal Error if choices is not an array (Gladhon, nicolas-grekas)
 * bug #17119 [Form] improve deprecation message for "empty_value" and "choice_list" options. (hhamon)

* 2.7.8 (2015-12-26)

 * bug #16864 [Yaml] fix indented line handling in folded blocks (xabbuh)
 * bug #17052  Fixed flatten exception recursion with errors (GrahamCampbell)
 * bug #16826 Embedded identifier support (mihai-stancu)
 * bug #17079 Also transform inline mappings to objects (WouterJ)
 * bug #17129 [Config] Fix array sort on normalization in edge case (romainneutron)
 * bug #17094 [Process] More robustness and deterministic tests (nicolas-grekas)
 * bug #17112 [PropertyAccess] Reorder elements array after PropertyPathBuilder::replace (alekitto)
 * bug #16797 [Filesystem] Recursively widen non-executable directories (Slamdunk)
 * bug #17040 [Console] Avoid extra blank lines when rendering exceptions (ogizanagi)
 * bug #17055 [Security] Verify if a password encoded with bcrypt is no longer than 72 characters (jakzal)
 * bug #16959 [Form] fix #15544 when a collection type attribute "required" is false, "prototype" should too (HeahDude)
 * bug #16860 [Yaml] do not remove "comments" in scalar blocks (xabbuh)
 * bug #17002 [Console][Table] fixed render row that contains multiple cells. (aitboudad)
 * bug #16971 [HttpFoundation] Added the ability of using BinaryFileResponse with stream wrappers (jakzal, Sander-Toonen)
 * bug #17048 Fix the logout path when not using the router (stof)
 * bug #17049 Fix the logout path when not using the router (stof)
 * bug #17057 [FrameworkBundle][HttpKernel] the finder is required to discover bundle commands (xabbuh)
 * bug #17006 [Form] Fix casting regression in DoctrineChoiceLoader (bendavies)
 * bug #16915 [Process] Enhance compatiblity with --enable-sigchild (nicolas-grekas)
 * bug #16829 [FrameworkBundle] prevent cache:clear creating too long paths (Tobion)
 * bug #16921 Fix short array syntax for php 5.3 (ewgRa)
 * bug #16450 [Serializer] Fixed `array_unique` on array of objects in `getAllowedAttributes`. (CornyPhoenix)
 * bug #16757 [FrameworkBundle] [Translation] Fixed translations not written when no translations directory in update command (jeremyFreeAgent)
 * bug #16871 [FrameworkBundle] Disable built-in server commands when Process component is missing (gnugat, xabbuh)
 * bug #16870 [FrameworkBundle] Disable the server:run command when Process component is missing (gnugat, xabbuh)
 * bug #16742 [Console][ProgressBar] redrawFrequency should never be 0 (dritter)
 * bug #16799 Improve error message for undefined DIC aliases (mpdude)
 * bug #16825 [VarDumper] fix .sf-dump z-index (debug bar conflict) (Antoine LA)
 * bug #16772 Refactoring EntityUserProvider::__construct() to not do work, cause cache warm error (weaverryan)
 * bug #16753 [Process] Fix signaling/stopping logic on Windows (nicolas-grekas)
 * bug #16733 [Console] do not encode backslashes in console default description (Tobion)
 * bug #16312 [HttpKernel] clearstatcache() so the Cache sees when a .lck file has been released (mpdude)
 * bug #16351 [WIP] [Form] [TwigBridge] Bootstrap horizontal theme missing tests (pieter2627)
 * bug #16685 [Form] Fixed: Duplicate choice labels are remembered when using "choices_as_values" = false (webmozart)
 * bug #16705 [Form] Deprecated setting "choices_as_values" to "false" (webmozart)
 * bug #16695 [SecurityBundle] disable the init:acl command if ACL is not used (Tobion)
 * bug #16679 [Form] Disabled view data validation if "data_class" is set to null (webmozart)
 * bug #16676 [HttpFoundation] Workaround HHVM rewriting HTTP response line (nicolas-grekas)
 * bug #16668 [ClassLoader] Fix parsing namespace when token_get_all() is missing (nicolas-grekas)
 * bug #16386 Bug #16343 [Router] Too many Routes ? (jelte)
 * bug #16651 [Debug] Ensure class declarations are loaded only once (nicolas-grekas)

* 2.7.7 (2015-11-23)

 * security #16631 CVE-2015-8124: Session Fixation in the "Remember Me" Login Feature (xabbuh)
 * security #16630 CVE-2015-8125: Potential Remote Timing Attack Vulnerability in Security Remember-Me Service (xabbuh)
 * bug #16588 Sent out a status text for unknown HTTP headers. (dawehner)
 * bug #16295 [DependencyInjection] Unescape parameters for all types of injection (Nicofuma)
 * bug #16574 [Process] Fix PhpProcess with phpdbg runtime (nicolas-grekas)
 * bug #16578 [Console] Fix bug in windows detection (kbond)
 * bug #16546 [Serializer] ObjectNormalizer: don't serialize static methods and props (dunglas)
 * bug #16352 Fix the server variables in the router_*.php files (leofeyer)
 * bug #16537 [Validator] Allow an empty path with a non empty fragment or a query (jakzal)
 * bug #16528 [Translation] Add support for Armenian pluralization. (marcosdsanchez)
 * bug #16510 [Process] fix Proccess run with pts enabled (ewgRa)
 * bug #16292 fix race condition at mkdir (#16258) (ewgRa)
 * bug #15945 [Form] trigger deprecation warning when using empty_value (xabbuh)
 * bug #16384 [FrameworkBundle] JsonDescriptor - encode container params only once (xabbuh)
 * bug #16480 [VarDumper] Fix PHP7 type-hints compat (nicolas-grekas)
 * bug #16463 [PropertyAccess] Port of the performance optimization from 2.3 (dunglas)
 * bug #16462 [PropertyAccess] Fix dynamic property accessing. (dunglas)
 * bug #16454 [Serializer] GetSetNormalizer shouldn't set/get static methods (boekkooi)
 * bug #16453 [Serializer] PropertyNormalizer shouldn't set static properties (boekkooi)
 * bug #16471 [VarDumper] Fix casting for ReflectionParameter (nicolas-grekas)
 * bug #16294 [PropertyAccess] Major performance improvement (dunglas)
 * bug #16331 fixed Twig deprecation notices (fabpot)
 * bug #16306 [DoctrineBridge] Fix issue which prevent the profiler to explain a query  (Baachi)
 * bug #16359 Use mb_detect_encoding with $strict = true (nicolas-grekas)
 * bug #16144 [Security] don't allow to install the split Security packages (xabbuh)

* 2.7.6 (2015-10-27)

 * bug #16338 [VarDumper] Fix anonymous class dumping (nicolas-grekas)
 * bug #16288 [Process] Inherit env vars by default in PhpProcess (nicolas-grekas)
 * bug #16302 [DoctrineBridge] Fix required guess of boolean fields (enumag)
 * bug #16298 Changed one console output style to avoid visual issues (javiereguiluz)
 * bug #16291 [VarDumper] Fix return type and anonymous classes dumping (nicolas-grekas)
 * bug #16177 [HttpFoundation] Fixes /0 subnet handling in IpUtils (ultrafez)
 * bug #16262 [TwigBundle] Fix Twig cache is not properly warmed (tucksaun)
 * bug #16259 [Validator] Allow an empty path in a URL with only a fragment or a query (jakzal)
 * bug #16226 [filesystem] makeRelativePath does not work correctly from root (jaytaph, fabpot)
 * bug #16108 [Security] #15764. Use SessionAuthenticationStrategy on RememberMe login (s12v)
 * bug #16196 [Console] Fix progress bar formatting when max is set on start() and some other edge cases (vsychov, fabpot)
 * bug #16183 [VarDumper] Fix wordwrap with Bootstrap (ogizanagi)
 * bug #16182 [Process] Workaround buggy PHP warning (cbj4074)
 * bug #16095 [Console] Add additional ways to detect OS400 platform (johnkary)
 * bug #15793 [Yaml] Allow tabs before comments at the end of a line (superdav42)
 * bug #16152 Fix URL validator failure with empty string (fabpot, bocharsky-bw)
 * bug #15121 fixed #15118 [Filesystem] mirroring a symlink copies absolute file path (danepowell)
 * bug #15161 avoid duplicated path with addPrefix (remicollet)
 * bug #16146 [Security] sync translations and add a test for it (xabbuh)
 * bug #16133 compatibility with Security component split (xabbuh)
 * bug #16123 Command list ordering fix (spdionis, fabpot)
 * bug #14842 [Security][bugfix] "Remember me" cookie cleared on logout with custom "secure"/"httponly" config options  (MacDada)
 * bug #13627 [Security] InMemoryUserProvider now concerns whether user's password is changed when refreshing (issei-m)
 * bug #16090 Fix PropertyAccessor modifying array in object when array key does no… (pierredup)
 * bug #16092 [Process] Throw exception if tempnam returns false (pierredup)
 * bug #16111 Throw exception if tempnam returns false in ProcessPipes (pierredup)
 * bug #16087 Fixing typo in variable name (yceruto)
 * bug #16053 [Console] use PHP_OS instead of php_uname('s') (xabbuh)
 * bug #15860 [Yaml] Fix improper comments removal (ogizanagi)
 * bug #16050 [TwigBundle] fix useless and failing test (Tobion)
 * bug #16028 [DomCrawler] always pass base href to subcrawlers (xabbuh)
 * bug #15482 [Yaml] Improve newline handling in folded scalar blocks (teohhanhui)
 * bug #15976 [Console] do not make the getHelp() method smart (xabbuh)
 * bug #15799 [HttpFoundation] NativeSessionStorage `regenerate` method wrongly sets storage as started (iambrosi)
 * bug #15446 [Twig][Bridge] force space between widget and label in checkbox_radio_label (MatTheCat)
 * bug #15533 [Console] Fix input validation when required arguments are missing (jakzal)
 * bug #15915 Detect Mintty for color support on Windows (stof)
 * bug #15906 Forbid serializing a Crawler (stof)
 * bug #15682 [Form] Added exception when setAutoInitialize() is called when locked (jaytaph)
 * bug #15776 [TwigBridge] fix with_minutes option in time widget (arduanov)
 * bug #15846 [FrameworkBundle] Advanced search templates of bundles (yethee)
 * bug #15895 [Security] Allow user providers to be defined in many files (lyrixx)

* 2.7.5 (2015-09-25)

 * bug #15866 [VarDumper] Fix dump comparison on large arrays (romainneutron)
 * bug #15878 [OptionsResolver] Fix catched exception along the dependency tree mistakenly detects cyclic dependencies (lemoinem)
 * bug #15795 [Console] Default to stderr for the console helpers (2.7+) (alcohol)
 * bug #15821 [EventDispatcher] fix memory leak in getListeners (Tobion)
 * bug #15859 [Config] Fix enum default value in Yaml dumper (romainneutron)
 * bug #15826 [Finder] Optimize the hot-path (nicolas-grekas)
 * bug #15804 [VarDumper] Fix HtmlDumper constructor calling CliDumper's (nicolas-grekas)
 * bug #15802 [Finder] Handle filtering of recursive iterators and use it to skip looping over excluded directories (nicolas-grekas)
 * bug #15803 [Finder] Exclude files based on path before applying the sorting (stof)
 * feature #13761 Automatically process extensions when they implement CompilerPassInterface (WouterJ)
 * bug #13794 [DomCrawler] Invalid uri created from forms if base tag present (danez)
 * bug #15728 Use stderr by default when a specific output is not injected (Seldaek)
 * bug #15637 Use ObjectManager interface instead of EntityManager (gnat42)
 * bug #15783 [Debug] Fix case mismatch detection (nicolas-grekas)
 * bug #14802 [HttpKernel] fix broken multiline <esi:remove> (sstok)
 * bug #14841 [DoctrineBridge] Fixed #14840 (saksmt)
 * bug #15770 [Yaml] Fix the parsing of float keys (jmgq)
 * bug #15771 [Console] Ensure the console output is only detected as decorated when both stderr and stdout support colors (Seldaek)
 * bug #15750 Add tests to the recently added exceptions thrown from YamlFileLoaders (jakzal)
 * bug #15763 [HttpKernel] fix DumpDataCollector compat with Twig 2.0 (nicolas-grekas)
 * bug #15718 Fix that two DirectoryResources with different patterns would be deduplicated (mpdude)
 * bug #15516 [Translator][warmup][fallback locales] fixed missing cache file generation. (aitboudad)
 * bug #14916 [WebProfilerBundle] Added tabindex="-1" to not interfer with normal UX (drAlberT)
 * bug #15725 Dispatch console.terminate *after* console.exception (Seldaek)
 * bug #15731 improve exceptions when parsing malformed files (xabbuh)
 * bug #15737 Fix the injection of the container in invokable controllers (stof)
 * bug #15729 [Kernel] Integer version constants (Tobion)

* 2.7.4 (2015-09-08)

 * bug #15552 [ExpressionLanguage] Fixed expressions cache key generation (inso)
 * bug #15527 [Translator][fallback catalogues] fixed circular reference. (aitboudad)
 * bug #15662 [Form][ Choice type] fixed groups with empty array. (aitboudad)
 * bug #15601 [console] Use the description when no help is available (Nicofuma)
 * bug #15649 [VarDumper] Fix missing support for dumping PHP7 return type (nicolas-grekas)
 * bug #15603 [HttpKernel] Do not normalize the kernel root directory path #15567 (leofeyer)
 * bug #15647 [Debug] Ignore silencing for deprecations (nicolas-grekas)
 * bug #15625 Various fixes esp. on Windows (nicolas-grekas)
 * bug #15428 Fix the validation of form resources to register the default theme (stof)
 * bug #15623 Fix the retrieval of the value with property path when using a loader (stof)
 * bug #15619 [Translation] Fix the string casting in the XliffFileLoader (stof)
 * bug #15575 Add appveyor.yml for C.I. on Windows (nicolas-grekas)
 * bug #15493 [VarDumper] fixed HtmlDumper to target specific the head tag (SaschaDens)
 * bug #15611 [Translation][Xliff Loader] Support omitting the <target> node in an .xlf file. (leofeyer)
 * bug #15608 [Form] Fix the handling of values for multiple choice types (stof)
 * bug #15549 [FrameworkBundle] Fix precedence of xdebug.file_link_format (nicolas-grekas)
 * bug #15589 made Symfony compatible with both Twig 1.x and 2.x (fabpot)
 * bug #15590 Made Symfony 2.7 compatible with Twig 2.0 (fabpot)
 * bug #15535 made Symfony compatible with both Twig 1.x and 2.x (fabpot)
 * bug #15561 [Form] only use PropertyPath if not already callable (Tobion)
 * bug #15588 [WebProfilerBundle] add import for Twig macro (xabbuh)
 * bug #15546 [Form] fixed BC-break on grouped choice lists (origaminal)
 * bug #15515 [Console] Fixed warning when command alias is longer than command name (dosten)
 * bug #15251 [DoctrineBridge][Form] Fix IdReader when indexing by primary foreign key (giosh94mhz)
 * bug #14372 [DoctrineBridge][Form] fix EntityChoiceList when indexing by primary foreign key (giosh94mhz)
 * bug #15514 removed _self usage when not needed (fabpot)
 * bug #15489 Implement the support of timezone objects in the stub IntlDateFormatter (stof)
 * bug #15426 [Serializer] Add support for variadic arguments in the GetSetNormalizer (stof)
 * bug #15480 [Yaml] Nested merge keys (mathroc)
 * bug #15443 [Debug] Enhance DebugClassLoader performance on MacOSX (nicolas-grekas)
 * bug #15445 do not remove space between attributes (greg0ire)
 * bug #15263 [HttpFoundation] fixed the check of 'proxy-revalidate' in Response::mustRevalidate() (axiac)
 * bug #15425 [Routing] Fix the retrieval of the default value for variadic arguments in the annotation loader (wdalmut, stof)
 * bug #15074 Fixing DbalSessionHandler to work with a Oracle "limitation" or bug? (nuncanada)
 * bug #13828 [Validator] Improve Iban Validation (afurculita)
 * bug #15380 do not dump leading backslashes in class names (xabbuh)
 * bug #15376 [ClassMapGenerator] Skip ::class constant (WouterJ)
 * bug #15389 [securityBundle] Compare roles strictly when computing inherited roles (bokonet)
 * bug #15170 [Config] type specific check for emptiness (xabbuh)
 * bug #15411 Fix the handling of null as locale in the stub intl classes (stof)

* 2.7.3 (2015-07-31)

 * bug #15413 Fix the return value on error for intl methods returning arrays (stof)
 * bug #15392 Fix missing _route parameter notice in RouterListener logging case (Haehnchen)
 * bug #15390 [php7] Fix for substr() always returning a string (nicolas-grekas)
 * bug #15386 [php7] Fix for substr() always returning a string (nicolas-grekas)
 * bug #15355 [Security] Do not save the target path in the session for a stateless firewall (lyrixx)
 * bug #15306 [HttpKernel] [HttpCache] Fix deprecated error in HttpCache#getSurrogate (m14t)
 * bug #15369 [TwigBridge] type-dependent path discovery (marcosdsanchez, xabbuh)
 * bug #15361 [Yaml] throw a ParseException on invalid data type (xabbuh)
 * bug #15345 [Twig+FrameworkBundle] Fix forward compat with Form 2.8 (nicolas-grekas)
 * bug #15330 [Console] Fix console output with closed stdout (jakzal)
 * bug #15339 [Serializer] Fix 2 bugs regarding private setters (dunglas)
 * bug #15326 [Security] fix check for empty usernames (xabbuh)
 * bug #15291 [HttpFoundation] Fix Response::closeOutputBuffers() for HHVM 3.3 (nicolas-grekas)
 * bug #15249 [HttpFoundation] [PSR-7] Allow to use resources as content body and to return resources from string content (dunglas)
 * bug #15282 [HttpFoundation] Behaviour change in PHP7 for substr (Nicofuma)
 * bug #15277 [Form] Fix a BC break in the entity (jakzal)
 * bug #15271 fix broken ChoiceQuestion (sstok)
 * bug #15250 [PropertyAccess] BC Break since 2.6.5 (Nicolas Macherey)

* 2.7.2 (2015-07-13)

 * bug #15248 Added 'default' color (jaytaph)
 * bug #15243 Reload the session after regenerating its id (jakzal)
 * bug #15176 [Serializer] Fix ClassMetadata::sleep() (dunglas)
 * bug #15202 [Security] allow to use `method` in XML configs (xabbuh)
 * bug #15218 [Twig][Bridge] replaced `extends` with `use` in bootstrap_3_horizontal_layout.html.twig (MatTheCat)
 * bug #15223 [Finder] Command::addAtIndex() fails with Command instance argument (thunderer)
 * bug #15220 [DependencyInjection] Freeze also FrozenParameterBag::remove (lyrixx)
 * bug #15110 Add a way to reset the singleton (dawehner)
 * bug #15183 [TwigBridge] fix for legacy asset() with EmptyVersionStrategy (xabbuh)
 * bug #15115 [Validator] always evaluate binary format when changed (xabbuh)
 * bug #15163 Update DateTimeToArrayTransformer.php (zhil)
 * bug #15150 [Translation] Azerbaijani language pluralization rule is wrong (shehi)
 * bug #15159  Towards 100% HHVM compat (nicolas-grekas)
 * bug #15146 Towards 100% HHVM compat (nicolas-grekas)
 * bug #15061 [Form] Fixed handling of choices passed in choice groups (webmozart)
 * bug #15145 [Bridge/PhpUnit] Enforce a consistent locale (nicolas-grekas)
 * bug #15069 [Form] Fixed: Data mappers always receive forms indexed by their names (webmozart)
 * bug #15137 [Security] Initialize SwitchUserEvent::targetUser on attemptExitUser (Rvanlaak, xabbuh)
 * bug #15142 Fix choice translation domain for expanded choice widget (jvasseur)
 * bug #15126 [Validator] Fix BC for Validator's validate method (michalmarcinkowski)
 * bug #15101 [Form] Fixed compatibility with FormTypeInterface implementations that don't extend AbstractType (webmozart)
 * bug #15083 [DependencyInjection] Fail when dumping a Definition with no class nor factory (nicolas-grekas)
 * bug #15127 [Validator] fix validation for Maestro UK card numbers (xabbuh)
 * bug #15128 DbalLogger: Small nonutf8 array fix (vpetrovych, weaverryan)
 * bug #15048 [Translation][Form][choice] empty_value shouldn't be translated when it has an empty value (Restless-ET)
 * bug #15117 [Form] fixed sending non array data on submit to ResizeListener (BruceWouaigne)
 * bug #15122 [Console] respect multi-character shortcuts (xabbuh)
 * bug #15012 [Validator] don't trigger deprecation with empty group array (xabbuh)
 * bug #15102 [Translation][debug cmd] fixed failing tests. (aitboudad)
 * bug #13750 [DependencyInjection] Fixed decoration of service for service with parent (hason)
 * bug #15086 Fixed the regexp for the validator of Maestro-based credit/debit cards (javiereguiluz)
 * bug #15058 [Console] Fix STDERR output text on IBM iSeries OS400 (johnkary)
 * bug #14853 [Validator] more strict e-mail validation regex (xabbuh)
 * bug #15064 [Form] Fixed: Support objects with __toString() in choice groups (webmozart)
 * bug #15065 [Form] Fixed: remove quoted strings from Intl date formats (e.g. es_ES full pattern) (webmozart)
 * bug #15039 [Translation][update cmd] taken account into bundle overrides path. (aitboudad)
 * bug #15038 [Translation][debug cmd] taken account into bundle overrides path. (aitboudad)
 * bug #14964 [bugfix][MonologBridge] WebProcessor: passing $extraFields to BaseWebProcessor (MacDada)
 * bug #14989 [FrameworkBundle] Reuse PropertyAccessor service for ObjectNormalizer (dunglas)
 * bug #15036 [VarDumper] Fix dump output for better readability (nicolas-grekas)
 * bug #15031 [PhpUnitBridge] Enforce @-silencing of deprecation notices according to new policy (nicolas-grekas)
 * bug #15027 [Form] Fixed: Filter non-integers when selecting entities by int ID (webmozart, nicolas-grekas)
 * bug #15000 [Debug] Fix fatal-errors handling on HHVM (nicolas-grekas)
 * bug #14999 [Debug] Fix fatal-errors handling on HHVM (nicolas-grekas, digitalkaoz)
 * bug #14959 [Debug+VarDumper] Fix handling of PHP7 "Throwable" exceptions (nicolas-grekas)
 * bug #15010 [Debug] Fix log level of stacked errors (nicolas-grekas)
 * bug #15017 [VarDumper] Fix uninitialized id in HtmlDumper (nicolas-grekas)
 * bug #14980 Fixed fluent interface (jaytaph)
 * bug #14974 [Security][Translation] #14920 update translations (vincentaubert)
 * bug #14950 [Form] Fixed: Filter non-integers when selecting entities by int ID (webmozart)
 * bug #14930 Bug #14836 [HttpFoundation] Moves default JSON encoding assignment fr… (Incognito)

* 2.7.1 (2015-06-11)

 * bug #14835 [DependencyInjection] Fixed resolving of service configurators containing Definition objects (webmozart)
 * bug #14816 [TwigBridge] Make AppVariable check if security.context exists (ogizanagi)
 * bug #14897  Allow new lines in Messages translated with transchoice() (replacement for #14867)  (azine)
 * bug #14887 [Form] Swap new ChoiceView constructor arguments to ease migrating from the deprecated one (nicolas-grekas)
 * bug #14900 Silence deprecation warnings by default (reecefowell)
 * bug #14739 [Console] SymfonyStyle : fix blocks wordwrapping (ogizanagi)
 * bug #14740 [Console] SymfonyStyle : fix blocks output is broken on windows cmd (ogizanagi)
 * bug #14623 [Console] SymfonyStyle : fix & automate block gaps. (ogizanagi)
 * bug #14895 [Form] Support DateTimeImmutable in transform() (c960657)
 * bug #14891 without this change allways the legacy code get called (dominikzogg)
 * bug #14888 [Console] Fix ask and askHidden methods (dosten)
 * bug #14705 [Translator] avoid serialize unserializable resources. (aitboudad)
 * bug #14846 [console][TableCell] get cell width without decoration. (aitboudad)
 * bug #14852 [VarDumper] Fix generic casters calling order (nicolas-grekas)
 * bug #14855 [VarDumper] Changed tooltip to expand-all keybinding in OS X (taylankasap)
 * bug #14854 [Bridge\PhpUnit] Fix composer installed phpunit detection (nicolas-grekas)
 * bug #14859 Improve the config validation in TwigBundle (stof)
 * bug #14837 [SecurityBundle] Remove SecurityContext from Compile (Zander Baldwin)
 * bug #14793 [FrameworkBundle] make `templating.helper.router` service available again for BC reasons (xabbuh)
 * bug #14785 [BrowserKit] Fix bug when uri starts with http. (amouhzi)
 * bug #14807 [Security][Acl] enforce string identifiers (xabbuh)
 * bug #14808 [WebProfilerBundle][logger] added missing deprecation message. (aitboudad)

* 2.7.0 (2015-05-30)

 * bug #14777 Avoid using the app global variable in the profiler templates (stof)
 * bug #14262 [REVERTED] [TwigBundle] Refresh twig paths when resources change. (aitboudad)
 * security #14759 CVE-2015-4050 [HttpKernel] Do not call the FragmentListener if _controller is already defined (jakzal)
 * bug #14745 [Serializer] AbstractNormalizer::instantiateObject allow default values when not optional (boekkooi)
 * bug #14743 [DebugBundle] Fix config XSD (nicolas-grekas)
 * bug #14711 [Serializer] AbstractNormalizer instantiateObject avoid `null` rejection (boekkooi)
 * bug #14726 [Translation] fixed JSON loader on PHP 7 when file is empty (fabpot)
 * bug #14715 [Form] Check instance of FormBuilderInterface instead of FormBuilder (dosten)
 * bug #14654 [Console] SymfonyStyle : fix blocks failed when $messages is null (ogizanagi)
 * bug #14708 [TwigBridge] use proper class to fetch asset version strategy property (xabbuh)
 * bug #14678 [Security] AbstractRememberMeServices::encodeCookie() validates cookie parts (MacDada)
 * bug #14635 [HttpKernel] Handle an array vary header in the http cache store (jakzal)
 * bug #14513 [console][formater] allow format toString object. (aitboudad)
 * bug #14335 [HttpFoundation] Fix baseUrl when script filename is contained in pathInfo (danez)
 * bug #14593 [Security][Firewall] Avoid redirection to XHR URIs (asiragusa)
 * bug #14576 [DoctrineBridge][Form] Fix BC break in DoctrineType (malarzm)
 * bug #14551 [Form] Fixed ChoiceType with legacy ChoiceList (xelaris)
 * bug #14648 [Console] Fix first choice was invalid when using value (ogizanagi)
 * bug #14618 [DomCrawler] Throw an exception if a form field path is incomplete (jakzal)
 * bug #14699  Fix HTML escaping of to-source links (amenk, nicolas-grekas)
 * bug #14698  Fix HTML escaping of to-source links (nicolas-grekas)
 * bug #14690 [HttpFoundation] IpUtils::checkIp4() should allow `/0` networks (zerkms)
 * bug #14696 Fix the rendering of deprecation log messages (stof)
 * bug #14683 Fixed the indentation in the compiled template for the DumpNode (stof)
 * bug #14262 [TwigBundle] Refresh twig paths when resources change. (aitboudad)
 * bug #13633 [ServerBag] Handled bearer authorization header in REDIRECT_ form (Lance0312)
 * bug #13637 [CSS] WebProfiler break words (nicovak)
 * bug #14217 [WebProfilerBundle] Fix regexp (romqin)
 * bug #14644 [Bridge\Twig] Adding a space between the icon and the error message (zmikael, nicolas-grekas)
 * bug #14645 [WebProfilerBundle] Fix compatiblity with HttpKernel < 2.7 (GromNaN)
 * bug #14640 [DebugBundle] Allow alternative destination for dumps (nicolas-grekas)
 * bug #14600 [Console] SymfonyStyle: fix block rpadding when escaping '<' (ogizanagi)
 * bug #14633 [EventDispatcher] make listeners removable from an executed listener (xabbuh)

* 2.7.0-BETA2 (2015-05-13)

 * bug #14609 [DebugBundle] Remove inlined dumps on XHR (nicolas-grekas)
 * bug #14605 [PropertyAccess] Fix setting public property on a class having a magic getter (lolautruche)
 * bug #14266 [HttpKernel] Check if "symfony/proxy-manager-bridge" package is installed (hason)
 * bug #14465 [Form] Fixed regression: Empty values were not accepted anymore for collapsed, optional choice fields (webmozart)
 * bug #14478 [DebugBundle] Fix dump() output in API / No-Toolbar context (nicolas-grekas)
 * bug #14501 [ProxyBridge] Fix proxy classnames generation (xphere)
 * bug #14540 [Serializer] Ignore \Traversable in default normalizers. (dunglas)
 * bug #14527 Fix getOrigin (WouterJ)
 * bug #14395 [Validator] Property paths starting with 0 are broken. (fago)
 * feature #14472 [Debug] Trigger deprecation notices when using PHP7 reserved class names (nicolas-grekas)
 * bug #14498 [FrameworkBundle] Added missing log in server:run command (lyrixx)
 * bug #14503 [Finder] Only use GLOB_BRACE when available (dosten)
 * bug #14484 [SecurityBundle][WebProfiler] check authenticated user by tokenClass instead of username. (aitboudad)
 * bug #14497 [HttpFoundation] Allow curly braces in trusted host patterns (sgrodzicki)
 * bug #14480 [TwigBundle] Fix deprecated use of FlattenException (alOneh)
 * bug #14469 [Debug] BaseException compatibility for PHP7 (nicolas-grekas)
 * bug #14483 [VarDumper] Fix #14481 : Open tree recursively on OSX (romainneutron)
 * bug #14466 [WebProfiler] fix html syntax for input types (Tobion)
 * bug #14436 Show a better error when the port is in use (dosten)
 * bug #14463 [Validator] Fixed Choice when an empty array is used in the "choices" option (webmozart)
 * bug #14415 [Serializer] Fix a bug when using groups together with a name converter (dunglas)
 * bug #14301 [FrameworkBundle][Translation] skip warmUp when cache is not used. (aitboudad)
 * bug #14446 [DependencyInjection] resolve circular reference (xabbuh)
 * feature #14187 [Serializer] Supports hassers and setters for groups annotations (dunglas)
 * feature #14462 Revert "[HttpKernel] Throw a LogicException when kernel.exception does not led to a Response" (nicolas-grekas)
 * bug #14448 [Validator] Fixed Choice when an empty array is used in the "choices" option (webmozart)
 * bug #14451 [Debug] Fix ClassNotFoundFatalErrorHandler candidates lookups (nicolas-grekas)
 * bug #14422 Update DebugClassLoader.php (userfriendly)
 * bug #14419 inject asset packages in assets helper service (xabbuh)
 * bug #14355 [EventDispatcher] make listeners removable from an executed listener (xabbuh)
 * bug #14397 [Debug] Map PHP errors to LogLevel::CRITICAL (nicolas-grekas)
 * bug #14402 [FrameworkBundle][Translation] Check for 'xlf' instead of 'xliff' (xelaris)
 * bug #14272 [FrameworkBundle] Workaround php -S ignoring auto_prepend_file (nicolas-grekas)
 * bug #14362 [Debug] Scream as LogLevel::DEBUG (but for fatal errors / uncaught exceptions) (nicolas-grekas)
 * bug #14345 [FrameworkBundle] Fix Routing\DelegatingLoader resiliency to fatal errors (nicolas-grekas)
 * bug #14381 [FrameworkBundle] Initialize translator with the default locale. (aitboudad)
 * bug #14325 [Routing][DependencyInjection] Support .yaml extension in YAML loaders (thunderer)
 * bug #14344 [Translation][fixed test] refresh cache when resources are no longer fresh. (aitboudad)
 * bug #14346  [WebProfilerBundle] Fix resiliency to exceptions thrown by the url generator (nicolas-grekas)
 * bug #14338 [FrameworkBundle] improve usage of Table helper (xabbuh)
 * bug #14315 [Translation] Revert inlining fallback catalogues as it might cause inconsistent results when a cache is used (mpdude)
 * bug #14129 [FrameworkBundle] Fixed server:start --router relative path issue #14124 (abulford)
 * bug #14313 [HttpKernel] fixed a regression when no exception listeners are registered (fabpot)
 * bug #14268 [Translator] Cache does not take fallback locales into consideration (sf2.3) (mpdude)

* 2.7.0-BETA1 (2015-04-10)

 * feature #14229 [WebProfilerBundle] AJAX links (romqin)
 * feature #13220 [Console] Made output docopt compatible (WouterJ)
 * feature #14178 [Config] Delegate creation of ConfigCache instances to a factory. (mpdude)
 * feature #13443 [Translation][Command][FrameworkBundle] Enable translation debugging in directories (xelaris)
 * feature #14198 Automatically start server:run if server:start failed (WouterJ)
 * feature #13651 [Form][choice] added choice_translation_domain to avoid trans options. (aitboudad)
 * feature #14185 [Translation][Profiler]added the number of times a translation has been used. (aitboudad)
 * feature #13717 Deprecated precision option in favor of scale (WouterJ)
 * feature #14159 [Debug] Add symfony_debug_backtrace() and use it when dealing with fatal errors (jpauli, nicolas-grekas)
 * feature #14192 [HttpKernel] Embed the original exception as previous to bounced exceptions (nicolas-grekas)
 * feature #13626 [WebProfilerBundle] Added feedback about the current symfony version (WouterJ)
 * feature #13554 [TwigBundle] make date formats and number formats configurable (xabbuh)
 * feature #14196 Tweaked some console command styles (javiereguiluz)
 * feature #14181 [Debug] Updated the default log level when a PHP error occurs (lyrixx)
 * feature #14186 [Debug] Renamed "context" key to "scope_vars" to avoid any ambiguity (lyrixx)
 * feature #13942 [Translation] generate translation cache at warmup (xavierleune)
 * feature #14116 [FrameworkBundle] Move lint commands to lint namespace. (aitboudad)
 * feature #14052 [FrameworkBundle] added a protected shortcut getParameter() method in the base Controller class. (hhamon)
 * feature #14080 [VarDumper] Add casters for Reflection* classes (nicolas-grekas)
 * feature #14050 [Form] Refactored choice lists to support dynamic label, value, index and attribute generation (webmozart)
 * feature #14079 [VarDumper] Add and use Caster::PREFIX_* consts (nicolas-grekas)
 * feature #14057 [RFC][Console] Added console style guide helpers (v2) (kbond)
 * feature #14077 [VarDumper] Add VarDumperTestCase and related trait (nicolas-grekas)
 * feature #14058 [VarDumper] Add filters to casters (nicolas-grekas)
 * feature #14003 [Translation][Profiler] Added a Translation profiler. (aitboudad)
 * feature #14002 [Translation][Extractor] Allow extracting an array of files besides extracting a directory (marcosdsanchez)
 * feature #13438 [Console][Table] Add support for colspan/rowspan + multiple header lines (aitboudad)
 * feature #14071  	[VarDumper] Ctrl+click toggles-all and fix IE8 support (larsborn, nicolas-grekas)
 * feature #13981 [Translation] merge all fallback catalogues messages into current catalo... (aitboudad)
 * feature #14006 [VarDumper] with-er interface for Cloner\Data (nicolas-grekas)
 * feature #14034 [VarDumper] add caster for MongoCursor objects (nicolas-grekas)
 * feature #14030 [DependencyInjection] make it possible to dump inlined services to XML (xabbuh)
 * feature #14016   Remove the API version in the validator component (saro0h, fabpot, stof)
 * feature #13960 [VarDumper] Add Caster for XML-parser resources (nicolas-grekas)
 * feature #13937 [FrameworkBundle] Allow to disable Kernel reboot (sroze)
 * feature #13892 [DependencyInjection] Improved yaml syntax (hason)
 * feature #14000 [SECURITY][ACL] fixed Base ACL exceptions on the RuntimeException (Neophy7e)
 * feature #14001  [Security] [ACL] Improved MaskBuilder and PermissionMap (AlexDpy)
 * feature #13959 [VarDumper] Add catch-all-objects hook for casters (nicolas-grekas)
 * feature #13980 [VarDumper] Added support for amqp (lyrixx)
 * feature #12818 [SecurityBundle] Added a command to encode a password (saro0h)
 * feature #13107 [FrameworkBundle] Serializer groups support (dunglas)
 * feature #13872 [FrameworkBundle] Added domain column when debugging translations (hiddewie)
 * feature #13780 [HttpKernel] Throw a LogicException when kernel.exception does not lead to a Response (nicolas-grekas)
 * feature #13897 [translation][performances] move loading resources into Translator initialize. (aitboudad)
 * feature #13864 Entity type: loader caching by query builder instance (dominikzogg)
 * feature #13855 Read validation contraints from Resources/config/validation/ sub-dir (GromNaN)
 * feature #13257 [Serializer] ObjectNormalizer (dunglas)
 * feature #13795 [Serializer] Refactoring of metadata (dunglas)
 * feature #13840 [WebProfilerBundle] Update ajax calls in toolbar to add the css error class (rubenrua)
 * feature #13809 [OptionsResolver] add missing deprecation triggers (Tobion)
 * feature #13398 [PhpUnit] new PhpUnit bridge (nicolas-grekas)
 * feature #13615 [FrameworkBundle] Made ServerParams a service (rpg600)
 * feature #12526 Add an auto_alias compiler pass (Daniel Wehner)
 * feature #13665 [Debug] generalize deprecated interfaces tracking (nicolas-grekas)
 * feature #13656 removed Propel bridge from Symfony Core (fabpot)
 * feature #13500 [Serializer] Normalizers can serialize collections and scalars (dunglas)
 * feature #13463 [WebProfilerBundle] Replaced raster PNG icons with vector SVG icons (sgrodzicki)
 * feature #13234 [Asset] added the component (fabpot)
 * feature #11379 Added new Forwarded header support for Request::getClientIps (tony-co)
 * feature #9782 [Security] added string representation for core Users (tobiassjosten)
 * feature #12174 [TwigBundle] Add loader priority (wizhippo)
 * feature #13074 [Translation] Refresh catalogues when resources change (iamluc)
 * feature #13294 [PropertyAccess] Show property path in all exception messages (mpajunen)
 * feature #13548 [TwigBridge] Added support for passing more files to twig:lint command (sustmi)
 * feature #13120 [Serializer] Name converter support (dunglas)
 * feature #13428 Added a Twig profiler (fabpot)
 * feature #11129 Added i18n support to ConfirmationQuestion (WouterJ)
 * feature #13034 [HttpKernel] [WebProfilerBundle] added HTTP status to profiler search result (xelaris)
 * feature #13475 [SecurityBundle] decouple the logout PHP helper and Twig extension (fabpot)
 * feature #12891 [Form] Deprecated setDefaultOptions() in favor of configureOptions() (peterrehm)
 * feature #13342 [security] Fetching current stored context when not explicitly specified (jaytaph)
 * feature #12960 [FrameworkBundle] Container parameters in Route#condition (nikita2206)
 * feature #13418 [DX] Attempt to improve logging messages with  parameters (iltar)
 * feature #13320 [HttpKernel] Add request uri to Logger context (Rvanlaak)
 * feature #13401 [TwigBundle] use the new Twig autoescaping strategy (fabpot)
 * feature #13361 [Routing] apply deprecation triggers and fix tests (Tobion)
 * feature #13378 lazy-load fragment renderers (fabpot)
 * feature #13354 Twig decoupling from Templating (fabpot)
 * feature #13264 URL manipulations as a Twig extension (fabpot)
 * feature #13289 [DependencyInjection] deprecated synchronized services (fabpot)
 * feature #13323 [Security] removed usage of the deprecated SecurityContextInterface (fabpot)
 * feature #13241 [Form] add back model_timezone and view_timezone options (xabbuh)
 * feature #13252 [Serializer] Refactoring and object_to_populate support. (dunglas)
 * feature #13255 [Serializer] Add circular reference handling to the PropertyNormalizer (dunglas)
 * feature #13259 Deprecate the translator implementation in the Validator component (stof)
 * feature #12956 [Validator] Added checkDNS option on URL validator (saro0h)
 * feature #13230 [TwigBundle] removed the Container dependency on ActionsExtension (fabpot)
 * feature #12602 Add type aliases for allowed types in OptionsResolver (henrikbjorn)
 * feature #12594 [DX] [HttpKernel] Use "context" argument when logging route in RouterListener (iltar)
 * feature #12653 [Filesystem] Keep executable permission when a file is copied (joelwurtz)
 * feature #13164 [Debug] track and report deprecated classes and interfaces (nicolas-grekas)
 * feature #13157 [Security] Updated ACL generateSql.php (jaytaph)
 * feature #13105 [FrameworkBundle] added a test router for the built-in web server (fabpot)
 * feature #12092 [Serializer] Serialization groups support (dunglas)
 * feature #13031 [Serializer] Add xml_format_output context option. Close #12517. (dunglas)
 * feature #12862 [Console] Allowing the user answering key or value of the autocompleterValues (saro0h)
 * feature #12469 [Security] Added the triggering of the security.interactive_login event in SimplePreAuthenticationListener (saro0h)
 * feature #12896 [DX][Profiler] Show the inherited roles in the web profiler (peterrehm)
 * feature #12295 [FrameworkBundle] make GetSetMethodNormalizer available by default (dunglas)
 * feature #12666 [Hackday][Stopwatch] added __toString on StopwatchEvent (damienalexandre)

