CHANGELOG for 4.2.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 4.2 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v4.2.0...v4.2.1

* 4.2.2 (2019-01-06)

 * bug #29494 [HttpFoundation] Fix request uri when it starts with double slashes (alquerci)
 * bug #29697 [DI] Fixed wrong factory method in exception (Wojciech Gorczyca)
 * bug #29679 [HttpKernel] Correctly Render Signed URIs Containing Fragments (zanbaldwin)
 * bug #29754 Ensure final input of CommandTester works with default (Firehed)
 * bug #29695 [Form] Do not ignore the choice groups for caching (vudaltsov)
 * bug #29738 [Intl] handle null date and time types (xabbuh)
 * bug #29708 [FrameworkBundle] access the container getting it from the kernel (xabbuh)
 * bug #29676 [HttpFoundation] Fix erasing cookies issue (eiannone)
 * bug #29741 [VarExporter] fix exporting array indexes (xabbuh)
 * bug #29704 [FrameworkBundle] improve errors in tests missing the BrowserKit component (xabbuh)
 * bug #29721 [SecurityBundle] Fix traceable voters (ro0NL)
 * bug #29617 [Console] Add specific replacement for help text in single command applications (codedmonkey)
 * bug #29714 [Event Dispatcher] fixed 29703: TraceableEventDispatcher reset() callStack to null (mlievertz)
 * bug #29597 [DI] fix reporting bindings on overriden services as unused (nicolas-grekas)
 * bug #29639 [Yaml] detect circular references (xabbuh)
 * bug #29644 [Cache] fix bad optim (nicolas-grekas)
 * bug #29648 [Cache] fix Simple\Psr6Cache proxying of metadata (nicolas-grekas)
 * bug #29569 [FrameworkBundle] decouple debug:autowiring from phpdocumentor/reflection-docblock (SerkanYildiz)
 * bug #29546 [DI] map snake-case ids of service subscribers to camel-case autowiring aliases (nicolas-grekas)
 * bug #29409 Fix env fallback to an unresolved variable (jderusse)
 * bug #29626 [Routing] fix trailing slash redirections involving a trailing var (nicolas-grekas)
 * bug #29411 [EventDispatcher] Revers event tracing order (ro0NL)
 * bug #29533 Fixed public directory when configured in composer.json (alexander-schranz)
 * bug #29619 [Console] OutputFormatter: move strtolower to createStyleFromString (ogizanagi)
 * bug #29621 [Security] Prefer clone() over unserialize(serialize()) for user refreshment (chalasr)
 * bug #29591 [Cache] Fix undefined variable in ArrayTrait (eXtreme)
 * bug #29558 [Messenger] Restore message handlers laziness (chalasr)
 * bug #29589 [VarExporter] dont call userland code with uninitialized objects (nicolas-grekas)
 * bug #29542 [Routing] fix dumping same-path routes with placeholders (nicolas-grekas)
 * bug #29587 [Debug] ignore underscore vs backslash namespaces in DebugClassLoader (nicolas-grekas)
 * bug #29584 [FrameworkBundle] fix describing routes with no controllers (nicolas-grekas)
 * bug #29582 [DI] move RegisterServiceSubscribersPass before DecoratorServicePass (kbond)
 * bug #29527 [TwigBridge][Form] Prevent multiple rendering of form collection prototypes (Shoplifter)
 * bug #29571 [Yaml] ensures that the mb_internal_encoding is reset to its initial value (Jörn Lang)
 * bug #29513 [Hackday][Serializer] Deserialization ignores argument type hint from phpdoc for array in constructor argument (karser)
 * bug #29323 [Security] defer log message in guard authenticator (eschultz-magix)
 * bug #29539 [WebProfilerBundle][TwigBundle] CSS fixes (ro0NL)
 * bug #29543 [Cache] Don't erase processed redis dsn (chalasr)
 * bug #29531 [Validator] Added IBAN format for Vatican City State (raulfraile)
 * bug #29501 [Form] filter out invalid language values (xabbuh)
 * bug #29307 [Form] Filter arrays out of scalar form types (nicolas-grekas)
 * bug #29500 [Form] filter out invalid Intl values (xabbuh)
 * bug #29499 [Validator] Fixed grouped composite constraints (HeahDude)

* 4.2.1 (2018-12-06)

 * security #cve-2018-19790 [Security\Http] detect bad redirect targets using backslashes (xabbuh)
 * security #cve-2018-19789 [Form] Filter file uploads out of regular form types (nicolas-grekas)
 * bug #29481 [TwigBridge] Deprecating legacy Twig paths in DebugCommand and simplifications (yceruto)
 * bug #29436 [Cache] Fixed Memcached adapter doClear()to call flush() (raitocz)
 * bug #29482 Fixes sprintf(): Too few arguments in MessageFormatter::choiceFormat (stephanedelprat)
 * bug #29461 [Contracts] extract LocaleAwareInterface out of TranslatorInterface (nicolas-grekas)
 * bug #29446 [VarExporter] fix dumping private properties from abstract classes (nicolas-grekas)
 * bug #29441 [Routing] ignore trailing slash for non-GET requests (nicolas-grekas)
 * bug #29445 [FrameworkBundle] Fix empty output for debug:autowiring when reflection-docblock is not installed (chalasr)
 * bug #29444 [Workflow] Fixed BC break for Workflow metadata (lyrixx)
 * bug #29432 [DI] dont inline when lazy edges are found (nicolas-grekas)
 * bug #29413 [Serializer] fixed DateTimeNormalizer to maintain microseconds when a different timezone required (rvitaliy)
 * bug #29424 [Routing] fix taking verb into account when redirecting (nicolas-grekas)
 * bug #29418 [VarExporter] fix dumping protected property from abstract classes (nicolas-grekas)
 * bug #29414 [DI] Fix dumping expressions accessing single-use private services (chalasr)
 * bug #28853 [LDAP] Add TIMEOUT Option to LDAP Connection Options (lmatte7)
 * bug #29399 [FrameworkBundle] define doctrine as default_pdo_provider only if the package is installed (nicolas-grekas)
 * bug #29375 [Validator] Allow `ConstraintViolation::__toString()` to expose codes that are not null or emtpy strings (phansys)
 * bug #29376 [EventDispatcher] Fix eventListener wrapper loop in TraceableEventDispatcher (jderusse)
 * bug #29386 undeprecate the single-colon notation for controllers (fbourigault)
 * bug #29393 [DI] fix edge case in InlineServiceDefinitionsPass (nicolas-grekas)
 * bug #29394 [Config] fix path exclusion during glob discovery (nicolas-grekas)
 * bug #29395 [FrameworkBundle][Messenger] Restore check for messenger serializer default id (ogizanagi)
 * bug #29380 [Routing] fix greediness of trailing slash (nicolas-grekas)

* 4.2.0 (2018-11-30)

 * bug #29343 [Form] Handle all case variants of "nan" when parsing a number (mwhudson, xabbuh)
 * bug #29373 [Routing] fix trailing slash redirection (nicolas-grekas)
 * bug #29355 [PropertyAccess] calculate cache keys for property setters depending on the value (xabbuh)
 * bug #29369 [DI] fix combinatorial explosion when analyzing the service graph (nicolas-grekas)
 * bug #29349 [Debug] workaround opcache bug mutating "$this" !?! (nicolas-grekas)
 * bug #29344 Fixes sprintf(): Too few arguments in Translator (stephanedelprat)
 * bug #29318 [Console] Move back root exception to stack trace in verbose mode (chalasr)

* 4.2.0-RC1 (2018-11-26)

 * bug #29332 [PropertyAccess] make cache keys encoding bijective (nicolas-grekas)
 * bug #29298 [Routing] fix trailing slash redirection when using RedirectableUrlMatcher (nicolas-grekas)
 * bug #29297 [Routing] fix trailing slash redirection when using RedirectableUrlMatcher (nicolas-grekas)
 * bug #29313 [PropertyAccessor] fix encoding of cache keys (nicolas-grekas)
 * bug #29328 [HttpKernel] handle anonymous classes when generating the dumped container class name (nicolas-grekas)
 * bug #28917 [DoctrineBridge] catch errors while converting to db values in data collector (alekitto)
 * bug #29317 [WebProfiler] Detect non-file paths in file viewer (ro0NL)
 * bug #29305 [EventDispatcher] Unwrap wrapped listeners internally (ro0NL)
 * bug #29302 [Contracts][Cache] allow retrieving metadata of cached items (nicolas-grekas)
 * bug #29315 [DI] fix copying expression providers when analyzing the service graph (nicolas-grekas)
 * bug #27314 [DoctrineBridge] fix case sensitivity issue in RememberMe\DoctrineTokenProvider (PF4Public)
 * bug #29310 [MonologBridge] Return empty list for unknown requests (ro0NL)
 * bug #29316 [VarDumper] Fix ClassStub ellipsis (ro0NL)
 * bug #29300 [Translation] fix dumping catalogues cache (nicolas-grekas)
 * bug #29308 [Translation] Use XLIFF source rather than resname when there's no target (thewilkybarkid)
 * bug #26244 [BrowserKit] fixed BC Break for HTTP_HOST header (brizzz)
 * bug #28147 [DomCrawler] exclude fields inside "template" tags (Gorjunov)
 * bug #29260 [Lock] Fixed PdoStore::putOffExpiration(), PdoStore::getHashedKey() (PavelPrischepa)
 * bug #29222 [Dotenv] properly parse backslashes in unquoted env vars (xabbuh)
 * bug #29256 [HttpFoundation] Fixed absolute Request URI with default port (thomasbisignani)
 * bug #29274 [Routing] Remove duplicate schemes and methods for invokable controllers (claudusd)
 * bug #29285 [HttpKernel][WebProfilerBundle] Getting the cached client mime type instead of guessing it again (yceruto)
 * bug #29271 [HttpFoundation] Fix trailing space for mime-type with parameters (Sascha Dens)
 * feature #29167 [Messenger] Add a trait for synchronous query & command buses (ogizanagi)
 * bug #29243 [Cache] fix optimizing Psr6Cache for AdapterInterface pools (nicolas-grekas)
 * bug #29247 [DI] fix taking lazy services into account when dumping the container (nicolas-grekas)
 * bug #29249 [Form] Fixed empty data for compound date interval (HeahDude)
 * bug #29265 [Bridge/PhpUnit] Use composer to download phpunit (nicolas-grekas)
 * bug #28769 [FrameworkBundle] deal with explicitly enabled workflow nodes (xabbuh)

* 4.2.0-BETA2 (2018-11-16)

 * bug #29190 [Debug][HttpKernel] remove frames added by DebugClassLoader in stack traces (nicolas-grekas)
 * bug #29233 [FrameworkBundle] metadata_update_threshold default value must be an int (dunglas)
 * bug #29226 [Messenger] Improved message when handler class does not exist (neeckeloo)
 * bug #29223 [Validator] Added the missing constraints instance checks (thomasbisignani)
 * bug #28966 [PropertyAccessor] Fix unable to write to singular property using setter while plural adder/remover exist (karser)
 * bug #29182 [Form] Fixed empty data for compound date types (HeahDude)
 * bug #29224 [SecurityBundle] Fix remember-me cookie framework inheritance when session is disabled (fbourigault)
 * bug #29220 [Translation] make intl+icu format seamless by handling it in MessageCatalogue (nicolas-grekas)
 * feature #29166 [Messenger] Add handled & sent stamps (ogizanagi)
 * bug #29209 [VarExporter] fix handling of __sleep() (nicolas-grekas)
 * bug #29196 [Messenger] Fix collecting messages (ro0NL)
 * bug #29205 [Dotenv] skip loading "local" env twice (nicolas-grekas)
 * bug #29204 [FrameworkBundle][WebServerBundle] Revert deprecation of --env and --no-debug console options (chalasr)
 * bug #29191 [Routing] generate(null) should throw an exception (nicolas-grekas)
 * bug #29199 [FrameworkBundle] conflict with Dotenv <4.2 to simplify recipes (nicolas-grekas)
 * bug #29197 Revert "bug #29154 [FrameworkBundle] Define APP_ENV/APP_DEBUG from argv via Application::bootstrapEnv() (nicolas-grekas)
 * bug #29185 [Form] Fixed keeping hash of equal \DateTimeInterface on submit (HeahDude)
 * bug #29183 [HttpKernel] Fix collecting uploaded files (ro0NL)
 * bug #29141 [Workflow] Fixed bug of buildTransitionBlockerList when many transition are enabled (Tetragramat, lyrixx)
 * bug #29137 [Workflow][FrameworkBundle] fixed guard event names for transitions (destillat, lyrixx)
 * bug #29184 [WebProfilerBundle] Fix theme settings (ro0NL)
 * feature #29159 [Messenger] collect all stamps added on Envelope as collections (nicolas-grekas)
 * bug #29171 [Dotenv] load .env.dist when it exists and .env is not found (nicolas-grekas)
 * bug #28731 [Form] invalidate forms on transformation failures (xabbuh)
 * bug #29152 [Config] Unset key during normalization (ro0NL)
 * bug #29165 [DI] align IniFileLoader to PHP bugfix #76965 (nicolas-grekas)
 * bug #29154 [FrameworkBundle] Define APP_ENV/APP_DEBUG from argv via Application::bootstrapEnv() (chalasr)
 * bug #29129 [Dotenv] add loadEnv(), a smoother alternative to loadForEnv() (nicolas-grekas)
 * bug #29113 [Routing] fix dumping conditions that use the request (nicolas-grekas)
 * bug #29115 Change button_widget class to btn-primary (neFAST)
 * bug #29131 [Dotenv] dont use getenv() to read SYMFONY_DOTENV_VARS (nicolas-grekas)
 * bug #29057 [HttpFoundation] replace any preexisting Content-Type headers (nicolas-grekas)
 * bug #29076 [Serializer] Allow null values when denormalizing with constructor missing data (danut007ro)
 * bug #29128 [FrameworkBundle] Cleaning translation commands and fix a bug for --all option (yceruto)
 * bug #29104 [DI] fix dumping inlined services (nicolas-grekas)
 * bug #29054 [VarDumper] fix dump of closures created from callables (nicolas-grekas)
 * bug #29102 [DI] fix GraphvizDumper ignoring inline definitions (nicolas-grekas)
 * bug #29090 LoggingTranslator should implement Symfony\Contracts\Translation\TranslatorInterface (desmax)
 * bug #29095 [TwigBridge] require the needed symfony/contracts package (xabbuh)
 * bug #29107 [DI] dont track classes/interfaces used to compute autowiring error messages (nicolas-grekas)
 * bug #29094 Add samesite attribute to session cookie after session migration (rpkamp)
 * bug #29080 [FrameworkBundle] fix deps (ro0NL)

* 4.2.0-BETA1 (2018-11-03)

 * feature #28622 [VarDumper] add caster for Memcached (jschaedl)
 * feature #29042 [DI] use filter_var() instead of XmlUtils::phpize() in EnvVarProcessor (nicolas-grekas)
 * feature #29047 Revert "[HttpFoundation] Adds getAcceptableFormats() method for Request" (Tobion)
 * feature #29046 [Bridge/Doctrine] remove workarounds from the past (nicolas-grekas)
 * feature #29022 [Cache] allow to skip saving the computed value when using CacheInterface::get() (nicolas-grekas)
 * feature #29010  [Messenger] make senders and handlers subscribing to parent interfaces receive *all* matching messages, wildcard included (nicolas-grekas)
 * feature #29006 [Messenger] make TraceableMiddleware decorate a StackInterface instead of each middleware to free the callstack from noisy frames (nicolas-grekas)
 * feature #28970 [FrameworkBundle] make debug:autowiring list useful services and their description (nicolas-grekas)
 * feature #28952 [Translation] allow using the ICU message format using domains with the "+intl-icu" suffix (nicolas-grekas)
 * feature #27914 [Security][SecurityBundle] Add voter individual decisions to profiler (l-vo)
 * feature #28985 [Messenger] Move MiddlewareTestCase in Test ns (ogizanagi)
 * feature #28892 [FrameworkBundle] Deprecate support for legacy directories in Translation comands (chalasr)
 * feature #28854 [VarDumper] Scroll into view when searching (ro0NL)
 * feature #28997 [FrameworkBundle] Deprecating support for legacy translations directory (yceruto)
 * feature #28983 [Messenger] make dispatch(), handle() and send() methods return Envelope (nicolas-grekas)
 * feature #28533 [DotEnv] Add a new loadForEnv() method mimicking Ruby's dotenv behavior (dunglas)
 * feature #28943 [Messenger] Add `StackInterface`, allowing to unstack the call stack (nicolas-grekas)
 * feature #28860 [Form] Deprecate TimezoneType regions option (ro0NL)
 * feature #28945 [Messenger] remove AllowNoHandlerMiddleware in favor of a constructor argument on HandleMessageMiddleware (nicolas-grekas)
 * feature #28947 [Messenger] remove classifying sub-namespaces in favor of semantic ones (nicolas-grekas)
 * feature #27917 [Validator] catch any UnexpectedValueException on validation (xabbuh)
 * feature #28875 [FWBundle] Add a new method AbstractController::addLink() (dunglas)
 * feature #28934 [WebProfilerBundle] Add channel log filter (ro0NL)
 * feature #28939 [WebProfilerBundle] Remove application name (ro0NL)
 * feature #28709 [Serializer] Refactor and uniformize the config by introducing a default context (dunglas)
 * feature #28914 [Messenger] make Envelope first class citizen for middleware handlers (nicolas-grekas)
 * feature #28909 [Messenger] made dispatch() and handle() return void (nicolas-grekas)
 * feature #28936 [WebProfilerBundle] Replay referer URL (ro0NL)
 * feature #28893 [TwigBundle] Fix usage of TwigBundle without FrameworkBundle (tgalopin)
 * feature #28891 [TwigBundle] Deprecating support for legacy templates directories (yceruto)
 * feature #28911 [Messenger] rename "envelope items" and move them in the "Stamp" namespace (nicolas-grekas)
 * feature #27043 [Form][TwigBridge] Add help_attr (mpiot)
 * feature #28810 [HttpKernel] Deprecate usage of getRootDir() and kernel.root_dir (fabpot)
 * feature #28809 [HttpKernel] Deprecate the Kernel name (fabpot)
 * feature #28807 [HttpFoundation] Make ResponseHeaderBag::makeDisposition static (fabpot)
 * feature #28842 [Validator] Deprecate checkMX and checkHost on Email validator (fabpot)
 * feature #28833 [Intl] Blacklist invalid languages (ro0NL)
 * feature #28815 YamlEncoder handle yml format (kevin-biig)
 * feature #27742 [Process] Add feature "wait until callback" to process class (Nek-)
 * feature #28713 [Cache] added support for connecting to Redis clusters via DSN (nicolas-grekas)
 * feature #24263 Filter logs by level (ro0NL)
 * feature #24151 Display the log context in the debug pages (javiereguiluz)
 * feature #26261 [Validator] Improvement: provide file basename for constr. violation messages in FileValidator. (TheCelavi)
 * feature #26324 [Form] allow additional http methods in form configuration (alekitto)
 * feature #26771 [Filesystem] Fix mirroring a directory with a relative path and a custom iterator (fxbt)
 * feature #27291 [OptionsResolver] Added support for nesting options definition (yceruto)
 * feature #27261 [VarDumper] Allow to use a light theme out of the box (ogizanagi)
 * feature #27967 [Finder] Added a way to inverse a previous sorting (lyrixx)
 * feature #28061 [Security] add port in access_control (roukmoute)
 * feature #28476 Added different protocols to be allowed as asset base_url (alexander-schranz)
 * feature #27770 [FrameworkBundle] Moving Cache-related CompilerPass to Cache component (Korbeil)
 * feature #28738 [OptionsResolver] Passing Options argument to deprecation closure (yceruto)
 * feature #28718 [Cache] add CacheInterface::delete() + improve CacheTrait (nicolas-grekas)
 * feature #24530 [Form] simplify the form type extension registration (xabbuh)
 * feature #28586 [WebServerBundle] Added ability to display the current hostname address if available when binding to 0.0.0.0 (respinoza)
 * feature #28763 [WebProfilerBundle] Extract server parameters into their own tab (fabpot)
 * feature #28375 [Translator] Deprecated transChoice and moved it away from contracts (Nyholm, nicolas-grekas)
 * feature #28745 [WebServerBundle] Deprecate relying on --env in server:start and server:run (chalasr)
 * feature #28505 [Serialized] allow configuring the serialized name of properties through metadata (fbourigault)
 * feature #28669 [Serializer] Object class resolver (alanpoulain)
 * feature #28653 [FrameworkBundle] Deprecate the "--env" and "--no-debug" console options (chalasr)
 * feature #28693 [Security] Deprecate simple_preauth and simple_form in favor of Guard (chalasr)
 * feature #28626 [Translation] marked getFallbackLocales() as internal (boscho87)
 * feature #28571 [DependencyInjection] Improve ServiceLocatorTagPass service matching (codedmonkey)
 * feature #28644 [Validator] Pre-check constraint validator dependencies (ro0NL)
 * feature #28661 [Serializer] Add an option to skip null values (dunglas)
 * feature #28679 [FrameworkBundle] Add vscode editor to ide config (lexcast)
 * feature #28656 When a CSRF occures on a Form submit add a cause on the FormError object (gmponos)
 * feature #28588 [Cache] add "setCallbackWrapper()" on adapters implementing CacheInterface for more flexibility (nicolas-grekas)
 * feature #28598 [Cache] support configuring multiple Memcached servers in one DSN (nicolas-grekas)
 * feature #28447 [HttpFoundation] make cookies auto-secure when passing them $secure=null + plan to make it and samesite=lax the defaults in 5.0 (nicolas-grekas)
 * feature #28446 [SecurityBundle] make remember-me cookies auto-secure + inherit their default config from framework.session.cookie_* (nicolas-grekas)
 * feature #28417 [VarExporter] add Instantiator::instantiate() to create+populate objects without calling their constructor nor any other methods (nicolas-grekas)
 * feature #27819 [Serializer] deprecated normalizers and encoders who dont implement the base interfaces (rodnaph)
 * feature #28572 Make it clear that the profiler is for dev only (fabpot)
 * feature #28536 Favor LogicException for missing classes & functions (ro0NL)
 * feature #28569 [Form] deprecate precision in IntegerToLocalizedStringTransformer (xabbuh)
 * feature #28570 [Form] deprecate the unused scale option (xabbuh)
 * feature #28566 [VarDumper] add casters for IntlDateFormatter and IntlCalendar (jschaedl)
 * feature #28559 [VarDumper] add caster for IntlTimeZone (jschaedl)
 * feature #28449 [DependencyInjection] improved message when alias service is not found (xabbuh)
 * feature #27434 [Console] Add support for error ouput in the CommandTester (cdekok)
 * feature #28555 [VarDumper] add caster for NumberFormatter (jschaedl)
 * feature #28538 [Lock] Wrap release exception (jderusse)
 * feature #28551 [VarDumper] add caster for MessageFormatter (nicolas-grekas)
 * feature #28329 [Debug] Trigger a deprecation for new parameters not defined in sub classes (GuilhemN)
 * feature #27920 Add Zookeeper data store for Lock Component (Ganesh Chandrasekaran)
 * feature #28317 [VarDumper] Allow dd() to be called without arguments (SjorsO)
 * feature #28424 [Ldap] Add verbose ext-ldap error if present for easier debugging (scaytrase)
 * feature #28521 [Yaml] Added support for multiple files or directories in LintCommand (yceruto)
 * feature #28522 [Translation] Added support for multiple files or directories in XliffLintCommand (yceruto)
 * feature #28523 [FrameworkBundle] Register an identity translator as fallback (yceruto)
 * feature #28473 [Validator] Check the BIC country with symfony/intl (sylfabre)
 * feature #28487 [FrameworkBundle] Ignore backslashes in service ids when using debug:container and debug:autowiring (respinoza)
 * feature #28412 [PhpUnitBridge] enable DebugClassLoader by default (nicolas-grekas)
 * feature #28416 [FrameworkBundle] bind "ContainerInterface $parameterBag" arguments to the "parameter_bag" service (nicolas-grekas)
 * feature #28316 Trigger deprecation notices when inherited class calls parent method but misses adding new arguments (kevinjhappy)
 * feature #28373 [Console] Support max column width in Table (ro0NL)
 * feature #28422 [VarExporter] throw component-specific exceptions (nicolas-grekas)
 * feature #28415 [FrameworkBundle] Deprecate ContainerAwareCommand (chalasr)
 * feature #28419 [Messenger] Change AmqpExt classes constructor signature (fabpot)
 * feature #28405 [Messenger] Uses a messenger serializer, not an individual encoder/decoder (sroze)
 * feature #28298 [WebServerBundle] Add support for Xdebug's Profiler (maidmaid)
 * feature #28399 [Messenger] Add a SenderLocator decoupled from ContainerInterface (fabpot)
 * feature #27321 [Messenger][Profiler] Trace middleware execution (ogizanagi)
 * feature #28400 [Messenger] Add a simple serializer (fabpot)
 * feature #28397 [Messenger] Change exceptions to use component's one (fabpot)
 * feature #28387 [HttpKernel][Profiler] Add arg value resolver category in performances panel (ogizanagi)
 * feature #25015 [Validator] Deprecate validating DateTimeInterface in Date|Time|DateTime constraints (ro0NL)
 * feature #28394 [Messenger] Add interfaces to be type-hinted even when not using a Container (fabpot)
 * feature #27981 [TwigBridge] Added template "name" argument to debug:twig command to find their paths (yceruto)
 * feature #28207 [DI] leverage Contracts\Service (nicolas-grekas)
 * feature #22225 [Console] Support formatted text cutting (ro0NL)
 * feature #28206 [Contracts] Add traits+interfaces from the DI component (nicolas-grekas)
 * feature #27456 [LOCK] Add a PdoStore  (jderusse)
 * feature #24297 Feature/doctrine type guesser simple json array support (iluuu1994)
 * feature #26859 [Dotenv] add a flag to allow env vars override (fmata)
 * feature #26997 [PropertyInfo] Add an extractor to guess if a property is initializable (dunglas)
 * feature #27667 [Form][OptionsResolver] Show deprecated options definition on debug:form command (yceruto)
 * feature #27021 [Serializer] Allow to access extra infos in name converters (dunglas)
 * feature #26923 [FrameworkBundle] Allow user to specify folder for flock (MaksSlesarenko)
 * feature #25125 [VarDumper] New env var to select the dump format (dunglas)
 * feature #28117 [FrameworkBundle] add class description to debug:container command (gimler)
 * feature #28270 [Messenger] Uses Symfony Serializer by default for envelope items (sroze)
 * feature #27935 [FrameworkBundle] [Command] TranslationUpdate change default output to xlf (Alexis BOYER)
 * feature #28168 Add SameSite cookies to FrameWorkBundle (rpkamp)
 * feature #28303 [Process] Add relative path support for PHP_BINARY env var of PhpExecutableFinder (maidmaid)
 * feature #28096 [Contracts] Add Cache contract to extend PSR-6 with tag invalidation, callback-based computation and stampede protection (nicolas-grekas)
 * feature #27399 [Translation] Added intl message formatter. (aitboudad, Nyholm)
 * feature #28315 [DI] Trigger exception when using '@id' name in parent option (Seb33300)
 * feature #28210 [Contracts] Add Translation\TranslatorInterface + decouple symfony/validator from symfony/translation (nicolas-grekas)
 * feature #28331 [FrameworkBundle] Don't populate fallback cache on warmup (nicolas-grekas)
 * feature #28264 [VarDumper] make RedisCaster handle RedisCluster and dump all options on all drivers (nicolas-grekas)
 * feature #28289 [Serializer] Add support for ignoring comments while XML encoding (maidmaid)
 * feature #28294 [Messenger] Remove the "obscure" message subscriber configuration (sroze)
 * feature #28271 [Messenger] Allow interfaces to be type-hinted as well (sroze)
 * feature #28190 [Messenger] Add a --bus option to the messenger:consume-messages command (chalasr, sroze)
 * feature #28275 [Messenger] Only subscribe to a given bus from the MessageSubscriber (sroze)
 * feature #28243 [FrameworkBundle] Deprecate `Symfony\Bundle\FrameworkBundle\Controller\Controller` (sroze)
 * feature #28070 [Translator] Use ICU parent locales as fallback locales (thewilkybarkid)
 * feature #28231 [VarExporter] a new component to serialize values to plain PHP code (nicolas-grekas)
 * feature #28244 [FrameworkBundle] Added new "auto" mode for `framework.session.cookie_secure` to turn it on when https is used (nicolas-grekas)
 * feature #28277 [Serializer] AbstractObjectNormalizer improve performance (martiis)
 * feature #28247 [Messenger] Don't make EnvelopeItemInterface extend Serializable (nicolas-grekas)
 * feature #27926 [Serializer] XmlEncoder doesn't ignore PI nodes while encoding  (maidmaid)
 * feature #27890 Mock date() in ClockMock (Dominic Tubach)
 * feature #28218 Improve support for anonymous classes (nicolas-grekas)
 * feature #28221 [DomCrawler] Add a way to filter direct children (Einenlum)
 * feature #28234 [DI] Allow autowiring by type + parameter name (nicolas-grekas)
 * feature #28156 [Serializer] Fix the XML comments encoding (maidmaid)
 * feature #28069 [Validator] New `DivisibleBy` constraint for testing divisibility (colinodell)
 * feature #28176 [DI] [FrameworkBundle] Add LoggerAwareInterface to auto configuration (GaryPEGEOT)
 * feature #27957 [Routing] Add fallback to cultureless locale for internationalized routes (fancyweb)
 * feature #28027 [Config] Rename FileLoaderLoadException to LoaderLoadException (ProgMiner)
 * feature #28085 [Config] show proposals when unsupported option is provided (fmata)
 * feature #27806 [DI] Allow autoconfiguring bindings (nicolas-grekas)
 * feature #21002 [Form] Added options for separate date/time labels in DateTimeType. (mktcode)
 * feature #27763 [WebProfilerBundle] Append new ajax request to the end of the list (BoShurik)
 * feature #28035 [DomCrawler] Allow using non-absolute base URIs (javiereguiluz)
 * feature #28106 [Yaml] save preg_match() calls when possible (xabbuh)
 * feature #27678 Allow to configure some options of the profiler interface (javiereguiluz)
 * feature #27943 [Security] Deprecate returning stringish objects from Security::getUser (ro0NL)
 * feature #27956 Added types and tweaked PHPdoc of clickLink() and submitForm() methods (javiereguiluz)
 * feature #27976 [Security] Remember me: allow to set the samesite cookie flag (dunglas)
 * feature #27978 [WebProfilerBundle] Show relative path of the template and improving panel view (yceruto)
 * feature #27891 [Finder] Allow arrays as parameters of some methods for better fluent experience and code readability (jfredon)
 * feature #27829 [DoctrineBridge] Inject the entity manager instead of the class metadata factory in DoctrineExtractor (dunglas)
 * feature #27093 Add symfony/contracts: a set of abstractions extracted out of the Symfony components (nicolas-grekas)
 * feature #27807 Added new methods submitForm and clickLink to Client class (nowiko)
 * feature #27879 [Routing] deprecate non string requirement names (xabbuh)
 * feature #26933 [Console] Add title table (maidmaid)
 * feature #27697 [ProxyManagerBridge][DI] allow proxifying interfaces with "lazy: Some\ProxifiedInterface" (nicolas-grekas)
 * feature #27645 [Cache] Add `MarshallerInterface` allowing to change the serializer, providing a default one that automatically uses igbinary when available (nicolas-grekas)
 * feature #27694 [FrameworkBundle][Cache] Allow configuring PDO-based cache pools, with table auto-creation on first use (nicolas-grekas)
 * feature #27774 [FrameworkBundle] allow turning routes to utf8 mode by default (nicolas-grekas)
 * feature #27821 [Process][Console] deprecated defining commands as strings (nicolas-grekas)
 * feature #27320 [Messenger] Activation middleware decorator (ogizanagi)
 * feature #27519 [HttpKernel][FrameworkBundle] Turn HTTP exceptions to HTTP status codes by default (nicolas-grekas)
 * feature #27020 [Serializer] Allow to access to the format and context in circular ref handler (dunglas)
 * feature #27783 [DI] Add ServiceLocatorArgument to generate array-based locators optimized for OPcache shared memory (nicolas-grekas)
 * feature #27850 [Security] Allow passing null as $filter in LdapUserProvider to get the default filter (louhde)
 * feature #27650 [SecurityBundle] Add json login ldap (Rudy Onfroy)
 * feature #27798 [Security] Use AuthenticationTrustResolver in SimplePreAuthenticationListener (nicolas-grekas)
 * feature #27801 [MonologBridge] Add ProcessorInterface, enabling autoconfiguration of monolog processors (nicolas-grekas)
 * feature #27503 [Serializer] Allow to pass a single value for the groups opt (dunglas)
 * feature #27715 [Serializer] Deprecate CsvEncoder as_collection false default value (ogizanagi)
 * feature #27768 [VarDumper] display the signature of callables (nicolas-grekas)
 * feature #27766 [VarDumper] show proxified class on hover (nicolas-grekas)
 * feature #27675 [DoctrineBridge] always load event listeners lazy via ServiceLocator (dmaicher)
 * feature #27499 Improved an error message related to controllers (javiereguiluz)
 * feature #26300 [PropertyInfo] Implement "Collection" types in PhpDocExtractor (popy-dev)
 * feature #26946 [WebProfilerBundle] Display uploaded files in the profiler (javiereguiluz)
 * feature #27476 [Config] deprecate tree builders without root nodes (xabbuh)
 * feature #27586 [PropertyAccess] Add Property Path to Exception Message (rodnaph)
 * feature #27699 Redesigned the default error page in production (javiereguiluz)
 * feature #27655 [Translation] Added support for translation files with other filename patterns (javiereguiluz)
 * feature #27580 [Form] Add ability to clear form errors (colinodell)
 * feature #27247 [Form] Deprecate `searchAndRenderBlock` returning empty string (ostrolucky)
 * feature #27646 [Cache] added support for phpredis 4 `compression` and `tcp_keepalive` options (nicolas-grekas)
 * feature #27605 [DX] Log potential redirect loops caused by forced HTTPS (colinodell)
 * feature #27653 [Translation] Improved the performance of the lint:xliff command (javiereguiluz)
 * feature #27421 CacheWarmerAggregate handle deprecations logs (ScullWM)
 * feature #27611 [FrameworkBundle][SecurityBundle] Moved security expression providers pass logic to SecurityBundle (HeahDude)
 * feature #27277 [OptionsResolver] Introduce ability to deprecate options, allowed types and values (yceruto)
 * feature #26919 [TwigBridge] Added bundle name suggestion on wrongly overrided templates paths (pmontoya, Pascal Montoya)
 * feature #26486 [HttpFoundation] Adds getAcceptableFormats() method for Request (AndreiIgna)
 * feature #27535 [TwigBundle] Enhance the twig not found exception (behnoushnorouzi)
 * feature #27551 [FrameworkBundle] show public/private for aliases in debug:container command (OskarStark)
 * feature #27543 [Cache] serialize objects using native arrays when possible (nicolas-grekas)
 * feature #27563 [Cache] Improve perf of array-based pools (nicolas-grekas)
 * feature #27604 [Cache] Prevent stampede at warmup using flock() (nicolas-grekas)
 * feature #27315 [TwigBundle] add exception chain breadcrumbs navigation (kiler129)
 * feature #27031 [Cache] Use sub-second accuracy for internal expiry calculations (nicolas-grekas)
 * feature #27549 [Cache] Unconditionally use PhpFilesAdapter for system pools (nicolas-grekas)
 * feature #27009 [Cache] Add stampede protection via probabilistic early expiration (nicolas-grekas)
 * feature #27471 [DI] Improve performance of removing/inlining passes (nicolas-grekas)
 * feature #27462 [FrameworkBundle] Deprecate auto-injection of the container in AbstractController instances (nicolas-grekas)
 * feature #27077 [DependencyInjection] add ServiceSubscriberTrait (kbond)
 * feature #27398 [Cache] Remove TaggableCacheInterface, alias cache.app.taggable to CacheInterface (nicolas-grekas)
 * feature #27343 [Messenger][Profiler] Show dispatch caller (ogizanagi)
 * feature #27429 [PropertyInfo] Auto-enable PropertyInfo component (sroze)
 * feature #27430 [PropertyInfo] Add an alias to the property info type extractor (sroze)
 * feature #27417 [WebProfilerBundle] Make Twig bundle an explicit dependency (fabpot)
 * feature #27024 [Finder] added "use natural sort" option (vyshkant)
 * feature #26934 [FrameworkBundle] Allow configuring taggable cache pools (nicolas-grekas)
 * feature #26981 No more support for custom anon/remember tokens based on FQCN (Iltar van der Berg)
 * feature #27336 [Security][SecurityBundle] FirewallMap/FirewallContext deprecations (chalasr)
 * feature #27157 [DI] Select specific key from an array resolved env var (bobvandevijver)
 * feature #27165 [DI] Allow binding by type+name (nicolas-grekas)
 * feature #26929 [Cache] Add [Taggable]CacheInterface, the easiest way to use a cache (nicolas-grekas)
 * feature #27305 [Security/Core] Add "is_granted()" to security expressions, deprecate "has_role()" (nicolas-grekas)
 * feature #27069 [LDAP] Add "applyOperations" method to EntryManager (mablae)
 * feature #27118 [BrowserKit] Adds support for meta refresh (jhedstrom)
 * feature #27268 [DI] fine tune dumped factories (nicolas-grekas)
 * feature #27075 [DI][DX] Allow exclude to be an array of patterns (magnetik)
 * feature #27138 [HttpKernel] Better exception page when the controller returns nothing (lyrixx)

