CHANGELOG for 4.1.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 4.1 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v4.1.0...v4.1.1

* 4.1.9 (2018-12-06)

 * security #cve-2018-19790 [Security\Http] detect bad redirect targets using backslashes (xabbuh)
 * security #cve-2018-19789 [Form] Filter file uploads out of regular form types (nicolas-grekas)
 * bug #29436 [Cache] Fixed Memcached adapter doClear()to call flush() (raitocz)
 * bug #29441 [Routing] ignore trailing slash for non-GET requests (nicolas-grekas)
 * bug #29444 [Workflow] Fixed BC break for Workflow metadata (lyrixx)
 * bug #29432 [DI] dont inline when lazy edges are found (nicolas-grekas)
 * bug #29413 [Serializer] fixed DateTimeNormalizer to maintain microseconds when a different timezone required (rvitaliy)
 * bug #29424 [Routing] fix taking verb into account when redirecting (nicolas-grekas)
 * bug #29414 [DI] Fix dumping expressions accessing single-use private services (chalasr)
 * bug #29375 [Validator] Allow `ConstraintViolation::__toString()` to expose codes that are not null or emtpy strings (phansys)
 * bug #29376 [EventDispatcher] Fix eventListener wrapper loop in TraceableEventDispatcher (jderusse)
 * bug #29386 undeprecate the single-colon notation for controllers (fbourigault)
 * bug #29393 [DI] fix edge case in InlineServiceDefinitionsPass (nicolas-grekas)
 * bug #29380 [Routing] fix greediness of trailing slash (nicolas-grekas)
 * bug #29343 [Form] Handle all case variants of "nan" when parsing a number (mwhudson, xabbuh)
 * bug #29373 [Routing] fix trailing slash redirection (nicolas-grekas)
 * bug #29355 [PropertyAccess] calculate cache keys for property setters depending on the value (xabbuh)
 * bug #29369 [DI] fix combinatorial explosion when analyzing the service graph (nicolas-grekas)
 * bug #29349 [Debug] workaround opcache bug mutating "$this" !?! (nicolas-grekas)

* 4.1.8 (2018-11-26)

 * bug #29318 [Console] Move back root exception to stack trace in verbose mode (chalasr)
 * bug #29332 [PropertyAccess] make cache keys encoding bijective (nicolas-grekas)
 * bug #29298 [Routing] fix trailing slash redirection when using RedirectableUrlMatcher (nicolas-grekas)
 * bug #29297 [Routing] fix trailing slash redirection when using RedirectableUrlMatcher (nicolas-grekas)
 * bug #29313 [PropertyAccessor] fix encoding of cache keys (nicolas-grekas)
 * bug #28917 [DoctrineBridge] catch errors while converting to db values in data collector (alekitto)
 * bug #29317 [WebProfiler] Detect non-file paths in file viewer (ro0NL)
 * bug #29305 [EventDispatcher] Unwrap wrapped listeners internally (ro0NL)
 * bug #27314 [DoctrineBridge] fix case sensitivity issue in RememberMe\DoctrineTokenProvider (PF4Public)
 * bug #29310 [MonologBridge] Return empty list for unknown requests (ro0NL)
 * bug #29308 [Translation] Use XLIFF source rather than resname when there's no target (thewilkybarkid)
 * bug #26244 [BrowserKit] fixed BC Break for HTTP_HOST header (brizzz)
 * bug #28147 [DomCrawler] exclude fields inside "template" tags (Gorjunov)
 * bug #29222 [Dotenv] properly parse backslashes in unquoted env vars (xabbuh)
 * bug #29256 [HttpFoundation] Fixed absolute Request URI with default port (thomasbisignani)
 * bug #29274 [Routing] Remove duplicate schemes and methods for invokable controllers (claudusd)
 * bug #29271 [HttpFoundation] Fix trailing space for mime-type with parameters (Sascha Dens)
 * bug #29243 [Cache] fix optimizing Psr6Cache for AdapterInterface pools (nicolas-grekas)
 * bug #29247 [DI] fix taking lazy services into account when dumping the container (nicolas-grekas)
 * bug #29249 [Form] Fixed empty data for compound date interval (HeahDude)
 * bug #29265 [Bridge/PhpUnit] Use composer to download phpunit (nicolas-grekas)
 * bug #28769 [FrameworkBundle] deal with explicitly enabled workflow nodes (xabbuh)
 * bug #29223 [Validator] Added the missing constraints instance checks (thomasbisignani)
 * bug #28966 [PropertyAccessor] Fix unable to write to singular property using setter while plural adder/remover exist (karser)
 * bug #29182 [Form] Fixed empty data for compound date types (HeahDude)
 * bug #29191 [Routing] generate(null) should throw an exception (nicolas-grekas)
 * bug #29185 [Form] Fixed keeping hash of equal \DateTimeInterface on submit (HeahDude)
 * bug #29141 [Workflow] Fixed bug of buildTransitionBlockerList when many transition are enabled (Tetragramat, lyrixx)
 * bug #29137 [Workflow][FrameworkBundle] fixed guard event names for transitions (destillat, lyrixx)
 * bug #28731 [Form] invalidate forms on transformation failures (xabbuh)
 * bug #29152 [Config] Unset key during normalization (ro0NL)
 * bug #29165 [DI] align IniFileLoader to PHP bugfix #76965 (nicolas-grekas)
 * bug #29115 Change button_widget class to btn-primary (neFAST)
 * bug #29131 [Dotenv] dont use getenv() to read SYMFONY_DOTENV_VARS (nicolas-grekas)
 * bug #29057 [HttpFoundation] replace any preexisting Content-Type headers (nicolas-grekas)
 * bug #29076 [Serializer] Allow null values when denormalizing with constructor missing data (danut007ro)
 * bug #29104 [DI] fix dumping inlined services (nicolas-grekas)
 * bug #29054 [VarDumper] fix dump of closures created from callables (nicolas-grekas)
 * bug #29102 [DI] fix GraphvizDumper ignoring inline definitions (nicolas-grekas)
 * bug #29107 [DI] dont track classes/interfaces used to compute autowiring error messages (nicolas-grekas)

* 4.1.7 (2018-11-03)

 * bug #28820 [DependencyInjection] Fix tags on multiple decorated service (Soner Sayakci)
 * bug #29020 Fix ini_get() for boolean values (deguif)
 * bug #28955 [Messenger] send using the routing_key for AMQP transport (nicolas-grekas)
 * bug #28960 also clean away the NO_AUTO_CACHE_CONTROL_HEADER if we have no session (dbu)
 * feature #28893 [TwigBundle] Fix usage of TwigBundle without FrameworkBundle (tgalopin)
 * bug #28889 [Serializer] Reduce class discriminator overhead (fbourigault)
 * bug #28861 [DependencyInjection] Skip empty proxy code (olvlvl)
 * bug #28801 Convert InsufficientAuthenticationException to HttpException with 401 status code (vincentchalamon)
 * bug #28840 add missing double-quotes to extra_fields output message (danielkay)
 * bug #28838 [DI] Default undefined env to empty string during compile (ro0NL)
 * bug #28863 [Process] Allow to pass non-string arguments to Process (vudaltsov)
 * bug #28712 [Form] reverse transform RFC 3339 formatted dates (xabbuh)
 * bug #28813 Fix for race condition in console output stream write (rudolfratusinski)
 * bug #27772 [Console] Fixes multiselect choice question defaults in non-interactive mode (veewee)
 * bug #28835 [FrameworkBundle] Setting missing default paths under BC layer (yceruto)
 * bug #28760 [DI] fix dumping inline services again (nicolas-grekas)
 * bug #28689 [Process] fix locking of pipe files on Windows (nicolas-grekas)
 * bug #28704 [Form] fix multi-digit seconds fraction handling (xabbuh)
 * bug #28793 [SecurityBundle] do not override custom access decision configs (xabbuh)
 * bug #28783 [FrameworkBundle] add missing cache prefix seed attribute to XSD (xabbuh)
 * bug #28072 [Security] Do not deauthenticate user when the first refreshed user has changed (gpekz)
 * bug #28735 [FWBundle] Automatically enable PropertyInfo when using Flex (dunglas)
 * bug #28751 [FrameworkBundle] Register messenger before the profiler (sroze)

* 4.1.6 (2018-10-03)

 * bug #28604 [Finder] fixed root directory access for ftp/sftp wrapper (DerDu)
 * bug #28688 [FWBundle] Throw if PropertyInfo is enabled, but the component isn't installed (dunglas)
 * bug #28638 [Console] Fix clearing sections containing questions (chalasr)
 * bug #28690 [FrameworkBundle] dont suggest hidden services in debug:container and debug:autow commands (nicolas-grekas)
 * bug #28648 [PHPUnitBridge] Fix ClockMock microtime() format (acasademont)
 * bug #28678 [DI] fix dumping setters before their inlined instances (nicolas-grekas)
 * bug #28672 [DI] fix error in dumped container (nicolas-grekas)
 * bug #28664 [Console] Don't return early as this bypasses the auto exit feature (duncan3dc)

* 4.1.5 (2018-09-30)

 * bug #28636 [HttpFoundation] X-Accel-Mapping does not use HTTP key=value syntax (c960657)
 * bug #28376 [TwigBundle] Fixed caching of templates in src/Resources/<BundleName>/views on cache warmup (yceruto)
 * bug #28565 [HttpFoundation][Security] forward locale and format to subrequests (nicolas-grekas)
 * bug #28561 [Cache] prevent getting older entries when the version key is evicted (nicolas-grekas)
 * bug #28562 [HttpFoundation] fix hidding warnings from session handlers (nicolas-grekas)
 * bug #28545 [Console] Send the right exit code to console.terminate listeners (mpdude)
 * bug #28553 [Debug] Fix false-positive "MicroKernelTrait::loadRoutes()" method is considered internal" (nicolas-grekas)
 * bug #28466 [Form] fail reverse transforming invalid RFC 3339 dates (xabbuh)
 * bug #28540 [Intl] parse numbers terminated with decimal separator (xabbuh)
 * bug #28548 [Console] Fixed boxed table style with colspan (ro0NL)
 * bug #28433 [HttpFoundation] Allow reuse of Session between requests if ID did not change (tgalopin)
 * bug #28508 [Form] forward false label option to nested types (xabbuh)
 * bug #28471 [MonologBridge] Re-add option option to ignore empty context and extra data (mpdude)
 * bug #28464 [Form] forward the invalid_message option in date types (xabbuh)
 * bug #28524 [PhpUnitBridge] fix disabling DeprecationErrorHandler using phpunit.xml file (soerenbernstein)
 * bug #28512 [DI] fix infinite loop involving self-references in decorated services (nicolas-grekas)
 * bug #28507 [DI] fix dumping lazy services (nicolas-grekas)
 * bug #28469 [Form][TwigBridge] fix not displaying labels when value is false (xabbuh)
 * bug #28495 [PhpUnitBridge] Implement startTest rather than startTestSuite (greg0ire)
 * bug #28480 [DI] Detect circular references with ChildDefinition parent (Seb33300)
 * bug #28497 [VarDumper] Fix global dump function return value for PHP7 (patrickcarlohickman)
 * bug #28499 [Ldap] Use shut up operator on connection errors at ldap_start_tls (Andras Debreczeni)
 * bug #28372 [Form] Fix DateTimeType html5 input format (franzwilding, mcfedr)
 * bug #28396 [Intl] Blacklist Eurozone and United Nations in Region Data Generator (gregurco)
 * bug #28418 [FrameworkBundle] Register the messenger data collector only when the profiler is enabled (pierredup)
 * bug #28393 [Console] fixed corrupt error output for unknown multibyte short option (downace)
 * bug #28411 [Debug] fix detecting overriden final/internal methods implemented using traits (nicolas-grekas)
 * bug #28404 [Controller][ServiceValueResolver] Making method access case insensitive (nicoweb)
 * bug #28401 [Console] Fix SymfonyQuestionHelper::askQuestion() with choice value as default (chalasr)
 * bug #28388 [DI] configure inlined services before injecting them when dumping the container (nicolas-grekas)
 * bug #28377 fix fopen flags (SpacePossum)
 * bug #27764 [TwigBundle] Fixed caching of templates in default path on cache warmup (yceruto)
 * bug #28366 [DI] Fix dumping some complex service graphs (nicolas-grekas)
 * bug #27970 [FileValidator] Format file size in validation message according to binaryFormat option (jfredon)
 * bug #28029 [TwigBundle] remove cache warmers when Twig cache is disabled (xabbuh)
 * bug #28322 [Workflow] Make sure we do not run the next transition on an updated state (Nyholm)
 * bug #28344 [HttpKernel][FrameworkBundle] Fix escaping of serialized payloads passed to test clients (nicolas-grekas)
 * bug #28183 [WebProfilerBundle] fix wrong url when base path is the index (ismail1432)
 * bug #28334 [FWB][Messenger] Revert "Move commands-specifics to a compiler pass in FWB" (sroze)
 * bug #28328 [Messenger][FrameworkBundle] Move commands-specifics to a compiler pass in FWB (sroze)

* 4.1.4 (2018-08-28)

 * bug #28278 [HttpFoundation] Fix unprepared BinaryFileResponse sends empty file (wackymole)
 * bug #28284 [PhpUnitBridge] keep compat with composer 1.0 (nicolas-grekas)
 * bug #28251 [HttpFoundation] Allow RedisCluster class for RedisSessionHandler (michaelperrin)
 * bug #28241 [HttpKernel] fix forwarding trusted headers as server parameters (nicolas-grekas)
 * bug #28220 [PropertyAccess] fix type error handling when writing values (xabbuh)
 * bug #28249 [Cache] enable Memcached::OPT_TCP_NODELAY to fix perf of misses (nicolas-grekas)
 * bug #28252 [DoctrineBridge] support __toString as documented for UniqueEntityValidator (dmaicher)
 * bug #28216 [FrameworkBundle] `message_bus` alias public (sroze)
 * bug #28113 [Form] Add help texts for checkboxes in horizontal bootstrap 4 forms (apfelbox)
 * bug #28100 [Security] Call AccessListener after LogoutListener (chalasr)
 * bug #28174 Remove the HTML5 validation from the profiler URL search form (Soullivaneuh)
 * bug #28159 [DI] Fix autowire inner service (hason)
 * bug #28060 [DI] Fix false-positive circular ref leading to wrong exceptions or infinite loops at runtime (nicolas-grekas)
 * bug #28144 [HttpFoundation] fix false-positive ConflictingHeadersException (nicolas-grekas)
 * bug #28152 [Translation] fix perf of lint:xliff command (nicolas-grekas)
 * bug #28115 [Form] Remove extra .form-group wrapper around file widget in bootstrap 4 (MrMitch)
 * bug #28120 [Routing] Fixed scheme redirecting for root path (twoleds)
 * bug #28112 Fix CSS property typo (AhmedAbdulrahman)
 * bug #28012 [PropertyInfo] Allow nested collections (jderusse)
 * bug #28055 [PropertyInfo] Allow nested collections (jderusse)
 * bug #28083 Remove the Expires header when calling Response::expire() (javiereguiluz)

* 4.1.3 (2018-08-01)

 * security #cve-2018-14774 [HttpKernel] fix trusted headers management in HttpCache and InlineFragmentRenderer (nicolas-grekas)
 * security #cve-2018-14773 [HttpFoundation] Remove support for legacy and risky HTTP headers (nicolas-grekas)
 * bug #28003 [HttpKernel] Fixes invalid REMOTE_ADDR in inline subrequest when configuring trusted proxy with subnet (netiul)
 * bug #28007 [FrameworkBundle] fixed guard event names for transitions (destillat)
 * bug #28045 [HttpFoundation] Fix Cookie::isCleared (ro0NL)
 * bug #28080 [HttpFoundation] fixed using _method parameter with invalid type (Phobetor)
 * bug #28059 [Messenger] Fix error message on undefined message class for non-subscriber handler (chalasr)
 * bug #28052 [HttpKernel] Fix merging bindings for controllers' locators (nicolas-grekas)
 * bug #28014 [Messenger] Fix chaining senders with their aliases (sroze)

* 4.1.2 (2018-07-23)

 * bug #28005 [HttpKernel] Fixed templateExists on parse error of the template name (yceruto)
 * bug #28013 [Messenger] Add missing typehint on chain sender (sroze)
 * bug #27997 Serbo-Croatian has Serbian plural rule (kylekatarnls)
 * bug #26193 Fix false-positive deprecation notices for TranslationLoader and WriteCheckSessionHandler (iquito)
 * bug #27827 [Serializer] Supports nested abstract items (sroze)
 * bug #27958 [Form] Remaining changes for bootstrap 4 file fields (apfelbox)
 * bug #27919 [Form] Improve rendering of `file` field in bootstrap 4 (apfelbox)
 * bug #27941 [WebProfilerBundle] Fixed icon alignment issue using Bootstrap 4.1.2 (jmsche)
 * bug #27937 [HttpFoundation] reset callback on StreamedResponse when setNotModified() is called (rubencm)
 * bug #27927 [HttpFoundation] Suppress side effects in 'get' and 'has' methods of NamespacedAttributeBag (webnet-fr)
 * bug #27913 [EventDispatcher] Clear orphaned events on reset (acasademont)
 * bug #27923 [Form/Profiler] Massively reducing memory footprint of form profiling pages... (VincentChalnot)
 * bug #27918 [Console] correctly return parameter's default value on "--" (seschwar)
 * bug #27826 [Serializer] Fix serialization of items with groups across entities and discrimination map (sroze)
 * bug #27904 [Filesystem] fix lock file permissions (fritzmg)
 * bug #27903 [Lock] fix lock file permissions (fritzmg)
 * bug #27889 [Form] Replace .initialism with .text-uppercase. (vudaltsov)
 * bug #27902 Fix the detection of the Process new argument (stof)
 * bug #27885 [HttpFoundation] don't encode cookie name for BC (nicolas-grekas)
 * bug #27782 [DI] Fix dumping ignore-on-uninitialized references to synthetic services (nicolas-grekas)
 * bug #27435 [OptionResolver] resolve arrays (Doctrs)
 * bug #27728 [TwigBridge] Fix missing path and separators in loader paths list on debug:twig output (yceruto)
 * bug #27837 [PropertyInfo] Fix dock block lookup fallback loop (DerManoMann)
 * bug #27848 [Workflow] Fixed BC break (lyrixx)
 * bug #27758 [WebProfilerBundle] Prevent toolbar links color override by css (alcalyn)
 * bug #27847 [Security] Fix accepting null as $uidKey in LdapUserProvider (louhde)
 * bug #27820 [Messenger] Fix a bug when having more than one named handler per message subscriber (sroze)
 * bug #27834 [DI] Don't show internal service id on binding errors (nicolas-grekas)
 * bug #27831  Check for Hyper terminal on all operating systems.  (azjezz)
 * bug #27794 Add color support for Hyper terminal . (azjezz)
 * bug #27809 [HttpFoundation] Fix tests: new message for status 425 (dunglas)
 * bug #27618 [PropertyInfo] added handling of nullable types in PhpDoc (oxan)
 * bug #27659 [HttpKernel] Make AbstractTestSessionListener compatible with CookieClearingLogoutHandler (thewilkybarkid)
 * bug #27752 [Cache] provider does not respect option maxIdLength with versioning enabled (Constantine Shtompel)
 * bug #27773 [Serializer] Class discriminator and serialization groups (sroze)
 * bug #27710 [DependencyInjection] fix handling of empty DI extension configs (xabbuh)
 * bug #27776 [ProxyManagerBridge] Fix support of private services (bis) (nicolas-grekas)
 * bug #27714 [HttpFoundation] fix session tracking counter (nicolas-grekas, dmaicher)
 * bug #27727 [Routing] Disallow object usage inside Route (paxal)
 * bug #27736 [Routing] fix too much greediness in host-matching regex (nicolas-grekas)
 * bug #27747 [HttpFoundation] fix registration of session proxies (nicolas-grekas)
 * bug #27754 [HttpFoundation] missing namespace for RedisProxy (Bonfante)
 * bug #27722 Redesign the Debug error page in prod (javiereguiluz)
 * bug #27716 [DI] fix dumping deprecated service in yaml (nicolas-grekas)

* 4.1.1 (2018-06-25)

 * bug #27626 [TwigBundle][DX] Only add the Twig WebLinkExtension if the WebLink component is enabled (thewilkybarkid)
 * bug #27702 [TwigBundle] bump lowest deps to fix issue with "double-colon" controller service refs (nicolas-grekas)
 * bug #27701 [SecurityBundle] Dont throw if "security.http_utils" is not found (nicolas-grekas)
 * bug #27690 [DI] Resolve env placeholder in logs (ro0NL)
 * bug #27687 [HttpKernel] fix argument's error messages in ServiceValueResolver (nicolas-grekas)
 * bug #27614 [VarDumper] Fix dumping by splitting Server/Connection out of Dumper/ServerDumper (nicolas-grekas)
 * bug #27681 [DI] Avoid leaking unused env placeholders (ro0NL)
 * bug #26534 allow_extra_attributes does not throw an exception as documented (deviantintegral)
 * bug #27664 [FrameworkBundle] Ignore keepQueryParams attribute when generating route redirect (vudaltsov)
 * bug #27668 [Lock] use 'r+' for fopen (fixes issue on Solaris) (fritzmg)
 * bug #27669 [Filesystem] fix file lock on SunOS (fritzmg)
 * bug #27662 [HttpKernel] fix handling of nested Error instances (xabbuh)
 * bug #27651 [Messenger] Fixed MessengerPass::guessHandledClasses return type  (massimilianobraglia)
 * bug #26845 [Config] Fixing GlobResource when inside phar archive (vworldat)
 * bug #27382 [Form] Fix error when rendering a DateIntervalType form with exactly 0 weeks (krixon)
 * bug #27309 Fix surrogate not using original request (Toflar)
 * bug #27467 [HttpKernel] fix session tracking in surrogate master requests (nicolas-grekas)
 * bug #27632 [HttpFoundation] Ensure RedisSessionHandler::updateTimestamp returns a boolean (MatTheCat)
 * bug #27630 [Validator][Form] Remove BOM in some xlf files (gautierderuette)
 * bug #27596 [Framework][Workflow] Added support for interfaces (vudaltsov)
 * bug #27593 [ProxyManagerBridge] Fixed support of private services (nicolas-grekas)
 * bug #27591 [VarDumper] Fix dumping ArrayObject and ArrayIterator instances (nicolas-grekas)
 * bug #27528 [FrameworkBundle] give access to non-shared services when using test.service_container (nicolas-grekas)
 * bug #27584 Avoid calling eval when there is no script embedded in the toolbar (stof)
 * bug #27581 Fix bad method call with guard authentication + session migration (weaverryan)
 * bug #27576 [Cache] Fix expiry comparisons in array-based pools (nicolas-grekas)
 * bug #27566 [FrameworkBundle] fix for allowing single colon controller notation (dmaicher)
 * bug #27556 Avoiding session migration for stateless firewall UsernamePasswordJsonAuthenticationListener (weaverryan)
 * bug #27452 Avoid migration on stateless firewalls (weaverryan)
 * bug #27568 [DI] Deduplicate generated proxy classes (nicolas-grekas)
 * bug #27511 [Routing] fix matching host patterns, utf8 prefixes and non-capturing groups (nicolas-grekas)
 * bug #27326 [Serializer] deserialize from xml: Fix a collection that contains the only one element (webnet-fr)
 * bug #27562 [HttpKernel] Log/Collect exceptions at prio 0 (ro0NL)
 * bug #27567 [PhpUnitBridge] Fix error on some Windows OS (Nsbx)
 * bug #27357 [Lock] Remove released semaphore (jderusse)
 * bug #27416 TagAwareAdapter over non-binary memcached connections corrupts memcache (Aleksey Prilipko)
 * bug #27514 [Debug] Pass previous exception to FatalErrorException (pmontoya)
 * bug #27516 Revert "bug #26138 [HttpKernel] Catch HttpExceptions when templating is not installed (cilefen)" (nicolas-grekas)
 * bug #27501 [FrameworkBundle] Fix test-container on kernel reboot, revert to returning the real container from Client::getContainer() (nicolas-grekas)
 * bug #27472 [DI] Ignore missing tree root nodes on validate (ro0NL)
 * bug #27458 [WebProfilerBundle] fixed getSession when no session has been set deprecation warnings (GregOriol)
 * bug #27318 [Cache] memcache connect should not add duplicate entries on sequential calls (Aleksey Prilipko)
 * bug #27498 [Routing] Don't reorder past variable-length placeholders (nanocom, nicolas-grekas)
 * bug #27496 [DebugBundle] DebugBundle::registerCommands should be noop (ogizanagi)
 * bug #27485 [BrowserKit] Fix a BC break in Client affecting Panthère (dunglas)
 * bug #27470 [DI] Remove default env type check on validate (ro0NL)
 * bug #27454 [FrameworkBundle][TwigBridge] Fix BC break from strong dependency on CSRF token storage (tgalopin)
 * bug #27389 [Serializer] Fix serializer tries to denormalize null values on nullable properties (ogizanagi)
 * bug #27272 [FrameworkBundle] Change priority of AddConsoleCommandPass to TYPE_BEFORE_REMOVING (upyx)
 * bug #27396 [HttpKernel] fix registering IDE links (nicolas-grekas)
 * bug #26973 [HttpKernel] Set first trusted proxy as REMOTE_ADDR in InlineFragmentRenderer. (kmadejski)
 * bug #27303 [Process] Consider "executable" suffixes first on Windows (sanmai)
 * bug #27297 Triggering RememberMe's loginFail() when token cannot be created (weaverryan)

* 4.1.0 (2018-05-30)

 * bug #27420 Revert "feature #26702 Mark ExceptionInterfaces throwable (ostrolucky)" (nicolas-grekas)
 * bug #27415 Insert correct parameter_bag service in AbstractController (curry684)

* 4.1.0-BETA3 (2018-05-26)

 * bug #27388 [Routing] Account for greediness when merging route patterns (nicolas-grekas)
 * bug #27344 [HttpKernel] reset kernel start time on reboot (kiler129)
 * bug #27365 [Serializer] Check the value of enable_max_depth if defined (dunglas)
 * bug #27358 [PhpUnitBridge] silence some stderr outputs (ostrolucky)
 * bug #27366 [DI] never inline lazy services (nicolas-grekas)
 * bug #27352 Remove reference to the test container after kernel shutdown (stof)
 * bug #27350 [HttpKernel] fix deprecation in AbstractTestSessionListener (alekitto)
 * bug #27367 [FrameworkBundle] cleanup generated test container (nicolas-grekas)
 * bug #27379 [FrameworkBundle] Fix using test.service_container when Client is rebooted (nicolas-grekas)
 * bug #27364 [DI] Fix bad exception on uninitialized references to non-shared services (nicolas-grekas)
 * bug #27359 [HttpFoundation] Fix perf issue during MimeTypeGuesser intialization (nicolas-grekas)
 * security #cve-2018-11408 [SecurityBundle] Fail if security.http_utils cannot be configured
 * security #cve-2018-11406 clear CSRF tokens when the user is logged out
 * security #cve-2018-11385 migrating session for UsernamePasswordJsonAuthenticationListener
 * security #cve-2018-11385 migrating session for UsernamePasswordJsonAuthenticationListener
 * security #cve-2018-11385 Adding session authentication strategy to Guard to avoid session fixation
 * security #cve-2018-11385 Adding session strategy to ALL listeners to avoid *any* possible fixation
 * security #cve-2018-11386 [HttpFoundation] Break infinite loop in PdoSessionHandler when MySQL is in loose mode
 * bug #27341 [WebProfilerBundle] Fixed validator/dump trace CSS (yceruto)
 * bug #27337  [FrameworkBundle] fix typo in CacheClearCommand (emilielorenzo)
 * bug #27292 [Serializer] Fix and improve constraintViolationListNormalizer's RFC7807 compliance (dunglas)

* 4.1.0-BETA2 (2018-05-21)

 * bug #27312 Supress deprecation notices thrown when getting private servies from container in tests (arderyp)
 * feature #27275 [Messenger] Allow to scope handlers per bus (ogizanagi, sroze)
 * bug #27264 [Validator] Use strict type in URL validator (mimol91)
 * bug #27267 [DependencyInjection] resolve array env vars (jamesthomasonjr)
 * bug #26781 [Form] Fix precision of MoneyToLocalizedStringTransformer's divisions on transform() (syastrebov)
 * bug #27270 [Routing] Fix adding name prefix to canonical route names (ismail1432)
 * bug #27286 [Translation] Add Occitan plural rule (kylekatarnls)
 * bug #27271 [DI] Allow defining bindings on ChildDefinition (nicolas-grekas)
 * bug #27246 Disallow invalid characters in session.name (ostrolucky)
 * feature #27230 [Messenger] Select alternatives on missing receiver arg or typo (yceruto)
 * bug #27287 [PropertyInfo] fix resolving parent|self type hints (nicolas-grekas)
 * bug #27281 [HttpKernel] Fix dealing with self/parent in ArgumentMetadataFactory (fabpot)
 * bug #24805 [Security] Fix logout (MatTheCat)
 * bug #27265 [DI] Shared services should not be inlined in non-shared ones (nicolas-grekas)
 * bug #27141 [Process] Suppress warnings when open_basedir is non-empty (cbj4074)
 * bug #27250 [Session] limiting :key for GET_LOCK to 64 chars (oleg-andreyev)
 * feature #27128 [Messenger] Middleware factories support in config (ogizanagi)
 * bug #27214 [HttpKernel] Fix services are no longer injected into __invoke controllers method (ogizanagi)
 * bug #27237 [Debug] Fix populating error_get_last() for handled silent errors (nicolas-grekas)
 * bug #27232 [Cache][Lock] Fix usages of error_get_last() (nicolas-grekas)
 * bug #27236 [Filesystem] Fix usages of error_get_last() (nicolas-grekas)
 * feature #27202 [Messenger] Improve the profiler panel (ogizanagi)
 * bug #27191 [DI] Display previous error messages when throwing unused bindings (nicolas-grekas)
 * bug #27231 [FrameworkBundle] Fix cache:clear on vagrant (nicolas-grekas)
 * bug #27222 [WebProfilerBundle][Cache] Fix misses calculation when calling getItems (fsevestre)
 * bug #27227 [HttpKernel] Handle NoConfigurationException "onKernelException()" (nicolas-grekas)
 * feature #27034 [Messenger][DX] Uses custom method names for handlers (sroze)
 * bug #27228 [Messenger] Remove autoconfiguration for Sender/ReceiverInterface (kbond)
 * bug #27229 [Messenger] Rename tag attribute "name" by "alias" (yceruto)
 * bug #27224 [Messenger] Make sure default receiver name is set before command configuration (yceruto)
 * feature #27225 [Messenger] Autoconfiguring TransportFactoryInterface classes (yceruto)
 * bug #27220 [Messenger] Fix new AMQP Transport test with Envelope & fix contract (ogizanagi)
 * bug #27184 [Messenger] Fix return senders based on the message parents/interfaces (yceruto)
 * feature #27182 [Messenger] Re-introduce wrapped message configuration (with fix) (sroze, ogizanagi)
 * bug #27209 [Workflow] add is deprecated since Symfony 4.1. Use addWorkflow() instead (xkobal)
 * feature #26803 [Messenger] Add debug:messenger CLI command (ro0NL, sroze)
 * bug #27189 [Profiler] Fix dump makes toolbar disappear (ogizanagi)
 * bug #27199 [Messenger] Fix default bus name (ogizanagi)
 * bug #27198 [Messenger] Fix the transport factory after moving it (sroze)
 * bug #27197 [Messenger] Fix AMQP Transport factory & TransportFactoryInterface (ogizanagi)
 * bug #27196 [Messenger] Fix AMQP Transport (yceruto)

* 4.1.0-BETA1 (2018-05-07)

 * feature #26945 [Messenger] Support configuring messages when dispatching (ogizanagi)
 * feature #27168 [HttpKernel] Add Kernel::getAnnotatedClassesToCompile() (nicolas-grekas)
 * feature #27170 Show the deprecations tab by default in the logger panel (javiereguiluz)
 * feature #27130 [Messenger] Add a new time limit receiver (sdelicata)
 * feature #27104 [DX] Redirect to proper Symfony version documentation (noniagriconomie)
 * feature #27105 [Serializer] Add ->hasCacheableSupportsMethod() to CacheableSupportsMethodInterface (nicolas-grekas)
 * feature #24896 Add CODE_OF_CONDUCT.md (egircys)
 * feature #27092 [Workflow] "clear()" instead of "reset()" (nicolas-grekas)
 * feature #26655 [WebProfilerBundle] Make WDT follow ajax requests if header set (jeffreymb)
 * feature #27049 [Serializer] Cache the normalizer to use when possible (dunglas, nicolas-grekas)
 * feature #27062 [SecurityBundle] Register a `UserProviderInterface` alias if one provider only (sroze)
 * feature #27065 [DI][Routing] Allow invokable objects to be used as PHP-DSL loaders (aurimasniekis)
 * feature #26975 [Messenger] Add a memory limit option for `ConsumeMessagesCommand` (sdelicata)
 * feature #26864 [Messenger] Define multiple buses from the `framework.messenger.buses` configuration (sroze)
 * feature #27017 [Serializer] Allow to access to the context and various other infos in callbacks and max depth handler (dunglas)
 * feature #26832 [MonologBridge] Added WebSubscriberProcessor to ease processor configuration (lyrixx)
 * feature #24699 [HttpFoundation] Add HeaderUtils class (c960657)
 * feature #26791 [BrowserKit] Bypass Header Informations (cfjulien)
 * feature #26825 [Form] Add choice_translation_locale option for Intl choice types (yceruto, fabpot)
 * feature #26921 [DI][FrameworkBundle] Hide service ids that start with a dot (nicolas-grekas)
 * feature #23659 [HttpKernel] LoggerDataCollector: splitting logs on different sub-requests (vtsykun)
 * feature #26768 [DI] Allow autoconfigured calls in PHP (Gary PEGEOT, GaryPEGEOT)
 * feature #26833 [HttpKernel] Added support for timings in ArgumentValueResolvers (iltar)
 * feature #26770 Do not normalize array keys in twig globals (lstrojny)
 * feature #26787 [Security] Make security.providers optional (MatTheCat)
 * feature #26970 [VarDumper] Add dd() helper == dump() + exit() (nicolas-grekas)
 * feature #26941 [Messenger] Allow to configure the transport (sroze)
 * feature #26632 [Messenger] Add AMQP adapter (sroze)
 * feature #26863 [Console] Support iterable in SymfonyStyle::write/writeln (ogizanagi)
 * feature #26847 [Console] add support for iterable in output (Tobion)
 * feature #26660 [SecurityBundle] allow using custom function inside allow_if expressions (dmaicher)
 * feature #26096 [HttpFoundation] Added a migrating session handler (rossmotley)
 * feature #26528 [Debug] Support any Throwable object in FlattenException (derrabus)
 * feature #26811 [PhpUnitBridge] Search for other SYMFONY_* env vars in phpunit.xml then phpunit.xml.dist (lyrixx)
 * feature #26800 [PhpUnitBridge] Search for SYMFONY_PHPUNIT_REMOVE env var in phpunit.xml then phpunit.xml.dist (lyrixx)
 * feature #26684 [Messenger] Remove the Doctrine middleware configuration from the FrameworkBundle (sroze)
 * feature #21856 [LDAP] Allow adding and removing values to/from multi-valued attributes (jean-gui)
 * feature #26767 [Form] ability to set rounding strategy for MoneyType (syastrebov)
 * feature #23707 [Monolog Bridge][DX] Add a Monolog activation strategy for ignoring specific HTTP codes (simshaun, fabpot)
 * feature #26685 [Messenger] Add a `MessageHandlerInterface` (multiple messages + auto-configuration) (sroze)
 * feature #26648 [Messenger] Added a middleware that validates messages (Nyholm)
 * feature #26475 [HttpFoundation] split FileException into specialized ones about upload handling (fmata)
 * feature #26702 Mark ExceptionInterfaces throwable (ostrolucky)
 * feature #26656 [Workflow][Registry] Added a new 'all' method (alexpozzi, lyrixx)
 * feature #26693 [Console] Add box-double table style (maidmaid)
 * feature #26698 [Console] Use UTF-8 bullet for listing (ro0NL)
 * feature #26682 Improved the lint:xliff command (javiereguiluz)
 * feature #26681 Allow to easily ask Symfony not to set a response to private automatically (Toflar)
 * feature #26627 [DI] Add runtime service exceptions to improve the error message when controller arguments cannot be injected (nicolas-grekas)
 * feature #26504 [FrameworkBundle] framework.php_errors.log now accept a log level (Simperfit)
 * feature #26498 Allow "json:" env var processor to accept null value (mcfedr)
 * feature #25928 [DI] Allow binary values in parameters. (bburnichon)
 * feature #26647 [Messenger] Add a middleware that wraps all handlers in one Doctrine transaction. (Nyholm)
 * feature #26668 [WebProfilerBundle] Live duration of AJAX request (ostrolucky)
 * feature #26650 [Messenger] Clone messages to show in profiler (Nyholm)
 * feature #26281 [FrameworkBundle] keep query in redirect (Simperfit)
 * feature #26665 Improved the Ajax profiler panel when there are exceptions (javiereguiluz)
 * feature #26654 [VarDumper] Provide binary, allowing to start a server at any time (ogizanagi)
 * feature #26332 Add a data_help method in Form (mpiot, Nyholm)
 * feature #26671 More compact display of vendor code in exception pages (javiereguiluz)
 * feature #26502 [Form] Add Bootstrap 4 style for field FileType (zenmate)
 * feature #23888 [DI] Validate env vars in config (ro0NL)
 * feature #26658 Adding support to bind scalar values to controller arguments (weaverryan)
 * feature #26651 [Workflow] Added a TransitionException (andrewtch, lyrixx)
 * feature #23831 [VarDumper] Introduce a new way to collect dumps through a server dumper (ogizanagi, nicolas-grekas)
 * feature #26220 [HttpFoundation] Use parse_str() for query strings normalization (nicolas-grekas)
 * feature #24411 [Messenger] Add a new Messenger component (sroze)
 * feature #22150 [Serializer] Added a ConstraintViolationListNormalizer (lyrixx)
 * feature #26639 [SecurityBundle] Added an alias from RoleHierarchyInterface to security.role_hierarchy (lyrixx)
 * feature #26636 [DI] deprecate TypedReference::canBeAutoregistered() and getRequiringClass() (nicolas-grekas)
 * feature #26445 [Serializer] Ignore comments when decoding XML (q0rban)
 * feature #26284 [Routing] allow no-slash root on imported routes (nicolas-grekas)
 * feature #26092 [Workflow] Add a MetadataStore to fetch some metadata (lyrixx)
 * feature #26121 [FrameworkBundle] feature: add the ability to search a route (Simperfit)
 * feature #25197 [FrameworkBundle][TwigBridge] make csrf_token() usable without forms (xabbuh)
 * feature #25631 [DI] Service decoration: autowire the inner service (dunglas)
 * feature #26076 [Workflow] Add transition blockers (d-ph, lyrixx)
 * feature #24363 [Console] Modify console output and print multiple modifyable sections (pierredup)
 * feature #26381 Transform both switchToXHR() and removeXhr() to xmlHttpRequest() (Simperfit)
 * feature #26449 Make ProgressBar::setMaxSteps public (ostrolucky)
 * feature #26308 [Config] Introduce BuilderAwareInterface (ro0NL)
 * feature #26518 [Routing] Allow inline definition of requirements and defaults (nicolas-grekas)
 * feature #26143 [Routing]  Implement i18n routing (frankdejonge, nicolas-grekas)
 * feature #26564 [HttpFoundation] deprecate call to Request::getSession() when Request::hasSession() returns false (fmata)
 * feature #26408 Readd 'form_label_errors' block to disable errors on form labels (birkof)
 * feature #25456 [Console] Make pretty the `box` style table (maidmaid)
 * feature #26499 [FrameworkBundle] Allow fetching private services from test clients (nicolas-grekas)
 * feature #26509 [BrowserKit] Avoid nullable values in some Client's methods (ossinkine)
 * feature #26288 [FrameworkBundle] show the unregistered command warning at the end of the list command (Simperfit)
 * feature #26520 Added some HTML5 features to the Symfony Profiler (javiereguiluz)
 * feature #26398 [WebProfilerBundle] Display the missing translation panel by default (javiereguiluz)
 * feature #23409 [Security] AuthenticationUtils::getLastUsername() return type inconsistency (vudaltsov)
 * feature #26439 [Console] [DX] Fix command description/help display (noniagriconomie)
 * feature #26372 Revert "feature #24763 [Process] Allow writing portable "prepared" command lines (Simperfit)" (nicolas-grekas)
 * feature #26223 [FrameworkBundle] Add command to delete an item from a cache pool (pierredup)
 * feature #26341 Autoconfigure service locator tag (apfelbox)
 * feature #26330 [FORM] Fix HTML errors. (Nyholm)
 * feature #26334 [SecurityBundle] Deprecate switch_user.stateless config node (chalasr)
 * feature #26304 [Routing] support scheme requirement without redirectable dumped matcher (Tobion)
 * feature #26283 [Routing] Redirect from trailing slash to no-slash when possible (nicolas-grekas)
 * feature #25732 [Console] Add option to automatically run suggested command if there is only 1 alternative (pierredup)
 * feature #26085 Deprecate bundle:controller:action and service:method notation (Tobion)
 * feature #26175 [Security] Add configuration for Argon2i encryption (CoalaJoe)
 * feature #26075 [Validator] Deprecate use of `Locale` validation constraint without setting "canonicalize" option to `true` (phansys)
 * feature #26218 [MonologBridge] Allow to change level format in ConsoleFormatter (ostrolucky)
 * feature #26232 [Lock] Add a TTL to refresh lock (jderusse)
 * feature #26108 [Serializer] Add a MaxDepth handler (dunglas)
 * feature #24778 [BrowserKit] add a way to switch to ajax for one request (Simperfit)
 * feature #25605 [PropertyInfo] Added support for extracting type from constructor (lyrixx)
 * feature #24763 [Process] Allow writing portable "prepared" command lines (Simperfit)
 * feature #25218 [Serializer] add a constructor arguement to return csv always as collection  (Simperfit)
 * feature #25369 [Serializer] add a context key to return always as collection for XmlEncoder (Simperfit)
 * feature #26213 [FrameworkBundle] Add support to 307/308 HTTP status codes in RedirectController (ZipoKing)
 * feature #26149 Added support for name on the unit node (Nyholm)
 * feature #24308 [Validator] support protocolless urls validation (MyDigitalLife)
 * feature #26059  [Routing] Match 77.7x faster by compiling routes in one regexp (nicolas-grekas)
 * feature #22447 [WebProfilerBundle] Imply forward request by a new X-Previous-Debug-Token header (ro0NL)
 * feature #26152 [Intl] Add polyfill for Locale::canonicalize() (nicolas-grekas)
 * feature #26073 [DoctrineBridge] Add support for datetime immutable types in doctrine type guesser (jvasseur)
 * feature #26079 [Workflow] Remove constraints on transition/place name + Updated Dumper (lyrixx)
 * feature #23617 [PropertyInfo] Add hassers for accessors prefixes (sebdec)
 * feature #25997 Always show all deprecations except legacy ones when not weak (greg0ire)
 * feature #25582 [Form] Support \DateTimeImmutable (vudaltsov)
 * feature #24705 [Workflow] Add PlantUML dumper to workflow:dump command (Plopix)
 * feature #24508 [Serializer] Fix security issue on CsvEncoder about CSV injection (welcoMattic)
 * feature #25772 [Security] The AuthenticationException should implements Security's ExceptionInterface (sroze)
 * feature #25164 [WebProfilerBundle] Improve controller linking (ro0NL)
 * feature #22353 [Validator] Add `canonicalize` option for `Locale` validator (phansys)
 * feature #26036 Added support for getting default values in Accept headers (javiereguiluz)
 * feature #25780 [TwigBundle] Deprecating "false" in favor of "kernel.debug" as default value of "strict_variable" (yceruto)
 * feature #23508 Deprecated the AdvancedUserInterface (iltar)
 * feature #24781 [HttpFoundation] RedisSessionHandler (dkarlovi)
 * feature #26028 Unwrap errors in FlattenException (derrabus)
 * feature #25892 Adding an array adapter (weaverryan)
 * feature #24894 [FrameworkBundle] add a notice when passing a routerInterface without warmupInterface in RouterCacheWarmer (Simperfit)
 * feature #24632 [DependencyInjection] Anonymous services in PHP DSL (unkind)
 * feature #25836 [HttpKernel] Make session-related services extra-lazy (nicolas-grekas)
 * feature #25775 Introduce signaled process specific exception class (Soullivaneuh)
 * feature #22253 [Config] allow changing the path separator (bburnichon)
 * feature #25493 [Serializer] `default_constructor_arguments` context option for denormalization (Nek-)
 * feature #25839 [SecurityBundle] Deprecate in_memory.user abstract service (chalasr)
 * feature #24392 Display orphaned events in profiler (kejwmen)
 * feature #25275 [DI] Allow for invokable event listeners (ro0NL)
 * feature #25627 [DI] Add a simple CSV env var processor (dunglas)
 * feature #25092 [Security] #25091 add target user to SwitchUserListener (jwmickey)
 * feature #24777 [TwigBundle] Added priority to twig extensions (Brunty)
 * feature #25710 [FrameworkBundle] add cache.app.simple psr simple cache (dmaicher)
 * feature #25669 [Security] Fail gracefully if the security token cannot be unserialized from the session (thewilkybarkid)
 * feature #25504 [Validator] Add option to pass custom values to Expression validator (ostrolucky)
 * feature #25701 [FrameworkBundle] add autowiring aliases for TranslationReaderInterface, ExtractorInterface & TranslationWriterInterface (Dennis Langen)
 * feature #25516 [Validator] Deprecated "checkDNS" option in Url constraint (ro0NL)
 * feature #25588 Move SecurityUserValueResolver to security-http (chalasr)
 * feature #25629 [Process] Make `PhpExecutableFinder` look for the `PHP_BINARY` env var (nicolas-grekas)
 * feature #25562 allow autowire for http_utils class (do-see)
 * feature #25478 [FrameworkBundle] add email_validation_mode option (xabbuh)
 * feature #25366 [HttpKernel] Decouple exception logging from rendering (ro0NL)
 * feature #25450 [PropertyAccess] add more information to NoSuchPropertyException Message (Simperfit)
 * feature #25148 Pr/workflow name as graph label (shdev)
 * feature #25324 [HttpFoundation] Incorrect documentation and method name for UploadedFile::getClientSize() (Simperfit)
 * feature #24738 [FrameworkBundle][Routing] Use a PSR-11 container in FrameworkBundle Router (ogizanagi)
 * feature #25439 Add ControllerTrait::getParameter() (chalasr)
 * feature #25332 [VarDumper] Allow VarDumperTestTrait expectation to be non-scalar (romainneutron)
 * feature #25301 [Console] Add box style table (maidmaid)
 * feature #25415 [FrameworkBundle] Add atom editor to ide config (lexcast)
 * feature #24442 [Validator] Html5 Email Validation (PurpleBooth)
 * feature #25288 [DI][FrameworkBundle] Add PSR-11 "ContainerBag" to access parameters as-a-service (nicolas-grekas, sroze)
 * feature #25290 [FrameworkBundle] debug:autowiring: don't list FQCN when they are aliased (nicolas-grekas)
 * feature #24375 [Serializer] Serialize and deserialize from abstract classes (sroze)
 * feature #25346 [DoctrineBridge] DoctrineDataCollector comments the non runnable part of the query (Simperfit)
 * feature #24216 added clean option to assets install command (robinlehrmann)
 * feature #25142 [Process] Create a "isTtySupported" static method (nesk)
 * feature #24751 [Workflow] Introduce a Workflow interface (Simperfit)
 * feature #25293 [Routing] Parse PHP constants in YAML routing files (ostrolucky)
 * feature #25295 [Translation] Parse PHP constants in YAML translation files (ostrolucky)
 * feature #25294 [Serializer] Parse PHP constants in YAML mappings (ostrolucky)
 * feature #24637 [FrameworkBundle] Improve the DX of TemplateController when using SF 4 (dunglas)
 * feature #25178 [Routing] Allow to set name prefixes from the configuration (sroze)
 * feature #25237 [VarDumper] add a GMP caster in order to cast GMP resources into string or integer (Simperfit)
 * feature #25166 [WebProfilerBundle] Expose dotenv variables (ro0NL)
 * feature #24785 [Profiler][Translation] Logging false by default and desactivated when using the profiler (Simperfit)
 * feature #24826 [FrameworkBundle] Allow to pass a logger instance to the Router (ogizanagi)
 * feature #24937 [DependencyInjection] Added support for variadics in named arguments (PabloKowalczyk)
 * feature #24819 [Console] add setInputs to ApplicationTester and share some code (Simperfit)
 * feature #25131 [SecurityBundle][Security][Translation] trigger some deprecations for legacy methods (xabbuh)

