CHANGELOG for 5.2.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 5.2 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v5.2.0...v5.2.1

* 5.2.13 (2021-07-27)

 * bug #42270 [WebProfilerBundle] [WebProfiler] "empty" filter bugfix. Filter with name "empty" is not … (luzrain)

* 5.2.12 (2021-07-26)

 * bug #42212 [Lock] Handle lock with long key (jderusse)
 * bug #42223 [Debug][ErrorHandler] Do not use the php80 polyfill (nicolas-grekas)
 * bug #42207 [Console] fix table setHeaderTitle without headers (a1812)
 * bug #42130 [Translation] fix fallback to Locale::getDefault() (nicolas-grekas)
 * bug #42184 [Mailer] Make sure Http TransportException is not leaking (Nyholm)
 * bug #42091 [Console] Run commands when implements SignalableCommandInterface without pcntl and they have'nt signals (PaolaRuby)
 * bug #42150 [Form] Fix 'invalid_message' use in multiple ChoiceType (alexandre-daubois)
 * bug #42183 [Notifier] Allow passing a previous throwable to exceptions (derrabus)
 * bug #42182 [Notifier] Make sure Http TransportException is not leaking (Nyholm)
 * bug #42173 [Messenger] [Redis] Fix auth option wrongly considered invalid (chalasr)
 * bug #42174 Indicate compatibility with psr/log 2 and 3 (derrabus)
 * bug #42112 [HttpFoundation] fix FileBag under PHP 8.1 (alexpott)
 * bug #42131 [PhpUnitBridge] Fix composer resolution on Windows (Rainrider)
 * bug #42097 [DependencyInjection] Support for intersection types (derrabus)
 * bug #42114 [HttpFoundation] Fix return types of SessionHandler::gc() (derrabus)
 * bug #42099 [VarDumper] Support for intersection types (derrabus)
 * bug #42011 [Cache] Support decorated Dbal drivers in PdoAdapter (Jeroeny)
 * bug #42068 Add a Special Case for Translating Choices in en_US_POSIX (chrisguitarguy)
 * bug #42074 Fix ctype_digit deprecation (alexpott)
 * bug #42084 [WebProfilerBundle] Fix the values of some CSS properties (javiereguiluz)
 * bug #42079 [FrameworkBundle] Fixed file operations in Sodium vault seal (javiereguiluz)
 * bug #42067 [Messenger] [Redis] Make `auth` option works (welcoMattic)
 * bug #42054 [DoctrineBridge] fix setting default mapping type to attribute/annotation on php 8/7 respectively (nicolas-grekas)
 * bug #42059 [Messenger] Fixed BC layer for RedeliveryStamp (Nyholm)
 * bug #42049 [TwigBridge] do not render the same label id attribute twice (xabbuh)
 * bug #42032 [HttpKernel] recover from failed deserializations (xabbuh)
 * bug #42035 [Messenger] Fix use_notify default value for PostgreSqlConnection (tgalopin)
 * bug #41990 [Lock] fix derivating semaphore from key (nicolas-grekas)
 * bug #40529 [Translation] Missing translations from traits (insekticid)
 * bug #41384 Fix SkippedTestSuite (jderusse)
 * bug #41966 [Console] Revert "bug #41952  fix handling positional arguments" (chalasr, nicolas-grekas)
 * bug #41905 [EventDispatcher] Correct the called event listener method case (JJsty1e)
 * bug #41952 [Console] fix handling positional arguments (nicolas-grekas)
 * bug #41887 [PhpUnitBridge] Fix deprecation handler with PHPUnit 10 (YaFou)

* 5.2.11 (2021-06-30)

 * bug #41893 [Filesystem] Workaround cannot dumpFile into "protected" folders on Windows (arnegroskurth)
 * bug #41896 [Messenger] fix FlattenExceptionNormalizer (nicolas-grekas)
 * bug #41242 [SecurityBundle] Change information label from red to yellow (94noni)
 * bug #41665 [HttpKernel] Keep max lifetime also when part of the responses don't set it (mpdude)
 * bug #41760 [ErrorHandler] fix handling buffered SilencedErrorContext (nicolas-grekas)
 * bug #41807 [HttpClient] fix Psr18Client when allow_url_fopen=0 (nicolas-grekas)
 * bug #40857 [DependencyInjection] Add support of PHP enumerations (alexandre-daubois)
 * bug #41767 [Config] fix tracking default values that reference the parent class (nicolas-grekas)
 * bug #41768 [DependencyInjection] Fix binding "iterable $foo" when using the PHP-DSL (nicolas-grekas)
 * bug #41801 [Uid] Fix fromString() with low base58 values (fancyweb)
 * bug #41793 [Cache] handle prefixed redis connections when clearing pools (nicolas-grekas)
 * bug #41804 [Cache] fix eventual consistency when using RedisTagAwareAdapter with a cluster (nicolas-grekas)
 * bug #41773 [Cache] Disable locking on Windows by default (nicolas-grekas)
 * bug #41655 [Mailer] fix encoding of addresses using SmtpTransport (dmaicher)
 * bug #41663 [HttpKernel] [HttpCache] Keep s-maxage=0 from ESI sub-responses (mpdude)
 * bug #41739 Avoid broken action URL in text notification mail (mbrodala)
 * bug #41701 [VarDumper] Fix tests for PHP 8.1 (alexandre-daubois)
 * bug #41795 [FrameworkBundle] Replace var_export with VarExporter to use array short syntax in secrets list files (alexandre-daubois)
 * bug #41779 [DependencyInjection] throw proper exception when decorating a synthetic service (nicolas-grekas)
 * bug #41776 [ErrorHandler] [DebugClassLoader] Do not check Phake mocks classes (adoy)
 * bug #41780 [PhpUnitBridge] fix handling the COMPOSER_BINARY env var when using simple-phpunit (Taluu)
 * bug #41670 [HttpFoundation] allow savePath of NativeFileSessionHandler to be null (simon.chrzanowski)
 * bug #41751 [Messenger] prevent reflection usages when classes do not exist (xabbuh)
 * bug #41616 [Messenger] Remove TLS related options when not using TLS (odolbeau)
 * bug #41719 [FrameworkBundle] fix Could not find service "test.service_container" (smilesrg)
 * bug #41674 [HttpClient] fix compat with cURL <= 7.37 (nicolas-grekas)
 * bug #41656 [HttpClient] throw exception when AsyncDecoratorTrait gets an already consumed response (nicolas-grekas)
 * bug #41644 [Config] fix tracking attributes in ReflectionClassResource (nicolas-grekas)
 * bug #41621 [Process] Fix incorrect parameter type (bch36)
 * bug #41624 [HttpClient] Revert bindto workaround for unaffected PHP versions (derrabus)
 * bug #41549 [Security] Fix opcache preload with alias classes (jderusse)
 * bug #41491 [Serializer] Do not allow to denormalize string with spaces only to valid a DateTime object (sidz)
 * bug #41218 [DependencyInjection] Update loader’s directory when calling ContainerConfigurator::withPath (MatTheCat)
 * bug #41505 [FrameworkBundle] fix KernelBrowser::loginUser with a stateless firewall (dunglas)
 * bug #41509 [SecurityBundle] Link UserProviderListener to correct firewall dispatcher (Matth--)
 * bug #41386 [Console] Escape synopsis output (jschaedl)
 * bug #41495 [HttpFoundation] Add ReturnTypeWillChange to SessionHandlers (nikic)

* 5.2.10 (2021-06-01)

 * bug #41000 [Form] Use !isset for checks cause this doesn't falsely include 0 (Kai Dederichs)
 * bug #41407 [DependencyInjection] keep container.service_subscriber tag on the decorated definition (xabbuh)
 * bug #40866 [Filesystem] fix readlink() for Windows (a1812)
 * bug #41394 [Form] fix support for years outside of the 32b range on x86 arch (nicolas-grekas)
 * bug #41380 Make Mailgun Header compatible with other Bridges (jderusse)
 * bug #39847 [Messenger] Fix merging PrototypedArrayNode associative values (svityashchuk)
 * bug #41346 [WebProfilerBundle] Wrapping exception js in Sfjs check and also loading base_js Sfjs if needed (weaverryan)
 * bug #41344 [VarDumper] Don't pass null to parse_url() (derrabus)

* 5.2.9 (2021-05-19)

 * security #cve-2021-21424 [Security\Core] Fix user enumeration via response body on invalid credentials (chalasr)
 * bug #41275 Fixes Undefined method call (faizanakram99)
 * bug #41269 [SecurityBundle] Remove invalid unused service (chalasr)
 * bug #41139 [Security] [DataCollector] Remove allows anonymous information in datacollector (ismail1432)
 * bug #41230 [FrameworkBundle][Validator] Fix deprecations from Doctrine Annotations+Cache (derrabus)
 * bug #41206 [Mailer] Fix SES API call with UTF-8 Addresses (jderusse)
 * bug #41240 Fixed deprecation warnings about passing null as parameter (derrabus)
 * bug #41241 [Finder] Fix gitignore regex build with "**" (mvorisek)
 * bug #41224 [HttpClient] fix adding query string to relative URLs with scoped clients (nicolas-grekas)
 * bug #41233 [DependencyInjection][ProxyManagerBridge] Don't call class_exists() on null (derrabus)
 * bug #41211 [Notifier] Add missing charset to content-type for Slack notifier (norkunas)
 * bug #41210 [Console] Fix Windows code page support (orkan)

* 5.2.8 (2021-05-12)

 * security #cve-2021-21424 [Security][Guard] Prevent user enumeration (chalasr)
 * bug #41176 [DependencyInjection] fix dumping service-closure-arguments (nicolas-grekas)
 * bug #41174 [Console] Fix Windows code page support (orkan)
 * bug #41173 [Security] Make Login Rate Limiter also case insensitive for non-ascii user identifiers (Seldaek)
 * bug #41168 WDT: Only load "Sfjs" if it is not present already (weaverryan)
 * bug #41147 [Inflector][String] wrong plural form of words ending by "pectus" (makraz)
 * bug #41160 [HttpClient] Don't prepare the request in ScopingHttpClient (nicolas-grekas)
 * bug #41156 [Security] Make Login Rate Limiter case insensitive (jderusse)
 * bug #41137 [Security] Reset limiters on successful login (MatTheCat)
 * bug #40758 [Security] NullToken signature (jderusse)
 * bug #40763 Fix/Rewrite .gitignore regex builder (mvorisek)
 * bug #41113 [Console] Fix Windows code page support (orkan)
 * bug #40902 [Security] Allow ips parameter in access_control to accept comma-separated string (edefimov)
 * bug #40980 [TwigBridge] Fix HTML for translatable custom-file label in Bootstrap 4 theme (acran)
 * bug #40955 [Notifier] [Bridge] Fix missed messageId for SendMessage object in slack notifier (WaylandAce)
 * bug #40943 [PropertyInfo] PhpDocExtractor: Handle "true" and "false" property types (Maciej Zgadzaj)
 * bug #40759 [Form] Add missing TranslatableMessage support to choice_label option of ChoiceType (alexandre-daubois)
 * bug #40917 [Config][DependencyInjection] Uniformize trailing slash handling (dunglas)
 * bug #40699 [PropertyInfo] Make ReflectionExtractor correctly extract nullability (shiftby)
 * bug #40874 [PropertyInfo] fix attribute namespace with recursive traits (soullivaneuh)
 * bug #40957 [PhpUnitBridge] Fix tests with ``@doesNotPerformAssertions`` annotations (alexpott)
 * bug #41099 [Cache] Check if phpredis version is compatible with stream parameter (nicolassing)
 * bug #40982 [Notifier] Fix return SentMessage then Messenger not used (WaylandAce)
 * bug #41072 [VarExporter] Add support of PHP enumerations (alexandre-daubois)
 * bug #41104 Fix return type in isAllowedProperty method on ReflectionExtractor class (Tomanhez)
 * bug #41078 [Notifier] Make FailoverTransport always pick the first transport (jschaedl)
 * bug #41105 [Inflector][String] Fixed singularize `edges` > `edge` (ruudk)
 * bug #41075 [ErrorHandler] Skip "same vendor" ``@method`` deprecations for `Symfony\*` classes unless symfony/symfony is being tested (nicolas-grekas)

* 5.2.7 (2021-05-01)

 * bug #41008 [Security] Do not try to rehash null-passwords (tjveldhuizen)
 * bug #40993 [Security] [Security/Core] fix checking for bcrypt (nicolas-grekas)
 * bug #40923 [Yaml] expose references detected in inline notation structures (xabbuh)
 * bug #40964 [HttpFoundation] Fixes for PHP 8.1 deprecations (jrmajor)
 * bug #40919 [Mailer] use correct spelling when accessing the SMTP php.ini value (xabbuh)
 * bug #40514 [Yaml] Allow tabs as separators between tokens (bertramakers)
 * bug #40882 [Cache] phpredis: Added full TLS support for RedisCluster (jackthomasatl)
 * bug #40872 [DependencyInjection] [AliasDeprecatedPublicServicesPass] Noop when the service is private (fancyweb)
 * bug #40802 [FrameworkBundle] Fix array controller link in debug:router (fancyweb)
 * bug #40793 [DoctrineBridge] Add support for a driver type "attribute" (beberlei)
 * bug #40807 RequestMatcher issue when `_controller` is a closure (Plopix)
 * bug #40811 [PropertyInfo] Use the right context for methods defined in traits (colinodell)
 * bug #40791 [WebProfilerBundle] Use ControllerReference instead of URL in twig render() (Foxprodev)
 * bug #40330 [SecurityBundle] Empty line starting with dash under "access_control" causes all rules to be skipped (monteiro)
 * bug #40780 [Cache] Apply NullAdapter as Null Object (roukmoute)
 * bug #40740 [Cache][FrameworkBundle] Fix logging for TagAwareAdapter (fancyweb)
 * bug #40755 [Routing] Better inline requirements and defaults parsing (Foxprodev)
 * bug #40754 [PhpUnitBridge] Fix phpunit symlink on Windows (johnstevenson)
 * bug #40660 [Form] Fix 'invalid_message' use in multiple ChoiceType (alexandre-daubois)
 * bug #40707 [Yaml] Fixed infinite loop when parser goes through an additional and invalid closing tag (alexandre-daubois)
 * bug #40698 [Console] Add Helper::width() and Helper::length() (Nyholm, grasmash)
 * bug #40679 [Debug][ErrorHandler] Avoid warning with Xdebug 3 with develop mode disabled (Jean85)
 * bug #40702 [HttpClient] allow CurlHttpClient on Windows (n0rbyt3)
 * bug #40503 [Yaml] fix parsing some block sequences (a1812)
 * bug #40610 Fixed bugs found by psalm (Nyholm)
 * bug #40603 [Config] Fixed support for nodes not extending BaseNode (Nyholm)
 * bug #40658 [RateLimiter] Fix sleep value (jderusse)
 * bug #40645 [FrameworkBundle] Dont store cache misses on warmup (Nyholm)
 * bug #40629 [DependencyInjection] Fix "url" env var processor behavior when the url has no path (fancyweb)
 * bug #40655 [Cache] skip storing failure-to-save as misses in ArrayAdapter (nicolas-grekas)
 * bug #40522 [Serializer] Allow AbstractNormalizer to use null for non-optional nullable constructor parameters without default value (Pierre Rineau)
 * bug #40595 add missing queue_name to find(id) in doctrine messenger transport (monteiro)
 * bug #40619 [FrameworkBundle] dont access the container to configure http_cache (nicolas-grekas)

* 5.2.6 (2021-03-29)

 * bug #40598 [Form] error if the input string couldn't be parsed as a date (xabbuh)
 * bug #40587 [HttpClient] fix using stream_copy_to_stream() with responses cast to php streams (nicolas-grekas)
 * bug #40510 [Form] IntegerType: Always use en for IntegerToLocalizedStringTransformer (Warxcell)
 * bug #40593 Uses the correct assignment action for console options depending if they are short or long (topikito)
 * bug #40535 [HttpKernel] ConfigDataCollector to return known data without the need of a Kernel (topikito)
 * bug #40552 [Translation] Fix update existing key with existing +int-icu domain (Alexis)
 * bug #40541 Fixed parsing deprecated definitions without message key (adamwojs)
 * bug #40537 [Security] Handle properly 'auto' option for remember me cookie security (fliespl)
 * bug #40524 [Console] fix emojis messing up the line width (MarionLeHerisson)
 * bug #40506 [Validator] Avoid triggering the autoloader for user-input values (Seldaek)
 * bug #40544 [FrameworkBundle] ensure TestBrowserToken::$firewallName is serialized (kbond)
 * bug #40547 [RateLimiter] Security hardening - Rate limiter (jderusse)
 * bug #40538 [HttpClient] remove using $http_response_header (nicolas-grekas)
 * bug #40508 [PhpUnitBridge] fix reporting deprecations from DebugClassLoader (nicolas-grekas)
 * bug #40497 [HttpFoundation] enable HTTP method overrides as early as possible with the HTTP cache (xabbuh)
 * bug #40348 [Console] Fix line wrapping for decorated text in block output (grasmash)
 * bug #40499 [Inflector][String] Fixed pluralize "coupon" (Nyholm)
 * bug #40494 [PhpUnitBridge] fix compat with symfony/debug (nicolas-grekas)
 * bug #40453 [VarDumper] Adds support for ReflectionUnionType to VarDumper (Michael Nelson, michaeldnelson)
 * bug #40460 Correctly clear lines for multi-line progress bar messages (grasmash)
 * bug #40490 [Security] Add XML support for authenticator manager (wouterj)
 * bug #40242 [ErrorHandler] Fix error caused by `include` + open_basedir (stlrnz)
 * bug #40368 [FrameworkBundle] Make the TestBrowserToken interchangeable with other tokens (Seldaek)
 * bug #40450 [Console] ProgressBar clears too many lines on update (danepowell)
 * bug #40178 [FrameworkBundle] Exclude unreadable files when executing About command (michaljusiega)
 * bug #40472 [Bridge\Twig] Add 'form-control-range' for range input type (Oviglo)
 * bug #40481 make async-ses required (jderusse)
 * bug #39866 [Mime] Escape commas in address names (YaFou)
 * bug #40373 Check if templating engine supports given view (fritzmg)
 * bug #39992 [Security] Refresh original user in SwitchUserListener (AndrolGenhald)
 * bug #40446 [TwigBridge] Fix "Serialization of 'Closure'" error when rendering an TemplatedEmail (jderusse)
 * bug #40416 Fix `ConstraintViolation#getMessageTemplate()` to always return `string` (Ocramius)
 * bug #40425 [DoctrineBridge] Fix eventListener initialization when eventSubscriber constructor dispatch an event (jderusse)
 * bug #40313 [FrameworkBundle] Fix PropertyAccess definition when not in debug (PedroTroller)
 * bug #40417 [Form] clear unchecked choice radio boxes even if clear missing is set to false (xabbuh)
 * bug #40388 [ErrorHandler] Added missing type annotations to FlattenException (derrabus)
 * bug #40407 [TwigBridge] Allow version 3 of the Twig extra packages (derrabus)

* 5.2.5 (2021-03-10)

 * bug #40415 Fix `ConstraintViolation#getPropertyPath()` to always return `string` (Ocramius)
 * bug #40421 [FrameworkBundle] fix XSD (nicolas-grekas)
 * bug #39685 [Mailer][Mime][TwigBridge][Validator] Allow egulias/email-validator 3.x (derrabus)
 * bug #40398 [FrameworkBundle] : Fix method name compare in ResolveControllerNameSubscriber (glensc)
 * bug #39733 [TwigBridge] Render email once (jderusse)
 * bug #40386 [DependencyInjection][Security] Backport psr/container 1.1/2.0 compatibility (derrabus)
 * bug #40376 [Messenger] Don't lock tables or start transactions (Nyholm)
 * bug #40378 Changing ZulipTransportFactory tag to prevent the exception UnsupportedSchemeException (big-r81)

* 5.2.4 (2021-03-04)

 * bug #40336 [Messenger] Doctrine setup with migrations (Nyholm)
 * bug #40318 [Translation] deal with indented heredoc/nowdoc tokens (xabbuh)
 * bug #40350 [DependencyInjection] fix parsing calls of methods named "method" (xabbuh)
 * bug #40316 [Serializer] zero parts can be omitted in date interval input (xabbuh)
 * bug #40239 MockResponse total_time should not be simulated when provided (Pierrick VIGNAND)
 * bug #40299 [Cache] Add server-commands support for Predis Replication Environments (DemigodCode)
 * bug #40231 [HttpKernel] Configure `session.cookie_secure` earlier (tamcy)
 * bug #40283 [Translation] Make `name` attribute optional in xliff2 (MarieMinasyan)
 * bug #40286 [Security] #[CurrentUser] arguments should resolve to null for "anon." (chalasr)
 * bug #40281 [FrameworkBundle] Allow x-forwarded-prefix trusted header in config (drupol)
 * bug #39599 [Cache] Fix Redis TLS scheme `rediss` for Redis connection (misaert)
 * bug #40244 [Routing] fix conflict with param named class in attribute (nlhommet)
 * bug #40273 [Cache] fix setting items' metadata on commit() (nicolas-grekas)
 * bug #40258 [Form] Ignoring invalid forms from delete_empty behavior in CollectionType (yceruto)
 * bug #40246 [EventDispatcher] fix registering subscribers twice on edge-case (nicolas-grekas)
 * bug #40162 [Intl] fix Locale::getFallback() throwing exception on long $locale (AmirHo3ein13)
 * bug #40211 [Validator] fix taking error message from the correct violation (xabbuh)
 * bug #40208 [PropertyInfo] fix resolving self to name of the analyzed class (xabbuh)
 * bug #40209 [WebLink] Escape double quotes in attributes values (fancyweb)
 * bug #40192 [Console] fix QuestionHelper::getHiddenResponse() not working with space in project directory name (Yendric)
 * bug #40203 [String] Check if function exists before declaring it (Nyholm)
 * bug #40175 [PropertyInfo]  use the right context for properties defined in traits (xabbuh)
 * bug #40172 [Translation] Allow using dashes in locale when linting Xliff files (localheinz)
 * bug #39671 [Worflow] Fixed GuardListener when using the new Security system (lyrixx)
 * bug #40187 [Console] Fix PHP 8.1 null error for preg_match flag (kylekatarnls)
 * bug #39659 [Form] keep valid submitted choices when additional choices are submitted (xabbuh)
 * bug #40188 [HttpFoundation] Fix PHP 8.1 null values (kylekatarnls)
 * bug #40167 [DependencyInjection] Definition::removeMethodCall should remove all matching calls (ruudk)
 * bug #40160 [PropertyInfo] fix extracting mixed type-hinted property types (xabbuh)
 * bug #40040 [Finder] Use a lazyIterator to close files descriptors when no longer used (jderusse)
 * bug #40141 [RateLimiter] Fix sliding_window misbehaving with stale records  (xesxen)
 * bug #40135 [FrameworkBundle] Fix freshness checks with boolean parameters on routes (HypeMC)
 * bug #40138 [FrameworkBundle] fix registering "annotations.cache" on the "container.hot_path" (nicolas-grekas)
 * bug #40137 [Form] forward the label_html option to expanded choice fields (xabbuh)
 * bug #40116 [FrameworkBundle][Translator] scan directories for translations sequentially (xabbuh)
 * bug #40124 [Form] merge translation parameters with value configured for parent form (xabbuh)
 * bug #40104 [HttpKernel] [Kernel] Silence failed deprecations logs writes (fancyweb)
 * bug #40098 [DependencyInjection] fix tracking of changes to vendor/ dirs (nicolas-grekas)
 * bug #39980 [Mailer][Mime] Update inline part names with newly generated ContentId (ddegentesh)
 * bug #40043 [HttpFoundation] Setting `REQUEST_TIME_FLOAT` when constructing a Request object (ctasada)
 * bug #40050 [FrameworkBundle][Translator] Fixed updating catalogue metadata from Intl domain (yceruto)
 * bug #40080 Fix Request with DNS issue not retried (jderusse)
 * bug #40089 [SecurityBundle] role_names variable instead of roles (wickedOne)
 * bug #40042 [Doctrine] Restore priority for EventSubscribers (jderusse)
 * bug #40066 [ErrorHandler] fix parsing return types in DebugClassLoader (nicolas-grekas)
 * bug #40065 [ErrorHandler] fix handling messages with null bytes from anonymous classes (nicolas-grekas)
 * bug #40067 [PhpUnitBridge] fix reporting deprecations when they come from DebugClassLoader (nicolas-grekas)

* 5.2.3 (2021-02-03)

 * bug #39954 [Mailer][Mime] Fix case-sensitive handling of header names (piku235)
 * bug #40055 [Messenger] Fix Doctrine setup when using a migration (fabpot)
 * bug #40018 [TwigBridge] take into account all label related options (xabbuh)
 * bug #40023 [Finder]  use proper keys to not override appended files (xabbuh)
 * bug #40019 [ErrorHandler] Fix strpos error when trying to call a method without a name (Deuchnord)
 * bug #40027 [DoctrineBridge] add missing `@experimental` annotation on Uid generators (nicolas-grekas)
 * bug #40004 [Serializer] Prevent access to private properties without getters (julienfalque)
 * bug #40003 [Uid] Fix time to float conversion (fancyweb)

* 5.2.2 (2021-01-27)

 * bug #38900 [Serializer] Exclude non-initialized properties accessed with getters (BoShurik)
 * bug #39982 [SecurityBundle] Fix referencing aliases from RegisterEntryPointsPass (chalasr)
 * bug #39872 [Validator] propagate the object being validated to nested constraints (xabbuh)
 * bug #39887 [Translator] fix handling plural for floating numbers (kylekatarnls)
 * bug #39967 [Messenger] fix redis messenger options with dsn (Kleinast)
 * bug #39970 [Messenger] Fix transporting non-UTF8 payloads by encoding them using base 64 (nicolas-grekas)
 * bug #39956 [Uid] fix checking for valid UUIDs (nicolas-grekas)
 * bug #39951 [Form] check parent types for label_format and translation_domain (xabbuh)
 * bug #39911 [RateLimiter] Fix infinite values with NoLimiter (YaFou)
 * bug #39936 [Validator] Fix DebugCommand (loic425)
 * bug #39909 [PhpUnitBridge] Allow relative path to composer cache (jderusse)
 * bug #39944 [HttpKernel] Configure the ErrorHandler even when it is overriden (nicolas-grekas)
 * bug #39896 [PropertyInfo] Fix breaking change with has*(arguments...) methods (YaFou)
 * bug #39932 [Console] [Command] Fix Closure code binding when it is a static anonymous function (fancyweb)
 * bug #39871 [Notifier] [OvhCloud] “Invalid signature” for message with slashes (OneT0uch)
 * bug #39900 [Uid] Unable to extend Uuid/Ulid and use fromString() (OskarStark)
 * bug #39880 [DoctrineBridge] Add username to UserNameNotFoundException (qurben)
 * bug #39633 [HttpFoundation] Drop int return type from parseFilesize() (LukeTowers)
 * bug #39889 [HttpClient] Add check for constant in Curl client (pierredup)
 * bug #39886 [HttpFoundation] Revert #38614 and add assert to avoid regressions (BafS)
 * bug #39873 [DependencyInjection] Fix container injection with TypedReference (jderusse)
 * bug #39858 Fix problem when SYMFONY_PHPUNIT_VERSION is empty string value (alexander-schranz)
 * bug #39861 [DependencyInjection] Skip deprecated definitions in CheckTypeDeclarationsPass (chalasr)
 * bug #39862 [Security] Replace message data in JSON security error response (wouterj)
 * bug #39859 [Security] Replace message data in JSON security error response (wouterj)
 * bug #39839 [Messenger] [AmazonSqs] Fix auto-setup for fifo queue (starred-gijs)
 * bug #39667 [DoctrineBridge] Take into account that indexBy="person_id" could be a db column name, for a referenced entity (victormacko)
 * bug #39799 [DoctrineBridge] Fix circular loop with EntityManager (jderusse)
 * bug #39821 [DependencyInjection] Don't trigger notice for deprecated aliases pointing to deprecated definitions (chalasr)
 * bug #39816 [HttpFoundation] use atomic writes in MockFileSessionStorage (nicolas-grekas)
 * bug #39812 Make EmailMessage & SmsMessage transport nullable (odolbeau)
 * bug #39735 [Serializer] Rename normalize param (VincentLanglet)
 * bug #39797 Dont allow unserializing classes with a destructor (jderusse)
 * bug #39743 [Mailer] Fix missing BCC recipients in SES bridge (jderusse)
 * bug #39764 [Config]  fix handling float-like key attribute values (xabbuh)
 * bug #39787 [Yaml] a colon followed by spaces exclusively separates mapping keys and values (xabbuh)
 * bug #39788 [Cache] fix possible collision when writing tmp file in filesystem adapter (nicolas-grekas)
 * bug #39796 Dont allow unserializing classes with a destructor - 5.2 (jderusse)
 * bug #39794 Dont allow unserializing classes with a destructor - 4.4 (jderusse)
 * bug #39795 Dont allow unserializing classes with a destructor - 5.1 (jderusse)
 * bug #39389 [Security]  Move the handleAuthenticationSuccess logic outside try/catch block (jderusse)
 * bug #39747 [DependencyInjection] Support PHP 8 builtin types in CheckTypeDeclarationsPass (derrabus)
 * bug #39738 [VarDumper] fix mutating $GLOBALS while cloning it (nicolas-grekas)
 * bug #39746 [DependencyInjection] Fix InvalidParameterTypeException for function parameters (derrabus)
 * bug #39681 [HttpFoundation] parse cookie values containing the equal sign (xabbuh)
 * bug #39716 [DependencyInjection] do not break when loading schemas from network paths on Windows (xabbuh)
 * bug #39703 [Finder] apply the sort callback on the whole search result (xabbuh)
 * bug #39717 [TwigBridge] Remove full head content in HTML to text converter (pupaxxo)
 * bug #39672 [FrameworkBundle] Fix UidNormalizer priority (fancyweb)
 * bug #39649 [Validator] propagate groups to nested constraints (xabbuh)
 * bug #39708 [WebProfilerBundle] take query and request parameters into account when matching routes (xabbuh)
 * bug #39692 [FrameworkBundle] Dump abstract arguments (jderusse)
 * bug #39683 [Yaml] keep trailing newlines when dumping multi-line strings (xabbuh)
 * bug #39670 [Form] disable error bubbling by default when inherit_data is configured (xabbuh)
 * bug #39686 [Lock] Fix config merging in lock (jderusse)
 * bug #39668 [Yaml] do not dump extra trailing newlines for multiline blocks (xabbuh)
 * bug #39674 [Messenger] fix postgres transport when the retry table is the same (lyrixx)
 * bug #39653 [Form] fix passing null $pattern to IntlDateFormatter (nicolas-grekas)
 * bug #39637 [Security] Fix event propagation for AuthenticationTokenCreatedEvent when globally registered (scheb)
 * bug #39647 [Validator] Update Isin message to match the translation files (derrabus)
 * bug #39598 [Messenger] Fix stopwach usage if it has been reset (lyrixx)
 * bug #39636 [Uid] Handle ValueErrors triggered by ext-uuid on PHP 8 (derrabus)
 * bug #39631 [VarDumper] Fix display of nullable union return types (derrabus)
 * bug #39629 [VarDumper] fixed displaying "mixed" as "?mixed" (nicolas-grekas)
 * bug #39597 [Mailer] Handle failure when sending DATA (jderusse)
 * bug #39621 [Security] Fix event propagation for globally registered security events (scheb)
 * bug #39603 [TwigBridge] allow null values in form helpers (xabbuh)
 * bug #39610 [ProxyManagerBridge] fix PHP notice, switch to "friendsofphp/proxy-manager-lts" (nicolas-grekas)
 * bug #39584 [Security] Add RememberMe Badge to LoginLinkAuthenticator (jderusse)
 * bug #39586 Supports empty path for slack DSN (odolbeau)

* 5.2.1 (2020-12-18)

 * bug #39555 [FrameworkBundle] Fix NFS detection on macOs (jderusse)
 * bug #39545 [Notifier] [Mattermost] Host is required (OskarStark)
 * bug #39548 [Notifier] [Infobip][Zulip] Host is required (OskarStark)
 * bug #39550 [HttpFoundation] keep turning dots to underscores when using Request::create() (nicolas-grekas)
 * bug #39538 [Notifier] Fix parsing Dsn with empty user/password (OskarStark)
 * bug #39531 [Mailer] Fix parsing Dsn with empty user/password (OskarStark)
 * bug #39492 [Notifier] [Discord] Use private const and mb_strlen() (OskarStark)
 * bug #39522 [Notifier] Set message id on SentMessage (OskarStark)
 * bug #39532 [Notifier] Fix toString when optional parameter is not set (OskarStark)
 * bug #39518 [Ldap] Incorrect determination of RelativeDistinguishedName for the "move" operation (astepin)
 * bug #39525 [VarDumper] dont hide any nodes until JS is proven to work (nicolas-grekas)
 * bug #39498 [DoctrineBridge] Guess correct form types for DATE_IMMUTABLE and DATETIME_IMMUTABLE (guillaume-sainthillier)
 * bug #39510 [Notifier]  [Free Mobile] Could not use custom host in DSN (OskarStark)
 * bug #39515 [Notifier] Fix wrong package name (OskarStark)
 * bug #39514 [Notifier] Fix wrong package names (OskarStark)
 * bug #39502 Add missing symfony/deprecation-contracts requirement - 5.2 (jderusse)
 * bug #39494 Add missing symfony/deprecation-contracts requirement (jderusse)
 * bug #39360 [FrameworkBundler] Fix cache:clear with buildDir (jderusse)
 * bug #39476 [Lock] Prevent store exception break combined store (dzubchik)
 * bug #39478 [FrameworkBundle] Fix missing kernel.build_dir on cache clear (chalasr)
 * bug #39456 [Notifier] [Free Mobile] Fix wrong scheme in mapping (OskarStark)
 * bug #39442 Fix enabled key for ratelimiter config (pierredup)
 * bug #39299 [PropertyInfo][Serializer] Fixed extracting ignored properties for Serializer (javer)
 * bug #39433 [Cache] fix setting "read_timeout" when using Redis (nicolas-grekas)
 * bug #39228 [HttpClient] Fix content swallowed by AsyncClient initializer (jderusse)
 * bug #39420 [Cache] Prevent notice on case matching metadata trick (bastnic)
 * bug #39413 [Notifier] [Discord] Make webhookId argument required (OskarStark)
 * bug #39203 [DI] Fix not working if only "default_index_method" used (malteschlueter)
 * bug #39409 [Notifier] [Twilio] Add tests (OskarStark)
 * bug #39401 [DoctrineBridge] no-op RegisterUidTypePass if DBAL types aren't loaded (craue)
 * bug #39417 [Form] Fix UUID exception (jderusse)
 * bug #39142 [Config] Stop treating multiline resources as globs (michaelKaefer)
 * bug #39341 [Form] Fixed StringUtil::trim() to trim ZERO WIDTH SPACE (U+200B) and SOFT HYPHEN (U+00AD) (pmishev)
 * bug #39268 [HttpClient] Use decoration instead of class replacement for mock factory (GaryPEGEOT)
 * bug #39334 [Config][TwigBundle] Fixed syntax error in config (Nyholm)
 * bug #39196 [DI] Fix Xdebug 3.0 detection (vertexvaar)
 * bug #39375 [SecurityBundle] fix LDAP-based HTTP Basic Auth entry point registration (xabbuh)
 * bug #39226 [PhpUnitBridge] Fix disabling DeprecationErrorHandler from PHPUnit configuration file (fancyweb)
 * bug #39298 [Cache] Fixed incorrect usage of UNLINK with PHPRedis with Redis < 4.0 (wickex)
 * bug #39361 [FrameworkBundle] acces public-deprecated services via the private container to remove false-positive deprecations (nicolas-grekas)
 * bug #39358 [HttpFoundation] fix parsing some special chars with HeaderUtils::parseQuery() (nicolas-grekas)
 * bug #39357 [FrameworkBundle] fix preserving some special chars in the query string (nicolas-grekas)
 * bug #39310 [Notifier] Add exception for deprecated slack dsn (malteschlueter)
 * bug #39271 [HttpFoundation] Fix TypeError: Argument 1 passed to JsonResponse::setJson() must be of the type string, object given (sidz)
 * bug #39251 [DependencyInjection] Fix container linter for union types (derrabus)
 * bug #39336 [Config] YamlReferenceDumper: No default value required for VariableNode with array example (Nyholm)
 * bug #39333 [Form] do not apply the Valid constraint on scalar form data (lchrusciel, xabbuh)
 * bug #39331 [PhpUnitBridge] Fixed PHPunit 9.5 compatibility (wouterj)
 * bug #39220 [HttpKernel] Fix bug with whitespace in Kernel::stripComments() (ausi)
 * bug #39252 [Mime] Leverage PHP 8's detection of CSV files (derrabus)
 * bug #39313 [FrameworkBundle] TextDescriptor::formatControllerLink checked method… (fjogeleit)
 * bug #39286 [HttpClient] throw clearer error when no scheme is provided (BackEndTea)
 * bug #39267 [Yaml] fix lexing backslashes in single quoted strings (xabbuh)
 * bug #39151 [DependencyInjection] Fixed incorrect report for private services if required service does not exist (Islam93)
 * bug #39236 [Notifier] Fix slack section block (norkunas)
 * bug #39274 [Yaml] fix lexing mapping values with trailing whitespaces (xabbuh)
 * bug #39256 [Workflow] Fixed case when the marking store is not defined (lyrixx)
 * bug #39244 [String] Fix Notice when argument is empty string (moldman)
 * bug #39270 [Inflector] Fix Notice when argument is empty string (moldman)
 * bug #39263 [Security] more defensive PasswordMigratingListener (romaricdrigon)
 * bug #39261 [Security] fix #39249, default entry_point compiler pass was returning too early (romaricdrigon)
 * bug #39247 [Security] remove return type definition in order to avoid type juggling (adeptofvoltron)
 * bug #39223 [Console] Re-enable hyperlinks in Konsole/Yakuake (OndraM)
 * bug #39241 [Yaml] fix lexing inline sequences/mappings with trailing whitespaces (Nyholm, xabbuh)
 * bug #39243 [Filesystem] File existence check before calling unlink method (gechetspr)

* 5.2.0 (2020-11-30)

 * feature #39213 [Security] [DX] Automatically add PasswordUpgradeBadge + default support() impl in AbstractFormLoginAuthenticator (wouterj)
 * bug #39166 [Messenger] Fix mssql compatibility for doctrine transport. (bill moll)
 * bug #39210 [DoctrineBridge] Fix form EntityType with filter on UID (jderusse)
 * bug #39211 [HttpClient] fix binding to network interfaces (nicolas-grekas)
 * bug #39129 [DependencyInjection] Fix circular in DI with lazy + byContruct loop (jderusse)
 * feature #39153 [Security] Automatically register custom authenticator as entry_point (if supported) (wouterj)
 * bug #39068 [DependencyInjection][Translator] Silent deprecation triggered by libxml_disable_entity_loader (jderusse)
 * bug #39119 [Form] prevent duplicated error message for file upload limits (xabbuh)
 * bug #39099 [Form] ignore the pattern attribute for textareas (xabbuh)
 * feature #39118 [DoctrineBridge] Require doctrine/persistence 2 (greg0ire)
 * feature #39128 [HttpFoundation] Deprecate BinaryFileResponse::create() (derrabus)
 * bug #39154 [Yaml] fix lexing strings containing escaped quotation characters (xabbuh)
 * bug #39187 [Security] Support for SwitchUserToken instances serialized with 4.4/5.1 (derrabus)
 * bug #39180 [Serializer] Fix denormalizing scalar with UnwrappingDenormalizer (camilledejoye)
 * bug #38597 [PhpUnitBridge] Fix qualification of deprecations triggered by the debug class loader (fancyweb)
 * bug #39160 [Console] Use a partial buffer in SymfonyStyle (jderusse)
 * bug #39168 [Console] Fix console closing tag (jderusse)
 * bug #39155 [VarDumper] fix casting resources turned into objects on PHP 8 (nicolas-grekas)
 * bug #39131 [Cache] Fix CI because of Couchbase version (jderusse)
 * bug #39115 [HttpClient] don't fallback to HTTP/1.1 when HTTP/2 streams break (nicolas-grekas)
 * bug #33763 [Yaml] fix lexing nested sequences/mappings (xabbuh)

* 5.2.0-RC2 (2020-11-21)

 * bug #39113 [DoctrineBridge] drop binary variants of UID types (nicolas-grekas)
 * feature #39111 [Security] Update password upgrader listener to work with the new UserBadge (wouterj)
 * bug #39083 [Dotenv] Check if method inheritEnvironmentVariables exists (Chi-teck)
 * bug #39094 [Ldap] Fix undefined variable $con (derrabus)
 * bug #39091 [Config] Recheck glob brace support after GlobResource was serialized (wouterj)
 * bug #39092 Fix critical extension when reseting paged control (jderusse)
 * bug #38614 [HttpFoundation] Fix for virtualhosts based on URL path (mvorisek)
 * bug #39072 [FrameworkBundle] [Notifier] fix firebase transport factory DI tag type (xabbuh)
 * bug #39070 [Validator] Remove IsinValidator's validator dependency (derrabus)
 * bug #38387 [Validator] prevent hash collisions caused by reused object hashes (fancyweb, xabbuh)
 * bug #38999 [DependencyInjection] autoconfigure behavior describing tags on decorators (xabbuh)
 * bug #39058 [DependencyInjection] Fix circular detection with multiple paths (jderusse)
 * bug #39059 [Filesystem] fix cleaning up tmp files when dumpFile() fails (nicolas-grekas)

* 5.2.0-RC1 (2020-11-10)

 * bug #39004 [Messenger] Fix JSON deserialization of ErrorDetailsStamp and normalization of FlattenException::$statusText (Jean85)
 * bug #38628 [DoctrineBridge]  indexBy could reference to association columns (juanmiguelbesada)
 * bug #39021  [DependencyInjection] Optimize circular collection by removing flattening (jderusse)
 * bug #39031 [Ldap] Fix pagination (jderusse)
 * bug #39038 [DoctrineBridge]    also reset id readers (xabbuh)
 * feature #39032 [Validator] Allow load mappings from attributes without doctrine/annotations (derrabus)
 * feature #39022  [FrameworkBundle] Allow to use attribute-based configuration of routing/serializer without doctrine/annotations (derrabus)
 * bug #39002 [Validator] Override the default option of the choice constraint (benji07)
 * bug #39026 [Messenger] Fix DBAL deprecations in PostgreSqlConnection (chalasr)
 * bug #39025 [DoctrineBridge] Fix DBAL deprecations in middlewares (derrabus)
 * bug #38991 [Console] Fix ANSI when stdErr is not a tty (jderusse)
 * bug #38980 [DependencyInjection] Fix circular reference with Factory + Lazy Iterrator (jderusse)
 * bug #38986 [DoctrineBridge] accept converting Uid-as-strings to db-values (nicolas-grekas)
 * feature #38850 [Messenger] Do not call getQueueUrl when the url is known in AmazonSqs transport (jderusse)
 * feature #38940 [Messenger] Improve formatting of exception in failed message (Jeroen Noten)
 * feature #38954 [HttpFundation][FrameworkBundle] Deprecate the HEADER_X_FORWARDED_ALL constant (jderusse)
 * bug #38977 [HttpClient] Check status code before decoding content in TraceableResponse (chalasr)
 * bug #38971 [PhpUnitBridge] fix replaying skipped tests (nicolas-grekas)
 * bug #38910 [HttpKernel] Fix session initialized several times (jderusse)
 * bug #38882 [DependencyInjection] Improve performances in CircualReference detection (jderusse)
 * bug #38950 [Process] Dont test TTY if there is no TTY support (Nyholm)
 * bug #38921 [PHPUnitBridge] Fixed crash on Windows with PHP 8 (villfa)
 * feature #38919 [Console] Make error message more verbose (Nyholm)
 * bug #38869 [SecurityBundle] inject only compatible token storage implementations for usage tracking (xabbuh)
 * feature #38859 [HttpFoundation] Deprecate not passing a `Closure` together with `FILTER_CALLBACK` to `ParameterBag::filter()` (nicolas-grekas)
 * bug #38894 [HttpKernel] Remove Symfony 3 compatibility code (derrabus)
 * bug #38888 remove reflection-docblock from mime requirements (garak)
 * bug #38895 [PhpUnitBridge] Fix wrong check for exporter in ConstraintTrait (alcaeus)
 * bug #38879 [Cache] Fixed expiry could be int in ChainAdapter due to race conditions (phamviet)
 * bug #38867 [FrameworkBundle] Fixing TranslationUpdateCommand failure when using "--no-backup" (liarco)
 * bug #38856 [Cache] Add missing use statement (fabpot)

* 5.2.0-BETA3 (2020-10-28)

 * bug #38845 [Console] Register signal handling only for commands implemeting SignalableCommandInterface (lyrixx)
 * bug #38751 [Security] Move AbstractListener abstract methods to the new FirewallListenerInterface (chalasr)
 * bug #38713 [DI] Fix Preloader exception when preloading a class with an unknown parent/interface (rgeraads)
 * feature #38664 [RateLimiter] Moved classes implementing LimiterInterface to a new namespace (Nyholm)
 * bug #38647 [HttpClient] relax auth bearer format requirements (xabbuh)
 * bug #38675 [RateLimiter] Rename RateLimiter to RateLimiterFactory (Nyholm)
 * bug #38699 [DependencyInjection] Preload classes with union types correctly (derrabus)
 * feature #38688 [HttpClient] Add a Stopwatch on TraceableHttpClient (jderusse)
 * bug #38669 [Serializer] fix decoding float XML attributes starting with 0 (Marcin Kruk)
 * bug #38680 [PhpUnitBridge] Support new expect methods in test case polyfill (alcaeus)
 * bug #38681 [PHPUnitBridge] Support PHPUnit 8 and PHPUnit 9 in constraint compatibility trait (alcaeus)
 * bug #38686 [TwigBridge] Remove "transchoice" from the code base (nicolas-grekas)
 * bug #38661 [RateLimiter] Fix delete method of the cache storage (GregOriol, Nyholm)
 * bug #38678 [String] fix before/after[Last]() returning the empty string instead of the original one on non-match (nicolas-grekas)
 * bug #38682 [HttpClient] never trace content of event-stream responses (nicolas-grekas)
 * bug #38679 [PhpUnitBridge] Add missing exporter function for PHPUnit 7 (alcaeus)
 * bug #38674 [RateLimiter] Make sure we actually can use sliding_window and no_limit (Nyholm)
 * bug #38670 [RateLimiter] Be more type safe when fetching from cache (Nyholm)
 * bug #38665 [RateLimiter] Allow configuration value "no_limit" (Nyholm)
 * bug #38659 [String] fix slicing in UnicodeString (nicolas-grekas)
 * bug #38633 [HttpClient] Fix decorating progress info in AsyncResponse (jderusse)
 * feature #38543 [HttpKernel] add `kernel.runtime_environment` = `env(default:kernel.environment:APP_RUNTIME_ENV)` parameter (nicolas-grekas)
 * bug #38595 [TwigBridge] do not translate null placeholders or titles (xabbuh)
 * feature #38653 [DoctrineBridge] Enabled to use the UniqueEntity constraint as an attribute (derrabus)
 * bug #38635 [Cache] Use correct expiry in ChainAdapter (Nyholm)
 * bug #38652 [Filesystem] Check if failed unlink was caused by permission denied (Nyholm)
 * bug #38645 [PropertyAccess] forward the caught exception (xabbuh)
 * bug #38644 [FrameworkBundle] remove transport factory service when class does not exist (xabbuh)
 * feature #38426 [HttpClient] Parameterize list of retryable methods (jderusse)
 * feature #38608 [RateLimiter] rename Limit to RateLimit and add RateLimit::getLimit() (kbond)
 * bug #38617 [Form] Add missing invalid_message translations (wouterj)
 * bug #38612 [Messenger/Amqp] Allow setting option "login" in DSN (W0rma)
 * bug #38618 [Messenger][Doctrine] Avoid early db access for pgsql detection (chalasr)
 * bug #38623 [HttpFoundation][RateLimiter] fix RequestRateLimiterInterface::reset() (kbond)
 * bug #38604 [DoctrineBridge] indexBy does not refer to attributes, but to column names (xabbuh)
 * bug #38605 [DoctrinBridge] make Uid types stricter (nicolas-grekas)
 * bug #38606 [WebProfilerBundle] Hide debug toolbar in print view (jt2k)
 * bug #38602 [Console] Fix signal management  (chalasr)
 * bug #38600 [DoctrineBridge] Convert values to Rfc4122 before inserting them into the database (Kai)
 * feature #38562 [RateLimiter] Added reserve() to LimiterInterface and rename Limiter to RateLimiter (wouterj)
 * feature #38593 [Lock][Semaphore] Add Factory::createFromKey and deprecate lock.store services (jderusse)
 * feature #38587 [HttpClient] added `extra.trace_content` option to `TraceableHttpClient` to prevent it from keeping the content in memory (nicolas-grekas)
 * bug #38580 [FrameworkBundle] fix config declaration of http_cache option (nicolas-grekas)
 * bug #38589 [Console] Don't register signal handlers if pcntl is disabled (chalasr)
 * bug #38581 [Semaphore] Reset Key lifetime time before we acquire it (jderusse)
 * bug #38582 [DI] Fix Reflection file name with eval()\'d code (maxime-aknin)
 * feature #38565 [RateLimiter] Adding SlidingWindow algorithm (Nyholm)
 * feature #38576 Deeprecate lock service (jderusse)
 * bug #38578 Add missing use statement (jderusse)
 * bug #38516 [HttpFoundation] Fix Range Requests (BattleRattle)

* 5.2.0-BETA2 (2020-10-14)

 * feature #38552 [Security][Notifier] Added integration of Login Link with the Notifier component (wouterj)
 * bug #38566 Fix minor issue when sharing windows between Limiters (Nyholm)
 * feature #38563 [Messenger][Redis] Adding support for lazy connect (Nyholm)
 * bug #38553 [Lock] Reset Key lifetime time before we acquire it (Nyholm)
 * bug #38559 [Lock] Reset lifetime on acquireRead() (Nyholm)
 * bug #38548 [FrameworkBundle] Bugfixes in buildDir in the CacheClear command (Nyholm)
 * bug #38551 Remove content-type check on toArray methods (jderusse)
 * feature #38550 [Security] Added check_post_only to the login link authenticator (wouterj)
 * bug #38546 [String] fix "is too large" ValueError on PHP 8 (nicolas-grekas)
 * bug #38544 [DI] fix dumping env vars (nicolas-grekas)
 * feature #38532 [HttpClient] simplify retry mechanism around RetryStrategyInterface (nicolas-grekas)
 * bug #38533 [TwigBridge] Fix preload hint and remove "unlinked class class@anonymous" warning (burned42)
 * bug #38528 [Security] Making login link signature_properties option required (weaverryan)
 * feature #38525 [Serializer] Enabled mapping configuration via attributes (derrabus)
 * feature #38522 [Notifier ] Add Discord notifier (mpiot, connorhu)
 * bug #38477 [Form] fix ViolationMapper was always generating a localized label for each FormType (romaricdrigon)
 * bug #38529 [Mailer] Fix mailjet image embedding (Sandldan)
 * bug #38530 [HttpClient] fix reading the body after a ClientException (nicolas-grekas)
 * bug #38523 [HttpClient] Fix multiple timeout with multiple retry (jderusse)
 * bug #38520 [HttpClient] Fix nesteed stream in AsyncResponse (jderusse)
 * bug #38518 [HttpClient] fix decorating timeout errors (nicolas-grekas)
 * feature #38499 [Validator] Upgraded constraints to enable named arguments and attributes (derrabus)
 * feature #38505 [Security][Login Link] Allow null and DateTime objects to be used as signatureProperties (wouterj)
 * bug #38507 [Bug] Fix RateLimiter framework configuration (bobvandevijver)
 * bug #38510 [PropertyInfo] Support for the mixed type (derrabus)
 * bug #38493 [HttpClient] Fix CurlHttpClient memory leak (HypeMC)
 * feature #38484 [Messenger] Add DelayStamp::delayFor() and DelayStamp::delayUntil() (Nyholm)
 * bug #38476 [HttpClient] Fix missing abstract arg (jderusse)
 * feature #37733 [PhpUnitBridge] Add ability to set a baseline for deprecation testing (alexpott)
 * bug #38456 [Cache] skip igbinary < 3.1.6 (nicolas-grekas)
 * bug #38453 [lock] Mark Key unserializable whith PgsqlStore (jderusse)
 * bug #38452 [SecurityBundle] Make user lazy loading working without user provider (tyx)
 * bug #38455 [Form] Fix field_value Twig helper for multiple choices (tgalopin)
 * bug #38392 [Ldap] Bypass the use of `ldap_control_paged_result` on PHP >= 7.3 (lucasaba)
 * feature #38434 [HttpClient] Add jitter to RetryBackoff (jderusse)
 * feature #38346 [lock] Add store dedicated to postgresql (jderusse)
 * bug #38444 [PhpUnitBridge] fix running parallel tests with phpunit 9 (nicolas-grekas)
 * bug #38446 [PropertyInfo] Extract from default value doesn't set collection boolean (Korbeil)
 * feature #38424 [Translation] Rename Translatable class to TranslatableMessage (natewiebe13)
 * bug #38442 [VarDumper] fix truncating big arrays (nicolas-grekas)
 * bug #38433 [Mime] Fix serialization of RawMessage (gilbertsoft)
 * bug #38422 [SecurityGuard] Implement PostAuthenticationGuardToken::getFirewallName() (derrabus)
 * feature #38393 [FrameworkBundle] Add option --as-tree to translation:update command (jschaedl)
 * bug #38419 [DoctrineBridge] fix and replace namespace to Uid (maxhelias)
 * feature #38410 [Validator] Migrate File and Image constraints to attributes (derrabus)
 * bug #38418 [HttpClient] minor fixes in RetryableHttpClient (nicolas-grekas)
 * feature #38253 [Cache] Allow ISO 8601 time intervals to specify default lifetime (lstrojny)

* 5.2.0-BETA1 (2020-10-05)

 * feature #38382 [Validator] Use comparison constraints as attributes (derrabus)
 * feature #38369 [HttpFoundation] Expired cookies string representation consistency & tests (iquito)
 * feature #38407 [Mime] Prefer .jpg instead of .jpeg (fabpot)
 * feature #36479 [Notifier][WebProfilerBundle][FrameworkBundle] Add notifier section to profiler (jschaedl)
 * feature #38395 [lock] Prevent user serializing the key when store does not support it. (jderusse)
 * feature #38307 [Form] Implement Twig helpers to get field variables (tgalopin)
 * feature #38177 [Security] Magic login link authentication (weaverryan)
 * feature #38224 [HttpFoundation] Add Request::toArray() for JSON content (Nyholm)
 * feature #38323 [Mime] Allow multiple parts with the same name in FormDataPart (HypeMC)
 * feature #38354 [RateLimiter] add Limit::ensureAccepted() which throws RateLimitExceededException if not accepted (kbond)
 * feature #32904 [Messenger] Added ErrorDetailsStamp (TimoBakx)
 * feature #36152 [Messenger] dispatch event when a message is retried (nikophil)
 * feature #38361 Can define ChatMessage transport to null (odolbeau)
 * feature #38289 [HttpClient] provide response body to the RetryDecider (jderusse)
 * feature #38308 [Security][RateLimiter] Added request rate limiter to prevent breadth-first attacks (wouterj)
 * feature #38257 [RateLimiter] Add limit object on RateLimiter consume method (Valentin, vasilvestre)
 * feature #38309 [Validator] Constraints as php 8 Attributes (derrabus)
 * feature #38332 [Validator] Add support for UUIDv6 in Uuid constraint (nicolas-grekas)
 * feature #38330 [Contracts] add TranslatableInterface (nicolas-grekas)
 * feature #38322 [Validator] Add Ulid constraint and validator (Laurent Clouet)
 * feature #38333 [Uid] make UUIDv6 always return truly random nodes to prevent leaking the MAC of the host (nicolas-grekas)
 * feature #38296 [lock] Provides default implementation when store does not supports the behavior (jderusse)
 * feature #38298 [Notifier] Add Sendinblue notifier. (ptondereau)
 * feature #38305 [PhpUnitBridge] Enable a maximum PHPUnit version to be set via SYMFONY_MAX_PHPUNIT_VERSION (stevegrunwell)
 * feature #38288 [DomCrawler] Add `assertFormValue()` in `WebTestCase` (mnapoli)
 * feature #38287 [DomCrawler] Add checkbox assertions for functional tests (mnapoli)
 * feature #36326 [Validator] Add invalid datetime message in Range validator (przemyslaw-bogusz)
 * feature #38243 [HttpKernel] Auto-register kernel as an extension (HypeMC)
 * feature #38277 [Mailer] Added Sendinblue bridge (drixs6o9)
 * feature #35956 [Form] Added "html5" option to both MoneyType and PercentType (romaricdrigon)
 * feature #38269 [String] allow passing null to string functions (kbond)
 * feature #38176 [Config] Adding the "info" to a missing option error messages (weaverryan)
 * feature #38167 [VarDumper] Support for ReflectionAttribute (derrabus)
 * feature #35740 [MonologBridge] Use composition instead of inheritance in monolog bridge (pvgnd, mm-pvgnd)
 * feature #38182 [HttpClient] Added RetryHttpClient (jderusse)
 * feature #38204 [Security] Added login throttling feature (wouterj)
 * feature #38007 [Amqp] Add amqps support (vasilvestre-OS)
 * feature #37546 [RFC] Introduce a RateLimiter component (wouterj)
 * feature #38193 Make RetryTillSaveStore implements the SharedLockStoreInterface (jderusse)
 * feature #37968 [Form] Add new way of mapping data using callback functions (yceruto)
 * feature #38198 [String] allow translit rules to be given as closure (nicolas-grekas)
 * feature #37829 [RFC][HttpKernel][Security] Allowed adding attributes on controller arguments that will be passed to argument resolvers. (jvasseur)
 * feature #37752 [RFC][lock] Introduce Shared Lock (or Read/Write Lock) (jderusse)
 * feature #37759 [Messenger] - Add option to confirm message delivery in Amqp connection (scyzoryck)
 * feature #30572 [Cache] add integration with Messenger to allow computing cached values in a worker (nicolas-grekas)
 * feature #38149 [SecurityBundle] Comma separated ips for security.access_control (a-menshchikov)
 * feature #38151 [Serializer] add UidNormalizer (guillbdx, norkunas)
 * feature #37976 [Messenger] Don't prevent dispatch out of another bus (ogizanagi)
 * feature #38134 [Lock] Fix wrong interface for MongoDbStore (jderusse)
 * feature #38135 [AmazonSqsMessenger] Added the count message awareness on the transport (raphahardt)
 * feature #38026 [HttpClient] Allow to provide additional curl options  to CurlHttpClient (pizzaminded)
 * feature #37559 [PropertyInfo] fix array types with keys (array<string, string>) (digilist)
 * feature #37519 [Process] allow setting options esp. "create_new_console" to detach a subprocess (andrei0x309)
 * feature #37704 [MonologBridge] Added SwitchUserTokenProcessor to log the impersonator (IgorTimoshenko)
 * feature #37545 [DependencyInjection] Add the Required attribute (derrabus)
 * feature #37474 [RFC][Routing] Added the Route attribute (derrabus)
 * feature #38068 [Notifier] Register NotificationDataCollector and NotificationLoggerListener service (jschaedl)
 * feature #32841 Create impersonation_exit_path() and *_url() functions (dFayet)
 * feature #37706 [Validator] Debug validator command (loic425, fabpot)
 * feature #38052 Increase HttpBrowser::getHeaders() visibility to protected (iansltx)
 * feature #36727 [Messenger] Add option to prevent Redis from deleting messages on rejection (Steveb-p)
 * feature #37678 [DoctrineBridge] Ulid and Uuid as Doctrine Types (gennadigennadigennadi)
 * feature #38037 Translate failure messages of json authentication (Malte Schlüter)
 * feature #35890 [Cache] give control over cache prefix seed (Tobion)
 * feature #37337 [Security] Configurable execution order for firewall listeners (scheb)
 * feature #33850 [Serializer] fix denormalization of basic property-types in XML and CSV (mkrauser)
 * feature #38017 [PHPUnitBridge] deprecations not disabled anymore when disabled=0 (l-vo)
 * feature #33381 [Form] dispatch submit events for disabled forms too (xabbuh)
 * feature #35338 Added support for using the "{{ label }}" placeholder in constraint messages (a-menshchikov)
 * feature #34790 [Console] Remove restriction for choices to be strings (LordZardeck, YaFou, ogizanagi)
 * feature #37979 [Workflow] Expose the Metadata Store in the DIC (lyrixx)
 * feature #37371 [Translation] Add support for calling 'trans' with ICU formatted messages (someonewithpc)
 * feature #37670 [Translation] Translatable objects (natewiebe13)
 * feature #37432 [Mailer] Implement additional mailer transport options (fritzmg)
 * feature #35893 [HttpClient][DI] Add an option to use the MockClient in functional tests (GaryPEGEOT)
 * feature #35780 [Semaphore] Added the component (lyrixx)
 * feature #37846 [Security] Lazily load the user during the check passport event (wouterj)
 * feature #37934 [Mailer] Mailjet Add ability to pass custom headers to API (tcheymol)
 * feature #37942 [Security] Renamed provider key to firewall name (wouterj)
 * feature #37951 [FrameworkBundle] Make AbstractPhpFileCacheWarmer public (ossinkine)
 * feature #30335 [PropertyInfo] ConstructorExtractor which has higher priority than PhpDocExtractor and ReflectionExtractor (karser)
 * feature #37926 [lock] Lazy create table in lock PDO store (jderusse)
 * feature #36573 [Notifier] Add Esendex bridge (odolbeau)
 * feature #33540 [Serializer] Add special '*' serialization group that allows any group (nrobinaubertin)
 * feature #37708 Allow Drupal to wrap the Symfony test listener (alexpott)
 * feature #36211 [Serializer] Adds FormErrorNormalizer (YaFou)
 * feature #37087 [Messenger] Add FlattenException Normalizer (monteiro)
 * feature #37917 [Security] Pass Passport to LoginFailureEvent (ihmels)
 * feature #37734 [HttpFoundation] add support for X_FORWARDED_PREFIX header (jeff1985)
 * feature #37897 [Mailer] Support Amazon SES ConfigurationSetName (cvmiert)
 * feature #37915 Improve link script with rollback when using symlink (noniagriconomie)
 * feature #37889 Toolbar toggler accessibility (Chi-teck)
 * feature #36515 [HttpKernel] Add `$kernel->getBuildDir()` to separate it from the cache directory (mnapoli)
 * feature #32133 [PropertyAccess] Allow to disable magic __get & __set (ogizanagi)
 * feature #36016 [Translation] Add a pseudo localization translator (fancyweb)
 * feature #37755 Fix #37740: Cast all Request parameter values to string (rgeraads)
 * feature #36541 ✨ [Mailer] Add Mailjet bridge (tcheymol)
 * feature #36940 [Notifier] add support for smsapi-notifier (szepczynski)
 * feature #37830 [Notifier] Add LinkedIn provider (ismail1432)
 * feature #37867 [Messenger] Add message timestamp to amqp connection (Bartłomiej Zając)
 * feature #36925 [Security] Verifying if the password field is null (Mbechezi Nawo)
 * feature #37847 [Serializer][Mime] Fix Mime message serialization (fabpot)
 * feature #37338 [Console] added TableCellStyle (khoptynskyi)
 * feature #37840 [VarDumper] Support PHPUnit --colors option (ogizanagi)
 * feature #37138 [Notifier][Slack] Use Slack Web API chat.postMessage instead of WebHooks (xavierbriand)
 * feature #37827 [Console] Rework the signal integration (lyrixx)
 * feature #36131 [Mailer] Add a transport that uses php.ini settings for configuration (l-vo)
 * feature #36596 Add cache.adapter.redis_tag_aware to use RedisCacheAwareAdapter (l-vo)
 * feature #36582 [Messenger] Add Beanstalkd bridge (X-Coder264)
 * feature #35967 [VarDumper] Add VAR_DUMPER_FORMAT=server format (ogizanagi)
 * feature #37815 [Workflow] Choose which Workflow events should be dispatched (stewartmalik, lyrixx)
 * feature #20054 [Console] Different approach on merging application definition (ro0NL)
 * feature #36648 [Notifier] Add Mobyt bridge (Deamon)
 * feature #37332 [FrameworkBundle] Allow to leverage autoconfiguration for DataCollectors with template (l-vo)
 * feature #37359 [Security] Add event to inspect authenticated token before it becomes effective (scheb)
 * feature #37539 [Workflow] Added Context to Workflow Event (epitre)
 * feature #37683 [Console] allow multiline responses to console questions (ramsey)
 * feature #29117 [Serializer] Add CompiledClassMetadataFactory (fbourigault)
 * feature #37676 [Stopwatch] Add name property to the stopwatchEvent (AhmedRaafat14)
 * feature #34704 [Messenger] Add method HandlerFailedException::getNestedExceptionOfClass (tyx)
 * feature #37793 Revert "[DependencyInjection] Resolve parameters in tag arguments" (rpkamp)
 * feature #37537 [HttpKernel] Provide status code in fragment handler exception (gonzalovilaseca)
 * feature #36480 [Notifier] Add Infobip bridge (jeremyFreeAgent)
 * feature #36496 [Notifier] added telegram options (krasilnikovm)
 * feature #37754 [FrameworkBundle] Add days before expiration in "about" command (noniagriconomie)
 * feature #35773 [Notifier] Change notifier recipient handling (jschaedl)
 * feature #36488 [Notifier] Add Google Chat bridge (GromNaN)
 * feature #36692 [HttpClient] add EventSourceHttpClient to consume Server-Sent Events (soyuka)
 * feature #36616 [Notifier] Add Zulip notifier bridge (phpfour)
 * feature #37747 [Notifier] Make Freemobile config more flexible (fabpot)
 * feature #37718 [Security] class Security implements AuthorizationCheckerInterface (SimonHeimberg)
 * feature #37732 [Console] Allow testing single command apps using CommandTester (chalasr)
 * feature #37480 [Messenger] add redeliveredAt in RedeliveryStamp construct (qkdreyer)
 * feature #37565 [Validator] Add Isin validator constraint (lmasforne)
 * feature #37712 [Mailer] Prevent MessageLoggerListener from leaking in env=prod (vudaltsov)
 * feature #33729 [Console] Add signal event (marie)
 * feature #36352 [Validator] Added support for cascade validation on typed properties (HeahDude)
 * feature #37243 [DependencyInjection] Resolve parameters in tag arguments (rpkamp)
 * feature #37415 [Console] added info method to symfony style (titospeakap, titomiguelcosta)
 * feature #36691 [FrameworkBundle] Deprecate some public services to private (fancyweb)
 * feature #36929 Added a FrenchInflector for the String component (Alexandre-T)
 * feature #37620 [Security] Use NullToken while checking authorization (wouterj)
 * feature #37711 [Router] allow to use \A and \z as regex start and end (zlodes)
 * feature #37703 Update StopwatchPeriod.php (ThomasLandauer)
 * feature #37696 [Routing] Allow inline definition of requirements and defaults for host (julienfalque)
 * feature #37567 [PhpUnitBridge] Polyfill new phpunit 9.1 assertions (phpfour)
 * feature #37479 [HttpFoundation] Added File::getContent() (lyrixx)
 * feature #36178 [Mime] allow non-ASCII characters in local part of email (dmaicher)
 * feature #30931 [Form] Improve invalid messages for form types (hiddewie)
 * feature #37492 [ErrorHandler] Allow override of the default non-debug template (PhilETaylor)
 * feature #37482 [HttpClient] always yield a LastChunk in AsyncResponse on destruction (nicolas-grekas)
 * feature #36364 [HttpKernel][WebProfilerBundle] Add session profiling (mtarld)
 * feature #37428 [Workflow] Added Function (and Twig extension) to retrieve a specific transition (Carlos Pereira De Amorim)
 * feature #36487 [HttpClient] Add MockResponse::getRequestMethod() and getRequestUrl() to allow inspecting which request has been sent (javespi)
 * feature #37295 Move event alias mappings to their components (derrabus)
 * feature #37443 [HttpClient] add StreamableInterface to ease turning responses into PHP streams (nicolas-grekas)
 * feature #36739 [TwigBundle] Deprecate the public "twig" service to private (fancyweb)
 * feature #37272 [HttpFoundation] add `HeaderUtils::parseQuery()`: it does the same as `parse_str()` but preserves dots in variable names (nicolas-grekas)
 * feature #37403 [Notifier] Return SentMessage from the Notifier message handler (fabpot)
 * feature #36611 Add Notifier SentMessage (jeremyFreeAgent)
 * feature #37357 [FrameworkBundle] allow configuring trusted proxies using semantic configuration (nicolas-grekas)
 * feature #37373 [DI] deprecate Definition/Alias::setPrivate() (nicolas-grekas)
 * feature #37351 [FrameworkBundle] allow enabling the HTTP cache using semantic configuration (nicolas-grekas)
 * feature #37306 [Messenger] added support for Amazon SQS QueueUrl as DSN (starred-gijs)
 * feature #37336 [Security] Let security factories add firewall listeners (scheb)
 * feature #37318 [Security] Add attributes on Passport (fabpot)
 * feature #37241 [Console] Fix Docblock for CommandTester::getExitCode (Jean85)
 * feature #35834 [Notifier] Remove default transport property in Transports class (jschaedl)
 * feature #37198 [FrameworkBundle] Add support for tagged_iterator/tagged_locator in unused tags util (fabpot)
 * feature #37165 [Mime] Add DKIM support (fabpot)
 * feature #36778 Use PHP instead of XML as the prefered service/route configuration in core (fabpot)
 * feature #36802 [Console] Add support for true colors (fabpot)
 * feature #36775 [DependencyInjection] Add abstract_arg() and param() (fabpot)
 * feature #37040 [PropertyInfo] Support using the SerializerExtractor with no group check (GuilhemN)
 * feature #37175 [Mime] Deprecate Address::fromString() (fabpot)
 * feature #37114 Provides a way to override cache and log folders from the ENV (Plopix)
 * feature #36736 [FrameworkBundle][Mailer] Add a way to configure some email headers from semantic configuration (fabpot)
 * feature #37136 [HttpClient] added support for pausing responses with a new `pause_handler` callable exposed as an info item (nicolas-grekas)
 * feature #36779 [HttpClient] add AsyncDecoratorTrait to ease processing responses without breaking async (nicolas-grekas)
 * feature #36790 Bump Doctrine DBAL to 2.10+ (fabpot)
 * feature #36818 [Validator] deprecate the "allowEmptyString" option (xabbuh)

