CHANGELOG for 5.3.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 5.3 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v5.3.0...v5.3.1

* 5.3.1 (2021-06-02)

 * bug #41463 [Serializer][Validator] Fix not null return from "getCollectionValueTypes" (jderusse)
 * bug #41493 [Security] Readd deprecated methods to the interfaces (wouterj)
 * bug #41495 [HttpFoundation] Add ReturnTypeWillChange to SessionHandlers (nikic)
 * bug #41485 [HttpKernel] fix ArgumentMetadataFactory messes up controller arguments with attributes (sgehrig)
 * bug #41461 Fix Symfony 5.3 end of maintenance date (jmsche)

* 5.3.0 (2021-05-31)

 * bug #41458 [FrameworkBundle] fix ConfigBuilderCacheWarmer (nicolas-grekas)
 * bug #41456 [FrameworkBundle] fix creating ContainerBuilder at warmup/CLI time (nicolas-grekas)
 * bug #41452 [FrameworkBundle] Remove redundant cache service (derrabus)
 * bug #41451 [Translation] Remove PoEditor Provider (welcoMattic)
 * bug #41000 [Form] Use !isset for checks cause this doesn't falsely include 0 (Kai Dederichs)
 * bug #41407 [DependencyInjection] keep container.service_subscriber tag on the decorated definition (xabbuh)
 * bug #40866 [Filesystem] fix readlink() for Windows (a1812)
 * bug #41402 [HttpKernel] Throw when HttpKernel is created and the env is empty (nicolas-grekas)
 * bug #41376 [SecurityBundle] Don't register deprecated listeners with authenticator manager enabled (chalasr)
 * bug #41394 [Form] fix support for years outside of the 32b range on x86 arch (nicolas-grekas)
 * bug #41380 Make Mailgun Header compatible with other Bridges (jderusse)
 * bug #39847 [Messenger] Fix merging PrototypedArrayNode associative values (svityashchuk)
 * bug #41367 [Ldap] Avoid calling the deprecated getUsername() (derrabus)
 * bug #41346 [WebProfilerBundle] Wrapping exception js in Sfjs check and also loading base_js Sfjs if needed (weaverryan)
 * bug #41344 [VarDumper] Don't pass null to parse_url() (derrabus)

* 5.3.0-RC1 (2021-05-19)

 * security #cve-2021-21424 [Security\Core] Fix user enumeration via response body on invalid credentials (chalasr)
 * bug #41275 Fixes Undefined method call (faizanakram99)
 * feature #41175 [Security] [RememberMe] Add support for parallel requests doing remember-me re-authentication (Seldaek)
 * bug #41269 [SecurityBundle] Remove invalid unused service (chalasr)
 * feature #41247 [Security] Deprecate the old authentication mechanisms (chalasr)
 * bug #41139 [Security] [DataCollector] Remove allows anonymous information in datacollector (ismail1432)
 * bug #41254 [Security\Http] Fix handling `secure: auto` using the new RememberMeAuthenticator (chalasr)
 * bug #41230 [FrameworkBundle][Validator] Fix deprecations from Doctrine Annotations+Cache (derrabus)
 * bug #41206 [Mailer] Fix SES API call with UTF-8 Addresses (jderusse)
 * bug #41240 Fixed deprecation warnings about passing null as parameter (derrabus)
 * bug #41241 [Finder] Fix gitignore regex build with "**" (mvorisek)
 * bug #41224 [HttpClient] fix adding query string to relative URLs with scoped clients (nicolas-grekas)
 * bug #41233 [DependencyInjection][ProxyManagerBridge] Don't call class_exists() on null (derrabus)
 * bug #41214 [Console] fix registering command aliases when using the new "cmd|alias" syntax for names (nicolas-grekas)
 * bug #41211 [Notifier] Add missing charset to content-type for Slack notifier (norkunas)
 * bug #41210 [Console] Fix Windows code page support (orkan)

* 5.3.0-BETA4 (2021-05-12)

 * security #cve-2021-21424 [Security][Guard] Prevent user enumeration (chalasr)
 * feature #41178 [FrameworkBundle] Introduce `AbstractController::renderForm()` instead of `handleForm()` (lyrixx)
 * feature #41182 [DependencyInjection] allow PHP-DSL files to be env-conditional (nicolas-grekas)
 * bug #41177 [DependencyInjection] fix empty instanceof-conditionals created by AttributeAutoconfigurationPass (nicolas-grekas)
 * bug #41176 [DependencyInjection] fix dumping service-closure-arguments (nicolas-grekas)
 * bug #41174 [Console] Fix Windows code page support (orkan)
 * bug #41173 [Security] Make Login Rate Limiter also case insensitive for non-ascii user identifiers (Seldaek)
 * bug #41170 [DependencyInjection] Don't try to load YamlFileLoader if it's not actually needed (nicolas-grekas)
 * bug #41168 WDT: Only load "Sfjs" if it is not present already (weaverryan)
 * feature #36864 [Messenger] Ability to distinguish retry and delay actions (theravel)
 * bug #41164 [FrameworkBundle] fix debug:event-dispatcher and debug:firewall (nicolas-grekas)
 * feature #41161 [HttpClient] Add `DecoratorTrait` to ease writing simple decorators (nicolas-grekas)
 * bug #41147 [Inflector][String] wrong plural form of words ending by "pectus" (makraz)
 * bug #41160 [HttpClient] Don't prepare the request in ScopingHttpClient (nicolas-grekas)
 * bug #41156 [Security] Make Login Rate Limiter case insensitive (jderusse)
 * bug #41155 [Translation] Improved Translation Providers (welcoMattic)
 * feature #40927 [Translation] Added Lokalise Provider (welcoMattic)
 * feature #40926 [Translation] Added PoEditor Provider (welcoMattic)
 * bug #41137 [Security] Reset limiters on successful login (MatTheCat)
 * bug #41148 [Runtime] fix defining $_SERVER[APP_ENV] (nicolas-grekas)
 * bug #40758 [Security] NullToken signature (jderusse)
 * bug #40763 Fix/Rewrite .gitignore regex builder (mvorisek)

* 5.3.0-BETA3 (2021-05-09)

 * feature #40947 [Translation] Added Crowdin Translation Provider (andrii-bodnar)
 * bug #41132 [Runtime] don't display the shebang on the CLI (nicolas-grekas)
 * bug #41113 [Console] Fix Windows code page support (orkan)
 * bug #40902 [Security] Allow ips parameter in access_control to accept comma-separated string (edefimov)
 * bug #40980 [TwigBridge] Fix HTML for translatable custom-file label in Bootstrap 4 theme (acran)
 * bug #40955 [Notifier] [Bridge] Fix missed messageId for SendMessage object in slack notifier (WaylandAce)
 * bug #40943 [PropertyInfo] PhpDocExtractor: Handle "true" and "false" property types (Maciej Zgadzaj)
 * bug #40759 [Form] Add missing TranslatableMessage support to choice_label option of ChoiceType (alexandre-daubois)
 * bug #40917 [Config][DependencyInjection] Uniformize trailing slash handling (dunglas)
 * bug #40699 [PropertyInfo] Make ReflectionExtractor correctly extract nullability (shiftby)
 * bug #40874 [PropertyInfo] fix attribute namespace with recursive traits (soullivaneuh)
 * bug #40957 [PhpUnitBridge] Fix tests with ``@doesNotPerformAssertions`` annotations (alexpott)
 * bug #41099 [Cache] Check if phpredis version is compatible with stream parameter (nicolassing)
 * bug #40982 [Notifier] Fix return SentMessage then Messenger not used (WaylandAce)
 * bug #40972 Avoid regenerating the remember me token if it is still fresh (Seldaek)
 * bug #41072 [VarExporter] Add support of PHP enumerations (alexandre-daubois)
 * feature #40992 [Notifier] Add SlackOptions::threadTs() to send message as reply (WaylandAce)
 * bug #41104 Fix return type in isAllowedProperty method on ReflectionExtractor class (Tomanhez)
 * bug #41078 [Notifier] Make FailoverTransport always pick the first transport (jschaedl)
 * feature #39157 [TwigBridge] Add form templates for Bootstrap 5 (ker0x)
 * bug #41022 [PasswordHasher] Improved BC layer (derrabus)
 * bug #41105 [Inflector][String] Fixed singularize `edges` > `edge` (ruudk)
 * bug #41075 [ErrorHandler] Skip "same vendor" ``@method`` deprecations for `Symfony\*` classes unless symfony/symfony is being tested (nicolas-grekas)
 * bug #41096 Make Serializable implementation internal and final (derrabus)
 * bug #40994 [Config] More accurate message on invalid config builder (a-menshchikov)
 * bug #40767 [Routing] Fix localized paths (l-vo)

* 5.3.0-BETA2 (2021-05-01)

 * feature #41002 [FrameworkBundle][HttpKernel] Move IDE file link formats from FrameworkExtension to FileLinkFormatter (MatTheCat)
 * bug #41014 [Routing] allow extending Route attribute (robmro27)
 * feature #39913 [OptionsResolver] Add prototype definition support for nested options (yceruto)
 * bug #41008 [Security] Do not try to rehash null-passwords (tjveldhuizen)
 * bug #41013 [Console] Remove spaces between arguments GithubActionReporter (franmomu)
 * bug #40920 [PasswordHasher] accept hashing passwords with nul bytes or longer than 72 bytes when using bcrypt (nicolas-grekas)
 * bug #40993 [Security] [Security/Core] fix checking for bcrypt (nicolas-grekas)
 * bug #40986 [Console] Negatable option are null by default (jderusse)
 * bug #40923 [Yaml] expose references detected in inline notation structures (xabbuh)
 * bug #40951 [FrameworkBundle] Make debug:event-dispatcher search case insensitive (javiereguiluz)
 * bug #40966 [Messenger] fix manual amqp setup when autosetup disabled (Tobion)
 * bug #40956 [Config] [ConfigBuilder] Set FQCN as properties type instead of class name (MatTheCat)
 * bug #40964 [HttpFoundation] Fixes for PHP 8.1 deprecations (jrmajor)
 * bug #40950 [Config] Remove double semicolons from autogenerated config classes (HypeMC)
 * bug #40903 [Config] Builder: Remove typehints and allow for EnvConfigurator (Nyholm)
 * bug #40919 [Mailer] use correct spelling when accessing the SMTP php.ini value (xabbuh)
 * bug #40514 [Yaml] Allow tabs as separators between tokens (bertramakers)
 * bug #40882 [Cache] phpredis: Added full TLS support for RedisCluster (jackthomasatl)
 * feature #38475 [Translation] Adding Translation Providers (welcoMattic)
 * bug #40877 [Config] Make sure one can build cache on Windows and then run in (Docker) Linux (Nyholm)
 * bug #40878 [Config] Use plural name on array values (Nyholm)
 * bug #40872 [DependencyInjection] [AliasDeprecatedPublicServicesPass] Noop when the service is private (fancyweb)
 * feature #40800 [DependencyInjection] Add `#[Target]` to tell how a dependency is used and hint named autowiring aliases (nicolas-grekas)
 * bug #40859 [Config] Support extensions without configuration in ConfigBuilder warmup (wouterj)
 * bug #40852 [Notifier] Add missing entries in scheme to package map (jschaedl)

* 5.3.0-BETA1 (2021-04-18)

 * feature #40838 [SecurityBundle] Deprecate public services to private (fancyweb)
 * feature #40782 [DependencyInjection] Add `#[When(env: 'foo')]` to skip autoregistering a class when the env doesn't match (nicolas-grekas)
 * feature #40840 [Security] Add passport to AuthenticationTokenCreatedEvent (scheb)
 * feature #40799 [FrameworkBundle] Add AbstractController::handleForm() helper (dunglas)
 * feature #40646 [Notifier] Add MessageBird notifier bridge (StaffNowa)
 * feature #40804 [Config][FrameworkBundle] Add CacheWarmer for ConfigBuilder (Nyholm)
 * feature #40814 Remove the experimental flag from the authenticator system 🚀 (chalasr)
 * feature #40690 [Form] Add support for sorting fields (yceruto)
 * feature #40691 [Notifier] Add SmsBiuras notifier bridge (StaffNowa)
 * feature #40406 [DependencyInjection] Autowire arguments using attributes (derrabus, nicolas-grekas)
 * feature #40155 [Messenger] Support Redis Cluster (nesk)
 * feature #40600 [Config][DependencyInjection] Add configuration builder for writing PHP config (Nyholm)
 * feature #40171 [Workflow] Add Mermaid.js dumper (eFrane)
 * feature #40761 [MonologBridge] Reset loggers on workers (l-vo)
 * feature #40785 [Security] Deprecate using UsageTrackingTokenStorage outside the request-response cycle (wouterj)
 * feature #40718 [Messenger] Add X-Ray trace header support to the SQS transport (WaylandAce)
 * feature #40682 [DependencyInjection] Add env() and EnvConfigurator in the PHP-DSL (fancyweb)
 * feature #40145 [Security] Rework the remember me system (wouterj)
 * feature #40695 [Console] Deprecate Helper::strlen() for width() and length() (Nyholm)
 * feature #40486 [Security] Add concept of required passport badges (wouterj)
 * feature #39007 [Notifier] Add notifier for Microsoft Teams (idetox)
 * feature #40710 [Serializer] Construct annotations using named arguments (derrabus)
 * feature #40647 [Notifier] [FakeChat] Added the bridge (OskarStark)
 * feature #40607 [Notifier] Add LightSms notifier bridge (Vasilij Dusko, StaffNowa)
 * feature #40576 [Mime] Remove @internal from Headers methods (VincentLanglet)
 * feature #40575 [FrameworkBundle][HttpKernel][TwigBridge] Add an helper to generate fragments URL (dunglas)
 * feature #38468 Messenger multiple failed transports (monteiro)
 * feature #39949 [Notifier] [FakeSms] Add the bridge (JamesHemery)
 * feature #40403 [Security] Rename UserInterface::getUsername() to getUserIdentifier() (wouterj)
 * feature #40602 [Cache] Support a custom serializer in the ApcuAdapter class (ste93cry)
 * feature #40449 [TwigBridge] add tailwindcss form layout (kbond)
 * feature #40567 [Security] Move the badges resolution check to `AuthenticatorManager` (chalasr)
 * feature #40300 [HttpFoundation] Add support for mysql unix_socket and charset in PdoSessionHandler::buildDsnFromUrl (bcremer, Nyholm)
 * feature #40153 [Security] LoginLink with specific locale (roromix)
 * feature #40489 [Serializer] Add a Custom End Of Line in CSV File (xfifix)
 * feature #40554 [Contracts] Add `TranslatorInterface::getLocale()` (nicolas-grekas)
 * feature #40556 Add `#[As-prefix]` to service attributes (nicolas-grekas)
 * feature #40555 [HttpKernel] Add `#[AsController]` attribute for declaring standalone controllers on PHP 8 (nicolas-grekas)
 * feature #40550 [Notifier] Move abstract test cases to  namespace (OskarStark)
 * feature #40530 [Uid] Handle predefined namespaces keywords "dns", "url", "oid" and "x500" (fancyweb)
 * feature #40536 [HttpFoundation][HttpKernel] Rename master request to main request (derrabus)
 * feature #40513 [Runtime] make GenericRuntime ... generic (nicolas-grekas)
 * feature #40430 [Form] Add "form_attr" FormType option (cristoforocervino)
 * feature #38488 [Validator] Add normalizer option to Unique constraint (henry2778)
 * feature #40487 [Security] Remove deprecated support for passing a UserInterface implementation to Passport (wouterj)
 * feature #40443 [Security] Rename User to InMemoryUser (chalasr)
 * feature #40468 Deprecate configuring tag names and service ids in compiler passes (nicolas-grekas)
 * feature #40248 [DependencyInjection] Add `#[TaggedItem]` attribute for defining the index and priority of classes found in tagged iterators/locators (nicolas-grekas)
 * feature #40240 [Validator] Add Validation::createIsValidCallable() that returns a boolean instead of exception (wouterj)
 * feature #40366 [FrameworkBundle] Add KernelTestCase::getContainer() (Nyholm)
 * feature #40441 [WebProfilerBundle] Disable CSP if dumper was used (monojp)
 * feature #40448 [twig-bridge] Allow NotificationEmail to be marked as public (maxailloud)
 * feature #38465 [Runtime] a new component to decouple applications from global state (nicolas-grekas)
 * feature #40432 [HttpKernel] Deprecate returning a `ContainerBuilder` from `KernelInterface::registerContainerConfiguration()` (nicolas-grekas)
 * feature #40337 [DependencyInjection] Add support an integer return for default_index_method (maranqz)
 * feature #39693 [PropertyAccess] use bitwise flags to configure when the property accessor should throw (xabbuh)
 * feature #40267 [Security] Decouple passwords from UserInterface (chalasr)
 * feature #40377 [Notifier] [OvhCloud] Add "sender" (notFloran)
 * feature #40384 [DependencyInjection] Implement psr/container 1.1 (derrabus)
 * feature #40229 [FrameworkBundle][Translation] Extract translation IDs from all of src (natewiebe13)
 * feature #40338 [FrameworkBundle] Add support for doctrine/annotations:1.13 || 2.0 (Nyholm)
 * feature #40323 [TwigBridge][TwigBundle] Twig serialize filter (jrushlow)
 * feature #40339 [RateLimiter][Security] Add a `login_throttling.interval` (in `security.firewalls`) option to change the default throttling interval. (damienfa, wouterj)
 * feature #40307 [HttpKernel] Handle multi-attribute controller arguments (chalasr)
 * feature #40284 [RateLimiter][Security] Allow to use no lock in the rate limiter/login throttling (wouterj)
 * feature #39607 [Messenger] Add `rediss://` DSN scheme support for TLS to Redis transport (njutn95)
 * feature #40306 [HttpClient] Add `HttpClientInterface::withOptions()` (nicolas-grekas)
 * feature #39883 [Uid] Add Generate and Inspect commands (fancyweb)
 * feature #40140 [DependencyInjection] Add ContainerBuilder::willBeAvailable() to help with conditional configuration (nicolas-grekas)
 * feature #40266 [Routing] Construct Route annotations using named arguments (derrabus)
 * feature #40288 Deprecate passing null as $message or $code to exceptions (derrabus)
 * feature #40298 [Form] Remove hard dependency on symfony/intl (Nyholm)
 * feature #40214 [FrameworkBundle] allow container/routing configurators to vary by env (nicolas-grekas)
 * feature #40257 [Intl] Add `Currencies::getCashFractionDigits()` and `Currencies::getCashRoundingIncrement()` (nicolas-grekas)
 * feature #39326 [Security] Added debug:firewall command (TimoBakx)
 * feature #40234 [Console] Add `ConsoleCommand` attribute for declaring commands on PHP 8 (nicolas-grekas)
 * feature #39897 [DependencyInjection] Autoconfigurable attributes (derrabus)
 * feature #39804 [DependencyInjection] Add `#[Autoconfigure]` to help define autoconfiguration rules (nicolas-grekas)
 * feature #40174 [Mailer] AWS SES transport Source ARN header support (chekalsky)
 * feature #38473 [Framework] Add tag assets.package to register asset packages (GromNaN)
 * feature #39399 [Serializer] Allow to provide (de)normalization context in mapping (ogizanagi)
 * feature #40202 [Workflow] Deprecate InvalidTokenConfigurationException (chalasr)
 * feature #40176 [PasswordHasher] Use bcrypt as default hash algorithm for "native" and "auto" (chalasr)
 * feature #40048 [FrameworkBundle] Deprecate session.storage service (jderusse)
 * feature #40169 [DependencyInjection] Negated (not:) env var processor (bpolaszek)
 * feature #39802 [Security] Extract password hashing from security-core - with proper wording (chalasr)
 * feature #40143 [Filesystem] improve messages on failure (nicolas-grekas)
 * feature #40144 [Filesystem] Remove dirs atomically if possible (nicolas-grekas)
 * feature #39507 [Uid] Add UidFactory to create Ulid and Uuid from timestamps and randomness/nodes (fancyweb)
 * feature #39688 [FrameworkBundle][Messenger] Added RouterContextMiddleware (jderusse)
 * feature #40102 [Notifier] [Firebase] Add data field to options (Raresmldvn)
 * feature #39978 [DoctrineBridge] Make subscriber and listeners prioritizable (jderusse)
 * feature #39732 [Routing] don't decode nor double-encode already encoded slashes when generating URLs (nicolas-grekas)
 * feature #39893 [HttpKernel] Show full URI when route not found (ruudk)
 * feature #40059 [PhpUnitBridge] Add SYMFONY_PHPUNIT_REQUIRE env variable (acasademont)
 * feature #39948 [Notifier] [SpotHit] Add the bridge (JamesHemery)
 * feature #38973 [Messenger] Allow to limit consumer to specific queues (dbu)
 * feature #40029 [DoctineBridge] Remove UuidV*Generator classes (nicolas-grekas)
 * feature #39976 [Console] Add bright colors to console. (CupOfTea696)
 * feature #40028 [Semaphore] remove "experimental" status (jderusse)
 * feature #38616 [FrameworkBundle][HttpFoundation][Security] Deprecate service "session" (jderusse)
 * feature #40010 [Uid] remove "experimental" status (nicolas-grekas)
 * feature #40012 [Uid] Add RFC4122 UUID namespaces as constants (nicolas-grekas)
 * feature #40008 [Uid] Replace getTime() with getDateTime() (fancyweb)
 * feature #39910 [FrameworkBundle] Command cache:pool:clear warns and fails when one of the pools fails to clear (jderusse)
 * feature #39699 [String] Made AsciiSlugger fallback to parent locale's symbolsMap (jontjs)
 * feature #39971 [Cache] Change PDO cache table collate from utf8_bin to utf8mb4_bin (pdragun)
 * feature #38922 [Notifier] Add notifier for Clickatell (Kevin Auivinet, Kevin Auvinet, ke20)
 * feature #39587 [Notifier] [Mobyt] Change ctor signature and validate message types (OskarStark)
 * feature #39919 [Security] Randomize CSRF token to harden BREACH attacks (jderusse)
 * feature #39850 [Uid] Add fromBase58(), fromBase32(), fromRfc4122() and fromBinary() methods (fancyweb)
 * feature #39904 [Console] add option `--short` to the `list` command (nicolas-grekas)
 * feature #39851 [Console] enable describing commands in ways that make the `list` command lazy (nicolas-grekas)
 * feature #39838 [Notifier] Add Gitter Bridge (christingruber)
 * feature #39342 [Notifier] Add mercure bridge (mtarld)
 * feature #39863 [Form][Uid] Add UlidType and UuidType form types (Gemorroj)
 * feature #39806 [DependencyInjection] Add a remove() method to the PHP configurator (dunglas)
 * feature #39843 [FrameworkBundle] Add renderForm() helper setting the appropriate HTTP status code (dunglas)
 * feature #39852 [Security] RoleHierarchy returns an unique array of roles (lyrixx)
 * feature #39855 [HttpFoundation] deprecate the NamespacedAttributeBag class (xabbuh)
 * feature #39579 [Notifier] [GoogleChat] [BC BREAK] Rename threadKey parameter to thread_key + set parameter via ctor (OskarStark)
 * feature #39617 [Notifier] Add AllMySms Bridge (qdequippe)
 * feature #39702 [Notifier] Add Octopush notifier transport (aurelienheyliot)
 * feature #39568 [Notifier] Add GatewayApi bridge (Piergiuseppe Longo)
 * feature #39585 [Notifier] Change Dsn api (OskarStark)
 * feature #39675 [Serializer] [UidNormalizer] Add normalization formats (fancyweb)
 * feature #39457 [Notifier] [DX] Dsn::getRequiredOption() (OskarStark)
 * feature #39098 [PhpUnitBridge] Add log file option for deprecations (michaelKaefer)
 * feature #39642 [Console] Support binary / negatable options (greg-1-anderson, jderusse)
 * feature #39051 [WebProfilerBundle] Possibility to dynamically set mode (brusch)
 * feature #39701 [Lock] Create flock directory (jderusse)
 * feature #39696 [DoctrineBridge] Deprecate internal test helpers in Test namespace (wouterj)
 * feature #39684 [DomCrawler] deprecate parents() in favor of ancestors() (xabbuh)
 * feature #39666 [FrameworkBundle][HttpFoundation] add assertResponseFormatSame() (dunglas)
 * feature #39660 [Messenger] Deprecate option prefetch_count (jderusse)
 * feature #39577 [Serializer] Migrate ArrayDenormalizer to DenormalizerAwareInterface (derrabus)
 * feature #39020 [PropertyInfo] Support multiple types for collection keys & values (Korbeil)
 * feature #39557 [Notifier] [BC BREAK] Final classes (OskarStark)
 * feature #39592 [Notifier] [BC BREAK] Change constructor signature for Mattermost and Esendex transport (OskarStark)
 * feature #39643 [PhpUnitBridge] Remove obsolete polyfills (derrabus)
 * feature #39606 [Notifier] [Slack] Validate token syntax (OskarStark)
 * feature #39549 [Notifier] [BC BREAK] Fix return type (OskarStark)
 * feature #39096 [Notifier] add iqsms bridge (alexandrbarabolia)
 * feature #39493 [Notifier] Introduce LengthException (OskarStark)
 * feature #39484 [FrameworkBundle] Allow env variables in `json_manifest_path` (jderusse)
 * feature #39480 [FrameworkBundle] Add "mailer" monolog channel to mailer transports (chalasr)
 * feature #39419 [PhpUnitBridge] bump "php" to 7.1+ and "phpunit" to 7.5+ (nicolas-grekas)
 * feature #39410 [Notifier] Add HeaderBlock for slack notifier (norkunas)
 * feature #39365 [Notifier] [DX] UnsupportedMessageTypeException for notifier transports (OskarStark)
 * feature #38469 [Form] Add "choice_translation_parameters" option (VincentLanglet)
 * feature #39352 [TwigBridge] export concatenated translations (Stephen)
 * feature #39378 [Messenger] Use "warning" instead of "error" log level for RecoverableException (lyrixx)
 * feature #38622 [BrowserKit] Allowing body content from GET with a content-type (thiagomp)
 * feature #39363 [Cache] Support Redis Sentinel mode when using phpredis/phpredis extension (renan)
 * feature #39340 [Security] Assert voter returns valid decision (jderusse)
 * feature #39327 [FrameworkBundle] Add validator.expression_language service (fbourigault)
 * feature #39276 [FrameworkBundle] Added option to specify the event dispatcher in debug:event-dispatcher (TimoBakx)
 * feature #39042 [Console] Extracting ProgressBar's format's magic strings into const (CesarScur)
 * feature #39323 Search for pattern on debug:event-dispatcher (Nyholm)
 * feature #39317 [Form] Changed DataMapperInterface $forms parameter type to \Traversable (vudaltsov)
 * feature #39258 [Notifier] Add ContextBlock for slack notifier (norkunas)
 * feature #39300 [Notifier] Check for maximum number of buttons in slack action block (malteschlueter)
 * feature #39097 [DomCrawler] Cache discovered namespaces (simonberger, fabpot)
 * feature #39037 [Ldap] Ldap Entry case-sensitive attribute key option (karlshea)
 * feature #39146 [Console] Added Invalid constant into Command Class (TheGarious)
 * feature #39075 [Messenger]  Allow InMemoryTransport to serialize message (tyx)
 * feature #38982 [Console][Yaml] Linter: add Github annotations format for errors (ogizanagi)
 * feature #38846 [Messenger] Make all the dependencies of AmazonSqsTransport injectable (jacekwilczynski)
 * feature #38596 [BrowserKit] Add jsonRequest function to the browser-kit client (alexander-schranz)
 * feature #38998 [Messenger][SQS] Make sure one can enable debug logs (Nyholm)
 * feature #38974 [Intl] deprecate polyfills in favor of symfony/polyfill-intl-icu (nicolas-grekas)

