CHANGELOG for 6.1.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 6.1 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v6.1.0...v6.1.1

* 6.1.8 (2022-11-28)

 * bug #48333 [Yaml] parse unquoted digits in tag values as integers (xabbuh)
 * bug #48330 [FrameworkBundle] do not wire the MercureTransportFactory if the MercureBundle is not enabled (xabbuh)
 * bug #48262 [Notifier] [SMSBiuras] `true`/`false` mismatch for `test_mode` option (StaffNowa)
 * bug #48273 [HttpKernel] Fix message for unresovable arguments of invokable controllers (fancyweb)
 * bug #48251 [PropertyInfo] ignore const expressions read by phpdocumentor (xabbuh)
 * bug #48224 [DependencyInjection] Process bindings in `ServiceLocatorTagPass` (MatTheCat)
 * bug #48179 [Console] Support completion for bash functions (Chi-teck)
 * bug #48217 [Console] Improve error message when shell is not detected in completion command (GromNaN)
 * bug #48222 [Translation] [Lokalize] Configure `replace_breaks` to prevent issues with multilines translations (Kocal)
 * bug #48210 [Console]  Fix signal handlers called after event listeners and skip exit (GromNaN)
 * bug #48198 [Messenger] Fix time-limit check exception (alamirault)
 * bug #48122 [PhpUnitBridge] Fix language deprecations incorrectly marked as direct (wouterj)
 * bug #47998 [Console] Fix console `ProgressBar::override()` after manual `ProgressBar::cleanup()` (maxbeckers)
 * bug #48173 [HttpClient] Handle Amp HTTP client v5 incompatibility gracefully (fancyweb)
 * bug #48172 [HttpKernel] Don’t try to wire Response argument with controller.service_arguments (MatTheCat)
 * bug #48085 [Messenger] Tell about messenger:consume invalid limit options (MatTheCat)
 * bug #48120 [Messenger] Do not throw 'no handlers' exception when skipping handlers due to duplicate handling (wouterj)
 * bug #48112 [HttpFoundation] Compare cookie with null value as empty string in ResponseCookieValueSame (fancyweb)
 * bug #48119 [FrameworkBundle][Lock] Allow to disable lock without defining a resource (MatTheCat)
 * bug #48110 [HttpKernel] Fix deprecation for DateTimeValueResolver with null on non-nullable argument (GromNaN)
 * bug #48093 [DependencyInjection] don't move locator tag for service subscriber (RobertMe)
 * bug #48075 [Mailer] Stream timeout not detected fgets returns false (Sezil)
 * bug #48092 Fix the notification email theme for asynchronously dispatched emails (krisbuist)
 * bug #48097 Fix search scope when performing fallback mapping driver detection (spideyfusion)
 * bug #48103 [HttpClient] Do not set http_version instead of setting it to null (Tetragramat)
 * bug #48027 [DependencyInjection] Don't autoconfigure tag when it's already set with attributes (nicolas-grekas)
 * bug #48050 [HttpFoundation] Check IPv6 is valid before comparing it (PhilETaylor)

* 6.1.7 (2022-10-28)

 * bug #47990 [HttpClient] Fix retrying requests when the content is used by the strategy (nicolas-grekas)
 * bug #48005 [ErrorHandler] s/</br>/<br> (PhilETaylor)
 * bug #47907 [Console] Update Application.php (aleksandr-shevchenko)
 * bug #47955 [Security][Serializer] Add missing args to trigger_deprecation (alamirault)
 * bug #47932 Throw LogicException instead of Error when trying to generate logout-… (addiks)
 * bug #47918 [Intl] Update the ICU data to 72.1 - 5.4 (jderusse)
 * bug #47857 [HttpKernel] Fix empty request stack when terminating with exception (krzyc)
 * bug #47879 [HttpClient] Fix buffering after calling AsyncContext::passthru() (nicolas-grekas, lubo13)
 * bug #47878 [HttpKernel] Remove EOL when using error_log() in HttpKernel Logger (cyve)
 * bug #47854 [HttpClient] Don't override header if is x-www-form-urlencoded (Oipnet)
 * bug #47883 [Console] Fix error output on windows cli (Maximilian.Beckers)
 * bug #47884 [Cache] Reserve numeric keys when doing memory leak prevention (simoheinonen)
 * bug #47863 [DoctrineBridge] Allow doctrine/event-manager 2 (derrabus)
 * bug #47831 [Messenger] Fix amqp socket lost (GurvanVgx)
 * bug #47855 [Routing] TypeError in Router when using UrlGenerator (Maximilian.Beckers)
 * bug #47822 [Mailer] fix: use message object from event (rogamoore)
 * bug #47858 [DoctrineBridge] Implement `EventManager::getAllListeners()` (derrabus)

* 6.1.6 (2022-10-12)

 * bug #47621 [Serializer] Allow getting discriminated type by class name (TamasSzigeti)
 * bug #47833 [TwigBridge] Remove empty spaces between choices when using checkbox-inline or checkbox-switch (simondaigre)
 * bug #47808 [HttpClient] Fix seeking in not-yet-initialized requests (nicolas-grekas)
 * bug #47798 [DoctrineBridge] Fix auto mapping for bundles that contain only embeddables (jorissae)
 * bug #47702 [Messenger] Fix default serializer not handling DateTime objects properly (barton-webwings)
 * bug #47764 [Serializer] fixed traceable decoration priorities (mtarld)
 * bug #47779 [Console] Fix `Helper::removeDecoration` hyperlink bug (greew)
 * bug #47753 [Mime] sync message serializer code for forward-compatibility (xabbuh)
 * bug #47763 [PropertyInfo] a readonly property must not be reported as being writable (xabbuh)
 * bug #47731 [WebProfiler] Fix overflow issue in Forms panel (zolikonta)
 * bug #46956 [FrameworkBundle] Allow to specify `null` for exception mapping configuration values (andrew-demb)
 * bug #47746 [HttpFoundation] Fix BinaryFileResponse content type detection logic (X-Coder264)
 * bug #47626 [Notifier] [Expo] Throw exception on error-response from expo api (sdrewergutland)
 * bug #47317 [Security] Fix login url matching when app is not run with url rewriting or from a sub folder (sgehrig)

* 6.1.5 (2022-09-30)

 * bug #47703 [Mailer][Mailjet] Apply the default value of 512 for max depths (nurtext)
 * bug #47637 [FrameworkBundle] Fix passing `serializer.default_context` option to normalizers (wuchen90)
 * bug #47695 [FrameworkBundle] Filter out trans paths that are covered by a parent folder path (natewiebe13)
 * bug #45554 [Serializer] Fixed framework.serializer.default_context is not working for JsonEncoder (siganushka)
 * bug #47547 [Ldap] Do not run ldap_set_option on failed connection (tatankat)
 * bug #47635 [DependencyInjection] EnvPlaceholderParameterBag::get() can't return UnitEnum (jack.shpartko)
 * bug #47675 [HttpKernel] Use Accept-Language header even if there are no enabled locales (MatTheCat)
 * bug #47578 [Security] Fix AbstractFormLoginAuthenticator return types (AndrolGenhald)
 * bug #47614 [FrameworkBundle] Fix a phpdoc in mailer assertions (HeahDude)
 * bug #47227 [Messenger] Support for custom handler method containing a Union type tagged with #[AsMessageHandler] (ArchitectNate)
 * bug #47516 [HttpFoundation] Prevent BinaryFileResponse::prepare from adding content type if no content is sent (naitsirch)
 * bug #47533 [Messenger] decode URL-encoded characters in DSN's usernames/passwords (xabbuh)
 * bug #47530 [HttpFoundation] Always return strings from accept headers (ausi)
 * bug #47529 [Routing] Reject v2 UUIDs (nicolas-grekas)
 * bug #47523 [Uid] Ensure ULIDs are monotonic even when the time goes backward (nicolas-grekas)
 * bug #47528 [Form] fix UUID tranformer (nicolas-grekas)
 * bug #47488 [Security] Fix valid remember-me token exposure to the second consequent request (Ivan Kurnosov)
 * bug #47518 [Uid] Fix validating UUID variant bits (nicolas-grekas)
 * bug #47441 [HttpClient] [HttpClientBundle] Bugfix for delayed retryableHttpClient (martkop26)
 * bug #47499 [Uid][Validator] Stop to first ULID format violation (ogizanagi)
 * bug #47491 [HttpKernel] Prevent exception in RequestDataCollector if request stack is empty (aschempp)
 * bug #47497 [Bridge] Fix mkdir() race condition in ProxyCacheWarmer (andrey-tech)
 * bug #47415 [HttpClient] Psr18Client ignore invalid HTTP headers (nuryagdym)
 * bug #47463 [Console] [Completion] Make fish completion run in non interactive mode (Seldaek)
 * bug #47394 [Console] [Completion] Make bash completion run in non interactive mode (Seldaek)
 * bug #47455 [Mime] Fix TextPart broken after being serialized (fabpot)
 * bug #47423 [String] CamelCase/SnakeCase on uppercase word (mpiot)
 * bug #47435 [HttpKernel] lock when writting profiles (nicolas-grekas)
 * bug #47417 [WebProfilerBundle] Fix profile search bar link query params (HeahDude)
 * bug #47437 [Mime] Fix email rendering when having inlined parts that are not related to the content (fabpot)
 * bug #47434 [HttpFoundation] move flushing outside of Response::closeOutputBuffers (nicolas-grekas)
 * bug #47351 [FrameworkBundle] Do not throw when describing a factory definition (MatTheCat)
 * bug #47403 [Mailer] Fix edge cases in STMP transports (fabpot)

* 6.1.4 (2022-08-26)

 * bug #47372 [Console] Fix OutputFormatterStyleStack::getCurrent return type (alamirault)
 * bug #47391 [LokaliseBridge] Fix push command --delete-missing options when there are no missing messages (rwionczek)
 * bug #47368 [Security] Count remember me cookie parts before accessing the second (MatTheCat)
 * bug #47358 Fix broken request stack state if throwable is thrown. (Warxcell)
 * bug #47304 [Serializer] Fix caching context-aware encoders/decoders in ChainEncoder/ChainDecoder (Guite)
 * bug #47150 [Serializer] Revert deprecation of `ContextAwareEncoderInterface` and `ContextAwareDecoderInterface` (nicolas-grekas)
 * bug #47329 Email image parts: regex for single closing quote (rr-it)
 * bug #47335 [Security] [AbstractToken] getUserIdentifier() must return a string (mpiot)
 * bug #47283 [HttpFoundation] Prevent accepted rate limits with no remaining token to be preferred over denied ones (MatTheCat)
 * bug #47128 [Serializer] Throw InvalidArgumentException if the data needed in the constructor doesn't belong to a backedEnum  (allison guilhem)
 * bug #47273 [HttpFoundation] Do not send Set-Cookie header twice for deleted session cookie (X-Coder264)
 * bug #47255 [Serializer] Fix get accessor regex in AnnotationLoader (jsor)
 * bug #47238 [HttpKernel] Fix passing `null` to `\trim()` method in LoggerDataCollector (SVillette)
 * bug #47216 [Translation] Crowdin provider throw Exception when status is 50x (alamirault)
 * bug #47209 Always attempt to listen for notifications (goetas)
 * bug #47211 [Validator] validate nested constraints only if they are in the same group (xabbuh)
 * bug #47218 [Console] fix dispatch signal event check for compatibility with the contract interface (xabbuh)
 * bug #47200 [Form] ignore missing keys when mapping DateTime objects to uninitialized arrays (xabbuh)
 * bug #47189 [Validator] Add additional hint when `egulias/email-validator` needs to be installed (mpdude)
 * bug #47195 [FrameworkBundle] fix writes to static $kernel property (xabbuh)
 * bug #47185 [String] Fix snake conversion (simPod)
 * bug #47175 [DowCrawler] Fix locale-sensitivity of whitespace normalization (nicolas-grekas)
 * bug #47172 [Translation] Fix reading intl-icu domains with LocoProvider (nicolas-grekas)
 * bug #47171 [TwigBridge] suggest to install the Twig bundle when the required component is already installed (xabbuh)
 * bug #47169 [Serializer] Fix throwing right exception in ArrayDenormalizer with invalid type (norkunas)
 * bug #47162 [Mailer] Fix error message in case of an SMTP error (fabpot)
 * bug #47161 [Mailer] Fix logic (fabpot)
 * bug #47157 [Messenger] Fix Doctrine transport on MySQL (nicolas-grekas)
 * bug #47155 [Filesystem] Remove needless `mb_*` calls (HellFirePvP)
 * bug #46190 [Translation] Fix translator overlapse (Xavier RENAUDIN)
 * bug #47142 [Mailer] Fix error message in case of an STMP error (fabpot)
 * bug #45333 [Console] Fix ConsoleEvents::SIGNAL subscriber dispatch (GwendolenLynch)
 * bug #47145 [HttpClient] Fix shared connections not being freed on PHP < 8 (nicolas-grekas)
 * bug #47143 [HttpClient] Fix memory leak when using StreamWrapper (nicolas-grekas)
 * bug #47130 [HttpFoundation] Fix invalid ID not regenerated with native PHP file sessions (BrokenSourceCode)
 * bug #47129 [FrameworkBundle] remove the ChatterInterface alias when the chatter service is removed (xabbuh)

* 6.1.3 (2022-07-29)

 * bug #47069 [Security] Allow redirect after login to absolute URLs (Tim Ward)
 * bug #47073 [HttpKernel] Fix non-scalar check in surrogate fragment renderer (aschempp)
 * bug #46849 [HtmlSanitizer] Allow null for sanitizer option `allowed_link_hosts` and `allowed_media_hosts` (plfort)
 * bug #47104 [Serializer] Fix wrong needsNormalization in TraceableEncoder (ostrolucky)
 * bug #47003 [Cache] Ensured that redis adapter can use multiple redis sentinel hosts (warslett)
 * bug #43329 [Serializer] Respect default context in DateTimeNormalizer::denormalize (hultberg)
 * bug #47070 [Messenger] Fix function name in TriggerSql on postgresql bridge to support table name with schema (zimny9932)
 * bug #47086 Workaround disabled "var_dump" (nicolas-grekas)
 * bug #40828 [BrowserKit] Merge fields and files recursively if they are multidimensional array (januszmk)
 * bug #47010 [String] Fix `width` method in `AbstractUnicodeString` (TBoileau)
 * bug #47048 [Serializer] Fix XmlEncoder encoding attribute false (alamirault)
 * bug #46957 [HttpFoundation] Fix `\Stringable` support in `InputBag::get()` (chalasr)
 * bug #47022 [Console] get full command path for command in search path (remicollet)
 * bug #47000 [ErrorHandler] Fix return type patching for list and class-string pseudo types (derrabus)
 * bug #43998 [HttpKernel] [HttpCache] Don't throw on 304 Not Modified (aleho)
 * bug #46792 [Bridge] Corrects bug in test listener trait (magikid)
 * bug #46985 [DoctrineBridge] Avoid calling `AbstractPlatform::hasNativeGuidType()` (derrabus)
 * bug #46958 [Serializer] Ignore getter with required parameters (Fix #46592) (astepin)
 * bug #46981 [Mime]  quote address names if they contain parentheses (xabbuh)
 * bug #46960 [FrameworkBundle] Fail gracefully when forms use disabled CSRF (HeahDude)
 * bug #46973 [DependencyInjection] Fail gracefully when attempting to autowire composite types (derrabus)
 * bug #45884 [Serializer] Fix inconsistent behaviour of nullable objects in key/value arrays (phramz)
 * bug #46963 [Mime] Fix inline parts when added via attachPart() (fabpot)
 * bug #46968 [PropertyInfo] Make sure nested composite types do not crash ReflectionExtractor (derrabus)
 * bug #46931 Flush backend output buffer after closing. (bradjones1)
 * bug #46947 [Serializer] Prevent that bad Ignore method annotations lead to incorrect results (astepin)
 * bug #46948 [Validator] : Fix "PHP Warning: Undefined array key 1" in NotCompromisedPasswordValidator (KevinVanSonsbeek)
 * bug #46905 [BrowserKit] fix sending request to paths containing multiple slashes (xabbuh)
 * bug #46244 [Validator] Fix traverse option on Valid constraint when used as Attribute (tobias-93)
 * bug #42033 [HttpFoundation] Fix deleteFileAfterSend on client abortion (nerg4l)
 * bug #46941 [Messenger] Fix calls to deprecated DBAL methods (derrabus)
 * bug #46863 [Mime] Fix invalid DKIM signature with multiple parts (BrokenSourceCode)
 * bug #46808 [HttpFoundation] Fix TypeError on null `$_SESSION`  in `NativeSessionStorage::save()` (chalasr)
 * bug #46811 [DoctrineBridge] Fix comment for type on Query::setValue (middlewares) (l-vo)
 * bug #46790 [HttpFoundation] Prevent PHP Warning: Session ID is too long or contains illegal characters (BrokenSourceCode)
 * bug #46700 [HttpClient] Prevent "Fatal error" in data collector (fmata)
 * bug #46800 Spaces in system temp folder path cause deprecation errors in php 8 (demeritcowboy)
 * bug #46797 [Messenger] Ceil waiting time when multiplier is a float on retry (WissameMekhilef)

* 6.1.2 (2022-06-26)

 * bug #46779 [String] Add an invariable word in french (lemonlab)
 * bug #46765 [Serializer] Fix denormalization union types with constructor (Gwemox)
 * bug #46769 [HttpKernel] Fix a PHP 8.1 deprecation notice in HttpCache (mpdude)
 * bug #46760 Fix double authentication via RememberMe resulting in wrong RememberMe cookie being set in client (heiglandreas)
 * bug #46766 Initially set user null. (mogilvie)
 * bug #46735 [Messenger] Do not log the message object itself (ajardin)
 * bug #46748 [Security] Fix legacy impersonation system (dunglas)
 * bug #46747 Fix global state pollution between tests run with ApplicationTester (Seldaek)
 * bug #46730 [Intl] Fix the IntlDateFormatter::formatObject signature (damienalexandre)
 * bug #46668 [FrameworkBundle] Lower JsonSerializableNormalizer priority (aprat84)
 * bug #46711 [PhpUnitBridge] Exclude from baseline generation deprecations triggered in legacy test (mondrake)
 * bug #46678 [HttpFoundation] Update "[Session] Overwrite invalid session id" to only validate when files session storage is used (alexpott)
 * bug #46665 [HttpClient] Fix Copy as curl with base uri (HypeMC)
 * bug #46670 [HttpClient] Fix json encode flags usage in copy-as-curl generation (welcoMattic)
 * bug #45861 [Serializer] Try all possible denormalization route with union types when ALLOW_EXTRA_ATTRIBUTES=false (T-bond)
 * bug #46676 [DoctrineBridge] Extend type guessing on enum fields (Gigino Chianese)
 * bug #46699 [Cache] Respect $save option in all adapters (jrjohnson)
 * bug #46697 [HttpKernel] Disable session tracking while collecting profiler data (nicolas-grekas)
 * bug #46704 Allow passing null in twig_is_selected_choice (raziel057)
 * bug #46684 [MonologBridge] Fixed support of elasticsearch 7.+ in ElasticsearchLogstashHandler (lyrixx)
 * bug #46650  [WebProfilerBundle] Bump http-kernel requirement to ^6.1  (ostrolucky)
 * bug #46646 [Messenger] move resetting services at worker stopped into listener (Thomas Talbot)
 * bug #46611 [PropertyInfo] Fix multi phpdoc covered promoted properties (ostrolucky, simPod)
 * bug #46368 [Mailer] Fix for missing sender name in case with usage of the EnvelopeListener (bobahvas)
 * bug #46603 [Mailer] Fix Error Handling for OhMySMTP Bridge (paul-oms)

* 6.1.1 (2022-06-09)

 * bug #46570 [HttpClient][WebProfilerBundle] Catch errors when encoding body for c… (Phillip Look)
 * bug #46583 [HttpClient] Copy as curl fixes (HypeMC)
 * bug #46625 [FrameworkBundle] Disable Serializer data collect by default (chalasr)
 * bug #46545 Fix getting class constraints on debug command (loic425)
 * bug #46548 [Mime] Allow url as a path in the DataPart::fromPath (wkania)
 * bug #46576 Fix choice filter error when loading mix of grouped and non-grouped choices (BreyndotEchse)
 * bug #46594 [FrameworkBundle] Fix XML cache config (HeahDude)
 * bug #46610 [Messenger] use the outermost wrapping DBAL connection (xabbuh)
 * bug #46595 [Console] Escape  in command name & description from getDefaultName() (ogizanagi)
 * bug #46608 [Console] Fix deprecation when description is null (HypeMC)
 * bug #46586 [HttpKernel] Fix BackedEnumValueResolver already resolved enum value (janatjak)
 * bug #46574 [Console] Escape  in command name & description from PHP (getDefault* methods) (ogizanagi)
 * bug #46577 [Serializer] Fix ignore attribute in Xml files (alamirault)
 * bug #46565 [WebProfilerBundle] Fix dark theme selected line highlight color & reuse css vars (ogizanagi)
 * bug #46553 [WebProfilerBundle] normalizer and encoder can be undefined in template (kor3k)
 * bug #46538 [FrameworkBundle][HtmlSanitizer] Fix calling `allowStaticElements` when setting `allow_all_static_elements: true` (norkunas)
 * bug #46525 [Serializer] Get attributeContext after converting name (zenas1210)
 * bug #46535 [Mime] Check that the path is a file in the DataPart::fromPath (wkania)
 * bug #46543 [Cache] do not pass null to strlen() (xabbuh)
 * bug #46523 [HttpFoundation] Revert "Send `Content-Length` when calling `Response::send()` and the content is a non-empty string" (nicolas-grekas)
 * bug #46526 [Serializer] Added missing __call to TraceableEncoder (danielburger1337)
 * bug #46527 [Serializer] Forget partially collected traces (mtarld)
 * bug #46515 [PropertyInfo] Fix extracting int range type (norkunas)
 * bug #46511 [Serializer] Added missing __call to TraceableNormalizer and TraceableSerializer (danielburger1337)
 * bug #46478 [Contracts] remove static cache from `ServiceSubscriberTrait` (kbond)
 * bug #46480 [FrameworkBundle][TwigBundle] Fix registering html-sanitizer services (nicolas-grekas)
 * bug #46475 [MonologBridge] ensure that the $response property is initialized before being read (xabbuh)

* 6.1.0 (2022-05-27)

 * bug #46453 [PropertyInfo] Fix resolution of partially docblock covered constructors (ostrolucky)
 * bug #46454 [ExpressionLanguage] Fix null-safe chaining (HypeMC)
 * bug #46386 [Console]  Fix missing negative variation of negatable options in shell completion (GromNaN)
 * bug #46387 [Console] Complete negatable options (Fish) (GromNaN)
 * bug #46448 [DependencyInjection] Fix "proxy" tag: resolve its parameters and pass it to child definitions (nicolas-grekas)
 * bug #46442 [FrameworkBundle] Revert "bug #46125  Always add CacheCollectorPass (fancyweb)" (chalasr)
 * bug #46443 [DoctrineBridge] Don't reinit managers when they are proxied as ghost objects (nicolas-grekas)
 * bug #46427 [FrameworkBundle] fix wiring of annotations.cached_reader (nicolas-grekas)
 * bug #46425 [DependencyInjection] Ignore unused bindings defined by attribute (nicolas-grekas)
 * bug #46434 [FrameworkBundle] Fix BC break in abstract config commands (yceruto)
 * bug #46424 [Form] do not accept array input when a form is not multiple (xabbuh)
 * bug #46367 [Mime] Throw exception when body in Email attach method is not ok (alamirault)
 * bug #46421 [VarDumper][VarExporter] Deal with DatePeriod->include_end_date on PHP 8.2 (nicolas-grekas)
 * bug #46401 [Cache] Throw when "redis_sentinel" is used with a non-Predis "class" option (buffcode)
 * bug #46414 Bootstrap 4 fieldset for row errors (konradkozaczenko)
 * bug #46412 [FrameworkBundle] Fix dumping extension config without bundle (yceruto)
 * bug #46385 [HttpKernel] New bundle path convention when `AbstractBundle` is used (yceruto)
 * bug #46382 [HttpClient] Honor "max_duration" when replacing requests with async decorators (nicolas-grekas)
 * bug #46407 [Filesystem] Safeguard (sym)link calls (derrabus)
 * bug #46098 [Form] Fix same choice loader with different choice values (HeahDude)
 * bug #46380 [HttpClient] Add missing HttpOptions::setMaxDuration() (nicolas-grekas)
 * bug #46377 [HttpKernel] Fix missing null type in `ErrorListener::__construct()` (chalasr)
 * bug #46249 [HttpFoundation] [Session] Regenerate invalid session id (peter17)
 * bug #46373 [HtmlSanitizer] Fix default config service definition (wouterj)
 * bug #46328 [Config] Allow scalar configuration in PHP Configuration (jderusse, HypeMC)
 * bug #46366 [Mime] Add null check for EmailHeaderSame (magikid)
 * bug #46361 [PropertyInfo] Ignore empty doc-block for promoted properties in PhpStanExtractor (BoShurik)
 * bug #46364 [Config] Fix looking for single files in phars with GlobResource (nicolas-grekas)
 * bug #46365 [HttpKernel] Revert "bug #46327  Allow ErrorHandler ^5.0 to be used" (nicolas-grekas)

* 6.1.0-RC1 (2022-05-14)

 * feature #46335 [Form][FrameworkBundle][TwigBundle] Add Twig filter, form-type extension and improve service definitions for HtmlSanitizer (nicolas-grekas)
 * bug #46114 Fixes "Incorrectly nested style tag found" error when using multi-line header content (Perturbatio)
 * bug #46325 [Ldap] Fix LDAP connection options (buffcode)
 * bug #46341 Fix aliases handling in command name completion (Seldaek)
 * bug #46317 [Security/Http] Ignore invalid URLs found in failure/success paths (nicolas-grekas)
 * bug #46309 [Security] Fix division by zero (tvlooy)
 * bug #46327 [HttpKernel] Allow ErrorHandler ^5.0 to be used in HttpKernel 4.4 (mpdude)
 * bug #46310 [MonologBridge] Fix LevelName being removed in Monolog 3.0 (Seldaek)
 * bug #46297 [Serializer] Fix JsonSerializableNormalizer ignores circular reference handler in $context (BreyndotEchse)
 * bug #46291 [Console] Suppress unhandled error in some specific use-cases. (rw4lll)
 * bug #46302 [ErrorHandler] Fix list of tentative return types (nicolas-grekas)
 * bug #46293 [HttpClient] "debug" is missing if a request failed to even start (weaverryan)
 * bug #45981 [Serializer][PropertyInfo] Fix support for "false" built-in type on PHP 8.2 (alexandre-daubois)
 * feature #41676 [Console] Table vertical rendering (yoannrenard)
 * bug #46277 [HttpKernel] Fix SessionListener without session in request (edditor)
 * bug #46282 [DoctrineBridge] Treat firstResult === 0 like null (derrabus)
 * bug #46239 [Translation] Refresh local translations on PushCommand if the provider has domains (Florian-B)
 * bug #46274 [HtmlSanitizer] Fix node renderer handling of self-closing (void) elements (omniError)
 * bug #46276 [DependencyInjection] Fix lazyness of AutowiringFailedException (nicolas-grekas)
 * bug #46278 [Workflow] Fix deprecated syntax for interpolated strings (nicolas-grekas)
 * bug #46264 [Console] Better required argument check in InputArgument (jnoordsij)
 * bug #46272 [DependencyInjection] Fix resolving parameters found in #[Autowire] (nicolas-grekas)
 * bug #46262 [EventDispatcher] Fix removing listeners when using first-class callable syntax (javer)
 * feature #46153 [MonologBridge] Add support for Monolog 3 (Seldaek)
 * bug #46199 [HttpKernel] Handle previously converted `DateTime` arguments (mbabker)
 * bug #46216 [Form] fix populating single widget time view data with different timezones (xabbuh)
 * bug #46221 [DomCrawler][VarDumper] Fix html-encoding emojis (nicolas-grekas)
 * bug #46220 [Console] Fix fish completion script (wouterj)
 * bug #46167 [VarExporter] Fix exporting DateTime objects on PHP 8.2 (nicolas-grekas)

* 6.1.0-BETA2 (2022-04-27)

 * feature #45282 [Serializer] Support canners in object normalizer (rmikalkenas)
 * feature #46157 [Routing] Remove variadic constructor signature (wouterj)
 * bug #46154 [Mailer] Restore X-Transport after failure (zenas1210)
 * bug #46178 [DependencyInjection] Properly declare #[When] as allowed on functions (nicolas-grekas)
 * bug #46171 [VarDumper] Fix dumping floats on PHP8 (nicolas-grekas)
 * bug #46170 Fix dumping enums on PHP 8.2 (nicolas-grekas)
 * bug #46143 [Cache] Prevent fatal errors on php 8 when running concurrently with TagAwareAdapter v6.1 (sbelyshkin)
 * bug #45896 [Cache] Optimize caching of tags (sbelyshkin)
 * bug #46149 Modify processing of uploaded files to be compatible with PHP 8.1 (p-golovin)
 * feature #46112 [DependencyInjection] Rename `#[InnerService]` to `#[MapDecorated]` (chalasr)
 * bug #46125 [FrameworkBundle] Always add CacheCollectorPass (fancyweb)
 * feature #45989 [FrameworkBundle] deprecate not setting http_method_override (Tobion)
 * feature #46042 [Routing] Add params variable to condition expression (HypeMC)
 * feature #46115 [FrameworkBundle] Add support for route attributes in kernel controller methods (dunglas)
 * bug #46121 Fix "Notice: Undefined index: headers" in messenger with Oracle (rjd22)
 * feature #45834 [DependencyInjection] add AsDecorator class attribute and InnerService parameter attribute (Jean-Beru)
 * bug #46106 [String] Fix ansi escape sequences regex (fancyweb)
 * feature #46056 [PropertyInfo] Add support for promoted properties in PhpStanExtractor (simPod)
 * feature #46047 [Notifier] smsapi - send messages in test mode (Patryk Kozłowski)
 * bug #46097 [Routing] fix router base url when default uri has trailing slash (Tobion)
 * feature #46052 [TwigBundle] Deprecate option "autoescape", use "autoescape_service[_method]" instead (nicolas-grekas)
 * bug #46054 [SecurityBundle] Use config's secret in remember-me signatures (jderusse)
 * feature #45528 [Routing] Add Requirement, a collection of universal regular-expressions constants to use as route parameter requirements (fancyweb)
 * bug #46051 Don't replace symfony/security-guard (derrabus)

* 6.1.0-BETA1 (2022-04-15)

 * feature #44798 [FrameworkBundle] Integrate the HtmlSanitizer component (tgalopin, wouterj)
 * feature #46045 [Translation] Improve LocaleSwitcher a bit (nicolas-grekas)
 * feature #42403 [Validator] Define which collection keys should be checked for uniqueness (wkania)
 * feature #44405 [Routing] Allow using services in the route condition (renanbr)
 * feature #46009 [FrameworkBundle] Add support for first-class callable route controller in MicroKernelTrait (fancyweb)
 * feature #44155 [FrameworkBundle] Add semaphore configuration (jderusse)
 * feature #45803 [Routing] Add EnumRequirement to help generate route requirements from a \BackedEnum (fancyweb)
 * feature #45724 [FrameworkBundle] Add support to set BinaryFileResponse::trustXSendfileTypeHeader over config (alexander-schranz)
 * feature #45092 [HttpFoundation] Send `Content-Length` when calling `Response::send()` and the content is a non-empty string (nicolas-grekas)
 * feature #45967 [Messenger] Consume a PSR-14 dispatcher for dispatching events (derrabus)
 * feature #45951 [Notifier] [OvhCloud] Add `no_stop_clause` to DSN (alamirault)
 * feature #45795 [ExpressionLanguage] Add support for null-safe operator (mytuny)
 * feature #45605 [Form] Add prototype_options to CollectionType (michaelKaefer)
 * feature #45912 [ExpressionLanguage] Add some more operators (fabpot)
 * feature #45656 [Serializer] Add serializer profiler (mtarld)
 * feature #45072 [Validator] Allow creating constraints with required arguments (norkunas)
 * feature #43239 [Finder] Look for gitignore patterns up to git root (julienfalque)
 * feature #45845 [TwigBundle]  Pre-compile only *.twig files in cache warmup (GromNaN)
 * feature #44446 [Mailer] Improve extensibility of `EsmtpTransport` (ampaze)
 * feature #45226 [PhpUnitBridge] Add option `ignoreFile` to configure a file that lists deprecation messages to ignore (mondrake)
 * feature #43163 [Messenger] Add Redis Sentinel support (norbertschultheisz)
 * feature #43701 [HttpKernel] Simplifying Bundle/Extension config definition (yceruto)
 * feature #45873 [HttpFoundation] Allow dynamic session "ttl" when using a remote storage (nicolas-grekas)
 * feature #45878 [DependencyInjection] Add argument type `closure` to help passing closures to services (nicolas-grekas)
 * feature #44898 [Ldap] LDAP authentication should return a meaningful error when the LDAP server is unavailable (Jayfrown)
 * feature #45090 [Validator] Improve Image constraint invalid mime type message (fancyweb)
 * feature #42997 [Cache] Improve reliability and performance of `TagAwareAdapter` by making tag versions an integral part of item value (Sergey Belyshkin, nicolas-grekas)
 * feature #45512 [DependencyInjection] Allow using expressions as service factories (nicolas-grekas, jvasseur)
 * feature #45273 [Messenger] Allow AsMessageHandler attribute on methods (mjpvandenberg, fabpot)
 * feature #44284 [SecurityBundle] Display the inherited roles of the logged-in user in the WDT (jmsche)
 * feature #44303 Add Engagespot bridge (danut007ro)
 * feature #44532 Handle CSV DSN in ZookeeperStore (qkdreyer)
 * feature #45047 [Notifier] Use Importance level to set flash message type (benr77, fabpot)
 * feature #45166 [HttpFoundation] add stale while revalidate cache header (remieuronews)
 * feature #45195 [Notifier] Add Sendberry notifier bridge (StaffNowa)
 * feature #45793 [FrameworkBundle][Translation] add `LocaleSwitcher` service (kbond)
 * feature #45833 [HttpKernel] Add Http Status 423 LockedHttpException (xosofox)
 * feature #45705 [FrameworkBundle] Deprecate the messenger.reset_on_message config option (upyx)
 * feature #45812 [HttpClient] Improve default content-type handling (nicolas-grekas)
 * feature #45783 [DependencyInjection] adjust `Autowire` attribute implementation (kbond)
 * feature #44171 [Config] Add comment on array methods (jderusse)
 * feature #45657 [DependencyInjection] add `Autowire` parameter attribute (kbond)
 * feature #45725 [Finder] Fix SplFileInfo PHPDoc (InvisibleSmiley)
 * feature #44948 [Console] Add completion values to input definition (GromNaN)
 * feature #45745 [ErrorHandler][HttpKernel] Read SYMFONY_IDE to render exception in case of fatal error (GromNaN)
 * feature #45765 Mailer - Display email recipients in Profiler (raziel057)
 * feature #45094 Add generics to ArgumentMetadata::getAttributes (Seldaek)
 * feature #45761 Throw access denied if CurrentUser cannot be resolved instead of a 500 (Seldaek)
 * feature #45680 [DependencyInjection] use `#[Required]` for `ServiceSubscriberTrait::setContainer()` (kbond)
 * feature #45624 [Config] Allow using environment variables in `EnumNode` (ecourtial)
 * feature #45484 Make constraint violation interfaces stringable (HypeMC)
 * feature #43931 [HttpClient][WebProfilerBundle] Add button to copy a request as a cURL command (Deuchnord)
 * feature #45515 [BrowserKit] Add `toArray` to `Response` (HypeMC)
 * feature #45658 [Routing] Avoid double encoded slashes in query parameters (usu)
 * feature #45062 [PropertyInfo] Add PHP 8.0 promoted properties `@param` mutation support to PhpDocExtractor (raphaelvoisin)
 * feature #44522 [Messenger] add TransportMessageIdStamp to RedisSender (GaryPEGEOT)
 * feature #45623 [Validator] Deprecate constraint "ExpressionLanguageSyntax", use "ExpressionSyntax" instead (mpiot)
 * feature #45563 Deprecate requiring the "symfony/symfony" package (nicolas-grekas)
 * feature #45616 [HttpClient] Remove credentials from requests redirected to same host but different port (GromNaN)
 * feature #45377 Bump minimum version of PHP to 8.1 (nicolas-grekas)
 * feature #45421  [Translation] Add the possibilty to export xliff translation with the .xliff suffix (DanielBadura)
 * feature #45152 Ability to customize payload when sending mail through mailjet+api (gam6itko)
 * feature #44665 [HttpKernel] Add the UidValueResolver argument value resolver (fancyweb)
 * feature #44073 [ExpressionLanguage] Support lexing numbers with underscores and decimals with no leading zero (fancyweb)
 * feature #44721 [Serializer] Deprecate support for abstract uid denormalization in UidNormalizer (fancyweb)
 * feature #44615 [Routing] Support the "attribute" type (alias of "annotation") in annotation loaders (fancyweb)
 * feature #45265 [HttpKernel] Add Profiler::isEnabled() method (Bilge)
 * feature #45449 [Mime] Added getter for "TextPart::$name" (MasterRO94)
 * feature #45402 make Message classes extensible (bitgandtter)
 * feature #45476 [HttpKernel] Deprecate StreamedResponseListener, it serves no purpose anymore (nicolas-grekas)
 * feature #45436 [Messenger] Support setting `connection_name` for AMQP (a.dmitryuk)
 * feature #45450 [DependencyInjection] Add an env function to DI expression language (jvasseur)
 * feature #45388 [Mailer] Allow manually start() of SmtpTransport (jannick-holm)
 * feature #45376 [Mime] Fix embed logic for background attributes (flack)
 * feature #45360 [ErrorHandler] trigger deprecations for ``@final`` properties (nicolas-grekas, fancyweb)
 * feature #45371 [Validator] Deprecate `Constraint::$errorNames` in favor of `Constraint::ERROR_NAMES` (nicolas-grekas)
 * feature #44692 [Cache][FrameworkBundle] add `cache:pool:invalidate-tags` command (kbond)
 * feature #45361 [Console] Deprecate the `$defaultName` property (derrabus)
 * feature #45313 [Cache] Add support for ACL auth in RedisAdapter (gam6itko)
 * feature #45303 [ErrorHandler] Report overridden @final constants (fancyweb)
 * feature #44484 [Translation] [Loco] Send `If-Modified-Since` header when possible (Kocal)
 * feature #45307 [Mailer] Allow manually stop() of SmtpTransport (dvaeversted)
 * feature #43973 [Serializer] Add context builders (mtarld)
 * feature #45222 [Mailer] Implement EmailTags for Amazon Mailer (driesvints, kbond)
 * feature #44670 [SecurityBundle] Allow to specify a RequestMatcher directly in an ACL definition (TristanPouliquen)
 * feature #45139 [Notifier] smsapi-notifier `fast` option to sending message with the highest priority (marphi)
 * feature #45155 [Serializer] Set context annotation as not final (benjaminmal)
 * feature #44503 [FrameworkBundle] Allow PHP configuration in config/packages by default (dreadnip)
 * feature #45101 [Form] Add inputmode attribute on NumberType (welcoMattic)
 * feature #45075 [Routing] Enrich MissingMandatoryParametersException (adrienlucas)
 * feature #45064 [Messenger] Add sessionToken option to SQS transport (filkaris)
 * feature #44917 [Mailer] Add downloadable attachments to profiler (dbrekelmans)
 * feature #45054 [Routing] Allow using UTF-8 parameter names (nicolas-grekas)
 * feature #44360 [Notifier] [Bridge] [KazInfoTeh] added the bridge (taranovegor)
 * feature #44874 [Notifier] Added 46elks notifier bridge (jongotlin)
 * feature #44913 [Notifier] Add Orange SMS bridge (enigma972)
 * feature #44971 [Messenger] Resolve handled classes when only method in tag is provided (angelov)
 * feature #43982 [Messenger][Serializer] Deprecate "context aware" interfaces (mtarld)
 * feature #44790 [Serializer] Give more hints when an attribute is not correctly used (lyrixx)
 * feature #44831 [HttpKernel] Add a controller argument resolver for backed enums (ogizanagi)
 * feature #44589 [Messenger] add SerializedMessageStamp (nikophil)
 * feature #41750 [Yaml] Double-quote strings with single quote marks (Ostrzyciel)
 * feature #44774 Add `exclude` to `TaggedIterator` and `TaggedLocator` (ruudk)
 * feature #44681 [HtmlSanitizer] Introduce HtmlSanitizer component (tgalopin)
 * feature #44311 [Mime] add DraftEmail (kbond)
 * feature #44746 [Console] Add method `__toString()` to `InputInterface` (boesing)
 * feature #44568 [HttpClient] Allow yielding Exception from MockResponse's  $body to mock transport errors (fancyweb)
 * feature #44672 [Translation] Translatable parameters (sylfabre)
 * feature #44451 [PropertyInfo] Add support for phpDocumentor and PHPStan pseudo-types (EmilMassey)
 * feature #44575 [Framework] Read env var SYMFONY_IDE by default for framework.ide (GromNaN)
 * feature #43641 [Console] Issue 43602 : Add fish completion (guillaume-a)
 * feature #44150 [Assets] Accept empty `base_url`, in order to simplify local dev configuration. (GromNaN)
 * feature #44137 [Mailer] [Mailgun] Allow multiple TagHeaders with MailgunApiTransport (starred-gijs)
 * feature #44543 [HttpFoundation] Update cookie date time format (chapterjason)
 * feature #44483 [HttpKernel][WebProfilerBundle] adding xdebug_info page to webprofilerbundle (chr-hertel)

