<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Form\Tests\Util;

use Symfony\Component\Form\Util\FormUtil;

class FormUtilTest extends \PHPUnit_Framework_TestCase
{
    public function isChoiceGroupProvider()
    {
        return array(
            array(false, 0),
            array(false, '0'),
            array(false, '1'),
            array(false, 1),
            array(false, ''),
            array(false, null),
            array(false, true),

            array(true, array()),
        );
    }

    /**
     * @dataProvider isChoiceGroupProvider
     */
    public function testIsChoiceGroup($expected, $value)
    {
        $this->assertSame($expected, FormUtil::isChoiceGroup($value));
    }

    public function testIsChoiceGroupPart2()
    {
        $this->assertTrue(FormUtil::isChoiceGroup(new \SplFixedArray(1)));
    }

    public function isChoiceSelectedProvider()
    {
        // The commented cases should not be necessary anymore, because the
        // choice lists should assure that both values passed here are always
        // strings
        return array(
//             array(true, 0, 0),
            array(true, '0', '0'),
            array(true, '1', '1'),
//             array(true, false, 0),
//             array(true, true, 1),
            array(true, '', ''),
//             array(true, null, ''),
            array(true, '1.23', '1.23'),
            array(true, 'foo', 'foo'),
            array(true, 'foo10', 'foo10'),
            array(true, 'foo', array(1, 'foo', 'foo10')),

            array(false, 10, array(1, 'foo', 'foo10')),
            array(false, 0, array(1, 'foo', 'foo10')),
        );
    }

    /**
     * @dataProvider isChoiceSelectedProvider
     */
    public function testIsChoiceSelected($expected, $choice, $value)
    {
        $this->assertSame($expected, FormUtil::isChoiceSelected($choice, $value));
    }

    public function singularifyProvider()
    {
        // see http://english-zone.com/spelling/plurals.html
        // see http://www.scribd.com/doc/3271143/List-of-100-Irregular-Plural-Nouns-in-English
        return array(
            array('tags', 'tag'),
            array('alumni', 'alumnus'),
            array('funguses', array('fungus', 'funguse', 'fungusis')),
            array('fungi', 'fungus'),
            array('axes', array('ax', 'axe', 'axis')),
            array('appendices', array('appendex', 'appendix')),
            array('indices', array('index', 'indix')),
            array('indexes', 'index'),
            array('children', 'child'),
            array('men', 'man'),
            array('women', 'woman'),
            array('oxen', 'ox'),
            array('bacteria', array('bacterion', 'bacterium')),
            array('criteria', array('criterion', 'criterium')),
            array('feet', 'foot'),
            array('nebulae', 'nebula'),
            array('babies', 'baby'),
            array('hooves', 'hoof'),
            array('chateaux', 'chateau'),
            array('echoes', array('echo', 'echoe')),
            array('analyses', array('analys', 'analyse', 'analysis')),
            array('theses', array('thes', 'these', 'thesis')),
            array('foci', 'focus'),
            array('focuses', array('focus', 'focuse', 'focusis')),
            array('oases', array('oas', 'oase', 'oasis')),
            array('matrices', array('matrex', 'matrix')),
            array('matrixes', 'matrix'),
            array('bureaus', 'bureau'),
            array('bureaux', 'bureau'),
            array('beaux', 'beau'),
            array('data', array('daton', 'datum')),
            array('phenomena', array('phenomenon', 'phenomenum')),
            array('strata', array('straton', 'stratum')),
            array('geese', 'goose'),
            array('teeth', 'tooth'),
            array('antennae', 'antenna'),
            array('antennas', 'antenna'),
            array('houses', array('hous', 'house', 'housis')),
            array('arches', array('arch', 'arche')),
            array('atlases', array('atlas', 'atlase', 'atlasis')),
            array('batches', array('batch', 'batche')),
            array('bushes', array('bush', 'bushe')),
            array('buses', array('bus', 'buse', 'busis')),
            array('calves', 'calf'),
            array('circuses', array('circus', 'circuse', 'circusis')),
            array('crises', array('cris', 'crise', 'crisis')),
            array('dwarves', 'dwarf'),
            array('elves', 'elf'),
            array('emphases', array('emphas', 'emphase', 'emphasis')),
            array('faxes', 'fax'),
            array('halves', 'half'),
            array('heroes', array('hero', 'heroe')),
            array('hoaxes', 'hoax'),
            array('irises', array('iris', 'irise', 'irisis')),
            array('kisses', array('kiss', 'kisse', 'kissis')),
            array('knives', 'knife'),
            array('lives', 'life'),
            array('lice', 'louse'),
            array('mice', 'mouse'),
            array('neuroses', array('neuros', 'neurose', 'neurosis')),
            array('plateaux', 'plateau'),
            array('poppies', 'poppy'),
            array('quizzes', 'quiz'),
            array('scarves', 'scarf'),
            array('spies', 'spy'),
            array('stories', 'story'),
            array('syllabi', 'syllabus'),
            array('thieves', 'thief'),
            array('waltzes', array('waltz', 'waltze')),
            array('wharves', 'wharf'),
            array('wives', 'wife'),
            array('ions', 'ion'),
            array('bases', array('bas', 'base', 'basis')),
            array('cars', 'car'),
            array('cassettes', array('cassett', 'cassette')),
            array('lamps', 'lamp'),
            array('hats', 'hat'),
            array('cups', 'cup'),
            array('boxes', 'box'),
            array('sandwiches', array('sandwich', 'sandwiche')),
            array('suitcases', array('suitcas', 'suitcase', 'suitcasis')),
            array('roses', array('ros', 'rose', 'rosis')),
            array('garages', array('garag', 'garage')),
            array('shoes', array('sho', 'shoe')),
            array('days', 'day'),
            array('boys', 'boy'),
            array('roofs', 'roof'),
            array('cliffs', 'cliff'),
            array('sheriffs', 'sheriff'),
            array('discos', 'disco'),
            array('pianos', 'piano'),
            array('photos', 'photo'),
            array('trees', array('tre', 'tree')),
            array('bees', array('be', 'bee')),
            array('cheeses', array('chees', 'cheese', 'cheesis')),
            array('radii', 'radius'),

            // test casing: if the first letter was uppercase, it should remain so
            array('Men', 'Man'),
            array('GrandChildren', 'GrandChild'),
            array('SubTrees', array('SubTre', 'SubTree')),
        );
    }

    /**
     * @dataProvider singularifyProvider
     */
    public function testSingularify($plural, $singular)
    {
        $this->assertEquals($singular, FormUtil::singularify($plural));
    }
}
