<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Messenger\Event;

use Symfony\Component\Messenger\Envelope;

abstract class AbstractWorkerMessageEvent
{
    private $envelope;
    private $receiverName;

    public function __construct(Envelope $envelope, string $receiverName)
    {
        $this->envelope = $envelope;
        $this->receiverName = $receiverName;
    }

    public function getEnvelope(): Envelope
    {
        return $this->envelope;
    }

    /**
     * Returns a unique identifier for transport receiver this message was received from.
     */
    public function getReceiverName(): string
    {
        return $this->receiverName;
    }
}
