# Changelog

All notable changes to `phpunit-snapshot-assertions` will be documented in this file

## 5.2.1 - 2025-07-02

### What's Changed

* Bump dependabot/fetch-metadata from 2.3.0 to 2.4.0 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/213
* Bump stefanzweifel/git-auto-commit-action from 5 to 6 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/215
* Allow `assertMatchesJsonSnapshot` to accept any JSON-serializable value by @LuckyWindsck in https://github.com/spatie/phpunit-snapshot-assertions/pull/216

### New Contributors

* @LuckyWindsck made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/216

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.2.0...5.2.1

## 5.2.0 - 2025-05-08

### What's Changed

* Allow setting yamlInline for ObjectDriver by @tassilogroeper in https://github.com/spatie/phpunit-snapshot-assertions/pull/212

### New Contributors

* @tassilogroeper made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/212

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.1.8...5.2.0

## 5.1.8 - 2025-02-10

### What's Changed

* Bump dependabot/fetch-metadata from 2.2.0 to 2.3.0 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/207
* Bump aglipanci/laravel-pint-action from 2.4 to 2.5 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/208
* Allow phpunit 12 by @mfruehauf in https://github.com/spatie/phpunit-snapshot-assertions/pull/209

### New Contributors

* @mfruehauf made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/209

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.1.7...5.1.8

## 5.1.7 - 2024-12-09

### What's Changed

* Bump dependabot/fetch-metadata from 2.1.0 to 2.2.0 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/203
* Bump oven-sh/setup-bun from 1 to 2 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/202
* gha: run tests against PHP 8.4 too by @erikn69 in https://github.com/spatie/phpunit-snapshot-assertions/pull/204
* Improve readability of generated JSON snapshots by @ostrolucky in https://github.com/spatie/phpunit-snapshot-assertions/pull/205

### New Contributors

* @erikn69 made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/204
* @ostrolucky made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/205

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.1.6...5.1.7

## 4.2.17 - 2024-05-03

### What's Changed

* Update symfony version in deps by @Niolak in https://github.com/spatie/phpunit-snapshot-assertions/pull/196
* Fix/v4 permissions snapshot files by @Niolak in https://github.com/spatie/phpunit-snapshot-assertions/pull/201

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.16...4.2.17

## 5.1.6 - 2024-05-03

### What's Changed

* Minor updates and improvements by @patinthehat in https://github.com/spatie/phpunit-snapshot-assertions/pull/192
* Bump aglipanci/laravel-pint-action from 2.3.1 to 2.4 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/194
* Bump dependabot/fetch-metadata from 2.0.0 to 2.1.0 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/200
* chmod snapshot folders and files by @Niolak in https://github.com/spatie/phpunit-snapshot-assertions/pull/199

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.1.5...5.1.6

## 5.1.5 - 2024-02-20

### What's Changed

* gha: run tests against PHP 8.3 too by @mfn in https://github.com/spatie/phpunit-snapshot-assertions/pull/188
* Use PHPUnit attributes by @simonhammes in https://github.com/spatie/phpunit-snapshot-assertions/pull/187

### New Contributors

* @simonhammes made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/187

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.1.4...5.1.5

## 5.1.4 - 2024-02-03

### What's Changed

* Bump aglipanci/laravel-pint-action from 2.3.0 to 2.3.1 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/183
* Allow phpunit 11 by @mfn in https://github.com/spatie/phpunit-snapshot-assertions/pull/185

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.1.3...5.1.4

## 5.1.3 - 2023-11-29

### What's Changed

* Bump actions/setup-node from 3 to 4 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/181
* Symfony 7.0 by @janatjak in https://github.com/spatie/phpunit-snapshot-assertions/pull/182

### New Contributors

* @janatjak made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/182

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.1.2...5.1.3

## 5.1.2 - 2023-10-11

### What's Changed

- Bump actions/setup-node from 2 to 3 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/176
- fix: correct typo in readme by @TSchuermans in https://github.com/spatie/phpunit-snapshot-assertions/pull/178
- Fix #179 - assert difference between empty array and object. by @Sam152 in https://github.com/spatie/phpunit-snapshot-assertions/pull/180
- Bump stefanzweifel/git-auto-commit-action from 4 to 5 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/177

### New Contributors

- @TSchuermans made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/178
- @Sam152 made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/180

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.1.1...5.1.2

## 5.1.1 - 2023-09-12

- fix image driver

## 5.1.0 - 2023-09-11

### What's Changed

- Add image assertions by @freekmurze in https://github.com/spatie/phpunit-snapshot-assertions/pull/175

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.0.2...5.1.0

## 5.0.1 - 2023-02-13

### What's Changed

- Generate snapshot file names with dataset by @pierres in https://github.com/spatie/phpunit-snapshot-assertions/pull/163
- Bump aglipanci/laravel-pint-action from 0.1.0 to 2.1.0 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/164
- Update windows users info in readme.md by @raveren in https://github.com/spatie/phpunit-snapshot-assertions/pull/150

### New Contributors

- @pierres made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/163
- @raveren made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/150

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/5.0.0...5.0.1

## 5.0.0 - 2023-02-09

### What's Changed

- Add Dependabot Automation by @patinthehat in https://github.com/spatie/phpunit-snapshot-assertions/pull/152
- Add PHP 8.2 Support by @patinthehat in https://github.com/spatie/phpunit-snapshot-assertions/pull/151
- Bump actions/checkout from 2 to 3 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/153
- Bump dependabot/fetch-metadata from 1.3.5 to 1.3.6 by @dependabot in https://github.com/spatie/phpunit-snapshot-assertions/pull/159
- Fix badge with `run-tests` status in `README.md` by @gomzyakov in https://github.com/spatie/phpunit-snapshot-assertions/pull/160
- add support for PHPUnit v10 by @freekmurze in https://github.com/spatie/phpunit-snapshot-assertions/pull/154

### New Contributors

- @patinthehat made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/152
- @dependabot made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/153
- @gomzyakov made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/160

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.16...5.0.0

## 4.2.16 - 2022-10-10

### What's Changed

- serialize empty HTML by @Khartir in https://github.com/spatie/phpunit-snapshot-assertions/pull/148

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.15...4.2.16

## 4.2.15 - 2022-08-25

### What's Changed

- Apply PCRE_UTF8 for cleaning filename by @su-kun1899 in https://github.com/spatie/phpunit-snapshot-assertions/pull/147

### New Contributors

- @su-kun1899 made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/147

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.14...4.2.15

## 4.2.14 - 2022-07-29

### What's Changed

- Add tests for Text Driver and Windows EOL fixes by @mallardduck in https://github.com/spatie/phpunit-snapshot-assertions/pull/146

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.13...4.2.14

## 4.2.13 - 2022-06-26

### What's Changed

- Add test to cover HTML without doctype by @mallardduck in https://github.com/spatie/phpunit-snapshot-assertions/pull/144
- Add type safe json matching by @cschindl in https://github.com/spatie/phpunit-snapshot-assertions/pull/145

### New Contributors

- @cschindl made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/145

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.12...4.2.13

## 4.2.12 - 2022-05-31

### What's Changed

- Use `LIBXML_HTML_NODEFDTD` to maintain output consistency by @JayBizzle in https://github.com/spatie/phpunit-snapshot-assertions/pull/141

### New Contributors

- @JayBizzle made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/141

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.11...4.2.12

## 4.2.11 - 2022-03-18

## What's Changed

- revert match process in JsonDriver by @Stevemoretz in https://github.com/spatie/phpunit-snapshot-assertions/pull/138

## New Contributors

- @Stevemoretz made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/138

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.10...4.2.11

## 4.2.10 - 2022-02-08

## What's Changed

- Normalize windows line endings on HTML tests by @mallardduck in https://github.com/spatie/phpunit-snapshot-assertions/pull/136

## New Contributors

- @mallardduck made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/136

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.9...4.2.10

## 4.2.9 - 2021-12-03

## What's Changed

- Do not convert stdClass to array && remove outdated piece of code by @alshenetsky in https://github.com/spatie/phpunit-snapshot-assertions/pull/134

## New Contributors

- @alshenetsky made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/134

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.8...4.2.9

## 4.2.8 - 2021-12-02

## What's Changed

- Update php-cs-fixer config by @gndk in https://github.com/spatie/phpunit-snapshot-assertions/pull/132
- Allow Symfony 6.0 by @gndk in https://github.com/spatie/phpunit-snapshot-assertions/pull/133

## New Contributors

- @gndk made their first contribution in https://github.com/spatie/phpunit-snapshot-assertions/pull/132

**Full Changelog**: https://github.com/spatie/phpunit-snapshot-assertions/compare/4.2.7...4.2.8

## 4.2.7 - 2021-07-09

- clean filenames on MatchesFileSnapshot for Windows (#130)

## 4.2.6 - 2021-04-20

- allow using env vars to manage snapshot creation and update (#126)

## 4.2.5 - 2021-01-27

- add support for PHP 7.3

## 4.2.4 - 2020-11-26

- add support for PHP 8

## 4.2.3 - 2020-11-03

- migrate phpunit config

## 4.2.2 - 2020-06-01

- moves default implementation of snapshot directory/id to concerns directory (#99)

## 4.2.1 - 2020-05-18

- Fix exception message

## 4.2.0 - 2020-05-11

- Fixed inconsistent line endings
- Improved Windows support

## 4.1.0 - 2020-04-08

- Added `--without-creating-snapshots` flag

## 4.0.0 - 2020-02-11

*Snapshots generated with `assertMatchesSnapshot` will break when upgrading to this version. The easiest way to upgrade is to ensure your snapshot tests pass, delete your snapshots, upgrade the package, then rerun the tests to generate new snapshots.*

- New snapshot formats when using `assertMatchesSnapshot`: scalars (strings, integers & floats) are serialized to `txt` files, objects & arrays are serialized to `yaml` files
- New `TextDriver` to store snapshots in `txt` files
- New `ObjectDriver` to serialize data to YAML and store snapshots in `yaml` files
- Removed `VarDriver`

## 3.1.1 - 2019-02-10

- Add support for PHPUnit 9 (#86)

## 3.1.0 - 2019-12-02

- Drop support for PHP 7.3

## 3.0.0 - 2019-11-22

- `assertMatchesJsonSnapshot` now supports all JSON serializable objects, and won't convert empty arrays to obejcts anymore

## 2.2.1 - 2019-11-22

- Allow symfony 5 components

## 2.2.0 - 2019-10-23

- Added an `assertMatchesHtmlSnapshot` assertion

## 2.1.3 - 2019-08-07

- Allow recursive mkdir for file snapshots

## 2.1.2 - 2019-03-27

- Less restrictive symfony/yaml version requirement

## 2.1.1 - 2019-03-04

- Fix for json driver

## 2.1.0 - 2019-02-07

- Require PHPUnit 8 & PHP 7.2

## 2.0.0 - 2019-01-29

- Use YAML by default for associative arrays
- Drop PHP 7.0 support, the new constraint is ^7.1
- Drop PHPUnit ^6.5 support, the new constraint is ^7.0

## 1.4.1 - 2019-01-29

- Fix JSON array comparisons

## 1.4.0 - 2019-01-29

- Allow arrays to be serialized to JSON

## 1.3.3 - 2018-12-15

- Fix updating failed file-snapshots

## 1.3.2 - 2018-10-18

- Fix for tests with weird characters

## 1.3.1 - 2018-06-09

- Lowered minimum required PHPUnit version

## 1.3.0 - 2018-05-22

- Only mark test incomplete after every snapshot has been run

## 1.2.3 - 2018-03-15

- Fixed snapshot creation in recursive directories

## 1.2.2 - 2018-02-17

- Support PHP 7.2

## 1.2.1 - 2018-02-02

- Support phpunit ^7.0

## 1.2.0 - 2017-11-29

- Added `assertMatchesFileSnapshot`

## 1.1.1 - 2017-10-11

- Fixed `assertMatchesFileHashSnapshot`

## 1.1.0 - 2017-10-07

- Added `assertMatchesFileHashSnapshot` assertion

## 1.0.2 - 2017-09-11

- Added `example` folder to `.gitattributes`

## 1.0.1 - 2017-06-23

- Fixed expected and actual argument order when making json assertions

## 1.0.0 - 2017-05-29

- Added a reminder how to update snapshots when a snapshot assertion fails

## 0.4.1 - 2017-03-27

- Initial release
