# Changelog

## [3.4.1](https://github.com/snc/SncRedisBundle/tree/HEAD)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.4.0...HEAD)

**Fixed bugs:**

- falsy "failed \(MOVED\)" error logs when using cluster mode \(following \#416\) [\#466](https://github.com/snc/SncRedisBundle/issues/466)

**Closed issues:**

- Memory leak with logging: true [\#626](https://github.com/snc/SncRedisBundle/issues/626)
- SessionHandler configuration deprecation [\#624](https://github.com/snc/SncRedisBundle/issues/624)
- Logging in cluster mode works only for first query [\#615](https://github.com/snc/SncRedisBundle/issues/615)

**Merged pull requests:**

- Fix tests and doctrine-bundle 2.4 compatibility [\#627](https://github.com/snc/SncRedisBundle/pull/627) ([ostrolucky](https://github.com/ostrolucky))
- Fix predis RedisCluster logging [\#619](https://github.com/snc/SncRedisBundle/pull/619) ([ostrolucky](https://github.com/ostrolucky))
- Do not falsily classify MOVED responses in logs as errors [\#616](https://github.com/snc/SncRedisBundle/pull/616) ([ostrolucky](https://github.com/ostrolucky))

## [3.4.0](https://github.com/snc/SncRedisBundle/tree/3.4.0) (2021-05-25)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.3.0...3.4.0)

**Merged pull requests:**

- Add json serialization type for phpredis [\#609](https://github.com/snc/SncRedisBundle/pull/609) ([xElysioN](https://github.com/xElysioN))

## [3.3.0](https://github.com/snc/SncRedisBundle/tree/3.3.0) (2021-01-12)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.2.4...3.3.0)

**Closed issues:**

- TLS - Certificate verify failed [\#598](https://github.com/snc/SncRedisBundle/issues/598)
- Hi. snc\_redis removed after composer update [\#597](https://github.com/snc/SncRedisBundle/issues/597)
- How to force reconnection on redis timeout? [\#595](https://github.com/snc/SncRedisBundle/issues/595)

**Merged pull requests:**

- Add support for PHP 8 [\#599](https://github.com/snc/SncRedisBundle/pull/599) ([nicwortel](https://github.com/nicwortel))
- Support nested DSNs generated by process environment variables [\#594](https://github.com/snc/SncRedisBundle/pull/594) ([nesk](https://github.com/nesk))

## [3.2.4](https://github.com/snc/SncRedisBundle/tree/3.2.4) (2020-11-07)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.2.3...3.2.4)

**Closed issues:**

- Understand doctrine's configuration [\#591](https://github.com/snc/SncRedisBundle/issues/591)
- TTL for doctrine cache [\#590](https://github.com/snc/SncRedisBundle/issues/590)
- Update README in regards to Predis [\#589](https://github.com/snc/SncRedisBundle/issues/589)
- php 7.4 + phpredis 5 support [\#583](https://github.com/snc/SncRedisBundle/issues/583)
- Disable bundle in test [\#582](https://github.com/snc/SncRedisBundle/issues/582)
- Allow specifying lifetime for caches or create command to clear all items? [\#575](https://github.com/snc/SncRedisBundle/issues/575)
- Prefixing with Predis [\#574](https://github.com/snc/SncRedisBundle/issues/574)

**Merged pull requests:**

- 🐛 Fix declaration of zAdd\(\) for phpredis 5.2.1 of ClientCluster [\#596](https://github.com/snc/SncRedisBundle/pull/596) ([B-Galati](https://github.com/B-Galati))
- Fix Symfony cache pool example [\#588](https://github.com/snc/SncRedisBundle/pull/588) ([derrabus](https://github.com/derrabus))
- Support phpredis 5.2.1 [\#587](https://github.com/snc/SncRedisBundle/pull/587) ([nesk](https://github.com/nesk))
- Update Changelog for 3.2.3 release [\#581](https://github.com/snc/SncRedisBundle/pull/581) ([B-Galati](https://github.com/B-Galati))

## [3.2.3](https://github.com/snc/SncRedisBundle/tree/3.2.3) (2020-06-05)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.2.2...3.2.3)

**Closed issues:**

- Lazy config is not working with phpredis. [\#578](https://github.com/snc/SncRedisBundle/issues/578)
- How to inject @snc\_redis in my controller ? [\#576](https://github.com/snc/SncRedisBundle/issues/576)
- Cache cleared exclude sessions [\#568](https://github.com/snc/SncRedisBundle/issues/568)

**Merged pull requests:**

- Deprecation since Symfony 5.1: NodeDefinition::setDeprecated\(\) requires 3 arguments [\#580](https://github.com/snc/SncRedisBundle/pull/580) ([StudioMaX](https://github.com/StudioMaX))

## [3.2.2](https://github.com/snc/SncRedisBundle/tree/3.2.2) (2020-04-30)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.13...3.2.2)

**Implemented enhancements:**

- Secure connection via phpredis doesn't work [\#562](https://github.com/snc/SncRedisBundle/issues/562)

**Closed issues:**

- Declaration ClientCluster::flushAll not compatible [\#572](https://github.com/snc/SncRedisBundle/issues/572)
- php\_network\_getaddresses: getaddrinfo failed: Name or service not known [\#570](https://github.com/snc/SncRedisBundle/issues/570)
- "snc\_redis.session.handler" has a dependency on a non-existent      service "snc\_redis.session" [\#569](https://github.com/snc/SncRedisBundle/issues/569)
- Does not work with API Platform, Docker Builds [\#560](https://github.com/snc/SncRedisBundle/issues/560)
- BC break: zAdd does not support adding multiple members at once [\#559](https://github.com/snc/SncRedisBundle/issues/559)
- Configure doctrine metadata cache with multiple entity manager [\#555](https://github.com/snc/SncRedisBundle/issues/555)
- PHP 7.4 deprecation [\#549](https://github.com/snc/SncRedisBundle/issues/549)
- Attempted to load class "Redis" from namespace "ContainerMlRinL0" with Symfony 4.4 [\#548](https://github.com/snc/SncRedisBundle/issues/548)
- Document how to use this bundle with the Symfony Cache component. [\#291](https://github.com/snc/SncRedisBundle/issues/291)
- Register Custom Command [\#92](https://github.com/snc/SncRedisBundle/issues/92)

**Merged pull requests:**

- fix: ClientCluster::flushall compatibility with redis extension [\#573](https://github.com/snc/SncRedisBundle/pull/573) ([firnas](https://github.com/firnas))
- Update 2.0.0 upgrade notes [\#567](https://github.com/snc/SncRedisBundle/pull/567) ([gigo6000](https://github.com/gigo6000))
- \[Docs\] Added example for use with Symfony Cache Pools. [\#565](https://github.com/snc/SncRedisBundle/pull/565) ([Basster](https://github.com/Basster))
- Fix deprecation notice about naming strategy [\#564](https://github.com/snc/SncRedisBundle/pull/564) ([B-Galati](https://github.com/B-Galati))
- Support encrypted connection via phpredis [\#563](https://github.com/snc/SncRedisBundle/pull/563) ([benburleson](https://github.com/benburleson))
- Handle default database for persistent connection [\#561](https://github.com/snc/SncRedisBundle/pull/561) ([asilelik](https://github.com/asilelik))
- Add 5.0.x to list of supported versions [\#551](https://github.com/snc/SncRedisBundle/pull/551) ([codysnider](https://github.com/codysnider))

## [2.1.13](https://github.com/snc/SncRedisBundle/tree/2.1.13) (2019-12-09)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.2.1...2.1.13)

## [3.2.1](https://github.com/snc/SncRedisBundle/tree/3.2.1) (2019-11-18)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.2.0...3.2.1)

**Implemented enhancements:**

- Symfony 5 / Doctrine Bundle 2 compat [\#544](https://github.com/snc/SncRedisBundle/pull/544) ([B-Galati](https://github.com/B-Galati))
- Add many DSN support for phpredis cluster [\#542](https://github.com/snc/SncRedisBundle/pull/542) ([B-Galati](https://github.com/B-Galati))
- Add Support for Phpredis\RedisCluster \(\#453\) [\#454](https://github.com/snc/SncRedisBundle/pull/454) ([furester](https://github.com/furester))

**Fixed bugs:**

- Fix data collector sf5 [\#547](https://github.com/snc/SncRedisBundle/pull/547) ([B-Galati](https://github.com/B-Galati))
- Ensure compatibility with Symfony 4.4 \(fix \#461\) [\#543](https://github.com/snc/SncRedisBundle/pull/543) ([B-Galati](https://github.com/B-Galati))

**Merged pull requests:**

- Prepare 3.2.0 changelog [\#546](https://github.com/snc/SncRedisBundle/pull/546) ([B-Galati](https://github.com/B-Galati))
- Prepare 3.1.1 release [\#540](https://github.com/snc/SncRedisBundle/pull/540) ([B-Galati](https://github.com/B-Galati))
- Fix check for connection\_persistent with phpredis factory [\#538](https://github.com/snc/SncRedisBundle/pull/538) ([starred-gijs](https://github.com/starred-gijs))
- Simplify injection of client locator using ServiceLocatorTagPass [\#535](https://github.com/snc/SncRedisBundle/pull/535) ([rpkamp](https://github.com/rpkamp))
- Invalid argument supplied for foreach\(\) fix  [\#534](https://github.com/snc/SncRedisBundle/pull/534) ([imper86](https://github.com/imper86))
- No longer use curly brackets for substring [\#532](https://github.com/snc/SncRedisBundle/pull/532) ([rpkamp](https://github.com/rpkamp))
- Fix a non-existent  service "snc\_redis.phpredis.monolog" [\#531](https://github.com/snc/SncRedisBundle/pull/531) ([phakpoom](https://github.com/phakpoom))
- Autoconfigure RedisBaseCommand to add snc\_redis.command tag [\#528](https://github.com/snc/SncRedisBundle/pull/528) ([maxhelias](https://github.com/maxhelias))
- Fix C&P error in Phpredis Client Proxy Class [\#526](https://github.com/snc/SncRedisBundle/pull/526) ([deegital](https://github.com/deegital))

## [3.2.0](https://github.com/snc/SncRedisBundle/tree/3.2.0) (2019-11-14)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.12...3.2.0)

**Fixed bugs:**

- profiler\_storage not working with Symfony 4 [\#461](https://github.com/snc/SncRedisBundle/issues/461)

**Closed issues:**

- Incompatibility with Symfony 4.4.0-BETA1  [\#545](https://github.com/snc/SncRedisBundle/issues/545)
- Clarification on Cluster Support [\#541](https://github.com/snc/SncRedisBundle/issues/541)
- PhpRedis Cluster [\#453](https://github.com/snc/SncRedisBundle/issues/453)

## [2.1.12](https://github.com/snc/SncRedisBundle/tree/2.1.12) (2019-10-09)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.1.1...2.1.12)

## [3.1.1](https://github.com/snc/SncRedisBundle/tree/3.1.1) (2019-10-09)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.1.0...3.1.1)

**Implemented enhancements:**

- Can't use env variable for type configuration [\#518](https://github.com/snc/SncRedisBundle/issues/518)

**Fixed bugs:**

- Phpredis factory adds wrong parameter for non-persistent connections [\#537](https://github.com/snc/SncRedisBundle/issues/537)
- ClientLocatorPass::createClientLocatorDefinition : add definition without id. [\#520](https://github.com/snc/SncRedisBundle/issues/520)

**Closed issues:**

- New release? [\#539](https://github.com/snc/SncRedisBundle/issues/539)
- Warning: Invalid argument supplied for foreach\(\) [\#536](https://github.com/snc/SncRedisBundle/issues/536)
- Service "snc\_redis.phpredis.monolog" still is used in Monolog When set client type is "phpredis" [\#530](https://github.com/snc/SncRedisBundle/issues/530)

## [3.1.0](https://github.com/snc/SncRedisBundle/tree/3.1.0) (2019-08-01)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.11...3.1.0)

**Fixed bugs:**

- Error on deprecation message [\#523](https://github.com/snc/SncRedisBundle/issues/523)

**Merged pull requests:**

- Add support for env variable for client type [\#525](https://github.com/snc/SncRedisBundle/pull/525) ([alexander-schranz](https://github.com/alexander-schranz))
- Adding metrics to Profiler page [\#517](https://github.com/snc/SncRedisBundle/pull/517) ([stefantalen](https://github.com/stefantalen))

## [2.1.11](https://github.com/snc/SncRedisBundle/tree/2.1.11) (2019-07-31)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.0.0...2.1.11)

**Closed issues:**

- stable 3.x release [\#452](https://github.com/snc/SncRedisBundle/issues/452)

## [3.0.0](https://github.com/snc/SncRedisBundle/tree/3.0.0) (2019-07-28)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.10...3.0.0)

**Implemented enhancements:**

- fix \#249 - fix session handler lock key prefix [\#503](https://github.com/snc/SncRedisBundle/pull/503) ([B-Galati](https://github.com/B-Galati))

**Closed issues:**

- Deprecation in RedisBaseCommand, progress on v3? [\#522](https://github.com/snc/SncRedisBundle/issues/522)
- Predis Client constructed without logger [\#519](https://github.com/snc/SncRedisBundle/issues/519)

## [2.1.10](https://github.com/snc/SncRedisBundle/tree/2.1.10) (2019-04-09)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.0.0-RC2...2.1.10)

**Implemented enhancements:**

- Predis vs Phpredis container definitions [\#383](https://github.com/snc/SncRedisBundle/issues/383)
- LockKey doesn't get prefixed with prefix properly + patch [\#249](https://github.com/snc/SncRedisBundle/issues/249)

**Fixed bugs:**

- Single \Predis\Connection\Parameters instance should be wrapped in array when using sentinel replication. [\#381](https://github.com/snc/SncRedisBundle/issues/381)
- Leverage "options.parameters" config in `PhpredisClientFactory::create()` [\#505](https://github.com/snc/SncRedisBundle/pull/505) ([phansys](https://github.com/phansys))

**Closed issues:**

- Redis connection \(in Doctrine cache\) gets initialized on each command [\#510](https://github.com/snc/SncRedisBundle/issues/510)
- AWS Redis 5 master-replica [\#504](https://github.com/snc/SncRedisBundle/issues/504)
- Create a service locator for clients to be used in various locations [\#419](https://github.com/snc/SncRedisBundle/issues/419)

**Merged pull requests:**

- Wrap Parameters in array when using replication - fix \#381 [\#516](https://github.com/snc/SncRedisBundle/pull/516) ([duxet](https://github.com/duxet))
- Execute flushdb/flushall in all nodes of cluster [\#514](https://github.com/snc/SncRedisBundle/pull/514) ([peter-gribanov](https://github.com/peter-gribanov))
- Use semver for PHP version at `composer.json`, added support for PHP 7.3 at Travis [\#508](https://github.com/snc/SncRedisBundle/pull/508) ([phansys](https://github.com/phansys))
- Update method signatures in `Client` in order to respect its parent [\#507](https://github.com/snc/SncRedisBundle/pull/507) ([phansys](https://github.com/phansys))
- fix \#383 - deprecates redis service alias in favor of 'snc\_redis.{alias}' [\#501](https://github.com/snc/SncRedisBundle/pull/501) ([B-Galati](https://github.com/B-Galati))

## [3.0.0-RC2](https://github.com/snc/SncRedisBundle/tree/3.0.0-RC2) (2019-02-20)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.9...3.0.0-RC2)

**Merged pull requests:**

- Not quoting the % indicator is deprecated [\#495](https://github.com/snc/SncRedisBundle/pull/495) ([magnetik](https://github.com/magnetik))

## [2.1.9](https://github.com/snc/SncRedisBundle/tree/2.1.9) (2019-02-20)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.8...2.1.9)

**Fixed bugs:**

- Option read\_write\_timeout is not working with phpredis [\#498](https://github.com/snc/SncRedisBundle/issues/498)
- Request getSession\(\) cause an UndefinedMethodException [\#485](https://github.com/snc/SncRedisBundle/issues/485)
- No master server available for replication after upgrade to 2.1.6 [\#449](https://github.com/snc/SncRedisBundle/issues/449)
- Azure redis Auth error - Invalid password [\#429](https://github.com/snc/SncRedisBundle/issues/429)
- Cluster with multi-masters setup fail [\#312](https://github.com/snc/SncRedisBundle/issues/312)
- fix \#498 - Add read\_timeout connection option to phpredis [\#499](https://github.com/snc/SncRedisBundle/pull/499) ([B-Galati](https://github.com/B-Galati))
-  Fix \#312 - deprecation option cannot be false  [\#494](https://github.com/snc/SncRedisBundle/pull/494) ([B-Galati](https://github.com/B-Galati))

**Closed issues:**

- Connection to redis is mandatory with Symfony 2.8? [\#497](https://github.com/snc/SncRedisBundle/issues/497)
- 2.1.8 does not show on packagist.org [\#496](https://github.com/snc/SncRedisBundle/issues/496)
- Enable support for TLS connections \(predis\) [\#457](https://github.com/snc/SncRedisBundle/issues/457)
- Creating multiple session keys when using snc\_redis.session.handler [\#438](https://github.com/snc/SncRedisBundle/issues/438)
- Logging not possible for session and swiftmailer [\#262](https://github.com/snc/SncRedisBundle/issues/262)

**Merged pull requests:**

- Fix \#449 - No master server available for replication [\#493](https://github.com/snc/SncRedisBundle/pull/493) ([B-Galati](https://github.com/B-Galati))

## [2.1.8](https://github.com/snc/SncRedisBundle/tree/2.1.8) (2019-02-04)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/3.0.0-RC1...2.1.8)

**Closed issues:**

- 2.1.5 is broken [\#460](https://github.com/snc/SncRedisBundle/issues/460)
- 30 seconds wasted in session locking [\#182](https://github.com/snc/SncRedisBundle/issues/182)

**Merged pull requests:**

- set logger on the connection wrapper only [\#489](https://github.com/snc/SncRedisBundle/pull/489) ([xabbuh](https://github.com/xabbuh))

## [3.0.0-RC1](https://github.com/snc/SncRedisBundle/tree/3.0.0-RC1) (2019-01-17)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.7...3.0.0-RC1)

**Implemented enhancements:**

- Make all bundle services private [\#409](https://github.com/snc/SncRedisBundle/pull/409) ([curry684](https://github.com/curry684))

**Closed issues:**

- Exception on connection are not catched by Symfony [\#490](https://github.com/snc/SncRedisBundle/issues/490)
- Weird PhpredisClientFactory Error [\#488](https://github.com/snc/SncRedisBundle/issues/488)
- Symfony 4.2 deprecation notice [\#484](https://github.com/snc/SncRedisBundle/issues/484)
- RedisBaseCommand extends ContainerAwareCommand gives deprecated mesage [\#480](https://github.com/snc/SncRedisBundle/issues/480)
- What the advantages over Symfony cache component? [\#476](https://github.com/snc/SncRedisBundle/issues/476)
- Missing 3.x version [\#464](https://github.com/snc/SncRedisBundle/issues/464)
- command redis:flushall The client default is not defined [\#441](https://github.com/snc/SncRedisBundle/issues/441)

**Merged pull requests:**

- No memory limit for composer in TravisCI [\#492](https://github.com/snc/SncRedisBundle/pull/492) ([B-Galati](https://github.com/B-Galati))
- Fix TravisCI after merging 2.1 into master [\#491](https://github.com/snc/SncRedisBundle/pull/491) ([B-Galati](https://github.com/B-Galati))
- Conditionally enable lazy loading for `phpredis` [\#487](https://github.com/snc/SncRedisBundle/pull/487) ([rvanlaak](https://github.com/rvanlaak))
- Excluded tests from classmap [\#486](https://github.com/snc/SncRedisBundle/pull/486) ([samnela](https://github.com/samnela))
- Fix: Make script step explicit [\#477](https://github.com/snc/SncRedisBundle/pull/477) ([localheinz](https://github.com/localheinz))
- Enhancement: Normalize composer.json [\#475](https://github.com/snc/SncRedisBundle/pull/475) ([localheinz](https://github.com/localheinz))
- Fix: Explicitly configure Travis build matrix [\#474](https://github.com/snc/SncRedisBundle/pull/474) ([localheinz](https://github.com/localheinz))
- Fix: Remove useless else [\#473](https://github.com/snc/SncRedisBundle/pull/473) ([localheinz](https://github.com/localheinz))
- Fix: Combine conditions [\#472](https://github.com/snc/SncRedisBundle/pull/472) ([localheinz](https://github.com/localheinz))
- Supply name for new TreeBuilder instead of calling root method [\#471](https://github.com/snc/SncRedisBundle/pull/471) ([rpkamp](https://github.com/rpkamp))
- Enhancement: Add note about usage with symfony/web-profiler-bundle [\#470](https://github.com/snc/SncRedisBundle/pull/470) ([localheinz](https://github.com/localheinz))
- Fix: No need to verify whether hard dependency is not null [\#469](https://github.com/snc/SncRedisBundle/pull/469) ([localheinz](https://github.com/localheinz))
- Fix: Travis CI badge URLs [\#468](https://github.com/snc/SncRedisBundle/pull/468) ([localheinz](https://github.com/localheinz))
- Add Symfony 4.1, 4.2 and php nightly to the CI [\#450](https://github.com/snc/SncRedisBundle/pull/450) ([B-Galati](https://github.com/B-Galati))
- \#419: Create a service locator for clients to be used in the commands. [\#433](https://github.com/snc/SncRedisBundle/pull/433) ([Basster](https://github.com/Basster))
- Fix support for Heroku style REDIS\_URL env variables [\#413](https://github.com/snc/SncRedisBundle/pull/413) ([B-Galati](https://github.com/B-Galati))
- New session handler [\#404](https://github.com/snc/SncRedisBundle/pull/404) ([Seldaek](https://github.com/Seldaek))

## [2.1.7](https://github.com/snc/SncRedisBundle/tree/2.1.7) (2018-10-15)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.6...2.1.7)

**Fixed bugs:**

- Connection via TLS \(rediss\) broken since 2.1.4 [\#444](https://github.com/snc/SncRedisBundle/issues/444)
- \[Fix\]\[Predis\] Fixes persistent connections when used many databases on the same instance [\#462](https://github.com/snc/SncRedisBundle/pull/462) ([qRoC](https://github.com/qRoC))

**Closed issues:**

- Symfony 4 setup instructions \(framework.yaml\) [\#459](https://github.com/snc/SncRedisBundle/issues/459)
- snc\_redis.doctrine\_cache\_predis configured to return PredisCache.php [\#458](https://github.com/snc/SncRedisBundle/issues/458)
- permit to set the ttl for each clients [\#456](https://github.com/snc/SncRedisBundle/issues/456)
- When reids was down, it can't affect the running of the program. for symfony4.1 [\#455](https://github.com/snc/SncRedisBundle/issues/455)
- No master server available for replication [\#451](https://github.com/snc/SncRedisBundle/issues/451)
- How can i share session between two different domains? [\#448](https://github.com/snc/SncRedisBundle/issues/448)
- how to configure password in symfony4.1 [\#447](https://github.com/snc/SncRedisBundle/issues/447)
- \[Question\]  differences between SncRedisBundle , Symfony Redis Cache adapter, and Doctring Redis Cache adapter? [\#394](https://github.com/snc/SncRedisBundle/issues/394)
- Circular reference "snc\_redis.session" with Monolog Formatter, Processor [\#161](https://github.com/snc/SncRedisBundle/issues/161)

## [2.1.6](https://github.com/snc/SncRedisBundle/tree/2.1.6) (2018-07-31)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.5...2.1.6)

**Closed issues:**

- lazyLoadingMethodInterceptor from proxy manager generates wrong Redis-\>set arguments part [\#443](https://github.com/snc/SncRedisBundle/issues/443)

**Merged pull requests:**

- Fix connection via TLS \(rediss://\) \(\#444\) [\#445](https://github.com/snc/SncRedisBundle/pull/445) ([jankramer](https://github.com/jankramer))

## [2.1.5](https://github.com/snc/SncRedisBundle/tree/2.1.5) (2018-07-18)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.4...2.1.5)

**Closed issues:**

- Support pre-building the Symfony container without the Redis server available \(or known\) [\#434](https://github.com/snc/SncRedisBundle/issues/434)
- Symfony 4 autowire [\#426](https://github.com/snc/SncRedisBundle/issues/426)

**Merged pull requests:**

- \#434 Enable Lazy service for phpredis [\#440](https://github.com/snc/SncRedisBundle/pull/440) ([B-Galati](https://github.com/B-Galati))

## [2.1.4](https://github.com/snc/SncRedisBundle/tree/2.1.4) (2018-06-25)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.3...2.1.4)

**Fixed bugs:**

- PhpRedis DSN does not interpolate environment variables in 2.1.3 [\#428](https://github.com/snc/SncRedisBundle/issues/428)
- \[v2.1.3\] Unable to connect to Redis Resource in Azure [\#425](https://github.com/snc/SncRedisBundle/issues/425)
- AWS Elasticache Redis Cluster : Uncaught PHP Exception Predis\Response\ServerException: MOVED [\#402](https://github.com/snc/SncRedisBundle/issues/402)

**Closed issues:**

- symfony 4.0  "snc\_redis.default" service or alias has been removed [\#430](https://github.com/snc/SncRedisBundle/issues/430)
- If Redis server is not reachable application returns 500 error [\#427](https://github.com/snc/SncRedisBundle/issues/427)
- Empty entities loaded from Redis second level cache [\#272](https://github.com/snc/SncRedisBundle/issues/272)
- DSN defination problem: Cluster hostname [\#267](https://github.com/snc/SncRedisBundle/issues/267)

**Merged pull requests:**

- \#425 Use RedisDsn to build connection options for env based config  [\#439](https://github.com/snc/SncRedisBundle/pull/439) ([B-Galati](https://github.com/B-Galati))
-  \#182 token serialization while lock remove [\#437](https://github.com/snc/SncRedisBundle/pull/437) ([piotrkochan](https://github.com/piotrkochan))
- \#428 \#356 Fix support for DSN env variable with phpredis [\#432](https://github.com/snc/SncRedisBundle/pull/432) ([B-Galati](https://github.com/B-Galati))

## [2.1.3](https://github.com/snc/SncRedisBundle/tree/2.1.3) (2018-05-09)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.2...2.1.3)

**Fixed bugs:**

- \[Bug\] DSN is not interpolated at runtime with environment variable [\#410](https://github.com/snc/SncRedisBundle/issues/410)
- RedisEnvDsn will break with Symfony 3.4/4.1 [\#356](https://github.com/snc/SncRedisBundle/issues/356)

**Closed issues:**

- Support for runtime Environment Variables [\#421](https://github.com/snc/SncRedisBundle/issues/421)
- How is with 3 version? [\#420](https://github.com/snc/SncRedisBundle/issues/420)

**Merged pull requests:**

- Remove env placeholder regexp [\#422](https://github.com/snc/SncRedisBundle/pull/422) ([B-Galati](https://github.com/B-Galati))
- Create cluster connection correctly for one host [\#416](https://github.com/snc/SncRedisBundle/pull/416) ([linasm83](https://github.com/linasm83))
- Close connections on shutdown [\#415](https://github.com/snc/SncRedisBundle/pull/415) ([supersmile2009](https://github.com/supersmile2009))

## [2.1.2](https://github.com/snc/SncRedisBundle/tree/2.1.2) (2018-04-23)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.1...2.1.2)

**Closed issues:**

- Direct access to private services in RedisBaseCommand [\#418](https://github.com/snc/SncRedisBundle/issues/418)
- Version 2.1.1 causes performance issues [\#417](https://github.com/snc/SncRedisBundle/issues/417)

## [2.1.1](https://github.com/snc/SncRedisBundle/tree/2.1.1) (2018-04-18)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.1.0...2.1.1)

**Implemented enhancements:**

- Alias for services created via dependency injection are not public [\#384](https://github.com/snc/SncRedisBundle/issues/384)

**Fixed bugs:**

- \[Bug\] No commands in profiler using symfony cache with predis [\#407](https://github.com/snc/SncRedisBundle/issues/407)

**Closed issues:**

- SncRedisBundle SwiftMailer integration needs SwiftMailer to be installed [\#414](https://github.com/snc/SncRedisBundle/issues/414)
- Better handle the case when Redis is not installled [\#406](https://github.com/snc/SncRedisBundle/issues/406)
- User Deprecated: Implementing "Symfony\Component\HttpKernel\DataCollector\DataCollectorInterface" without the "reset\(\)" [\#401](https://github.com/snc/SncRedisBundle/issues/401)
- Repo description is incorrect [\#397](https://github.com/snc/SncRedisBundle/issues/397)
- Doctrine query\_cache TTL [\#389](https://github.com/snc/SncRedisBundle/issues/389)
- how to Reset ttl ? [\#368](https://github.com/snc/SncRedisBundle/issues/368)
- How to inject @snc\_redis to own service ? [\#367](https://github.com/snc/SncRedisBundle/issues/367)
- Session fixation [\#364](https://github.com/snc/SncRedisBundle/issues/364)
- What is sf2orm\_\*\*\*\*\*\* in my database 0 [\#354](https://github.com/snc/SncRedisBundle/issues/354)
- Changing list of servers in runtime [\#346](https://github.com/snc/SncRedisBundle/issues/346)
- All values surrounded with s:number:"" after doctrine cache [\#343](https://github.com/snc/SncRedisBundle/issues/343)
- `replication: sentinel` \(currently on master branch\) launches AUTH to sentinel instances [\#339](https://github.com/snc/SncRedisBundle/issues/339)
- use SncRedisBundle, password is not in $options   when  new Predis\Client\($parameters, $options\); [\#336](https://github.com/snc/SncRedisBundle/issues/336)
- integration with platform.sh [\#314](https://github.com/snc/SncRedisBundle/issues/314)
- Redis endpoints should be parameters [\#310](https://github.com/snc/SncRedisBundle/issues/310)
- Symfony connection redis cluster [\#304](https://github.com/snc/SncRedisBundle/issues/304)
- Fatal error when installing this bundle. [\#299](https://github.com/snc/SncRedisBundle/issues/299)
- Is able to divide SwiftMailer's spool into multiple ? \(Is able to divide \(redis\)spool's keyName into multiple ?\) [\#295](https://github.com/snc/SncRedisBundle/issues/295)
- Using phpRedis for caching doctrine directly [\#294](https://github.com/snc/SncRedisBundle/issues/294)
- Symfony 2.8 + snc/redis-bundle 1.1 [\#293](https://github.com/snc/SncRedisBundle/issues/293)
- query\_cache ignores DoctrineExtensions\Translatable query hint for fallback [\#290](https://github.com/snc/SncRedisBundle/issues/290)
- Disable caching for config\_dev.yml [\#285](https://github.com/snc/SncRedisBundle/issues/285)
- how to cache data in redis before storing them in mongodb [\#279](https://github.com/snc/SncRedisBundle/issues/279)
- Consider creating project for session handler [\#273](https://github.com/snc/SncRedisBundle/issues/273)
- Create service alias for each defined client [\#271](https://github.com/snc/SncRedisBundle/issues/271)
- Fatal error: Call to a member function createCommand\(\) on string [\#270](https://github.com/snc/SncRedisBundle/issues/270)
- Compatibility to DoctrineMigrationsBundle [\#268](https://github.com/snc/SncRedisBundle/issues/268)
- Cleanup issues on GitHub [\#263](https://github.com/snc/SncRedisBundle/issues/263)
- Disable SncRedis for comparison / benchmark [\#261](https://github.com/snc/SncRedisBundle/issues/261)
- Doctrine Redis Cache requires \Redis\(\) not Predis\Client\(\) [\#257](https://github.com/snc/SncRedisBundle/issues/257)
- Doctrine metadata cache, forms, type guesser. [\#256](https://github.com/snc/SncRedisBundle/issues/256)
- Problem with Predis\Profile\Factory [\#255](https://github.com/snc/SncRedisBundle/issues/255)
- Invalid argument supplied for foreach\(\) on Symfony/Bundle/FrameworkBundle/Console/Application.php:127 [\#254](https://github.com/snc/SncRedisBundle/issues/254)
- Backport to fix deprecation warning on 1.1 branch [\#252](https://github.com/snc/SncRedisBundle/issues/252)
- Symfony 2.8+ profiler bar visual glitch [\#251](https://github.com/snc/SncRedisBundle/issues/251)
- RedisSessionHandler spinlock looping in PHP7 [\#250](https://github.com/snc/SncRedisBundle/issues/250)
- Security tokens lost on mysql failure [\#246](https://github.com/snc/SncRedisBundle/issues/246)
- Logging messages as INFO when they should be DEBUG [\#243](https://github.com/snc/SncRedisBundle/issues/243)
- Have a base class for the snc\_redis.\* services [\#240](https://github.com/snc/SncRedisBundle/issues/240)
- Clearing Doctrine cache does not really deleting the keys [\#239](https://github.com/snc/SncRedisBundle/issues/239)
- Monolog RedisHandler with predis Client does'nt work. [\#222](https://github.com/snc/SncRedisBundle/issues/222)
- Call to a member function wakeupReflection\(\) on a non-object [\#217](https://github.com/snc/SncRedisBundle/issues/217)
- Redis::connect on command that requires Twig [\#211](https://github.com/snc/SncRedisBundle/issues/211)
- multiple app in one server [\#204](https://github.com/snc/SncRedisBundle/issues/204)
- RedisSessionHandler private -\> protected [\#201](https://github.com/snc/SncRedisBundle/issues/201)
- Question about the Redis key [\#181](https://github.com/snc/SncRedisBundle/issues/181)
- Compatible with Twemproxy ? [\#179](https://github.com/snc/SncRedisBundle/issues/179)
- Doctrine configuration requires at least one value for entity\_manager or document\_manager [\#177](https://github.com/snc/SncRedisBundle/issues/177)
- \[1.1.8\] Different Clients injected for snc\_redis.default\[\_client\] [\#170](https://github.com/snc/SncRedisBundle/issues/170)
- RedisSessionHandler needs to return true \(for HHVM\)  [\#168](https://github.com/snc/SncRedisBundle/issues/168)
- DSN with slave instances not working as expected [\#159](https://github.com/snc/SncRedisBundle/issues/159)

**Merged pull requests:**

- Use destructor to close session \(partially reverted \#348\) [\#412](https://github.com/snc/SncRedisBundle/pull/412) ([supersmile2009](https://github.com/supersmile2009))
- Add Serialization option [\#411](https://github.com/snc/SncRedisBundle/pull/411) ([yellow1912](https://github.com/yellow1912))
- fix predis logging using symfony cache component [\#408](https://github.com/snc/SncRedisBundle/pull/408) ([vchebotarev](https://github.com/vchebotarev))

## [2.1.0](https://github.com/snc/SncRedisBundle/tree/2.1.0) (2018-04-06)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.0.6...2.1.0)

**Closed issues:**

- Defining profile by env variable fails [\#391](https://github.com/snc/SncRedisBundle/issues/391)
- Issues with symfony/web-profiler-bundle, SncRedisBundle and content security policy [\#390](https://github.com/snc/SncRedisBundle/issues/390)
- How to define a database name in snc\_redis configuration [\#387](https://github.com/snc/SncRedisBundle/issues/387)
- Bundle is labelled as not-maintained as of 2016 [\#382](https://github.com/snc/SncRedisBundle/issues/382)
- Change lockMaxWait in RedisSessionHandler from private to protected [\#379](https://github.com/snc/SncRedisBundle/issues/379)
- BUG: session\_wirte\_close\(\) error! [\#377](https://github.com/snc/SncRedisBundle/issues/377)
- Clear cache failed on Symfony 2.7 [\#376](https://github.com/snc/SncRedisBundle/issues/376)
- Recover session by its id [\#363](https://github.com/snc/SncRedisBundle/issues/363)
- Support for phpredis with RedisEnvDsn is broken [\#361](https://github.com/snc/SncRedisBundle/issues/361)
- After latest ppa:ondrej/php, SncRedisBundle stop working [\#357](https://github.com/snc/SncRedisBundle/issues/357)
- Feature Request: Compression [\#331](https://github.com/snc/SncRedisBundle/issues/331)
- Phpiredis support [\#221](https://github.com/snc/SncRedisBundle/issues/221)
- Pretty big performance regression from 1.1.7 to 1.1.8 [\#132](https://github.com/snc/SncRedisBundle/issues/132)
- Memory leak somewhere in the bundle [\#128](https://github.com/snc/SncRedisBundle/issues/128)
- Anti Dog Pile System [\#102](https://github.com/snc/SncRedisBundle/issues/102)
- Attempting to connect during assets:install [\#97](https://github.com/snc/SncRedisBundle/issues/97)
- Client object type varies based on symfony environment [\#90](https://github.com/snc/SncRedisBundle/issues/90)
- TTL For non session use [\#84](https://github.com/snc/SncRedisBundle/issues/84)

**Merged pull requests:**

- Disable logging wrappers on PhpRedis \>= 4.0.0 [\#405](https://github.com/snc/SncRedisBundle/pull/405) ([curry684](https://github.com/curry684))
- Use a Predis command to be able to use EVALSHA instead of EVALing the session freeing script every time [\#403](https://github.com/snc/SncRedisBundle/pull/403) ([Seldaek](https://github.com/Seldaek))
- Clarify documentation on Redis Sentinel [\#398](https://github.com/snc/SncRedisBundle/pull/398) ([rpkamp](https://github.com/rpkamp))
- Pimp the readme with badge poser [\#396](https://github.com/snc/SncRedisBundle/pull/396) ([JellyBellyDev](https://github.com/JellyBellyDev))
- No longer use style in svg image for profiler [\#395](https://github.com/snc/SncRedisBundle/pull/395) ([rpkamp](https://github.com/rpkamp))
- Resolve env placeholders for profile [\#393](https://github.com/snc/SncRedisBundle/pull/393) ([Majkl578](https://github.com/Majkl578))
- Ignore bin folder, use absolute ignore paths [\#392](https://github.com/snc/SncRedisBundle/pull/392) ([Majkl578](https://github.com/Majkl578))
- Updated test with namespaced PHPUnit TestCase [\#388](https://github.com/snc/SncRedisBundle/pull/388) ([MarioBlazek](https://github.com/MarioBlazek))
- Update .travis.yml [\#386](https://github.com/snc/SncRedisBundle/pull/386) ([andreybolonin](https://github.com/andreybolonin))
- Change lockMaxWait in RedisSessionHandler from private to protected [\#380](https://github.com/snc/SncRedisBundle/pull/380) ([lunglung876](https://github.com/lunglung876))
- Support env vars for both drivers [\#378](https://github.com/snc/SncRedisBundle/pull/378) ([kozlice](https://github.com/kozlice))
- dont re-define the function in the loop again and again [\#355](https://github.com/snc/SncRedisBundle/pull/355) ([staabm](https://github.com/staabm))
- Session handler shutdown cleanup [\#348](https://github.com/snc/SncRedisBundle/pull/348) ([coder-pm](https://github.com/coder-pm))
- Call logCommand\(\) on null [\#335](https://github.com/snc/SncRedisBundle/pull/335) ([Jim-Raynor](https://github.com/Jim-Raynor))
- Update RateLimit.php to correct post URL [\#287](https://github.com/snc/SncRedisBundle/pull/287) ([overint](https://github.com/overint))
- Client node not required by default [\#127](https://github.com/snc/SncRedisBundle/pull/127) ([goetas](https://github.com/goetas))

## [2.0.6](https://github.com/snc/SncRedisBundle/tree/2.0.6) (2017-12-01)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.0.5...2.0.6)

**Closed issues:**

- Error in commit 58f8f3c with Symfony 2.8 [\#375](https://github.com/snc/SncRedisBundle/issues/375)

## [2.0.5](https://github.com/snc/SncRedisBundle/tree/2.0.5) (2017-12-01)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.0.4...2.0.5)

**Closed issues:**

- Symfony 3.4/4.0 deprecations [\#374](https://github.com/snc/SncRedisBundle/issues/374)
- update for symfony 3.4+ [\#372](https://github.com/snc/SncRedisBundle/issues/372)
- ERR unknown command 'SET' when I use sentinel mode? [\#371](https://github.com/snc/SncRedisBundle/issues/371)
- Make RedisDataCollector compatible with Symfony 4.0 [\#365](https://github.com/snc/SncRedisBundle/issues/365)

**Merged pull requests:**

- Fix ci warning caused by PHPUnit Api deprecation [\#373](https://github.com/snc/SncRedisBundle/pull/373) ([SiM07](https://github.com/SiM07))
- Provides Symfony 4 compatibility [\#370](https://github.com/snc/SncRedisBundle/pull/370) ([ghost](https://github.com/ghost))
- forward compatibility with Symfony 4.0 [\#366](https://github.com/snc/SncRedisBundle/pull/366) ([xabbuh](https://github.com/xabbuh))

## [2.0.4](https://github.com/snc/SncRedisBundle/tree/2.0.4) (2017-10-02)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.0.3...2.0.4)

**Closed issues:**

- DSN with ENV Variables \(Symfony 3.3.9\). Request for release [\#360](https://github.com/snc/SncRedisBundle/issues/360)
- Not compatible with swiftmailer 6 [\#359](https://github.com/snc/SncRedisBundle/issues/359)

## [2.0.3](https://github.com/snc/SncRedisBundle/tree/2.0.3) (2017-10-01)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.0.2...2.0.3)

**Closed issues:**

- Could you tag a new release? [\#347](https://github.com/snc/SncRedisBundle/issues/347)
- Debugbar incorrectly reports errors [\#334](https://github.com/snc/SncRedisBundle/issues/334)

**Merged pull requests:**

- Support for Heroku style REDIS\_URL env variables [\#353](https://github.com/snc/SncRedisBundle/pull/353) ([iKlaus](https://github.com/iKlaus))
- Fix RedisSpool to use Swift\_Mime\_SimpleMessage [\#350](https://github.com/snc/SncRedisBundle/pull/350) ([gohiei](https://github.com/gohiei))

## [2.0.2](https://github.com/snc/SncRedisBundle/tree/2.0.2) (2017-06-15)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.0.1...2.0.2)

**Closed issues:**

- queueMessage not compatible [\#344](https://github.com/snc/SncRedisBundle/issues/344)
- ClassNotFoundException in SncRedisExtension.php line 162: [\#332](https://github.com/snc/SncRedisBundle/issues/332)
- Consider adding GitHub Topics to this repository [\#327](https://github.com/snc/SncRedisBundle/issues/327)
- Please tag a release [\#326](https://github.com/snc/SncRedisBundle/issues/326)
- Seninel support [\#315](https://github.com/snc/SncRedisBundle/issues/315)
- SncRedis doesn't work with runtime environment variables [\#302](https://github.com/snc/SncRedisBundle/issues/302)
- DSN values for Platform.sh host [\#286](https://github.com/snc/SncRedisBundle/issues/286)
- Same underlying connection resource used for multiple clients, database option ignored with persistent connections [\#185](https://github.com/snc/SncRedisBundle/issues/185)

**Merged pull requests:**

- Fix template namespacing [\#349](https://github.com/snc/SncRedisBundle/pull/349) ([alOneh](https://github.com/alOneh))
- Improve the readme [\#342](https://github.com/snc/SncRedisBundle/pull/342) ([stof](https://github.com/stof))
- Move the LICENSE file to the root [\#341](https://github.com/snc/SncRedisBundle/pull/341) ([stof](https://github.com/stof))
- Add database & password parameters support for predis sentinel [\#340](https://github.com/snc/SncRedisBundle/pull/340) ([Erliz](https://github.com/Erliz))
- Added prefix option for client in readme [\#338](https://github.com/snc/SncRedisBundle/pull/338) ([stellalie](https://github.com/stellalie))
- Fixed usage of non-Twig paths [\#337](https://github.com/snc/SncRedisBundle/pull/337) ([stellalie](https://github.com/stellalie))
- Create .gitattributes [\#309](https://github.com/snc/SncRedisBundle/pull/309) ([Aliance](https://github.com/Aliance))
- allow sentinel replication configuration [\#307](https://github.com/snc/SncRedisBundle/pull/307) ([othillo](https://github.com/othillo))
- Pass the path parameter to deduplicate persistent connections [\#186](https://github.com/snc/SncRedisBundle/pull/186) ([dominics](https://github.com/dominics))

## [2.0.1](https://github.com/snc/SncRedisBundle/tree/2.0.1) (2017-02-16)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/2.0.0...2.0.1)

**Closed issues:**

- PHPRedis RedisClient never throws and error [\#323](https://github.com/snc/SncRedisBundle/issues/323)
- Doctrine ODM service name is still wrong [\#318](https://github.com/snc/SncRedisBundle/issues/318)
- doctrine's metadata cache is not invalidated unless I call redis:flushdb [\#311](https://github.com/snc/SncRedisBundle/issues/311)
- DDOS possible? Is it safe to store every custom session id passed? [\#300](https://github.com/snc/SncRedisBundle/issues/300)
- Redis AUTH support Colon \(:\) but SncRedisBundle doesn't. [\#282](https://github.com/snc/SncRedisBundle/issues/282)
- \[2.0.0\] `SELECT` failed: ERR invalid DB index \[tcp://localhost:6379\] [\#280](https://github.com/snc/SncRedisBundle/issues/280)
- Release 2.0 [\#278](https://github.com/snc/SncRedisBundle/issues/278)
- Not able to use it with symfony v3.0.6 [\#277](https://github.com/snc/SncRedisBundle/issues/277)
- support for symfony3 [\#223](https://github.com/snc/SncRedisBundle/issues/223)
- snc\_redis must be configured [\#219](https://github.com/snc/SncRedisBundle/issues/219)
- Problems with latest release [\#197](https://github.com/snc/SncRedisBundle/issues/197)
- PHP 5.6.7 Redis::scan\(\) expected to be a reference [\#178](https://github.com/snc/SncRedisBundle/issues/178)
- count function return 2 times of real number [\#171](https://github.com/snc/SncRedisBundle/issues/171)
- Configuration error "Invalid type for client options." [\#167](https://github.com/snc/SncRedisBundle/issues/167)

**Merged pull requests:**

- Fixed last pull request according comments [\#325](https://github.com/snc/SncRedisBundle/pull/325) ([aurimasniekis](https://github.com/aurimasniekis))
- \#323 Implemented error handling for PHPRedis/Client::call [\#324](https://github.com/snc/SncRedisBundle/pull/324) ([aurimasniekis](https://github.com/aurimasniekis))
- Removed unused code line in RedisLogger.php file [\#322](https://github.com/snc/SncRedisBundle/pull/322) ([aurimasniekis](https://github.com/aurimasniekis))
- As per the ticket \#318, reverting the odm definition change [\#319](https://github.com/snc/SncRedisBundle/pull/319) ([usmanzafar](https://github.com/usmanzafar))
- update scan to use reference \(iterator\) [\#316](https://github.com/snc/SncRedisBundle/pull/316) ([toooni](https://github.com/toooni))
- Use persistent id generated from DSN, if connection\_persistent is set to 'true' [\#308](https://github.com/snc/SncRedisBundle/pull/308) ([Donar23](https://github.com/Donar23))
- Fix small typo in index.md [\#303](https://github.com/snc/SncRedisBundle/pull/303) ([chteuchteu](https://github.com/chteuchteu))
- Reimplementation of the RedisProfilerStorage [\#301](https://github.com/snc/SncRedisBundle/pull/301) ([GijsL](https://github.com/GijsL))
- Use .svg image instead of .png for Travis badges [\#298](https://github.com/snc/SncRedisBundle/pull/298) ([bocharsky-bw](https://github.com/bocharsky-bw))
- clarify docs around urlencoding chars in password [\#292](https://github.com/snc/SncRedisBundle/pull/292) ([danalloway](https://github.com/danalloway))
- Update the maintenance status badge [\#288](https://github.com/snc/SncRedisBundle/pull/288) ([emirb](https://github.com/emirb))

## [2.0.0](https://github.com/snc/SncRedisBundle/tree/2.0.0) (2016-06-17)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.10...2.0.0)

**Closed issues:**

- Stillmaintained.com icon [\#265](https://github.com/snc/SncRedisBundle/issues/265)
- Caching Queries [\#264](https://github.com/snc/SncRedisBundle/issues/264)
- Session handler  [\#260](https://github.com/snc/SncRedisBundle/issues/260)
- Metadata caching fails on PHP7 phpredis [\#259](https://github.com/snc/SncRedisBundle/issues/259)
- When redis session enabled, app goes loop on long polling requests [\#258](https://github.com/snc/SncRedisBundle/issues/258)
- How to invalidate doctrine query cache? [\#241](https://github.com/snc/SncRedisBundle/issues/241)
- PHP7 & session\_write\_close issue [\#237](https://github.com/snc/SncRedisBundle/issues/237)
- Dependancy injection tagging of services [\#234](https://github.com/snc/SncRedisBundle/issues/234)
- Auth information from DSN read incorrectly [\#218](https://github.com/snc/SncRedisBundle/issues/218)
- Ignore "no connection" for localhost [\#214](https://github.com/snc/SncRedisBundle/issues/214)
- Create new tagged release [\#209](https://github.com/snc/SncRedisBundle/issues/209)
- Symfony 2.7 and recommended configuration for sessions, session.handler seems to be overwritten by Symfony2 default [\#196](https://github.com/snc/SncRedisBundle/issues/196)
- JSON Encode Error Logging [\#193](https://github.com/snc/SncRedisBundle/issues/193)
- Can't save Redis  [\#176](https://github.com/snc/SncRedisBundle/issues/176)
- Configuration [\#175](https://github.com/snc/SncRedisBundle/issues/175)
- Redis cannot be found [\#121](https://github.com/snc/SncRedisBundle/issues/121)
- Create command to clear Doctrine cache only [\#119](https://github.com/snc/SncRedisBundle/issues/119)
- Problems with long running connections [\#82](https://github.com/snc/SncRedisBundle/issues/82)

**Merged pull requests:**

- Don't show wrapper HTML when no icon is visible in profile bar. [\#275](https://github.com/snc/SncRedisBundle/pull/275) ([Sander-Toonen](https://github.com/Sander-Toonen))
- Increase the cut-limit for a command [\#266](https://github.com/snc/SncRedisBundle/pull/266) ([goetas](https://github.com/goetas))
- Properly extract password from auth credentials \(fixes \#218\) [\#248](https://github.com/snc/SncRedisBundle/pull/248) ([NielsJanssen](https://github.com/NielsJanssen))
- Remove custom styles icon to work well with new profiler design [\#244](https://github.com/snc/SncRedisBundle/pull/244) ([stloyd](https://github.com/stloyd))
- Add tags for the snc\_redis clients [\#242](https://github.com/snc/SncRedisBundle/pull/242) ([alister](https://github.com/alister))
- Allow easier inherritence of RedisSessionHandler [\#238](https://github.com/snc/SncRedisBundle/pull/238) ([urg](https://github.com/urg))
- Fix Session Handler with Predis [\#236](https://github.com/snc/SncRedisBundle/pull/236) ([Pouix](https://github.com/Pouix))
- fix create doctrine cache difinition when predis is client [\#233](https://github.com/snc/SncRedisBundle/pull/233) ([shustrik](https://github.com/shustrik))
- Don't test not supported Symfony versions [\#232](https://github.com/snc/SncRedisBundle/pull/232) ([stloyd](https://github.com/stloyd))
- Fix \#228 RateLimit and add some tests [\#231](https://github.com/snc/SncRedisBundle/pull/231) ([Pouix](https://github.com/Pouix))
- Add Second level Cache, Update Phpredis Client, Deprecate RedisCache, Fix session locking, Fix Travis [\#230](https://github.com/snc/SncRedisBundle/pull/230) ([Pouix](https://github.com/Pouix))
- Add branch alias for master branch [\#229](https://github.com/snc/SncRedisBundle/pull/229) ([Seldaek](https://github.com/Seldaek))
- rename symfony2 to symfony [\#227](https://github.com/snc/SncRedisBundle/pull/227) ([Ma27](https://github.com/Ma27))
- Fix commands on Symfony 3.0 [\#226](https://github.com/snc/SncRedisBundle/pull/226) ([piotrantosik](https://github.com/piotrantosik))
- Improve testing & add Symfony 3 support [\#215](https://github.com/snc/SncRedisBundle/pull/215) ([wouterj](https://github.com/wouterj))
- Updated instructions for install predis. [\#210](https://github.com/snc/SncRedisBundle/pull/210) ([maxolasersquad](https://github.com/maxolasersquad))
- Update PHPUnit to stable version, load using Composer [\#187](https://github.com/snc/SncRedisBundle/pull/187) ([dominics](https://github.com/dominics))
- Fix multiple connections with same alias overwriting other connections parameters [\#184](https://github.com/snc/SncRedisBundle/pull/184) ([nzwalker](https://github.com/nzwalker))
- if connection was not initialized it will throw exception on destruct [\#180](https://github.com/snc/SncRedisBundle/pull/180) ([edast](https://github.com/edast))
- setAlias takes only two args [\#174](https://github.com/snc/SncRedisBundle/pull/174) ([mhor](https://github.com/mhor))
- Fixes session storage for HHVM \(and possibly strict PHP environments\) [\#164](https://github.com/snc/SncRedisBundle/pull/164) ([hardchor](https://github.com/hardchor))
- fix phpredis [\#156](https://github.com/snc/SncRedisBundle/pull/156) ([ricardclau](https://github.com/ricardclau))
- use monolog redishandler [\#153](https://github.com/snc/SncRedisBundle/pull/153) ([ricardclau](https://github.com/ricardclau))
- Restructure the phpredis client. [\#126](https://github.com/snc/SncRedisBundle/pull/126) ([antoox](https://github.com/antoox))

## [1.1.10](https://github.com/snc/SncRedisBundle/tree/1.1.10) (2016-01-21)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.9...1.1.10)

**Closed issues:**

- strlen\(\) expects parameter 1 to be string, array given in RedisSessionHandler lockSession [\#235](https://github.com/snc/SncRedisBundle/issues/235)
- Predis Client::multiExec no longer exists, but is still used in RateLimit [\#228](https://github.com/snc/SncRedisBundle/issues/228)
- Twig Extension ? [\#224](https://github.com/snc/SncRedisBundle/issues/224)
- Global DB select [\#220](https://github.com/snc/SncRedisBundle/issues/220)
- Doctrine Second Level Cache \[SOLVED!\] [\#216](https://github.com/snc/SncRedisBundle/issues/216)
- Predis parametrs for sessions [\#207](https://github.com/snc/SncRedisBundle/issues/207)
- You can enable or disable SncRedisBundle dynamically? [\#206](https://github.com/snc/SncRedisBundle/issues/206)
- Deprecate RedisCache in favour to native Doctrine\Common\Cache\{RedisCache,PredisCache} [\#205](https://github.com/snc/SncRedisBundle/issues/205)
- Master-Slave Doctrine Cache [\#198](https://github.com/snc/SncRedisBundle/issues/198)
- \[1.1.9\] Class 'Predis\Profile\Factory' not found [\#190](https://github.com/snc/SncRedisBundle/issues/190)
- Fatal error after update form 1.1.8 to 1.1.9 [\#188](https://github.com/snc/SncRedisBundle/issues/188)

## [1.1.9](https://github.com/snc/SncRedisBundle/tree/1.1.9) (2015-06-30)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.8...1.1.9)

**Closed issues:**

- non-existent service "snc\_redis.cache\_client" [\#173](https://github.com/snc/SncRedisBundle/issues/173)
- Documentation use client name that were not defined [\#163](https://github.com/snc/SncRedisBundle/issues/163)
- Using RateLimit with PHPRedis instead of Predis\Client [\#162](https://github.com/snc/SncRedisBundle/issues/162)
- No handing when Fatal errors. [\#155](https://github.com/snc/SncRedisBundle/issues/155)
- Class Predis\Profile\ServerProfile not found with predis 1.x [\#151](https://github.com/snc/SncRedisBundle/issues/151)
- Composer udpate crash during cache:clear command. [\#149](https://github.com/snc/SncRedisBundle/issues/149)
- use the bundle with two different servers [\#146](https://github.com/snc/SncRedisBundle/issues/146)
- Namespace conflict for Predis 0.8 [\#145](https://github.com/snc/SncRedisBundle/issues/145)
- On data transformers [\#144](https://github.com/snc/SncRedisBundle/issues/144)
- Doctrine ODM Caching [\#142](https://github.com/snc/SncRedisBundle/issues/142)
- \[Session\] Cannot login when using redis session on another server [\#139](https://github.com/snc/SncRedisBundle/issues/139)
- Empty session files creates [\#138](https://github.com/snc/SncRedisBundle/issues/138)
- Unknown server profile: 2,8 [\#136](https://github.com/snc/SncRedisBundle/issues/136)
- Support for multiple databases [\#135](https://github.com/snc/SncRedisBundle/issues/135)
- Tag 1.1.8 [\#131](https://github.com/snc/SncRedisBundle/issues/131)
- What is the advantage of Snc's Monolog Redis Handler over the one provided by Monolog? [\#122](https://github.com/snc/SncRedisBundle/issues/122)

**Merged pull requests:**

- Predis 1.0 in branch 1.1 [\#172](https://github.com/snc/SncRedisBundle/pull/172) ([theUniC](https://github.com/theUniC))
- Updated service name for Doctrine ODM [\#143](https://github.com/snc/SncRedisBundle/pull/143) ([douglaslinsmeyer](https://github.com/douglaslinsmeyer))
- persistent connections - use a different persistent\_id per DSN [\#141](https://github.com/snc/SncRedisBundle/pull/141) ([nail](https://github.com/nail))
- Update Configuration.php - fix for "Unknown server profile: 2,8" [\#137](https://github.com/snc/SncRedisBundle/pull/137) ([sunra](https://github.com/sunra))
- session expiration time should be based on session.gc\_maxlifetime value ... [\#134](https://github.com/snc/SncRedisBundle/pull/134) ([profforg](https://github.com/profforg))
- Removed session locking on write, added unlock on destroy [\#133](https://github.com/snc/SncRedisBundle/pull/133) ([mevdschee](https://github.com/mevdschee))

## [1.1.8](https://github.com/snc/SncRedisBundle/tree/1.1.8) (2014-02-01)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.7...1.1.8)

**Closed issues:**

- Update problem [\#116](https://github.com/snc/SncRedisBundle/issues/116)
- Clients aliases looks useless [\#113](https://github.com/snc/SncRedisBundle/issues/113)

**Merged pull requests:**

- Fixed travis-ci testsuite [\#124](https://github.com/snc/SncRedisBundle/pull/124) ([pborreli](https://github.com/pborreli))
- Session locking [\#120](https://github.com/snc/SncRedisBundle/pull/120) ([shtouff](https://github.com/shtouff))
- Use inline profiler icon [\#117](https://github.com/snc/SncRedisBundle/pull/117) ([Furizaa](https://github.com/Furizaa))

## [1.1.7](https://github.com/snc/SncRedisBundle/tree/1.1.7) (2013-11-24)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.6...1.1.7)

**Closed issues:**

- Logging value by defaults can works incorrectly [\#114](https://github.com/snc/SncRedisBundle/issues/114)
- Different phpredis instances [\#111](https://github.com/snc/SncRedisBundle/issues/111)
- Configure SensioLabsInsight to be a bootable project using this bundle and PHPRedis [\#110](https://github.com/snc/SncRedisBundle/issues/110)
- The status of this Bundle [\#104](https://github.com/snc/SncRedisBundle/issues/104)

**Merged pull requests:**

- Fix default value for logging \#114 [\#115](https://github.com/snc/SncRedisBundle/pull/115) ([Koc](https://github.com/Koc))
- use parameters for phpredis classes [\#107](https://github.com/snc/SncRedisBundle/pull/107) ([odolbeau](https://github.com/odolbeau))
- Close connection on class destruction [\#106](https://github.com/snc/SncRedisBundle/pull/106) ([odolbeau](https://github.com/odolbeau))
- Monolog logging redis level doesn't work [\#103](https://github.com/snc/SncRedisBundle/pull/103) ([volkan](https://github.com/volkan))

## [1.1.6](https://github.com/snc/SncRedisBundle/tree/1.1.6) (2013-09-07)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.11...1.1.6)

**Merged pull requests:**

- Update redis.xml [\#101](https://github.com/snc/SncRedisBundle/pull/101) ([ingvar](https://github.com/ingvar))
- Added a formatter option for the monolog logger [\#100](https://github.com/snc/SncRedisBundle/pull/100) ([acasademont](https://github.com/acasademont))
- Add "replication" option [\#99](https://github.com/snc/SncRedisBundle/pull/99) ([acasademont](https://github.com/acasademont))

## [1.0.11](https://github.com/snc/SncRedisBundle/tree/1.0.11) (2013-09-07)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.5...1.0.11)

**Closed issues:**

- RedisLogger does not log duration? [\#98](https://github.com/snc/SncRedisBundle/issues/98)

## [1.1.5](https://github.com/snc/SncRedisBundle/tree/1.1.5) (2013-07-09)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.10...1.1.5)

## [1.0.10](https://github.com/snc/SncRedisBundle/tree/1.0.10) (2013-07-09)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.4...1.0.10)

**Closed issues:**

- Where did a 2.1 tag? [\#96](https://github.com/snc/SncRedisBundle/issues/96)
- Use stable stability flag instead of dev [\#94](https://github.com/snc/SncRedisBundle/issues/94)

## [1.1.4](https://github.com/snc/SncRedisBundle/tree/1.1.4) (2013-04-27)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.9...1.1.4)

**Closed issues:**

- Predis\Profile [\#88](https://github.com/snc/SncRedisBundle/issues/88)
- Installation problem [\#85](https://github.com/snc/SncRedisBundle/issues/85)

**Merged pull requests:**

- Support for Symfony2.3 [\#91](https://github.com/snc/SncRedisBundle/pull/91) ([Shine-neko](https://github.com/Shine-neko))
- Update index.md [\#86](https://github.com/snc/SncRedisBundle/pull/86) ([piscis](https://github.com/piscis))
- Adding a redis:flushall command [\#74](https://github.com/snc/SncRedisBundle/pull/74) ([Sgoettschkes](https://github.com/Sgoettschkes))

## [1.0.9](https://github.com/snc/SncRedisBundle/tree/1.0.9) (2013-02-16)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.3...1.0.9)

## [1.1.3](https://github.com/snc/SncRedisBundle/tree/1.1.3) (2013-02-16)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.8...1.1.3)

**Closed issues:**

- some times session wont save automatically  [\#79](https://github.com/snc/SncRedisBundle/issues/79)

**Merged pull requests:**

- Can't use phpredis prefix. [\#83](https://github.com/snc/SncRedisBundle/pull/83) ([sifue](https://github.com/sifue))

## [1.0.8](https://github.com/snc/SncRedisBundle/tree/1.0.8) (2013-01-13)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.2...1.0.8)

## [1.1.2](https://github.com/snc/SncRedisBundle/tree/1.1.2) (2013-01-13)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.7...1.1.2)

**Closed issues:**

- Error when defining multiple redis servers in a cluster [\#78](https://github.com/snc/SncRedisBundle/issues/78)
- Session storage setup [\#72](https://github.com/snc/SncRedisBundle/issues/72)

## [1.0.7](https://github.com/snc/SncRedisBundle/tree/1.0.7) (2013-01-13)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.1...1.0.7)

## [1.1.1](https://github.com/snc/SncRedisBundle/tree/1.1.1) (2013-01-13)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.6...1.1.1)

**Closed issues:**

- Example to cache doctrine query [\#77](https://github.com/snc/SncRedisBundle/issues/77)
- session serialization/deserialization [\#76](https://github.com/snc/SncRedisBundle/issues/76)
- Should be great create a library with \Client directory [\#75](https://github.com/snc/SncRedisBundle/issues/75)
- Setting TTL to session without cookie\_lifetime [\#70](https://github.com/snc/SncRedisBundle/issues/70)
- predis and phpredis prefixes. [\#69](https://github.com/snc/SncRedisBundle/issues/69)
- ERR wrong number of arguments for "del" command [\#67](https://github.com/snc/SncRedisBundle/issues/67)

**Merged pull requests:**

- Fixed prefixing keys in Predis [\#80](https://github.com/snc/SncRedisBundle/pull/80) ([luxemate](https://github.com/luxemate))
- Set Session TTL [\#73](https://github.com/snc/SncRedisBundle/pull/73) ([MattKetmo](https://github.com/MattKetmo))
- Predis v0.8 integration [\#71](https://github.com/snc/SncRedisBundle/pull/71) ([ronnylt](https://github.com/ronnylt))

## [1.0.6](https://github.com/snc/SncRedisBundle/tree/1.0.6) (2012-11-11)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.1.0...1.0.6)

## [1.1.0](https://github.com/snc/SncRedisBundle/tree/1.1.0) (2012-11-11)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.5...1.1.0)

**Closed issues:**

- Writing tests [\#66](https://github.com/snc/SncRedisBundle/issues/66)
- fails with phpredis [\#62](https://github.com/snc/SncRedisBundle/issues/62)
- Can't use flush:command [\#61](https://github.com/snc/SncRedisBundle/issues/61)
- Disable doctrine support [\#60](https://github.com/snc/SncRedisBundle/issues/60)
- Predis now only being installed using composer.phar install --dev? [\#52](https://github.com/snc/SncRedisBundle/issues/52)
- Implementing Commands? [\#50](https://github.com/snc/SncRedisBundle/issues/50)
- Session storage is broken [\#48](https://github.com/snc/SncRedisBundle/issues/48)
- Session handling broken? [\#43](https://github.com/snc/SncRedisBundle/issues/43)

**Merged pull requests:**

- Improving the display of the Redis widget in the debug bar [\#64](https://github.com/snc/SncRedisBundle/pull/64) ([clemherreman](https://github.com/clemherreman))
- Calling zRevRangeByScore with limit options set would cause notice error in the logger [\#63](https://github.com/snc/SncRedisBundle/pull/63) ([modi](https://github.com/modi))
- \[composer\] set minimum-stability: dev [\#54](https://github.com/snc/SncRedisBundle/pull/54) ([arnaud-lb](https://github.com/arnaud-lb))
- Fixed phpredis log command when passing an array argument [\#49](https://github.com/snc/SncRedisBundle/pull/49) ([jeremyFreeAgent](https://github.com/jeremyFreeAgent))
- Force `false` return for a cache miss [\#47](https://github.com/snc/SncRedisBundle/pull/47) ([justinrainbow](https://github.com/justinrainbow))
- predis should not be installed if user want to use phpredis. [\#45](https://github.com/snc/SncRedisBundle/pull/45) ([stephpy](https://github.com/stephpy))
- Disconnect wrapped connections [\#42](https://github.com/snc/SncRedisBundle/pull/42) ([dominics](https://github.com/dominics))
- Updating Redis session support [\#40](https://github.com/snc/SncRedisBundle/pull/40) ([justinrainbow](https://github.com/justinrainbow))
- Forcing composer to stick with stable releases of Predis in the v0.7 bra... [\#35](https://github.com/snc/SncRedisBundle/pull/35) ([sliver](https://github.com/sliver))

## [1.0.5](https://github.com/snc/SncRedisBundle/tree/1.0.5) (2012-05-08)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.4...1.0.5)

**Closed issues:**

- Configuration [\#41](https://github.com/snc/SncRedisBundle/issues/41)
- Add support for doctrine/master [\#39](https://github.com/snc/SncRedisBundle/issues/39)
- Add support for symfony/master [\#38](https://github.com/snc/SncRedisBundle/issues/38)
- Default/Test configuration [\#37](https://github.com/snc/SncRedisBundle/issues/37)
- Add compatibility with phpredis \(redis native extension\) [\#30](https://github.com/snc/SncRedisBundle/issues/30)

## [1.0.4](https://github.com/snc/SncRedisBundle/tree/1.0.4) (2012-03-10)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.3...1.0.4)

**Closed issues:**

- Cookie\_lifetime must be configured [\#36](https://github.com/snc/SncRedisBundle/issues/36)
- Add support for predis/master [\#34](https://github.com/snc/SncRedisBundle/issues/34)
- Memory leak [\#33](https://github.com/snc/SncRedisBundle/issues/33)
- Wrong index to the options array in RedisSessionStorage [\#32](https://github.com/snc/SncRedisBundle/issues/32)

## [1.0.3](https://github.com/snc/SncRedisBundle/tree/1.0.3) (2012-02-18)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.2...1.0.3)

**Closed issues:**

- Fix doctrine2/master cache support [\#31](https://github.com/snc/SncRedisBundle/issues/31)
- broken with SF2-master [\#29](https://github.com/snc/SncRedisBundle/issues/29)
- How to make this work in Symfony CLI [\#26](https://github.com/snc/SncRedisBundle/issues/26)
- doctrine result cache can't cache to redis server [\#25](https://github.com/snc/SncRedisBundle/issues/25)
- RedisCache::deleteAll\(\) throws Predis\ServerException when no cache ids found [\#22](https://github.com/snc/SncRedisBundle/issues/22)
- How to disable redisbundle when excuting unit test? [\#16](https://github.com/snc/SncRedisBundle/issues/16)
- How to enable result cache in a DocumentManager\(MongoDB\)? [\#14](https://github.com/snc/SncRedisBundle/issues/14)

**Merged pull requests:**

- Avoid creating PHP native sessions when using redis session storage [\#28](https://github.com/snc/SncRedisBundle/pull/28) ([Seldaek](https://github.com/Seldaek))
- added config option "use\_as\_default" for session store [\#24](https://github.com/snc/SncRedisBundle/pull/24) ([simon-n](https://github.com/simon-n))
- Unexpected Predis\ServerException in Doctrine\Common\Cache\Cache\RedisCache::deleteAll\(\) [\#23](https://github.com/snc/SncRedisBundle/pull/23) ([pasinter](https://github.com/pasinter))

## [1.0.2](https://github.com/snc/SncRedisBundle/tree/1.0.2) (2011-12-11)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.1...1.0.2)

**Merged pull requests:**

- Client options [\#21](https://github.com/snc/SncRedisBundle/pull/21) ([nrk](https://github.com/nrk))
- Wrap connection instances to provide logging or other accessory features. [\#20](https://github.com/snc/SncRedisBundle/pull/20) ([nrk](https://github.com/nrk))
- Update to work with the new connection factory class from Predis. [\#19](https://github.com/snc/SncRedisBundle/pull/19) ([nrk](https://github.com/nrk))
- Fix the name of the protected field that holds connection parameters. [\#18](https://github.com/snc/SncRedisBundle/pull/18) ([nrk](https://github.com/nrk))

## [1.0.1](https://github.com/snc/SncRedisBundle/tree/1.0.1) (2011-10-15)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/1.0.0...1.0.1)

**Closed issues:**

- Specify a current version and a license [\#15](https://github.com/snc/SncRedisBundle/issues/15)

**Merged pull requests:**

- Add support for Composer [\#17](https://github.com/snc/SncRedisBundle/pull/17) ([nrk](https://github.com/nrk))

## [1.0.0](https://github.com/snc/SncRedisBundle/tree/1.0.0) (2011-10-12)

[Full Changelog](https://github.com/snc/SncRedisBundle/compare/e885d746da8f7b3b6cd48f599dcaafb5b6692bac...1.0.0)

**Closed issues:**

- MongoDB Caching [\#9](https://github.com/snc/SncRedisBundle/issues/9)

**Merged pull requests:**

- Enable simple disabling of logging [\#11](https://github.com/snc/SncRedisBundle/pull/11) ([ebernhardson](https://github.com/ebernhardson))
- Updated for latest Predis master branch. [\#10](https://github.com/snc/SncRedisBundle/pull/10) ([nrk](https://github.com/nrk))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
