<?php
/**
 * VersionControl_HG
 * Simple OO implementation for Mercurial.
 *
 * PHP Version 5.4
 *
 * @copyright 2014 Siad Ardroumli
 * @license http://www.opensource.org/licenses/mit-license.php MIT
 * @link http://siad007.github.io/versioncontrol_hg
 */

namespace Siad007\VersionControl\HG\Command;

/**
 * Simple OO implementation for Mercurial.
 *
 * @author Siad Ardroumli <siad.ardroumli@gmail.com>
 *
 * @method boolean getNoDecode()
 * @method void setNoDecode(boolean $flag)
 * @method string getPrefix()
 * @method void setPrefix(string $prefix)
 * @method string getRev()
 * @method void setRev(string $revision)
 * @method string getType()
 * @method void setType(string $type)
 * @method boolean getSubrepos()
 * @method void setSubrepos(boolean $flag)
 * @method array getInclude()
 * @method void addInclude(string $pattern)
 * @method array getExclude()
 * @method void addExclude(string $pattern)
 */
class ArchiveCommand extends AbstractCommand
{
    /**
     * Available arguments for this command.
     *
     * @var array $arguments
     */
    protected $arguments = [
        'dest' => ''
    ];

    /**
     * {@inheritdoc}
     *
     * @var mixed $options
     */
    protected $options = [
        '--no-decode' => false,
        '--prefix'    => '',
        '--rev'       => '',
        '--type'      => '',
        '--subrepos'  => false,
        '--include'   => [],
        '--exclude'   => [],
    ];

    /**
     * Get the destination argument.
     *
     * @return string
     */
    public function getDestination()
    {
        return $this->arguments['dest'];
    }

    /**
     * Set the destination argument.
     *
     * @param string $dest
     *
     * @return ArchiveCommand
     */
    public function setDestination($dest)
    {
        $this->arguments['dest'] = escapeshellarg($dest);

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function __toString()
    {
        return sprintf(
            "%s%s %s",
            $this->name,
            $this->assembleOptionString(),
            $this->arguments['dest']
        );
    }
}
