<?php

/*
 * This file is part of ansi-to-html.
 *
 * (c) Fabien Potencier
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace SensioLabs\AnsiConverter\Bridge\Twig;

use SensioLabs\AnsiConverter\AnsiToHtmlConverter;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;
use Twig\TwigFunction;

class AnsiExtension extends AbstractExtension
{
    public function __construct(
        private AnsiToHtmlConverter $converter = new AnsiToHtmlConverter(),
    ) {
    }

    public function getFilters(): array
    {
        return [
            new TwigFilter('ansi_to_html', [$this, 'ansiToHtml'], ['is_safe' => ['html']]),
        ];
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('ansi_css', [$this, 'css'], ['is_safe' => ['css']]),
        ];
    }

    public function ansiToHtml($string)
    {
        return $this->converter->convert($string);
    }

    public function css(): string
    {
        return $this->converter->getTheme()->asCss();
    }
}
