<?php

namespace Elastica\Processor;

/**
 * Elastica Lowercase Processor.
 *
 * @author Federico Panini <fpanini@gmail.com>
 *
 * @see https://www.elastic.co/guide/en/elasticsearch/reference/current/lowercase-processor.html
 */
class Lowercase extends AbstractProcessor
{
    /**
     * Lowercase constructor.
     */
    public function __construct(string $field)
    {
        $this->setField($field);
    }

    /**
     * Set field.
     *
     * @return $this
     */
    public function setField(string $field): self
    {
        return $this->setParam('field', $field);
    }
}
