<?php

namespace Elastica\Test\Aggregation;


use Elastica\Aggregation\Avg;
use Elastica\Aggregation\GlobalAggregation;

class GlobalAggregationTest extends BaseAggregationTest
{
    public function testToArray()
    {
        $expected = array(
            "global" => array(),
            "aggs" => array(
                "avg_price" => array("avg" => array("field" => "price"))
            )
        );

        $agg = new GlobalAggregation("all_products");
        $avg = new Avg("avg_price");
        $avg->setField("price");
        $agg->addAggregation($avg);
        $this->assertEquals($expected, $agg->toArray());
    }
}
 