<?php

declare(strict_types=1);

namespace Elastica\Aggregation;

/**
 * Class PercentilesBucket.
 *
 * @see https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-pipeline-percentiles-bucket-aggregation.html
 */
class PercentilesBucket extends AbstractAggregation implements GapPolicyInterface
{
    use Traits\BucketsPathTrait;
    use Traits\GapPolicyTrait;
    use Traits\KeyedTrait;

    public function __construct(string $name, string $bucketsPath)
    {
        parent::__construct($name);

        $this->setBucketsPath($bucketsPath);
    }

    /**
     * Set the format for this aggregation.
     */
    public function setFormat(string $format): self
    {
        return $this->setParam('format', $format);
    }

    /**
     * Set which percents must be returned.
     *
     * @param float[] $percents
     */
    public function setPercents(array $percents): self
    {
        return $this->setParam('percents', $percents);
    }
}
