<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace RectorPrefix202602\Symfony\Component\Console\Messenger;

use RectorPrefix202602\Symfony\Component\Console\Application;
use RectorPrefix202602\Symfony\Component\Console\Command\Command;
use RectorPrefix202602\Symfony\Component\Console\Exception\RunCommandFailedException;
use RectorPrefix202602\Symfony\Component\Console\Input\StringInput;
use RectorPrefix202602\Symfony\Component\Console\Output\BufferedOutput;
use RectorPrefix202602\Symfony\Component\Messenger\Exception\RecoverableExceptionInterface;
use RectorPrefix202602\Symfony\Component\Messenger\Exception\UnrecoverableExceptionInterface;
/**
 * @author Kevin Bond <kevinbond@gmail.com>
 */
final class RunCommandMessageHandler
{
    /**
     * @readonly
     */
    private Application $application;
    public function __construct(Application $application)
    {
        $this->application = $application;
    }
    public function __invoke(RunCommandMessage $message): RunCommandContext
    {
        $input = new StringInput($message->input);
        $output = new BufferedOutput();
        $this->application->setCatchExceptions($message->catchExceptions);
        try {
            $exitCode = $this->application->run($input, $output);
        } catch (UnrecoverableExceptionInterface|RecoverableExceptionInterface $e) {
            throw $e;
        } catch (\Throwable $e) {
            throw new RunCommandFailedException($e, new RunCommandContext($message, Command::FAILURE, $output->fetch()));
        }
        if ($message->throwOnFailure && Command::SUCCESS !== $exitCode) {
            throw new RunCommandFailedException(\sprintf('Command "%s" exited with code "%s".', $message->input, $exitCode), new RunCommandContext($message, $exitCode, $output->fetch()));
        }
        return new RunCommandContext($message, $exitCode, $output->fetch());
    }
}
