<?php

declare (strict_types=1);
namespace Rector\BetterPhpDocParser\ValueObject;

use Rector\Core\Exception\ShouldNotHappenException;
final class StartAndEnd
{
    /**
     * @var int
     */
    private $start;
    /**
     * @var int
     */
    private $end;
    public function __construct(int $start, int $end)
    {
        $this->start = $start;
        $this->end = $end;
        if ($end < $start) {
            throw new \Rector\Core\Exception\ShouldNotHappenException();
        }
    }
    public function getStart() : int
    {
        return $this->start;
    }
    public function getEnd() : int
    {
        return $this->end;
    }
    public function contains(int $position) : bool
    {
        if ($position < $this->start) {
            return \false;
        }
        return $position < $this->end;
    }
}
