<?php declare(strict_types = 1);

namespace PHPStan\Type\Symfony;

use PhpParser\Node\Expr\MethodCall;
use PHPStan\Analyser\Scope;
use PHPStan\Reflection\MethodReflection;
use PHPStan\Type\Constant\ConstantBooleanType;
use PHPStan\Type\DynamicMethodReturnTypeExtension;
use PHPStan\Type\ResourceType;
use PHPStan\Type\StringType;
use PHPStan\Type\Type;

final class RequestDynamicReturnTypeExtension implements DynamicMethodReturnTypeExtension
{

	public function getClass(): string
	{
		return 'Symfony\Component\HttpFoundation\Request';
	}

	public function isMethodSupported(MethodReflection $methodReflection): bool
	{
		return $methodReflection->getName() === 'getContent';
	}

	public function getTypeFromMethodCall(
		MethodReflection $methodReflection,
		MethodCall $methodCall,
		Scope $scope
	): ?Type
	{
		if (!isset($methodCall->getArgs()[0])) {
			return new StringType();
		}

		$argType = $scope->getType($methodCall->getArgs()[0]->value);
		$isTrueType = (new ConstantBooleanType(true))->isSuperTypeOf($argType)->result;
		$isFalseType = (new ConstantBooleanType(false))->isSuperTypeOf($argType)->result;
		$compareTypes = $isTrueType->compareTo($isFalseType);
		if ($compareTypes === $isTrueType) {
			return new ResourceType();
		}
		if ($compareTypes === $isFalseType) {
			return new StringType();
		}

		return null;
	}

}
