<?php

declare(strict_types=1);

/**
 * This lists all of the possible real return types of various global functions.
 * This is useful because php won't provide many of these until php 8,
 * and even then won't be able to represent types such as string|false.
 *
 * This is conservative to avoid false positives, and includes types returned for all possible failure modes
 * (invalid arguments/argument counts, spurious errors, etc.)
 *
 * Generated by Phan's internal/extract_arg_info.php, from ext/opcache/Optimizer/zend_func_info.c of php-src.
 * (for the php 8.0-dev branch)
 *
 * Note that this has less entries than the php 7 map because Reflection already has accurate real types.
 * For accurate real condition detection of code targeting php 8.0-dev, run Phan with php 8.0-dev.
 */

return [
'_' => 'false|string',
'abs' => 'float|int',
'acos' => 'float',
'acosh' => 'float',
'addcslashes' => 'string',
'addslashes' => 'string',
'array_change_key_case' => 'array',
'array_chunk' => 'list<array>',
'array_column' => 'array',
'array_combine' => 'array',
'array_count_values' => 'int[]',
'array_diff' => 'array',
'array_diff_assoc' => 'array',
'array_diff_key' => 'array',
'array_diff_uassoc' => 'array',
'array_diff_ukey' => 'array',
'array_fill' => 'array<int,mixed>',
'array_fill_keys' => 'array',
'array_filter' => 'array',
'array_flip' => 'int[]|string[]',
'array_intersect' => 'array',
'array_intersect_assoc' => 'array',
'array_intersect_key' => 'array',
'array_intersect_uassoc' => 'array',
'array_intersect_ukey' => 'array',
'array_keys' => 'list<int>|list<string>',
'array_map' => 'array',
'array_merge' => 'array',
'array_merge_recursive' => 'array',
'array_pad' => 'array',
'array_replace' => 'array',
'array_replace_recursive' => 'array',
'array_reverse' => 'array',
'array_slice' => 'array',
'array_splice' => 'array',
'array_udiff' => 'array',
'array_udiff_assoc' => 'array',
'array_udiff_uassoc' => 'array',
'array_uintersect' => 'array',
'array_uintersect_assoc' => 'array',
'array_uintersect_uassoc' => 'array',
'array_unique' => 'array',
'array_values' => 'list<mixed>',
'array_walk' => 'true',
'array_walk_recursive' => 'true',
'arsort' => 'true',
'asort' => 'true',
'assert_options' => '?array<int,object>|?array<int,string>|?false|?int|?object|?string',
'base64_decode' => 'false|string',
'base64_encode' => 'string',
'base_convert' => 'string',
'basename' => 'string',
'bcadd' => 'string',
'bcdiv' => 'string',
'bcmod' => 'string',
'bcmul' => 'string',
'bcpow' => 'string',
'bcpowmod' => 'false|string',
'bcsqrt' => 'string',
'bcsub' => 'string',
'bin2hex' => 'string',
'bind_textdomain_codeset' => 'false|string',
'bindtextdomain' => 'false|string',
'chr' => 'string',
'chunk_split' => 'string',
'class_alias' => 'bool',
'class_exists' => 'bool',
'class_implements' => 'array<string,string>|false',
'class_parents' => 'array<string,string>|false',
'class_uses' => 'array<string,string>|false',
'closedir' => 'void',
'closelog' => 'true',
'collator_asort' => 'bool',
'collator_compare' => 'false|int',
'collator_create' => '?\Collator',
'collator_get_attribute' => 'false|int',
'collator_get_error_code' => 'false|int',
'collator_get_error_message' => 'false|string',
'collator_get_locale' => 'false|string',
'collator_get_sort_key' => 'false|string',
'collator_get_strength' => 'int',
'collator_set_attribute' => 'bool',
'collator_set_strength' => 'bool',
'collator_sort' => 'bool',
'collator_sort_with_sort_keys' => 'bool',
'compact' => 'array<string,mixed>',
'constant' => '?array|?bool|?float|?int|?resource|?string',
'Closure::bind' => '?\Closure',
'Closure::bindTo' => '?\Closure',
'Closure::call' => 'mixed',
'Closure::fromCallable' => '\Closure',
'connection_aborted' => 'int',
'connection_status' => 'int',
'convert_uudecode' => 'false|string',
'convert_uuencode' => 'string',
'copy' => 'bool',
'cos' => 'float',
'cosh' => 'float',
'count' => 'int',
'count_chars' => 'array<int,int>|string',
'crc32' => 'int',
'crypt' => 'string',
'ctype_alnum' => 'bool',
'ctype_alpha' => 'bool',
'ctype_cntrl' => 'bool',
'ctype_digit' => 'bool',
'ctype_graph' => 'bool',
'ctype_lower' => 'bool',
'ctype_print' => 'bool',
'ctype_punct' => 'bool',
'ctype_space' => 'bool',
'ctype_upper' => 'bool',
'ctype_xdigit' => 'bool',
'curl_close' => 'void',
'curl_copy_handle' => '\CurlHandle|false',
'curl_errno' => 'int',
'curl_error' => 'string',
'curl_escape' => 'false|string',
'curl_exec' => 'bool|string',
'curl_file_create' => '\CURLFile',
'curl_getinfo' => 'mixed',
'curl_init' => '\CurlHandle|false',
'curl_multi_add_handle' => 'int',
'curl_multi_close' => 'void',
'curl_multi_errno' => 'int',
'curl_multi_exec' => 'int',
'curl_multi_getcontent' => '?string',
'curl_multi_info_read' => 'array|false',
'curl_multi_init' => '\CurlMultiHandle',
'curl_multi_remove_handle' => 'int',
'curl_multi_select' => 'int',
'curl_multi_setopt' => 'bool',
'curl_multi_strerror' => '?string',
'curl_pause' => 'int',
'curl_reset' => 'void',
'curl_setopt' => 'bool',
'curl_setopt_array' => 'bool',
'curl_share_close' => 'void',
'curl_share_errno' => 'int',
'curl_share_init' => '\CurlShareHandle',
'curl_share_setopt' => 'bool',
'curl_share_strerror' => '?string',
'curl_strerror' => '?string',
'curl_unescape' => 'false|string',
'curl_version' => 'array<string,array>|array<string,int>|array<string,string>|false',
'date' => 'string',
'date_create' => 'false|object',
'date_create_from_format' => 'false|object',
'date_create_immutable' => 'false|object',
'date_create_immutable_from_format' => 'false|object',
'date_default_timezone_get' => 'string',
'date_diff' => 'object',
'date_format' => 'string',
'date_get_last_errors' => 'array<string,array>|array<string,int>|false',
'date_interval_create_from_date_string' => 'false|object',
'date_interval_format' => 'string',
'date_parse' => 'array<string,mixed>',
'date_parse_from_format' => 'array<string,mixed>',
'date_sun_info' => 'array<string,bool>|array<string,int>',
'date_sunrise' => 'false|float|int|string',
'date_sunset' => 'false|float|int|string',
'date_timezone_get' => 'false|object',
'datefmt_create' => '?\IntlDateFormatter',
'datefmt_format' => 'false|string',
'datefmt_format_object' => 'false|string',
'datefmt_get_calendar' => 'false|int',
'datefmt_get_calendar_object' => '\IntlCalendar|false|null',
'datefmt_get_datetype' => 'false|int',
'datefmt_get_error_code' => 'int',
'datefmt_get_error_message' => 'string',
'datefmt_get_locale' => 'false|string',
'datefmt_get_pattern' => 'false|string',
'datefmt_get_timetype' => 'false|int',
'datefmt_get_timezone' => '\IntlTimeZone|false',
'datefmt_get_timezone_id' => 'false|string',
'datefmt_is_lenient' => 'bool',
'datefmt_localtime' => 'array|false',
'datefmt_parse' => 'false|float|int',
'datefmt_set_calendar' => 'bool',
'datefmt_set_lenient' => 'void',
'datefmt_set_pattern' => 'bool',
// 'datefmt_set_timezone' => '?bool',
'dcgettext' => 'false|string',
'dcngettext' => 'false|string',
'debug_backtrace' => 'list<array>',
'debug_print_backtrace' => 'void',
'debug_zval_dump' => 'void',
'decbin' => 'string',
'dechex' => 'string',
'decoct' => 'string',
'dgettext' => 'false|string',
'dir' => 'false|object',
'dirname' => 'string',
'dns_get_record' => 'list<array>|false',
'error_get_last' => '?array{type:int,message:string,file:string,line:int}',
'escapeshellarg' => 'string',
'escapeshellcmd' => 'string',
'exec' => 'false|string',
'exif_read_data' => 'array<string,mixed>|false',
'exif_tagname' => 'false|string',
'exif_thumbnail' => 'false|string',
'explode' => 'list<string>',
'fgetc' => 'false|string',
'fgetcsv' => '?list<?string>|?false',
'fgets' => 'false|string',
'file' => 'list<string>|false',
'file_get_contents' => 'false|string',
'filetype' => 'false|string',
'filter_input_array' => '?array|?false',
'filter_list' => 'list<string>',
'filter_var_array' => '?array|?false',
'finfo_buffer' => 'false|string',
'finfo_file' => 'false|string',
'finfo_open' => 'false|resource',
'finfo_set_flags' => 'bool',
'floatval' => 'float',
'flock' => 'bool',
'floor' => 'float',
'flush' => 'void',
'fmod' => 'float',
'fnmatch' => 'bool',
'fopen' => 'false|resource',
'forward_static_call' => 'mixed',
'forward_static_call_array' => 'mixed',
'fpassthru' => 'int',
'fprintf' => 'int',
'fputcsv' => 'false|int',
'fputs' => 'false|int',
'fread' => 'false|string',
'fscanf' => '?list<mixed>|?false|?int',
'fsockopen' => 'false|resource',
'fstat' => 'false|int[]',
'func_get_args' => 'list<mixed>|false',
'gd_info' => 'array<string,bool>|array<string,string>',
'get_browser' => 'array<string,mixed>|false|object',
'get_cfg_var' => 'array[]|false|string|string[]',
'get_class_methods' => '?list<string>|?false',
'get_class_vars' => 'array<string,mixed>|false',
'get_current_user' => 'string',
'get_declared_classes' => 'list<string>',
'get_declared_interfaces' => 'list<string>',
'get_declared_traits' => 'list<string>',
'get_defined_constants' => 'array<string,?array>|array<string,?bool>|array<string,?float>|array<string,?int>|array<string,?resource>|array<string,?string>',
'get_defined_functions' => 'array<string,array>',
'get_defined_vars' => 'array<string,mixed>',
'get_extension_funcs' => 'list<string>|false',
'get_headers' => 'array[]|false|string[]',
'get_html_translation_table' => 'array<string,string>',
'get_include_path' => 'false|string',
'get_included_files' => 'list<string>',
'get_loaded_extensions' => 'list<string>',
'get_magic_quotes_gpc' => 'false',
'get_magic_quotes_runtime' => 'false',
'get_mangled_object_vars' => 'array',
'get_meta_tags' => 'array<string,string>|false',
'get_object_vars' => 'array',
'get_resource_type' => 'string',
'getcwd' => 'false|string',
'getdate' => 'array<string,int>|array<string,string>',
'getenv' => 'array<string,string>|false|string',
'gethostbyaddr' => 'false|string',
'gethostbyname' => 'string',
'gethostbynamel' => 'list<string>|false',
'gethostname' => 'false|string',
'getimagesize' => 'false|int[]|string[]',
'getimagesizefromstring' => 'false|int[]|string[]',
'getopt' => 'array[]|bool[]|false|string[]',
'getprotobynumber' => 'false|string',
'getrusage' => 'array<string,int>|false',
'getservbyport' => 'false|string',
'gettext' => 'false|string',
'gettimeofday' => 'array<string,int>|float',
'glob' => 'list<string>|false',
'gmdate' => 'string',
'gmmktime' => 'false|int',
'gmp_abs' => '\GMP',
'gmp_add' => '\GMP',
'gmp_and' => '\GMP',
'gmp_binomial' => '\GMP',
'gmp_clrbit' => 'void',
'gmp_cmp' => 'int',
'gmp_com' => '\GMP',
'gmp_div' => '\GMP',
'gmp_div_q' => '\GMP',
'gmp_div_qr' => 'array',
'gmp_div_r' => '\GMP',
'gmp_divexact' => '\GMP',
'gmp_export' => 'string',
'gmp_fact' => '\GMP',
'gmp_gcd' => '\GMP',
'gmp_gcdext' => 'array',
'gmp_hamdist' => 'int',
'gmp_import' => '\GMP',
'gmp_init' => '\GMP',
'gmp_intval' => 'int',
'gmp_invert' => '\GMP|false',
'gmp_jacobi' => 'int',
'gmp_kronecker' => 'int',
'gmp_lcm' => '\GMP',
'gmp_legendre' => 'int',
'gmp_mod' => '\GMP',
'gmp_mul' => '\GMP',
'gmp_neg' => '\GMP',
'gmp_nextprime' => '\GMP',
'gmp_or' => '\GMP',
'gmp_perfect_power' => 'bool',
'gmp_perfect_square' => 'bool',
'gmp_popcount' => 'int',
'gmp_pow' => '\GMP',
'gmp_powm' => '\GMP',
'gmp_prob_prime' => 'int',
'gmp_random_bits' => '\GMP',
'gmp_random_range' => '\GMP',
'gmp_random_seed' => 'void',
'gmp_root' => '\GMP',
'gmp_rootrem' => 'array',
'gmp_scan0' => 'int',
'gmp_scan1' => 'int',
'gmp_setbit' => 'void',
'gmp_sign' => 'int',
'gmp_sqrt' => '\GMP',
'gmp_sqrtrem' => 'array',
'gmp_strval' => 'string',
'gmp_sub' => '\GMP',
'gmp_testbit' => 'bool',
'gmp_xor' => '\GMP',
'gmstrftime' => 'false|string',
'grapheme_extract' => 'false|string',
'grapheme_stripos' => 'false|int',
'grapheme_stristr' => 'false|string',
'grapheme_strlen' => 'false|int|null',
'grapheme_strpos' => 'false|int',
'grapheme_strripos' => 'false|int',
'grapheme_strrpos' => 'false|int',
'grapheme_strstr' => 'false|string',
'grapheme_substr' => 'false|string',
'gregoriantojd' => 'int',
'gzclose' => 'bool',
'gzcompress' => 'false|string',
'gzdecode' => 'false|string',
'gzdeflate' => 'false|string',
'gzencode' => 'false|string',
'gzfile' => 'list<string>|false',
'gzgetc' => 'false|string',
'gzgets' => 'false|string',
'gzinflate' => 'false|string',
'gzopen' => '?false|?resource',
'gzpassthru' => 'int',
'gzputs' => 'false|int',
'gzread' => 'false|string',
'gzrewind' => 'bool',
'gzseek' => 'int',
'gztell' => 'false|int',
'gzuncompress' => 'false|string',
'gzwrite' => 'false|int',
'hash' => 'false|string',
'hash_algos' => 'list<string>',
'hash_copy' => 'object',
'hash_file' => 'false|string',
'hash_final' => 'string',
'hash_hkdf' => 'string',
'hash_hmac' => 'false|string',
'hash_hmac_algos' => 'list<string>',
'hash_hmac_file' => 'false|string',
'hash_init' => '\HashContext',
'hash_pbkdf2' => 'string',
'hash_update' => 'bool',
'hash_update_file' => 'bool',
'hash_update_stream' => 'int',
'header' => 'void',
'header_register_callback' => 'bool',
'header_remove' => 'void',
'headers_list' => 'array',
'headers_sent' => 'bool',
'hebrev' => 'string',
'hex2bin' => 'false|string',
'hexdec' => 'float|int',
'highlight_file' => 'bool|string',
'highlight_string' => 'bool|string',
'hrtime' => 'array|false|float|int',
'html_entity_decode' => 'string',
'htmlentities' => 'string',
'htmlspecialchars' => 'string',
'htmlspecialchars_decode' => 'string',
'http_build_query' => 'string',
'http_response_code' => 'bool|int',
'hypot' => 'float',
'iconv' => 'false|string',
'iconv_get_encoding' => 'array<string,string>|false|string',
'iconv_mime_decode' => 'false|string',
'iconv_mime_decode_headers' => 'array<string,array>|array<string,string>|false',
'iconv_mime_encode' => 'false|string',
'iconv_substr' => 'false|string',
'image_type_to_extension' => 'false|string',
'image_type_to_mime_type' => 'string',
'imageaffine' => '\GdImage|false',
'imageaffinematrixconcat' => 'array<int,float>|false',
'imageaffinematrixget' => 'array<int,float>|false',
'imagealphablending' => 'bool',
'imagebmp' => 'bool',
'imagechar' => 'bool',
'imagecharup' => 'bool',
'imagecolorallocatealpha' => 'false|int',
'imagecolorallocate' => 'false|int',
'imagecolorat' => 'false|int',
'imagecolorclosestalpha' => 'false|int',
'imagecolorclosest' => 'false|int',
'imagecolorclosesthwb' => 'false|int',
'imagecolordeallocate' => 'bool',
'imagecolorexactalpha' => 'false|int',
'imagecolorexact' => 'false|int',
'imagecolormatch' => 'bool',
'imagecolorresolvealpha' => 'false|int',
'imagecolorresolve' => 'false|int',
'imagecolorset' => '?false',
'imagecolorsforindex' => 'array<string,int>|false',
'imageconvolution' => 'bool',
'imagecopy' => 'bool',
'imagecopymerge' => 'bool',
'imagecopymergegray' => 'bool',
'imagecopyresampled' => 'bool',
'imagecopyresized' => 'bool',
'imagecreate' => '\GdImage|false',
'imagecreatefrombmp' => '\GdImage|false',
'imagecreatefromgd' => '\GdImage|false',
'imagecreatefromgd2' => '\GdImage|false',
'imagecreatefromgd2part' => '\GdImage|false',
'imagecreatefromgif' => '\GdImage|false',
'imagecreatefromjpeg' => '\GdImage|false',
'imagecreatefrompng' => '\GdImage|false',
'imagecreatefromstring' => '\GdImage|false',
'imagecreatefromtga' => '\GdImage|false',
'imagecreatefromwbmp' => '\GdImage|false',
'imagecreatefromwebp' => 'false|object',
'imagecreatefromxbm' => '\GdImage|false',
'imagecreatefromxpm' => '\GdImage|false',
'imagecreatetruecolor' => '\GdImage|false',
'imagecrop' => '\GdImage|false',
'imagecropauto' => '\GdImage|false',
'imagefill' => 'bool',
'imagefilledarc' => 'bool',
'imagefilledellipse' => 'bool',
'imagefilledpolygon' => 'bool',
'imagefilledrectangle' => 'bool',
'imagefilltoborder' => 'bool',
'imagefilter' => 'bool',
'imageflip' => 'bool',
'imagefontheight' => 'int',
'imagefontwidth' => 'int',
'imageftbbox' => 'array<int,int>|false',
'imagefttext' => 'array<int,int>|false',
'imagegammacorrect' => 'bool',
'imagegd' => 'bool',
'imagegd2' => 'bool',
'imagegetclip' => 'array<int,int>',
'imagegetinterpolation' => 'int',
'imagegif' => 'bool',
'imagegrabscreen' => 'false|object',
'imagegrabwindow' => 'false|object',
'imageloadfont' => 'false|int',
'imageopenpolygon' => 'bool',
'imagepalettecopy' => 'void',
'imagepalettetotruecolor' => 'bool',
'imagepng' => 'bool',
'imagepolygon' => 'bool',
'imagerectangle' => 'bool',
'imageresolution' => 'array<int,int>|true',
'imagerotate' => 'false|GdImage',
'imagesavealpha' => 'bool',
'imagescale' => '\GdImage|false',
'imagesetbrush' => 'bool',
'imagesetclip' => 'bool',
'imagesetinterpolation' => 'bool',
'imagesetpixel' => 'bool',
'imagesetstyle' => 'bool',
'imagesetthickness' => 'bool',
'imagesettile' => 'bool',
'imagestring' => 'bool',
'imagestringup' => 'bool',
'imagesx' => 'int',
'imagesy' => 'int',
'imagetruecolortopalette' => 'bool',
'imagettfbbox' => 'array<int,int>|false',
'imagettftext' => 'array<int,int>|false',
'imagetypes' => 'int',
'imagewbmp' => 'bool',
'imagexbm' => 'bool',
'implode' => 'string',
'in_array' => 'bool',
'inet_ntop' => 'false|string',
'inet_pton' => 'false|string',
'ini_alter' => 'false|string',
'ini_get_all' => 'array<string,?array>|array<string,?string>|false',
'iptcembed' => 'false|string',
'iptcparse' => 'array<string,array>|false',
'iterator_to_array' => 'array',
'json_encode' => 'false|string',
'json_last_error_msg' => 'string',
'krsort' => 'true',
'ksort' => 'true',
'localeconv' => 'array<string,array>|array<string,int>|array<string,string>',
'localtime' => 'int[]',
'long2ip' => 'false|string',
'lstat' => 'bool[]|false|int[]|string[]',
'mb_convert_case' => 'false|string',
'mb_convert_encoding' => 'array|false|string',
'mb_convert_kana' => 'false|string',
'mb_convert_variables' => 'false|string',
'mb_decode_mimeheader' => 'false|string',
'mb_decode_numericentity' => 'false|string',
'mb_detect_encoding' => 'false|string',
'mb_detect_order' => 'list<string>|false',
'mb_encode_mimeheader' => 'false|string',
'mb_encode_numericentity' => 'false|string',
'mb_encoding_aliases' => 'list<string>|false',
'mb_ereg_replace' => '?false|?string',
'mb_ereg_replace_callback' => '?false|?string',
'mb_ereg_search_getregs' => 'array<int,bool>|array<int,string>|false',
'mb_ereg_search_pos' => 'array<int,int>|false',
'mb_ereg_search_regs' => 'array<int,bool>|array<int,string>|false',
'mb_eregi_replace' => '?false|?string',
'mb_get_info' => 'array[]|false|int|int[]|string|string[]',
'mb_http_input' => 'array<int,string>|false|string',
'mb_http_output' => 'bool|string',
'mb_internal_encoding' => 'bool|string',
'mb_language' => 'bool|string',
'mb_list_encodings' => 'array<int,string>',
'mb_output_handler' => 'string',
'mb_preferred_mime_name' => 'false|string',
'mb_regex_encoding' => 'bool|string',
'mb_regex_set_options' => 'string',
'mb_split' => 'list<string>|false',
'mb_strcut' => 'false|string',
'mb_strimwidth' => 'false|string',
'mb_stristr' => 'false|string',
'mb_strrchr' => 'false|string',
'mb_strrichr' => 'false|string',
'mb_strstr' => 'false|string',
'mb_strtolower' => 'false|string',
'mb_strtoupper' => 'false|string',
'mb_substitute_character' => 'bool|int|string',
'mb_substr' => 'false|string',
'md5' => 'string',
'md5_file' => 'false|string',
'metaphone' => 'false|string',
'mhash' => 'false|string',
'mhash_get_hash_name' => '?false|?string',
'mhash_keygen_s2k' => '?false|?string',
'microtime' => 'float|string',
'mime_content_type' => 'false|string',
'mysqli_affected_rows' => '?int|?string',
'mysqli_autocommit' => '?bool',
'mysqli_begin_transaction' => '?bool',
'mysqli_change_user' => '?bool',
'mysqli_character_set_name' => '?string',
'mysqli_close' => '?true',
'mysqli_commit' => '?bool',
'mysqli_connect' => '?false|?object',
'mysqli_connect_errno' => 'int',
'mysqli_connect_error' => '?string',
'mysqli_data_seek' => '?bool',
'mysqli_debug' => '?true',
'mysqli_dump_debug_info' => '?bool',
'mysqli_errno' => '?int',
'mysqli_error' => '?string',
'mysqli_error_list' => '?array<int,array>',
'mysqli_fetch_all' => '?array|?false',
'mysqli_fetch_array' => '?array|?false',
'mysqli_fetch_assoc' => '?array<string,mixed>|?false',
'mysqli_fetch_field' => '?false|?object',
'mysqli_fetch_field_direct' => '?false|?object',
'mysqli_fetch_fields' => '?array<int,object>',
'mysqli_fetch_lengths' => '?array<int,int>|?false',
'mysqli_fetch_object' => '?false|?object',
'mysqli_fetch_row' => '?array<int,mixed>|?false',
'mysqli_field_count' => '?int',
'mysqli_field_seek' => '?bool',
'mysqli_field_tell' => '?int',
'mysqli_free_result' => 'void',
'mysqli_get_client_info' => 'string',
'mysqli_get_client_version' => 'int',
'mysqli_get_host_info' => '?string',
'mysqli_get_links_stats' => '?array<string,int>',
'mysqli_get_proto_info' => '?int',
'mysqli_get_server_info' => '?string',
'mysqli_get_server_version' => '?int',
'mysqli_get_warnings' => '?false|?object',
'mysqli_info' => '?string',
'mysqli_init' => 'false|object',
'mysqli_kill' => '?bool',
'mysqli_more_results' => '?bool',
'mysqli_multi_query' => '?bool',
'mysqli_next_result' => '?bool',
'mysqli_num_fields' => '?false|?int',
'mysqli_num_rows' => '?false|?int|?string',
'mysqli_options' => '?bool',
'mysqli_ping' => '?bool',
'mysqli_poll' => '?false|?int',
'mysqli_prepare' => '?false|?object',
'mysqli_query' => '?bool|?object',
'mysqli_real_connect' => '?bool',
'mysqli_real_escape_string' => '?string',
'mysqli_real_query' => '?bool',
'mysqli_reap_async_query' => '?bool|?object',
'mysqli_refresh' => '?bool',
'mysqli_release_savepoint' => '?bool',
'mysqli_rollback' => '?bool',
'mysqli_savepoint' => '?bool',
'mysqli_select_db' => '?bool',
'mysqli_set_charset' => '?bool',
'mysqli_sqlstate' => '?string',
'mysqli_ssl_set' => '?true',
'mysqli_stmt_attr_get' => '?false|?int',
'mysqli_stmt_attr_set' => '?bool',
'mysqli_stmt_bind_param' => '?bool',
'mysqli_stmt_bind_result' => '?bool',
'mysqli_stmt_close' => '?bool',
'mysqli_stmt_data_seek' => '?false',
'mysqli_stmt_errno' => '?int',
'mysqli_stmt_error' => '?string',
'mysqli_stmt_error_list' => '?array<int,array>',
'mysqli_stmt_execute' => '?bool',
'mysqli_stmt_fetch' => '?bool',
'mysqli_stmt_field_count' => '?int',
'mysqli_stmt_free_result' => 'void',
'mysqli_stmt_get_result' => '?false|?object',
'mysqli_stmt_get_warnings' => '?false|?object',
'mysqli_stmt_init' => '?false|?object',
'mysqli_stmt_insert_id' => '?int|?string',
'mysqli_stmt_more_results' => '?bool',
'mysqli_stmt_next_result' => '?bool',
'mysqli_stmt_num_rows' => '?int|?string',
'mysqli_stmt_param_count' => '?int',
'mysqli_stmt_prepare' => '?bool',
'mysqli_stmt_reset' => '?bool',
'mysqli_stmt_result_metadata' => '?false|?object',
'mysqli_stmt_send_long_data' => '?bool',
'mysqli_stmt_sqlstate' => '?string',
'mysqli_stmt_store_result' => '?bool',
'mysqli_store_result' => '?false|?object',
'mysqli_thread_id' => '?int',
'mysqli_thread_safe' => 'bool',
'mysqli_use_result' => '?false|?object',
'mysqli_warning_count' => '?int',
'ngettext' => 'false|string',
'nl_langinfo' => 'false|string',
'number_format' => 'string',
'ob_get_clean' => 'false|string',
'ob_get_flush' => 'false|string',
'ob_get_status' => 'array[]|int[]|string[]',
'ob_gzhandler' => 'false|string',
'ob_list_handlers' => 'list<string>',
'opendir' => 'false|resource',
'pack' => 'false|string',
'parse_ini_file' => '(?array)[]|(?bool)[]|(?float)[]|(?int)[]|(?string)[]|false',
'parse_ini_string' => '(?array)[]|(?bool)[]|(?float)[]|(?int)[]|(?string)[]|false',
'parse_url' => 'array|false|int|null|string',
'passthru' => '?false',
'password_get_info' => '?array<string,array>|?array<string,int>|?array<string,string>',
'password_hash' => 'string',
'pathinfo' => 'array|string',
'pfsockopen' => 'false|resource',
'pg_affected_rows' => '?false|?int',
'pg_cancel_query' => 'bool',
'pg_close' => '?bool',
'pg_connect' => '?false|?resource',
'pg_connect_poll' => '?false|?int',
'pg_connection_busy' => 'bool',
'pg_connection_reset' => 'bool',
'pg_connection_status' => 'false|int',
'pg_consume_input' => '?bool',
'pg_convert' => '?array<string,mixed>|?false',
'pg_copy_from' => '?bool',
'pg_copy_to' => '?array<int,string>|?false',
'pg_dbname' => '?false|?string',
'pg_delete' => '?bool|?string',
'pg_end_copy' => '?bool',
'pg_escape_bytea' => '?false|?string',
'pg_escape_identifier' => '?false|?string',
'pg_escape_literal' => '?false|?string',
'pg_escape_string' => '?false|?string',
'pg_execute' => '?false|?resource',
'pg_fetch_all' => '?array<int,array>|?false',
'pg_fetch_all_columns' => '?array<int,?string>|?false',
'pg_fetch_array' => '?(?string)[]|?false',
'pg_fetch_assoc' => '?array<string,?string>|?false',
'pg_fetch_object' => '?false|?object',
'pg_fetch_result' => '?false|?string',
'pg_fetch_row' => '?array<int,?string>|?false',
'pg_field_is_null' => '?false|?int',
'pg_field_name' => '?false|?string',
'pg_field_num' => '?false|?int',
'pg_field_prtlen' => '?false|?int',
'pg_field_size' => '?false|?int',
'pg_field_table' => '?false|?int|?string',
'pg_field_type' => '?false|?string',
'pg_field_type_oid' => '?false|?int|?string',
'pg_flush' => '?bool|?int',
'pg_free_result' => '?bool',
'pg_get_notify' => 'array|false',
'pg_get_pid' => 'false|int',
'pg_get_result' => 'false|resource',
'pg_host' => '?false|?string',
'pg_insert' => '?bool|?resource|?string',
'pg_last_error' => '?false|?string',
'pg_last_oid' => '?false|?int|?string',
'pg_lo_create' => '?false|?int|?string',
'pg_lo_export' => '?bool',
'pg_lo_import' => '?false|?int|?string',
'pg_lo_open' => '?false|?resource',
'pg_lo_read' => '?false|?string',
'pg_lo_read_all' => '?false|?int',
'pg_lo_seek' => '?bool',
'pg_lo_tell' => '?false|?int',
'pg_lo_truncate' => '?bool',
'pg_lo_unlink' => '?bool',
'pg_lo_write' => '?false|?int',
'pg_meta_data' => '?array<string,array>|?false',
'pg_num_fields' => '?false|?int',
'pg_num_rows' => '?false|?int',
'pg_options' => '?false|?string',
'pg_parameter_status' => 'false|string',
'pg_pconnect' => '?false|?resource',
'pg_ping' => 'bool',
'pg_port' => '?false|?string',
'pg_prepare' => '?false|?resource',
'pg_put_line' => '?bool',
'pg_query' => '?false|?resource',
'pg_query_params' => '?false|?resource',
'pg_result_error' => 'false|string',
'pg_result_error_field' => 'false|null|string',
'pg_result_seek' => '?bool',
'pg_result_status' => '?false|?int|?string',
'pg_select' => '?bool|?string',
'pg_send_execute' => '?bool|?int',
'pg_send_prepare' => '?bool|?int',
'pg_send_query' => '?bool|?int',
'pg_send_query_params' => '?bool|?int',
'pg_set_client_encoding' => '?false|?int',
'pg_set_error_verbosity' => '?false|?int',
'pg_socket' => '?false|?resource',
'pg_trace' => '?bool',
'pg_transaction_status' => 'false|int',
'pg_tty' => '?false|?string',
'pg_unescape_bytea' => '?false|?string',
'pg_untrace' => '?bool',
'pg_update' => '?bool|?string',
'pg_version' => '?array<string,string>|?false',
'php_ini_loaded_file' => 'false|string',
'php_ini_scanned_files' => 'false|string',
'php_sapi_name' => 'false|string',
'php_strip_whitespace' => 'string',
'php_uname' => 'string',
'phpcredits' => 'true',
'phpinfo' => 'true',
'phpversion' => 'false|string',
'popen' => 'false|resource',
'pow' => '?float|?int|?object',
'preg_filter' => '?string|?string[]',
'preg_grep' => 'array|false',
'preg_replace' => '?string|?string[]',
'preg_replace_callback' => '?string|?string[]',
'preg_split' => '?list<array>|?list<string>|?false',
'print_r' => 'string|true',
'proc_get_status' => 'array<string,bool>|array<string,int>|array<string,string>',
'proc_open' => 'false|resource',
'quoted_printable_decode' => 'string',
'quoted_printable_encode' => 'string',
'quotemeta' => 'string',
'random_bytes' => 'string',
'rawurldecode' => 'string',
'rawurlencode' => 'string',
'readdir' => 'false|string',
'readlink' => 'false|string',
'realpath' => 'false|string',
'realpath_cache_get' => 'array<string,array>',
'register_shutdown_function' => '?false',
'restore_error_handler' => 'true',
'restore_exception_handler' => 'true',
'scandir' => 'list<string>|false',
'serialize' => 'string',
'session_cache_limiter' => 'false|string',
'session_create_id' => 'false|string',
'session_encode' => 'false|string',
'session_get_cookie_params' => 'array<string,mixed>',
'session_module_name' => 'false|string',
'session_name' => 'false|string',
'session_save_path' => 'false|string',
'set_error_handler' => '?callable',
'set_include_path' => 'false|string',
'sha1' => 'string',
'sha1_file' => 'false|string',
'shell_exec' => '?false|?string',
'shm_has_var' => 'bool',
'shm_put_var' => 'bool',
'shm_remove' => 'bool',
'shm_remove_var' => 'bool',
'shmop_close' => 'void',
'shmop_delete' => 'bool',
'shmop_open' => '\Shmop|false',
'shmop_read' => 'string',
'shmop_size' => 'int',
'shmop_write' => 'int',
'show_source' => 'false|string',
'shuffle' => 'true',
'similar_text' => 'int',
'simplexml_import_dom' => '?\SimpleXMLElement',
'simplexml_load_file' => '\SimpleXMLElement|false',
'simplexml_load_string' => '\SimpleXMLElement|false',
'SimpleXMLElement::__toString' => 'string',
'SimpleXMLIterator::__toString' => 'string',
'sin' => 'float',
'sinh' => 'float',
'sizeof' => 'int',
'sleep' => 'int',
'SoapFault::__toString' => 'string',
'SoapFault::getFile' => 'string',
'SoapFault::getLine' => 'int',
'SoapFault::getMessage' => 'string',
'SoapFault::getPrevious' => '?\Throwable',
'SoapFault::getTrace' => 'array',
'SoapFault::getTraceAsString' => 'string',
'socket_accept' => '\Socket|false',
'socket_addrinfo_bind' => '\Socket|false',
'socket_addrinfo_connect' => '\Socket|false',
'socket_addrinfo_explain' => 'array',
'socket_addrinfo_lookup' => 'array|false',
'socket_bind' => 'bool',
'socket_clear_error' => 'void',
'socket_close' => 'void',
'socket_cmsg_space' => '?int',
'socket_connect' => 'bool',
'socket_create' => '\Socket|false',
'socket_create_listen' => '\Socket|false',
'socket_create_pair' => '?bool',
'socket_get_option' => 'array|false|int',
'socket_get_status' => 'array<string,mixed>',
'socket_getopt' => 'array|false|int',
'socket_getpeername' => 'bool',
'socket_getsockname' => 'bool',
'socket_import_stream' => '\Socket|false',
'socket_last_error' => 'int',
'socket_listen' => 'bool',
'socket_read' => 'false|string',
'socket_recv' => 'false|int',
'socket_recvfrom' => 'false|int',
'socket_recvmsg' => 'false|int',
'socket_select' => 'false|int',
'socket_send' => 'false|int',
'socket_sendmsg' => 'false|int',
'socket_sendto' => 'false|int',
'socket_set_block' => 'bool',
'socket_set_blocking' => 'bool',
'socket_set_nonblock' => 'bool',
'socket_set_option' => 'bool',
'socket_set_timeout' => 'bool',
'socket_setopt' => 'bool',
'socket_shutdown' => 'bool',
'socket_strerror' => 'string',
'socket_write' => 'false|int',
'sodium_bin2hex' => 'string',
'sodium_crypto_aead_aes256gcm_decrypt' => 'false|string',
'sodium_crypto_aead_aes256gcm_encrypt' => 'string',
'sodium_crypto_aead_aes256gcm_keygen' => 'string',
'sodium_crypto_aead_chacha20poly1305_decrypt' => 'false|string',
'sodium_crypto_aead_chacha20poly1305_encrypt' => 'string',
'sodium_crypto_aead_chacha20poly1305_ietf_decrypt' => 'false|string',
'sodium_crypto_aead_chacha20poly1305_ietf_encrypt' => 'string',
'sodium_crypto_aead_chacha20poly1305_ietf_keygen' => 'string',
'sodium_crypto_aead_chacha20poly1305_keygen' => 'string',
'sodium_crypto_aead_xchacha20poly1305_ietf_decrypt' => 'false|string',
'sodium_crypto_aead_xchacha20poly1305_ietf_encrypt' => 'string',
'sodium_crypto_aead_xchacha20poly1305_ietf_keygen' => 'string',
'sodium_crypto_auth' => 'string',
'sodium_crypto_auth_keygen' => 'string',
'sodium_crypto_box' => 'string',
'sodium_crypto_box_keypair' => 'string',
'sodium_crypto_box_keypair_from_secretkey_and_publickey' => 'string',
'sodium_crypto_box_open' => 'false|string',
'sodium_crypto_box_publickey' => 'string',
'sodium_crypto_box_publickey_from_secretkey' => 'string',
'sodium_crypto_box_seal' => 'string',
'sodium_crypto_box_seal_open' => 'false|string',
'sodium_crypto_box_secretkey' => 'string',
'sodium_crypto_box_seed_keypair' => 'string',
'sodium_crypto_generichash' => 'string',
'sodium_crypto_generichash_final' => 'string',
'sodium_crypto_generichash_init' => 'string',
'sodium_crypto_generichash_keygen' => 'string',
'sodium_crypto_generichash_update' => 'true',
'sodium_crypto_kdf_derive_from_key' => 'string',
'sodium_crypto_kdf_keygen' => 'string',
'sodium_crypto_kx_client_session_keys' => 'array<int,string>',
'sodium_crypto_kx_keypair' => 'string',
'sodium_crypto_kx_publickey' => 'string',
'sodium_crypto_kx_secretkey' => 'string',
'sodium_crypto_kx_seed_keypair' => 'string',
'sodium_crypto_kx_server_session_keys' => 'array<int,string>',
'sodium_crypto_pwhash' => 'string',
'sodium_crypto_pwhash_scryptsalsa208sha256' => 'string',
'sodium_crypto_pwhash_scryptsalsa208sha256_str' => 'string',
'sodium_crypto_pwhash_str' => 'string',
'sodium_crypto_scalarmult' => 'string',
'sodium_crypto_secretbox' => 'string',
'sodium_crypto_secretbox_keygen' => 'string',
'sodium_crypto_secretbox_open' => 'false|string',
'sodium_crypto_shorthash' => 'string',
'sodium_crypto_shorthash_keygen' => 'string',
'sodium_crypto_sign' => 'string',
'sodium_crypto_sign_detached' => 'string',
'sodium_crypto_sign_ed25519_pk_to_curve25519' => 'string',
'sodium_crypto_sign_ed25519_sk_to_curve25519' => 'string',
'sodium_crypto_sign_keypair' => 'string',
'sodium_crypto_sign_keypair_from_secretkey_and_publickey' => 'string',
'sodium_crypto_sign_open' => 'false|string',
'sodium_crypto_sign_publickey' => 'string',
'sodium_crypto_sign_publickey_from_secretkey' => 'string',
'sodium_crypto_sign_secretkey' => 'string',
'sodium_crypto_sign_seed_keypair' => 'string',
'sodium_crypto_stream' => 'string',
'sodium_crypto_stream_keygen' => 'string',
'sodium_crypto_stream_xor' => 'string',
'sodium_hex2bin' => 'string',
'sodium_pad' => 'string',
'sodium_unpad' => 'string',
'sort' => 'true',
'soundex' => 'false|string',
'spl_classes' => 'array<string,string>',
'spl_object_hash' => 'string',
'sprintf' => 'string',
'sscanf' => '?list<mixed>|?int',
'stat' => 'bool[]|false|int[]|string[]',
'str_getcsv' => 'list<?string>',
'str_ireplace' => 'array[]|object[]|string|string[]',
'str_repeat' => 'string',
'str_replace' => 'array[]|object[]|string|string[]',
'str_rot13' => 'string',
'str_shuffle' => 'string',
'str_split' => 'list<string>',
'str_word_count' => 'array<int,string>|int',
'strchr' => 'false|string',
'stream_bucket_make_writeable' => '?object',
'stream_context_create' => 'resource',
'stream_context_get_default' => 'false|resource',
'stream_context_get_options' => 'array<string,mixed>|false',
'stream_context_get_params' => 'array<string,mixed>|false',
'stream_context_set_default' => 'false|resource',
'stream_context_set_params' => 'bool',
'stream_filter_append' => 'false|resource',
'stream_filter_prepend' => 'false|resource',
'stream_get_contents' => 'false|string',
'stream_get_filters' => 'list<string>',
'stream_get_line' => 'false|string',
'stream_get_meta_data' => 'array<string,mixed>|false',
'stream_get_transports' => 'list<string>|false',
'stream_get_wrappers' => 'list<string>|false',
'stream_resolve_include_path' => 'false|string',
'stream_socket_accept' => 'false|resource',
'stream_socket_client' => 'false|resource',
'stream_socket_get_name' => 'false|string',
'stream_socket_pair' => 'array{0:resource,1:resource}|false',
'stream_socket_recvfrom' => 'false|string',
'stream_socket_server' => 'false|resource',
'strftime' => 'false|string',
'strip_tags' => 'string',
'stripcslashes' => 'string',
'stripslashes' => 'string',
'stristr' => 'false|string',
'strpbrk' => 'false|string',
'strptime' => 'array<string,int>|array<string,string>|false',
'strrchr' => 'false|string',
'strrev' => 'string',
'strstr' => 'false|string',
'strtok' => 'false|string',
'substr_replace' => 'false|string|string[]',
'sys_get_temp_dir' => 'string',
'sys_getloadavg' => 'array{0:float,1:float,2:float}|false',
'syslog' => 'true',
'system' => 'false|string',
'tan' => 'float',
'tanh' => 'float',
'tempnam' => 'false|string',
'textdomain' => 'string',
'tidy_access_count' => 'int',
'tidy_clean_repair' => 'bool',
'tidy_config_count' => 'int',
'tidy_diagnose' => 'bool',
'tidy_error_count' => 'int',
'tidy_get_body' => '?\tidyNode',
'tidy_get_config' => 'array',
'tidy_get_error_buffer' => 'false|string',
'tidy_get_head' => '?\tidyNode',
'tidy_get_html' => '?\tidyNode',
'tidy_get_html_ver' => 'int',
'tidy_get_opt_doc' => 'false|string',
'tidy_get_output' => 'string',
'tidy_get_release' => 'string',
'tidy_get_root' => '?\tidyNode',
'tidy_get_status' => 'int',
'tidy_getopt' => 'bool|int|string',
'tidy_is_xhtml' => 'bool',
'tidy_is_xml' => 'bool',
'tidy_parse_file' => '\tidy|false',
'tidy_parse_string' => '\tidy|false',
'tidy_repair_file' => 'false|string',
'tidy_repair_string' => 'false|string',
'tidy_warning_count' => 'int',
'tidyNode::getParent' => '?\tidyNode',
'tidyNode::hasChildren' => 'bool',
'tidyNode::hasSiblings' => 'bool',
'tidyNode::isAsp' => 'bool',
'tidyNode::isComment' => 'bool',
'tidyNode::isHtml' => 'bool',
'tidyNode::isJste' => 'bool',
'tidyNode::isPhp' => 'bool',
'tidyNode::isText' => 'bool',
'time' => 'int',
'time_nanosleep' => 'array|bool',
'time_sleep_until' => 'bool',
'timezone_abbreviations_list' => 'array',
'timezone_identifiers_list' => 'list<string>',
'timezone_location_get' => 'array|false',
'timezone_name_from_abbr' => 'false|string',
'timezone_name_get' => 'string',
'timezone_offset_get' => 'int',
'timezone_open' => '\DateTimeZone|false',
'timezone_transitions_get' => 'array|false',
'timezone_version_get' => 'string',
'tmpfile' => 'false|resource',
'uasort' => 'true',
'ucwords' => 'string',
'uksort' => 'true',
'uniqid' => 'string',
'unixtojd' => 'false|int',
'unlink' => 'bool',
'unpack' => 'array|false',
'unregister_tick_function' => 'void',
'unserialize' => 'mixed',
'urldecode' => 'string',
'urlencode' => 'string',
'use_soap_error_handler' => 'bool',
'user_error' => 'bool',
'usleep' => 'void',
'usort' => 'bool',
'utf8_decode' => 'string',
'utf8_encode' => 'string',
'var_dump' => 'void',
'var_export' => '?string',
'var_representation' => 'string',
'version_compare' => 'bool|int',
'vfprintf' => 'int',
'vprintf' => 'int',
'vsprintf' => 'string',
'WeakMap::count' => 'int',
'WeakMap::offsetExists' => 'bool',
'WeakMap::offsetGet' => 'mixed',
'WeakMap::offsetSet' => 'void',
'WeakMap::offsetUnset' => 'void',
'WeakReference::create' => '\WeakReference',
'WeakReference::get' => '?object',
'wordwrap' => 'string',
'xml_error_string' => '?string',
'xml_get_current_byte_index' => 'int',
'xml_get_current_column_number' => 'int',
'xml_get_current_line_number' => 'int',
'xml_get_error_code' => 'int',
'xml_parse' => 'int',
'xml_parse_into_struct' => 'int',
'xml_parser_create' => '\XmlParser',
'xml_parser_create_ns' => '\XmlParser',
'xml_parser_free' => 'bool',
'xml_parser_get_option' => 'int|string',
'xml_parser_set_option' => 'bool',
'xml_set_character_data_handler' => 'bool',
'xml_set_default_handler' => 'bool',
'xml_set_element_handler' => 'bool',
'xml_set_end_namespace_decl_handler' => 'bool',
'xml_set_external_entity_ref_handler' => 'bool',
'xml_set_notation_decl_handler' => 'bool',
'xml_set_object' => 'bool',
'xml_set_processing_instruction_handler' => 'bool',
'xml_set_start_namespace_decl_handler' => 'bool',
'xml_set_unparsed_entity_decl_handler' => 'bool',
'xmlwriter_end_attribute' => 'bool',
'xmlwriter_end_cdata' => 'bool',
'xmlwriter_end_comment' => 'bool',
'xmlwriter_end_document' => 'bool',
'xmlwriter_end_dtd' => 'bool',
'xmlwriter_end_dtd_attlist' => 'bool',
'xmlwriter_end_dtd_element' => 'bool',
'xmlwriter_end_dtd_entity' => 'bool',
'xmlwriter_end_element' => 'bool',
'xmlwriter_end_pi' => 'bool',
'xmlwriter_flush' => 'int|string',
'xmlwriter_full_end_element' => 'bool',
'xmlwriter_open_memory' => '\XMLWriter|false',
'xmlwriter_open_uri' => '\XMLWriter|false',
'xmlwriter_output_memory' => 'string',
'xmlwriter_set_indent' => 'bool',
'xmlwriter_set_indent_string' => 'bool',
'xmlwriter_start_attribute' => 'bool',
'xmlwriter_start_attribute_ns' => 'bool',
'xmlwriter_start_cdata' => 'bool',
'xmlwriter_start_comment' => 'bool',
'xmlwriter_start_document' => 'bool',
'xmlwriter_start_dtd' => 'bool',
'xmlwriter_start_dtd_attlist' => 'bool',
'xmlwriter_start_dtd_element' => 'bool',
'xmlwriter_start_dtd_entity' => 'bool',
'xmlwriter_start_element' => 'bool',
'xmlwriter_start_element_ns' => 'bool',
'xmlwriter_start_pi' => 'bool',
'xmlwriter_text' => 'bool',
'xmlwriter_write_attribute' => 'bool',
'xmlwriter_write_attribute_ns' => 'bool',
'xmlwriter_write_cdata' => 'bool',
'xmlwriter_write_comment' => 'bool',
'xmlwriter_write_dtd' => 'bool',
'xmlwriter_write_dtd_attlist' => 'bool',
'xmlwriter_write_dtd_element' => 'bool',
'xmlwriter_write_dtd_entity' => 'bool',
'xmlwriter_write_element' => 'bool',
'xmlwriter_write_element_ns' => 'bool',
'xmlwriter_write_pi' => 'bool',
'xmlwriter_write_raw' => 'bool',
'zend_version' => 'string',
'zip_close' => 'void',
'zip_entry_close' => 'bool',
'zip_entry_compressedsize' => 'false|int',
'zip_entry_compressionmethod' => 'false|string',
'zip_entry_filesize' => 'false|int',
'zip_entry_name' => 'false|string',
'zip_entry_open' => 'bool',
'zip_entry_read' => 'false|string',
'zlib_decode' => 'false|string',
'zlib_encode' => 'false|string',
'zlib_get_coding_type' => 'false|string',
];
