<?php // phpcs:ignoreFile

/**
 * This contains the information needed to convert the function signatures for php 7.2 to php 7.1 (and vice versa)
 *
 * This has two sections.
 * The 'new' section contains function/method names from FunctionSignatureMap (And alternates, if applicable) that do not exist in php7.1 or have different signatures in php 7.2.
 *   If they were just updated, the function/method will be present in the 'added' signatures.
 * The 'old' signatures contains the signatures that are different in php 7.1.
 *   Functions are expected to be removed only in major releases of php. (e.g. php 7.0 removed various functions that were deprecated in 5.6)
 *
 * @see FunctionSignatureMap.php
 *
 * @phan-file-suppress PhanPluginMixedKeyNoKey (read by Phan when analyzing this file)
 */
return [
  'added' => [
    'DOMNodeList::count' => ['int'],
    'ftp_append' => ['bool', 'ftp'=>'resource', 'remote_filename'=>'string', 'local_filename'=>'string', 'mode='=>'int'],
    'hash_hmac_algos' => ['list<string>'],
    'imagebmp' => ['bool', 'image'=>'resource', 'file='=>'null|resource|string', 'compressed='=>'bool'],
    'imagecreatefrombmp' => ['resource|false', 'filename'=>'string'],
    'imageopenpolygon' => ['bool', 'image'=>'resource', 'points'=>'array', 'num_points_or_color'=>'int', 'color='=>'int'],
    'imageresolution' => ['array<int,int>|bool', 'image'=>'resource', 'resolution_x='=>'int', 'resolution_y='=>'int'],
    'imagesetclip' => ['bool', 'image'=>'resource', 'x1'=>'int', 'y1'=>'int', 'x2'=>'int', 'y2'=>'int'],
    'ldap_exop' => ['bool|resource', 'ldap'=>'resource', 'request_oid'=>'string', 'request_data='=>'string', 'controls='=>'?array', '&w_response_data='=>'string', '&w_response_oid='=>'string'],
    'ldap_exop_passwd' => ['bool|string', 'ldap'=>'resource', 'user='=>'string', 'old_password='=>'string', 'new_password='=>'string', '&controls='=>'?array'],
    'ldap_exop_refresh' => ['int|false', 'ldap'=>'resource', 'dn'=>'string', 'ttl'=>'int'],
    'ldap_exop_whoami' => ['string|false', 'ldap'=>'resource'],
    'ldap_parse_exop' => ['bool', 'ldap'=>'resource', 'result'=>'resource', '&w_response_data='=>'string', '&w_response_oid='=>'string'],
    'mb_chr' => ['string|false', 'codepoint'=>'int', 'encoding='=>'string'],
    'mb_ord' => ['int|false', 'string'=>'string', 'encoding='=>'string'],
    'mb_scrub' => ['string|false', 'string'=>'string', 'encoding='=>'string'],
    'oci_register_taf_callback' => ['bool', 'connection'=>'resource', 'callback'=>'callable'],
    'oci_set_call_timeout' => ['bool', 'connection'=>'resource', 'timeout'=>'int'],
    'oci_unregister_taf_callback' => ['bool', 'connection'=>'resource'],
    'ReflectionClass::isIterable' => ['bool'],
    'sapi_windows_vt100_support' => ['bool', 'stream'=>'resource', 'enable='=>'bool'],
    'socket_addrinfo_bind' => ['?resource', 'address'=>'resource'],
    'socket_addrinfo_connect' => ['?resource', 'address'=>'resource'],
    'socket_addrinfo_explain' => ['array', 'address'=>'resource'],
    'socket_addrinfo_lookup' => ['resource[]', 'host'=>'string', 'service='=>'?string', 'hints='=>'array'],
    'sodium_add' => ['void', '&string1'=>'string', 'string2'=>'string'],
    'sodium_base642bin' => ['string', 'string'=>'string', 'id'=>'int', 'ignore='=>'string'],
    'sodium_bin2base64' => ['string', 'string'=>'string', 'id'=>'int'],
    'sodium_bin2hex' => ['string', 'string'=>'string'],
    'sodium_compare' => ['int', 'string1'=>'string', 'string2'=>'string'],
    'sodium_crypto_aead_aes256gcm_decrypt' => ['string|false', 'ciphertext'=>'string', 'additional_data'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_aead_aes256gcm_encrypt' => ['string', 'message'=>'string', 'additional_data'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_aead_aes256gcm_is_available' => ['bool'],
    'sodium_crypto_aead_aes256gcm_keygen' => ['string'],
    'sodium_crypto_aead_chacha20poly1305_decrypt' => ['string', 'ciphertext'=>'string', 'additional_data'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_aead_chacha20poly1305_encrypt' => ['string', 'message'=>'string', 'additional_data'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_aead_chacha20poly1305_ietf_decrypt' => ['false|string', 'ciphertext'=>'string', 'additional_data'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_aead_chacha20poly1305_ietf_encrypt' => ['string', 'message'=>'string', 'additional_data'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_aead_chacha20poly1305_ietf_keygen' => ['string'],
    'sodium_crypto_aead_chacha20poly1305_keygen' => ['string'],
    'sodium_crypto_aead_xchacha20poly1305_ietf_decrypt' => ['string|false', 'ciphertext'=>'string', 'additional_data'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_aead_xchacha20poly1305_ietf_encrypt' => ['string', 'message'=>'string', 'additional_data'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_aead_xchacha20poly1305_ietf_keygen' => ['string'],
    'sodium_crypto_auth' => ['string', 'message'=>'string', 'key'=>'string'],
    'sodium_crypto_auth_keygen' => ['string'],
    'sodium_crypto_auth_verify' => ['bool', 'mac'=>'string', 'message'=>'string', 'key'=>'string'],
    'sodium_crypto_box' => ['string', 'message'=>'string', 'nonce'=>'string', 'key_pair'=>'string'],
    'sodium_crypto_box_keypair' => ['string'],
    'sodium_crypto_box_keypair_from_secretkey_and_publickey' => ['string', 'secret_key'=>'string', 'public_key'=>'string'],
    'sodium_crypto_box_open' => ['string|false', 'ciphertext'=>'string', 'nonce'=>'string', 'key_pair'=>'string'],
    'sodium_crypto_box_publickey' => ['string', 'key_pair'=>'string'],
    'sodium_crypto_box_publickey_from_secretkey' => ['string', 'secret_key'=>'string'],
    'sodium_crypto_box_seal' => ['string', 'message'=>'string', 'public_key'=>'string'],
    'sodium_crypto_box_seal_open' => ['string|false', 'ciphertext'=>'string', 'key_pair'=>'string'],
    'sodium_crypto_box_secretkey' => ['string', 'key_pair'=>'string'],
    'sodium_crypto_box_seed_keypair' => ['string', 'seed'=>'string'],
    'sodium_crypto_generichash' => ['string', 'message'=>'string', 'key='=>'string', 'length='=>'int'],
    'sodium_crypto_generichash_final' => ['string', '&state'=>'string', 'length='=>'int'],
    'sodium_crypto_generichash_init' => ['string', 'key='=>'string', 'length='=>'int'],
    'sodium_crypto_generichash_keygen' => ['string'],
    'sodium_crypto_generichash_update' => ['bool', '&state'=>'string', 'message'=>'string'],
    'sodium_crypto_kdf_derive_from_key' => ['string', 'subkey_length'=>'int', 'subkey_id'=>'int', 'context'=>'string', 'key'=>'string'],
    'sodium_crypto_kdf_keygen' => ['string'],
    'sodium_crypto_kx_client_session_keys' => ['array<int,string>', 'client_key_pair'=>'string', 'server_key'=>'string'],
    'sodium_crypto_kx_keypair' => ['string'],
    'sodium_crypto_kx_publickey' => ['string', 'key_pair'=>'string'],
    'sodium_crypto_kx_secretkey' => ['string', 'key_pair'=>'string'],
    'sodium_crypto_kx_seed_keypair' => ['string', 'seed'=>'string'],
    'sodium_crypto_kx_server_session_keys' => ['array<int,string>', 'server_key_pair'=>'string', 'client_key'=>'string'],
    'sodium_crypto_pwhash' => ['string', 'length'=>'int', 'password'=>'string', 'salt'=>'string', 'opslimit'=>'int', 'memlimit'=>'int', 'algo='=>'int'],
    'sodium_crypto_pwhash_scryptsalsa208sha256' => ['string', 'length'=>'int', 'password'=>'string', 'salt'=>'string', 'opslimit'=>'int', 'memlimit'=>'int'],
    'sodium_crypto_pwhash_scryptsalsa208sha256_str' => ['string', 'password'=>'string', 'opslimit'=>'int', 'memlimit'=>'int'],
    'sodium_crypto_pwhash_scryptsalsa208sha256_str_verify' => ['bool', 'hash'=>'string', 'password'=>'string'],
    'sodium_crypto_pwhash_str' => ['string', 'password'=>'string', 'opslimit'=>'int', 'memlimit'=>'int'],
    'sodium_crypto_pwhash_str_needs_rehash' => ['bool', 'password'=>'string', 'opslimit'=>'int', 'memlimit'=>'int'],
    'sodium_crypto_pwhash_str_verify' => ['bool', 'hash'=>'string', 'password'=>'string'],
    'sodium_crypto_scalarmult' => ['string', 'n'=>'string', 'p'=>'string'],
    'sodium_crypto_scalarmult_base' => ['string', 'secret_key'=>'string'],
    'sodium_crypto_secretbox' => ['string', 'message'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_secretbox_keygen' => ['string'],
    'sodium_crypto_secretbox_open' => ['string|false', 'ciphertext'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_secretstream_xchacha20poly1305_init_pull' => ['string', 'header'=>'string', 'key'=>'string'],
    'sodium_crypto_secretstream_xchacha20poly1305_init_push' => ['array', 'key'=>'string'],
    'sodium_crypto_secretstream_xchacha20poly1305_keygen' => ['string'],
    'sodium_crypto_secretstream_xchacha20poly1305_pull' => ['array', '&state'=>'string', 'ciphertext'=>'string', 'additional_data='=>'string'],
    'sodium_crypto_secretstream_xchacha20poly1305_push' => ['string', '&state'=>'string', 'message'=>'string', 'additional_data='=>'string', 'tag='=>'int'],
    'sodium_crypto_secretstream_xchacha20poly1305_rekey' => ['void', '&state'=>'string'],
    'sodium_crypto_shorthash' => ['string', 'message'=>'string', 'key'=>'string'],
    'sodium_crypto_shorthash_keygen' => ['string'],
    'sodium_crypto_sign' => ['string', 'message'=>'string', 'secret_key'=>'string'],
    'sodium_crypto_sign_detached' => ['string', 'message'=>'string', 'secret_key'=>'string'],
    'sodium_crypto_sign_ed25519_pk_to_curve25519' => ['string', 'public_key'=>'string'],
    'sodium_crypto_sign_ed25519_sk_to_curve25519' => ['string', 'secret_key'=>'string'],
    'sodium_crypto_sign_keypair' => ['string'],
    'sodium_crypto_sign_keypair_from_secretkey_and_publickey' => ['string', 'secret_key'=>'string', 'public_key'=>'string'],
    'sodium_crypto_sign_open' => ['string|false', 'signed_message'=>'string', 'public_key'=>'string'],
    'sodium_crypto_sign_publickey' => ['string', 'key_pair'=>'string'],
    'sodium_crypto_sign_publickey_from_secretkey' => ['string', 'secret_key'=>'string'],
    'sodium_crypto_sign_secretkey' => ['string', 'key_pair'=>'string'],
    'sodium_crypto_sign_seed_keypair' => ['string', 'seed'=>'string'],
    'sodium_crypto_sign_verify_detached' => ['bool', 'signature'=>'string', 'message'=>'string', 'public_key'=>'string'],
    'sodium_crypto_stream' => ['string', 'length'=>'int', 'nonce'=>'string', 'key'=>'string'],
    'sodium_crypto_stream_keygen' => ['string'],
    'sodium_crypto_stream_xor' => ['string', 'message'=>'string', 'nonce'=>'string', 'key'=>'string'],
    'sodium_hex2bin' => ['string', 'string'=>'string', 'ignore='=>'string'],
    'sodium_increment' => ['void', '&string'=>'string'],
    'sodium_memcmp' => ['int', 'string1'=>'string', 'string2'=>'string'],
    'sodium_memzero' => ['void', '&string'=>'string'],
    'sodium_pad' => ['string', 'string'=>'string', 'block_size'=>'int'],
    'sodium_unpad' => ['string', 'string'=>'string', 'block_size'=>'int'],
    'stream_isatty' => ['bool', 'stream'=>'resource'],
    'ZipArchive::count' => ['int'],
    'ZipArchive::setEncryptionIndex' => ['bool', 'index'=>'int', 'method'=>'int', 'password='=>'string'],
    'ZipArchive::setEncryptionName' => ['bool', 'name'=>'string', 'method'=>'int', 'password='=>'string'],
  ],
  'changed' => [
    'exif_read_data' => [
      'old' => ['array<string,mixed>|false', 'file'=>'string', 'required_sections='=>'string', 'as_arrays='=>'bool', 'read_thumbnail='=>'bool'],
      'new' => ['array<string,mixed>|false', 'file'=>'resource|string', 'required_sections='=>'string', 'as_arrays='=>'bool', 'read_thumbnail='=>'bool'],
    ],
    'hash_copy' => [
      'old' => ['resource', 'context'=>'resource'],
      'new' => ['HashContext', 'context'=>'HashContext'],
    ],
    'hash_final' => [
      'old' => ['string', 'context'=>'resource', 'binary='=>'bool'],
      'new' => ['string', 'context'=>'HashContext', 'binary='=>'bool'],
    ],
    'hash_init' => [
      'old' => ['resource', 'algo'=>'string', 'flags='=>'int', 'key='=>'string'],
      'new' => ['HashContext', 'algo'=>'string', 'flags='=>'int', 'key='=>'string'],
    ],
    'hash_update' => [
      'old' => ['bool', 'context'=>'resource', 'data'=>'string'],
      'new' => ['bool', 'context'=>'HashContext', 'data'=>'string'],
    ],
    'hash_update_file' => [
      'old' => ['bool', 'context'=>'resource', 'filename'=>'string', 'stream_context='=>'?resource'],
      'new' => ['bool', 'context'=>'HashContext', 'filename'=>'string', 'stream_context='=>'?resource'],
    ],
    'hash_update_stream' => [
      'old' => ['int', 'context'=>'resource', 'stream'=>'resource', 'length='=>'int'],
      'new' => ['int', 'context'=>'HashContext', 'stream'=>'resource', 'length='=>'int'],
    ],
    'json_decode' => [
      'old' => ['mixed', 'json'=>'string', 'assoc='=>'bool', 'depth='=>'int', 'flags='=>'int'],
      'new' => ['mixed', 'json'=>'string', 'associative='=>'?bool', 'depth='=>'int', 'flags='=>'int'],
    ],
    'SQLite3::openBlob' => [
      'old' => ['resource|false', 'table'=>'string', 'column'=>'string', 'rowid'=>'int', 'database='=>'string'],
      'new' => ['resource|false', 'table'=>'string', 'column'=>'string', 'rowid'=>'int', 'database='=>'string', 'flags='=>'int'],
    ],
  ],
  'removed' => [
  ],
];
