<?php
declare(strict_types=1);

/**
 * This lists all of the possible real return types of various global functions.
 * This is useful because php won't provide many of these until php 8,
 * and even then won't be able to represent types such as string|false.
 *
 * This is conservative to avoid false positives, and includes types returned for all possible failure modes
 * (invalid arguments/argument counts, spurious errors, etc.)
 *
 * Generated by Phan's internal/extract_arg_info.php, from Zend/Optimizer/zend_func_info.c of php-src,
 * source version 8.4.8, using PHP version 8.4.8 with extensions:
 *   Core, date, libxml, openssl, pcre, zlib, filter, hash, json, pcntl,
 *   random, Reflection, SPL, session, standard, sodium, mysqlnd, PDO, xml, ast,
 *   calendar, ctype, curl, dom, excimer, mbstring, FFI, fileinfo, ftp, gd,
 *   gettext, gmp, iconv, igbinary, intl, exif, msgpack, mysqli, OAuth, pcov,
 *   pdo_mysql, pdo_pgsql, pgsql, Phar, posix, pspell, readline, shmop, SimpleXML, soap,
 *   sockets, sysvmsg, sysvsem, sysvshm, tidy, tokenizer, xmlreader, xmlwriter, xsl, zip,
 *   memcached, redis, Zend OPcache,
 */
return [
'_' => 'string',
'abs' => 'float|int',
'acos' => 'float',
'acosh' => 'float',
'addcslashes' => 'string',
'addslashes' => 'string',
'ArgumentCountError::__toString' => 'string',
'ArgumentCountError::getFile' => 'string',
'ArgumentCountError::getLine' => 'int',
'ArgumentCountError::getMessage' => 'string',
'ArgumentCountError::getPrevious' => '?\Throwable',
'ArgumentCountError::getTrace' => 'array',
'ArgumentCountError::getTraceAsString' => 'string',
'ArithmeticError::__toString' => 'string',
'ArithmeticError::getFile' => 'string',
'ArithmeticError::getLine' => 'int',
'ArithmeticError::getMessage' => 'string',
'ArithmeticError::getPrevious' => '?\Throwable',
'ArithmeticError::getTrace' => 'array',
'ArithmeticError::getTraceAsString' => 'string',
'array_all' => 'bool',
'array_any' => 'bool',
'array_change_key_case' => 'array',
'array_chunk' => 'array',
'array_column' => 'array',
'array_combine' => 'array',
'array_count_values' => 'array',
'array_diff' => 'array',
'array_diff_assoc' => 'array',
'array_diff_key' => 'array',
'array_diff_uassoc' => 'array',
'array_diff_ukey' => 'array',
'array_fill' => 'array',
'array_fill_keys' => 'array',
'array_filter' => 'array',
'array_find' => 'mixed',
'array_find_key' => 'mixed',
'array_flip' => 'array',
'array_intersect' => 'array',
'array_intersect_assoc' => 'array',
'array_intersect_key' => 'array',
'array_intersect_uassoc' => 'array',
'array_intersect_ukey' => 'array',
'array_is_list' => 'bool',
'array_key_exists' => 'bool',
'array_key_first' => 'int|null|string',
'array_key_last' => 'int|null|string',
'array_keys' => 'array',
'array_map' => 'array',
'array_merge' => 'array',
'array_merge_recursive' => 'array',
'array_multisort' => 'bool',
'array_pad' => 'array',
'array_pop' => 'mixed',
'array_product' => 'float|int',
'array_push' => 'int',
'array_rand' => 'array|int|string',
'array_reduce' => 'mixed',
'array_replace' => 'array',
'array_replace_recursive' => 'array',
'array_reverse' => 'array',
'array_search' => 'false|int|string',
'array_shift' => 'mixed',
'array_slice' => 'array',
'array_splice' => 'array',
'array_sum' => 'float|int',
'array_udiff' => 'array',
'array_udiff_assoc' => 'array',
'array_udiff_uassoc' => 'array',
'array_uintersect' => 'array',
'array_uintersect_assoc' => 'array',
'array_uintersect_uassoc' => 'array',
'array_unique' => 'array',
'array_unshift' => 'int',
'array_values' => 'array',
'array_walk' => 'true',
'array_walk_recursive' => 'true',
'arsort' => 'true',
'asin' => 'float',
'asinh' => 'float',
'asort' => 'true',
'assert' => 'bool',
'assert_options' => 'mixed',
'AssertionError::__toString' => 'string',
'AssertionError::getFile' => 'string',
'AssertionError::getLine' => 'int',
'AssertionError::getMessage' => 'string',
'AssertionError::getPrevious' => '?\Throwable',
'AssertionError::getTrace' => 'array',
'AssertionError::getTraceAsString' => 'string',
'ast\get_kind_name' => 'string',
'ast\get_metadata' => 'array',
'ast\get_supported_versions' => 'array',
'ast\kind_uses_flags' => 'bool',
'ast\parse_code' => '\ast\Node',
'ast\parse_file' => '\ast\Node',
'atan' => 'float',
'atan2' => 'float',
'atanh' => 'float',
'BadFunctionCallException::__toString' => 'string',
'BadFunctionCallException::getFile' => 'string',
'BadFunctionCallException::getLine' => 'int',
'BadFunctionCallException::getMessage' => 'string',
'BadFunctionCallException::getPrevious' => '?\Throwable',
'BadFunctionCallException::getTrace' => 'array',
'BadFunctionCallException::getTraceAsString' => 'string',
'BadMethodCallException::__toString' => 'string',
'BadMethodCallException::getFile' => 'string',
'BadMethodCallException::getLine' => 'int',
'BadMethodCallException::getMessage' => 'string',
'BadMethodCallException::getPrevious' => '?\Throwable',
'BadMethodCallException::getTrace' => 'array',
'BadMethodCallException::getTraceAsString' => 'string',
'base64_decode' => 'false|string',
'base64_encode' => 'string',
'base_convert' => 'string',
'basename' => 'string',
'bin2hex' => 'string',
'bind_textdomain_codeset' => 'false|string',
'bindec' => 'float|int',
'bindtextdomain' => 'false|string',
'boolval' => 'bool',
'CachingIterator::__toString' => 'string',
'cal_days_in_month' => 'int',
'cal_from_jd' => 'array',
'cal_info' => 'array',
'cal_to_jd' => 'int',
'call_user_func' => 'mixed',
'call_user_func_array' => 'mixed',
'ceil' => 'float',
'chdir' => 'bool',
'checkdate' => 'bool',
'checkdnsrr' => 'bool',
'chgrp' => 'bool',
'chmod' => 'bool',
'chop' => 'string',
'chown' => 'bool',
'chr' => 'string',
'chroot' => 'bool',
'chunk_split' => 'string',
'class_alias' => 'bool',
'class_exists' => 'bool',
'class_implements' => 'array|false',
'class_parents' => 'array|false',
'class_uses' => 'array|false',
'clearstatcache' => 'void',
'cli_get_process_title' => '?string',
'cli_set_process_title' => 'bool',
'ClosedGeneratorException::__toString' => 'string',
'ClosedGeneratorException::getFile' => 'string',
'ClosedGeneratorException::getLine' => 'int',
'ClosedGeneratorException::getMessage' => 'string',
'ClosedGeneratorException::getPrevious' => '?\Throwable',
'ClosedGeneratorException::getTrace' => 'array',
'ClosedGeneratorException::getTraceAsString' => 'string',
'closedir' => 'void',
'closelog' => 'true',
'Closure::bind' => '?\Closure',
'Closure::bindTo' => '?\Closure',
'Closure::call' => 'mixed',
'Closure::fromCallable' => '\Closure',
'collator_asort' => 'bool',
'collator_compare' => 'false|int',
'collator_create' => '?\Collator',
'collator_get_attribute' => 'false|int',
'collator_get_error_code' => 'false|int',
'collator_get_error_message' => 'false|string',
'collator_get_locale' => 'false|string',
'collator_get_sort_key' => 'false|string',
'collator_get_strength' => 'int',
'collator_set_attribute' => 'bool',
'collator_set_strength' => 'true',
'collator_sort' => 'bool',
'collator_sort_with_sort_keys' => 'bool',
'compact' => 'array',
'CompileError::__toString' => 'string',
'CompileError::getFile' => 'string',
'CompileError::getLine' => 'int',
'CompileError::getMessage' => 'string',
'CompileError::getPrevious' => '?\Throwable',
'CompileError::getTrace' => 'array',
'CompileError::getTraceAsString' => 'string',
'connection_aborted' => 'int',
'connection_status' => 'int',
'constant' => 'mixed',
'convert_uudecode' => 'false|string',
'convert_uuencode' => 'string',
'copy' => 'bool',
'cos' => 'float',
'cosh' => 'float',
'count' => 'int',
'count_chars' => 'array|string',
'crc32' => 'int',
'crypt' => 'string',
'ctype_alnum' => 'bool',
'ctype_alpha' => 'bool',
'ctype_cntrl' => 'bool',
'ctype_digit' => 'bool',
'ctype_graph' => 'bool',
'ctype_lower' => 'bool',
'ctype_print' => 'bool',
'ctype_punct' => 'bool',
'ctype_space' => 'bool',
'ctype_upper' => 'bool',
'ctype_xdigit' => 'bool',
'curl_close' => 'void',
'curl_copy_handle' => '\CurlHandle|false',
'curl_errno' => 'int',
'curl_error' => 'string',
'curl_escape' => 'false|string',
'curl_exec' => 'bool|string',
'curl_file_create' => '\CURLFile',
'curl_getinfo' => 'mixed',
'curl_init' => '\CurlHandle|false',
'curl_multi_add_handle' => 'int',
'curl_multi_close' => 'void',
'curl_multi_errno' => 'int',
'curl_multi_exec' => 'int',
'curl_multi_getcontent' => '?string',
'curl_multi_info_read' => 'array|false',
'curl_multi_init' => '\CurlMultiHandle',
'curl_multi_remove_handle' => 'int',
'curl_multi_select' => 'int',
'curl_multi_setopt' => 'bool',
'curl_multi_strerror' => '?string',
'curl_pause' => 'int',
'curl_reset' => 'void',
'curl_setopt' => 'bool',
'curl_setopt_array' => 'bool',
'curl_share_close' => 'void',
'curl_share_errno' => 'int',
'curl_share_init' => '\CurlShareHandle',
'curl_share_setopt' => 'bool',
'curl_share_strerror' => '?string',
'curl_strerror' => '?string',
'curl_unescape' => 'false|string',
'curl_upkeep' => 'bool',
'curl_version' => 'array|false',
'current' => 'mixed',
'date' => 'string',
'date_add' => '\DateTime',
'date_create' => '\DateTime|false',
'date_create_from_format' => '\DateTime|false',
'date_create_immutable' => '\DateTimeImmutable|false',
'date_create_immutable_from_format' => '\DateTimeImmutable|false',
'date_date_set' => '\DateTime',
'date_default_timezone_get' => 'string',
'date_default_timezone_set' => 'bool',
'date_diff' => '\DateInterval',
'date_format' => 'string',
'date_get_last_errors' => 'array|false',
'date_interval_create_from_date_string' => '\DateInterval|false',
'date_interval_format' => 'string',
'date_isodate_set' => '\DateTime',
'date_modify' => '\DateTime|false',
'date_offset_get' => 'int',
'date_parse' => 'array',
'date_parse_from_format' => 'array',
'date_sub' => '\DateTime',
'date_sun_info' => 'array',
'date_sunrise' => 'false|float|int|string',
'date_sunset' => 'false|float|int|string',
'date_time_set' => '\DateTime',
'date_timestamp_get' => 'int',
'date_timestamp_set' => '\DateTime',
'date_timezone_get' => '\DateTimeZone|false',
'date_timezone_set' => '\DateTime',
'DateError::__toString' => 'string',
'DateError::getFile' => 'string',
'DateError::getLine' => 'int',
'DateError::getMessage' => 'string',
'DateError::getPrevious' => '?\Throwable',
'DateError::getTrace' => 'array',
'DateError::getTraceAsString' => 'string',
'DateException::__toString' => 'string',
'DateException::getFile' => 'string',
'DateException::getLine' => 'int',
'DateException::getMessage' => 'string',
'DateException::getPrevious' => '?\Throwable',
'DateException::getTrace' => 'array',
'DateException::getTraceAsString' => 'string',
'datefmt_create' => '?\IntlDateFormatter',
'datefmt_format' => 'false|string',
'datefmt_format_object' => 'false|string',
'datefmt_get_calendar' => 'false|int',
'datefmt_get_calendar_object' => '\IntlCalendar|false|null',
'datefmt_get_datetype' => 'false|int',
'datefmt_get_error_code' => 'int',
'datefmt_get_error_message' => 'string',
'datefmt_get_locale' => 'false|string',
'datefmt_get_pattern' => 'false|string',
'datefmt_get_timetype' => 'false|int',
'datefmt_get_timezone' => '\IntlTimeZone|false',
'datefmt_get_timezone_id' => 'false|string',
'datefmt_is_lenient' => 'bool',
'datefmt_localtime' => 'array|false',
'datefmt_parse' => 'false|float|int',
'datefmt_set_calendar' => 'bool',
'datefmt_set_lenient' => 'void',
'datefmt_set_pattern' => 'bool',
'datefmt_set_timezone' => 'bool',
'DateInterval::__serialize' => 'array',
'DateInterval::__unserialize' => 'void',
'DateInvalidOperationException::__toString' => 'string',
'DateInvalidOperationException::getFile' => 'string',
'DateInvalidOperationException::getLine' => 'int',
'DateInvalidOperationException::getMessage' => 'string',
'DateInvalidOperationException::getPrevious' => '?\Throwable',
'DateInvalidOperationException::getTrace' => 'array',
'DateInvalidOperationException::getTraceAsString' => 'string',
'DateInvalidTimeZoneException::__toString' => 'string',
'DateInvalidTimeZoneException::getFile' => 'string',
'DateInvalidTimeZoneException::getLine' => 'int',
'DateInvalidTimeZoneException::getMessage' => 'string',
'DateInvalidTimeZoneException::getPrevious' => '?\Throwable',
'DateInvalidTimeZoneException::getTrace' => 'array',
'DateInvalidTimeZoneException::getTraceAsString' => 'string',
'DateMalformedIntervalStringException::__toString' => 'string',
'DateMalformedIntervalStringException::getFile' => 'string',
'DateMalformedIntervalStringException::getLine' => 'int',
'DateMalformedIntervalStringException::getMessage' => 'string',
'DateMalformedIntervalStringException::getPrevious' => '?\Throwable',
'DateMalformedIntervalStringException::getTrace' => 'array',
'DateMalformedIntervalStringException::getTraceAsString' => 'string',
'DateMalformedPeriodStringException::__toString' => 'string',
'DateMalformedPeriodStringException::getFile' => 'string',
'DateMalformedPeriodStringException::getLine' => 'int',
'DateMalformedPeriodStringException::getMessage' => 'string',
'DateMalformedPeriodStringException::getPrevious' => '?\Throwable',
'DateMalformedPeriodStringException::getTrace' => 'array',
'DateMalformedPeriodStringException::getTraceAsString' => 'string',
'DateMalformedStringException::__toString' => 'string',
'DateMalformedStringException::getFile' => 'string',
'DateMalformedStringException::getLine' => 'int',
'DateMalformedStringException::getMessage' => 'string',
'DateMalformedStringException::getPrevious' => '?\Throwable',
'DateMalformedStringException::getTrace' => 'array',
'DateMalformedStringException::getTraceAsString' => 'string',
'DateObjectError::__toString' => 'string',
'DateObjectError::getFile' => 'string',
'DateObjectError::getLine' => 'int',
'DateObjectError::getMessage' => 'string',
'DateObjectError::getPrevious' => '?\Throwable',
'DateObjectError::getTrace' => 'array',
'DateObjectError::getTraceAsString' => 'string',
'DatePeriod::__serialize' => 'array',
'DatePeriod::__unserialize' => 'void',
'DatePeriod::createFromISO8601String' => 'static',
'DatePeriod::getIterator' => '\Iterator',
'DateRangeError::__toString' => 'string',
'DateRangeError::getFile' => 'string',
'DateRangeError::getLine' => 'int',
'DateRangeError::getMessage' => 'string',
'DateRangeError::getPrevious' => '?\Throwable',
'DateRangeError::getTrace' => 'array',
'DateRangeError::getTraceAsString' => 'string',
'DateTime::__serialize' => 'array',
'DateTime::__unserialize' => 'void',
'DateTime::createFromInterface' => '\DateTime',
'DateTime::getMicrosecond' => 'int',
'DateTime::setMicrosecond' => 'static',
'DateTimeImmutable::__serialize' => 'array',
'DateTimeImmutable::__unserialize' => 'void',
'DateTimeImmutable::createFromInterface' => '\DateTimeImmutable',
'DateTimeImmutable::getMicrosecond' => 'int',
'DateTimeImmutable::setMicrosecond' => 'static',
'DateTimeZone::__serialize' => 'array',
'DateTimeZone::__unserialize' => 'void',
'dcgettext' => 'string',
'dcngettext' => 'string',
'debug_backtrace' => 'array',
'debug_print_backtrace' => 'void',
'debug_zval_dump' => 'void',
'decbin' => 'string',
'dechex' => 'string',
'decoct' => 'string',
'define' => 'bool',
'defined' => 'bool',
'deflate_add' => 'false|string',
'deflate_init' => '\DeflateContext|false',
'deg2rad' => 'float',
'dgettext' => 'string',
'die' => 'never',
'dir' => '\Directory|false',
'DirectoryIterator::__toString' => 'string',
'dirname' => 'string',
'disk_free_space' => 'false|float',
'disk_total_space' => 'false|float',
'diskfreespace' => 'false|float',
'DivisionByZeroError::__toString' => 'string',
'DivisionByZeroError::getFile' => 'string',
'DivisionByZeroError::getLine' => 'int',
'DivisionByZeroError::getMessage' => 'string',
'DivisionByZeroError::getPrevious' => '?\Throwable',
'DivisionByZeroError::getTrace' => 'array',
'DivisionByZeroError::getTraceAsString' => 'string',
'dl' => 'bool',
'dngettext' => 'string',
'dns_check_record' => 'bool',
'dns_get_mx' => 'bool',
'dns_get_record' => 'array|false',
'Dom\AdjacentPosition::cases' => 'array',
'Dom\AdjacentPosition::from' => 'static',
'Dom\AdjacentPosition::tryFrom' => '?static',
'Dom\Attr::__sleep' => 'array',
'Dom\Attr::__wakeup' => 'void',
'Dom\Attr::appendChild' => '\Dom\Node',
'Dom\Attr::C14N' => 'false|string',
'Dom\Attr::C14NFile' => 'false|int',
'Dom\Attr::cloneNode' => '\Dom\Node',
'Dom\Attr::compareDocumentPosition' => 'int',
'Dom\Attr::contains' => 'bool',
'Dom\Attr::getLineNo' => 'int',
'Dom\Attr::getNodePath' => 'string',
'Dom\Attr::getRootNode' => '\Dom\Node',
'Dom\Attr::hasChildNodes' => 'bool',
'Dom\Attr::insertBefore' => '\Dom\Node',
'Dom\Attr::isDefaultNamespace' => 'bool',
'Dom\Attr::isEqualNode' => 'bool',
'Dom\Attr::isId' => 'bool',
'Dom\Attr::isSameNode' => 'bool',
'Dom\Attr::lookupNamespaceURI' => '?string',
'Dom\Attr::lookupPrefix' => '?string',
'Dom\Attr::normalize' => 'void',
'Dom\Attr::removeChild' => '\Dom\Node',
'Dom\Attr::rename' => 'void',
'Dom\Attr::replaceChild' => '\Dom\Node',
'Dom\CDATASection::__sleep' => 'array',
'Dom\CDATASection::__wakeup' => 'void',
'Dom\CDATASection::after' => 'void',
'Dom\CDATASection::appendChild' => '\Dom\Node',
'Dom\CDATASection::appendData' => 'void',
'Dom\CDATASection::before' => 'void',
'Dom\CDATASection::C14N' => 'false|string',
'Dom\CDATASection::C14NFile' => 'false|int',
'Dom\CDATASection::cloneNode' => '\Dom\Node',
'Dom\CDATASection::compareDocumentPosition' => 'int',
'Dom\CDATASection::contains' => 'bool',
'Dom\CDATASection::deleteData' => 'void',
'Dom\CDATASection::getLineNo' => 'int',
'Dom\CDATASection::getNodePath' => 'string',
'Dom\CDATASection::getRootNode' => '\Dom\Node',
'Dom\CDATASection::hasChildNodes' => 'bool',
'Dom\CDATASection::insertBefore' => '\Dom\Node',
'Dom\CDATASection::insertData' => 'void',
'Dom\CDATASection::isDefaultNamespace' => 'bool',
'Dom\CDATASection::isEqualNode' => 'bool',
'Dom\CDATASection::isSameNode' => 'bool',
'Dom\CDATASection::lookupNamespaceURI' => '?string',
'Dom\CDATASection::lookupPrefix' => '?string',
'Dom\CDATASection::normalize' => 'void',
'Dom\CDATASection::remove' => 'void',
'Dom\CDATASection::removeChild' => '\Dom\Node',
'Dom\CDATASection::replaceChild' => '\Dom\Node',
'Dom\CDATASection::replaceData' => 'void',
'Dom\CDATASection::replaceWith' => 'void',
'Dom\CDATASection::splitText' => '\Dom\Text',
'Dom\CDATASection::substringData' => 'string',
'Dom\CharacterData::__sleep' => 'array',
'Dom\CharacterData::__wakeup' => 'void',
'Dom\CharacterData::after' => 'void',
'Dom\CharacterData::appendChild' => '\Dom\Node',
'Dom\CharacterData::appendData' => 'void',
'Dom\CharacterData::before' => 'void',
'Dom\CharacterData::C14N' => 'false|string',
'Dom\CharacterData::C14NFile' => 'false|int',
'Dom\CharacterData::cloneNode' => '\Dom\Node',
'Dom\CharacterData::compareDocumentPosition' => 'int',
'Dom\CharacterData::contains' => 'bool',
'Dom\CharacterData::deleteData' => 'void',
'Dom\CharacterData::getLineNo' => 'int',
'Dom\CharacterData::getNodePath' => 'string',
'Dom\CharacterData::getRootNode' => '\Dom\Node',
'Dom\CharacterData::hasChildNodes' => 'bool',
'Dom\CharacterData::insertBefore' => '\Dom\Node',
'Dom\CharacterData::insertData' => 'void',
'Dom\CharacterData::isDefaultNamespace' => 'bool',
'Dom\CharacterData::isEqualNode' => 'bool',
'Dom\CharacterData::isSameNode' => 'bool',
'Dom\CharacterData::lookupNamespaceURI' => '?string',
'Dom\CharacterData::lookupPrefix' => '?string',
'Dom\CharacterData::normalize' => 'void',
'Dom\CharacterData::remove' => 'void',
'Dom\CharacterData::removeChild' => '\Dom\Node',
'Dom\CharacterData::replaceChild' => '\Dom\Node',
'Dom\CharacterData::replaceData' => 'void',
'Dom\CharacterData::replaceWith' => 'void',
'Dom\CharacterData::substringData' => 'string',
'Dom\Comment::__sleep' => 'array',
'Dom\Comment::__wakeup' => 'void',
'Dom\Comment::after' => 'void',
'Dom\Comment::appendChild' => '\Dom\Node',
'Dom\Comment::appendData' => 'void',
'Dom\Comment::before' => 'void',
'Dom\Comment::C14N' => 'false|string',
'Dom\Comment::C14NFile' => 'false|int',
'Dom\Comment::cloneNode' => '\Dom\Node',
'Dom\Comment::compareDocumentPosition' => 'int',
'Dom\Comment::contains' => 'bool',
'Dom\Comment::deleteData' => 'void',
'Dom\Comment::getLineNo' => 'int',
'Dom\Comment::getNodePath' => 'string',
'Dom\Comment::getRootNode' => '\Dom\Node',
'Dom\Comment::hasChildNodes' => 'bool',
'Dom\Comment::insertBefore' => '\Dom\Node',
'Dom\Comment::insertData' => 'void',
'Dom\Comment::isDefaultNamespace' => 'bool',
'Dom\Comment::isEqualNode' => 'bool',
'Dom\Comment::isSameNode' => 'bool',
'Dom\Comment::lookupNamespaceURI' => '?string',
'Dom\Comment::lookupPrefix' => '?string',
'Dom\Comment::normalize' => 'void',
'Dom\Comment::remove' => 'void',
'Dom\Comment::removeChild' => '\Dom\Node',
'Dom\Comment::replaceChild' => '\Dom\Node',
'Dom\Comment::replaceData' => 'void',
'Dom\Comment::replaceWith' => 'void',
'Dom\Comment::substringData' => 'string',
'Dom\Document::__sleep' => 'array',
'Dom\Document::__wakeup' => 'void',
'Dom\Document::adoptNode' => '\Dom\Node',
'Dom\Document::append' => 'void',
'Dom\Document::appendChild' => '\Dom\Node',
'Dom\Document::C14N' => 'false|string',
'Dom\Document::C14NFile' => 'false|int',
'Dom\Document::cloneNode' => '\Dom\Node',
'Dom\Document::compareDocumentPosition' => 'int',
'Dom\Document::contains' => 'bool',
'Dom\Document::createAttribute' => '\Dom\Attr',
'Dom\Document::createAttributeNS' => '\Dom\Attr',
'Dom\Document::createCDATASection' => '\Dom\CDATASection',
'Dom\Document::createComment' => '\Dom\Comment',
'Dom\Document::createDocumentFragment' => '\Dom\DocumentFragment',
'Dom\Document::createElement' => '\Dom\Element',
'Dom\Document::createElementNS' => '\Dom\Element',
'Dom\Document::createProcessingInstruction' => '\Dom\ProcessingInstruction',
'Dom\Document::createTextNode' => '\Dom\Text',
'Dom\Document::getElementById' => '?\Dom\Element',
'Dom\Document::getElementsByTagName' => '\Dom\HTMLCollection',
'Dom\Document::getElementsByTagNameNS' => '\Dom\HTMLCollection',
'Dom\Document::getLineNo' => 'int',
'Dom\Document::getNodePath' => 'string',
'Dom\Document::getRootNode' => '\Dom\Node',
'Dom\Document::hasChildNodes' => 'bool',
'Dom\Document::importLegacyNode' => '\Dom\Node',
'Dom\Document::importNode' => '\Dom\Node',
'Dom\Document::insertBefore' => '\Dom\Node',
'Dom\Document::isDefaultNamespace' => 'bool',
'Dom\Document::isEqualNode' => 'bool',
'Dom\Document::isSameNode' => 'bool',
'Dom\Document::lookupNamespaceURI' => '?string',
'Dom\Document::lookupPrefix' => '?string',
'Dom\Document::normalize' => 'void',
'Dom\Document::prepend' => 'void',
'Dom\Document::querySelector' => '?\Dom\Element',
'Dom\Document::querySelectorAll' => '\Dom\NodeList',
'Dom\Document::registerNodeClass' => 'void',
'Dom\Document::relaxNgValidate' => 'bool',
'Dom\Document::relaxNgValidateSource' => 'bool',
'Dom\Document::removeChild' => '\Dom\Node',
'Dom\Document::replaceChild' => '\Dom\Node',
'Dom\Document::replaceChildren' => 'void',
'Dom\Document::schemaValidate' => 'bool',
'Dom\Document::schemaValidateSource' => 'bool',
'Dom\DocumentFragment::__sleep' => 'array',
'Dom\DocumentFragment::__wakeup' => 'void',
'Dom\DocumentFragment::append' => 'void',
'Dom\DocumentFragment::appendChild' => '\Dom\Node',
'Dom\DocumentFragment::appendXml' => 'bool',
'Dom\DocumentFragment::C14N' => 'false|string',
'Dom\DocumentFragment::C14NFile' => 'false|int',
'Dom\DocumentFragment::cloneNode' => '\Dom\Node',
'Dom\DocumentFragment::compareDocumentPosition' => 'int',
'Dom\DocumentFragment::contains' => 'bool',
'Dom\DocumentFragment::getLineNo' => 'int',
'Dom\DocumentFragment::getNodePath' => 'string',
'Dom\DocumentFragment::getRootNode' => '\Dom\Node',
'Dom\DocumentFragment::hasChildNodes' => 'bool',
'Dom\DocumentFragment::insertBefore' => '\Dom\Node',
'Dom\DocumentFragment::isDefaultNamespace' => 'bool',
'Dom\DocumentFragment::isEqualNode' => 'bool',
'Dom\DocumentFragment::isSameNode' => 'bool',
'Dom\DocumentFragment::lookupNamespaceURI' => '?string',
'Dom\DocumentFragment::lookupPrefix' => '?string',
'Dom\DocumentFragment::normalize' => 'void',
'Dom\DocumentFragment::prepend' => 'void',
'Dom\DocumentFragment::querySelector' => '?\Dom\Element',
'Dom\DocumentFragment::querySelectorAll' => '\Dom\NodeList',
'Dom\DocumentFragment::removeChild' => '\Dom\Node',
'Dom\DocumentFragment::replaceChild' => '\Dom\Node',
'Dom\DocumentFragment::replaceChildren' => 'void',
'Dom\DocumentType::__sleep' => 'array',
'Dom\DocumentType::__wakeup' => 'void',
'Dom\DocumentType::after' => 'void',
'Dom\DocumentType::appendChild' => '\Dom\Node',
'Dom\DocumentType::before' => 'void',
'Dom\DocumentType::C14N' => 'false|string',
'Dom\DocumentType::C14NFile' => 'false|int',
'Dom\DocumentType::cloneNode' => '\Dom\Node',
'Dom\DocumentType::compareDocumentPosition' => 'int',
'Dom\DocumentType::contains' => 'bool',
'Dom\DocumentType::getLineNo' => 'int',
'Dom\DocumentType::getNodePath' => 'string',
'Dom\DocumentType::getRootNode' => '\Dom\Node',
'Dom\DocumentType::hasChildNodes' => 'bool',
'Dom\DocumentType::insertBefore' => '\Dom\Node',
'Dom\DocumentType::isDefaultNamespace' => 'bool',
'Dom\DocumentType::isEqualNode' => 'bool',
'Dom\DocumentType::isSameNode' => 'bool',
'Dom\DocumentType::lookupNamespaceURI' => '?string',
'Dom\DocumentType::lookupPrefix' => '?string',
'Dom\DocumentType::normalize' => 'void',
'Dom\DocumentType::remove' => 'void',
'Dom\DocumentType::removeChild' => '\Dom\Node',
'Dom\DocumentType::replaceChild' => '\Dom\Node',
'Dom\DocumentType::replaceWith' => 'void',
'dom\domexception::__toString' => 'string',
'dom\domexception::getFile' => 'string',
'dom\domexception::getLine' => 'int',
'dom\domexception::getMessage' => 'string',
'dom\domexception::getPrevious' => '?\Throwable',
'dom\domexception::getTrace' => 'array',
'dom\domexception::getTraceAsString' => 'string',
'Dom\DtdNamedNodeMap::count' => 'int',
'Dom\DtdNamedNodeMap::getIterator' => '\Iterator',
'Dom\DtdNamedNodeMap::getNamedItem' => '\Dom\Entity|\Dom\Notation|null',
'Dom\DtdNamedNodeMap::getNamedItemNS' => '\Dom\Entity|\Dom\Notation|null',
'Dom\DtdNamedNodeMap::item' => '\Dom\Entity|\Dom\Notation|null',
'Dom\Element::__sleep' => 'array',
'Dom\Element::__wakeup' => 'void',
'Dom\Element::after' => 'void',
'Dom\Element::append' => 'void',
'Dom\Element::appendChild' => '\Dom\Node',
'Dom\Element::before' => 'void',
'Dom\Element::C14N' => 'false|string',
'Dom\Element::C14NFile' => 'false|int',
'Dom\Element::cloneNode' => '\Dom\Node',
'Dom\Element::closest' => '?\Dom\Element',
'Dom\Element::compareDocumentPosition' => 'int',
'Dom\Element::contains' => 'bool',
'Dom\Element::getAttribute' => '?string',
'Dom\Element::getAttributeNames' => 'array',
'Dom\Element::getAttributeNode' => '?\Dom\Attr',
'Dom\Element::getAttributeNodeNS' => '?\Dom\Attr',
'Dom\Element::getAttributeNS' => '?string',
'Dom\Element::getDescendantNamespaces' => 'array',
'Dom\Element::getElementsByTagName' => '\Dom\HTMLCollection',
'Dom\Element::getElementsByTagNameNS' => '\Dom\HTMLCollection',
'Dom\Element::getInScopeNamespaces' => 'array',
'Dom\Element::getLineNo' => 'int',
'Dom\Element::getNodePath' => 'string',
'Dom\Element::getRootNode' => '\Dom\Node',
'Dom\Element::hasAttribute' => 'bool',
'Dom\Element::hasAttributeNS' => 'bool',
'Dom\Element::hasAttributes' => 'bool',
'Dom\Element::hasChildNodes' => 'bool',
'Dom\Element::insertAdjacentElement' => '?\Dom\Element',
'Dom\Element::insertAdjacentText' => 'void',
'Dom\Element::insertBefore' => '\Dom\Node',
'Dom\Element::isDefaultNamespace' => 'bool',
'Dom\Element::isEqualNode' => 'bool',
'Dom\Element::isSameNode' => 'bool',
'Dom\Element::lookupNamespaceURI' => '?string',
'Dom\Element::lookupPrefix' => '?string',
'Dom\Element::matches' => 'bool',
'Dom\Element::normalize' => 'void',
'Dom\Element::prepend' => 'void',
'Dom\Element::querySelector' => '?\Dom\Element',
'Dom\Element::querySelectorAll' => '\Dom\NodeList',
'Dom\Element::remove' => 'void',
'Dom\Element::removeAttribute' => 'void',
'Dom\Element::removeAttributeNode' => '\Dom\Attr',
'Dom\Element::removeAttributeNS' => 'void',
'Dom\Element::removeChild' => '\Dom\Node',
'Dom\Element::rename' => 'void',
'Dom\Element::replaceChild' => '\Dom\Node',
'Dom\Element::replaceChildren' => 'void',
'Dom\Element::replaceWith' => 'void',
'Dom\Element::setAttribute' => 'void',
'Dom\Element::setAttributeNode' => '?\Dom\Attr',
'Dom\Element::setAttributeNodeNS' => '?\Dom\Attr',
'Dom\Element::setAttributeNS' => 'void',
'Dom\Element::setIdAttribute' => 'void',
'Dom\Element::setIdAttributeNode' => 'void',
'Dom\Element::setIdAttributeNS' => 'void',
'Dom\Element::toggleAttribute' => 'bool',
'Dom\Entity::__sleep' => 'array',
'Dom\Entity::__wakeup' => 'void',
'Dom\Entity::appendChild' => '\Dom\Node',
'Dom\Entity::C14N' => 'false|string',
'Dom\Entity::C14NFile' => 'false|int',
'Dom\Entity::cloneNode' => '\Dom\Node',
'Dom\Entity::compareDocumentPosition' => 'int',
'Dom\Entity::contains' => 'bool',
'Dom\Entity::getLineNo' => 'int',
'Dom\Entity::getNodePath' => 'string',
'Dom\Entity::getRootNode' => '\Dom\Node',
'Dom\Entity::hasChildNodes' => 'bool',
'Dom\Entity::insertBefore' => '\Dom\Node',
'Dom\Entity::isDefaultNamespace' => 'bool',
'Dom\Entity::isEqualNode' => 'bool',
'Dom\Entity::isSameNode' => 'bool',
'Dom\Entity::lookupNamespaceURI' => '?string',
'Dom\Entity::lookupPrefix' => '?string',
'Dom\Entity::normalize' => 'void',
'Dom\Entity::removeChild' => '\Dom\Node',
'Dom\Entity::replaceChild' => '\Dom\Node',
'Dom\EntityReference::__sleep' => 'array',
'Dom\EntityReference::__wakeup' => 'void',
'Dom\EntityReference::appendChild' => '\Dom\Node',
'Dom\EntityReference::C14N' => 'false|string',
'Dom\EntityReference::C14NFile' => 'false|int',
'Dom\EntityReference::cloneNode' => '\Dom\Node',
'Dom\EntityReference::compareDocumentPosition' => 'int',
'Dom\EntityReference::contains' => 'bool',
'Dom\EntityReference::getLineNo' => 'int',
'Dom\EntityReference::getNodePath' => 'string',
'Dom\EntityReference::getRootNode' => '\Dom\Node',
'Dom\EntityReference::hasChildNodes' => 'bool',
'Dom\EntityReference::insertBefore' => '\Dom\Node',
'Dom\EntityReference::isDefaultNamespace' => 'bool',
'Dom\EntityReference::isEqualNode' => 'bool',
'Dom\EntityReference::isSameNode' => 'bool',
'Dom\EntityReference::lookupNamespaceURI' => '?string',
'Dom\EntityReference::lookupPrefix' => '?string',
'Dom\EntityReference::normalize' => 'void',
'Dom\EntityReference::removeChild' => '\Dom\Node',
'Dom\EntityReference::replaceChild' => '\Dom\Node',
'Dom\HTMLCollection::count' => 'int',
'Dom\HTMLCollection::getIterator' => '\Iterator',
'Dom\HTMLCollection::item' => '?\Dom\Element',
'Dom\HTMLCollection::namedItem' => '?\Dom\Element',
'Dom\HTMLDocument::__sleep' => 'array',
'Dom\HTMLDocument::__wakeup' => 'void',
'Dom\HTMLDocument::adoptNode' => '\Dom\Node',
'Dom\HTMLDocument::append' => 'void',
'Dom\HTMLDocument::appendChild' => '\Dom\Node',
'Dom\HTMLDocument::C14N' => 'false|string',
'Dom\HTMLDocument::C14NFile' => 'false|int',
'Dom\HTMLDocument::cloneNode' => '\Dom\Node',
'Dom\HTMLDocument::compareDocumentPosition' => 'int',
'Dom\HTMLDocument::contains' => 'bool',
'Dom\HTMLDocument::createAttribute' => '\Dom\Attr',
'Dom\HTMLDocument::createAttributeNS' => '\Dom\Attr',
'Dom\HTMLDocument::createCDATASection' => '\Dom\CDATASection',
'Dom\HTMLDocument::createComment' => '\Dom\Comment',
'Dom\HTMLDocument::createDocumentFragment' => '\Dom\DocumentFragment',
'Dom\HTMLDocument::createElement' => '\Dom\Element',
'Dom\HTMLDocument::createElementNS' => '\Dom\Element',
'Dom\HTMLDocument::createEmpty' => '\Dom\HTMLDocument',
'Dom\HTMLDocument::createFromFile' => '\Dom\HTMLDocument',
'Dom\HTMLDocument::createFromString' => '\Dom\HTMLDocument',
'Dom\HTMLDocument::createProcessingInstruction' => '\Dom\ProcessingInstruction',
'Dom\HTMLDocument::createTextNode' => '\Dom\Text',
'Dom\HTMLDocument::getElementById' => '?\Dom\Element',
'Dom\HTMLDocument::getElementsByTagName' => '\Dom\HTMLCollection',
'Dom\HTMLDocument::getElementsByTagNameNS' => '\Dom\HTMLCollection',
'Dom\HTMLDocument::getLineNo' => 'int',
'Dom\HTMLDocument::getNodePath' => 'string',
'Dom\HTMLDocument::getRootNode' => '\Dom\Node',
'Dom\HTMLDocument::hasChildNodes' => 'bool',
'Dom\HTMLDocument::importLegacyNode' => '\Dom\Node',
'Dom\HTMLDocument::importNode' => '\Dom\Node',
'Dom\HTMLDocument::insertBefore' => '\Dom\Node',
'Dom\HTMLDocument::isDefaultNamespace' => 'bool',
'Dom\HTMLDocument::isEqualNode' => 'bool',
'Dom\HTMLDocument::isSameNode' => 'bool',
'Dom\HTMLDocument::lookupNamespaceURI' => '?string',
'Dom\HTMLDocument::lookupPrefix' => '?string',
'Dom\HTMLDocument::normalize' => 'void',
'Dom\HTMLDocument::prepend' => 'void',
'Dom\HTMLDocument::querySelector' => '?\Dom\Element',
'Dom\HTMLDocument::querySelectorAll' => '\Dom\NodeList',
'Dom\HTMLDocument::registerNodeClass' => 'void',
'Dom\HTMLDocument::relaxNgValidate' => 'bool',
'Dom\HTMLDocument::relaxNgValidateSource' => 'bool',
'Dom\HTMLDocument::removeChild' => '\Dom\Node',
'Dom\HTMLDocument::replaceChild' => '\Dom\Node',
'Dom\HTMLDocument::replaceChildren' => 'void',
'Dom\HTMLDocument::saveHtml' => 'string',
'Dom\HTMLDocument::saveHtmlFile' => 'false|int',
'Dom\HTMLDocument::saveXml' => 'false|string',
'Dom\HTMLDocument::saveXmlFile' => 'false|int',
'Dom\HTMLDocument::schemaValidate' => 'bool',
'Dom\HTMLDocument::schemaValidateSource' => 'bool',
'Dom\HTMLElement::__sleep' => 'array',
'Dom\HTMLElement::__wakeup' => 'void',
'Dom\HTMLElement::after' => 'void',
'Dom\HTMLElement::append' => 'void',
'Dom\HTMLElement::appendChild' => '\Dom\Node',
'Dom\HTMLElement::before' => 'void',
'Dom\HTMLElement::C14N' => 'false|string',
'Dom\HTMLElement::C14NFile' => 'false|int',
'Dom\HTMLElement::cloneNode' => '\Dom\Node',
'Dom\HTMLElement::closest' => '?\Dom\Element',
'Dom\HTMLElement::compareDocumentPosition' => 'int',
'Dom\HTMLElement::contains' => 'bool',
'Dom\HTMLElement::getAttribute' => '?string',
'Dom\HTMLElement::getAttributeNames' => 'array',
'Dom\HTMLElement::getAttributeNode' => '?\Dom\Attr',
'Dom\HTMLElement::getAttributeNodeNS' => '?\Dom\Attr',
'Dom\HTMLElement::getAttributeNS' => '?string',
'Dom\HTMLElement::getDescendantNamespaces' => 'array',
'Dom\HTMLElement::getElementsByTagName' => '\Dom\HTMLCollection',
'Dom\HTMLElement::getElementsByTagNameNS' => '\Dom\HTMLCollection',
'Dom\HTMLElement::getInScopeNamespaces' => 'array',
'Dom\HTMLElement::getLineNo' => 'int',
'Dom\HTMLElement::getNodePath' => 'string',
'Dom\HTMLElement::getRootNode' => '\Dom\Node',
'Dom\HTMLElement::hasAttribute' => 'bool',
'Dom\HTMLElement::hasAttributeNS' => 'bool',
'Dom\HTMLElement::hasAttributes' => 'bool',
'Dom\HTMLElement::hasChildNodes' => 'bool',
'Dom\HTMLElement::insertAdjacentElement' => '?\Dom\Element',
'Dom\HTMLElement::insertAdjacentText' => 'void',
'Dom\HTMLElement::insertBefore' => '\Dom\Node',
'Dom\HTMLElement::isDefaultNamespace' => 'bool',
'Dom\HTMLElement::isEqualNode' => 'bool',
'Dom\HTMLElement::isSameNode' => 'bool',
'Dom\HTMLElement::lookupNamespaceURI' => '?string',
'Dom\HTMLElement::lookupPrefix' => '?string',
'Dom\HTMLElement::matches' => 'bool',
'Dom\HTMLElement::normalize' => 'void',
'Dom\HTMLElement::prepend' => 'void',
'Dom\HTMLElement::querySelector' => '?\Dom\Element',
'Dom\HTMLElement::querySelectorAll' => '\Dom\NodeList',
'Dom\HTMLElement::remove' => 'void',
'Dom\HTMLElement::removeAttribute' => 'void',
'Dom\HTMLElement::removeAttributeNode' => '\Dom\Attr',
'Dom\HTMLElement::removeAttributeNS' => 'void',
'Dom\HTMLElement::removeChild' => '\Dom\Node',
'Dom\HTMLElement::rename' => 'void',
'Dom\HTMLElement::replaceChild' => '\Dom\Node',
'Dom\HTMLElement::replaceChildren' => 'void',
'Dom\HTMLElement::replaceWith' => 'void',
'Dom\HTMLElement::setAttribute' => 'void',
'Dom\HTMLElement::setAttributeNode' => '?\Dom\Attr',
'Dom\HTMLElement::setAttributeNodeNS' => '?\Dom\Attr',
'Dom\HTMLElement::setAttributeNS' => 'void',
'Dom\HTMLElement::setIdAttribute' => 'void',
'Dom\HTMLElement::setIdAttributeNode' => 'void',
'Dom\HTMLElement::setIdAttributeNS' => 'void',
'Dom\HTMLElement::toggleAttribute' => 'bool',
'Dom\Implementation::createDocument' => '\Dom\XMLDocument',
'Dom\Implementation::createDocumentType' => '\Dom\DocumentType',
'Dom\Implementation::createHTMLDocument' => '\Dom\HTMLDocument',
'dom\import_simplexml' => '\Dom\Attr|\Dom\Element',
'Dom\NamedNodeMap::count' => 'int',
'Dom\NamedNodeMap::getIterator' => '\Iterator',
'Dom\NamedNodeMap::getNamedItem' => '?\Dom\Attr',
'Dom\NamedNodeMap::getNamedItemNS' => '?\Dom\Attr',
'Dom\NamedNodeMap::item' => '?\Dom\Attr',
'Dom\Node::__sleep' => 'array',
'Dom\Node::__wakeup' => 'void',
'Dom\Node::appendChild' => '\Dom\Node',
'Dom\Node::C14N' => 'false|string',
'Dom\Node::C14NFile' => 'false|int',
'Dom\Node::cloneNode' => '\Dom\Node',
'Dom\Node::compareDocumentPosition' => 'int',
'Dom\Node::contains' => 'bool',
'Dom\Node::getLineNo' => 'int',
'Dom\Node::getNodePath' => 'string',
'Dom\Node::getRootNode' => '\Dom\Node',
'Dom\Node::hasChildNodes' => 'bool',
'Dom\Node::insertBefore' => '\Dom\Node',
'Dom\Node::isDefaultNamespace' => 'bool',
'Dom\Node::isEqualNode' => 'bool',
'Dom\Node::isSameNode' => 'bool',
'Dom\Node::lookupNamespaceURI' => '?string',
'Dom\Node::lookupPrefix' => '?string',
'Dom\Node::normalize' => 'void',
'Dom\Node::removeChild' => '\Dom\Node',
'Dom\Node::replaceChild' => '\Dom\Node',
'Dom\NodeList::count' => 'int',
'Dom\NodeList::getIterator' => '\Iterator',
'Dom\NodeList::item' => '?\Dom\Node',
'Dom\Notation::__sleep' => 'array',
'Dom\Notation::__wakeup' => 'void',
'Dom\Notation::appendChild' => '\Dom\Node',
'Dom\Notation::C14N' => 'false|string',
'Dom\Notation::C14NFile' => 'false|int',
'Dom\Notation::cloneNode' => '\Dom\Node',
'Dom\Notation::compareDocumentPosition' => 'int',
'Dom\Notation::contains' => 'bool',
'Dom\Notation::getLineNo' => 'int',
'Dom\Notation::getNodePath' => 'string',
'Dom\Notation::getRootNode' => '\Dom\Node',
'Dom\Notation::hasChildNodes' => 'bool',
'Dom\Notation::insertBefore' => '\Dom\Node',
'Dom\Notation::isDefaultNamespace' => 'bool',
'Dom\Notation::isEqualNode' => 'bool',
'Dom\Notation::isSameNode' => 'bool',
'Dom\Notation::lookupNamespaceURI' => '?string',
'Dom\Notation::lookupPrefix' => '?string',
'Dom\Notation::normalize' => 'void',
'Dom\Notation::removeChild' => '\Dom\Node',
'Dom\Notation::replaceChild' => '\Dom\Node',
'Dom\ProcessingInstruction::__sleep' => 'array',
'Dom\ProcessingInstruction::__wakeup' => 'void',
'Dom\ProcessingInstruction::after' => 'void',
'Dom\ProcessingInstruction::appendChild' => '\Dom\Node',
'Dom\ProcessingInstruction::appendData' => 'void',
'Dom\ProcessingInstruction::before' => 'void',
'Dom\ProcessingInstruction::C14N' => 'false|string',
'Dom\ProcessingInstruction::C14NFile' => 'false|int',
'Dom\ProcessingInstruction::cloneNode' => '\Dom\Node',
'Dom\ProcessingInstruction::compareDocumentPosition' => 'int',
'Dom\ProcessingInstruction::contains' => 'bool',
'Dom\ProcessingInstruction::deleteData' => 'void',
'Dom\ProcessingInstruction::getLineNo' => 'int',
'Dom\ProcessingInstruction::getNodePath' => 'string',
'Dom\ProcessingInstruction::getRootNode' => '\Dom\Node',
'Dom\ProcessingInstruction::hasChildNodes' => 'bool',
'Dom\ProcessingInstruction::insertBefore' => '\Dom\Node',
'Dom\ProcessingInstruction::insertData' => 'void',
'Dom\ProcessingInstruction::isDefaultNamespace' => 'bool',
'Dom\ProcessingInstruction::isEqualNode' => 'bool',
'Dom\ProcessingInstruction::isSameNode' => 'bool',
'Dom\ProcessingInstruction::lookupNamespaceURI' => '?string',
'Dom\ProcessingInstruction::lookupPrefix' => '?string',
'Dom\ProcessingInstruction::normalize' => 'void',
'Dom\ProcessingInstruction::remove' => 'void',
'Dom\ProcessingInstruction::removeChild' => '\Dom\Node',
'Dom\ProcessingInstruction::replaceChild' => '\Dom\Node',
'Dom\ProcessingInstruction::replaceData' => 'void',
'Dom\ProcessingInstruction::replaceWith' => 'void',
'Dom\ProcessingInstruction::substringData' => 'string',
'Dom\Text::__sleep' => 'array',
'Dom\Text::__wakeup' => 'void',
'Dom\Text::after' => 'void',
'Dom\Text::appendChild' => '\Dom\Node',
'Dom\Text::appendData' => 'void',
'Dom\Text::before' => 'void',
'Dom\Text::C14N' => 'false|string',
'Dom\Text::C14NFile' => 'false|int',
'Dom\Text::cloneNode' => '\Dom\Node',
'Dom\Text::compareDocumentPosition' => 'int',
'Dom\Text::contains' => 'bool',
'Dom\Text::deleteData' => 'void',
'Dom\Text::getLineNo' => 'int',
'Dom\Text::getNodePath' => 'string',
'Dom\Text::getRootNode' => '\Dom\Node',
'Dom\Text::hasChildNodes' => 'bool',
'Dom\Text::insertBefore' => '\Dom\Node',
'Dom\Text::insertData' => 'void',
'Dom\Text::isDefaultNamespace' => 'bool',
'Dom\Text::isEqualNode' => 'bool',
'Dom\Text::isSameNode' => 'bool',
'Dom\Text::lookupNamespaceURI' => '?string',
'Dom\Text::lookupPrefix' => '?string',
'Dom\Text::normalize' => 'void',
'Dom\Text::remove' => 'void',
'Dom\Text::removeChild' => '\Dom\Node',
'Dom\Text::replaceChild' => '\Dom\Node',
'Dom\Text::replaceData' => 'void',
'Dom\Text::replaceWith' => 'void',
'Dom\Text::splitText' => '\Dom\Text',
'Dom\Text::substringData' => 'string',
'Dom\TokenList::add' => 'void',
'Dom\TokenList::contains' => 'bool',
'Dom\TokenList::count' => 'int',
'Dom\TokenList::getIterator' => '\Iterator',
'Dom\TokenList::item' => '?string',
'Dom\TokenList::remove' => 'void',
'Dom\TokenList::replace' => 'bool',
'Dom\TokenList::supports' => 'bool',
'Dom\TokenList::toggle' => 'bool',
'Dom\XMLDocument::__sleep' => 'array',
'Dom\XMLDocument::__wakeup' => 'void',
'Dom\XMLDocument::adoptNode' => '\Dom\Node',
'Dom\XMLDocument::append' => 'void',
'Dom\XMLDocument::appendChild' => '\Dom\Node',
'Dom\XMLDocument::C14N' => 'false|string',
'Dom\XMLDocument::C14NFile' => 'false|int',
'Dom\XMLDocument::cloneNode' => '\Dom\Node',
'Dom\XMLDocument::compareDocumentPosition' => 'int',
'Dom\XMLDocument::contains' => 'bool',
'Dom\XMLDocument::createAttribute' => '\Dom\Attr',
'Dom\XMLDocument::createAttributeNS' => '\Dom\Attr',
'Dom\XMLDocument::createCDATASection' => '\Dom\CDATASection',
'Dom\XMLDocument::createComment' => '\Dom\Comment',
'Dom\XMLDocument::createDocumentFragment' => '\Dom\DocumentFragment',
'Dom\XMLDocument::createElement' => '\Dom\Element',
'Dom\XMLDocument::createElementNS' => '\Dom\Element',
'Dom\XMLDocument::createEmpty' => '\Dom\XMLDocument',
'Dom\XMLDocument::createEntityReference' => '\Dom\EntityReference',
'Dom\XMLDocument::createFromFile' => '\Dom\XMLDocument',
'Dom\XMLDocument::createFromString' => '\Dom\XMLDocument',
'Dom\XMLDocument::createProcessingInstruction' => '\Dom\ProcessingInstruction',
'Dom\XMLDocument::createTextNode' => '\Dom\Text',
'Dom\XMLDocument::getElementById' => '?\Dom\Element',
'Dom\XMLDocument::getElementsByTagName' => '\Dom\HTMLCollection',
'Dom\XMLDocument::getElementsByTagNameNS' => '\Dom\HTMLCollection',
'Dom\XMLDocument::getLineNo' => 'int',
'Dom\XMLDocument::getNodePath' => 'string',
'Dom\XMLDocument::getRootNode' => '\Dom\Node',
'Dom\XMLDocument::hasChildNodes' => 'bool',
'Dom\XMLDocument::importLegacyNode' => '\Dom\Node',
'Dom\XMLDocument::importNode' => '\Dom\Node',
'Dom\XMLDocument::insertBefore' => '\Dom\Node',
'Dom\XMLDocument::isDefaultNamespace' => 'bool',
'Dom\XMLDocument::isEqualNode' => 'bool',
'Dom\XMLDocument::isSameNode' => 'bool',
'Dom\XMLDocument::lookupNamespaceURI' => '?string',
'Dom\XMLDocument::lookupPrefix' => '?string',
'Dom\XMLDocument::normalize' => 'void',
'Dom\XMLDocument::prepend' => 'void',
'Dom\XMLDocument::querySelector' => '?\Dom\Element',
'Dom\XMLDocument::querySelectorAll' => '\Dom\NodeList',
'Dom\XMLDocument::registerNodeClass' => 'void',
'Dom\XMLDocument::relaxNgValidate' => 'bool',
'Dom\XMLDocument::relaxNgValidateSource' => 'bool',
'Dom\XMLDocument::removeChild' => '\Dom\Node',
'Dom\XMLDocument::replaceChild' => '\Dom\Node',
'Dom\XMLDocument::replaceChildren' => 'void',
'Dom\XMLDocument::saveXml' => 'false|string',
'Dom\XMLDocument::saveXmlFile' => 'false|int',
'Dom\XMLDocument::schemaValidate' => 'bool',
'Dom\XMLDocument::schemaValidateSource' => 'bool',
'Dom\XMLDocument::validate' => 'bool',
'Dom\XMLDocument::xinclude' => 'int',
'Dom\XPath::evaluate' => '\Dom\NodeList|bool|float|null|string',
'Dom\XPath::query' => '\Dom\NodeList',
'Dom\XPath::quote' => 'string',
'Dom\XPath::registerNamespace' => 'bool',
'Dom\XPath::registerPhpFunctionNS' => 'void',
'Dom\XPath::registerPhpFunctions' => 'void',
'dom_import_simplexml' => '\DOMAttr|\DOMElement',
'DomainException::__toString' => 'string',
'DomainException::getFile' => 'string',
'DomainException::getLine' => 'int',
'DomainException::getMessage' => 'string',
'DomainException::getPrevious' => '?\Throwable',
'DomainException::getTrace' => 'array',
'DomainException::getTraceAsString' => 'string',
'DOMAttr::__sleep' => 'array',
'DOMAttr::__wakeup' => 'void',
'DOMAttr::compareDocumentPosition' => 'int',
'DOMAttr::contains' => 'bool',
'DOMAttr::getRootNode' => '\DOMNode',
'DOMAttr::isEqualNode' => 'bool',
'DOMCdataSection::__sleep' => 'array',
'DOMCdataSection::__wakeup' => 'void',
'DOMCdataSection::after' => 'void',
'DOMCdataSection::before' => 'void',
'DOMCdataSection::compareDocumentPosition' => 'int',
'DOMCdataSection::contains' => 'bool',
'DOMCdataSection::getRootNode' => '\DOMNode',
'DOMCdataSection::isEqualNode' => 'bool',
'DOMCdataSection::remove' => 'void',
'DOMCdataSection::replaceWith' => 'void',
'DOMCharacterData::__sleep' => 'array',
'DOMCharacterData::__wakeup' => 'void',
'DOMCharacterData::after' => 'void',
'DOMCharacterData::before' => 'void',
'DOMCharacterData::compareDocumentPosition' => 'int',
'DOMCharacterData::contains' => 'bool',
'DOMCharacterData::getRootNode' => '\DOMNode',
'DOMCharacterData::isEqualNode' => 'bool',
'DOMCharacterData::remove' => 'void',
'DOMCharacterData::replaceWith' => 'void',
'DOMComment::__sleep' => 'array',
'DOMComment::__wakeup' => 'void',
'DOMComment::after' => 'void',
'DOMComment::before' => 'void',
'DOMComment::compareDocumentPosition' => 'int',
'DOMComment::contains' => 'bool',
'DOMComment::getRootNode' => '\DOMNode',
'DOMComment::isEqualNode' => 'bool',
'DOMComment::remove' => 'void',
'DOMComment::replaceWith' => 'void',
'DOMDocument::__sleep' => 'array',
'DOMDocument::__wakeup' => 'void',
'DOMDocument::append' => 'void',
'DOMDocument::compareDocumentPosition' => 'int',
'DOMDocument::contains' => 'bool',
'DOMDocument::getRootNode' => '\DOMNode',
'DOMDocument::isEqualNode' => 'bool',
'DOMDocument::prepend' => 'void',
'DOMDocument::replaceChildren' => 'void',
'DOMDocumentFragment::__sleep' => 'array',
'DOMDocumentFragment::__wakeup' => 'void',
'DOMDocumentFragment::append' => 'void',
'DOMDocumentFragment::compareDocumentPosition' => 'int',
'DOMDocumentFragment::contains' => 'bool',
'DOMDocumentFragment::getRootNode' => '\DOMNode',
'DOMDocumentFragment::isEqualNode' => 'bool',
'DOMDocumentFragment::prepend' => 'void',
'DOMDocumentFragment::replaceChildren' => 'void',
'DOMDocumentType::__sleep' => 'array',
'DOMDocumentType::__wakeup' => 'void',
'DOMDocumentType::compareDocumentPosition' => 'int',
'DOMDocumentType::contains' => 'bool',
'DOMDocumentType::getRootNode' => '\DOMNode',
'DOMDocumentType::isEqualNode' => 'bool',
'DOMElement::__sleep' => 'array',
'DOMElement::__wakeup' => 'void',
'DOMElement::after' => 'void',
'DOMElement::append' => 'void',
'DOMElement::before' => 'void',
'DOMElement::compareDocumentPosition' => 'int',
'DOMElement::contains' => 'bool',
'DOMElement::getAttributeNames' => 'array',
'DOMElement::getRootNode' => '\DOMNode',
'DOMElement::insertAdjacentElement' => '?\DOMElement',
'DOMElement::insertAdjacentText' => 'void',
'DOMElement::isEqualNode' => 'bool',
'DOMElement::prepend' => 'void',
'DOMElement::remove' => 'void',
'DOMElement::replaceChildren' => 'void',
'DOMElement::replaceWith' => 'void',
'DOMElement::toggleAttribute' => 'bool',
'DOMEntity::__sleep' => 'array',
'DOMEntity::__wakeup' => 'void',
'DOMEntity::compareDocumentPosition' => 'int',
'DOMEntity::contains' => 'bool',
'DOMEntity::getRootNode' => '\DOMNode',
'DOMEntity::isEqualNode' => 'bool',
'DOMEntityReference::__sleep' => 'array',
'DOMEntityReference::__wakeup' => 'void',
'DOMEntityReference::compareDocumentPosition' => 'int',
'DOMEntityReference::contains' => 'bool',
'DOMEntityReference::getRootNode' => '\DOMNode',
'DOMEntityReference::isEqualNode' => 'bool',
'DOMException::__toString' => 'string',
'DOMException::getFile' => 'string',
'DOMException::getLine' => 'int',
'DOMException::getMessage' => 'string',
'DOMException::getPrevious' => '?\Throwable',
'DOMException::getTrace' => 'array',
'DOMException::getTraceAsString' => 'string',
'DOMNamedNodeMap::getIterator' => '\Iterator',
'DOMNameSpaceNode::__sleep' => 'array',
'DOMNameSpaceNode::__wakeup' => 'void',
'DOMNode::__sleep' => 'array',
'DOMNode::__wakeup' => 'void',
'DOMNode::compareDocumentPosition' => 'int',
'DOMNode::contains' => 'bool',
'DOMNode::getRootNode' => '\DOMNode',
'DOMNode::isEqualNode' => 'bool',
'DOMNodeList::getIterator' => '\Iterator',
'DOMNotation::__sleep' => 'array',
'DOMNotation::__wakeup' => 'void',
'DOMNotation::compareDocumentPosition' => 'int',
'DOMNotation::contains' => 'bool',
'DOMNotation::getRootNode' => '\DOMNode',
'DOMNotation::isEqualNode' => 'bool',
'DOMProcessingInstruction::__sleep' => 'array',
'DOMProcessingInstruction::__wakeup' => 'void',
'DOMProcessingInstruction::compareDocumentPosition' => 'int',
'DOMProcessingInstruction::contains' => 'bool',
'DOMProcessingInstruction::getRootNode' => '\DOMNode',
'DOMProcessingInstruction::isEqualNode' => 'bool',
'DOMText::__sleep' => 'array',
'DOMText::__wakeup' => 'void',
'DOMText::after' => 'void',
'DOMText::before' => 'void',
'DOMText::compareDocumentPosition' => 'int',
'DOMText::contains' => 'bool',
'DOMText::getRootNode' => '\DOMNode',
'DOMText::isEqualNode' => 'bool',
'DOMText::remove' => 'void',
'DOMText::replaceWith' => 'void',
'DOMXPath::quote' => 'string',
'DOMXPath::registerPhpFunctionNS' => 'void',
'doubleval' => 'float',
'easter_date' => 'int',
'easter_days' => 'int',
'end' => 'mixed',
'enum_exists' => 'bool',
'Error::__clone' => 'void',
'Error::__toString' => 'string',
'Error::getFile' => 'string',
'Error::getLine' => 'int',
'Error::getMessage' => 'string',
'Error::getPrevious' => '?\Throwable',
'Error::getTrace' => 'array',
'Error::getTraceAsString' => 'string',
'error_clear_last' => 'void',
'error_get_last' => '?array',
'error_log' => 'bool',
'error_reporting' => 'int',
'ErrorException::__toString' => 'string',
'ErrorException::getFile' => 'string',
'ErrorException::getLine' => 'int',
'ErrorException::getMessage' => 'string',
'ErrorException::getPrevious' => '?\Throwable',
'ErrorException::getSeverity' => 'int',
'ErrorException::getTrace' => 'array',
'ErrorException::getTraceAsString' => 'string',
'escapeshellarg' => 'string',
'escapeshellcmd' => 'string',
'Exception::__clone' => 'void',
'Exception::__toString' => 'string',
'Exception::getFile' => 'string',
'Exception::getLine' => 'int',
'Exception::getMessage' => 'string',
'Exception::getPrevious' => '?\Throwable',
'Exception::getTrace' => 'array',
'Exception::getTraceAsString' => 'string',
'ExcimerLog::aggregateByFunction' => 'array',
'ExcimerProfiler::getLog' => '\ExcimerLog',
'exec' => 'false|string',
'exif_imagetype' => 'false|int',
'exif_read_data' => 'array|false',
'exif_tagname' => 'false|string',
'exif_thumbnail' => 'false|string',
'exit' => 'never',
'exp' => 'float',
'explode' => 'array',
'expm1' => 'float',
'extension_loaded' => 'bool',
'extract' => 'int',
'fclose' => 'bool',
'fdatasync' => 'bool',
'fdiv' => 'float',
'feof' => 'bool',
'FFI::addr' => '\FFI\CData',
'FFI::alignof' => 'int',
'FFI::arrayType' => '\FFI\CType',
'FFI::cast' => '\FFI\CData',
'FFI::cdef' => '\FFI',
'FFI::free' => 'void',
'FFI::isNull' => 'bool',
'FFI::load' => '?\FFI',
'FFI::memcmp' => 'int',
'FFI::memcpy' => 'void',
'FFI::memset' => 'void',
'FFI::new' => '\FFI\CData',
'FFI::scope' => '\FFI',
'FFI::sizeof' => 'int',
'FFI::string' => 'string',
'FFI::type' => '\FFI\CType',
'FFI::typeof' => '\FFI\CType',
'FFI\CType::getAlignment' => 'int',
'FFI\CType::getArrayElementType' => '\FFI\CType',
'FFI\CType::getArrayLength' => 'int',
'FFI\CType::getAttributes' => 'int',
'FFI\CType::getEnumKind' => 'int',
'FFI\CType::getFuncABI' => 'int',
'FFI\CType::getFuncParameterCount' => 'int',
'FFI\CType::getFuncParameterType' => '\FFI\CType',
'FFI\CType::getFuncReturnType' => '\FFI\CType',
'FFI\CType::getKind' => 'int',
'FFI\CType::getName' => 'string',
'FFI\CType::getPointerType' => '\FFI\CType',
'FFI\CType::getSize' => 'int',
'FFI\CType::getStructFieldNames' => 'array',
'FFI\CType::getStructFieldOffset' => 'int',
'FFI\CType::getStructFieldType' => '\FFI\CType',
'FFI\Exception::__toString' => 'string',
'FFI\Exception::getFile' => 'string',
'FFI\Exception::getLine' => 'int',
'FFI\Exception::getMessage' => 'string',
'FFI\Exception::getPrevious' => '?\Throwable',
'FFI\Exception::getTrace' => 'array',
'FFI\Exception::getTraceAsString' => 'string',
'FFI\ParserException::__toString' => 'string',
'FFI\ParserException::getFile' => 'string',
'FFI\ParserException::getLine' => 'int',
'FFI\ParserException::getMessage' => 'string',
'FFI\ParserException::getPrevious' => '?\Throwable',
'FFI\ParserException::getTrace' => 'array',
'FFI\ParserException::getTraceAsString' => 'string',
'fflush' => 'bool',
'fgetc' => 'false|string',
'fgetcsv' => 'array|false',
'fgets' => 'false|string',
'Fiber::getCurrent' => '?\Fiber',
'Fiber::getReturn' => 'mixed',
'Fiber::isRunning' => 'bool',
'Fiber::isStarted' => 'bool',
'Fiber::isSuspended' => 'bool',
'Fiber::isTerminated' => 'bool',
'Fiber::resume' => 'mixed',
'Fiber::start' => 'mixed',
'Fiber::suspend' => 'mixed',
'Fiber::throw' => 'mixed',
'FiberError::__toString' => 'string',
'FiberError::getFile' => 'string',
'FiberError::getLine' => 'int',
'FiberError::getMessage' => 'string',
'FiberError::getPrevious' => '?\Throwable',
'FiberError::getTrace' => 'array',
'FiberError::getTraceAsString' => 'string',
'file' => 'array|false',
'file_exists' => 'bool',
'file_get_contents' => 'false|string',
'file_put_contents' => 'false|int',
'fileatime' => 'false|int',
'filectime' => 'false|int',
'filegroup' => 'false|int',
'fileinode' => 'false|int',
'filemtime' => 'false|int',
'fileowner' => 'false|int',
'fileperms' => 'false|int',
'filesize' => 'false|int',
'FilesystemIterator::__toString' => 'string',
'filetype' => 'false|string',
'filter_has_var' => 'bool',
'filter_id' => 'false|int',
'filter_input' => 'mixed',
'filter_input_array' => 'array|false|null',
'filter_list' => 'array',
'filter_var' => 'mixed',
'filter_var_array' => 'array|false|null',
'finfo_buffer' => 'false|string',
'finfo_close' => 'bool',
'finfo_file' => 'false|string',
'finfo_open' => '\finfo|false',
'finfo_set_flags' => 'true',
'floatval' => 'float',
'flock' => 'bool',
'floor' => 'float',
'flush' => 'void',
'fmod' => 'float',
'fnmatch' => 'bool',
'forward_static_call' => 'mixed',
'forward_static_call_array' => 'mixed',
'fpassthru' => 'int',
'fpow' => 'float',
'fprintf' => 'int',
'fputcsv' => 'false|int',
'fputs' => 'false|int',
'fread' => 'false|string',
'frenchtojd' => 'int',
'fscanf' => 'array|false|int|null',
'fseek' => 'int',
'fstat' => 'array|false',
'fsync' => 'bool',
'ftell' => 'false|int',
'ftok' => 'int',
'ftp_alloc' => 'bool',
'ftp_append' => 'bool',
'ftp_cdup' => 'bool',
'ftp_chdir' => 'bool',
'ftp_chmod' => 'false|int',
'ftp_close' => 'bool',
'ftp_connect' => '\FTP\Connection|false',
'ftp_delete' => 'bool',
'ftp_exec' => 'bool',
'ftp_fget' => 'bool',
'ftp_fput' => 'bool',
'ftp_get' => 'bool',
'ftp_get_option' => 'bool|int',
'ftp_login' => 'bool',
'ftp_mdtm' => 'int',
'ftp_mkdir' => 'false|string',
'ftp_mlsd' => 'array|false',
'ftp_nb_continue' => 'int',
'ftp_nb_fget' => 'int',
'ftp_nb_fput' => 'int',
'ftp_nb_get' => 'false|int',
'ftp_nb_put' => 'false|int',
'ftp_nlist' => 'array|false',
'ftp_pasv' => 'bool',
'ftp_put' => 'bool',
'ftp_pwd' => 'false|string',
'ftp_quit' => 'bool',
'ftp_raw' => '?array',
'ftp_rawlist' => 'array|false',
'ftp_rename' => 'bool',
'ftp_rmdir' => 'bool',
'ftp_set_option' => 'bool',
'ftp_site' => 'bool',
'ftp_size' => 'int',
'ftp_ssl_connect' => '\FTP\Connection|false',
'ftp_systype' => 'false|string',
'ftruncate' => 'bool',
'func_get_arg' => 'mixed',
'func_get_args' => 'array',
'func_num_args' => 'int',
'function_exists' => 'bool',
'fwrite' => 'false|int',
'gc_collect_cycles' => 'int',
'gc_disable' => 'void',
'gc_enable' => 'void',
'gc_enabled' => 'bool',
'gc_mem_caches' => 'int',
'gc_status' => 'array',
'gd_info' => 'array',
'Generator::__debugInfo' => 'array',
'Generator::current' => 'mixed',
'Generator::getReturn' => 'mixed',
'Generator::key' => 'mixed',
'Generator::next' => 'void',
'Generator::rewind' => 'void',
'Generator::send' => 'mixed',
'Generator::throw' => 'mixed',
'Generator::valid' => 'bool',
'get_browser' => 'array|false|object',
'get_called_class' => 'string',
'get_cfg_var' => 'array|false|string',
'get_class' => 'string',
'get_class_methods' => 'array',
'get_class_vars' => 'array',
'get_current_user' => 'string',
'get_debug_type' => 'string',
'get_declared_classes' => 'array',
'get_declared_interfaces' => 'array',
'get_declared_traits' => 'array',
'get_defined_constants' => 'array',
'get_defined_functions' => 'array',
'get_defined_vars' => 'array',
'get_extension_funcs' => 'array|false',
'get_headers' => 'array|false',
'get_html_translation_table' => 'array',
'get_include_path' => 'false|string',
'get_included_files' => 'array',
'get_loaded_extensions' => 'array',
'get_mangled_object_vars' => 'array',
'get_meta_tags' => 'array|false',
'get_object_vars' => 'array',
'get_parent_class' => 'false|string',
'get_required_files' => 'array',
'get_resource_id' => 'int',
'get_resource_type' => 'string',
'get_resources' => 'array',
'getcwd' => 'false|string',
'getdate' => 'array',
'getenv' => 'array|false|string',
'gethostbyaddr' => 'false|string',
'gethostbyname' => 'string',
'gethostbynamel' => 'array|false',
'gethostname' => 'false|string',
'getimagesize' => 'array|false',
'getimagesizefromstring' => 'array|false',
'getlastmod' => 'false|int',
'getmxrr' => 'bool',
'getmygid' => 'false|int',
'getmyinode' => 'false|int',
'getmypid' => 'false|int',
'getmyuid' => 'false|int',
'getopt' => 'array|false',
'getprotobyname' => 'false|int',
'getprotobynumber' => 'false|string',
'getrandmax' => 'int',
'getrusage' => 'array|false',
'getservbyname' => 'false|int',
'getservbyport' => 'false|string',
'gettext' => 'string',
'gettimeofday' => 'array|float',
'gettype' => 'string',
'glob' => 'array|false',
'GlobIterator::__toString' => 'string',
'gmdate' => 'string',
'gmmktime' => 'false|int',
'GMP::__serialize' => 'array',
'GMP::__unserialize' => 'void',
'gmp_abs' => '\GMP',
'gmp_add' => '\GMP',
'gmp_and' => '\GMP',
'gmp_binomial' => '\GMP',
'gmp_clrbit' => 'void',
'gmp_cmp' => 'int',
'gmp_com' => '\GMP',
'gmp_div' => '\GMP',
'gmp_div_q' => '\GMP',
'gmp_div_qr' => 'array',
'gmp_div_r' => '\GMP',
'gmp_divexact' => '\GMP',
'gmp_export' => 'string',
'gmp_fact' => '\GMP',
'gmp_gcd' => '\GMP',
'gmp_gcdext' => 'array',
'gmp_hamdist' => 'int',
'gmp_import' => '\GMP',
'gmp_init' => '\GMP',
'gmp_intval' => 'int',
'gmp_invert' => '\GMP|false',
'gmp_jacobi' => 'int',
'gmp_kronecker' => 'int',
'gmp_lcm' => '\GMP',
'gmp_legendre' => 'int',
'gmp_mod' => '\GMP',
'gmp_mul' => '\GMP',
'gmp_neg' => '\GMP',
'gmp_nextprime' => '\GMP',
'gmp_or' => '\GMP',
'gmp_perfect_power' => 'bool',
'gmp_perfect_square' => 'bool',
'gmp_popcount' => 'int',
'gmp_pow' => '\GMP',
'gmp_powm' => '\GMP',
'gmp_prob_prime' => 'int',
'gmp_random_bits' => '\GMP',
'gmp_random_range' => '\GMP',
'gmp_random_seed' => 'void',
'gmp_root' => '\GMP',
'gmp_rootrem' => 'array',
'gmp_scan0' => 'int',
'gmp_scan1' => 'int',
'gmp_setbit' => 'void',
'gmp_sign' => 'int',
'gmp_sqrt' => '\GMP',
'gmp_sqrtrem' => 'array',
'gmp_strval' => 'string',
'gmp_sub' => '\GMP',
'gmp_testbit' => 'bool',
'gmp_xor' => '\GMP',
'gmstrftime' => 'false|string',
'grapheme_extract' => 'false|string',
'grapheme_str_split' => 'array|false',
'grapheme_stripos' => 'false|int',
'grapheme_stristr' => 'false|string',
'grapheme_strlen' => 'false|int|null',
'grapheme_strpos' => 'false|int',
'grapheme_strripos' => 'false|int',
'grapheme_strrpos' => 'false|int',
'grapheme_strstr' => 'false|string',
'grapheme_substr' => 'false|string',
'gregoriantojd' => 'int',
'gzclose' => 'bool',
'gzcompress' => 'false|string',
'gzdecode' => 'false|string',
'gzdeflate' => 'false|string',
'gzencode' => 'false|string',
'gzeof' => 'bool',
'gzfile' => 'array|false',
'gzgetc' => 'false|string',
'gzgets' => 'false|string',
'gzinflate' => 'false|string',
'gzpassthru' => 'int',
'gzputs' => 'false|int',
'gzread' => 'false|string',
'gzrewind' => 'bool',
'gzseek' => 'int',
'gztell' => 'false|int',
'gzuncompress' => 'false|string',
'gzwrite' => 'false|int',
'hash' => 'string',
'hash_algos' => 'array',
'hash_copy' => '\HashContext',
'hash_equals' => 'bool',
'hash_file' => 'false|string',
'hash_final' => 'string',
'hash_hkdf' => 'string',
'hash_hmac' => 'string',
'hash_hmac_algos' => 'array',
'hash_hmac_file' => 'false|string',
'hash_init' => '\HashContext',
'hash_pbkdf2' => 'string',
'hash_update' => 'true',
'hash_update_file' => 'bool',
'hash_update_stream' => 'int',
'HashContext::__debugInfo' => 'array',
'HashContext::__serialize' => 'array',
'HashContext::__unserialize' => 'void',
'header' => 'void',
'header_register_callback' => 'bool',
'header_remove' => 'void',
'headers_list' => 'array',
'headers_sent' => 'bool',
'hebrev' => 'string',
'hex2bin' => 'false|string',
'hexdec' => 'float|int',
'highlight_file' => 'bool|string',
'highlight_string' => 'string|true',
'hrtime' => 'array|false|float|int',
'html_entity_decode' => 'string',
'htmlentities' => 'string',
'htmlspecialchars' => 'string',
'htmlspecialchars_decode' => 'string',
'http_build_query' => 'string',
'http_clear_last_response_headers' => 'void',
'http_get_last_response_headers' => '?array',
'http_response_code' => 'bool|int',
'hypot' => 'float',
'iconv' => 'false|string',
'iconv_get_encoding' => 'array|false|string',
'iconv_mime_decode' => 'false|string',
'iconv_mime_decode_headers' => 'array|false',
'iconv_mime_encode' => 'false|string',
'iconv_set_encoding' => 'bool',
'iconv_strlen' => 'false|int',
'iconv_strpos' => 'false|int',
'iconv_strrpos' => 'false|int',
'iconv_substr' => 'false|string',
'idate' => 'false|int',
'idn_to_ascii' => 'false|string',
'idn_to_utf8' => 'false|string',
'ignore_user_abort' => 'int',
'image_type_to_extension' => 'false|string',
'image_type_to_mime_type' => 'string',
'imageaffine' => '\GdImage|false',
'imageaffinematrixconcat' => 'array|false',
'imageaffinematrixget' => 'array|false',
'imagealphablending' => 'bool',
'imageantialias' => 'bool',
'imagearc' => 'bool',
'imageavif' => 'bool',
'imagebmp' => 'bool',
'imagechar' => 'bool',
'imagecharup' => 'bool',
'imagecolorallocate' => 'false|int',
'imagecolorallocatealpha' => 'false|int',
'imagecolorat' => 'false|int',
'imagecolorclosest' => 'int',
'imagecolorclosestalpha' => 'int',
'imagecolorclosesthwb' => 'int',
'imagecolordeallocate' => 'bool',
'imagecolorexact' => 'int',
'imagecolorexactalpha' => 'int',
'imagecolormatch' => 'bool',
'imagecolorresolve' => 'int',
'imagecolorresolvealpha' => 'int',
'imagecolorset' => '?false',
'imagecolorsforindex' => 'array',
'imagecolorstotal' => 'int',
'imagecolortransparent' => 'int',
'imageconvolution' => 'bool',
'imagecopy' => 'bool',
'imagecopymerge' => 'bool',
'imagecopymergegray' => 'bool',
'imagecopyresampled' => 'bool',
'imagecopyresized' => 'bool',
'imagecreate' => '\GdImage|false',
'imagecreatefromavif' => '\GdImage|false',
'imagecreatefrombmp' => '\GdImage|false',
'imagecreatefromgd' => '\GdImage|false',
'imagecreatefromgd2' => '\GdImage|false',
'imagecreatefromgd2part' => '\GdImage|false',
'imagecreatefromgif' => '\GdImage|false',
'imagecreatefromjpeg' => '\GdImage|false',
'imagecreatefrompng' => '\GdImage|false',
'imagecreatefromstring' => '\GdImage|false',
'imagecreatefromtga' => '\GdImage|false',
'imagecreatefromwbmp' => '\GdImage|false',
'imagecreatefromwebp' => '\GdImage|false',
'imagecreatefromxbm' => '\GdImage|false',
'imagecreatefromxpm' => '\GdImage|false',
'imagecreatetruecolor' => '\GdImage|false',
'imagecrop' => '\GdImage|false',
'imagecropauto' => '\GdImage|false',
'imagedashedline' => 'bool',
'imagedestroy' => 'bool',
'imageellipse' => 'bool',
'imagefill' => 'bool',
'imagefilledarc' => 'bool',
'imagefilledellipse' => 'bool',
'imagefilledpolygon' => 'bool',
'imagefilledrectangle' => 'bool',
'imagefilltoborder' => 'bool',
'imagefilter' => 'bool',
'imageflip' => 'bool',
'imagefontheight' => 'int',
'imagefontwidth' => 'int',
'imageftbbox' => 'array|false',
'imagefttext' => 'array|false',
'imagegammacorrect' => 'bool',
'imagegd' => 'bool',
'imagegd2' => 'bool',
'imagegetclip' => 'array',
'imagegetinterpolation' => 'int',
'imagegif' => 'bool',
'imageinterlace' => 'bool',
'imageistruecolor' => 'bool',
'imagejpeg' => 'bool',
'imagelayereffect' => 'bool',
'imageline' => 'bool',
'imageloadfont' => '\GdFont|false',
'imageopenpolygon' => 'bool',
'imagepalettecopy' => 'void',
'imagepalettetotruecolor' => 'bool',
'imagepng' => 'bool',
'imagepolygon' => 'bool',
'imagerectangle' => 'bool',
'imageresolution' => 'array|bool',
'imagerotate' => '\GdImage|false',
'imagesavealpha' => 'bool',
'imagescale' => '\GdImage|false',
'imagesetbrush' => 'bool',
'imagesetclip' => 'bool',
'imagesetinterpolation' => 'bool',
'imagesetpixel' => 'bool',
'imagesetstyle' => 'bool',
'imagesetthickness' => 'bool',
'imagesettile' => 'bool',
'imagestring' => 'bool',
'imagestringup' => 'bool',
'imagesx' => 'int',
'imagesy' => 'int',
'imagetruecolortopalette' => 'bool',
'imagettfbbox' => 'array|false',
'imagettftext' => 'array|false',
'imagetypes' => 'int',
'imagewbmp' => 'bool',
'imagewebp' => 'bool',
'imagexbm' => 'bool',
'implode' => 'string',
'in_array' => 'bool',
'inet_ntop' => 'false|string',
'inet_pton' => 'false|string',
'inflate_add' => 'false|string',
'inflate_get_read_len' => 'int',
'inflate_get_status' => 'int',
'inflate_init' => '\InflateContext|false',
'ini_alter' => 'false|string',
'ini_get' => 'false|string',
'ini_get_all' => 'array|false',
'ini_parse_quantity' => 'int',
'ini_restore' => 'void',
'ini_set' => 'false|string',
'intdiv' => 'int',
'interface_exists' => 'bool',
'InternalIterator::current' => 'mixed',
'InternalIterator::key' => 'mixed',
'InternalIterator::next' => 'void',
'InternalIterator::rewind' => 'void',
'InternalIterator::valid' => 'bool',
'intl_error_name' => 'string',
'intl_get_error_code' => 'int',
'intl_get_error_message' => 'string',
'intl_is_failure' => 'bool',
'IntlBreakIterator::getIterator' => '\Iterator',
'intlcal_add' => 'bool',
'intlcal_after' => 'bool',
'intlcal_before' => 'bool',
'intlcal_clear' => 'true',
'intlcal_create_instance' => '?\IntlCalendar',
'intlcal_equals' => 'bool',
'intlcal_field_difference' => 'false|int',
'intlcal_from_date_time' => '?\IntlCalendar',
'intlcal_get' => 'false|int',
'intlcal_get_actual_maximum' => 'false|int',
'intlcal_get_actual_minimum' => 'false|int',
'intlcal_get_available_locales' => 'array',
'intlcal_get_day_of_week_type' => 'false|int',
'intlcal_get_error_code' => 'false|int',
'intlcal_get_error_message' => 'false|string',
'intlcal_get_first_day_of_week' => 'false|int',
'intlcal_get_greatest_minimum' => 'false|int',
'intlcal_get_keyword_values_for_locale' => '\IntlIterator|false',
'intlcal_get_least_maximum' => 'false|int',
'intlcal_get_locale' => 'false|string',
'intlcal_get_maximum' => 'false|int',
'intlcal_get_minimal_days_in_first_week' => 'false|int',
'intlcal_get_minimum' => 'false|int',
'intlcal_get_now' => 'float',
'intlcal_get_repeated_wall_time_option' => 'int',
'intlcal_get_skipped_wall_time_option' => 'int',
'intlcal_get_time' => 'false|float',
'intlcal_get_time_zone' => '\IntlTimeZone|false',
'intlcal_get_type' => 'string',
'intlcal_get_weekend_transition' => 'false|int',
'intlcal_in_daylight_time' => 'bool',
'intlcal_is_equivalent_to' => 'bool',
'intlcal_is_lenient' => 'bool',
'intlcal_is_set' => 'bool',
'intlcal_is_weekend' => 'bool',
'intlcal_roll' => 'bool',
'intlcal_set' => 'true',
'intlcal_set_first_day_of_week' => 'true',
'intlcal_set_lenient' => 'true',
'intlcal_set_minimal_days_in_first_week' => 'true',
'intlcal_set_repeated_wall_time_option' => 'true',
'intlcal_set_skipped_wall_time_option' => 'true',
'intlcal_set_time' => 'bool',
'intlcal_set_time_zone' => 'bool',
'intlcal_to_date_time' => '\DateTime|false',
'IntlCalendar::setDate' => 'void',
'IntlCalendar::setDateTime' => 'void',
'IntlCodePointBreakIterator::getIterator' => '\Iterator',
'IntlDateFormatter::parseToCalendar' => 'false|float|int',
'IntlDatePatternGenerator::create' => '?\IntlDatePatternGenerator',
'IntlDatePatternGenerator::getBestPattern' => 'false|string',
'IntlException::__toString' => 'string',
'IntlException::getFile' => 'string',
'IntlException::getLine' => 'int',
'IntlException::getMessage' => 'string',
'IntlException::getPrevious' => '?\Throwable',
'IntlException::getTrace' => 'array',
'IntlException::getTraceAsString' => 'string',
'intlgregcal_create_instance' => '?\IntlGregorianCalendar',
'intlgregcal_get_gregorian_change' => 'float',
'intlgregcal_is_leap_year' => 'bool',
'intlgregcal_set_gregorian_change' => 'bool',
'IntlGregorianCalendar::createFromDate' => 'static',
'IntlGregorianCalendar::createFromDateTime' => 'static',
'IntlGregorianCalendar::setDate' => 'void',
'IntlGregorianCalendar::setDateTime' => 'void',
'IntlRuleBasedBreakIterator::getIterator' => '\Iterator',
'IntlTimeZone::getIanaID' => 'false|string',
'intltz_count_equivalent_ids' => 'false|int',
'intltz_create_default' => '\IntlTimeZone',
'intltz_create_enumeration' => '\IntlIterator|false',
'intltz_create_time_zone' => '?\IntlTimeZone',
'intltz_create_time_zone_id_enumeration' => '\IntlIterator|false',
'intltz_from_date_time_zone' => '?\IntlTimeZone',
'intltz_get_canonical_id' => 'false|string',
'intltz_get_display_name' => 'false|string',
'intltz_get_dst_savings' => 'int',
'intltz_get_equivalent_id' => 'false|string',
'intltz_get_error_code' => 'false|int',
'intltz_get_error_message' => 'false|string',
'intltz_get_gmt' => '\IntlTimeZone',
'intltz_get_iana_id' => 'false|string',
'intltz_get_id' => 'false|string',
'intltz_get_id_for_windows_id' => 'false|string',
'intltz_get_offset' => 'bool',
'intltz_get_raw_offset' => 'int',
'intltz_get_region' => 'false|string',
'intltz_get_tz_data_version' => 'false|string',
'intltz_get_unknown' => '\IntlTimeZone',
'intltz_get_windows_id' => 'false|string',
'intltz_has_same_rules' => 'bool',
'intltz_to_date_time_zone' => '\DateTimeZone|false',
'intltz_use_daylight_time' => 'bool',
'intval' => 'int',
'InvalidArgumentException::__toString' => 'string',
'InvalidArgumentException::getFile' => 'string',
'InvalidArgumentException::getLine' => 'int',
'InvalidArgumentException::getMessage' => 'string',
'InvalidArgumentException::getPrevious' => '?\Throwable',
'InvalidArgumentException::getTrace' => 'array',
'InvalidArgumentException::getTraceAsString' => 'string',
'ip2long' => 'false|int',
'iptcembed' => 'bool|string',
'iptcparse' => 'array|false',
'is_a' => 'bool',
'is_array' => 'bool',
'is_bool' => 'bool',
'is_callable' => 'bool',
'is_countable' => 'bool',
'is_dir' => 'bool',
'is_double' => 'bool',
'is_executable' => 'bool',
'is_file' => 'bool',
'is_finite' => 'bool',
'is_float' => 'bool',
'is_infinite' => 'bool',
'is_int' => 'bool',
'is_integer' => 'bool',
'is_iterable' => 'bool',
'is_link' => 'bool',
'is_long' => 'bool',
'is_nan' => 'bool',
'is_null' => 'bool',
'is_numeric' => 'bool',
'is_object' => 'bool',
'is_readable' => 'bool',
'is_resource' => 'bool',
'is_scalar' => 'bool',
'is_soap_fault' => 'bool',
'is_string' => 'bool',
'is_subclass_of' => 'bool',
'is_uploaded_file' => 'bool',
'is_writable' => 'bool',
'is_writeable' => 'bool',
'iterator_apply' => 'int',
'iterator_count' => 'int',
'iterator_to_array' => 'array',
'jddayofweek' => 'int|string',
'jdmonthname' => 'string',
'jdtofrench' => 'string',
'jdtogregorian' => 'string',
'jdtojewish' => 'string',
'jdtojulian' => 'string',
'jdtounix' => 'int',
'jewishtojd' => 'int',
'join' => 'string',
'json_decode' => 'mixed',
'json_encode' => 'false|string',
'json_last_error' => 'int',
'json_last_error_msg' => 'string',
'json_validate' => 'bool',
'JsonException::__toString' => 'string',
'JsonException::getFile' => 'string',
'JsonException::getLine' => 'int',
'JsonException::getMessage' => 'string',
'JsonException::getPrevious' => '?\Throwable',
'JsonException::getTrace' => 'array',
'JsonException::getTraceAsString' => 'string',
'juliantojd' => 'int',
'key' => 'int|null|string',
'key_exists' => 'bool',
'krsort' => 'true',
'ksort' => 'true',
'lcfirst' => 'string',
'lcg_value' => 'float',
'lchgrp' => 'bool',
'lchown' => 'bool',
'LengthException::__toString' => 'string',
'LengthException::getFile' => 'string',
'LengthException::getLine' => 'int',
'LengthException::getMessage' => 'string',
'LengthException::getPrevious' => '?\Throwable',
'LengthException::getTrace' => 'array',
'LengthException::getTraceAsString' => 'string',
'levenshtein' => 'int',
'libxml_clear_errors' => 'void',
'libxml_disable_entity_loader' => 'bool',
'libxml_get_errors' => 'array',
'libxml_get_external_entity_loader' => '?callable',
'libxml_get_last_error' => '\LibXMLError|false',
'libxml_set_external_entity_loader' => 'bool',
'libxml_set_streams_context' => 'void',
'libxml_use_internal_errors' => 'bool',
'link' => 'bool',
'linkinfo' => 'false|int',
'locale_accept_from_http' => 'false|string',
'locale_canonicalize' => '?string',
'locale_compose' => 'false|string',
'locale_filter_matches' => '?bool',
'locale_get_all_variants' => '?array',
'locale_get_default' => 'string',
'locale_get_display_language' => 'false|string',
'locale_get_display_name' => 'false|string',
'locale_get_display_region' => 'false|string',
'locale_get_display_script' => 'false|string',
'locale_get_display_variant' => 'false|string',
'locale_get_keywords' => 'array|false|null',
'locale_get_primary_language' => '?string',
'locale_get_region' => '?string',
'locale_get_script' => '?string',
'locale_lookup' => '?string',
'locale_parse' => '?array',
'locale_set_default' => 'true',
'localeconv' => 'array',
'localtime' => 'array',
'log' => 'float',
'log10' => 'float',
'log1p' => 'float',
'LogicException::__toString' => 'string',
'LogicException::getFile' => 'string',
'LogicException::getLine' => 'int',
'LogicException::getMessage' => 'string',
'LogicException::getPrevious' => '?\Throwable',
'LogicException::getTrace' => 'array',
'LogicException::getTraceAsString' => 'string',
'long2ip' => 'string',
'lstat' => 'array|false',
'ltrim' => 'string',
'mail' => 'bool',
'max' => 'mixed',
'mb_check_encoding' => 'bool',
'mb_chr' => 'false|string',
'mb_convert_case' => 'string',
'mb_convert_encoding' => 'array|false|string',
'mb_convert_kana' => 'string',
'mb_convert_variables' => 'false|string',
'mb_decode_mimeheader' => 'string',
'mb_decode_numericentity' => 'string',
'mb_detect_encoding' => 'false|string',
'mb_detect_order' => 'array|bool',
'mb_encode_mimeheader' => 'string',
'mb_encode_numericentity' => 'string',
'mb_encoding_aliases' => 'array',
'mb_ereg' => 'bool',
'mb_ereg_match' => 'bool',
'mb_ereg_replace' => 'false|null|string',
'mb_ereg_replace_callback' => 'false|null|string',
'mb_ereg_search' => 'bool',
'mb_ereg_search_getpos' => 'int',
'mb_ereg_search_getregs' => 'array|false',
'mb_ereg_search_init' => 'bool',
'mb_ereg_search_pos' => 'array|false',
'mb_ereg_search_regs' => 'array|false',
'mb_ereg_search_setpos' => 'bool',
'mb_eregi' => 'bool',
'mb_eregi_replace' => 'false|null|string',
'mb_get_info' => 'array|false|int|null|string',
'mb_http_input' => 'array|false|string',
'mb_http_output' => 'bool|string',
'mb_internal_encoding' => 'bool|string',
'mb_language' => 'bool|string',
'mb_lcfirst' => 'string',
'mb_list_encodings' => 'array',
'mb_ltrim' => 'string',
'mb_ord' => 'false|int',
'mb_output_handler' => 'string',
'mb_parse_str' => 'bool',
'mb_preferred_mime_name' => 'false|string',
'mb_regex_encoding' => 'bool|string',
'mb_regex_set_options' => 'string',
'mb_rtrim' => 'string',
'mb_scrub' => 'string',
'mb_send_mail' => 'bool',
'mb_split' => 'array|false',
'mb_str_pad' => 'string',
'mb_str_split' => 'array',
'mb_strcut' => 'string',
'mb_strimwidth' => 'string',
'mb_stripos' => 'false|int',
'mb_stristr' => 'false|string',
'mb_strlen' => 'int',
'mb_strpos' => 'false|int',
'mb_strrchr' => 'false|string',
'mb_strrichr' => 'false|string',
'mb_strripos' => 'false|int',
'mb_strrpos' => 'false|int',
'mb_strstr' => 'false|string',
'mb_strtolower' => 'string',
'mb_strtoupper' => 'string',
'mb_strwidth' => 'int',
'mb_substitute_character' => 'bool|int|string',
'mb_substr' => 'string',
'mb_substr_count' => 'int',
'mb_trim' => 'string',
'mb_ucfirst' => 'string',
'md5' => 'string',
'md5_file' => 'false|string',
'Memcached::add' => 'bool',
'Memcached::addByKey' => 'bool',
'Memcached::addServer' => 'bool',
'Memcached::addServers' => 'bool',
'Memcached::append' => '?bool',
'Memcached::appendByKey' => '?bool',
'Memcached::cas' => 'bool',
'Memcached::casByKey' => 'bool',
'Memcached::checkKey' => 'bool',
'Memcached::decrement' => 'false|int',
'Memcached::decrementByKey' => 'false|int',
'Memcached::delete' => 'bool',
'Memcached::deleteByKey' => 'bool',
'Memcached::deleteMulti' => 'array',
'Memcached::deleteMultiByKey' => 'array',
'Memcached::fetch' => 'array|false',
'Memcached::fetchAll' => 'array|false',
'Memcached::flush' => 'bool',
'Memcached::flushBuffers' => 'bool',
'Memcached::get' => 'mixed',
'Memcached::getAllKeys' => 'array|false',
'Memcached::getByKey' => 'mixed',
'Memcached::getDelayed' => 'bool',
'Memcached::getDelayedByKey' => 'bool',
'Memcached::getLastDisconnectedServer' => 'array|false',
'Memcached::getLastErrorCode' => 'int',
'Memcached::getLastErrorErrno' => 'int',
'Memcached::getLastErrorMessage' => 'string',
'Memcached::getMulti' => 'array|false',
'Memcached::getMultiByKey' => 'array|false',
'Memcached::getOption' => 'mixed',
'Memcached::getResultCode' => 'int',
'Memcached::getResultMessage' => 'string',
'Memcached::getServerByKey' => 'array|false',
'Memcached::getServerList' => 'array',
'Memcached::getStats' => 'array|false',
'Memcached::getVersion' => 'array|false',
'Memcached::increment' => 'false|int',
'Memcached::incrementByKey' => 'false|int',
'Memcached::isPersistent' => 'bool',
'Memcached::isPristine' => 'bool',
'Memcached::prepend' => '?bool',
'Memcached::prependByKey' => '?bool',
'Memcached::quit' => 'bool',
'Memcached::replace' => 'bool',
'Memcached::replaceByKey' => 'bool',
'Memcached::resetServerList' => 'bool',
'Memcached::set' => 'bool',
'Memcached::setBucket' => 'bool',
'Memcached::setByKey' => 'bool',
'Memcached::setEncodingKey' => 'bool',
'Memcached::setMulti' => 'bool',
'Memcached::setMultiByKey' => 'bool',
'Memcached::setOption' => 'bool',
'Memcached::setOptions' => 'bool',
'Memcached::setSaslAuthData' => 'bool',
'Memcached::touch' => 'bool',
'Memcached::touchByKey' => 'bool',
'MemcachedException::__toString' => 'string',
'MemcachedException::getFile' => 'string',
'MemcachedException::getLine' => 'int',
'MemcachedException::getMessage' => 'string',
'MemcachedException::getPrevious' => '?\Throwable',
'MemcachedException::getTrace' => 'array',
'MemcachedException::getTraceAsString' => 'string',
'memory_get_peak_usage' => 'int',
'memory_get_usage' => 'int',
'memory_reset_peak_usage' => 'void',
'metaphone' => 'string',
'method_exists' => 'bool',
'mhash' => 'false|string',
'mhash_count' => 'int',
'mhash_get_block_size' => 'false|int',
'mhash_get_hash_name' => 'false|string',
'mhash_keygen_s2k' => 'false|string',
'microtime' => 'float|string',
'mime_content_type' => 'false|string',
'min' => 'mixed',
'mkdir' => 'bool',
'mktime' => 'false|int',
'move_uploaded_file' => 'bool',
'msg_get_queue' => '\SysvMessageQueue|false',
'msg_queue_exists' => 'bool',
'msg_receive' => 'bool',
'msg_remove_queue' => 'bool',
'msg_send' => 'bool',
'msg_set_queue' => 'bool',
'msg_stat_queue' => 'array|false',
'msgfmt_create' => '?\MessageFormatter',
'msgfmt_format' => 'false|string',
'msgfmt_format_message' => 'false|string',
'msgfmt_get_error_code' => 'int',
'msgfmt_get_error_message' => 'string',
'msgfmt_get_locale' => 'string',
'msgfmt_get_pattern' => 'false|string',
'msgfmt_parse' => 'array|false',
'msgfmt_parse_message' => 'array|false',
'msgfmt_set_pattern' => 'bool',
'mt_getrandmax' => 'int',
'mt_rand' => 'int',
'mt_srand' => 'void',
'mysqli::execute_query' => '\mysqli_result|bool',
'mysqli_affected_rows' => 'int|string',
'mysqli_autocommit' => 'bool',
'mysqli_begin_transaction' => 'bool',
'mysqli_change_user' => 'bool',
'mysqli_character_set_name' => 'string',
'mysqli_close' => 'true',
'mysqli_commit' => 'bool',
'mysqli_connect' => '\mysqli|false',
'mysqli_connect_errno' => 'int',
'mysqli_connect_error' => '?string',
'mysqli_data_seek' => 'bool',
'mysqli_debug' => 'true',
'mysqli_dump_debug_info' => 'bool',
'mysqli_errno' => 'int',
'mysqli_error' => 'string',
'mysqli_error_list' => 'array',
'mysqli_escape_string' => 'string',
'mysqli_execute' => 'bool',
'mysqli_execute_query' => '\mysqli_result|bool',
'mysqli_fetch_all' => 'array',
'mysqli_fetch_array' => 'array|false|null',
'mysqli_fetch_assoc' => 'array|false|null',
'mysqli_fetch_column' => 'false|float|int|null|string',
'mysqli_fetch_field' => 'false|object',
'mysqli_fetch_field_direct' => 'false|object',
'mysqli_fetch_fields' => 'array',
'mysqli_fetch_lengths' => 'array|false',
'mysqli_fetch_object' => 'false|null|object',
'mysqli_fetch_row' => 'array|false|null',
'mysqli_field_count' => 'int',
'mysqli_field_seek' => 'true',
'mysqli_field_tell' => 'int',
'mysqli_free_result' => 'void',
'mysqli_get_charset' => '?object',
'mysqli_get_client_info' => 'string',
'mysqli_get_client_stats' => 'array',
'mysqli_get_client_version' => 'int',
'mysqli_get_connection_stats' => 'array',
'mysqli_get_host_info' => 'string',
'mysqli_get_links_stats' => 'array',
'mysqli_get_proto_info' => 'int',
'mysqli_get_server_info' => 'string',
'mysqli_get_server_version' => 'int',
'mysqli_get_warnings' => '\mysqli_warning|false',
'mysqli_info' => '?string',
'mysqli_init' => '\mysqli|false',
'mysqli_insert_id' => 'int|string',
'mysqli_kill' => 'bool',
'mysqli_more_results' => 'bool',
'mysqli_multi_query' => 'bool',
'mysqli_next_result' => 'bool',
'mysqli_num_fields' => 'int',
'mysqli_num_rows' => 'int|string',
'mysqli_options' => 'bool',
'mysqli_ping' => 'bool',
'mysqli_poll' => 'false|int',
'mysqli_prepare' => '\mysqli_stmt|false',
'mysqli_query' => '\mysqli_result|bool',
'mysqli_real_connect' => 'bool',
'mysqli_real_escape_string' => 'string',
'mysqli_real_query' => 'bool',
'mysqli_reap_async_query' => '\mysqli_result|bool',
'mysqli_refresh' => 'bool',
'mysqli_release_savepoint' => 'bool',
'mysqli_report' => 'true',
'mysqli_result::fetch_column' => 'false|float|int|null|string',
'mysqli_result::getIterator' => '\Iterator',
'mysqli_rollback' => 'bool',
'mysqli_savepoint' => 'bool',
'mysqli_select_db' => 'bool',
'mysqli_set_charset' => 'bool',
'mysqli_set_opt' => 'bool',
'mysqli_sql_exception::__toString' => 'string',
'mysqli_sql_exception::getFile' => 'string',
'mysqli_sql_exception::getLine' => 'int',
'mysqli_sql_exception::getMessage' => 'string',
'mysqli_sql_exception::getPrevious' => '?\Throwable',
'mysqli_sql_exception::getSqlState' => 'string',
'mysqli_sql_exception::getTrace' => 'array',
'mysqli_sql_exception::getTraceAsString' => 'string',
'mysqli_sqlstate' => 'string',
'mysqli_ssl_set' => 'true',
'mysqli_stat' => 'false|string',
'mysqli_stmt_affected_rows' => 'int|string',
'mysqli_stmt_attr_get' => 'int',
'mysqli_stmt_attr_set' => 'bool',
'mysqli_stmt_bind_param' => 'bool',
'mysqli_stmt_bind_result' => 'bool',
'mysqli_stmt_close' => 'true',
'mysqli_stmt_data_seek' => 'void',
'mysqli_stmt_errno' => 'int',
'mysqli_stmt_error' => 'string',
'mysqli_stmt_error_list' => 'array',
'mysqli_stmt_execute' => 'bool',
'mysqli_stmt_fetch' => '?bool',
'mysqli_stmt_field_count' => 'int',
'mysqli_stmt_free_result' => 'void',
'mysqli_stmt_get_result' => '\mysqli_result|false',
'mysqli_stmt_get_warnings' => '\mysqli_warning|false',
'mysqli_stmt_init' => '\mysqli_stmt|false',
'mysqli_stmt_insert_id' => 'int|string',
'mysqli_stmt_more_results' => 'bool',
'mysqli_stmt_next_result' => 'bool',
'mysqli_stmt_num_rows' => 'int|string',
'mysqli_stmt_param_count' => 'int',
'mysqli_stmt_prepare' => 'bool',
'mysqli_stmt_reset' => 'bool',
'mysqli_stmt_result_metadata' => '\mysqli_result|false',
'mysqli_stmt_send_long_data' => 'bool',
'mysqli_stmt_sqlstate' => 'string',
'mysqli_stmt_store_result' => 'bool',
'mysqli_store_result' => '\mysqli_result|false',
'mysqli_thread_id' => 'int',
'mysqli_thread_safe' => 'bool',
'mysqli_use_result' => '\mysqli_result|false',
'mysqli_warning::next' => 'bool',
'mysqli_warning_count' => 'int',
'natcasesort' => 'true',
'natsort' => 'true',
'net_get_interfaces' => 'array|false',
'next' => 'mixed',
'ngettext' => 'string',
'nl2br' => 'string',
'nl_langinfo' => 'false|string',
'normalizer_get_raw_decomposition' => '?string',
'normalizer_is_normalized' => 'bool',
'normalizer_normalize' => 'false|string',
'number_format' => 'string',
'numfmt_create' => '?\NumberFormatter',
'numfmt_format' => 'false|string',
'numfmt_format_currency' => 'false|string',
'numfmt_get_attribute' => 'false|float|int',
'numfmt_get_error_code' => 'int',
'numfmt_get_error_message' => 'string',
'numfmt_get_locale' => 'false|string',
'numfmt_get_pattern' => 'false|string',
'numfmt_get_symbol' => 'false|string',
'numfmt_get_text_attribute' => 'false|string',
'numfmt_parse' => 'false|float|int',
'numfmt_parse_currency' => 'false|float',
'numfmt_set_attribute' => 'bool',
'numfmt_set_pattern' => 'bool',
'numfmt_set_symbol' => 'bool',
'numfmt_set_text_attribute' => 'bool',
'OAuthException::__toString' => 'string',
'OAuthException::getFile' => 'string',
'OAuthException::getLine' => 'int',
'OAuthException::getMessage' => 'string',
'OAuthException::getPrevious' => '?\Throwable',
'OAuthException::getTrace' => 'array',
'OAuthException::getTraceAsString' => 'string',
'ob_clean' => 'bool',
'ob_end_clean' => 'bool',
'ob_end_flush' => 'bool',
'ob_flush' => 'bool',
'ob_get_clean' => 'false|string',
'ob_get_contents' => 'false|string',
'ob_get_flush' => 'false|string',
'ob_get_length' => 'false|int',
'ob_get_level' => 'int',
'ob_get_status' => 'array',
'ob_gzhandler' => 'false|string',
'ob_implicit_flush' => 'void',
'ob_list_handlers' => 'array',
'ob_start' => 'bool',
'octdec' => 'float|int',
'opcache_compile_file' => 'bool',
'opcache_get_configuration' => 'array|false',
'opcache_get_status' => 'array|false',
'opcache_invalidate' => 'bool',
'opcache_is_script_cached' => 'bool',
'opcache_jit_blacklist' => 'void',
'opcache_reset' => 'bool',
'openlog' => 'true',
'openssl_cipher_iv_length' => 'false|int',
'openssl_cipher_key_length' => 'false|int',
'openssl_cms_decrypt' => 'bool',
'openssl_cms_encrypt' => 'bool',
'openssl_cms_read' => 'bool',
'openssl_cms_sign' => 'bool',
'openssl_cms_verify' => 'bool',
'openssl_csr_export' => 'bool',
'openssl_csr_export_to_file' => 'bool',
'openssl_csr_get_public_key' => '\OpenSSLAsymmetricKey|false',
'openssl_csr_get_subject' => 'array|false',
'openssl_csr_new' => '\OpenSSLCertificateSigningRequest|bool',
'openssl_csr_sign' => '\OpenSSLCertificate|false',
'openssl_decrypt' => 'false|string',
'openssl_dh_compute_key' => 'false|string',
'openssl_digest' => 'false|string',
'openssl_encrypt' => 'false|string',
'openssl_error_string' => 'false|string',
'openssl_free_key' => 'void',
'openssl_get_cert_locations' => 'array',
'openssl_get_cipher_methods' => 'array',
'openssl_get_curve_names' => 'array|false',
'openssl_get_md_methods' => 'array',
'openssl_get_privatekey' => '\OpenSSLAsymmetricKey|false',
'openssl_get_publickey' => '\OpenSSLAsymmetricKey|false',
'openssl_open' => 'bool',
'openssl_pbkdf2' => 'false|string',
'openssl_pkcs12_export' => 'bool',
'openssl_pkcs12_export_to_file' => 'bool',
'openssl_pkcs12_read' => 'bool',
'openssl_pkcs7_decrypt' => 'bool',
'openssl_pkcs7_encrypt' => 'bool',
'openssl_pkcs7_read' => 'bool',
'openssl_pkcs7_sign' => 'bool',
'openssl_pkcs7_verify' => 'bool|int',
'openssl_pkey_derive' => 'false|string',
'openssl_pkey_export' => 'bool',
'openssl_pkey_export_to_file' => 'bool',
'openssl_pkey_free' => 'void',
'openssl_pkey_get_details' => 'array|false',
'openssl_pkey_get_private' => '\OpenSSLAsymmetricKey|false',
'openssl_pkey_get_public' => '\OpenSSLAsymmetricKey|false',
'openssl_pkey_new' => '\OpenSSLAsymmetricKey|false',
'openssl_private_decrypt' => 'bool',
'openssl_private_encrypt' => 'bool',
'openssl_public_decrypt' => 'bool',
'openssl_public_encrypt' => 'bool',
'openssl_random_pseudo_bytes' => 'string',
'openssl_seal' => 'false|int',
'openssl_sign' => 'bool',
'openssl_spki_export' => 'false|string',
'openssl_spki_export_challenge' => 'false|string',
'openssl_spki_new' => 'false|string',
'openssl_spki_verify' => 'bool',
'openssl_verify' => 'false|int',
'openssl_x509_check_private_key' => 'bool',
'openssl_x509_checkpurpose' => 'bool|int',
'openssl_x509_export' => 'bool',
'openssl_x509_export_to_file' => 'bool',
'openssl_x509_fingerprint' => 'false|string',
'openssl_x509_free' => 'void',
'openssl_x509_parse' => 'array|false',
'openssl_x509_read' => '\OpenSSLCertificate|false',
'openssl_x509_verify' => 'int',
'ord' => 'int',
'OutOfBoundsException::__toString' => 'string',
'OutOfBoundsException::getFile' => 'string',
'OutOfBoundsException::getLine' => 'int',
'OutOfBoundsException::getMessage' => 'string',
'OutOfBoundsException::getPrevious' => '?\Throwable',
'OutOfBoundsException::getTrace' => 'array',
'OutOfBoundsException::getTraceAsString' => 'string',
'OutOfRangeException::__toString' => 'string',
'OutOfRangeException::getFile' => 'string',
'OutOfRangeException::getLine' => 'int',
'OutOfRangeException::getMessage' => 'string',
'OutOfRangeException::getPrevious' => '?\Throwable',
'OutOfRangeException::getTrace' => 'array',
'OutOfRangeException::getTraceAsString' => 'string',
'output_add_rewrite_var' => 'bool',
'output_reset_rewrite_vars' => 'bool',
'OverflowException::__toString' => 'string',
'OverflowException::getFile' => 'string',
'OverflowException::getLine' => 'int',
'OverflowException::getMessage' => 'string',
'OverflowException::getPrevious' => '?\Throwable',
'OverflowException::getTrace' => 'array',
'OverflowException::getTraceAsString' => 'string',
'pack' => 'string',
'parse_ini_file' => 'array|false',
'parse_ini_string' => 'array|false',
'parse_str' => 'void',
'parse_url' => 'array|false|int|null|string',
'ParseError::__toString' => 'string',
'ParseError::getFile' => 'string',
'ParseError::getLine' => 'int',
'ParseError::getMessage' => 'string',
'ParseError::getPrevious' => '?\Throwable',
'ParseError::getTrace' => 'array',
'ParseError::getTraceAsString' => 'string',
'passthru' => '?false',
'password_algos' => 'array',
'password_get_info' => 'array',
'password_hash' => 'string',
'password_needs_rehash' => 'bool',
'password_verify' => 'bool',
'pathinfo' => 'array|string',
'pclose' => 'int',
'Pcntl\QosClass::cases' => 'array',
'pcntl_alarm' => 'int',
'pcntl_async_signals' => 'bool',
'pcntl_errno' => 'int',
'pcntl_exec' => 'bool',
'pcntl_fork' => 'int',
'pcntl_get_last_error' => 'int',
'pcntl_getcpu' => 'int',
'pcntl_getcpuaffinity' => 'array|false',
'pcntl_getpriority' => 'false|int',
'pcntl_setcpuaffinity' => 'bool',
'pcntl_setns' => 'bool',
'pcntl_setpriority' => 'bool',
'pcntl_signal' => 'bool',
'pcntl_signal_dispatch' => 'bool',
'pcntl_sigprocmask' => 'bool',
'pcntl_sigtimedwait' => 'false|int',
'pcntl_sigwaitinfo' => 'false|int',
'pcntl_strerror' => 'string',
'pcntl_unshare' => 'bool',
'pcntl_wait' => 'int',
'pcntl_waitid' => 'bool',
'pcntl_waitpid' => 'int',
'pcntl_wexitstatus' => 'false|int',
'pcntl_wifcontinued' => 'bool',
'pcntl_wifexited' => 'bool',
'pcntl_wifsignaled' => 'bool',
'pcntl_wifstopped' => 'bool',
'pcntl_wstopsig' => 'false|int',
'pcntl_wtermsig' => 'false|int',
'PDO::connect' => 'static',
'Pdo\Mysql::connect' => 'static',
'Pdo\Mysql::getWarningCount' => 'int',
'Pdo\Pgsql::connect' => 'static',
'Pdo\Pgsql::copyFromArray' => 'bool',
'Pdo\Pgsql::copyFromFile' => 'bool',
'Pdo\Pgsql::copyToArray' => 'array|false',
'Pdo\Pgsql::copyToFile' => 'bool',
'Pdo\Pgsql::escapeIdentifier' => 'string',
'Pdo\Pgsql::getNotify' => 'array|false',
'Pdo\Pgsql::getPid' => 'int',
'Pdo\Pgsql::lobCreate' => 'false|string',
'Pdo\Pgsql::lobUnlink' => 'bool',
'Pdo\Pgsql::setNoticeCallback' => 'void',
'pdo_drivers' => 'array',
'PDOException::__toString' => 'string',
'PDOException::getFile' => 'string',
'PDOException::getLine' => 'int',
'PDOException::getMessage' => 'string',
'PDOException::getPrevious' => '?\Throwable',
'PDOException::getTrace' => 'array',
'PDOException::getTraceAsString' => 'string',
'PDOStatement::getIterator' => '\Iterator',
'pg_affected_rows' => 'int',
'pg_cancel_query' => 'bool',
'pg_change_password' => 'bool',
'pg_client_encoding' => 'string',
'pg_clientencoding' => 'string',
'pg_close' => 'true',
'pg_cmdtuples' => 'int',
'pg_connect' => '\PgSql\Connection|false',
'pg_connect_poll' => 'int',
'pg_connection_busy' => 'bool',
'pg_connection_reset' => 'bool',
'pg_connection_status' => 'int',
'pg_consume_input' => 'bool',
'pg_convert' => 'array|false',
'pg_copy_from' => 'bool',
'pg_copy_to' => 'array|false',
'pg_dbname' => 'string',
'pg_delete' => 'bool|string',
'pg_end_copy' => 'bool',
'pg_errormessage' => 'string',
'pg_escape_bytea' => 'string',
'pg_escape_identifier' => 'false|string',
'pg_escape_literal' => 'false|string',
'pg_escape_string' => 'string',
'pg_exec' => '\PgSql\Result|false',
'pg_execute' => '\PgSql\Result|false',
'pg_fetch_all' => 'array',
'pg_fetch_all_columns' => 'array',
'pg_fetch_array' => 'array|false',
'pg_fetch_assoc' => 'array|false',
'pg_fetch_object' => 'false|object',
'pg_fetch_result' => 'false|null|string',
'pg_fetch_row' => 'array|false',
'pg_field_is_null' => 'false|int',
'pg_field_name' => 'string',
'pg_field_num' => 'int',
'pg_field_prtlen' => 'false|int',
'pg_field_size' => 'int',
'pg_field_table' => 'false|int|string',
'pg_field_type' => 'string',
'pg_field_type_oid' => 'int|string',
'pg_fieldisnull' => 'false|int',
'pg_fieldname' => 'string',
'pg_fieldnum' => 'int',
'pg_fieldprtlen' => 'false|int',
'pg_fieldsize' => 'int',
'pg_fieldtype' => 'string',
'pg_flush' => 'bool|int',
'pg_free_result' => 'bool',
'pg_freeresult' => 'bool',
'pg_get_notify' => 'array|false',
'pg_get_pid' => 'int',
'pg_get_result' => '\PgSql\Result|false',
'pg_getlastoid' => 'false|int|string',
'pg_host' => 'string',
'pg_insert' => '\PgSql\Result|bool|string',
'pg_jit' => 'array',
'pg_last_error' => 'string',
'pg_last_notice' => 'array|bool|string',
'pg_last_oid' => 'false|int|string',
'pg_lo_close' => 'bool',
'pg_lo_create' => 'false|int|string',
'pg_lo_export' => 'bool',
'pg_lo_import' => 'false|int|string',
'pg_lo_open' => '\PgSql\Lob|false',
'pg_lo_read' => 'false|string',
'pg_lo_read_all' => 'int',
'pg_lo_seek' => 'bool',
'pg_lo_tell' => 'int',
'pg_lo_truncate' => 'bool',
'pg_lo_unlink' => 'bool',
'pg_lo_write' => 'false|int',
'pg_loclose' => 'bool',
'pg_locreate' => 'false|int|string',
'pg_loexport' => 'bool',
'pg_loimport' => 'false|int|string',
'pg_loopen' => '\PgSql\Lob|false',
'pg_loread' => 'false|string',
'pg_loreadall' => 'int',
'pg_lounlink' => 'bool',
'pg_lowrite' => 'false|int',
'pg_meta_data' => 'array|false',
'pg_num_fields' => 'int',
'pg_num_rows' => 'int',
'pg_numfields' => 'int',
'pg_numrows' => 'int',
'pg_options' => 'string',
'pg_parameter_status' => 'false|string',
'pg_pconnect' => '\PgSql\Connection|false',
'pg_ping' => 'bool',
'pg_port' => 'string',
'pg_prepare' => '\PgSql\Result|false',
'pg_put_copy_data' => 'int',
'pg_put_copy_end' => 'int',
'pg_put_line' => 'bool',
'pg_query' => '\PgSql\Result|false',
'pg_query_params' => '\PgSql\Result|false',
'pg_result' => 'false|null|string',
'pg_result_error' => 'false|string',
'pg_result_error_field' => 'false|null|string',
'pg_result_memory_size' => 'int',
'pg_result_seek' => 'bool',
'pg_result_status' => 'int|string',
'pg_select' => 'array|false|string',
'pg_send_execute' => 'bool|int',
'pg_send_prepare' => 'bool|int',
'pg_send_query' => 'bool|int',
'pg_send_query_params' => 'bool|int',
'pg_set_client_encoding' => 'int',
'pg_set_error_context_visibility' => 'int',
'pg_set_error_verbosity' => 'false|int',
'pg_setclientencoding' => 'int',
'pg_socket_poll' => 'int',
'pg_trace' => 'bool',
'pg_transaction_status' => 'int',
'pg_tty' => 'string',
'pg_unescape_bytea' => 'string',
'pg_untrace' => 'true',
'pg_update' => 'bool|string',
'pg_version' => 'array',
'Phar::__toString' => 'string',
'Phar::apiVersion' => 'string',
'Phar::canCompress' => 'bool',
'Phar::canWrite' => 'bool',
'Phar::createDefaultStub' => 'string',
'Phar::getSupportedCompression' => 'array',
'Phar::getSupportedSignatures' => 'array',
'Phar::interceptFileFuncs' => 'void',
'Phar::isValidPharFilename' => 'bool',
'Phar::loadPhar' => 'bool',
'Phar::mapPhar' => 'bool',
'Phar::mount' => 'void',
'Phar::mungServer' => 'void',
'Phar::running' => 'string',
'Phar::unlinkArchive' => 'true',
'Phar::webPhar' => 'void',
'PharData::__toString' => 'string',
'PharData::apiVersion' => 'string',
'PharData::canCompress' => 'bool',
'PharData::canWrite' => 'bool',
'PharData::createDefaultStub' => 'string',
'PharData::getSupportedCompression' => 'array',
'PharData::getSupportedSignatures' => 'array',
'PharData::interceptFileFuncs' => 'void',
'PharData::isValidPharFilename' => 'bool',
'PharData::loadPhar' => 'bool',
'PharData::mapPhar' => 'bool',
'PharData::mount' => 'void',
'PharData::mungServer' => 'void',
'PharData::running' => 'string',
'PharData::setStub' => 'true',
'PharData::unlinkArchive' => 'true',
'PharData::webPhar' => 'void',
'PharException::__toString' => 'string',
'PharException::getFile' => 'string',
'PharException::getLine' => 'int',
'PharException::getMessage' => 'string',
'PharException::getPrevious' => '?\Throwable',
'PharException::getTrace' => 'array',
'PharException::getTraceAsString' => 'string',
'PharFileInfo::__toString' => 'string',
'php_ini_loaded_file' => 'false|string',
'php_ini_scanned_files' => 'false|string',
'php_sapi_name' => 'false|string',
'php_strip_whitespace' => 'string',
'php_uname' => 'string',
'phpcredits' => 'true',
'phpinfo' => 'true',
'PhpToken::__toString' => 'string',
'PhpToken::getTokenName' => '?string',
'PhpToken::is' => 'bool',
'PhpToken::isIgnorable' => 'bool',
'PhpToken::tokenize' => 'array',
'phpversion' => 'false|string',
'pi' => 'float',
'pos' => 'mixed',
'posix_access' => 'bool',
'posix_ctermid' => 'false|string',
'posix_eaccess' => 'bool',
'posix_errno' => 'int',
'posix_fpathconf' => 'false|int',
'posix_get_last_error' => 'int',
'posix_getcwd' => 'false|string',
'posix_getegid' => 'int',
'posix_geteuid' => 'int',
'posix_getgid' => 'int',
'posix_getgrgid' => 'array|false',
'posix_getgrnam' => 'array|false',
'posix_getgroups' => 'array|false',
'posix_getlogin' => 'false|string',
'posix_getpgid' => 'false|int',
'posix_getpgrp' => 'int',
'posix_getpid' => 'int',
'posix_getppid' => 'int',
'posix_getpwnam' => 'array|false',
'posix_getpwuid' => 'array|false',
'posix_getrlimit' => 'array|false',
'posix_getsid' => 'false|int',
'posix_getuid' => 'int',
'posix_initgroups' => 'bool',
'posix_isatty' => 'bool',
'posix_kill' => 'bool',
'posix_mkfifo' => 'bool',
'posix_mknod' => 'bool',
'posix_pathconf' => 'false|int',
'posix_setegid' => 'bool',
'posix_seteuid' => 'bool',
'posix_setgid' => 'bool',
'posix_setpgid' => 'bool',
'posix_setrlimit' => 'bool',
'posix_setsid' => 'int',
'posix_setuid' => 'bool',
'posix_strerror' => 'string',
'posix_sysconf' => 'int',
'posix_times' => 'array|false',
'posix_ttyname' => 'false|string',
'posix_uname' => 'array|false',
'pow' => 'float|int|object',
'preg_filter' => 'array|null|string',
'preg_grep' => 'array|false',
'preg_last_error' => 'int',
'preg_last_error_msg' => 'string',
'preg_match' => 'false|int',
'preg_match_all' => 'false|int',
'preg_quote' => 'string',
'preg_replace' => 'array|null|string',
'preg_replace_callback' => 'array|null|string',
'preg_replace_callback_array' => 'array|null|string',
'preg_split' => 'array|false',
'prev' => 'mixed',
'print_r' => 'string|true',
'printf' => 'int',
'proc_close' => 'int',
'proc_get_status' => 'array',
'proc_nice' => 'bool',
'proc_terminate' => 'bool',
'property_exists' => 'bool',
'PropertyHookType::cases' => 'array',
'PropertyHookType::from' => 'static',
'PropertyHookType::tryFrom' => '?static',
'pspell_add_to_personal' => 'bool',
'pspell_add_to_session' => 'bool',
'pspell_check' => 'bool',
'pspell_clear_session' => 'bool',
'pspell_config_create' => '\PSpell\Config',
'pspell_config_data_dir' => 'bool',
'pspell_config_dict_dir' => 'bool',
'pspell_config_ignore' => 'bool',
'pspell_config_mode' => 'bool',
'pspell_config_personal' => 'bool',
'pspell_config_repl' => 'bool',
'pspell_config_runtogether' => 'bool',
'pspell_config_save_repl' => 'bool',
'pspell_new' => '\PSpell\Dictionary|false',
'pspell_new_config' => '\PSpell\Dictionary|false',
'pspell_new_personal' => '\PSpell\Dictionary|false',
'pspell_save_wordlist' => 'bool',
'pspell_store_replacement' => 'bool',
'pspell_suggest' => 'array|false',
'putenv' => 'bool',
'quoted_printable_decode' => 'string',
'quoted_printable_encode' => 'string',
'quotemeta' => 'string',
'rad2deg' => 'float',
'rand' => 'int',
'Random\BrokenRandomEngineError::__toString' => 'string',
'Random\BrokenRandomEngineError::getFile' => 'string',
'Random\BrokenRandomEngineError::getLine' => 'int',
'Random\BrokenRandomEngineError::getMessage' => 'string',
'Random\BrokenRandomEngineError::getPrevious' => '?\Throwable',
'Random\BrokenRandomEngineError::getTrace' => 'array',
'Random\BrokenRandomEngineError::getTraceAsString' => 'string',
'Random\Engine\Mt19937::__debugInfo' => 'array',
'Random\Engine\Mt19937::__serialize' => 'array',
'Random\Engine\Mt19937::__unserialize' => 'void',
'Random\Engine\Mt19937::generate' => 'string',
'Random\Engine\PcgOneseq128XslRr64::__debugInfo' => 'array',
'Random\Engine\PcgOneseq128XslRr64::__serialize' => 'array',
'Random\Engine\PcgOneseq128XslRr64::__unserialize' => 'void',
'Random\Engine\PcgOneseq128XslRr64::generate' => 'string',
'Random\Engine\PcgOneseq128XslRr64::jump' => 'void',
'Random\Engine\Secure::generate' => 'string',
'Random\Engine\Xoshiro256StarStar::__debugInfo' => 'array',
'Random\Engine\Xoshiro256StarStar::__serialize' => 'array',
'Random\Engine\Xoshiro256StarStar::__unserialize' => 'void',
'Random\Engine\Xoshiro256StarStar::generate' => 'string',
'Random\Engine\Xoshiro256StarStar::jump' => 'void',
'Random\Engine\Xoshiro256StarStar::jumpLong' => 'void',
'Random\IntervalBoundary::cases' => 'array',
'Random\RandomError::__toString' => 'string',
'Random\RandomError::getFile' => 'string',
'Random\RandomError::getLine' => 'int',
'Random\RandomError::getMessage' => 'string',
'Random\RandomError::getPrevious' => '?\Throwable',
'Random\RandomError::getTrace' => 'array',
'Random\RandomError::getTraceAsString' => 'string',
'Random\RandomException::__toString' => 'string',
'Random\RandomException::getFile' => 'string',
'Random\RandomException::getLine' => 'int',
'Random\RandomException::getMessage' => 'string',
'Random\RandomException::getPrevious' => '?\Throwable',
'Random\RandomException::getTrace' => 'array',
'Random\RandomException::getTraceAsString' => 'string',
'Random\Randomizer::__serialize' => 'array',
'Random\Randomizer::__unserialize' => 'void',
'Random\Randomizer::getBytes' => 'string',
'Random\Randomizer::getBytesFromString' => 'string',
'Random\Randomizer::getFloat' => 'float',
'Random\Randomizer::getInt' => 'int',
'Random\Randomizer::nextFloat' => 'float',
'Random\Randomizer::nextInt' => 'int',
'Random\Randomizer::pickArrayKeys' => 'array',
'Random\Randomizer::shuffleArray' => 'array',
'Random\Randomizer::shuffleBytes' => 'string',
'random_bytes' => 'string',
'random_int' => 'int',
'range' => 'array',
'RangeException::__toString' => 'string',
'RangeException::getFile' => 'string',
'RangeException::getLine' => 'int',
'RangeException::getMessage' => 'string',
'RangeException::getPrevious' => '?\Throwable',
'RangeException::getTrace' => 'array',
'RangeException::getTraceAsString' => 'string',
'rawurldecode' => 'string',
'rawurlencode' => 'string',
'readdir' => 'false|string',
'readfile' => 'false|int',
'readgzfile' => 'false|int',
'readline' => 'false|string',
'readline_add_history' => 'bool',
'readline_callback_handler_install' => 'bool',
'readline_callback_handler_remove' => 'bool',
'readline_callback_read_char' => 'void',
'readline_clear_history' => 'bool',
'readline_completion_function' => 'bool',
'readline_info' => 'mixed',
'readline_list_history' => 'array',
'readline_on_new_line' => 'void',
'readline_read_history' => 'bool',
'readline_redisplay' => 'void',
'readline_write_history' => 'bool',
'readlink' => 'false|string',
'realpath' => 'false|string',
'realpath_cache_get' => 'array',
'realpath_cache_size' => 'int',
'RecursiveCachingIterator::__toString' => 'string',
'RecursiveDirectoryIterator::__toString' => 'string',
'Redis::_compress' => 'string',
'Redis::_pack' => 'string',
'Redis::_prefix' => 'string',
'Redis::_serialize' => 'string',
'Redis::_uncompress' => 'string',
'Redis::_unpack' => 'mixed',
'Redis::_unserialize' => 'mixed',
'Redis::acl' => 'mixed',
'Redis::append' => '\Redis|false|int',
'Redis::auth' => '\Redis|bool',
'Redis::bgrewriteaof' => '\Redis|bool',
'Redis::bgSave' => '\Redis|bool',
'Redis::bitcount' => '\Redis|false|int',
'Redis::bitop' => '\Redis|false|int',
'Redis::bitpos' => '\Redis|false|int',
'Redis::blmove' => '\Redis|false|string',
'Redis::blmpop' => '\Redis|array|false|null',
'Redis::blPop' => '\Redis|array|false|null',
'Redis::brPop' => '\Redis|array|false|null',
'Redis::brpoplpush' => '\Redis|false|string',
'Redis::bzmpop' => '\Redis|array|false|null',
'Redis::bzPopMax' => '\Redis|array|false',
'Redis::bzPopMin' => '\Redis|array|false',
'Redis::clearLastError' => 'bool',
'Redis::clearTransferredBytes' => 'void',
'Redis::client' => 'mixed',
'Redis::close' => 'bool',
'Redis::command' => 'mixed',
'Redis::config' => 'mixed',
'Redis::connect' => 'bool',
'Redis::copy' => '\Redis|bool',
'Redis::dbSize' => '\Redis|false|int',
'Redis::debug' => '\Redis|string',
'Redis::decr' => '\Redis|false|int',
'Redis::decrBy' => '\Redis|false|int',
'Redis::del' => '\Redis|false|int',
'Redis::delete' => '\Redis|false|int',
'Redis::discard' => '\Redis|bool',
'Redis::dump' => '\Redis|false|string',
'Redis::echo' => '\Redis|false|string',
'Redis::eval' => 'mixed',
'Redis::eval_ro' => 'mixed',
'Redis::evalsha' => 'mixed',
'Redis::evalsha_ro' => 'mixed',
'Redis::exec' => '\Redis|array|false',
'Redis::exists' => '\Redis|bool|int',
'Redis::expire' => '\Redis|bool',
'Redis::expireAt' => '\Redis|bool',
'Redis::expiremember' => '\Redis|false|int',
'Redis::expirememberat' => '\Redis|false|int',
'Redis::expiretime' => '\Redis|false|int',
'Redis::failover' => '\Redis|bool',
'Redis::fcall' => 'mixed',
'Redis::fcall_ro' => 'mixed',
'Redis::flushAll' => '\Redis|bool',
'Redis::flushDB' => '\Redis|bool',
'Redis::function' => '\Redis|array|bool|string',
'Redis::geoadd' => '\Redis|false|int',
'Redis::geodist' => '\Redis|false|float',
'Redis::geohash' => '\Redis|array|false',
'Redis::geopos' => '\Redis|array|false',
'Redis::georadius' => 'mixed',
'Redis::georadius_ro' => 'mixed',
'Redis::georadiusbymember' => 'mixed',
'Redis::georadiusbymember_ro' => 'mixed',
'Redis::geosearch' => 'array',
'Redis::geosearchstore' => '\Redis|array|false|int',
'Redis::get' => 'mixed',
'Redis::getAuth' => 'mixed',
'Redis::getBit' => '\Redis|false|int',
'Redis::getDBNum' => 'int',
'Redis::getDel' => '\Redis|bool|string',
'Redis::getEx' => '\Redis|bool|string',
'Redis::getHost' => 'string',
'Redis::getLastError' => '?string',
'Redis::getMode' => 'int',
'Redis::getOption' => 'mixed',
'Redis::getPersistentID' => '?string',
'Redis::getPort' => 'int',
'Redis::getRange' => '\Redis|false|string',
'Redis::getReadTimeout' => 'float',
'Redis::getset' => '\Redis|false|string',
'Redis::getTimeout' => 'false|float',
'Redis::getTransferredBytes' => 'array',
'Redis::getWithMeta' => '\Redis|array|false',
'Redis::hDel' => '\Redis|false|int',
'Redis::hExists' => '\Redis|bool',
'Redis::hGet' => 'mixed',
'Redis::hGetAll' => '\Redis|array|false',
'Redis::hIncrBy' => '\Redis|false|int',
'Redis::hIncrByFloat' => '\Redis|false|float',
'Redis::hKeys' => '\Redis|array|false',
'Redis::hLen' => '\Redis|false|int',
'Redis::hMget' => '\Redis|array|false',
'Redis::hMset' => '\Redis|bool',
'Redis::hRandField' => '\Redis|array|false|string',
'Redis::hscan' => '\Redis|array|bool',
'Redis::hSet' => '\Redis|false|int',
'Redis::hSetNx' => '\Redis|bool',
'Redis::hStrLen' => '\Redis|false|int',
'Redis::hVals' => '\Redis|array|false',
'Redis::incr' => '\Redis|false|int',
'Redis::incrBy' => '\Redis|false|int',
'Redis::incrByFloat' => '\Redis|false|float',
'Redis::info' => '\Redis|array|false',
'Redis::isConnected' => 'bool',
'Redis::lastSave' => 'int',
'Redis::lcs' => '\Redis|array|false|int|string',
'Redis::lindex' => 'mixed',
'Redis::lLen' => '\Redis|false|int',
'Redis::lMove' => '\Redis|false|string',
'Redis::lmpop' => '\Redis|array|false|null',
'Redis::lPop' => '\Redis|array|bool|string',
'Redis::lPos' => '\Redis|array|bool|int|null',
'Redis::lPush' => '\Redis|false|int',
'Redis::lPushx' => '\Redis|false|int',
'Redis::lrange' => '\Redis|array|false',
'Redis::lrem' => '\Redis|false|int',
'Redis::lSet' => '\Redis|bool',
'Redis::ltrim' => '\Redis|bool',
'Redis::mget' => '\Redis|array|false',
'Redis::migrate' => '\Redis|bool',
'Redis::move' => '\Redis|bool',
'Redis::mset' => '\Redis|bool',
'Redis::msetnx' => '\Redis|bool',
'Redis::multi' => '\Redis|bool',
'Redis::object' => '\Redis|false|int|string',
'Redis::open' => 'bool',
'Redis::pconnect' => 'bool',
'Redis::persist' => '\Redis|bool',
'Redis::pexpire' => 'bool',
'Redis::pexpireAt' => '\Redis|bool',
'Redis::pexpiretime' => '\Redis|false|int',
'Redis::pfadd' => '\Redis|int',
'Redis::pfcount' => '\Redis|false|int',
'Redis::pfmerge' => '\Redis|bool',
'Redis::ping' => '\Redis|bool|string',
'Redis::pipeline' => '\Redis|bool',
'Redis::popen' => 'bool',
'Redis::psetex' => '\Redis|bool',
'Redis::psubscribe' => 'bool',
'Redis::pttl' => '\Redis|false|int',
'Redis::publish' => '\Redis|false|int',
'Redis::pubsub' => 'mixed',
'Redis::punsubscribe' => '\Redis|array|bool',
'Redis::randomKey' => '\Redis|false|string',
'Redis::rawcommand' => 'mixed',
'Redis::rename' => '\Redis|bool',
'Redis::renameNx' => '\Redis|bool',
'Redis::replicaof' => '\Redis|bool',
'Redis::reset' => '\Redis|bool',
'Redis::restore' => '\Redis|bool',
'Redis::role' => 'mixed',
'Redis::rPop' => '\Redis|array|bool|string',
'Redis::rpoplpush' => '\Redis|false|string',
'Redis::rPush' => '\Redis|false|int',
'Redis::rPushx' => '\Redis|false|int',
'Redis::sAdd' => '\Redis|false|int',
'Redis::sAddArray' => 'int',
'Redis::save' => '\Redis|bool',
'Redis::scan' => 'array|false',
'Redis::scard' => '\Redis|false|int',
'Redis::script' => 'mixed',
'Redis::sDiff' => '\Redis|array|false',
'Redis::sDiffStore' => '\Redis|false|int',
'Redis::select' => '\Redis|bool',
'Redis::serverName' => 'false|string',
'Redis::serverVersion' => 'false|string',
'Redis::set' => '\Redis|bool|string',
'Redis::setBit' => '\Redis|false|int',
'Redis::setnx' => '\Redis|bool',
'Redis::setOption' => 'bool',
'Redis::setRange' => '\Redis|false|int',
'Redis::sInter' => '\Redis|array|false',
'Redis::sintercard' => '\Redis|false|int',
'Redis::sInterStore' => '\Redis|false|int',
'Redis::sismember' => '\Redis|bool',
'Redis::slaveof' => '\Redis|bool',
'Redis::slowlog' => 'mixed',
'Redis::sMembers' => '\Redis|array|false',
'Redis::sMisMember' => '\Redis|array|false',
'Redis::sMove' => '\Redis|bool',
'Redis::sort' => 'mixed',
'Redis::sort_ro' => 'mixed',
'Redis::sortAsc' => 'array',
'Redis::sortAscAlpha' => 'array',
'Redis::sortDesc' => 'array',
'Redis::sortDescAlpha' => 'array',
'Redis::sPop' => '\Redis|array|false|string',
'Redis::sRandMember' => 'mixed',
'Redis::srem' => '\Redis|false|int',
'Redis::sscan' => 'array|false',
'Redis::ssubscribe' => 'bool',
'Redis::strlen' => '\Redis|false|int',
'Redis::subscribe' => 'bool',
'Redis::sUnion' => '\Redis|array|false',
'Redis::sUnionStore' => '\Redis|false|int',
'Redis::sunsubscribe' => '\Redis|array|bool',
'Redis::swapdb' => '\Redis|bool',
'Redis::time' => '\Redis|array',
'Redis::touch' => '\Redis|false|int',
'Redis::ttl' => '\Redis|false|int',
'Redis::type' => '\Redis|false|int',
'Redis::unlink' => '\Redis|false|int',
'Redis::unsubscribe' => '\Redis|array|bool',
'Redis::unwatch' => '\Redis|bool',
'Redis::wait' => 'false|int',
'Redis::waitaof' => '\Redis|array|false',
'Redis::watch' => '\Redis|bool',
'Redis::xack' => 'false|int',
'Redis::xadd' => '\Redis|false|string',
'Redis::xautoclaim' => '\Redis|array|bool',
'Redis::xclaim' => '\Redis|array|bool',
'Redis::xdel' => '\Redis|false|int',
'Redis::xgroup' => 'mixed',
'Redis::xinfo' => 'mixed',
'Redis::xlen' => '\Redis|false|int',
'Redis::xpending' => '\Redis|array|false',
'Redis::xrange' => '\Redis|array|bool',
'Redis::xread' => '\Redis|array|bool',
'Redis::xreadgroup' => '\Redis|array|bool',
'Redis::xrevrange' => '\Redis|array|bool',
'Redis::xtrim' => '\Redis|false|int',
'Redis::zAdd' => '\Redis|false|float|int',
'Redis::zCard' => '\Redis|false|int',
'Redis::zCount' => '\Redis|false|int',
'Redis::zdiff' => '\Redis|array|false',
'Redis::zdiffstore' => '\Redis|false|int',
'Redis::zIncrBy' => '\Redis|false|float',
'Redis::zinter' => '\Redis|array|false',
'Redis::zintercard' => '\Redis|false|int',
'Redis::zinterstore' => '\Redis|false|int',
'Redis::zLexCount' => '\Redis|false|int',
'Redis::zmpop' => '\Redis|array|false|null',
'Redis::zMscore' => '\Redis|array|false',
'Redis::zPopMax' => '\Redis|array|false',
'Redis::zPopMin' => '\Redis|array|false',
'Redis::zRandMember' => '\Redis|array|string',
'Redis::zRange' => '\Redis|array|false',
'Redis::zRangeByLex' => '\Redis|array|false',
'Redis::zRangeByScore' => '\Redis|array|false',
'Redis::zrangestore' => '\Redis|false|int',
'Redis::zRank' => '\Redis|false|int',
'Redis::zRem' => '\Redis|false|int',
'Redis::zRemRangeByLex' => '\Redis|false|int',
'Redis::zRemRangeByRank' => '\Redis|false|int',
'Redis::zRemRangeByScore' => '\Redis|false|int',
'Redis::zRevRange' => '\Redis|array|false',
'Redis::zRevRangeByLex' => '\Redis|array|false',
'Redis::zRevRangeByScore' => '\Redis|array|false',
'Redis::zRevRank' => '\Redis|false|int',
'Redis::zscan' => '\Redis|array|false',
'Redis::zScore' => '\Redis|false|float',
'Redis::zunion' => '\Redis|array|false',
'Redis::zunionstore' => '\Redis|false|int',
'RedisArray::__call' => 'mixed',
'RedisArray::_continuum' => 'array|bool',
'RedisArray::_distributor' => 'bool|callable',
'RedisArray::_function' => 'bool|callable',
'RedisArray::_hosts' => 'array|bool',
'RedisArray::_instance' => '\Redis|bool|null',
'RedisArray::_rehash' => '?bool',
'RedisArray::_target' => 'bool|null|string',
'RedisArray::bgsave' => 'array',
'RedisArray::del' => 'bool|int',
'RedisArray::discard' => '?bool',
'RedisArray::exec' => 'array|bool|null',
'RedisArray::flushall' => 'array|bool',
'RedisArray::flushdb' => 'array|bool',
'RedisArray::getOption' => 'array|bool',
'RedisArray::hscan' => 'array|bool',
'RedisArray::info' => 'array|bool',
'RedisArray::keys' => 'array|bool',
'RedisArray::mget' => 'array|bool',
'RedisArray::mset' => 'bool',
'RedisArray::multi' => '\RedisArray|bool',
'RedisArray::ping' => 'array|bool',
'RedisArray::save' => 'array|bool',
'RedisArray::scan' => 'array|bool',
'RedisArray::select' => 'array|bool',
'RedisArray::setOption' => 'array|bool',
'RedisArray::sscan' => 'array|bool',
'RedisArray::unlink' => 'bool|int',
'RedisArray::unwatch' => '?bool',
'RedisArray::zscan' => 'array|bool',
'RedisCluster::_compress' => 'string',
'RedisCluster::_masters' => 'array',
'RedisCluster::_pack' => 'string',
'RedisCluster::_prefix' => 'bool|string',
'RedisCluster::_redir' => '?string',
'RedisCluster::_serialize' => 'bool|string',
'RedisCluster::_uncompress' => 'string',
'RedisCluster::_unpack' => 'mixed',
'RedisCluster::_unserialize' => 'mixed',
'RedisCluster::acl' => 'mixed',
'RedisCluster::append' => '\RedisCluster|bool|int',
'RedisCluster::bgrewriteaof' => '\RedisCluster|bool',
'RedisCluster::bgsave' => '\RedisCluster|bool',
'RedisCluster::bitcount' => '\RedisCluster|bool|int',
'RedisCluster::bitop' => '\RedisCluster|bool|int',
'RedisCluster::bitpos' => '\RedisCluster|false|int',
'RedisCluster::blmove' => '\Redis|false|string',
'RedisCluster::blmpop' => '\RedisCluster|array|false|null',
'RedisCluster::blpop' => '\RedisCluster|array|false|null',
'RedisCluster::brpop' => '\RedisCluster|array|false|null',
'RedisCluster::brpoplpush' => 'mixed',
'RedisCluster::bzmpop' => '\RedisCluster|array|false|null',
'RedisCluster::bzpopmax' => 'array',
'RedisCluster::bzpopmin' => 'array',
'RedisCluster::clearlasterror' => 'bool',
'RedisCluster::cleartransferredbytes' => 'void',
'RedisCluster::client' => 'array|bool|string',
'RedisCluster::close' => 'bool',
'RedisCluster::cluster' => 'mixed',
'RedisCluster::command' => 'mixed',
'RedisCluster::config' => 'mixed',
'RedisCluster::copy' => '\RedisCluster|bool',
'RedisCluster::dbsize' => '\RedisCluster|int',
'RedisCluster::decr' => '\RedisCluster|false|int',
'RedisCluster::decrby' => '\RedisCluster|false|int',
'RedisCluster::decrbyfloat' => 'float',
'RedisCluster::del' => '\RedisCluster|false|int',
'RedisCluster::discard' => 'bool',
'RedisCluster::dump' => '\RedisCluster|false|string',
'RedisCluster::echo' => '\RedisCluster|false|string',
'RedisCluster::eval' => 'mixed',
'RedisCluster::eval_ro' => 'mixed',
'RedisCluster::evalsha' => 'mixed',
'RedisCluster::evalsha_ro' => 'mixed',
'RedisCluster::exec' => 'array|false',
'RedisCluster::exists' => '\RedisCluster|bool|int',
'RedisCluster::expire' => '\RedisCluster|bool',
'RedisCluster::expireat' => '\RedisCluster|bool',
'RedisCluster::expiremember' => '\Redis|false|int',
'RedisCluster::expirememberat' => '\Redis|false|int',
'RedisCluster::expiretime' => '\RedisCluster|false|int',
'RedisCluster::flushall' => '\RedisCluster|bool',
'RedisCluster::flushdb' => '\RedisCluster|bool',
'RedisCluster::geoadd' => '\RedisCluster|false|int',
'RedisCluster::geodist' => '\RedisCluster|false|float',
'RedisCluster::geohash' => '\RedisCluster|array|false',
'RedisCluster::geopos' => '\RedisCluster|array|false',
'RedisCluster::georadius' => 'mixed',
'RedisCluster::georadius_ro' => 'mixed',
'RedisCluster::georadiusbymember' => 'mixed',
'RedisCluster::georadiusbymember_ro' => 'mixed',
'RedisCluster::geosearch' => '\RedisCluster|array',
'RedisCluster::geosearchstore' => '\RedisCluster|array|false|int',
'RedisCluster::get' => 'mixed',
'RedisCluster::getbit' => '\RedisCluster|false|int',
'RedisCluster::getdel' => 'mixed',
'RedisCluster::getex' => '\RedisCluster|false|string',
'RedisCluster::getlasterror' => '?string',
'RedisCluster::getmode' => 'int',
'RedisCluster::getoption' => 'mixed',
'RedisCluster::getrange' => '\RedisCluster|false|string',
'RedisCluster::getset' => '\RedisCluster|bool|string',
'RedisCluster::gettransferredbytes' => 'array|false',
'RedisCluster::getWithMeta' => '\RedisCluster|array|false',
'RedisCluster::hdel' => '\RedisCluster|false|int',
'RedisCluster::hexists' => '\RedisCluster|bool',
'RedisCluster::hget' => 'mixed',
'RedisCluster::hgetall' => '\RedisCluster|array|false',
'RedisCluster::hincrby' => '\RedisCluster|false|int',
'RedisCluster::hincrbyfloat' => '\RedisCluster|false|float',
'RedisCluster::hkeys' => '\RedisCluster|array|false',
'RedisCluster::hlen' => '\RedisCluster|false|int',
'RedisCluster::hmget' => '\RedisCluster|array|false',
'RedisCluster::hmset' => '\RedisCluster|bool',
'RedisCluster::hrandfield' => '\RedisCluster|array|string',
'RedisCluster::hscan' => 'array|bool',
'RedisCluster::hset' => '\RedisCluster|false|int',
'RedisCluster::hsetnx' => '\RedisCluster|bool',
'RedisCluster::hstrlen' => '\RedisCluster|false|int',
'RedisCluster::hvals' => '\RedisCluster|array|false',
'RedisCluster::incr' => '\RedisCluster|false|int',
'RedisCluster::incrby' => '\RedisCluster|false|int',
'RedisCluster::incrbyfloat' => '\RedisCluster|false|float',
'RedisCluster::info' => '\RedisCluster|array|false',
'RedisCluster::keys' => '\RedisCluster|array|false',
'RedisCluster::lastsave' => '\RedisCluster|false|int',
'RedisCluster::lcs' => '\RedisCluster|array|false|int|string',
'RedisCluster::lget' => '\RedisCluster|bool|string',
'RedisCluster::lindex' => 'mixed',
'RedisCluster::linsert' => '\RedisCluster|false|int',
'RedisCluster::llen' => '\RedisCluster|bool|int',
'RedisCluster::lmove' => '\Redis|false|string',
'RedisCluster::lmpop' => '\RedisCluster|array|false|null',
'RedisCluster::lpop' => '\RedisCluster|array|bool|string',
'RedisCluster::lpos' => '\Redis|array|bool|int|null',
'RedisCluster::lpush' => '\RedisCluster|bool|int',
'RedisCluster::lpushx' => '\RedisCluster|bool|int',
'RedisCluster::lrange' => '\RedisCluster|array|false',
'RedisCluster::lrem' => '\RedisCluster|bool|int',
'RedisCluster::lset' => '\RedisCluster|bool',
'RedisCluster::ltrim' => '\RedisCluster|bool',
'RedisCluster::mget' => '\RedisCluster|array|false',
'RedisCluster::mset' => '\RedisCluster|bool',
'RedisCluster::msetnx' => '\RedisCluster|array|false',
'RedisCluster::multi' => '\RedisCluster|bool',
'RedisCluster::object' => '\RedisCluster|false|int|string',
'RedisCluster::persist' => '\RedisCluster|bool',
'RedisCluster::pexpire' => '\RedisCluster|bool',
'RedisCluster::pexpireat' => '\RedisCluster|bool',
'RedisCluster::pexpiretime' => '\RedisCluster|false|int',
'RedisCluster::pfadd' => '\RedisCluster|bool',
'RedisCluster::pfcount' => '\RedisCluster|false|int',
'RedisCluster::pfmerge' => '\RedisCluster|bool',
'RedisCluster::ping' => 'mixed',
'RedisCluster::psetex' => '\RedisCluster|bool',
'RedisCluster::psubscribe' => 'void',
'RedisCluster::pttl' => '\RedisCluster|false|int',
'RedisCluster::publish' => '\RedisCluster|bool|int',
'RedisCluster::pubsub' => 'mixed',
'RedisCluster::punsubscribe' => 'array|bool',
'RedisCluster::randomkey' => '\RedisCluster|bool|string',
'RedisCluster::rawcommand' => 'mixed',
'RedisCluster::rename' => '\RedisCluster|bool',
'RedisCluster::renamenx' => '\RedisCluster|bool',
'RedisCluster::restore' => '\RedisCluster|bool',
'RedisCluster::role' => 'mixed',
'RedisCluster::rpop' => '\RedisCluster|array|bool|string',
'RedisCluster::rpoplpush' => '\RedisCluster|bool|string',
'RedisCluster::rpush' => '\RedisCluster|false|int',
'RedisCluster::rpushx' => '\RedisCluster|bool|int',
'RedisCluster::sadd' => '\RedisCluster|false|int',
'RedisCluster::saddarray' => '\RedisCluster|bool|int',
'RedisCluster::save' => '\RedisCluster|bool',
'RedisCluster::scan' => 'array|bool',
'RedisCluster::scard' => '\RedisCluster|false|int',
'RedisCluster::script' => 'mixed',
'RedisCluster::sdiff' => '\RedisCluster|array|false',
'RedisCluster::sdiffstore' => '\RedisCluster|false|int',
'RedisCluster::set' => '\RedisCluster|bool|string',
'RedisCluster::setbit' => '\RedisCluster|false|int',
'RedisCluster::setex' => '\RedisCluster|bool',
'RedisCluster::setnx' => '\RedisCluster|bool',
'RedisCluster::setoption' => 'bool',
'RedisCluster::setrange' => '\RedisCluster|false|int',
'RedisCluster::sinter' => '\RedisCluster|array|false',
'RedisCluster::sintercard' => '\RedisCluster|false|int',
'RedisCluster::sinterstore' => '\RedisCluster|false|int',
'RedisCluster::sismember' => '\RedisCluster|bool',
'RedisCluster::slowlog' => 'mixed',
'RedisCluster::smembers' => '\RedisCluster|array|false',
'RedisCluster::smismember' => '\RedisCluster|array|false',
'RedisCluster::smove' => '\RedisCluster|bool',
'RedisCluster::sort' => '\RedisCluster|array|bool|int|string',
'RedisCluster::sort_ro' => '\RedisCluster|array|bool|int|string',
'RedisCluster::spop' => '\RedisCluster|array|false|string',
'RedisCluster::srandmember' => '\RedisCluster|array|false|string',
'RedisCluster::srem' => '\RedisCluster|false|int',
'RedisCluster::sscan' => 'array|false',
'RedisCluster::strlen' => '\RedisCluster|false|int',
'RedisCluster::subscribe' => 'void',
'RedisCluster::sunion' => '\RedisCluster|array|bool',
'RedisCluster::sunionstore' => '\RedisCluster|false|int',
'RedisCluster::time' => '\RedisCluster|array|bool',
'RedisCluster::touch' => '\RedisCluster|bool|int',
'RedisCluster::ttl' => '\RedisCluster|false|int',
'RedisCluster::type' => '\RedisCluster|false|int',
'RedisCluster::unlink' => '\RedisCluster|false|int',
'RedisCluster::unsubscribe' => 'array|bool',
'RedisCluster::unwatch' => 'bool',
'RedisCluster::waitaof' => '\RedisCluster|array|false',
'RedisCluster::watch' => '\RedisCluster|bool',
'RedisCluster::xack' => '\RedisCluster|false|int',
'RedisCluster::xadd' => '\RedisCluster|false|string',
'RedisCluster::xautoclaim' => '\RedisCluster|array|bool',
'RedisCluster::xclaim' => '\RedisCluster|array|false|string',
'RedisCluster::xdel' => '\RedisCluster|false|int',
'RedisCluster::xgroup' => 'mixed',
'RedisCluster::xinfo' => 'mixed',
'RedisCluster::xlen' => '\RedisCluster|false|int',
'RedisCluster::xpending' => '\RedisCluster|array|false',
'RedisCluster::xrange' => '\RedisCluster|array|bool',
'RedisCluster::xread' => '\RedisCluster|array|bool',
'RedisCluster::xreadgroup' => '\RedisCluster|array|bool',
'RedisCluster::xrevrange' => '\RedisCluster|array|bool',
'RedisCluster::xtrim' => '\RedisCluster|false|int',
'RedisCluster::zadd' => '\RedisCluster|false|float|int',
'RedisCluster::zcard' => '\RedisCluster|false|int',
'RedisCluster::zcount' => '\RedisCluster|false|int',
'RedisCluster::zdiff' => '\RedisCluster|array|false',
'RedisCluster::zdiffstore' => '\RedisCluster|false|int',
'RedisCluster::zincrby' => '\RedisCluster|false|float',
'RedisCluster::zinter' => '\RedisCluster|array|false',
'RedisCluster::zintercard' => '\RedisCluster|false|int',
'RedisCluster::zinterstore' => '\RedisCluster|false|int',
'RedisCluster::zlexcount' => '\RedisCluster|false|int',
'RedisCluster::zmpop' => '\RedisCluster|array|false|null',
'RedisCluster::zmscore' => '\Redis|array|false',
'RedisCluster::zpopmax' => '\RedisCluster|array|bool',
'RedisCluster::zpopmin' => '\RedisCluster|array|bool',
'RedisCluster::zrandmember' => '\RedisCluster|array|string',
'RedisCluster::zrange' => '\RedisCluster|array|bool',
'RedisCluster::zrangebylex' => '\RedisCluster|array|false',
'RedisCluster::zrangebyscore' => '\RedisCluster|array|false',
'RedisCluster::zrangestore' => '\RedisCluster|false|int',
'RedisCluster::zrank' => '\RedisCluster|false|int',
'RedisCluster::zrem' => '\RedisCluster|false|int',
'RedisCluster::zremrangebylex' => '\RedisCluster|false|int',
'RedisCluster::zremrangebyrank' => '\RedisCluster|false|int',
'RedisCluster::zremrangebyscore' => '\RedisCluster|false|int',
'RedisCluster::zrevrange' => '\RedisCluster|array|bool',
'RedisCluster::zrevrangebylex' => '\RedisCluster|array|bool',
'RedisCluster::zrevrangebyscore' => '\RedisCluster|array|bool',
'RedisCluster::zrevrank' => '\RedisCluster|false|int',
'RedisCluster::zscan' => '\RedisCluster|array|bool',
'RedisCluster::zscore' => '\RedisCluster|false|float',
'RedisCluster::zunion' => '\RedisCluster|array|false',
'RedisCluster::zunionstore' => '\RedisCluster|false|int',
'RedisClusterException::__toString' => 'string',
'RedisClusterException::getFile' => 'string',
'RedisClusterException::getLine' => 'int',
'RedisClusterException::getMessage' => 'string',
'RedisClusterException::getPrevious' => '?\Throwable',
'RedisClusterException::getTrace' => 'array',
'RedisClusterException::getTraceAsString' => 'string',
'RedisException::__toString' => 'string',
'RedisException::getFile' => 'string',
'RedisException::getLine' => 'int',
'RedisException::getMessage' => 'string',
'RedisException::getPrevious' => '?\Throwable',
'RedisException::getTrace' => 'array',
'RedisException::getTraceAsString' => 'string',
'RedisSentinel::myid' => 'string',
'ReflectionAttribute::__clone' => 'void',
'ReflectionAttribute::__toString' => 'string',
'ReflectionAttribute::getArguments' => 'array',
'ReflectionAttribute::getName' => 'string',
'ReflectionAttribute::getTarget' => 'int',
'ReflectionAttribute::isRepeated' => 'bool',
'ReflectionAttribute::newInstance' => 'object',
'ReflectionClass::__clone' => 'void',
'ReflectionClass::__toString' => 'string',
'ReflectionClass::getAttributes' => 'array',
'ReflectionClass::getLazyInitializer' => '?callable',
'ReflectionClass::initializeLazyObject' => 'object',
'ReflectionClass::isEnum' => 'bool',
'ReflectionClass::isReadOnly' => 'bool',
'ReflectionClass::isUninitializedLazyObject' => 'bool',
'ReflectionClass::markLazyObjectAsInitialized' => 'object',
'ReflectionClass::newLazyGhost' => 'object',
'ReflectionClass::newLazyProxy' => 'object',
'ReflectionClass::resetAsLazyGhost' => 'void',
'ReflectionClass::resetAsLazyProxy' => 'void',
'ReflectionClassConstant::__clone' => 'void',
'ReflectionClassConstant::__toString' => 'string',
'ReflectionClassConstant::getAttributes' => 'array',
'ReflectionClassConstant::getType' => '?\ReflectionType',
'ReflectionClassConstant::hasType' => 'bool',
'ReflectionClassConstant::isDeprecated' => 'bool',
'ReflectionClassConstant::isEnumCase' => 'bool',
'ReflectionClassConstant::isFinal' => 'bool',
'ReflectionConstant::__toString' => 'string',
'ReflectionConstant::getName' => 'string',
'ReflectionConstant::getNamespaceName' => 'string',
'ReflectionConstant::getShortName' => 'string',
'ReflectionConstant::getValue' => 'mixed',
'ReflectionConstant::isDeprecated' => 'bool',
'ReflectionEnum::__toString' => 'string',
'ReflectionEnum::getAttributes' => 'array',
'ReflectionEnum::getBackingType' => '?\ReflectionNamedType',
'ReflectionEnum::getCase' => '\ReflectionEnumUnitCase',
'ReflectionEnum::getCases' => 'array',
'ReflectionEnum::getLazyInitializer' => '?callable',
'ReflectionEnum::hasCase' => 'bool',
'ReflectionEnum::initializeLazyObject' => 'object',
'ReflectionEnum::isBacked' => 'bool',
'ReflectionEnum::isEnum' => 'bool',
'ReflectionEnum::isReadOnly' => 'bool',
'ReflectionEnum::isUninitializedLazyObject' => 'bool',
'ReflectionEnum::markLazyObjectAsInitialized' => 'object',
'ReflectionEnum::newLazyGhost' => 'object',
'ReflectionEnum::newLazyProxy' => 'object',
'ReflectionEnum::resetAsLazyGhost' => 'void',
'ReflectionEnum::resetAsLazyProxy' => 'void',
'ReflectionEnumBackedCase::__toString' => 'string',
'ReflectionEnumBackedCase::getAttributes' => 'array',
'ReflectionEnumBackedCase::getBackingValue' => 'int|string',
'ReflectionEnumBackedCase::getEnum' => '\ReflectionEnum',
'ReflectionEnumBackedCase::getType' => '?\ReflectionType',
'ReflectionEnumBackedCase::getValue' => '\UnitEnum',
'ReflectionEnumBackedCase::hasType' => 'bool',
'ReflectionEnumBackedCase::isDeprecated' => 'bool',
'ReflectionEnumBackedCase::isEnumCase' => 'bool',
'ReflectionEnumBackedCase::isFinal' => 'bool',
'ReflectionEnumUnitCase::__toString' => 'string',
'ReflectionEnumUnitCase::getAttributes' => 'array',
'ReflectionEnumUnitCase::getEnum' => '\ReflectionEnum',
'ReflectionEnumUnitCase::getType' => '?\ReflectionType',
'ReflectionEnumUnitCase::getValue' => '\UnitEnum',
'ReflectionEnumUnitCase::hasType' => 'bool',
'ReflectionEnumUnitCase::isDeprecated' => 'bool',
'ReflectionEnumUnitCase::isEnumCase' => 'bool',
'ReflectionEnumUnitCase::isFinal' => 'bool',
'ReflectionException::__toString' => 'string',
'ReflectionException::getFile' => 'string',
'ReflectionException::getLine' => 'int',
'ReflectionException::getMessage' => 'string',
'ReflectionException::getPrevious' => '?\Throwable',
'ReflectionException::getTrace' => 'array',
'ReflectionException::getTraceAsString' => 'string',
'ReflectionExtension::__clone' => 'void',
'ReflectionExtension::__toString' => 'string',
'ReflectionFiber::getCallable' => 'callable',
'ReflectionFiber::getExecutingFile' => '?string',
'ReflectionFiber::getExecutingLine' => '?int',
'ReflectionFiber::getFiber' => '\Fiber',
'ReflectionFiber::getTrace' => 'array',
'ReflectionFunction::__toString' => 'string',
'ReflectionFunction::getAttributes' => 'array',
'ReflectionFunction::getClosureUsedVariables' => 'array',
'ReflectionFunction::getTentativeReturnType' => '?\ReflectionType',
'ReflectionFunction::hasTentativeReturnType' => 'bool',
'ReflectionFunction::isAnonymous' => 'bool',
'ReflectionFunctionAbstract::__clone' => 'void',
'ReflectionFunctionAbstract::__toString' => 'string',
'ReflectionFunctionAbstract::getAttributes' => 'array',
'ReflectionFunctionAbstract::getClosureUsedVariables' => 'array',
'ReflectionFunctionAbstract::getTentativeReturnType' => '?\ReflectionType',
'ReflectionFunctionAbstract::hasTentativeReturnType' => 'bool',
'ReflectionGenerator::isClosed' => 'bool',
'ReflectionIntersectionType::__toString' => 'string',
'ReflectionIntersectionType::getTypes' => 'array',
'ReflectionMethod::__toString' => 'string',
'ReflectionMethod::createFromMethodName' => 'static',
'ReflectionMethod::getAttributes' => 'array',
'ReflectionMethod::getClosureUsedVariables' => 'array',
'ReflectionMethod::getTentativeReturnType' => '?\ReflectionType',
'ReflectionMethod::hasPrototype' => 'bool',
'ReflectionMethod::hasTentativeReturnType' => 'bool',
'ReflectionNamedType::__toString' => 'string',
'ReflectionObject::__toString' => 'string',
'ReflectionObject::getAttributes' => 'array',
'ReflectionObject::getLazyInitializer' => '?callable',
'ReflectionObject::initializeLazyObject' => 'object',
'ReflectionObject::isEnum' => 'bool',
'ReflectionObject::isReadOnly' => 'bool',
'ReflectionObject::isUninitializedLazyObject' => 'bool',
'ReflectionObject::markLazyObjectAsInitialized' => 'object',
'ReflectionObject::newLazyGhost' => 'object',
'ReflectionObject::newLazyProxy' => 'object',
'ReflectionObject::resetAsLazyGhost' => 'void',
'ReflectionObject::resetAsLazyProxy' => 'void',
'ReflectionParameter::__clone' => 'void',
'ReflectionParameter::__toString' => 'string',
'ReflectionParameter::getAttributes' => 'array',
'ReflectionParameter::isPromoted' => 'bool',
'ReflectionProperty::__clone' => 'void',
'ReflectionProperty::__toString' => 'string',
'ReflectionProperty::getAttributes' => 'array',
'ReflectionProperty::getHook' => '?\ReflectionMethod',
'ReflectionProperty::getHooks' => 'array',
'ReflectionProperty::getRawValue' => 'mixed',
'ReflectionProperty::getSettableType' => '?\ReflectionType',
'ReflectionProperty::hasDefaultValue' => 'bool',
'ReflectionProperty::hasHook' => 'bool',
'ReflectionProperty::hasHooks' => 'bool',
'ReflectionProperty::isAbstract' => 'bool',
'ReflectionProperty::isDynamic' => 'bool',
'ReflectionProperty::isFinal' => 'bool',
'ReflectionProperty::isLazy' => 'bool',
'ReflectionProperty::isPrivateSet' => 'bool',
'ReflectionProperty::isPromoted' => 'bool',
'ReflectionProperty::isProtectedSet' => 'bool',
'ReflectionProperty::isReadOnly' => 'bool',
'ReflectionProperty::isVirtual' => 'bool',
'ReflectionProperty::setRawValue' => 'void',
'ReflectionProperty::setRawValueWithoutLazyInitialization' => 'void',
'ReflectionProperty::skipLazyInitialization' => 'void',
'ReflectionReference::__clone' => 'void',
'ReflectionReference::fromArrayElement' => '?\ReflectionReference',
'ReflectionReference::getId' => 'string',
'ReflectionType::__clone' => 'void',
'ReflectionType::__toString' => 'string',
'ReflectionUnionType::__toString' => 'string',
'ReflectionUnionType::getTypes' => 'array',
'ReflectionZendExtension::__clone' => 'void',
'ReflectionZendExtension::__toString' => 'string',
'register_shutdown_function' => 'void',
'register_tick_function' => 'bool',
'rename' => 'bool',
'request_parse_body' => 'array',
'RequestParseBodyException::__toString' => 'string',
'RequestParseBodyException::getFile' => 'string',
'RequestParseBodyException::getLine' => 'int',
'RequestParseBodyException::getMessage' => 'string',
'RequestParseBodyException::getPrevious' => '?\Throwable',
'RequestParseBodyException::getTrace' => 'array',
'RequestParseBodyException::getTraceAsString' => 'string',
'reset' => 'mixed',
'ResourceBundle::getIterator' => '\Iterator',
'resourcebundle_count' => 'int',
'resourcebundle_create' => '?\ResourceBundle',
'resourcebundle_get' => '\ResourceBundle|array|int|null|string',
'resourcebundle_get_error_code' => 'int',
'resourcebundle_get_error_message' => 'string',
'resourcebundle_locales' => 'array|false',
'restore_error_handler' => 'true',
'restore_exception_handler' => 'true',
'rewind' => 'bool',
'rewinddir' => 'void',
'rmdir' => 'bool',
'round' => 'float',
'RoundingMode::cases' => 'array',
'rsort' => 'true',
'rtrim' => 'string',
'RuntimeException::__toString' => 'string',
'RuntimeException::getFile' => 'string',
'RuntimeException::getLine' => 'int',
'RuntimeException::getMessage' => 'string',
'RuntimeException::getPrevious' => '?\Throwable',
'RuntimeException::getTrace' => 'array',
'RuntimeException::getTraceAsString' => 'string',
'scandir' => 'array|false',
'sem_acquire' => 'bool',
'sem_get' => '\SysvSemaphore|false',
'sem_release' => 'bool',
'sem_remove' => 'bool',
'SensitiveParameterValue::__debugInfo' => 'array',
'SensitiveParameterValue::getValue' => 'mixed',
'serialize' => 'string',
'session_abort' => 'bool',
'session_cache_expire' => 'false|int',
'session_cache_limiter' => 'false|string',
'session_commit' => 'bool',
'session_create_id' => 'false|string',
'session_decode' => 'bool',
'session_destroy' => 'bool',
'session_encode' => 'false|string',
'session_gc' => 'false|int',
'session_get_cookie_params' => 'array',
'session_id' => 'false|string',
'session_module_name' => 'false|string',
'session_name' => 'false|string',
'session_regenerate_id' => 'bool',
'session_register_shutdown' => 'void',
'session_reset' => 'bool',
'session_save_path' => 'false|string',
'session_set_cookie_params' => 'bool',
'session_set_save_handler' => 'bool',
'session_start' => 'bool',
'session_status' => 'int',
'session_unset' => 'bool',
'session_write_close' => 'bool',
'set_file_buffer' => 'int',
'set_include_path' => 'false|string',
'set_time_limit' => 'bool',
'setcookie' => 'bool',
'setlocale' => 'false|string',
'setrawcookie' => 'bool',
'settype' => 'bool',
'sha1' => 'string',
'sha1_file' => 'false|string',
'shell_exec' => 'false|null|string',
'shm_attach' => '\SysvSharedMemory|false',
'shm_detach' => 'bool',
'shm_get_var' => 'mixed',
'shm_has_var' => 'bool',
'shm_put_var' => 'bool',
'shm_remove' => 'bool',
'shm_remove_var' => 'bool',
'shmop_close' => 'void',
'shmop_delete' => 'bool',
'shmop_open' => '\Shmop|false',
'shmop_read' => 'string',
'shmop_size' => 'int',
'shmop_write' => 'int',
'show_source' => 'bool|string',
'shuffle' => 'true',
'similar_text' => 'int',
'simplexml_import_dom' => '?\SimpleXMLElement',
'simplexml_load_file' => '\SimpleXMLElement|false',
'simplexml_load_string' => '\SimpleXMLElement|false',
'SimpleXMLElement::__toString' => 'string',
'SimpleXMLIterator::__toString' => 'string',
'sin' => 'float',
'sinh' => 'float',
'sizeof' => 'int',
'sleep' => 'int',
'SoapFault::__toString' => 'string',
'SoapFault::getFile' => 'string',
'SoapFault::getLine' => 'int',
'SoapFault::getMessage' => 'string',
'SoapFault::getPrevious' => '?\Throwable',
'SoapFault::getTrace' => 'array',
'SoapFault::getTraceAsString' => 'string',
'SoapServer::__getLastResponse' => '?string',
'socket_accept' => '\Socket|false',
'socket_addrinfo_bind' => '\Socket|false',
'socket_addrinfo_connect' => '\Socket|false',
'socket_addrinfo_explain' => 'array',
'socket_addrinfo_lookup' => 'array|false',
'socket_atmark' => 'bool',
'socket_bind' => 'bool',
'socket_clear_error' => 'void',
'socket_close' => 'void',
'socket_cmsg_space' => '?int',
'socket_connect' => 'bool',
'socket_create' => '\Socket|false',
'socket_create_listen' => '\Socket|false',
'socket_create_pair' => 'bool',
'socket_get_option' => 'array|false|int',
'socket_get_status' => 'array',
'socket_getopt' => 'array|false|int',
'socket_getpeername' => 'bool',
'socket_getsockname' => 'bool',
'socket_import_stream' => '\Socket|false',
'socket_last_error' => 'int',
'socket_listen' => 'bool',
'socket_read' => 'false|string',
'socket_recv' => 'false|int',
'socket_recvfrom' => 'false|int',
'socket_recvmsg' => 'false|int',
'socket_select' => 'false|int',
'socket_send' => 'false|int',
'socket_sendmsg' => 'false|int',
'socket_sendto' => 'false|int',
'socket_set_block' => 'bool',
'socket_set_blocking' => 'bool',
'socket_set_nonblock' => 'bool',
'socket_set_option' => 'bool',
'socket_set_timeout' => 'bool',
'socket_setopt' => 'bool',
'socket_shutdown' => 'bool',
'socket_strerror' => 'string',
'socket_write' => 'false|int',
'sodium_add' => 'void',
'sodium_base642bin' => 'string',
'sodium_bin2base64' => 'string',
'sodium_bin2hex' => 'string',
'sodium_compare' => 'int',
'sodium_crypto_aead_aes256gcm_decrypt' => 'false|string',
'sodium_crypto_aead_aes256gcm_encrypt' => 'string',
'sodium_crypto_aead_aes256gcm_is_available' => 'bool',
'sodium_crypto_aead_aes256gcm_keygen' => 'string',
'sodium_crypto_aead_chacha20poly1305_decrypt' => 'false|string',
'sodium_crypto_aead_chacha20poly1305_encrypt' => 'string',
'sodium_crypto_aead_chacha20poly1305_ietf_decrypt' => 'false|string',
'sodium_crypto_aead_chacha20poly1305_ietf_encrypt' => 'string',
'sodium_crypto_aead_chacha20poly1305_ietf_keygen' => 'string',
'sodium_crypto_aead_chacha20poly1305_keygen' => 'string',
'sodium_crypto_aead_xchacha20poly1305_ietf_decrypt' => 'false|string',
'sodium_crypto_aead_xchacha20poly1305_ietf_encrypt' => 'string',
'sodium_crypto_aead_xchacha20poly1305_ietf_keygen' => 'string',
'sodium_crypto_auth' => 'string',
'sodium_crypto_auth_keygen' => 'string',
'sodium_crypto_auth_verify' => 'bool',
'sodium_crypto_box' => 'string',
'sodium_crypto_box_keypair' => 'string',
'sodium_crypto_box_keypair_from_secretkey_and_publickey' => 'string',
'sodium_crypto_box_open' => 'false|string',
'sodium_crypto_box_publickey' => 'string',
'sodium_crypto_box_publickey_from_secretkey' => 'string',
'sodium_crypto_box_seal' => 'string',
'sodium_crypto_box_seal_open' => 'false|string',
'sodium_crypto_box_secretkey' => 'string',
'sodium_crypto_box_seed_keypair' => 'string',
'sodium_crypto_core_ristretto255_add' => 'string',
'sodium_crypto_core_ristretto255_from_hash' => 'string',
'sodium_crypto_core_ristretto255_is_valid_point' => 'bool',
'sodium_crypto_core_ristretto255_random' => 'string',
'sodium_crypto_core_ristretto255_scalar_add' => 'string',
'sodium_crypto_core_ristretto255_scalar_complement' => 'string',
'sodium_crypto_core_ristretto255_scalar_invert' => 'string',
'sodium_crypto_core_ristretto255_scalar_mul' => 'string',
'sodium_crypto_core_ristretto255_scalar_negate' => 'string',
'sodium_crypto_core_ristretto255_scalar_random' => 'string',
'sodium_crypto_core_ristretto255_scalar_reduce' => 'string',
'sodium_crypto_core_ristretto255_scalar_sub' => 'string',
'sodium_crypto_core_ristretto255_sub' => 'string',
'sodium_crypto_generichash' => 'string',
'sodium_crypto_generichash_final' => 'string',
'sodium_crypto_generichash_init' => 'string',
'sodium_crypto_generichash_keygen' => 'string',
'sodium_crypto_generichash_update' => 'true',
'sodium_crypto_kdf_derive_from_key' => 'string',
'sodium_crypto_kdf_keygen' => 'string',
'sodium_crypto_kx_client_session_keys' => 'array',
'sodium_crypto_kx_keypair' => 'string',
'sodium_crypto_kx_publickey' => 'string',
'sodium_crypto_kx_secretkey' => 'string',
'sodium_crypto_kx_seed_keypair' => 'string',
'sodium_crypto_kx_server_session_keys' => 'array',
'sodium_crypto_pwhash' => 'string',
'sodium_crypto_pwhash_scryptsalsa208sha256' => 'string',
'sodium_crypto_pwhash_scryptsalsa208sha256_str' => 'string',
'sodium_crypto_pwhash_scryptsalsa208sha256_str_verify' => 'bool',
'sodium_crypto_pwhash_str' => 'string',
'sodium_crypto_pwhash_str_needs_rehash' => 'bool',
'sodium_crypto_pwhash_str_verify' => 'bool',
'sodium_crypto_scalarmult' => 'string',
'sodium_crypto_scalarmult_base' => 'string',
'sodium_crypto_scalarmult_ristretto255' => 'string',
'sodium_crypto_scalarmult_ristretto255_base' => 'string',
'sodium_crypto_secretbox' => 'string',
'sodium_crypto_secretbox_keygen' => 'string',
'sodium_crypto_secretbox_open' => 'false|string',
'sodium_crypto_secretstream_xchacha20poly1305_init_pull' => 'string',
'sodium_crypto_secretstream_xchacha20poly1305_init_push' => 'array',
'sodium_crypto_secretstream_xchacha20poly1305_keygen' => 'string',
'sodium_crypto_secretstream_xchacha20poly1305_pull' => 'array|false',
'sodium_crypto_secretstream_xchacha20poly1305_push' => 'string',
'sodium_crypto_secretstream_xchacha20poly1305_rekey' => 'void',
'sodium_crypto_shorthash' => 'string',
'sodium_crypto_shorthash_keygen' => 'string',
'sodium_crypto_sign' => 'string',
'sodium_crypto_sign_detached' => 'string',
'sodium_crypto_sign_ed25519_pk_to_curve25519' => 'string',
'sodium_crypto_sign_ed25519_sk_to_curve25519' => 'string',
'sodium_crypto_sign_keypair' => 'string',
'sodium_crypto_sign_keypair_from_secretkey_and_publickey' => 'string',
'sodium_crypto_sign_open' => 'false|string',
'sodium_crypto_sign_publickey' => 'string',
'sodium_crypto_sign_publickey_from_secretkey' => 'string',
'sodium_crypto_sign_secretkey' => 'string',
'sodium_crypto_sign_seed_keypair' => 'string',
'sodium_crypto_sign_verify_detached' => 'bool',
'sodium_crypto_stream' => 'string',
'sodium_crypto_stream_keygen' => 'string',
'sodium_crypto_stream_xchacha20' => 'string',
'sodium_crypto_stream_xchacha20_keygen' => 'string',
'sodium_crypto_stream_xchacha20_xor' => 'string',
'sodium_crypto_stream_xchacha20_xor_ic' => 'string',
'sodium_crypto_stream_xor' => 'string',
'sodium_hex2bin' => 'string',
'sodium_increment' => 'void',
'sodium_memcmp' => 'int',
'sodium_memzero' => 'void',
'sodium_pad' => 'string',
'sodium_unpad' => 'string',
'SodiumException::__toString' => 'string',
'SodiumException::getFile' => 'string',
'SodiumException::getLine' => 'int',
'SodiumException::getMessage' => 'string',
'SodiumException::getPrevious' => '?\Throwable',
'SodiumException::getTrace' => 'array',
'SodiumException::getTraceAsString' => 'string',
'sort' => 'true',
'soundex' => 'string',
'spl_autoload' => 'void',
'spl_autoload_call' => 'void',
'spl_autoload_extensions' => 'string',
'spl_autoload_functions' => 'array',
'spl_autoload_register' => 'bool',
'spl_autoload_unregister' => 'bool',
'spl_classes' => 'array',
'spl_object_hash' => 'string',
'spl_object_id' => 'int',
'SplFileInfo::__toString' => 'string',
'SplFileObject::__toString' => 'string',
'SplFixedArray::__serialize' => 'array',
'SplFixedArray::__unserialize' => 'void',
'SplFixedArray::getIterator' => '\Iterator',
'SplFixedArray::jsonSerialize' => 'array',
'SplObjectStorage::seek' => 'void',
'SplTempFileObject::__toString' => 'string',
'Spoofchecker::setAllowedChars' => 'void',
'sprintf' => 'string',
'sqrt' => 'float',
'srand' => 'void',
'sscanf' => 'array|int|null',
'stat' => 'array|false',
'str_contains' => 'bool',
'str_decrement' => 'string',
'str_ends_with' => 'bool',
'str_getcsv' => 'array',
'str_increment' => 'string',
'str_ireplace' => 'array|string',
'str_pad' => 'string',
'str_repeat' => 'string',
'str_replace' => 'array|string',
'str_rot13' => 'string',
'str_shuffle' => 'string',
'str_split' => 'array',
'str_starts_with' => 'bool',
'str_word_count' => 'array|int',
'strcasecmp' => 'int',
'strchr' => 'false|string',
'strcmp' => 'int',
'strcoll' => 'int',
'strcspn' => 'int',
'stream_bucket_append' => 'void',
'stream_bucket_make_writeable' => '?\StreamBucket',
'stream_bucket_new' => '\StreamBucket',
'stream_bucket_prepend' => 'void',
'stream_context_get_options' => 'array',
'stream_context_get_params' => 'array',
'stream_context_set_option' => 'true',
'stream_context_set_options' => 'true',
'stream_context_set_params' => 'true',
'stream_copy_to_stream' => 'false|int',
'stream_filter_register' => 'bool',
'stream_filter_remove' => 'bool',
'stream_get_contents' => 'false|string',
'stream_get_filters' => 'array',
'stream_get_line' => 'false|string',
'stream_get_meta_data' => 'array',
'stream_get_transports' => 'array',
'stream_get_wrappers' => 'array',
'stream_is_local' => 'bool',
'stream_isatty' => 'bool',
'stream_register_wrapper' => 'bool',
'stream_resolve_include_path' => 'false|string',
'stream_select' => 'false|int',
'stream_set_blocking' => 'bool',
'stream_set_chunk_size' => 'int',
'stream_set_read_buffer' => 'int',
'stream_set_timeout' => 'bool',
'stream_set_write_buffer' => 'int',
'stream_socket_enable_crypto' => 'bool|int',
'stream_socket_get_name' => 'false|string',
'stream_socket_pair' => 'array|false',
'stream_socket_recvfrom' => 'false|string',
'stream_socket_sendto' => 'false|int',
'stream_socket_shutdown' => 'bool',
'stream_supports_lock' => 'bool',
'stream_wrapper_register' => 'bool',
'stream_wrapper_restore' => 'bool',
'stream_wrapper_unregister' => 'bool',
'strftime' => 'false|string',
'strip_tags' => 'string',
'stripcslashes' => 'string',
'stripos' => 'false|int',
'stripslashes' => 'string',
'stristr' => 'false|string',
'strlen' => 'int',
'strnatcasecmp' => 'int',
'strnatcmp' => 'int',
'strncasecmp' => 'int',
'strncmp' => 'int',
'strpbrk' => 'false|string',
'strpos' => 'false|int',
'strptime' => 'array|false',
'strrchr' => 'false|string',
'strrev' => 'string',
'strripos' => 'false|int',
'strrpos' => 'false|int',
'strspn' => 'int',
'strstr' => 'false|string',
'strtok' => 'false|string',
'strtolower' => 'string',
'strtotime' => 'false|int',
'strtoupper' => 'string',
'strtr' => 'string',
'strval' => 'string',
'substr' => 'string',
'substr_compare' => 'int',
'substr_count' => 'int',
'substr_replace' => 'array|string',
'symlink' => 'bool',
'sys_get_temp_dir' => 'string',
'sys_getloadavg' => 'array|false',
'syslog' => 'true',
'system' => 'false|string',
'tan' => 'float',
'tanh' => 'float',
'tempnam' => 'false|string',
'textdomain' => 'string',
'tidy_access_count' => 'int',
'tidy_clean_repair' => 'bool',
'tidy_config_count' => 'int',
'tidy_diagnose' => 'bool',
'tidy_error_count' => 'int',
'tidy_get_body' => '?\tidyNode',
'tidy_get_config' => 'array',
'tidy_get_error_buffer' => 'false|string',
'tidy_get_head' => '?\tidyNode',
'tidy_get_html' => '?\tidyNode',
'tidy_get_html_ver' => 'int',
'tidy_get_opt_doc' => 'false|string',
'tidy_get_output' => 'string',
'tidy_get_release' => 'string',
'tidy_get_root' => '?\tidyNode',
'tidy_get_status' => 'int',
'tidy_getopt' => 'bool|int|string',
'tidy_is_xhtml' => 'bool',
'tidy_is_xml' => 'bool',
'tidy_parse_file' => '\tidy|false',
'tidy_parse_string' => '\tidy|false',
'tidy_repair_file' => 'false|string',
'tidy_repair_string' => 'false|string',
'tidy_warning_count' => 'int',
'tidyNode::getNextSibling' => '?\tidyNode',
'tidyNode::getParent' => '?\tidyNode',
'tidyNode::getPreviousSibling' => '?\tidyNode',
'tidyNode::hasChildren' => 'bool',
'tidyNode::hasSiblings' => 'bool',
'tidyNode::isAsp' => 'bool',
'tidyNode::isComment' => 'bool',
'tidyNode::isHtml' => 'bool',
'tidyNode::isJste' => 'bool',
'tidyNode::isPhp' => 'bool',
'tidyNode::isText' => 'bool',
'time' => 'int',
'time_nanosleep' => 'array|bool',
'time_sleep_until' => 'bool',
'timezone_abbreviations_list' => 'array',
'timezone_identifiers_list' => 'array',
'timezone_location_get' => 'array|false',
'timezone_name_from_abbr' => 'false|string',
'timezone_name_get' => 'string',
'timezone_offset_get' => 'int',
'timezone_open' => '\DateTimeZone|false',
'timezone_transitions_get' => 'array|false',
'timezone_version_get' => 'string',
'token_get_all' => 'array',
'token_name' => 'string',
'touch' => 'bool',
'trait_exists' => 'bool',
'transliterator_create' => '?\Transliterator',
'transliterator_create_from_rules' => '?\Transliterator',
'transliterator_create_inverse' => '?\Transliterator',
'transliterator_get_error_code' => 'false|int',
'transliterator_get_error_message' => 'false|string',
'transliterator_list_ids' => 'array|false',
'transliterator_transliterate' => 'false|string',
'trigger_error' => 'true',
'trim' => 'string',
'TypeError::__toString' => 'string',
'TypeError::getFile' => 'string',
'TypeError::getLine' => 'int',
'TypeError::getMessage' => 'string',
'TypeError::getPrevious' => '?\Throwable',
'TypeError::getTrace' => 'array',
'TypeError::getTraceAsString' => 'string',
'uasort' => 'true',
'ucfirst' => 'string',
'ucwords' => 'string',
'uksort' => 'true',
'umask' => 'int',
'UnderflowException::__toString' => 'string',
'UnderflowException::getFile' => 'string',
'UnderflowException::getLine' => 'int',
'UnderflowException::getMessage' => 'string',
'UnderflowException::getPrevious' => '?\Throwable',
'UnderflowException::getTrace' => 'array',
'UnderflowException::getTraceAsString' => 'string',
'UnexpectedValueException::__toString' => 'string',
'UnexpectedValueException::getFile' => 'string',
'UnexpectedValueException::getLine' => 'int',
'UnexpectedValueException::getMessage' => 'string',
'UnexpectedValueException::getPrevious' => '?\Throwable',
'UnexpectedValueException::getTrace' => 'array',
'UnexpectedValueException::getTraceAsString' => 'string',
'UnhandledMatchError::__toString' => 'string',
'UnhandledMatchError::getFile' => 'string',
'UnhandledMatchError::getLine' => 'int',
'UnhandledMatchError::getMessage' => 'string',
'UnhandledMatchError::getPrevious' => '?\Throwable',
'UnhandledMatchError::getTrace' => 'array',
'UnhandledMatchError::getTraceAsString' => 'string',
'uniqid' => 'string',
'unixtojd' => 'false|int',
'unlink' => 'bool',
'unpack' => 'array|false',
'unregister_tick_function' => 'void',
'unserialize' => 'mixed',
'urldecode' => 'string',
'urlencode' => 'string',
'use_soap_error_handler' => 'bool',
'user_error' => 'true',
'usleep' => 'void',
'usort' => 'true',
'utf8_decode' => 'string',
'utf8_encode' => 'string',
'ValueError::__toString' => 'string',
'ValueError::getFile' => 'string',
'ValueError::getLine' => 'int',
'ValueError::getMessage' => 'string',
'ValueError::getPrevious' => '?\Throwable',
'ValueError::getTrace' => 'array',
'ValueError::getTraceAsString' => 'string',
'var_dump' => 'void',
'var_export' => '?string',
'version_compare' => 'bool|int',
'vfprintf' => 'int',
'vprintf' => 'int',
'vsprintf' => 'string',
'WeakMap::count' => 'int',
'WeakMap::getIterator' => '\Iterator',
'WeakMap::offsetExists' => 'bool',
'WeakMap::offsetGet' => 'mixed',
'WeakMap::offsetSet' => 'void',
'WeakMap::offsetUnset' => 'void',
'WeakReference::create' => '\WeakReference',
'WeakReference::get' => '?object',
'wordwrap' => 'string',
'xml_error_string' => '?string',
'xml_get_current_byte_index' => 'int',
'xml_get_current_column_number' => 'int',
'xml_get_current_line_number' => 'int',
'xml_get_error_code' => 'int',
'xml_parse' => 'int',
'xml_parse_into_struct' => 'false|int',
'xml_parser_create' => '\XMLParser',
'xml_parser_create_ns' => '\XMLParser',
'xml_parser_free' => 'bool',
'xml_parser_get_option' => 'bool|int|string',
'xml_parser_set_option' => 'bool',
'xml_set_character_data_handler' => 'true',
'xml_set_default_handler' => 'true',
'xml_set_element_handler' => 'true',
'xml_set_end_namespace_decl_handler' => 'true',
'xml_set_external_entity_ref_handler' => 'true',
'xml_set_notation_decl_handler' => 'true',
'xml_set_object' => 'true',
'xml_set_processing_instruction_handler' => 'true',
'xml_set_start_namespace_decl_handler' => 'true',
'xml_set_unparsed_entity_decl_handler' => 'true',
'XMLReader::fromStream' => 'static',
'XMLReader::fromString' => 'static',
'XMLReader::fromUri' => 'static',
'XMLWriter::toMemory' => 'static',
'XMLWriter::toStream' => 'static',
'XMLWriter::toUri' => 'static',
'xmlwriter_end_attribute' => 'bool',
'xmlwriter_end_cdata' => 'bool',
'xmlwriter_end_comment' => 'bool',
'xmlwriter_end_document' => 'bool',
'xmlwriter_end_dtd' => 'bool',
'xmlwriter_end_dtd_attlist' => 'bool',
'xmlwriter_end_dtd_element' => 'bool',
'xmlwriter_end_dtd_entity' => 'bool',
'xmlwriter_end_element' => 'bool',
'xmlwriter_end_pi' => 'bool',
'xmlwriter_flush' => 'int|string',
'xmlwriter_full_end_element' => 'bool',
'xmlwriter_open_memory' => '\XMLWriter|false',
'xmlwriter_open_uri' => '\XMLWriter|false',
'xmlwriter_output_memory' => 'string',
'xmlwriter_set_indent' => 'bool',
'xmlwriter_set_indent_string' => 'bool',
'xmlwriter_start_attribute' => 'bool',
'xmlwriter_start_attribute_ns' => 'bool',
'xmlwriter_start_cdata' => 'bool',
'xmlwriter_start_comment' => 'bool',
'xmlwriter_start_document' => 'bool',
'xmlwriter_start_dtd' => 'bool',
'xmlwriter_start_dtd_attlist' => 'bool',
'xmlwriter_start_dtd_element' => 'bool',
'xmlwriter_start_dtd_entity' => 'bool',
'xmlwriter_start_element' => 'bool',
'xmlwriter_start_element_ns' => 'bool',
'xmlwriter_start_pi' => 'bool',
'xmlwriter_text' => 'bool',
'xmlwriter_write_attribute' => 'bool',
'xmlwriter_write_attribute_ns' => 'bool',
'xmlwriter_write_cdata' => 'bool',
'xmlwriter_write_comment' => 'bool',
'xmlwriter_write_dtd' => 'bool',
'xmlwriter_write_dtd_attlist' => 'bool',
'xmlwriter_write_dtd_element' => 'bool',
'xmlwriter_write_dtd_entity' => 'bool',
'xmlwriter_write_element' => 'bool',
'xmlwriter_write_element_ns' => 'bool',
'xmlwriter_write_pi' => 'bool',
'xmlwriter_write_raw' => 'bool',
'XSLTProcessor::registerPHPFunctionNS' => 'void',
'zend_version' => 'string',
'zip_close' => 'void',
'zip_entry_close' => 'bool',
'zip_entry_compressedsize' => 'false|int',
'zip_entry_compressionmethod' => 'false|string',
'zip_entry_filesize' => 'false|int',
'zip_entry_name' => 'false|string',
'zip_entry_open' => 'bool',
'zip_entry_read' => 'false|string',
'ZipArchive::clearError' => 'void',
'ZipArchive::getArchiveFlag' => 'int',
'ZipArchive::isCompressionMethodSupported' => 'bool',
'ZipArchive::isEncryptionMethodSupported' => 'bool',
'ZipArchive::setArchiveFlag' => 'bool',
'zlib_decode' => 'false|string',
'zlib_encode' => 'false|string',
'zlib_get_coding_type' => 'false|string',
];
