<?php

declare(strict_types=1);

namespace Overblog\GraphQLBundle\Annotation;

use Attribute;
use Doctrine\Common\Annotations\Annotation\NamedArgumentConstructor;

/**
 * Annotation for operations provider.
 *
 * @Annotation
 * @NamedArgumentConstructor
 * @Target({"CLASS"})
 */
#[Attribute(Attribute::TARGET_CLASS)]
final class Provider extends Annotation
{
    /**
     * Optional prefix for provider fields.
     */
    public ?string $prefix;

    /**
     * The default target types to attach the provider queries to.
     *
     * @var array<string>
     */
    public ?array $targetQueryTypes;

    /**
     * The default target types to attach the provider mutations to.
     *
     * @var array<string>
     */
    public ?array $targetMutationTypes;

    /**
     * @param string               $prefix              A prefix to apply to the name of fields generated by this provider
     * @param string|string[]|null $targetQueryTypes    A list of GraphQL types to add the resolver queries to
     * @param string|string[]|null $targetMutationTypes A list of GraphQL types to add the resolver mutations to
     */
    public function __construct(string $prefix = null, $targetQueryTypes = null, $targetMutationTypes = null)
    {
        $this->prefix = $prefix;
        $this->targetQueryTypes = is_string($targetQueryTypes) ? [$targetQueryTypes] : $targetQueryTypes;
        $this->targetMutationTypes = is_string($targetMutationTypes) ? [$targetMutationTypes] : $targetMutationTypes;
    }
}
