<?php
/*
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the MIT license.
 */

namespace ProxyManagerTest\Factory\RemoteObject\Adapter;

use PHPUnit_Framework_TestCase;
use ProxyManager\Factory\RemoteObject\Adapter\XmlRpc;

/**
 * Tests for {@see \ProxyManager\Factory\RemoteObject\Adapter\XmlRpc}
 *
 * @author Vincent Blanchon <blanchon.vincent@gmail.com>
 * @license MIT
 */
class XmlRpcTest extends PHPUnit_Framework_TestCase
{
    /**
     * {@inheritDoc}
     *
     * @covers \ProxyManager\Factory\RemoteObject\Adapter\XmlRpc::__construct
     */
    public function testCanBuildAdapterWithXmlRpcClient()
    {
        $client = $this
            ->getMockBuilder('Zend\Server\Client')
            ->setMethods(array('call'))
            ->getMock();

        $adapter = new XmlRpc($client);

        $client
            ->expects($this->once())
            ->method('call')
            ->with('foo.bar', array('tab' => 'taz'))
            ->will($this->returnValue('baz'));

        $this->assertSame('baz', $adapter->call('foo', 'bar', array('tab' => 'taz')));
    }
}
