<?php

declare(strict_types=1);

namespace ProxyManager\Generator;

use ReflectionClass;
use function strtolower;

/**
 * Method generator for magic methods
 *
 * @psalm-external-mutation-free
 */
class MagicMethodGenerator extends MethodGenerator
{
    /**
     * @param mixed[] $parameters
     */
    public function __construct(ReflectionClass $originalClass, string $name, array $parameters = [])
    {
        parent::__construct(
            $name,
            $parameters,
            self::FLAG_PUBLIC
        );

        $this->setReturnsReference(strtolower($name) === '__get');

        if (! $originalClass->hasMethod($name)) {
            return;
        }

        $this->setReturnsReference($originalClass->getMethod($name)->returnsReference());
    }
}
