<?php

namespace PhpParser\NodeVisitor;

use PhpParser\Node;
use PhpParser\Node\Expr;
use PhpParser\NodeTraverser;
use PHPUnit\Framework\TestCase;

class FirstFindingVisitorTest extends TestCase
{
    public function testFindFirstVariable() {
        $traverser = new NodeTraverser();
        $visitor = new FirstFindingVisitor(function(Node $node) {
            return $node instanceof Node\Expr\Variable;
        });
        $traverser->addVisitor($visitor);

        $assign = new Expr\Assign(new Expr\Variable('a'), new Expr\Variable('b'));
        $stmts = [new Node\Stmt\Expression($assign)];

        $traverser->traverse($stmts);
        $this->assertSame($assign->var, $visitor->getFoundNode());
    }

    public function testFindNone() {
        $traverser = new NodeTraverser();
        $visitor = new FirstFindingVisitor(function(Node $node) {
            return $node instanceof Node\Expr\BinaryOp;
        });
        $traverser->addVisitor($visitor);

        $assign = new Expr\Assign(new Expr\Variable('a'), new Expr\Variable('b'));
        $stmts = [new Node\Stmt\Expression($assign)];

        $traverser->traverse($stmts);
        $this->assertSame(null, $visitor->getFoundNode());
    }
}
