Nette Utility Classes
=====================

[![Downloads this Month](https://img.shields.io/packagist/dm/nette/utils.svg)](https://packagist.org/packages/nette/utils)
[![Build Status](https://travis-ci.org/nette/utils.svg?branch=master)](https://travis-ci.org/nette/utils)
[![Coverage Status](https://coveralls.io/repos/github/nette/utils/badge.svg?branch=master)](https://coveralls.io/github/nette/utils?branch=master)
[![Latest Stable Version](https://poser.pugx.org/nette/utils/v/stable)](https://github.com/nette/utils/releases)
[![License](https://img.shields.io/badge/license-New%20BSD-blue.svg)](https://github.com/nette/utils/blob/master/license.md)


Introduction
------------

In package nette/utils you will find a set of useful classes for everyday use:

- [Arrays](https://doc.nette.org/arrays) - manipulate arrays
- [Callback](https://doc.nette.org/callback) - PHP callbacks
- [Date and Time](https://doc.nette.org/datetime) - modify times and dates
- [Filesystem](https://doc.nette.org/filesystem) - copying, renaming, …
- [HTML elements](https://doc.nette.org/html-elements) - generate HTML
- [Images](https://doc.nette.org/images) - crop, resize, rotate images
- [JSON](https://doc.nette.org/json) - encoding and decoding
- [Generating Random Strings](https://doc.nette.org/random)
- [Pagination](https://doc.nette.org/pagination) - comfort pagination
- [Strings](https://doc.nette.org/strings) - useful text transpilers
- [SmartObject](https://doc.nette.org/smartobject) - PHP Object Enhancements
- [Validation](https://doc.nette.org/validators) - validate inputs

Documentation can be found on the [website](https://doc.nette.org/utils).


Installation
------------

The recommended way to install is via Composer:

```
composer require nette/utils
```

It requires PHP version 5.6 and supports PHP up to 7.3. The dev-master version requires PHP 7.1.
