Nette Utility Classes
=====================

Introduction
------------

In package nette/utils you will find a set of [useful classes](https://doc.nette.org/utils) for everyday use:

- [Arrays](https://doc.nette.org/arrays) - manipulate arrays
- [Callback](https://doc.nette.org/callback) - PHP callbacks
- [Date and Time](https://doc.nette.org/datetime) - modify times and dates
- [Filesystem](https://doc.nette.org/filesystem) - copying, renaming, …
- [Helper Functions](https://doc.nette.org/helpers)
- [HTML elements](https://doc.nette.org/html-elements) - generate HTML
- [Images](https://doc.nette.org/images) - crop, resize, rotate images
- [JSON](https://doc.nette.org/json) - encoding and decoding
- [Generating Random Strings](https://doc.nette.org/random)
- [Paginator](https://doc.nette.org/paginator) - pagination math
- [PHP Reflection](https://doc.nette.org/reflection)
- [Strings](https://doc.nette.org/strings) - useful text functions
- [SmartObject](https://doc.nette.org/smartobject) - PHP object enhancements
- [Validation](https://doc.nette.org/validators) - validate inputs
- [Type](https://doc.nette.org/type) - PHP data type


Installation
------------

The recommended way to install is via Composer:

```
composer require nette/utils
```

- Nette Utils 3.1 is compatible with PHP 7.1 to 8.0
- Nette Utils 3.0 is compatible with PHP 7.1 to 8.0
- Nette Utils 2.5 is compatible with PHP 5.6 to 8.0
