<?php

namespace Carbon;

use DateTimeInterface;
use JsonSerializable;

/**
 * Common interface for Carbon and CarbonImmutable.
 *
 * <autodoc generated by `composer phpdoc`>
 *
 * @property      int            $year
 * @property      int            $yearIso
 * @property      int            $month
 * @property      int            $day
 * @property      int            $hour
 * @property      int            $minute
 * @property      int            $second
 * @property      int            $micro
 * @property      int            $microsecond
 * @property      int            $timestamp                                                                          seconds since the Unix Epoch
 * @property      string         $englishDayOfWeek                                                                   the day of week in English
 * @property      string         $shortEnglishDayOfWeek                                                              the abbreviated day of week in English
 * @property      string         $englishMonth                                                                       the day of week in English
 * @property      string         $shortEnglishMonth                                                                  the abbreviated day of week in English
 * @property      string         $localeDayOfWeek                                                                    the day of week in current locale LC_TIME
 * @property      string         $shortLocaleDayOfWeek                                                               the abbreviated day of week in current locale LC_TIME
 * @property      string         $localeMonth                                                                        the month in current locale LC_TIME
 * @property      string         $shortLocaleMonth                                                                   the abbreviated month in current locale LC_TIME
 * @property      int            $milliseconds
 * @property      int            $millisecond
 * @property      int            $milli
 * @property      int            $week                                                                               1 through 53
 * @property      int            $isoWeek                                                                            1 through 53
 * @property      int            $weekYear                                                                           year according to week format
 * @property      int            $isoWeekYear                                                                        year according to ISO week format
 * @property      int            $dayOfYear                                                                          1 through 366
 * @property      int            $age                                                                                does a diffInYears() with default parameters
 * @property      int            $offset                                                                             the timezone offset in seconds from UTC
 * @property      int            $offsetMinutes                                                                      the timezone offset in minutes from UTC
 * @property      int            $offsetHours                                                                        the timezone offset in hours from UTC
 * @property      CarbonTimeZone $timezone                                                                           the current timezone
 * @property      CarbonTimeZone $tz                                                                                 alias of $timezone
 * @property-read int            $dayOfWeek                                                                          0 (for Sunday) through 6 (for Saturday)
 * @property-read int            $dayOfWeekIso                                                                       1 (for Monday) through 7 (for Sunday)
 * @property-read int            $weekOfYear                                                                         ISO-8601 week number of year, weeks starting on Monday
 * @property-read int            $daysInMonth                                                                        number of days in the given month
 * @property-read string         $latinMeridiem                                                                      "am"/"pm" (Ante meridiem or Post meridiem latin lowercase mark)
 * @property-read string         $latinUpperMeridiem                                                                 "AM"/"PM" (Ante meridiem or Post meridiem latin uppercase mark)
 * @property-read string         $dayName                                                                            long name of weekday translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $shortDayName                                                                       short name of weekday translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $minDayName                                                                         very short name of weekday translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $monthName                                                                          long name of month translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $shortMonthName                                                                     short name of month translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $meridiem                                                                           lowercase meridiem mark translated according to Carbon locale, in latin if no translation available for current language
 * @property-read string         $upperMeridiem                                                                      uppercase meridiem mark translated according to Carbon locale, in latin if no translation available for current language
 * @property-read int            $noZeroHour                                                                         current hour from 1 to 24
 * @property-read int            $weeksInYear                                                                        51 through 53
 * @property-read int            $isoWeeksInYear                                                                     51 through 53
 * @property-read int            $weekOfMonth                                                                        1 through 5
 * @property-read int            $weekNumberInMonth                                                                  1 through 5
 * @property-read int            $firstWeekDay                                                                       0 through 6
 * @property-read int            $lastWeekDay                                                                        0 through 6
 * @property-read int            $daysInYear                                                                         365 or 366
 * @property-read int            $quarter                                                                            the quarter of this instance, 1 - 4
 * @property-read int            $decade                                                                             the decade of this instance
 * @property-read int            $century                                                                            the century of this instance
 * @property-read int            $millennium                                                                         the millennium of this instance
 * @property-read bool           $dst                                                                                daylight savings time indicator, true if DST, false otherwise
 * @property-read bool           $local                                                                              checks if the timezone is local, true if local, false otherwise
 * @property-read bool           $utc                                                                                checks if the timezone is UTC, true if UTC, false otherwise
 * @property-read string         $timezoneName                                                                       the current timezone name
 * @property-read string         $tzName                                                                             alias of $timezoneName
 * @property-read string         $timezoneAbbreviatedName                                                            the current timezone abbreviated name
 * @property-read string         $tzAbbrName                                                                         alias of $timezoneAbbreviatedName
 * @property-read string         $locale                                                                             locale of the current instance
 *
 * @method        string         format($format)                                                                     call \DateTime::format if mutable or \DateTimeImmutable::format else.
 *                                                                                                                   http://php.net/manual/en/datetime.format.php
 * @method        static         modify($modify)                                                                     call \DateTime::modify if mutable or \DateTimeImmutable::modify else.
 *                                                                                                                   http://php.net/manual/en/datetime.modify.php
 * @method        int            getOffset()                                                                         call \DateTime::getOffset if mutable or \DateTimeImmutable::getOffset else.
 *                                                                                                                   http://php.net/manual/en/datetime.getoffset.php
 * @method        int            getTimestamp()                                                                      call \DateTime::getTimestamp if mutable or \DateTimeImmutable::getTimestamp else.
 *                                                                                                                   http://php.net/manual/en/datetime.gettimestamp.php
 * @method        static         setTime($hour, $minute, $second = 0, $microseconds = 0)                             call \DateTime::setTime if mutable or \DateTimeImmutable::setTime else.
 *                                                                                                                   http://php.net/manual/en/datetime.settime.php
 * @method        static         setISODate($year, $week, $day = 1)                                                  call \DateTime::setISODate if mutable or \DateTimeImmutable::setISODate else.
 *                                                                                                                   http://php.net/manual/en/datetime.setisodate.php
 * @method        static         setTimestamp($unixtimestamp)                                                        call \DateTime::setTimestamp if mutable or \DateTimeImmutable::setTimestamp else.
 *                                                                                                                   http://php.net/manual/en/datetime.settimestamp.php
 * @method        \DateInterval  diff($object, $absolute = true)                                                     call \DateTime::diff if mutable or \DateTimeImmutable::diff else.
 *                                                                                                                   http://php.net/manual/en/datetime.diff.php
 * @method        bool           isUtc()                                                                             Check if the current instance has UTC timezone.
 * @method        bool           isUTC()                                                                             Check if the current instance has UTC timezone.
 * @method        bool           isLocal()                                                                           Check if the current instance has non-UTC timezone.
 * @method        bool           isValid()                                                                           Check if the current instance is a valid date.
 * @method        bool           isDST()                                                                             Check if the current instance is in a daylight saving time.
 * @method        bool           isSunday()                                                                          Checks if the instance day is sunday.
 * @method        bool           isMonday()                                                                          Checks if the instance day is monday.
 * @method        bool           isTuesday()                                                                         Checks if the instance day is tuesday.
 * @method        bool           isWednesday()                                                                       Checks if the instance day is wednesday.
 * @method        bool           isThursday()                                                                        Checks if the instance day is thursday.
 * @method        bool           isFriday()                                                                          Checks if the instance day is friday.
 * @method        bool           isSaturday()                                                                        Checks if the instance day is saturday.
 * @method        bool           isSameYear(\DateTimeInterface $date = null)                                         Checks if the given date is in the same year as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentYear()                                                                     Checks if the instance is in the same year as the current moment.
 * @method        bool           isNextYear()                                                                        Checks if the instance is in the same year as the current moment next year.
 * @method        bool           isLastYear()                                                                        Checks if the instance is in the same year as the current moment last year.
 * @method        bool           isSameWeek(\DateTimeInterface $date = null)                                         Checks if the given date is in the same week as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentWeek()                                                                     Checks if the instance is in the same week as the current moment.
 * @method        bool           isNextWeek()                                                                        Checks if the instance is in the same week as the current moment next week.
 * @method        bool           isLastWeek()                                                                        Checks if the instance is in the same week as the current moment last week.
 * @method        bool           isSameDay(\DateTimeInterface $date = null)                                          Checks if the given date is in the same day as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentDay()                                                                      Checks if the instance is in the same day as the current moment.
 * @method        bool           isNextDay()                                                                         Checks if the instance is in the same day as the current moment next day.
 * @method        bool           isLastDay()                                                                         Checks if the instance is in the same day as the current moment last day.
 * @method        bool           isSameHour(\DateTimeInterface $date = null)                                         Checks if the given date is in the same hour as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentHour()                                                                     Checks if the instance is in the same hour as the current moment.
 * @method        bool           isNextHour()                                                                        Checks if the instance is in the same hour as the current moment next hour.
 * @method        bool           isLastHour()                                                                        Checks if the instance is in the same hour as the current moment last hour.
 * @method        bool           isSameMinute(\DateTimeInterface $date = null)                                       Checks if the given date is in the same minute as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMinute()                                                                   Checks if the instance is in the same minute as the current moment.
 * @method        bool           isNextMinute()                                                                      Checks if the instance is in the same minute as the current moment next minute.
 * @method        bool           isLastMinute()                                                                      Checks if the instance is in the same minute as the current moment last minute.
 * @method        bool           isSameSecond(\DateTimeInterface $date = null)                                       Checks if the given date is in the same second as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentSecond()                                                                   Checks if the instance is in the same second as the current moment.
 * @method        bool           isNextSecond()                                                                      Checks if the instance is in the same second as the current moment next second.
 * @method        bool           isLastSecond()                                                                      Checks if the instance is in the same second as the current moment last second.
 * @method        bool           isSameMicro(\DateTimeInterface $date = null)                                        Checks if the given date is in the same micro as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMicro()                                                                    Checks if the instance is in the same micro as the current moment.
 * @method        bool           isNextMicro()                                                                       Checks if the instance is in the same micro as the current moment next micro.
 * @method        bool           isLastMicro()                                                                       Checks if the instance is in the same micro as the current moment last micro.
 * @method        bool           isSameMicrosecond(\DateTimeInterface $date = null)                                  Checks if the given date is in the same microsecond as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMicrosecond()                                                              Checks if the instance is in the same microsecond as the current moment.
 * @method        bool           isNextMicrosecond()                                                                 Checks if the instance is in the same microsecond as the current moment next microsecond.
 * @method        bool           isLastMicrosecond()                                                                 Checks if the instance is in the same microsecond as the current moment last microsecond.
 * @method        bool           isCurrentMonth()                                                                    Checks if the instance is in the same month as the current moment.
 * @method        bool           isNextMonth()                                                                       Checks if the instance is in the same month as the current moment next month.
 * @method        bool           isLastMonth()                                                                       Checks if the instance is in the same month as the current moment last month.
 * @method        bool           isCurrentQuarter()                                                                  Checks if the instance is in the same quarter as the current moment.
 * @method        bool           isNextQuarter()                                                                     Checks if the instance is in the same quarter as the current moment next quarter.
 * @method        bool           isLastQuarter()                                                                     Checks if the instance is in the same quarter as the current moment last quarter.
 * @method        bool           isSameDecade(\DateTimeInterface $date = null)                                       Checks if the given date is in the same decade as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentDecade()                                                                   Checks if the instance is in the same decade as the current moment.
 * @method        bool           isNextDecade()                                                                      Checks if the instance is in the same decade as the current moment next decade.
 * @method        bool           isLastDecade()                                                                      Checks if the instance is in the same decade as the current moment last decade.
 * @method        bool           isSameCentury(\DateTimeInterface $date = null)                                      Checks if the given date is in the same century as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentCentury()                                                                  Checks if the instance is in the same century as the current moment.
 * @method        bool           isNextCentury()                                                                     Checks if the instance is in the same century as the current moment next century.
 * @method        bool           isLastCentury()                                                                     Checks if the instance is in the same century as the current moment last century.
 * @method        bool           isSameMillennium(\DateTimeInterface $date = null)                                   Checks if the given date is in the same millennium as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMillennium()                                                               Checks if the instance is in the same millennium as the current moment.
 * @method        bool           isNextMillennium()                                                                  Checks if the instance is in the same millennium as the current moment next millennium.
 * @method        bool           isLastMillennium()                                                                  Checks if the instance is in the same millennium as the current moment last millennium.
 * @method        $this          years(int $value)                                                                   Set current instance year to the given value.
 * @method        $this          year(int $value)                                                                    Set current instance year to the given value.
 * @method        $this          setYears(int $value)                                                                Set current instance year to the given value.
 * @method        $this          setYear(int $value)                                                                 Set current instance year to the given value.
 * @method        $this          months(int $value)                                                                  Set current instance month to the given value.
 * @method        $this          month(int $value)                                                                   Set current instance month to the given value.
 * @method        $this          setMonths(int $value)                                                               Set current instance month to the given value.
 * @method        $this          setMonth(int $value)                                                                Set current instance month to the given value.
 * @method        $this          days(int $value)                                                                    Set current instance day to the given value.
 * @method        $this          day(int $value)                                                                     Set current instance day to the given value.
 * @method        $this          setDays(int $value)                                                                 Set current instance day to the given value.
 * @method        $this          setDay(int $value)                                                                  Set current instance day to the given value.
 * @method        $this          hours(int $value)                                                                   Set current instance hour to the given value.
 * @method        $this          hour(int $value)                                                                    Set current instance hour to the given value.
 * @method        $this          setHours(int $value)                                                                Set current instance hour to the given value.
 * @method        $this          setHour(int $value)                                                                 Set current instance hour to the given value.
 * @method        $this          minutes(int $value)                                                                 Set current instance minute to the given value.
 * @method        $this          minute(int $value)                                                                  Set current instance minute to the given value.
 * @method        $this          setMinutes(int $value)                                                              Set current instance minute to the given value.
 * @method        $this          setMinute(int $value)                                                               Set current instance minute to the given value.
 * @method        $this          seconds(int $value)                                                                 Set current instance second to the given value.
 * @method        $this          second(int $value)                                                                  Set current instance second to the given value.
 * @method        $this          setSeconds(int $value)                                                              Set current instance second to the given value.
 * @method        $this          setSecond(int $value)                                                               Set current instance second to the given value.
 * @method        $this          micros(int $value)                                                                  Set current instance micro to the given value.
 * @method        $this          micro(int $value)                                                                   Set current instance micro to the given value.
 * @method        $this          setMicros(int $value)                                                               Set current instance micro to the given value.
 * @method        $this          setMicro(int $value)                                                                Set current instance micro to the given value.
 * @method        $this          microseconds(int $value)                                                            Set current instance microsecond to the given value.
 * @method        $this          microsecond(int $value)                                                             Set current instance microsecond to the given value.
 * @method        $this          setMicroseconds(int $value)                                                         Set current instance microsecond to the given value.
 * @method        $this          setMicrosecond(int $value)                                                          Set current instance microsecond to the given value.
 * @method        $this          addYears(int $value = 1)                                                            Add years (the $value count passed in) to the instance (using date interval).
 * @method        $this          addYear()                                                                           Add one year to the instance (using date interval).
 * @method        $this          subYears(int $value = 1)                                                            Sub years (the $value count passed in) to the instance (using date interval).
 * @method        $this          subYear()                                                                           Sub one year to the instance (using date interval).
 * @method        $this          addYearsWithOverflow(int $value = 1)                                                Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addYearWithOverflow()                                                               Add one year to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subYearsWithOverflow(int $value = 1)                                                Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subYearWithOverflow()                                                               Sub one year to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addYearsWithoutOverflow(int $value = 1)                                             Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearWithoutOverflow()                                                            Add one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearsWithoutOverflow(int $value = 1)                                             Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearWithoutOverflow()                                                            Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearsWithNoOverflow(int $value = 1)                                              Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearWithNoOverflow()                                                             Add one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearsWithNoOverflow(int $value = 1)                                              Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearWithNoOverflow()                                                             Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearsNoOverflow(int $value = 1)                                                  Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearNoOverflow()                                                                 Add one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearsNoOverflow(int $value = 1)                                                  Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearNoOverflow()                                                                 Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonths(int $value = 1)                                                           Add months (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMonth()                                                                          Add one month to the instance (using date interval).
 * @method        $this          subMonths(int $value = 1)                                                           Sub months (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMonth()                                                                          Sub one month to the instance (using date interval).
 * @method        $this          addMonthsWithOverflow(int $value = 1)                                               Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addMonthWithOverflow()                                                              Add one month to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subMonthsWithOverflow(int $value = 1)                                               Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subMonthWithOverflow()                                                              Sub one month to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addMonthsWithoutOverflow(int $value = 1)                                            Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthWithoutOverflow()                                                           Add one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthsWithoutOverflow(int $value = 1)                                            Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthWithoutOverflow()                                                           Sub one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthsWithNoOverflow(int $value = 1)                                             Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthWithNoOverflow()                                                            Add one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthsWithNoOverflow(int $value = 1)                                             Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthWithNoOverflow()                                                            Sub one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthsNoOverflow(int $value = 1)                                                 Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthNoOverflow()                                                                Add one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthsNoOverflow(int $value = 1)                                                 Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthNoOverflow()                                                                Sub one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDays(int $value = 1)                                                             Add days (the $value count passed in) to the instance (using date interval).
 * @method        $this          addDay()                                                                            Add one day to the instance (using date interval).
 * @method        $this          subDays(int $value = 1)                                                             Sub days (the $value count passed in) to the instance (using date interval).
 * @method        $this          subDay()                                                                            Sub one day to the instance (using date interval).
 * @method        $this          addHours(int $value = 1)                                                            Add hours (the $value count passed in) to the instance (using date interval).
 * @method        $this          addHour()                                                                           Add one hour to the instance (using date interval).
 * @method        $this          subHours(int $value = 1)                                                            Sub hours (the $value count passed in) to the instance (using date interval).
 * @method        $this          subHour()                                                                           Sub one hour to the instance (using date interval).
 * @method        $this          addMinutes(int $value = 1)                                                          Add minutes (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMinute()                                                                         Add one minute to the instance (using date interval).
 * @method        $this          subMinutes(int $value = 1)                                                          Sub minutes (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMinute()                                                                         Sub one minute to the instance (using date interval).
 * @method        $this          addSeconds(int $value = 1)                                                          Add seconds (the $value count passed in) to the instance (using date interval).
 * @method        $this          addSecond()                                                                         Add one second to the instance (using date interval).
 * @method        $this          subSeconds(int $value = 1)                                                          Sub seconds (the $value count passed in) to the instance (using date interval).
 * @method        $this          subSecond()                                                                         Sub one second to the instance (using date interval).
 * @method        $this          addMicros(int $value = 1)                                                           Add micros (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMicro()                                                                          Add one micro to the instance (using date interval).
 * @method        $this          subMicros(int $value = 1)                                                           Sub micros (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMicro()                                                                          Sub one micro to the instance (using date interval).
 * @method        $this          addMicroseconds(int $value = 1)                                                     Add microseconds (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMicrosecond()                                                                    Add one microsecond to the instance (using date interval).
 * @method        $this          subMicroseconds(int $value = 1)                                                     Sub microseconds (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMicrosecond()                                                                    Sub one microsecond to the instance (using date interval).
 * @method        $this          addMillennia(int $value = 1)                                                        Add millennia (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMillennium()                                                                     Add one millennium to the instance (using date interval).
 * @method        $this          subMillennia(int $value = 1)                                                        Sub millennia (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMillennium()                                                                     Sub one millennium to the instance (using date interval).
 * @method        $this          addMillenniaWithOverflow(int $value = 1)                                            Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addMillenniumWithOverflow()                                                         Add one millennium to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subMillenniaWithOverflow(int $value = 1)                                            Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subMillenniumWithOverflow()                                                         Sub one millennium to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addMillenniaWithoutOverflow(int $value = 1)                                         Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniumWithoutOverflow()                                                      Add one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniaWithoutOverflow(int $value = 1)                                         Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniumWithoutOverflow()                                                      Sub one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniaWithNoOverflow(int $value = 1)                                          Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniumWithNoOverflow()                                                       Add one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniaWithNoOverflow(int $value = 1)                                          Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniumWithNoOverflow()                                                       Sub one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniaNoOverflow(int $value = 1)                                              Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniumNoOverflow()                                                           Add one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniaNoOverflow(int $value = 1)                                              Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniumNoOverflow()                                                           Sub one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturies(int $value = 1)                                                        Add centuries (the $value count passed in) to the instance (using date interval).
 * @method        $this          addCentury()                                                                        Add one century to the instance (using date interval).
 * @method        $this          subCenturies(int $value = 1)                                                        Sub centuries (the $value count passed in) to the instance (using date interval).
 * @method        $this          subCentury()                                                                        Sub one century to the instance (using date interval).
 * @method        $this          addCenturiesWithOverflow(int $value = 1)                                            Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addCenturyWithOverflow()                                                            Add one century to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subCenturiesWithOverflow(int $value = 1)                                            Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subCenturyWithOverflow()                                                            Sub one century to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addCenturiesWithoutOverflow(int $value = 1)                                         Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturyWithoutOverflow()                                                         Add one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturiesWithoutOverflow(int $value = 1)                                         Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturyWithoutOverflow()                                                         Sub one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturiesWithNoOverflow(int $value = 1)                                          Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturyWithNoOverflow()                                                          Add one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturiesWithNoOverflow(int $value = 1)                                          Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturyWithNoOverflow()                                                          Sub one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturiesNoOverflow(int $value = 1)                                              Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturyNoOverflow()                                                              Add one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturiesNoOverflow(int $value = 1)                                              Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturyNoOverflow()                                                              Sub one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecades(int $value = 1)                                                          Add decades (the $value count passed in) to the instance (using date interval).
 * @method        $this          addDecade()                                                                         Add one decade to the instance (using date interval).
 * @method        $this          subDecades(int $value = 1)                                                          Sub decades (the $value count passed in) to the instance (using date interval).
 * @method        $this          subDecade()                                                                         Sub one decade to the instance (using date interval).
 * @method        $this          addDecadesWithOverflow(int $value = 1)                                              Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addDecadeWithOverflow()                                                             Add one decade to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subDecadesWithOverflow(int $value = 1)                                              Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subDecadeWithOverflow()                                                             Sub one decade to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addDecadesWithoutOverflow(int $value = 1)                                           Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadeWithoutOverflow()                                                          Add one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadesWithoutOverflow(int $value = 1)                                           Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadeWithoutOverflow()                                                          Sub one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadesWithNoOverflow(int $value = 1)                                            Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadeWithNoOverflow()                                                           Add one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadesWithNoOverflow(int $value = 1)                                            Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadeWithNoOverflow()                                                           Sub one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadesNoOverflow(int $value = 1)                                                Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadeNoOverflow()                                                               Add one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadesNoOverflow(int $value = 1)                                                Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadeNoOverflow()                                                               Sub one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuarters(int $value = 1)                                                         Add quarters (the $value count passed in) to the instance (using date interval).
 * @method        $this          addQuarter()                                                                        Add one quarter to the instance (using date interval).
 * @method        $this          subQuarters(int $value = 1)                                                         Sub quarters (the $value count passed in) to the instance (using date interval).
 * @method        $this          subQuarter()                                                                        Sub one quarter to the instance (using date interval).
 * @method        $this          addQuartersWithOverflow(int $value = 1)                                             Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addQuarterWithOverflow()                                                            Add one quarter to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subQuartersWithOverflow(int $value = 1)                                             Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subQuarterWithOverflow()                                                            Sub one quarter to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addQuartersWithoutOverflow(int $value = 1)                                          Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuarterWithoutOverflow()                                                         Add one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuartersWithoutOverflow(int $value = 1)                                          Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuarterWithoutOverflow()                                                         Sub one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuartersWithNoOverflow(int $value = 1)                                           Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuarterWithNoOverflow()                                                          Add one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuartersWithNoOverflow(int $value = 1)                                           Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuarterWithNoOverflow()                                                          Sub one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuartersNoOverflow(int $value = 1)                                               Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuarterNoOverflow()                                                              Add one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuartersNoOverflow(int $value = 1)                                               Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuarterNoOverflow()                                                              Sub one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addWeeks(int $value = 1)                                                            Add weeks (the $value count passed in) to the instance (using date interval).
 * @method        $this          addWeek()                                                                           Add one week to the instance (using date interval).
 * @method        $this          subWeeks(int $value = 1)                                                            Sub weeks (the $value count passed in) to the instance (using date interval).
 * @method        $this          subWeek()                                                                           Sub one week to the instance (using date interval).
 * @method        $this          addWeekdays(int $value = 1)                                                         Add weekdays (the $value count passed in) to the instance (using date interval).
 * @method        $this          addWeekday()                                                                        Add one weekday to the instance (using date interval).
 * @method        $this          subWeekdays(int $value = 1)                                                         Sub weekdays (the $value count passed in) to the instance (using date interval).
 * @method        $this          subWeekday()                                                                        Sub one weekday to the instance (using date interval).
 * @method        $this          addRealMicroseconds(int $value = 1)                                                 Add microseconds (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealMicrosecond()                                                                Add one microsecond to the instance (using timestamp).
 * @method        $this          subRealMicroseconds(int $value = 1)                                                 Sub microseconds (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealMicrosecond()                                                                Sub one microsecond to the instance (using timestamp).
 * @method        $this          addRealSeconds(int $value = 1)                                                      Add seconds (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealSecond()                                                                     Add one second to the instance (using timestamp).
 * @method        $this          subRealSeconds(int $value = 1)                                                      Sub seconds (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealSecond()                                                                     Sub one second to the instance (using timestamp).
 * @method        $this          addRealMinutes(int $value = 1)                                                      Add minutes (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealMinute()                                                                     Add one minute to the instance (using timestamp).
 * @method        $this          subRealMinutes(int $value = 1)                                                      Sub minutes (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealMinute()                                                                     Sub one minute to the instance (using timestamp).
 * @method        $this          addRealHours(int $value = 1)                                                        Add hours (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealHour()                                                                       Add one hour to the instance (using timestamp).
 * @method        $this          subRealHours(int $value = 1)                                                        Sub hours (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealHour()                                                                       Sub one hour to the instance (using timestamp).
 * @method        $this          addRealDays(int $value = 1)                                                         Add days (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealDay()                                                                        Add one day to the instance (using timestamp).
 * @method        $this          subRealDays(int $value = 1)                                                         Sub days (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealDay()                                                                        Sub one day to the instance (using timestamp).
 * @method        $this          addRealWeeks(int $value = 1)                                                        Add weeks (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealWeek()                                                                       Add one week to the instance (using timestamp).
 * @method        $this          subRealWeeks(int $value = 1)                                                        Sub weeks (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealWeek()                                                                       Sub one week to the instance (using timestamp).
 * @method        $this          addRealMonths(int $value = 1)                                                       Add months (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealMonth()                                                                      Add one month to the instance (using timestamp).
 * @method        $this          subRealMonths(int $value = 1)                                                       Sub months (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealMonth()                                                                      Sub one month to the instance (using timestamp).
 * @method        $this          addRealQuarters(int $value = 1)                                                     Add quarters (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealQuarter()                                                                    Add one quarter to the instance (using timestamp).
 * @method        $this          subRealQuarters(int $value = 1)                                                     Sub quarters (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealQuarter()                                                                    Sub one quarter to the instance (using timestamp).
 * @method        $this          addRealYears(int $value = 1)                                                        Add years (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealYear()                                                                       Add one year to the instance (using timestamp).
 * @method        $this          subRealYears(int $value = 1)                                                        Sub years (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealYear()                                                                       Sub one year to the instance (using timestamp).
 * @method        $this          addRealDecades(int $value = 1)                                                      Add decades (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealDecade()                                                                     Add one decade to the instance (using timestamp).
 * @method        $this          subRealDecades(int $value = 1)                                                      Sub decades (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealDecade()                                                                     Sub one decade to the instance (using timestamp).
 * @method        $this          addRealCenturies(int $value = 1)                                                    Add centuries (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealCentury()                                                                    Add one century to the instance (using timestamp).
 * @method        $this          subRealCenturies(int $value = 1)                                                    Sub centuries (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealCentury()                                                                    Sub one century to the instance (using timestamp).
 * @method        $this          addRealMillennia(int $value = 1)                                                    Add millennia (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealMillennium()                                                                 Add one millennium to the instance (using timestamp).
 * @method        $this          subRealMillennia(int $value = 1)                                                    Sub millennia (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealMillennium()                                                                 Sub one millennium to the instance (using timestamp).
 * @method        $this          roundYear(float $precision = 1, string $function = "round")                         Round the current instance year with given precision using the given function.
 * @method        $this          roundYears(float $precision = 1, string $function = "round")                        Round the current instance year with given precision using the given function.
 * @method        $this          floorYear(float $precision = 1)                                                     Truncate the current instance year with given precision.
 * @method        $this          floorYears(float $precision = 1)                                                    Truncate the current instance year with given precision.
 * @method        $this          ceilYear(float $precision = 1)                                                      Ceil the current instance year with given precision.
 * @method        $this          ceilYears(float $precision = 1)                                                     Ceil the current instance year with given precision.
 * @method        $this          roundMonth(float $precision = 1, string $function = "round")                        Round the current instance month with given precision using the given function.
 * @method        $this          roundMonths(float $precision = 1, string $function = "round")                       Round the current instance month with given precision using the given function.
 * @method        $this          floorMonth(float $precision = 1)                                                    Truncate the current instance month with given precision.
 * @method        $this          floorMonths(float $precision = 1)                                                   Truncate the current instance month with given precision.
 * @method        $this          ceilMonth(float $precision = 1)                                                     Ceil the current instance month with given precision.
 * @method        $this          ceilMonths(float $precision = 1)                                                    Ceil the current instance month with given precision.
 * @method        $this          roundDay(float $precision = 1, string $function = "round")                          Round the current instance day with given precision using the given function.
 * @method        $this          roundDays(float $precision = 1, string $function = "round")                         Round the current instance day with given precision using the given function.
 * @method        $this          floorDay(float $precision = 1)                                                      Truncate the current instance day with given precision.
 * @method        $this          floorDays(float $precision = 1)                                                     Truncate the current instance day with given precision.
 * @method        $this          ceilDay(float $precision = 1)                                                       Ceil the current instance day with given precision.
 * @method        $this          ceilDays(float $precision = 1)                                                      Ceil the current instance day with given precision.
 * @method        $this          roundHour(float $precision = 1, string $function = "round")                         Round the current instance hour with given precision using the given function.
 * @method        $this          roundHours(float $precision = 1, string $function = "round")                        Round the current instance hour with given precision using the given function.
 * @method        $this          floorHour(float $precision = 1)                                                     Truncate the current instance hour with given precision.
 * @method        $this          floorHours(float $precision = 1)                                                    Truncate the current instance hour with given precision.
 * @method        $this          ceilHour(float $precision = 1)                                                      Ceil the current instance hour with given precision.
 * @method        $this          ceilHours(float $precision = 1)                                                     Ceil the current instance hour with given precision.
 * @method        $this          roundMinute(float $precision = 1, string $function = "round")                       Round the current instance minute with given precision using the given function.
 * @method        $this          roundMinutes(float $precision = 1, string $function = "round")                      Round the current instance minute with given precision using the given function.
 * @method        $this          floorMinute(float $precision = 1)                                                   Truncate the current instance minute with given precision.
 * @method        $this          floorMinutes(float $precision = 1)                                                  Truncate the current instance minute with given precision.
 * @method        $this          ceilMinute(float $precision = 1)                                                    Ceil the current instance minute with given precision.
 * @method        $this          ceilMinutes(float $precision = 1)                                                   Ceil the current instance minute with given precision.
 * @method        $this          roundSecond(float $precision = 1, string $function = "round")                       Round the current instance second with given precision using the given function.
 * @method        $this          roundSeconds(float $precision = 1, string $function = "round")                      Round the current instance second with given precision using the given function.
 * @method        $this          floorSecond(float $precision = 1)                                                   Truncate the current instance second with given precision.
 * @method        $this          floorSeconds(float $precision = 1)                                                  Truncate the current instance second with given precision.
 * @method        $this          ceilSecond(float $precision = 1)                                                    Ceil the current instance second with given precision.
 * @method        $this          ceilSeconds(float $precision = 1)                                                   Ceil the current instance second with given precision.
 * @method        $this          roundMillennium(float $precision = 1, string $function = "round")                   Round the current instance millennium with given precision using the given function.
 * @method        $this          roundMillennia(float $precision = 1, string $function = "round")                    Round the current instance millennium with given precision using the given function.
 * @method        $this          floorMillennium(float $precision = 1)                                               Truncate the current instance millennium with given precision.
 * @method        $this          floorMillennia(float $precision = 1)                                                Truncate the current instance millennium with given precision.
 * @method        $this          ceilMillennium(float $precision = 1)                                                Ceil the current instance millennium with given precision.
 * @method        $this          ceilMillennia(float $precision = 1)                                                 Ceil the current instance millennium with given precision.
 * @method        $this          roundCentury(float $precision = 1, string $function = "round")                      Round the current instance century with given precision using the given function.
 * @method        $this          roundCenturies(float $precision = 1, string $function = "round")                    Round the current instance century with given precision using the given function.
 * @method        $this          floorCentury(float $precision = 1)                                                  Truncate the current instance century with given precision.
 * @method        $this          floorCenturies(float $precision = 1)                                                Truncate the current instance century with given precision.
 * @method        $this          ceilCentury(float $precision = 1)                                                   Ceil the current instance century with given precision.
 * @method        $this          ceilCenturies(float $precision = 1)                                                 Ceil the current instance century with given precision.
 * @method        $this          roundDecade(float $precision = 1, string $function = "round")                       Round the current instance decade with given precision using the given function.
 * @method        $this          roundDecades(float $precision = 1, string $function = "round")                      Round the current instance decade with given precision using the given function.
 * @method        $this          floorDecade(float $precision = 1)                                                   Truncate the current instance decade with given precision.
 * @method        $this          floorDecades(float $precision = 1)                                                  Truncate the current instance decade with given precision.
 * @method        $this          ceilDecade(float $precision = 1)                                                    Ceil the current instance decade with given precision.
 * @method        $this          ceilDecades(float $precision = 1)                                                   Ceil the current instance decade with given precision.
 * @method        $this          roundQuarter(float $precision = 1, string $function = "round")                      Round the current instance quarter with given precision using the given function.
 * @method        $this          roundQuarters(float $precision = 1, string $function = "round")                     Round the current instance quarter with given precision using the given function.
 * @method        $this          floorQuarter(float $precision = 1)                                                  Truncate the current instance quarter with given precision.
 * @method        $this          floorQuarters(float $precision = 1)                                                 Truncate the current instance quarter with given precision.
 * @method        $this          ceilQuarter(float $precision = 1)                                                   Ceil the current instance quarter with given precision.
 * @method        $this          ceilQuarters(float $precision = 1)                                                  Ceil the current instance quarter with given precision.
 * @method        $this          roundMillisecond(float $precision = 1, string $function = "round")                  Round the current instance millisecond with given precision using the given function.
 * @method        $this          roundMilliseconds(float $precision = 1, string $function = "round")                 Round the current instance millisecond with given precision using the given function.
 * @method        $this          floorMillisecond(float $precision = 1)                                              Truncate the current instance millisecond with given precision.
 * @method        $this          floorMilliseconds(float $precision = 1)                                             Truncate the current instance millisecond with given precision.
 * @method        $this          ceilMillisecond(float $precision = 1)                                               Ceil the current instance millisecond with given precision.
 * @method        $this          ceilMilliseconds(float $precision = 1)                                              Ceil the current instance millisecond with given precision.
 * @method        $this          roundMicrosecond(float $precision = 1, string $function = "round")                  Round the current instance microsecond with given precision using the given function.
 * @method        $this          roundMicroseconds(float $precision = 1, string $function = "round")                 Round the current instance microsecond with given precision using the given function.
 * @method        $this          floorMicrosecond(float $precision = 1)                                              Truncate the current instance microsecond with given precision.
 * @method        $this          floorMicroseconds(float $precision = 1)                                             Truncate the current instance microsecond with given precision.
 * @method        $this          ceilMicrosecond(float $precision = 1)                                               Ceil the current instance microsecond with given precision.
 * @method        $this          ceilMicroseconds(float $precision = 1)                                              Ceil the current instance microsecond with given precision.
 * @method        string         shortAbsoluteDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)        Get the difference (short format, 'Absolute' mode) in a human readable format in the current locale.
 * @method        string         shortAbsoluteDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)        Get the difference (short format, 'Absolute' mode) in a human readable format in the current locale.
 * @method        string         longAbsoluteDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)         Get the difference (long format, 'Absolute' mode) in a human readable format in the current locale.
 * @method        string         longAbsoluteDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)         Get the difference (long format, 'Absolute' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)        Get the difference (short format, 'Relative' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)        Get the difference (short format, 'Relative' mode) in a human readable format in the current locale.
 * @method        string         longRelativeDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)         Get the difference (long format, 'Relative' mode) in a human readable format in the current locale.
 * @method        string         longRelativeDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)         Get the difference (long format, 'Relative' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeToNowDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)   Get the difference (short format, 'RelativeToNow' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeToNowDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)   Get the difference (short format, 'RelativeToNow' mode) in a human readable format in the current locale.
 * @method        string         longRelativeToNowDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)    Get the difference (long format, 'RelativeToNow' mode) in a human readable format in the current locale.
 * @method        string         longRelativeToNowDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)    Get the difference (long format, 'RelativeToNow' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeToOtherDiffForHumans(\DateTimeInterface $other = null, int $parts = 1) Get the difference (short format, 'RelativeToOther' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeToOtherDiffForHumans(int $parts = 1, \DateTimeInterface $other = null) Get the difference (short format, 'RelativeToOther' mode) in a human readable format in the current locale.
 * @method        string         longRelativeToOtherDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)  Get the difference (long format, 'RelativeToOther' mode) in a human readable format in the current locale.
 * @method        string         longRelativeToOtherDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)  Get the difference (long format, 'RelativeToOther' mode) in a human readable format in the current locale.
 *
 * </autodoc>
 */
interface CarbonInterface extends DateTimeInterface, JsonSerializable
{
    /**
     * Diff wording options.
     */
    public const NO_ZERO_DIFF = 01;
    public const JUST_NOW = 02;
    public const ONE_DAY_WORDS = 04;
    public const TWO_DAY_WORDS = 010;

    /**
     * Diff syntax options.
     */
    public const DIFF_ABSOLUTE = 1; // backward compatibility with true
    public const DIFF_RELATIVE_AUTO = 0; // backward compatibility with false
    public const DIFF_RELATIVE_TO_NOW = 2;
    public const DIFF_RELATIVE_TO_OTHER = 3;

    /**
     * The day constants.
     */
    public const SUNDAY = 0;
    public const MONDAY = 1;
    public const TUESDAY = 2;
    public const WEDNESDAY = 3;
    public const THURSDAY = 4;
    public const FRIDAY = 5;
    public const SATURDAY = 6;

    /**
     * Number of X in Y.
     */
    public const YEARS_PER_MILLENNIUM = 1000;
    public const YEARS_PER_CENTURY = 100;
    public const YEARS_PER_DECADE = 10;
    public const MONTHS_PER_YEAR = 12;
    public const MONTHS_PER_QUARTER = 3;
    public const WEEKS_PER_YEAR = 52;
    public const WEEKS_PER_MONTH = 4;
    public const DAYS_PER_WEEK = 7;
    public const HOURS_PER_DAY = 24;
    public const MINUTES_PER_HOUR = 60;
    public const SECONDS_PER_MINUTE = 60;
    public const MICROSECONDS_PER_SECOND = 1000000;

    /**
     * RFC7231 DateTime format.
     *
     * @var string
     */
    public const RFC7231_FORMAT = 'D, d M Y H:i:s \G\M\T';

    /**
     * Default format to use for __toString method when type juggling occurs.
     *
     * @var string
     */
    public const DEFAULT_TO_STRING_FORMAT = 'Y-m-d H:i:s';

    /**
     * Format for converting mocked time, includes microseconds.
     *
     * @var string
     */
    public const MOCK_DATETIME_FORMAT = 'Y-m-d H:i:s.u';

    // <methods>

    public function __call($method, $parameters);

    public static function __callStatic($method, $parameters);

    public function __construct($time = null, $tz = null);

    public function __get($name);

    public function __isset($name);

    public function __set($name, $value);

    public static function __set_state($dump);

    public function __sleep();

    public function __toString();

    public function add($unit, $value = 1, $overflow = null);

    public function addRealUnit($unit, $value = 1);

    public function addUnit($unit, $value = 1, $overflow = null);

    public function addUnitNoOverflow($valueUnit, $value, $overflowUnit);

    public function average($date = null);

    public function between($date1, $date2, $equal = true): bool;

    public function calendar($referenceTime = null, array $formats = []);

    public function ceil($precision = 1);

    public function ceilUnit($unit, $precision = 1);

    public function ceilWeek($weekStartsAt = null);

    public function clone();

    public function closest($date1, $date2);

    public function copy();

    public static function create($year = 0, $month = 1, $day = 1, $hour = 0, $minute = 0, $second = 0, $tz = null);

    public static function createFromDate($year = null, $month = null, $day = null, $tz = null);

    public static function createFromFormat($format, $time, $tz = null);

    public static function createFromTime($hour = 0, $minute = 0, $second = 0, $tz = null);

    public static function createFromTimeString($time, $tz = null);

    public static function createFromTimestamp($timestamp, $tz = null);

    public static function createFromTimestampMs($timestamp, $tz = null);

    public static function createFromTimestampUTC($timestamp);

    public static function createMidnightDate($year = null, $month = null, $day = null, $tz = null);

    public static function createSafe($year = null, $month = null, $day = null, $hour = null, $minute = null, $second = null, $tz = null);

    public function dayOfYear($value = null);

    public function diffAsCarbonInterval($date = null, $absolute = true);

    public function diffFiltered(\Carbon\CarbonInterval $ci, \Closure $callback, $date = null, $absolute = true);

    public function diffForHumans($other = null, $syntax = null, $short = false, $parts = 1, $options = null);

    public function diffInDays($date = null, $absolute = true);

    public function diffInDaysFiltered(\Closure $callback, $date = null, $absolute = true);

    public function diffInHours($date = null, $absolute = true);

    public function diffInHoursFiltered(\Closure $callback, $date = null, $absolute = true);

    public function diffInMicroseconds($date = null, $absolute = true);

    public function diffInMinutes($date = null, $absolute = true);

    public function diffInMonths($date = null, $absolute = true);

    public function diffInRealHours($date = null, $absolute = true);

    public function diffInRealMicroseconds($date = null, $absolute = true);

    public function diffInRealMinutes($date = null, $absolute = true);

    public function diffInRealSeconds($date = null, $absolute = true);

    public function diffInSeconds($date = null, $absolute = true);

    public function diffInWeekdays($date = null, $absolute = true);

    public function diffInWeekendDays($date = null, $absolute = true);

    public function diffInWeeks($date = null, $absolute = true);

    public function diffInYears($date = null, $absolute = true);

    public static function disableHumanDiffOption($humanDiffOption);

    public static function enableHumanDiffOption($humanDiffOption);

    public function endOf($unit, ...$params);

    public function endOfCentury();

    public function endOfDay();

    public function endOfDecade();

    public function endOfHour();

    public function endOfMillennium();

    public function endOfMinute();

    public function endOfMonth();

    public function endOfQuarter();

    public function endOfSecond();

    public function endOfWeek($weekEndsAt = null);

    public function endOfYear();

    public function eq($date): bool;

    public function equalTo($date): bool;

    public static function executeWithLocale($locale, $func);

    public function farthest($date1, $date2);

    public function firstOfMonth($dayOfWeek = null);

    public function firstOfQuarter($dayOfWeek = null);

    public function firstOfYear($dayOfWeek = null);

    public function floor($precision = 1);

    public function floorUnit($unit, $precision = 1);

    public function floorWeek($weekStartsAt = null);

    public function formatLocalized($format);

    public function from($other = null, $syntax = null, $short = false, $parts = 1, $options = null);

    public function fromNow($syntax = null, $short = false, $parts = 1, $options = null);

    public static function fromSerialized($value);

    public static function genericMacro($macro, $priority = 0);

    public function get($name);

    public static function getAvailableLocales();

    public function getCalendarFormats($locale = null);

    public static function getDays();

    public static function getHumanDiffOptions();

    public function getIsoFormats($locale = null);

    public static function getIsoUnits();

    public static function getLastErrors();

    public function getLocalTranslator();

    public static function getLocale();

    public static function getMidDayAt();

    public function getOffsetString($separator = ':');

    public function getPaddedUnit($unit, $length = 2, $padString = '0', $padType = 0);

    public function getPreciseTimestamp($precision = 6);

    public function getSettings();

    public static function getTestNow();

    public function getTranslationMessage(string $key, string $locale = null, string $default = null);

    public static function getTranslator();

    public static function getWeekEndsAt();

    public static function getWeekStartsAt();

    public static function getWeekendDays();

    public function greaterThan($date): bool;

    public function greaterThanOrEqualTo($date): bool;

    public function gt($date): bool;

    public function gte($date): bool;

    public static function hasFormat($date, $format);

    public static function hasMacro($name);

    public static function hasRelativeKeywords($time);

    public static function hasTestNow();

    public static function instance($date);

    public function isAfter($date): bool;

    public function isBefore($date): bool;

    public function isBetween($date1, $date2, $equal = true): bool;

    public function isBirthday($date = null);

    public function isCurrentUnit($unit);

    public function isDayOfWeek($dayOfWeek);

    public function isEndOfDay($checkMicroseconds = false);

    public function isFuture();

    public static function isImmutable();

    public function isLastOfMonth();

    public function isLeapYear();

    public function isLongYear();

    public function isMidday();

    public function isMidnight();

    public static function isModifiableUnit($unit);

    public static function isMutable();

    public function isPast();

    public function isSameAs($format, $date = null);

    public function isSameMonth($date = null, $ofSameYear = true);

    public function isSameQuarter($date = null, $ofSameYear = true);

    public function isSameUnit($unit, $date = null);

    public function isStartOfDay($checkMicroseconds = false);

    public static function isStrictModeEnabled();

    public function isToday();

    public function isTomorrow();

    public function isWeekday();

    public function isWeekend();

    public function isYesterday();

    public function isoFormat(string $format): string;

    public function isoWeek($week = null, $dayOfWeek = null, $dayOfYear = null);

    public function isoWeekYear($year = null, $dayOfWeek = null, $dayOfYear = null);

    public function isoWeekday($value = null);

    public function isoWeeksInYear($dayOfWeek = null, $dayOfYear = null);

    public function jsonSerialize();

    public function lastOfMonth($dayOfWeek = null);

    public function lastOfQuarter($dayOfWeek = null);

    public function lastOfYear($dayOfWeek = null);

    public function lessThan($date): bool;

    public function lessThanOrEqualTo($date): bool;

    public function locale(string $locale = null);

    public static function localeHasDiffOneDayWords($locale);

    public static function localeHasDiffSyntax($locale);

    public static function localeHasDiffTwoDayWords($locale);

    public static function localeHasPeriodSyntax($locale);

    public static function localeHasShortUnits($locale);

    public function lt($date): bool;

    public function lte($date): bool;

    public static function macro($name, $macro);

    public static function make($var);

    public function max($date = null);

    public static function maxValue();

    public function maximum($date = null);

    public function midDay();

    public function min($date = null);

    public static function minValue();

    public function minimum($date = null);

    public static function mixin($mixin);

    public function modify($modify);

    public function ne($date): bool;

    public function next($dayOfWeek = null);

    public function nextWeekday();

    public function nextWeekendDay();

    public function notEqualTo($date): bool;

    public static function now($tz = null);

    public function nowWithSameTz();

    public function nthOfMonth($nth, $dayOfWeek);

    public function nthOfQuarter($nth, $dayOfWeek);

    public function nthOfYear($nth, $dayOfWeek);

    public function ordinal(string $key, string $period = null): string;

    public static function parse($time = null, $tz = null);

    public static function pluralUnit(string $unit): string;

    public function previous($dayOfWeek = null);

    public function previousWeekday();

    public function previousWeekendDay();

    public static function resetMacros();

    public static function resetMonthsOverflow();

    public static function resetToStringFormat();

    public static function resetYearsOverflow();

    public function round($precision = 1, $function = 'round');

    public function roundUnit($unit, $precision = 1, $function = 'round');

    public function roundWeek($weekStartsAt = null);

    public function secondsSinceMidnight();

    public function secondsUntilEndOfDay();

    public function serialize();

    public static function serializeUsing($callback);

    public function set($name, $value = null);

    public function setDate($year, $month, $day);

    public function setDateFrom($date = null);

    public function setDateTime($year, $month, $day, $hour, $minute, $second = 0, $microseconds = 0);

    public function setDateTimeFrom($date = null);

    public static function setHumanDiffOptions($humanDiffOptions);

    public function setISODate($year, $week, $day);

    public function setLocalTranslator(\Symfony\Component\Translation\TranslatorInterface $translator);

    public static function setLocale($locale);

    public static function setMidDayAt($hour);

    public static function setTestNow($testNow = null);

    public function setTime($hour, $minute, $second, $microseconds);

    public function setTimeFrom($date = null);

    public function setTimeFromTimeString($time);

    public function setTimestamp($unixtimestamp);

    public function setTimezone($value);

    public static function setToStringFormat($format);

    public static function setTranslator(\Symfony\Component\Translation\TranslatorInterface $translator);

    public function setUnit($unit, $value = null);

    public function setUnitNoOverflow($valueUnit, $value, $overflowUnit);

    public static function setUtf8($utf8);

    public static function setWeekEndsAt($day);

    public static function setWeekStartsAt($day);

    public static function setWeekendDays($days);

    public function settings(array $settings);

    public function shiftTimezone($value);

    public static function shouldOverflowMonths();

    public static function shouldOverflowYears();

    public function since($other = null, $syntax = null, $short = false, $parts = 1, $options = null);

    public static function singularUnit(string $unit): string;

    public function startOf($unit, ...$params);

    public function startOfCentury();

    public function startOfDay();

    public function startOfDecade();

    public function startOfHour();

    public function startOfMillennium();

    public function startOfMinute();

    public function startOfMonth();

    public function startOfQuarter();

    public function startOfSecond();

    public function startOfWeek($weekStartsAt = null);

    public function startOfYear();

    public function sub($unit, $value = 1, $overflow = null);

    public function subRealUnit($unit, $value = 1);

    public function subUnit($unit, $value = 1, $overflow = null);

    public function subUnitNoOverflow($valueUnit, $value, $overflowUnit);

    public function subtract($unit, $value = 1, $overflow = null);

    public function timestamp($value);

    public function timezone($value);

    public function to($other = null, $syntax = null, $short = false, $parts = 1, $options = null);

    public function toArray();

    public function toAtomString();

    public function toCookieString();

    public function toDate();

    public function toDateString();

    public function toDateTime();

    public function toDateTimeLocalString();

    public function toDateTimeString();

    public function toDayDateTimeString();

    public function toFormattedDateString();

    public function toISOString($keepOffset = false);

    public function toImmutable();

    public function toIso8601String();

    public function toIso8601ZuluString();

    public function toJSON();

    public function toMutable();

    public function toNow($syntax = null, $short = false, $parts = 1, $options = null);

    public function toObject();

    public function toRfc1036String();

    public function toRfc1123String();

    public function toRfc2822String();

    public function toRfc3339String();

    public function toRfc7231String();

    public function toRfc822String();

    public function toRfc850String();

    public function toRssString();

    public function toString();

    public function toTimeString();

    public function toW3cString();

    public static function today($tz = null);

    public static function tomorrow($tz = null);

    public function translate(string $key, array $parameters = [], $number = null): string;

    public function tz($value = null);

    public function unix();

    public function until($other = null, $syntax = null, $short = false, $parts = 1, $options = null);

    public static function useMonthsOverflow($monthsOverflow = true);

    public static function useStrictMode($strictModeEnabled = true);

    public static function useYearsOverflow($yearsOverflow = true);

    public function utc();

    public function utcOffset(int $offset = null);

    public function valueOf();

    public function week($week = null, $dayOfWeek = null, $dayOfYear = null);

    public function weekYear($year = null, $dayOfWeek = null, $dayOfYear = null);

    public function weekday($value = null);

    public function weeksInYear($dayOfWeek = null, $dayOfYear = null);

    public static function yesterday($tz = null);

    // </methods>
}
