<?php

/*
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use Carbon\Carbon;

class IsTest extends TestFixture
{
   public function testIsWeekdayTrue()
   {
      $this->assertTrue(Carbon::createFromDate(2012, 1, 2)->isWeekday());
   }
   public function testIsWeekdayFalse()
   {
      $this->assertFalse(Carbon::createFromDate(2012, 1, 1)->isWeekday());
   }
   public function testIsWeekendTrue()
   {
      $this->assertTrue(Carbon::createFromDate(2012, 1, 1)->isWeekend());
   }
   public function testIsWeekendFalse()
   {
      $this->assertFalse(Carbon::createFromDate(2012, 1, 2)->isWeekend());
   }

   public function testIsYesterdayTrue()
   {
      $this->assertTrue(Carbon::now()->subDay()->isYesterday());
   }
   public function testIsYesterdayFalseWithToday()
   {
      $this->assertFalse(Carbon::now()->endOfDay()->isYesterday());
   }
   public function testIsYesterdayFalseWith2Days()
   {
      $this->assertFalse(Carbon::now()->subDays(2)->startOfDay()->isYesterday());
   }

   public function testIsTodayTrue()
   {
      $this->assertTrue(Carbon::now()->isToday());
   }
   public function testIsTodayFalseWithYesterday()
   {
      $this->assertFalse(Carbon::now()->subDay()->endOfDay()->isToday());
   }
   public function testIsTodayFalseWithTomorrow()
   {
      $this->assertFalse(Carbon::now()->addDay()->startOfDay()->isToday());
   }
   public function testIsTodayWithTimezone()
   {
      $this->assertTrue(Carbon::now('Asia/Tokyo')->isToday());
   }

   public function testIsTomorrowTrue()
   {
      $this->assertTrue(Carbon::now()->addDay()->isTomorrow());
   }
   public function testIsTomorrowFalseWithToday()
   {
      $this->assertFalse(Carbon::now()->endOfDay()->isTomorrow());
   }
   public function testIsTomorrowFalseWith2Days()
   {
      $this->assertFalse(Carbon::now()->addDays(2)->startOfDay()->isTomorrow());
   }

   public function testIsFutureTrue()
   {
      $this->assertTrue(Carbon::now()->addSecond()->isFuture());
   }
   public function testIsFutureFalse()
   {
      $this->assertFalse(Carbon::now()->isFuture());
   }
   public function testIsFutureFalseInThePast()
   {
      $this->assertFalse(Carbon::now()->subSecond()->isFuture());
   }

   public function testIsPastTrue()
   {
      $this->assertTrue(Carbon::now()->subSecond()->isPast());
   }
   public function testIsPast()
   {
      $this->assertFalse(Carbon::now()->addSecond()->isPast());
      $this->assertFalse(Carbon::now()->isPast());
   }
}
