<?php

/*
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Carbon\Traits;

use BadMethodCallException;
use Carbon\Carbon;
use Carbon\CarbonImmutable;
use Carbon\CarbonInterface;
use Carbon\CarbonInterval;
use Carbon\CarbonTimeZone;
use Carbon\Exceptions\InvalidDateException;
use Carbon\Translator;
use Closure;
use DateInterval;
use DateTime;
use DateTimeInterface;
use InvalidArgumentException;
use ReflectionException;
use Symfony\Component\Translation\TranslatorBagInterface;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * A simple API extension for DateTime.
 *
 * <autodoc generated by `composer phpdoc`>
 *
 * @property      int            $year
 * @property      int            $yearIso
 * @property      int            $month
 * @property      int            $day
 * @property      int            $hour
 * @property      int            $minute
 * @property      int            $second
 * @property      int            $micro
 * @property      int            $microsecond
 * @property      int            $timestamp                                                                          seconds since the Unix Epoch
 * @property      string         $englishDayOfWeek                                                                   the day of week in English
 * @property      string         $shortEnglishDayOfWeek                                                              the abbreviated day of week in English
 * @property      string         $englishMonth                                                                       the day of week in English
 * @property      string         $shortEnglishMonth                                                                  the abbreviated day of week in English
 * @property      string         $localeDayOfWeek                                                                    the day of week in current locale LC_TIME
 * @property      string         $shortLocaleDayOfWeek                                                               the abbreviated day of week in current locale LC_TIME
 * @property      string         $localeMonth                                                                        the month in current locale LC_TIME
 * @property      string         $shortLocaleMonth                                                                   the abbreviated month in current locale LC_TIME
 * @property      int            $milliseconds
 * @property      int            $millisecond
 * @property      int            $milli
 * @property      int            $week                                                                               1 through 53
 * @property      int            $isoWeek                                                                            1 through 53
 * @property      int            $weekYear                                                                           year according to week format
 * @property      int            $isoWeekYear                                                                        year according to ISO week format
 * @property      int            $dayOfYear                                                                          1 through 366
 * @property      int            $age                                                                                does a diffInYears() with default parameters
 * @property      int            $offset                                                                             the timezone offset in seconds from UTC
 * @property      int            $offsetMinutes                                                                      the timezone offset in minutes from UTC
 * @property      int            $offsetHours                                                                        the timezone offset in hours from UTC
 * @property      CarbonTimeZone $timezone                                                                           the current timezone
 * @property      CarbonTimeZone $tz                                                                                 alias of $timezone
 * @property-read int            $dayOfWeek                                                                          0 (for Sunday) through 6 (for Saturday)
 * @property-read int            $dayOfWeekIso                                                                       1 (for Monday) through 7 (for Sunday)
 * @property-read int            $weekOfYear                                                                         ISO-8601 week number of year, weeks starting on Monday
 * @property-read int            $daysInMonth                                                                        number of days in the given month
 * @property-read string         $latinMeridiem                                                                      "am"/"pm" (Ante meridiem or Post meridiem latin lowercase mark)
 * @property-read string         $latinUpperMeridiem                                                                 "AM"/"PM" (Ante meridiem or Post meridiem latin uppercase mark)
 * @property-read string         $dayName                                                                            long name of weekday translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $shortDayName                                                                       short name of weekday translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $minDayName                                                                         very short name of weekday translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $monthName                                                                          long name of month translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $shortMonthName                                                                     short name of month translated according to Carbon locale, in english if no translation available for current language
 * @property-read string         $meridiem                                                                           lowercase meridiem mark translated according to Carbon locale, in latin if no translation available for current language
 * @property-read string         $upperMeridiem                                                                      uppercase meridiem mark translated according to Carbon locale, in latin if no translation available for current language
 * @property-read int            $noZeroHour                                                                         current hour from 1 to 24
 * @property-read int            $weeksInYear                                                                        51 through 53
 * @property-read int            $isoWeeksInYear                                                                     51 through 53
 * @property-read int            $weekOfMonth                                                                        1 through 5
 * @property-read int            $weekNumberInMonth                                                                  1 through 5
 * @property-read int            $firstWeekDay                                                                       0 through 6
 * @property-read int            $lastWeekDay                                                                        0 through 6
 * @property-read int            $daysInYear                                                                         365 or 366
 * @property-read int            $quarter                                                                            the quarter of this instance, 1 - 4
 * @property-read int            $decade                                                                             the decade of this instance
 * @property-read int            $century                                                                            the century of this instance
 * @property-read int            $millennium                                                                         the millennium of this instance
 * @property-read bool           $dst                                                                                daylight savings time indicator, true if DST, false otherwise
 * @property-read bool           $local                                                                              checks if the timezone is local, true if local, false otherwise
 * @property-read bool           $utc                                                                                checks if the timezone is UTC, true if UTC, false otherwise
 * @property-read string         $timezoneName                                                                       the current timezone name
 * @property-read string         $tzName                                                                             alias of $timezoneName
 * @property-read string         $timezoneAbbreviatedName                                                            the current timezone abbreviated name
 * @property-read string         $tzAbbrName                                                                         alias of $timezoneAbbreviatedName
 * @property-read string         $locale                                                                             locale of the current instance
 *
 * @method        string         format($format)                                                                     call \DateTime::format if mutable or \DateTimeImmutable::format else.
 *                                                                                                                   http://php.net/manual/en/datetime.format.php
 * @method        static         modify($modify)                                                                     call \DateTime::modify if mutable or \DateTimeImmutable::modify else.
 *                                                                                                                   http://php.net/manual/en/datetime.modify.php
 * @method        int            getOffset()                                                                         call \DateTime::getOffset if mutable or \DateTimeImmutable::getOffset else.
 *                                                                                                                   http://php.net/manual/en/datetime.getoffset.php
 * @method        int            getTimestamp()                                                                      call \DateTime::getTimestamp if mutable or \DateTimeImmutable::getTimestamp else.
 *                                                                                                                   http://php.net/manual/en/datetime.gettimestamp.php
 * @method        static         setTime($hour, $minute, $second = 0, $microseconds = 0)                             call \DateTime::setTime if mutable or \DateTimeImmutable::setTime else.
 *                                                                                                                   http://php.net/manual/en/datetime.settime.php
 * @method        static         setISODate($year, $week, $day = 1)                                                  call \DateTime::setISODate if mutable or \DateTimeImmutable::setISODate else.
 *                                                                                                                   http://php.net/manual/en/datetime.setisodate.php
 * @method        static         setTimestamp($unixtimestamp)                                                        call \DateTime::setTimestamp if mutable or \DateTimeImmutable::setTimestamp else.
 *                                                                                                                   http://php.net/manual/en/datetime.settimestamp.php
 * @method        \DateInterval  diff($object, $absolute = true)                                                     call \DateTime::diff if mutable or \DateTimeImmutable::diff else.
 *                                                                                                                   http://php.net/manual/en/datetime.diff.php
 * @method        bool           isUtc()                                                                             Check if the current instance has UTC timezone.
 * @method        bool           isUTC()                                                                             Check if the current instance has UTC timezone.
 * @method        bool           isLocal()                                                                           Check if the current instance has non-UTC timezone.
 * @method        bool           isValid()                                                                           Check if the current instance is a valid date.
 * @method        bool           isDST()                                                                             Check if the current instance is in a daylight saving time.
 * @method        bool           isSunday()                                                                          Checks if the instance day is sunday.
 * @method        bool           isMonday()                                                                          Checks if the instance day is monday.
 * @method        bool           isTuesday()                                                                         Checks if the instance day is tuesday.
 * @method        bool           isWednesday()                                                                       Checks if the instance day is wednesday.
 * @method        bool           isThursday()                                                                        Checks if the instance day is thursday.
 * @method        bool           isFriday()                                                                          Checks if the instance day is friday.
 * @method        bool           isSaturday()                                                                        Checks if the instance day is saturday.
 * @method        bool           isCurrentMonth()                                                                    Checks if the instance is in the same month as the current moment.
 * @method        bool           isNextMonth()                                                                       Checks if the instance is in the same month as the current moment next month.
 * @method        bool           isLastMonth()                                                                       Checks if the instance is in the same month as the current moment last month.
 * @method        bool           isCurrentQuarter()                                                                  Checks if the instance is in the same quarter as the current moment.
 * @method        bool           isNextQuarter()                                                                     Checks if the instance is in the same quarter as the current moment next quarter.
 * @method        bool           isLastQuarter()                                                                     Checks if the instance is in the same quarter as the current moment last quarter.
 * @method        bool           isSameDecade(\DateTimeInterface $date = null)                                       Checks if the given date is in the same decade as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentDecade()                                                                   Checks if the instance is in the same decade as the current moment.
 * @method        bool           isNextDecade()                                                                      Checks if the instance is in the same decade as the current moment next decade.
 * @method        bool           isLastDecade()                                                                      Checks if the instance is in the same decade as the current moment last decade.
 * @method        bool           isSameCentury(\DateTimeInterface $date = null)                                      Checks if the given date is in the same century as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentCentury()                                                                  Checks if the instance is in the same century as the current moment.
 * @method        bool           isNextCentury()                                                                     Checks if the instance is in the same century as the current moment next century.
 * @method        bool           isLastCentury()                                                                     Checks if the instance is in the same century as the current moment last century.
 * @method        bool           isSameMillennium(\DateTimeInterface $date = null)                                   Checks if the given date is in the same millennium as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMillennium()                                                               Checks if the instance is in the same millennium as the current moment.
 * @method        bool           isNextMillennium()                                                                  Checks if the instance is in the same millennium as the current moment next millennium.
 * @method        bool           isLastMillennium()                                                                  Checks if the instance is in the same millennium as the current moment last millennium.
 * @method        bool           isSameYear(\DateTimeInterface $date = null)                                         Checks if the given date is in the same year as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentYear()                                                                     Checks if the instance is in the same year as the current moment.
 * @method        bool           isNextYear()                                                                        Checks if the instance is in the same year as the current moment next year.
 * @method        bool           isLastYear()                                                                        Checks if the instance is in the same year as the current moment last year.
 * @method        bool           isSameWeek(\DateTimeInterface $date = null)                                         Checks if the given date is in the same week as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentWeek()                                                                     Checks if the instance is in the same week as the current moment.
 * @method        bool           isNextWeek()                                                                        Checks if the instance is in the same week as the current moment next week.
 * @method        bool           isLastWeek()                                                                        Checks if the instance is in the same week as the current moment last week.
 * @method        bool           isSameDay(\DateTimeInterface $date = null)                                          Checks if the given date is in the same day as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentDay()                                                                      Checks if the instance is in the same day as the current moment.
 * @method        bool           isNextDay()                                                                         Checks if the instance is in the same day as the current moment next day.
 * @method        bool           isLastDay()                                                                         Checks if the instance is in the same day as the current moment last day.
 * @method        bool           isSameHour(\DateTimeInterface $date = null)                                         Checks if the given date is in the same hour as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentHour()                                                                     Checks if the instance is in the same hour as the current moment.
 * @method        bool           isNextHour()                                                                        Checks if the instance is in the same hour as the current moment next hour.
 * @method        bool           isLastHour()                                                                        Checks if the instance is in the same hour as the current moment last hour.
 * @method        bool           isSameMinute(\DateTimeInterface $date = null)                                       Checks if the given date is in the same minute as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMinute()                                                                   Checks if the instance is in the same minute as the current moment.
 * @method        bool           isNextMinute()                                                                      Checks if the instance is in the same minute as the current moment next minute.
 * @method        bool           isLastMinute()                                                                      Checks if the instance is in the same minute as the current moment last minute.
 * @method        bool           isSameSecond(\DateTimeInterface $date = null)                                       Checks if the given date is in the same second as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentSecond()                                                                   Checks if the instance is in the same second as the current moment.
 * @method        bool           isNextSecond()                                                                      Checks if the instance is in the same second as the current moment next second.
 * @method        bool           isLastSecond()                                                                      Checks if the instance is in the same second as the current moment last second.
 * @method        bool           isSameMicro(\DateTimeInterface $date = null)                                        Checks if the given date is in the same micro as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMicro()                                                                    Checks if the instance is in the same micro as the current moment.
 * @method        bool           isNextMicro()                                                                       Checks if the instance is in the same micro as the current moment next micro.
 * @method        bool           isLastMicro()                                                                       Checks if the instance is in the same micro as the current moment last micro.
 * @method        bool           isSameMicrosecond(\DateTimeInterface $date = null)                                  Checks if the given date is in the same microsecond as the instance. If null passed, compare to now (with the same timezone).
 * @method        bool           isCurrentMicrosecond()                                                              Checks if the instance is in the same microsecond as the current moment.
 * @method        bool           isNextMicrosecond()                                                                 Checks if the instance is in the same microsecond as the current moment next microsecond.
 * @method        bool           isLastMicrosecond()                                                                 Checks if the instance is in the same microsecond as the current moment last microsecond.
 * @method        $this          years(int $value)                                                                   Set current instance year to the given value.
 * @method        $this          year(int $value)                                                                    Set current instance year to the given value.
 * @method        $this          setYears(int $value)                                                                Set current instance year to the given value.
 * @method        $this          setYear(int $value)                                                                 Set current instance year to the given value.
 * @method        $this          months(int $value)                                                                  Set current instance month to the given value.
 * @method        $this          month(int $value)                                                                   Set current instance month to the given value.
 * @method        $this          setMonths(int $value)                                                               Set current instance month to the given value.
 * @method        $this          setMonth(int $value)                                                                Set current instance month to the given value.
 * @method        $this          days(int $value)                                                                    Set current instance day to the given value.
 * @method        $this          day(int $value)                                                                     Set current instance day to the given value.
 * @method        $this          setDays(int $value)                                                                 Set current instance day to the given value.
 * @method        $this          setDay(int $value)                                                                  Set current instance day to the given value.
 * @method        $this          hours(int $value)                                                                   Set current instance hour to the given value.
 * @method        $this          hour(int $value)                                                                    Set current instance hour to the given value.
 * @method        $this          setHours(int $value)                                                                Set current instance hour to the given value.
 * @method        $this          setHour(int $value)                                                                 Set current instance hour to the given value.
 * @method        $this          minutes(int $value)                                                                 Set current instance minute to the given value.
 * @method        $this          minute(int $value)                                                                  Set current instance minute to the given value.
 * @method        $this          setMinutes(int $value)                                                              Set current instance minute to the given value.
 * @method        $this          setMinute(int $value)                                                               Set current instance minute to the given value.
 * @method        $this          seconds(int $value)                                                                 Set current instance second to the given value.
 * @method        $this          second(int $value)                                                                  Set current instance second to the given value.
 * @method        $this          setSeconds(int $value)                                                              Set current instance second to the given value.
 * @method        $this          setSecond(int $value)                                                               Set current instance second to the given value.
 * @method        $this          micros(int $value)                                                                  Set current instance micro to the given value.
 * @method        $this          micro(int $value)                                                                   Set current instance micro to the given value.
 * @method        $this          setMicros(int $value)                                                               Set current instance micro to the given value.
 * @method        $this          setMicro(int $value)                                                                Set current instance micro to the given value.
 * @method        $this          microseconds(int $value)                                                            Set current instance microsecond to the given value.
 * @method        $this          microsecond(int $value)                                                             Set current instance microsecond to the given value.
 * @method        $this          setMicroseconds(int $value)                                                         Set current instance microsecond to the given value.
 * @method        $this          setMicrosecond(int $value)                                                          Set current instance microsecond to the given value.
 * @method        $this          addYears(int $value = 1)                                                            Add years (the $value count passed in) to the instance (using date interval).
 * @method        $this          addYear()                                                                           Add one year to the instance (using date interval).
 * @method        $this          subYears(int $value = 1)                                                            Sub years (the $value count passed in) to the instance (using date interval).
 * @method        $this          subYear()                                                                           Sub one year to the instance (using date interval).
 * @method        $this          addYearsWithOverflow(int $value = 1)                                                Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addYearWithOverflow()                                                               Add one year to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subYearsWithOverflow(int $value = 1)                                                Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subYearWithOverflow()                                                               Sub one year to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addYearsWithoutOverflow(int $value = 1)                                             Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearWithoutOverflow()                                                            Add one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearsWithoutOverflow(int $value = 1)                                             Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearWithoutOverflow()                                                            Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearsWithNoOverflow(int $value = 1)                                              Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearWithNoOverflow()                                                             Add one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearsWithNoOverflow(int $value = 1)                                              Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearWithNoOverflow()                                                             Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearsNoOverflow(int $value = 1)                                                  Add years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addYearNoOverflow()                                                                 Add one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearsNoOverflow(int $value = 1)                                                  Sub years (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subYearNoOverflow()                                                                 Sub one year to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonths(int $value = 1)                                                           Add months (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMonth()                                                                          Add one month to the instance (using date interval).
 * @method        $this          subMonths(int $value = 1)                                                           Sub months (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMonth()                                                                          Sub one month to the instance (using date interval).
 * @method        $this          addMonthsWithOverflow(int $value = 1)                                               Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addMonthWithOverflow()                                                              Add one month to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subMonthsWithOverflow(int $value = 1)                                               Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subMonthWithOverflow()                                                              Sub one month to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addMonthsWithoutOverflow(int $value = 1)                                            Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthWithoutOverflow()                                                           Add one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthsWithoutOverflow(int $value = 1)                                            Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthWithoutOverflow()                                                           Sub one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthsWithNoOverflow(int $value = 1)                                             Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthWithNoOverflow()                                                            Add one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthsWithNoOverflow(int $value = 1)                                             Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthWithNoOverflow()                                                            Sub one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthsNoOverflow(int $value = 1)                                                 Add months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMonthNoOverflow()                                                                Add one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthsNoOverflow(int $value = 1)                                                 Sub months (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMonthNoOverflow()                                                                Sub one month to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDays(int $value = 1)                                                             Add days (the $value count passed in) to the instance (using date interval).
 * @method        $this          addDay()                                                                            Add one day to the instance (using date interval).
 * @method        $this          subDays(int $value = 1)                                                             Sub days (the $value count passed in) to the instance (using date interval).
 * @method        $this          subDay()                                                                            Sub one day to the instance (using date interval).
 * @method        $this          addHours(int $value = 1)                                                            Add hours (the $value count passed in) to the instance (using date interval).
 * @method        $this          addHour()                                                                           Add one hour to the instance (using date interval).
 * @method        $this          subHours(int $value = 1)                                                            Sub hours (the $value count passed in) to the instance (using date interval).
 * @method        $this          subHour()                                                                           Sub one hour to the instance (using date interval).
 * @method        $this          addMinutes(int $value = 1)                                                          Add minutes (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMinute()                                                                         Add one minute to the instance (using date interval).
 * @method        $this          subMinutes(int $value = 1)                                                          Sub minutes (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMinute()                                                                         Sub one minute to the instance (using date interval).
 * @method        $this          addSeconds(int $value = 1)                                                          Add seconds (the $value count passed in) to the instance (using date interval).
 * @method        $this          addSecond()                                                                         Add one second to the instance (using date interval).
 * @method        $this          subSeconds(int $value = 1)                                                          Sub seconds (the $value count passed in) to the instance (using date interval).
 * @method        $this          subSecond()                                                                         Sub one second to the instance (using date interval).
 * @method        $this          addMicros(int $value = 1)                                                           Add micros (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMicro()                                                                          Add one micro to the instance (using date interval).
 * @method        $this          subMicros(int $value = 1)                                                           Sub micros (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMicro()                                                                          Sub one micro to the instance (using date interval).
 * @method        $this          addMicroseconds(int $value = 1)                                                     Add microseconds (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMicrosecond()                                                                    Add one microsecond to the instance (using date interval).
 * @method        $this          subMicroseconds(int $value = 1)                                                     Sub microseconds (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMicrosecond()                                                                    Sub one microsecond to the instance (using date interval).
 * @method        $this          addMillennia(int $value = 1)                                                        Add millennia (the $value count passed in) to the instance (using date interval).
 * @method        $this          addMillennium()                                                                     Add one millennium to the instance (using date interval).
 * @method        $this          subMillennia(int $value = 1)                                                        Sub millennia (the $value count passed in) to the instance (using date interval).
 * @method        $this          subMillennium()                                                                     Sub one millennium to the instance (using date interval).
 * @method        $this          addMillenniaWithOverflow(int $value = 1)                                            Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addMillenniumWithOverflow()                                                         Add one millennium to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subMillenniaWithOverflow(int $value = 1)                                            Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subMillenniumWithOverflow()                                                         Sub one millennium to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addMillenniaWithoutOverflow(int $value = 1)                                         Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniumWithoutOverflow()                                                      Add one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniaWithoutOverflow(int $value = 1)                                         Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniumWithoutOverflow()                                                      Sub one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniaWithNoOverflow(int $value = 1)                                          Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniumWithNoOverflow()                                                       Add one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniaWithNoOverflow(int $value = 1)                                          Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniumWithNoOverflow()                                                       Sub one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniaNoOverflow(int $value = 1)                                              Add millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addMillenniumNoOverflow()                                                           Add one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniaNoOverflow(int $value = 1)                                              Sub millennia (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subMillenniumNoOverflow()                                                           Sub one millennium to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturies(int $value = 1)                                                        Add centuries (the $value count passed in) to the instance (using date interval).
 * @method        $this          addCentury()                                                                        Add one century to the instance (using date interval).
 * @method        $this          subCenturies(int $value = 1)                                                        Sub centuries (the $value count passed in) to the instance (using date interval).
 * @method        $this          subCentury()                                                                        Sub one century to the instance (using date interval).
 * @method        $this          addCenturiesWithOverflow(int $value = 1)                                            Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addCenturyWithOverflow()                                                            Add one century to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subCenturiesWithOverflow(int $value = 1)                                            Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subCenturyWithOverflow()                                                            Sub one century to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addCenturiesWithoutOverflow(int $value = 1)                                         Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturyWithoutOverflow()                                                         Add one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturiesWithoutOverflow(int $value = 1)                                         Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturyWithoutOverflow()                                                         Sub one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturiesWithNoOverflow(int $value = 1)                                          Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturyWithNoOverflow()                                                          Add one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturiesWithNoOverflow(int $value = 1)                                          Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturyWithNoOverflow()                                                          Sub one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturiesNoOverflow(int $value = 1)                                              Add centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addCenturyNoOverflow()                                                              Add one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturiesNoOverflow(int $value = 1)                                              Sub centuries (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subCenturyNoOverflow()                                                              Sub one century to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecades(int $value = 1)                                                          Add decades (the $value count passed in) to the instance (using date interval).
 * @method        $this          addDecade()                                                                         Add one decade to the instance (using date interval).
 * @method        $this          subDecades(int $value = 1)                                                          Sub decades (the $value count passed in) to the instance (using date interval).
 * @method        $this          subDecade()                                                                         Sub one decade to the instance (using date interval).
 * @method        $this          addDecadesWithOverflow(int $value = 1)                                              Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addDecadeWithOverflow()                                                             Add one decade to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subDecadesWithOverflow(int $value = 1)                                              Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subDecadeWithOverflow()                                                             Sub one decade to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addDecadesWithoutOverflow(int $value = 1)                                           Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadeWithoutOverflow()                                                          Add one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadesWithoutOverflow(int $value = 1)                                           Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadeWithoutOverflow()                                                          Sub one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadesWithNoOverflow(int $value = 1)                                            Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadeWithNoOverflow()                                                           Add one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadesWithNoOverflow(int $value = 1)                                            Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadeWithNoOverflow()                                                           Sub one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadesNoOverflow(int $value = 1)                                                Add decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addDecadeNoOverflow()                                                               Add one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadesNoOverflow(int $value = 1)                                                Sub decades (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subDecadeNoOverflow()                                                               Sub one decade to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuarters(int $value = 1)                                                         Add quarters (the $value count passed in) to the instance (using date interval).
 * @method        $this          addQuarter()                                                                        Add one quarter to the instance (using date interval).
 * @method        $this          subQuarters(int $value = 1)                                                         Sub quarters (the $value count passed in) to the instance (using date interval).
 * @method        $this          subQuarter()                                                                        Sub one quarter to the instance (using date interval).
 * @method        $this          addQuartersWithOverflow(int $value = 1)                                             Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addQuarterWithOverflow()                                                            Add one quarter to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subQuartersWithOverflow(int $value = 1)                                             Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          subQuarterWithOverflow()                                                            Sub one quarter to the instance (using date interval) with overflow explicitly allowed.
 * @method        $this          addQuartersWithoutOverflow(int $value = 1)                                          Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuarterWithoutOverflow()                                                         Add one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuartersWithoutOverflow(int $value = 1)                                          Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuarterWithoutOverflow()                                                         Sub one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuartersWithNoOverflow(int $value = 1)                                           Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuarterWithNoOverflow()                                                          Add one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuartersWithNoOverflow(int $value = 1)                                           Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuarterWithNoOverflow()                                                          Sub one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuartersNoOverflow(int $value = 1)                                               Add quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addQuarterNoOverflow()                                                              Add one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuartersNoOverflow(int $value = 1)                                               Sub quarters (the $value count passed in) to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          subQuarterNoOverflow()                                                              Sub one quarter to the instance (using date interval) with overflow explicitly forbidden.
 * @method        $this          addWeeks(int $value = 1)                                                            Add weeks (the $value count passed in) to the instance (using date interval).
 * @method        $this          addWeek()                                                                           Add one week to the instance (using date interval).
 * @method        $this          subWeeks(int $value = 1)                                                            Sub weeks (the $value count passed in) to the instance (using date interval).
 * @method        $this          subWeek()                                                                           Sub one week to the instance (using date interval).
 * @method        $this          addWeekdays(int $value = 1)                                                         Add weekdays (the $value count passed in) to the instance (using date interval).
 * @method        $this          addWeekday()                                                                        Add one weekday to the instance (using date interval).
 * @method        $this          subWeekdays(int $value = 1)                                                         Sub weekdays (the $value count passed in) to the instance (using date interval).
 * @method        $this          subWeekday()                                                                        Sub one weekday to the instance (using date interval).
 * @method        $this          addRealMicroseconds(int $value = 1)                                                 Add microseconds (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealMicrosecond()                                                                Add one microsecond to the instance (using timestamp).
 * @method        $this          subRealMicroseconds(int $value = 1)                                                 Sub microseconds (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealMicrosecond()                                                                Sub one microsecond to the instance (using timestamp).
 * @method        $this          addRealSeconds(int $value = 1)                                                      Add seconds (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealSecond()                                                                     Add one second to the instance (using timestamp).
 * @method        $this          subRealSeconds(int $value = 1)                                                      Sub seconds (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealSecond()                                                                     Sub one second to the instance (using timestamp).
 * @method        $this          addRealMinutes(int $value = 1)                                                      Add minutes (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealMinute()                                                                     Add one minute to the instance (using timestamp).
 * @method        $this          subRealMinutes(int $value = 1)                                                      Sub minutes (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealMinute()                                                                     Sub one minute to the instance (using timestamp).
 * @method        $this          addRealHours(int $value = 1)                                                        Add hours (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealHour()                                                                       Add one hour to the instance (using timestamp).
 * @method        $this          subRealHours(int $value = 1)                                                        Sub hours (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealHour()                                                                       Sub one hour to the instance (using timestamp).
 * @method        $this          addRealDays(int $value = 1)                                                         Add days (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealDay()                                                                        Add one day to the instance (using timestamp).
 * @method        $this          subRealDays(int $value = 1)                                                         Sub days (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealDay()                                                                        Sub one day to the instance (using timestamp).
 * @method        $this          addRealWeeks(int $value = 1)                                                        Add weeks (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealWeek()                                                                       Add one week to the instance (using timestamp).
 * @method        $this          subRealWeeks(int $value = 1)                                                        Sub weeks (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealWeek()                                                                       Sub one week to the instance (using timestamp).
 * @method        $this          addRealMonths(int $value = 1)                                                       Add months (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealMonth()                                                                      Add one month to the instance (using timestamp).
 * @method        $this          subRealMonths(int $value = 1)                                                       Sub months (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealMonth()                                                                      Sub one month to the instance (using timestamp).
 * @method        $this          addRealQuarters(int $value = 1)                                                     Add quarters (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealQuarter()                                                                    Add one quarter to the instance (using timestamp).
 * @method        $this          subRealQuarters(int $value = 1)                                                     Sub quarters (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealQuarter()                                                                    Sub one quarter to the instance (using timestamp).
 * @method        $this          addRealYears(int $value = 1)                                                        Add years (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealYear()                                                                       Add one year to the instance (using timestamp).
 * @method        $this          subRealYears(int $value = 1)                                                        Sub years (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealYear()                                                                       Sub one year to the instance (using timestamp).
 * @method        $this          addRealDecades(int $value = 1)                                                      Add decades (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealDecade()                                                                     Add one decade to the instance (using timestamp).
 * @method        $this          subRealDecades(int $value = 1)                                                      Sub decades (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealDecade()                                                                     Sub one decade to the instance (using timestamp).
 * @method        $this          addRealCenturies(int $value = 1)                                                    Add centuries (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealCentury()                                                                    Add one century to the instance (using timestamp).
 * @method        $this          subRealCenturies(int $value = 1)                                                    Sub centuries (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealCentury()                                                                    Sub one century to the instance (using timestamp).
 * @method        $this          addRealMillennia(int $value = 1)                                                    Add millennia (the $value count passed in) to the instance (using timestamp).
 * @method        $this          addRealMillennium()                                                                 Add one millennium to the instance (using timestamp).
 * @method        $this          subRealMillennia(int $value = 1)                                                    Sub millennia (the $value count passed in) to the instance (using timestamp).
 * @method        $this          subRealMillennium()                                                                 Sub one millennium to the instance (using timestamp).
 * @method        $this          roundYear(float $precision = 1, string $function = "round")                         Round the current instance year with given precision using the given function.
 * @method        $this          roundYears(float $precision = 1, string $function = "round")                        Round the current instance year with given precision using the given function.
 * @method        $this          floorYear(float $precision = 1)                                                     Truncate the current instance year with given precision.
 * @method        $this          floorYears(float $precision = 1)                                                    Truncate the current instance year with given precision.
 * @method        $this          ceilYear(float $precision = 1)                                                      Ceil the current instance year with given precision.
 * @method        $this          ceilYears(float $precision = 1)                                                     Ceil the current instance year with given precision.
 * @method        $this          roundMonth(float $precision = 1, string $function = "round")                        Round the current instance month with given precision using the given function.
 * @method        $this          roundMonths(float $precision = 1, string $function = "round")                       Round the current instance month with given precision using the given function.
 * @method        $this          floorMonth(float $precision = 1)                                                    Truncate the current instance month with given precision.
 * @method        $this          floorMonths(float $precision = 1)                                                   Truncate the current instance month with given precision.
 * @method        $this          ceilMonth(float $precision = 1)                                                     Ceil the current instance month with given precision.
 * @method        $this          ceilMonths(float $precision = 1)                                                    Ceil the current instance month with given precision.
 * @method        $this          roundDay(float $precision = 1, string $function = "round")                          Round the current instance day with given precision using the given function.
 * @method        $this          roundDays(float $precision = 1, string $function = "round")                         Round the current instance day with given precision using the given function.
 * @method        $this          floorDay(float $precision = 1)                                                      Truncate the current instance day with given precision.
 * @method        $this          floorDays(float $precision = 1)                                                     Truncate the current instance day with given precision.
 * @method        $this          ceilDay(float $precision = 1)                                                       Ceil the current instance day with given precision.
 * @method        $this          ceilDays(float $precision = 1)                                                      Ceil the current instance day with given precision.
 * @method        $this          roundHour(float $precision = 1, string $function = "round")                         Round the current instance hour with given precision using the given function.
 * @method        $this          roundHours(float $precision = 1, string $function = "round")                        Round the current instance hour with given precision using the given function.
 * @method        $this          floorHour(float $precision = 1)                                                     Truncate the current instance hour with given precision.
 * @method        $this          floorHours(float $precision = 1)                                                    Truncate the current instance hour with given precision.
 * @method        $this          ceilHour(float $precision = 1)                                                      Ceil the current instance hour with given precision.
 * @method        $this          ceilHours(float $precision = 1)                                                     Ceil the current instance hour with given precision.
 * @method        $this          roundMinute(float $precision = 1, string $function = "round")                       Round the current instance minute with given precision using the given function.
 * @method        $this          roundMinutes(float $precision = 1, string $function = "round")                      Round the current instance minute with given precision using the given function.
 * @method        $this          floorMinute(float $precision = 1)                                                   Truncate the current instance minute with given precision.
 * @method        $this          floorMinutes(float $precision = 1)                                                  Truncate the current instance minute with given precision.
 * @method        $this          ceilMinute(float $precision = 1)                                                    Ceil the current instance minute with given precision.
 * @method        $this          ceilMinutes(float $precision = 1)                                                   Ceil the current instance minute with given precision.
 * @method        $this          roundSecond(float $precision = 1, string $function = "round")                       Round the current instance second with given precision using the given function.
 * @method        $this          roundSeconds(float $precision = 1, string $function = "round")                      Round the current instance second with given precision using the given function.
 * @method        $this          floorSecond(float $precision = 1)                                                   Truncate the current instance second with given precision.
 * @method        $this          floorSeconds(float $precision = 1)                                                  Truncate the current instance second with given precision.
 * @method        $this          ceilSecond(float $precision = 1)                                                    Ceil the current instance second with given precision.
 * @method        $this          ceilSeconds(float $precision = 1)                                                   Ceil the current instance second with given precision.
 * @method        $this          roundMillennium(float $precision = 1, string $function = "round")                   Round the current instance millennium with given precision using the given function.
 * @method        $this          roundMillennia(float $precision = 1, string $function = "round")                    Round the current instance millennium with given precision using the given function.
 * @method        $this          floorMillennium(float $precision = 1)                                               Truncate the current instance millennium with given precision.
 * @method        $this          floorMillennia(float $precision = 1)                                                Truncate the current instance millennium with given precision.
 * @method        $this          ceilMillennium(float $precision = 1)                                                Ceil the current instance millennium with given precision.
 * @method        $this          ceilMillennia(float $precision = 1)                                                 Ceil the current instance millennium with given precision.
 * @method        $this          roundCentury(float $precision = 1, string $function = "round")                      Round the current instance century with given precision using the given function.
 * @method        $this          roundCenturies(float $precision = 1, string $function = "round")                    Round the current instance century with given precision using the given function.
 * @method        $this          floorCentury(float $precision = 1)                                                  Truncate the current instance century with given precision.
 * @method        $this          floorCenturies(float $precision = 1)                                                Truncate the current instance century with given precision.
 * @method        $this          ceilCentury(float $precision = 1)                                                   Ceil the current instance century with given precision.
 * @method        $this          ceilCenturies(float $precision = 1)                                                 Ceil the current instance century with given precision.
 * @method        $this          roundDecade(float $precision = 1, string $function = "round")                       Round the current instance decade with given precision using the given function.
 * @method        $this          roundDecades(float $precision = 1, string $function = "round")                      Round the current instance decade with given precision using the given function.
 * @method        $this          floorDecade(float $precision = 1)                                                   Truncate the current instance decade with given precision.
 * @method        $this          floorDecades(float $precision = 1)                                                  Truncate the current instance decade with given precision.
 * @method        $this          ceilDecade(float $precision = 1)                                                    Ceil the current instance decade with given precision.
 * @method        $this          ceilDecades(float $precision = 1)                                                   Ceil the current instance decade with given precision.
 * @method        $this          roundQuarter(float $precision = 1, string $function = "round")                      Round the current instance quarter with given precision using the given function.
 * @method        $this          roundQuarters(float $precision = 1, string $function = "round")                     Round the current instance quarter with given precision using the given function.
 * @method        $this          floorQuarter(float $precision = 1)                                                  Truncate the current instance quarter with given precision.
 * @method        $this          floorQuarters(float $precision = 1)                                                 Truncate the current instance quarter with given precision.
 * @method        $this          ceilQuarter(float $precision = 1)                                                   Ceil the current instance quarter with given precision.
 * @method        $this          ceilQuarters(float $precision = 1)                                                  Ceil the current instance quarter with given precision.
 * @method        $this          roundMillisecond(float $precision = 1, string $function = "round")                  Round the current instance millisecond with given precision using the given function.
 * @method        $this          roundMilliseconds(float $precision = 1, string $function = "round")                 Round the current instance millisecond with given precision using the given function.
 * @method        $this          floorMillisecond(float $precision = 1)                                              Truncate the current instance millisecond with given precision.
 * @method        $this          floorMilliseconds(float $precision = 1)                                             Truncate the current instance millisecond with given precision.
 * @method        $this          ceilMillisecond(float $precision = 1)                                               Ceil the current instance millisecond with given precision.
 * @method        $this          ceilMilliseconds(float $precision = 1)                                              Ceil the current instance millisecond with given precision.
 * @method        $this          roundMicrosecond(float $precision = 1, string $function = "round")                  Round the current instance microsecond with given precision using the given function.
 * @method        $this          roundMicroseconds(float $precision = 1, string $function = "round")                 Round the current instance microsecond with given precision using the given function.
 * @method        $this          floorMicrosecond(float $precision = 1)                                              Truncate the current instance microsecond with given precision.
 * @method        $this          floorMicroseconds(float $precision = 1)                                             Truncate the current instance microsecond with given precision.
 * @method        $this          ceilMicrosecond(float $precision = 1)                                               Ceil the current instance microsecond with given precision.
 * @method        $this          ceilMicroseconds(float $precision = 1)                                              Ceil the current instance microsecond with given precision.
 * @method        string         shortAbsoluteDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)        Get the difference (short format, 'Absolute' mode) in a human readable format in the current locale.
 * @method        string         shortAbsoluteDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)        Get the difference (short format, 'Absolute' mode) in a human readable format in the current locale.
 * @method        string         longAbsoluteDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)         Get the difference (long format, 'Absolute' mode) in a human readable format in the current locale.
 * @method        string         longAbsoluteDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)         Get the difference (long format, 'Absolute' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)        Get the difference (short format, 'Relative' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)        Get the difference (short format, 'Relative' mode) in a human readable format in the current locale.
 * @method        string         longRelativeDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)         Get the difference (long format, 'Relative' mode) in a human readable format in the current locale.
 * @method        string         longRelativeDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)         Get the difference (long format, 'Relative' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeToNowDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)   Get the difference (short format, 'RelativeToNow' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeToNowDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)   Get the difference (short format, 'RelativeToNow' mode) in a human readable format in the current locale.
 * @method        string         longRelativeToNowDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)    Get the difference (long format, 'RelativeToNow' mode) in a human readable format in the current locale.
 * @method        string         longRelativeToNowDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)    Get the difference (long format, 'RelativeToNow' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeToOtherDiffForHumans(\DateTimeInterface $other = null, int $parts = 1) Get the difference (short format, 'RelativeToOther' mode) in a human readable format in the current locale.
 * @method        string         shortRelativeToOtherDiffForHumans(int $parts = 1, \DateTimeInterface $other = null) Get the difference (short format, 'RelativeToOther' mode) in a human readable format in the current locale.
 * @method        string         longRelativeToOtherDiffForHumans(\DateTimeInterface $other = null, int $parts = 1)  Get the difference (long format, 'RelativeToOther' mode) in a human readable format in the current locale.
 * @method        string         longRelativeToOtherDiffForHumans(int $parts = 1, \DateTimeInterface $other = null)  Get the difference (long format, 'RelativeToOther' mode) in a human readable format in the current locale.
 *
 * </autodoc>
 */
trait Date
{
    use Boundaries;
    use Difference;
    use Macro;
    use Options;
    use Test;

    /**
     * Names of days of the week.
     *
     * @var array
     */
    protected static $days = [
        // @call isDayOfWeek
        self::SUNDAY => 'Sunday',
        // @call isDayOfWeek
        self::MONDAY => 'Monday',
        // @call isDayOfWeek
        self::TUESDAY => 'Tuesday',
        // @call isDayOfWeek
        self::WEDNESDAY => 'Wednesday',
        // @call isDayOfWeek
        self::THURSDAY => 'Thursday',
        // @call isDayOfWeek
        self::FRIDAY => 'Friday',
        // @call isDayOfWeek
        self::SATURDAY => 'Saturday',
    ];
    /**
     * The errors that can occur.
     *
     * @var array
     */
    protected static $lastErrors;

    /**
     * The custom Carbon JSON serializer.
     *
     * @var callable|null
     */
    protected static $serializer;

    /**
     * Will UTF8 encoding be used to print localized date/time ?
     *
     * @var bool
     */
    protected static $utf8 = false;

    /**
     * List of unit and magic methods associated as doc-comments.
     *
     * @var array
     */
    protected static $units = [
        // @call setUnit
        // @call addUnit
        'year',
        // @call setUnit
        // @call addUnit
        'month',
        // @call setUnit
        // @call addUnit
        'day',
        // @call setUnit
        // @call addUnit
        'hour',
        // @call setUnit
        // @call addUnit
        'minute',
        // @call setUnit
        // @call addUnit
        'second',
        // @call setUnit
        // @call addUnit
        'micro',
        // @call setUnit
        // @call addUnit
        'microsecond',
    ];

    /**
     * Locale to dump comes here before serialization.
     *
     * @var string
     */
    protected $dumpLocale = null;

    /**
     * Return true if the current class/instance is mutable.
     *
     * @return bool
     */
    public static function isMutable()
    {
        return false;
    }

    /**
     * Return true if the current class/instance is immutable.
     *
     * @return bool
     */
    public static function isImmutable()
    {
        return !static::isMutable();
    }

    /**
     * Return a mutable copy of the instance.
     *
     * @return Carbon
     */
    public function toMutable()
    {
        return Carbon::instance($this);
    }

    /**
     * Return a immutable copy of the instance.
     *
     * @return CarbonImmutable
     */
    public function toImmutable()
    {
        return CarbonImmutable::instance($this);
    }

    /**
     * Creates a DateTimeZone from a string, DateTimeZone or integer offset.
     *
     * @param \DateTimeZone|string|int|null $object
     *
     * @throws \InvalidArgumentException
     *
     * @return \DateTimeZone|false
     */
    protected static function safeCreateDateTimeZone($object)
    {
        return CarbonTimeZone::instance($object);
    }

    /**
     * Get the TimeZone associated with the Carbon instance (as CarbonTimeZone).
     *
     * @return CarbonTimeZone
     *
     * @link http://php.net/manual/en/datetime.gettimezone.php
     */
    public function getTimezone()
    {
        return CarbonTimeZone::instance(parent::getTimezone());
    }

    ///////////////////////////////////////////////////////////////////
    //////////////////////////// CONSTRUCTORS /////////////////////////
    ///////////////////////////////////////////////////////////////////

    /**
     * Create a new Carbon instance.
     *
     * Please see the testing aids section (specifically static::setTestNow())
     * for more on the possibility of this constructor returning a test instance.
     *
     * @param string|null               $time
     * @param \DateTimeZone|string|null $tz
     */
    public function __construct($time = null, $tz = null)
    {
        if (is_int($time)) {
            $time = "@$time";
        }

        // If the class has a test now set and we are trying to create a now()
        // instance then override as required
        $isNow = empty($time) || $time === 'now';
        if (static::hasTestNow() && ($isNow || static::hasRelativeKeywords($time))) {
            $testInstance = clone static::getTestNow();

            //shift the time according to the given time zone
            if ($tz !== null && $tz !== static::getTestNow()->getTimezone()) {
                $testInstance = $testInstance->setTimezone($tz);
            } else {
                $tz = $testInstance->getTimezone();
            }

            if (static::hasRelativeKeywords($time)) {
                $testInstance = $testInstance->modify($time);
            }

            $time = $testInstance->format(static::MOCK_DATETIME_FORMAT);
        }

        $timezone = static::safeCreateDateTimeZone($tz);

        // Work-around for PHP bug https://bugs.php.net/bug.php?id=67127
        if (strpos((string) .1, '.') === false) {
            $locale = setlocale(LC_NUMERIC, '0');
            setlocale(LC_NUMERIC, 'C');
        }
        parent::__construct($time, $timezone);
        if (isset($locale)) {
            setlocale(LC_NUMERIC, $locale);
        }
        static::setLastErrors(parent::getLastErrors());
    }

    /**
     * Create a Carbon instance from a DateTime one.
     *
     * @param \DateTimeInterface $date
     *
     * @return static
     */
    public static function instance($date)
    {
        if ($date instanceof static) {
            return clone $date;
        }

        static::expectDateTime($date);

        return new static($date->format('Y-m-d H:i:s.u'), $date->getTimezone());
    }

    /**
     * Create a carbon instance from a string.
     *
     * This is an alias for the constructor that allows better fluent syntax
     * as it allows you to do Carbon::parse('Monday next week')->fn() rather
     * than (new Carbon('Monday next week'))->fn().
     *
     * @param string|null               $time
     * @param \DateTimeZone|string|null $tz
     *
     * @return static
     */
    public static function parse($time = null, $tz = null)
    {
        if ($time instanceof DateTimeInterface) {
            return static::instance($time);
        }

        return new static($time, $tz);
    }

    /**
     * Get a Carbon instance for the current date and time.
     *
     * @param \DateTimeZone|string|null $tz
     *
     * @return static
     */
    public static function now($tz = null)
    {
        return new static(null, $tz);
    }

    /**
     * Create a Carbon instance for today.
     *
     * @param \DateTimeZone|string|null $tz
     *
     * @return static
     */
    public static function today($tz = null)
    {
        return static::parse('today', $tz);
    }

    /**
     * Create a Carbon instance for tomorrow.
     *
     * @param \DateTimeZone|string|null $tz
     *
     * @return static
     */
    public static function tomorrow($tz = null)
    {
        return static::parse('tomorrow', $tz);
    }

    /**
     * Create a Carbon instance for yesterday.
     *
     * @param \DateTimeZone|string|null $tz
     *
     * @return static
     */
    public static function yesterday($tz = null)
    {
        return static::parse('yesterday', $tz);
    }

    /**
     * Create a Carbon instance for the greatest supported date.
     *
     * @return static
     */
    public static function maxValue()
    {
        if (self::$PHPIntSize === 4) {
            // 32 bit
            return static::createFromTimestamp(PHP_INT_MAX); // @codeCoverageIgnore
        }

        // 64 bit
        return static::create(9999, 12, 31, 23, 59, 59);
    }

    /**
     * Create a Carbon instance for the lowest supported date.
     *
     * @return static
     */
    public static function minValue()
    {
        if (self::$PHPIntSize === 4) {
            // 32 bit
            return static::createFromTimestamp(~PHP_INT_MAX); // @codeCoverageIgnore
        }

        // 64 bit
        return static::create(1, 1, 1, 0, 0, 0);
    }

    /**
     * Create a new Carbon instance from a specific date and time.
     *
     * If any of $year, $month or $day are set to null their now() values will
     * be used.
     *
     * If $hour is null it will be set to its now() value and the default
     * values for $minute and $second will be their now() values.
     *
     * If $hour is not null then the default values for $minute and $second
     * will be 0.
     *
     * @param int|null                  $year
     * @param int|null                  $month
     * @param int|null                  $day
     * @param int|null                  $hour
     * @param int|null                  $minute
     * @param int|null                  $second
     * @param \DateTimeZone|string|null $tz
     *
     * @throws \InvalidArgumentException
     *
     * @return static
     */
    public static function create($year = 0, $month = 1, $day = 1, $hour = 0, $minute = 0, $second = 0, $tz = null)
    {
        if (is_string($year) && !is_numeric($year)) {
            return static::parse($year);
        }

        $defaults = null;
        $getDefault = function ($unit) use ($tz, &$defaults) {
            if ($defaults === null) {
                $now = static::hasTestNow() ? static::getTestNow() : static::now($tz);

                $defaults = array_combine([
                    'year',
                    'month',
                    'day',
                    'hour',
                    'minute',
                    'second',
                ], explode('-', $now->format('Y-n-j-G-i-s.u')));
            }

            return $defaults[$unit];
        };

        $year = $year === null ? $getDefault('year') : $year;
        $month = $month === null ? $getDefault('month') : $month;
        $day = $day === null ? $getDefault('day') : $day;
        $hour = $hour === null ? $getDefault('hour') : $hour;
        $minute = $minute === null ? $getDefault('minute') : $minute;
        $second = $second === null ? $getDefault('second') : $second;

        $fixYear = null;

        if ($year < 0) {
            $fixYear = $year;
            $year = 0;
        } elseif ($year > 9999) {
            $fixYear = $year - 9999;
            $year = 9999;
        }

        $second = ($second < 10 ? '0' : '').number_format($second, 6);
        $instance = static::createFromFormat('!Y-n-j G:i:s.u', sprintf('%s-%s-%s %s:%02s:%02s', $year, $month, $day, $hour, $minute, $second), $tz);

        if ($fixYear !== null) {
            $instance = $instance->addYears($fixYear);
        }

        return $instance;
    }

    /**
     * List of minimum and maximums for each unit.
     *
     * @return array
     */
    protected static function getRangesByUnit()
    {
        return [
            // @call roundUnit
            'year' => [1, 9999],
            // @call roundUnit
            'month' => [1, static::MONTHS_PER_YEAR],
            // @call roundUnit
            'day' => [1, 31],
            // @call roundUnit
            'hour' => [0, static::HOURS_PER_DAY - 1],
            // @call roundUnit
            'minute' => [0, static::MINUTES_PER_HOUR - 1],
            // @call roundUnit
            'second' => [0, static::SECONDS_PER_MINUTE - 1],
        ];
    }

    /**
     * Create a new safe Carbon instance from a specific date and time.
     *
     * If any of $year, $month or $day are set to null their now() values will
     * be used.
     *
     * If $hour is null it will be set to its now() value and the default
     * values for $minute and $second will be their now() values.
     *
     * If $hour is not null then the default values for $minute and $second
     * will be 0.
     *
     * If one of the set values is not valid, an \InvalidArgumentException
     * will be thrown.
     *
     * @param int|null                  $year
     * @param int|null                  $month
     * @param int|null                  $day
     * @param int|null                  $hour
     * @param int|null                  $minute
     * @param int|null                  $second
     * @param \DateTimeZone|string|null $tz
     *
     * @throws \Carbon\Exceptions\InvalidDateException|\InvalidArgumentException
     *
     * @return static|false
     */
    public static function createSafe($year = null, $month = null, $day = null, $hour = null, $minute = null, $second = null, $tz = null)
    {
        $fields = static::getRangesByUnit();

        foreach ($fields as $field => $range) {
            if ($$field !== null && (!is_int($$field) || $$field < $range[0] || $$field > $range[1])) {
                if (static::isStrictModeEnabled()) {
                    throw new InvalidDateException($field, $$field);
                }

                return false;
            }
        }

        $instance = static::create($year, $month, $day, $hour, $minute, $second, $tz);

        foreach (array_reverse($fields) as $field => $range) {
            if ($$field !== null && (!is_int($$field) || $$field !== $instance->$field)) {
                if (static::isStrictModeEnabled()) {
                    throw new InvalidDateException($field, $$field);
                }

                return false;
            }
        }

        return $instance;
    }

    /**
     * Create a Carbon instance from just a date. The time portion is set to now.
     *
     * @param int|null                  $year
     * @param int|null                  $month
     * @param int|null                  $day
     * @param \DateTimeZone|string|null $tz
     *
     * @throws \InvalidArgumentException
     *
     * @return static
     */
    public static function createFromDate($year = null, $month = null, $day = null, $tz = null)
    {
        return static::create($year, $month, $day, null, null, null, $tz);
    }

    /**
     * Create a Carbon instance from just a date. The time portion is set to midnight.
     *
     * @param int|null                  $year
     * @param int|null                  $month
     * @param int|null                  $day
     * @param \DateTimeZone|string|null $tz
     *
     * @return static
     */
    public static function createMidnightDate($year = null, $month = null, $day = null, $tz = null)
    {
        return static::create($year, $month, $day, 0, 0, 0, $tz);
    }

    /**
     * Create a Carbon instance from just a time. The date portion is set to today.
     *
     * @param int|null                  $hour
     * @param int|null                  $minute
     * @param int|null                  $second
     * @param \DateTimeZone|string|null $tz
     *
     * @throws \InvalidArgumentException
     *
     * @return static
     */
    public static function createFromTime($hour = 0, $minute = 0, $second = 0, $tz = null)
    {
        return static::create(null, null, null, $hour, $minute, $second, $tz);
    }

    /**
     * Create a Carbon instance from a time string. The date portion is set to today.
     *
     * @param string                    $time
     * @param \DateTimeZone|string|null $tz
     *
     * @throws \InvalidArgumentException
     *
     * @return static
     */
    public static function createFromTimeString($time, $tz = null)
    {
        return static::today($tz)->setTimeFromTimeString($time);
    }

    private static function createFromFormatAndTimezone($format, $time, $tz)
    {
        if ($tz === null) {
            return parent::createFromFormat($format, $time);
        }

        $tz = static::safeCreateDateTimeZone($tz);

        if ($tz === false) {
            return false;
        }

        return parent::createFromFormat($format, $time, $tz);
    }

    /**
     * Create a Carbon instance from a specific format.
     *
     * @param string                          $format Datetime format
     * @param string                          $time
     * @param \DateTimeZone|string|false|null $tz
     *
     * @throws InvalidArgumentException
     *
     * @return static|false
     */
    public static function createFromFormat($format, $time, $tz = null)
    {
        // First attempt to create an instance, so that error messages are based on the unmodified format.
        $date = self::createFromFormatAndTimezone($format, $time, $tz);
        $lastErrors = parent::getLastErrors();

        if (($mock = static::getTestNow()) && ($date instanceof DateTime || $date instanceof DateTimeInterface)) {
            // Set timezone from mock if custom timezone was neither given directly nor as a part of format.
            // First let's skip the part that will be ignored by the parser.
            $nonEscaped = '(?<!\\\\)(\\\\{2})*';

            $nonIgnored = preg_replace("/^.*{$nonEscaped}!/s", '', $format);

            if ($tz === null && !preg_match("/{$nonEscaped}[eOPT]/", $nonIgnored)) {
                $tz = $mock->getTimezone();
            }

            // Prepend mock datetime only if the format does not contain non escaped unix epoch reset flag.
            if (!preg_match("/{$nonEscaped}[!|]/", $format)) {
                $format = static::MOCK_DATETIME_FORMAT.' '.$format;
                $time = $mock->format(static::MOCK_DATETIME_FORMAT).' '.$time;
            }

            // Regenerate date from the modified format to base result on the mocked instance instead of now.
            $date = self::createFromFormatAndTimezone($format, $time, $tz);
        }

        if ($date instanceof DateTime || $date instanceof DateTimeInterface) {
            $instance = static::instance($date);
            $instance::setLastErrors($lastErrors);

            return $instance;
        }

        if (static::isStrictModeEnabled()) {
            throw new InvalidArgumentException(implode(PHP_EOL, $lastErrors['errors']));
        }

        return false;
    }

    /**
     * Set last errors.
     *
     * @param array $lastErrors
     *
     * @return void
     */
    private static function setLastErrors(array $lastErrors)
    {
        static::$lastErrors = $lastErrors;
    }

    /**
     * {@inheritdoc}
     */
    public static function getLastErrors()
    {
        return static::$lastErrors;
    }

    /**
     * Create a Carbon instance from a timestamp.
     *
     * @param int                       $timestamp
     * @param \DateTimeZone|string|null $tz
     *
     * @return static
     */
    public static function createFromTimestamp($timestamp, $tz = null)
    {
        return static::today($tz)->setTimestamp($timestamp);
    }

    /**
     * Create a Carbon instance from a timestamp in milliseconds.
     *
     * @param int                       $timestamp
     * @param \DateTimeZone|string|null $tz
     *
     * @return static
     */
    public static function createFromTimestampMs($timestamp, $tz = null)
    {
        return static::createFromFormat('U.u', sprintf('%F', $timestamp / 1000))
            ->setTimezone($tz);
    }

    /**
     * Create a Carbon instance from an UTC timestamp.
     *
     * @param int $timestamp
     *
     * @return static
     */
    public static function createFromTimestampUTC($timestamp)
    {
        return new static('@'.$timestamp);
    }

    /**
     * Make a Carbon instance from given variable if possible.
     *
     * Always return a new instance. Parse only strings and only these likely to be dates (skip intervals
     * and recurrences). Throw an exception for invalid format, but otherwise return null.
     *
     * @param mixed $var
     *
     * @return static|null
     */
    public static function make($var)
    {
        if ($var instanceof DateTimeInterface) {
            return static::instance($var);
        }

        if (is_string($var)) {
            $var = trim($var);
            $first = substr($var, 0, 1);

            if (is_string($var) && $first !== 'P' && $first !== 'R' && preg_match('/[a-z0-9]/i', $var)) {
                return static::parse($var);
            }
        }
    }

    /**
     * Get a copy of the instance.
     *
     * @return static
     */
    public function copy()
    {
        return clone $this;
    }

    /**
     * @alias copy
     *
     * Get a copy of the instance.
     *
     * @return static
     */
    public function clone()
    {
        return clone $this;
    }

    /**
     * Returns a present instance in the same timezone.
     *
     * @return static
     */
    public function nowWithSameTz()
    {
        return static::now($this->getTimezone());
    }

    /**
     * Throws an exception if the given object is not a DateTime and does not implement DateTimeInterface.
     *
     * @param mixed        $date
     * @param string|array $other
     *
     * @throws \InvalidArgumentException
     */
    protected static function expectDateTime($date, $other = [])
    {
        $message = 'Expected ';
        foreach ((array) $other as $expect) {
            $message .= "$expect, ";
        }

        if (!$date instanceof DateTime && !$date instanceof DateTimeInterface) {
            throw new InvalidArgumentException(
                $message.'DateTime or DateTimeInterface, '.
                (is_object($date) ? get_class($date) : gettype($date)).' given'
            );
        }
    }

    /**
     * Return the Carbon instance passed through, a now instance in the same timezone
     * if null given or parse the input if string given.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|string|null $date
     *
     * @return static
     */
    protected function resolveCarbon($date = null)
    {
        if (!$date) {
            return $this->nowWithSameTz();
        }

        if (is_string($date)) {
            return static::parse($date, $this->getTimezone());
        }

        static::expectDateTime($date, ['null', 'string']);

        return $date instanceof self ? $date : static::instance($date);
    }

    ///////////////////////////////////////////////////////////////////
    ///////////////////////// GETTERS AND SETTERS /////////////////////
    ///////////////////////////////////////////////////////////////////

    /**
     * Get a part of the Carbon object
     *
     * @param string $name
     *
     * @throws \InvalidArgumentException
     *
     * @return string|int|bool|\DateTimeZone|null
     */
    public function __get($name)
    {
        return $this->get($name);
    }

    /**
     * Get a part of the Carbon object
     *
     * @param string $name
     *
     * @throws \InvalidArgumentException
     *
     * @return string|int|bool|\DateTimeZone|null
     */
    public function get($name)
    {
        static $formats = [
            // @property int
            'year' => 'Y',
            // @property int
            'yearIso' => 'o',
            // @property int
            // @call isSameUnit
            'month' => 'n',
            // @property int
            'day' => 'j',
            // @property int
            'hour' => 'G',
            // @property int
            'minute' => 'i',
            // @property int
            'second' => 's',
            // @property int
            'micro' => 'u',
            // @property int
            'microsecond' => 'u',
            // @property-read int 0 (for Sunday) through 6 (for Saturday)
            'dayOfWeek' => 'w',
            // @property-read int 1 (for Monday) through 7 (for Sunday)
            'dayOfWeekIso' => 'N',
            // @property-read int ISO-8601 week number of year, weeks starting on Monday
            'weekOfYear' => 'W',
            // @property-read int number of days in the given month
            'daysInMonth' => 't',
            // @property int seconds since the Unix Epoch
            'timestamp' => 'U',
            // @property-read string "am"/"pm" (Ante meridiem or Post meridiem latin lowercase mark)
            'latinMeridiem' => 'a',
            // @property-read string "AM"/"PM" (Ante meridiem or Post meridiem latin uppercase mark)
            'latinUpperMeridiem' => 'A',
            // @property string the day of week in English
            'englishDayOfWeek' => 'l',
            // @property string the abbreviated day of week in English
            'shortEnglishDayOfWeek' => 'D',
            // @property string the day of week in English
            'englishMonth' => 'F',
            // @property string the abbreviated day of week in English
            'shortEnglishMonth' => 'M',
            // @property string the day of week in current locale LC_TIME
            'localeDayOfWeek' => '%A',
            // @property string the abbreviated day of week in current locale LC_TIME
            'shortLocaleDayOfWeek' => '%a',
            // @property string the month in current locale LC_TIME
            'localeMonth' => '%B',
            // @property string the abbreviated month in current locale LC_TIME
            'shortLocaleMonth' => '%b',
        ];

        switch (true) {
            case isset($formats[$name]):
                $format = $formats[$name];
                $method = substr($format, 0, 1) === '%' ? 'formatLocalized' : 'format';
                $value = $this->$method($format);

                return is_numeric($value) ? (int) $value : $value;

            // @property-read string long name of weekday translated according to Carbon locale, in english if no translation available for current language
            case $name === 'dayName':
                return $this->getTranslationMessage('weekdays.'.$this->dayOfWeek, null, $this->englishDayOfWeek);
            // @property-read string short name of weekday translated according to Carbon locale, in english if no translation available for current language
            case $name === 'shortDayName':
                return $this->getTranslationMessage('weekdays_short.'.$this->dayOfWeek, null, $this->shortEnglishDayOfWeek);
            // @property-read string very short name of weekday translated according to Carbon locale, in english if no translation available for current language
            case $name === 'minDayName':
                return $this->getTranslationMessage('weekdays_min.'.$this->dayOfWeek, null, $this->shortEnglishDayOfWeek);
            // @property-read string long name of month translated according to Carbon locale, in english if no translation available for current language
            case $name === 'monthName':
                return $this->getTranslationMessage('months.'.($this->month - 1), null, $this->englishMonth);
            // @property-read string short name of month translated according to Carbon locale, in english if no translation available for current language
            case $name === 'shortMonthName':
                return $this->getTranslationMessage('months_short.'.($this->month - 1), null, $this->shortEnglishMonth);
            // @property-read string lowercase meridiem mark translated according to Carbon locale, in latin if no translation available for current language
            case $name === 'meridiem':
                $meridiem = $this->translate('meridiem', [
                    'hour' => $this->hour,
                    'minute' => $this->minute,
                    'isLower' => true,
                ]);

                return $meridiem === 'meridiem' ? $this->latinMeridiem : $meridiem;
            // @property-read string uppercase meridiem mark translated according to Carbon locale, in latin if no translation available for current language
            case $name === 'upperMeridiem':
                $meridiem = $this->translate('meridiem', [
                    'hour' => $this->hour,
                    'minute' => $this->minute,
                    'isLower' => false,
                ]);

                return $meridiem === 'meridiem' ? $this->latinUpperMeridiem : $meridiem;
            // @property-read int current hour from 1 to 24
            case $name === 'noZeroHour':
                return $this->hour ?: 24;
            // @property int
            case $name === 'milliseconds':
                // @property int
            case $name === 'millisecond':
            // @property int
            case $name === 'milli':
                return (int) floor($this->format('u') / 1000);

            // @property int 1 through 53
            case $name === 'week':
                return (int) $this->week();

            // @property int 1 through 53
            case $name === 'isoWeek':
                return (int) $this->isoWeek();

            // @property int year according to week format
            case $name === 'weekYear':
                return (int) $this->weekYear();

            // @property int year according to ISO week format
            case $name === 'isoWeekYear':
                return (int) $this->isoWeekYear();

            // @property-read int 51 through 53
            case $name === 'weeksInYear':
                return (int) $this->weeksInYear();

            // @property-read int 51 through 53
            case $name === 'isoWeeksInYear':
                return (int) $this->isoWeeksInYear();

            // @property-read int 1 through 5
            case $name === 'weekOfMonth':
                return (int) ceil($this->day / static::DAYS_PER_WEEK);

            // @property-read int 1 through 5
            case $name === 'weekNumberInMonth':
                return (int) ceil(($this->day + $this->copy()->startOfMonth()->dayOfWeekIso - 1) / static::DAYS_PER_WEEK);

            // @property-read int 0 through 6
            case $name === 'firstWeekDay':
                return $this->localTranslator ? ($this->getTranslationMessage('first_day_of_week') ?? 0) : static::getWeekStartsAt();

            // @property-read int 0 through 6
            case $name === 'lastWeekDay':
                return $this->localTranslator ? (($this->getTranslationMessage('first_day_of_week') ?? 0) + static::DAYS_PER_WEEK - 1) % static::DAYS_PER_WEEK : static::getWeekEndsAt();

            // @property int 1 through 366
            case $name === 'dayOfYear':
                return 1 + intval($this->format('z'));

            // @property-read int 365 or 366
            case $name === 'daysInYear':
                return $this->isLeapYear() ? 366 : 365;

            // @property int does a diffInYears() with default parameters
            case $name === 'age':
                return $this->diffInYears();

            // @property-read int the quarter of this instance, 1 - 4
            // @call isSameUnit
            case $name === 'quarter':
                return (int) ceil($this->month / static::MONTHS_PER_QUARTER);

            // @property-read int the decade of this instance
            // @call isSameUnit
            case $name === 'decade':
                return (int) ceil($this->year / static::YEARS_PER_DECADE);

            // @property-read int the century of this instance
            // @call isSameUnit
            case $name === 'century':
                $factor = 1;
                $year = $this->year;
                if ($year < 0) {
                    $year = -$year;
                    $factor = -1;
                }

                return (int) ($factor * ceil($year / static::YEARS_PER_CENTURY));

            // @property-read int the millennium of this instance
            // @call isSameUnit
            case $name === 'millennium':
                $factor = 1;
                $year = $this->year;
                if ($year < 0) {
                    $year = -$year;
                    $factor = -1;
                }

                return (int) ($factor * ceil($year / static::YEARS_PER_MILLENNIUM));

            // @property int the timezone offset in seconds from UTC
            case $name === 'offset':
                return $this->getOffset();

            // @property int the timezone offset in minutes from UTC
            case $name === 'offsetMinutes':
                return $this->getOffset() / static::SECONDS_PER_MINUTE;

            // @property int the timezone offset in hours from UTC
            case $name === 'offsetHours':
                return $this->getOffset() / static::SECONDS_PER_MINUTE / static::MINUTES_PER_HOUR;

            // @property-read bool daylight savings time indicator, true if DST, false otherwise
            case $name === 'dst':
                return $this->format('I') === '1';

            // @property-read bool checks if the timezone is local, true if local, false otherwise
            case $name === 'local':
                return $this->getOffset() === $this->copy()->setTimezone(date_default_timezone_get())->getOffset();

            // @property-read bool checks if the timezone is UTC, true if UTC, false otherwise
            case $name === 'utc':
                return $this->getOffset() === 0;

            // @property CarbonTimeZone $timezone the current timezone
            // @property CarbonTimeZone $tz alias of $timezone
            case $name === 'timezone' || $name === 'tz':
                return CarbonTimeZone::instance($this->getTimezone());

            // @property-read string $timezoneName the current timezone name
            // @property-read string $tzName alias of $timezoneName
            case $name === 'timezoneName' || $name === 'tzName':
                return $this->getTimezone()->getName();

            // @property-read string $timezoneAbbreviatedName the current timezone abbreviated name
            // @property-read string $tzAbbrName alias of $timezoneAbbreviatedName
            case $name === 'timezoneAbbreviatedName' || $name === 'tzAbbrName':
                return CarbonTimeZone::instance($this->getTimezone())->getAbbr($this->dst);

            // @property-read string locale of the current instance
            case $name === 'locale':
                return $this->getLocalTranslator()->getLocale();

            default:
                if (static::hasMacro($macro = 'get'.ucfirst($name))) {
                    return $this->$macro();
                }

                throw new InvalidArgumentException(sprintf("Unknown getter '%s'", $name));
        }
    }

    /**
     * Check if an attribute exists on the object
     *
     * @param string $name
     *
     * @return bool
     */
    public function __isset($name)
    {
        try {
            $this->__get($name);
        } catch (InvalidArgumentException $e) {
            return false;
        }

        return true;
    }

    /**
     * Set a part of the Carbon object
     *
     * @param string                   $name
     * @param string|int|\DateTimeZone $value
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function __set($name, $value)
    {
        $this->set($name, $value);
    }

    /**
     * Set a part of the Carbon object
     *
     * @param string|array             $name
     * @param string|int|\DateTimeZone $value
     *
     * @throws \InvalidArgumentException
     *
     * @return $this
     */
    public function set($name, $value = null)
    {
        if ($this->isImmutable()) {
            throw new \RuntimeException(sprintf(
                '%s class is immutable.', static::class
            ));
        }

        if (is_array($name)) {
            foreach ($name as $_name => $value) {
                $this->set($_name, $value);
            }

            return $this;
        }

        switch ($name) {
            case 'milliseconds':
            case 'millisecond':
            case 'milli':
                $value *= 1000;
            case 'microseconds':
            case 'microsecond':
            case 'micro':
                while ($value < 0) {
                    $this->subSecond();
                    $value += static::MICROSECONDS_PER_SECOND;
                }
                while ($value >= static::MICROSECONDS_PER_SECOND) {
                    $this->addSecond();
                    $value -= static::MICROSECONDS_PER_SECOND;
                }
                $this->modify($this->format('H:i:s.').str_pad(round($value), 6, '0', STR_PAD_LEFT));
                break;

            case 'year':
            case 'month':
            case 'day':
            case 'hour':
            case 'minute':
            case 'second':
                list($year, $month, $day, $hour, $minute, $second) = explode('-', $this->format('Y-n-j-G-i-s'));
                $$name = $value;
                $this->setDateTime($year, $month, $day, $hour, $minute, $second);
                break;

            case 'week':
                return $this->week($value);

            case 'isoWeek':
                return $this->isoWeek($value);

            case 'weekYear':
                return $this->weekYear($value);

            case 'isoWeekYear':
                return $this->isoWeekYear($value);

            case 'dayOfYear':
                return $this->addDays($value - $this->dayOfYear);

            case 'timestamp':
                parent::setTimestamp($value);
                break;

            case 'offset':
                $this->setTimezone(static::safeCreateDateTimeZone($value / static::SECONDS_PER_MINUTE / static::MINUTES_PER_HOUR));
                break;

            case 'offsetMinutes':
                $this->setTimezone(static::safeCreateDateTimeZone($value / static::MINUTES_PER_HOUR));
                break;

            case 'offsetHours':
                $this->setTimezone(static::safeCreateDateTimeZone($value));
                break;

            case 'timezone':
            case 'tz':
                $this->setTimezone($value);
                break;

            default:
                if (static::hasMacro($macro = 'set'.ucfirst($name))) {
                    $this->$macro($value);

                    break;
                }

                if (static::isStrictModeEnabled()) {
                    throw new InvalidArgumentException(sprintf("Unknown setter '%s'", $name));
                }

                $this->$name = $value;
        }

        return $this;
    }

    /**
     * Get/set the day of year.
     *
     * @param int|null $value new value for day of year if using as setter.
     *
     * @return static|int
     */
    public function dayOfYear($value = null)
    {
        $dayOfYear = $this->dayOfYear;

        return is_null($value) ? $dayOfYear : $this->addDays($value - $dayOfYear);
    }

    /**
     * Get/set the weekday from 0 (Sunday) to 6 (Saturday).
     *
     * @param int|null $value new value for weekday if using as setter.
     *
     * @return static|int
     */
    public function weekday($value = null)
    {
        $dayOfWeek = ($this->dayOfWeek + 7 - intval($this->getTranslationMessage('first_day_of_week') ?? 0)) % 7;

        return is_null($value) ? $dayOfWeek : $this->addDays($value - $dayOfWeek);
    }

    /**
     * Get/set the ISO weekday from 1 (Monday) to 7 (Sunday).
     *
     * @param int|null $value new value for weekday if using as setter.
     *
     * @return static|int
     */
    public function isoWeekday($value = null)
    {
        $dayOfWeekIso = $this->dayOfWeekIso;

        return is_null($value) ? $dayOfWeekIso : $this->addDays($value - $dayOfWeekIso);
    }

    /**
     * Set any unit to a new value without overflowing current other unit given.
     *
     * @param string $valueUnit    unit name to modify
     * @param int    $value        new value for the input unit
     * @param string $overflowUnit unit name to not overflow
     *
     * @return static
     */
    public function setUnitNoOverflow($valueUnit, $value, $overflowUnit)
    {
        try {
            $original = $this->copy();
            /** @var CarbonInterface $date */
            $date = $this->$valueUnit($value);
            $end = $original->copy()->endOf($overflowUnit);
            $start = $original->copy()->startOf($overflowUnit);
            if ($date < $start) {
                $date = $date->setDateTimeFrom($start);
            } elseif ($date > $end) {
                $date = $date->setDateTimeFrom($end);
            }

            return $date;
        } catch (BadMethodCallException | ReflectionException $exception) {
            throw new InvalidArgumentException("Unknown unit '$valueUnit'", 0, $exception);
        }
    }

    /**
     * Add any unit to a new value without overflowing current other unit given.
     *
     * @param string $valueUnit    unit name to modify
     * @param int    $value        amount to add to the input unit
     * @param string $overflowUnit unit name to not overflow
     *
     * @return static
     */
    public function addUnitNoOverflow($valueUnit, $value, $overflowUnit)
    {
        return $this->setUnitNoOverflow($valueUnit, $this->$valueUnit + $value, $overflowUnit);
    }

    /**
     * Subtract any unit to a new value without overflowing current other unit given.
     *
     * @param string $valueUnit    unit name to modify
     * @param int    $value        amount to subtract to the input unit
     * @param string $overflowUnit unit name to not overflow
     *
     * @return static
     */
    public function subUnitNoOverflow($valueUnit, $value, $overflowUnit)
    {
        return $this->setUnitNoOverflow($valueUnit, $this->$valueUnit - $value, $overflowUnit);
    }

    /**
     * Returns the minutes offset to UTC if no arguments passed, else set the timezone with given minutes shift passed.
     *
     * @param int|null $offset
     *
     * @return int|static
     */
    public function utcOffset(int $offset = null)
    {
        if (func_num_args() < 1) {
            return $this->offsetMinutes;
        }

        return $this->setTimezone(static::safeCreateDateTimeZone($offset / static::MINUTES_PER_HOUR));
    }

    /**
     * Sets the current date of the DateTime object to a different date.
     * Calls modify as a workaround for a php bug.
     *
     * @param int $year
     * @param int $month
     * @param int $day
     *
     * @return static
     *
     * @see https://github.com/briannesbitt/Carbon/issues/539
     * @see https://bugs.php.net/bug.php?id=63863
     */
    public function setDate($year, $month, $day)
    {
        $this->modify('+0 day');

        return parent::setDate($year, $month, $day);
    }

    /**
     * Set the date and time all together.
     *
     * @param int $year
     * @param int $month
     * @param int $day
     * @param int $hour
     * @param int $minute
     * @param int $second
     *
     * @return static
     */
    public function setDateTime($year, $month, $day, $hour, $minute, $second = 0, $microseconds = 0)
    {
        return $this->setDate($year, $month, $day)->setTime($hour, $minute, $second, $microseconds);
    }

    /**
     * Set the time by time string.
     *
     * @param string $time
     *
     * @return static
     */
    public function setTimeFromTimeString($time)
    {
        if (strpos($time, ':') === false) {
            $time .= ':0';
        }

        return $this->modify($time);
    }

    /**
     * Set the instance's timestamp.
     *
     * @param int $value
     *
     * @return static
     */
    public function timestamp($value)
    {
        return $this->setTimestamp($value);
    }

    /**
     * @alias setTimezone
     *
     * @param \DateTimeZone|string $value
     *
     * @return static
     */
    public function timezone($value)
    {
        return $this->setTimezone($value);
    }

    /**
     * Set the timezone or returns the timezone name if no arguments passed.
     *
     * @param \DateTimeZone|string $value
     *
     * @return CarbonInterface|string
     */
    public function tz($value = null)
    {
        if (func_num_args() < 1) {
            return $this->tzName;
        }

        return $this->setTimezone($value);
    }

    /**
     * Set the instance's timezone from a string or object.
     *
     * @param \DateTimeZone|string $value
     *
     * @return static
     */
    public function setTimezone($value)
    {
        /** @var static $date */
        $date = parent::setTimezone(static::safeCreateDateTimeZone($value));
        // https://bugs.php.net/bug.php?id=72338
        // just workaround on this bug
        $date->getTimestamp();

        return $date;
    }

    /**
     * Set the instance's timezone to UTC.
     *
     * @return static
     */
    public function utc()
    {
        return $this->setTimezone('UTC');
    }

    /**
     * Set the year, month, and date for this instance to that of the passed instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface $date now if null
     *
     * @return static
     */
    public function setDateFrom($date = null)
    {
        $date = $this->resolveCarbon($date);

        return $this->setDate($date->year, $date->month, $date->day);
    }

    /**
     * Set the hour, minute, second and microseconds for this instance to that of the passed instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface $date now if null
     *
     * @return static
     */
    public function setTimeFrom($date = null)
    {
        $date = $this->resolveCarbon($date);

        return $this->setTime($date->hour, $date->minute, $date->second, $date->microsecond);
    }

    /**
     * Set the date and time for this instance to that of the passed instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface $date
     *
     * @return static
     */
    public function setDateTimeFrom($date = null)
    {
        $date = $this->resolveCarbon($date);

        return $this->modify($date->format('Y-m-d H:i:s.u'));
    }

    /**
     * Get the days of the week
     *
     * @return array
     */
    public static function getDays()
    {
        return static::$days;
    }

    ///////////////////////////////////////////////////////////////////
    /////////////////////// WEEK SPECIAL DAYS /////////////////////////
    ///////////////////////////////////////////////////////////////////

    /**
     * Get the first day of week
     *
     * @return int
     */
    public static function getWeekStartsAt()
    {
        return static::$weekStartsAt;
    }

    /**
     * @deprecated To avoid conflict between different third-party libraries, static setters should not be used.
     *             Use $weekEndsAt optional parameter instead when using endOfWeek method. You can also use the
     *             'first_day_of_week' locale setting to change the start of week according to current locale
     *             selected and implicitly the end of week.
     *
     * Set the first day of week
     *
     * @param int $day week start day
     *
     * @return void
     */
    public static function setWeekStartsAt($day)
    {
        static::$weekStartsAt = max(0, (7 + $day) % 7);
    }

    /**
     * Get the last day of week
     *
     * @return int
     */
    public static function getWeekEndsAt()
    {
        return static::$weekEndsAt;
    }

    /**
     * @deprecated To avoid conflict between different third-party libraries, static setters should not be used.
     *             Use $weekStartsAt optional parameter instead when using startOfWeek, floorWeek, ceilWeek
     *             or roundWeek method. You can also use the 'first_day_of_week' locale setting to change the
     *             start of week according to current locale selected and implicitly the end of week.
     *
     * Set the last day of week
     *
     * @param int $day
     *
     * @return void
     */
    public static function setWeekEndsAt($day)
    {
        static::$weekEndsAt = max(0, (7 + $day) % 7);
    }

    /**
     * Get weekend days
     *
     * @return array
     */
    public static function getWeekendDays()
    {
        return static::$weekendDays;
    }

    /**
     * @deprecated To avoid conflict between different third-party libraries, static setters should not be used.
     *             You should rather consider week-end is always saturday and sunday, and if you have some custom
     *             week-end days to handle, give to those days an other name and create a macro for them:
     *
     *             ```
     *             Carbon::macro('isDayOff', function ($date) {
     *                 return $date->isSunday() || $date->isMonday();
     *             });
     *             Carbon::macro('isNotDayOff', function ($date) {
     *                 return !$date->isDayOff();
     *             });
     *             if ($someDate->isDayOff()) ...
     *             if ($someDate->isNotDayOff()) ...
     *             // Add 5 not-off days
     *             $count = 5;
     *             while ($someDate->isDayOff() || ($count-- > 0)) {
     *                 $someDate->addDay();
     *             }
     *             ```
     *
     * Set weekend days
     *
     * @param array $days
     *
     * @return void
     */
    public static function setWeekendDays($days)
    {
        static::$weekendDays = $days;
    }

    /**
     * get midday/noon hour
     *
     * @return int
     */
    public static function getMidDayAt()
    {
        return static::$midDayAt;
    }

    /**
     * @deprecated To avoid conflict between different third-party libraries, static setters should not be used.
     *             You should rather consider mid-day is always 12pm, then if you need to test if it's an other
     *             hour, test it explicitly:
     *                 $date->format('G') == 13
     *             or to set explicitly to a given hour:
     *                 $date->setTime(13, 0, 0, 0)
     *
     * Set midday/noon hour
     *
     * @param int $hour midday hour
     *
     * @return void
     */
    public static function setMidDayAt($hour)
    {
        static::$midDayAt = $hour;
    }

    /**
     * Determine if a time string will produce a relative date.
     *
     * @param string $time
     *
     * @return bool true if time match a relative date, false if absolute or invalid time string
     */
    public static function hasRelativeKeywords($time)
    {
        if (strtotime($time) === false) {
            return false;
        }

        $date1 = new DateTime('2000-01-01T00:00:00Z');
        $date1->modify($time);
        $date2 = new DateTime('2001-12-25T00:00:00Z');
        $date2->modify($time);

        return $date1 != $date2;
    }

    ///////////////////////////////////////////////////////////////////
    /////////////////////// STRING FORMATTING /////////////////////////
    ///////////////////////////////////////////////////////////////////

    /**
     * @deprecated To avoid conflict between different third-party libraries, static setters should not be used.
     *             You should rather use UTF-8 language packages on every machine.
     *
     * Set if UTF8 will be used for localized date/time.
     *
     * @param bool $utf8
     */
    public static function setUtf8($utf8)
    {
        static::$utf8 = $utf8;
    }

    /**
     * Format the instance with the current locale.  You can set the current
     * locale using setlocale() http://php.net/setlocale.
     *
     * @param string $format
     *
     * @return string
     */
    public function formatLocalized($format)
    {
        // Check for Windows to find and replace the %e modifier correctly.
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $format = preg_replace('#(?<!%)((?:%%)*)%e#', '\1%#d', $format); // @codeCoverageIgnore
        }

        $formatted = strftime($format, strtotime($this->toDateTimeString()));

        return static::$utf8 ? utf8_encode($formatted) : $formatted;
    }

    /**
     * Reset the format used to the default when type juggling a Carbon instance to a string
     *
     * @return void
     */
    public static function resetToStringFormat()
    {
        static::setToStringFormat(static::DEFAULT_TO_STRING_FORMAT);
    }

    /**
     * @deprecated To avoid conflict between different third-party libraries, static setters should not be used.
     *             You should rather let Carbon object being casted to string with DEFAULT_TO_STRING_FORMAT, and
     *             use other method or custom format passed to format() method if you need to dump an other string
     *             format.
     *
     * Set the default format used when type juggling a Carbon instance to a string
     *
     * @param string $format
     *
     * @return void
     */
    public static function setToStringFormat($format)
    {
        static::$toStringFormat = $format;
    }

    /**
     * Format the instance as a string using the set format
     *
     * @return string
     */
    public function __toString()
    {
        $format = static::$toStringFormat;

        return $this->format($format instanceof Closure ? $format($this) : $format);
    }

    /**
     * Format the instance as date
     *
     * @return string
     */
    public function toDateString()
    {
        return $this->format('Y-m-d');
    }

    /**
     * Format the instance as a readable date
     *
     * @return string
     */
    public function toFormattedDateString()
    {
        return $this->format('M j, Y');
    }

    /**
     * Format the instance as time
     *
     * @return string
     */
    public function toTimeString()
    {
        return $this->format('H:i:s');
    }

    /**
     * Format the instance as date and time
     *
     * @return string
     */
    public function toDateTimeString()
    {
        return $this->format('Y-m-d H:i:s');
    }

    /**
     * Format the instance with day, date and time
     *
     * @return string
     */
    public function toDayDateTimeString()
    {
        return $this->format('D, M j, Y g:i A');
    }

    /**
     * Format the instance as ATOM
     *
     * @return string
     */
    public function toAtomString()
    {
        return $this->format(DateTime::ATOM);
    }

    /**
     * Format the instance as COOKIE
     *
     * @return string
     */
    public function toCookieString()
    {
        return $this->format(DateTime::COOKIE);
    }

    /**
     * Format the instance as ISO8601
     *
     * @return string
     */
    public function toIso8601String()
    {
        return $this->toAtomString();
    }

    /**
     * Format the instance as RFC822
     *
     * @return string
     */
    public function toRfc822String()
    {
        return $this->format(DateTime::RFC822);
    }

    /**
     * Convert the instance to UTC and return as Zulu ISO8601
     *
     * @return string
     */
    public function toIso8601ZuluString()
    {
        return $this->copy()->utc()->format('Y-m-d\TH:i:s\Z');
    }

    /**
     * Format the instance as RFC850
     *
     * @return string
     */
    public function toRfc850String()
    {
        return $this->format(DateTime::RFC850);
    }

    /**
     * Format the instance as RFC1036
     *
     * @return string
     */
    public function toRfc1036String()
    {
        return $this->format(DateTime::RFC1036);
    }

    /**
     * Format the instance as RFC1123
     *
     * @return string
     */
    public function toRfc1123String()
    {
        return $this->format(DateTime::RFC1123);
    }

    /**
     * Format the instance as RFC2822
     *
     * @return string
     */
    public function toRfc2822String()
    {
        return $this->format(DateTime::RFC2822);
    }

    /**
     * Format the instance as RFC3339
     *
     * @return string
     */
    public function toRfc3339String()
    {
        return $this->format(DateTime::RFC3339);
    }

    /**
     * Format the instance as RSS
     *
     * @return string
     */
    public function toRssString()
    {
        return $this->format(DateTime::RSS);
    }

    /**
     * Format the instance as W3C
     *
     * @return string
     */
    public function toW3cString()
    {
        return $this->format(DateTime::W3C);
    }

    /**
     * Format the instance as RFC7231
     *
     * @return string
     */
    public function toRfc7231String()
    {
        return $this->copy()
            ->setTimezone('GMT')
            ->format(static::RFC7231_FORMAT);
    }

    /**
     * Get default array representation.
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'year' => $this->year,
            'month' => $this->month,
            'day' => $this->day,
            'dayOfWeek' => $this->dayOfWeek,
            'dayOfYear' => $this->dayOfYear,
            'hour' => $this->hour,
            'minute' => $this->minute,
            'second' => $this->second,
            'micro' => $this->micro,
            'timestamp' => $this->timestamp,
            'formatted' => $this->format(self::DEFAULT_TO_STRING_FORMAT),
            'timezone' => $this->timezone,
        ];
    }

    /**
     * Get default object representation.
     *
     * @return object
     */
    public function toObject()
    {
        return (object) $this->toArray();
    }

    /**
     * Returns english human readable complete date string.
     *
     * @return string
     */
    public function toString()
    {
        return $this->copy()->locale('en')->isoFormat('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
    }

    /**
     * Return the ISO-8601 string (ex: 1977-04-22T06:00:00Z, if $keepOffset truthy, offset will be kept:
     * 1977-04-22T01:00:00-05:00).
     *
     * @param bool $keepOffset Pass true to keep the date offset. Else forced to UTC.
     *
     * @return null|string
     */
    public function toISOString($keepOffset = false)
    {
        if (!$this->isValid()) {
            return null;
        }

        $keepOffset = (bool) $keepOffset;
        $yearFormat = true ? 'YYYY' : 'YYYYYY';
        $tzFormat = $keepOffset ? 'Z' : '[Z]';
        $date = $keepOffset ? $this : $this->copy()->utc();

        return $date->isoFormat("$yearFormat-MM-DD[T]HH:mm:ss.SSSSSS$tzFormat");
    }

    /**
     * Return the ISO-8601 string (ex: 1977-04-22T06:00:00Z) with UTC timezone.
     *
     * @return null|string
     */
    public function toJSON()
    {
        return $this->toISOString();
    }

    /**
     * Return native DateTime PHP object matching the current instance.
     *
     * @return DateTime
     */
    public function toDateTime()
    {
        return new DateTime($this->format('Y-m-d H:i:s.u'), $this->getTimezone());
    }

    /**
     * @alias toDateTime
     *
     * Return native DateTime PHP object matching the current instance.
     *
     * @return DateTime
     */
    public function toDate()
    {
        return $this->toDateTime();
    }

    /**
     * Returns raw translation message for a given key.
     *
     * @param string      $key     key to find
     * @param string|null $locale  current locale used if null
     * @param string|null $default default value if translation returns the key
     *
     * @return string
     */
    public function getTranslationMessage(string $key, string $locale = null, string $default = null)
    {
        $translator = $this->getLocalTranslator();
        if (!($translator instanceof TranslatorBagInterface && $translator instanceof TranslatorInterface)) {
            throw new InvalidArgumentException(
                'Translator does not implement '.TranslatorInterface::class.' and '.TranslatorBagInterface::class.'.'
            );
        }

        $result = $translator->getCatalogue($locale ?? $translator->getLocale())->get($key);

        return $result === $key ? $default : $result;
    }

    /**
     * Returns list of locale formats for ISO formatting.
     *
     * @param string|null $locale current locale used if null
     *
     * @return array
     */
    public function getIsoFormats($locale = null)
    {
        return [
            'LT' => $this->getTranslationMessage('formats.LT', $locale, 'h:mm A'),
            'LTS' => $this->getTranslationMessage('formats.LTS', $locale, 'h:mm:ss A'),
            'L' => $this->getTranslationMessage('formats.L', $locale, 'MM/DD/YYYY'),
            'LL' => $this->getTranslationMessage('formats.LL', $locale, 'MMMM D, YYYY'),
            'LLL' => $this->getTranslationMessage('formats.LLL', $locale, 'MMMM D, YYYY h:mm A'),
            'LLLL' => $this->getTranslationMessage('formats.LLLL', $locale, 'dddd, MMMM D, YYYY h:mm A'),
        ];
    }

    /**
     * Returns list of calendar formats for ISO formatting.
     *
     * @param string|null $locale current locale used if null
     *
     * @return array
     */
    public function getCalendarFormats($locale = null)
    {
        return [
            'sameDay' => $this->getTranslationMessage('calendar.sameDay', $locale, '[Today at] LT'),
            'nextDay' => $this->getTranslationMessage('calendar.nextDay', $locale, '[Tomorrow at] LT'),
            'nextWeek' => $this->getTranslationMessage('calendar.nextWeek', $locale, 'dddd [at] LT'),
            'lastDay' => $this->getTranslationMessage('calendar.lastDay', $locale, '[Yesterday at] LT'),
            'lastWeek' => $this->getTranslationMessage('calendar.lastWeek', $locale, '[Last] dddd [at] LT'),
            'sameElse' => $this->getTranslationMessage('calendar.sameElse', $locale, 'L'),
        ];
    }

    /**
     * Returns list of locale units for ISO formatting.
     *
     * @return array
     */
    public static function getIsoUnits()
    {
        static $units = null;
        if ($units === null) {
            $units = [
                'D' => 'day',
                'DD' => ['format', ['d']],
                'Do' => ['ordinal', ['day', 'D']],
                'd' => 'dayOfWeek',
                'dd' => 'minDayName',
                'ddd' => 'shortDayName',
                'dddd' => 'dayName',
                'DDD' => 'dayOfYear',
                'DDDD' => ['getPaddedUnit', ['dayOfYear', 3]],
                'DDDo' => ['ordinal', ['dayOfYear', 'DDD']],
                'e' => 'dayOfWeek',
                'E' => 'dayOfWeekIso',
                'H' => ['format', ['G']],
                'HH' => ['format', ['H']],
                'h' => ['format', ['g']],
                'hh' => ['format', ['h']],
                'k' => 'noZeroHour',
                'kk' => ['getPaddedUnit', ['noZeroHour']],
                'hmm' => ['format', ['gi']],
                'hmmss' => ['format', ['gis']],
                'Hmm' => ['format', ['Gi']],
                'Hmmss' => ['format', ['Gis']],
                'm' => 'minute',
                'mm' => ['format', ['i']],
                'a' => 'meridiem',
                'A' => 'upperMeridiem',
                's' => 'second',
                'ss' => ['getPaddedUnit', ['second']],
                'S' => function (CarbonInterface $date) {
                    return strval(round($date->micro / 100000));
                },
                'SS' => function (CarbonInterface $date) {
                    return str_pad(round($date->micro / 10000), 2, '0', STR_PAD_LEFT);
                },
                'SSS' => function (CarbonInterface $date) {
                    return str_pad(round($date->micro / 1000), 3, '0', STR_PAD_LEFT);
                },
                'SSSS' => function (CarbonInterface $date) {
                    return str_pad(round($date->micro / 100), 4, '0', STR_PAD_LEFT);
                },
                'SSSSS' => function (CarbonInterface $date) {
                    return str_pad(round($date->micro / 10), 5, '0', STR_PAD_LEFT);
                },
                'SSSSSS' => ['getPaddedUnit', ['micro', 6]],
                'SSSSSSS' => ['getPaddedUnit', ['micro', 7]],
                'SSSSSSSS' => ['getPaddedUnit', ['micro', 8]],
                'SSSSSSSSS' => ['getPaddedUnit', ['micro', 9]],
                'M' => 'month',
                'MM' => ['format', ['m']],
                'MMM' => function (CarbonInterface $date) {
                    $month = $date->shortMonthName;
                    $suffix = $date->getTranslationMessage('mmm_suffix');
                    if ($suffix && $month !== $date->monthName) {
                        $month .= $suffix;
                    }

                    return $month;
                },
                'MMMM' => 'monthName',
                'Mo' => ['ordinal', ['month', 'M']],
                'Q' => 'quarter',
                'Qo' => ['ordinal', ['quarter', 'M']],
                'G' => 'isoWeekYear',
                'GG' => ['getPaddedUnit', ['isoWeekYear']],
                'GGG' => ['getPaddedUnit', ['isoWeekYear', 3]],
                'GGGG' => ['getPaddedUnit', ['isoWeekYear', 4]],
                'GGGGG' => ['getPaddedUnit', ['isoWeekYear', 5]],
                'g' => 'weekYear',
                'gg' => ['getPaddedUnit', ['weekYear']],
                'ggg' => ['getPaddedUnit', ['weekYear', 3]],
                'gggg' => ['getPaddedUnit', ['weekYear', 4]],
                'ggggg' => ['getPaddedUnit', ['weekYear', 5]],
                'W' => 'isoWeek',
                'WW' => ['getPaddedUnit', ['isoWeek']],
                'Wo' => ['ordinal', ['isoWeek', 'W']],
                'w' => 'week',
                'ww' => ['getPaddedUnit', ['week']],
                'wo' => ['ordinal', ['week', 'w']],
                'x' => ['valueOf'],
                'X' => 'timestamp',
                'Y' => ['format', 'Y'],
                'YY' => ['format', 'y'],
                'YYYY' => ['getPaddedUnit', ['year', 4]],
                'YYYYY' => ['getPaddedUnit', ['year', 5]],
                'YYYYYY' => function (CarbonInterface $date) {
                    return ($date->year < 0 ? '' : '+').$date->getPaddedUnit('year', 6);
                },
                'z' => 'tzAbbrName',
                'zz' => 'tzName',
                'Z' => ['getOffsetString', []],
                'ZZ' => ['getOffsetString', ['']],
            ];
        }

        return $units;
    }

    /**
     * Returns a unit of the instance padded with 0 by default or any other string if specified.
     *
     * @param string $unit      Carbon unit name
     * @param int    $length    Length of the output (2 by default)
     * @param string $padString String to use for padding ("0" by default)
     * @param int    $padType   Side(s) to pad (STR_PAD_LEFT by default)
     *
     * @return string
     */
    public function getPaddedUnit($unit, $length = 2, $padString = '0', $padType = STR_PAD_LEFT)
    {
        return ($this->$unit < 0 ? '-' : '').str_pad(abs($this->$unit), $length, $padString, $padType);
    }

    /**
     * Translate using translation string or callback available.
     *
     * @param string $key
     * @param array  $parameters
     * @param null   $number
     *
     * @return string
     */
    public function translate(string $key, array $parameters = [], $number = null): string
    {
        $message = $this->getTranslationMessage($key, null, $key);
        if ($message instanceof Closure) {
            return $message(...array_values($parameters));
        }

        return $number === null
            ? $this->getLocalTranslator()->trans($key, $parameters)
            : $this->getLocalTranslator()->transChoice($key, $number, $parameters);
    }

    /**
     * Return a property with its ordinal.
     *
     * @param string      $key
     * @param string|null $period
     *
     * @return string
     */
    public function ordinal(string $key, string $period = null): string
    {
        $number = $this->$key;
        $result = $this->translate('ordinal', [
            'number' => $number,
            'period' => $period,
        ]);

        return strval($result === 'ordinal' ? $number : $result);
    }

    /**
     * @param string $format
     *
     * @return string
     */
    public function isoFormat(string $format): string
    {
        $result = '';
        $length = mb_strlen($format);
        $inEscaped = false;
        $formats = null;
        $units = null;

        for ($i = 0; $i < $length; $i++) {
            $char = mb_substr($format, $i, 1);
            if ($char === '\\') {
                $result .= mb_substr($format, ++$i, 1);

                continue;
            }

            if ($char === '[' && !$inEscaped) {
                $inEscaped = true;

                continue;
            }

            if ($char === ']' && $inEscaped) {
                $inEscaped = false;

                continue;
            }

            if ($inEscaped) {
                $result .= $char;

                continue;
            }

            $input = mb_substr($format, $i);
            if (preg_match('/^(LTS|LT|[Ll]{1,4})/', $input, $match)) {
                if ($formats === null) {
                    $formats = $this->getIsoFormats();
                }

                $code = $match[0];
                $sequence = $formats[$code] ?? preg_replace_callback(
                    '/MMMM|MM|DD|dddd/',
                    function ($code) {
                        return mb_substr($code[0], 1);
                    },
                    $formats[strtoupper($code)] ?? ''
                );
                $rest = mb_substr($format, $i + mb_strlen($code));
                $format = mb_substr($format, 0, $i).$sequence.$rest;
                $length = mb_strlen($format);
                $input = $sequence.$rest;
            }

            if (preg_match('/^([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|g{1,5}|G{1,5}|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?)/', $input, $match)) {
                $code = $match[0];
                if ($units === null) {
                    $units = static::getIsoUnits();
                }

                $sequence = $units[$code] ?? '';
                if ($sequence instanceof Closure) {
                    $sequence = $sequence($this);
                } elseif (is_array($sequence)) {
                    $sequence = $this->{$sequence[0]}(...$sequence[1]);
                } elseif (is_string($sequence)) {
                    $sequence = $this->$sequence ?? $code;
                }
                $format = mb_substr($format, 0, $i).$sequence.mb_substr($format, $i + mb_strlen($code));
                $i += mb_strlen($sequence) - 1;
                $length = mb_strlen($format);
                $char = $sequence;
            }

            $result .= $char;
        }

        return $result;
    }

    /**
     * Returns the offset hour and minute formatted with +/- and a given separator (":" by default).
     * For example, if the time zone is 9 hours 30 minutes, you'll get "+09:30", with "@@" as first
     * argument, "+09@@30", with "" as first argument, "+0930". Negative offset will return something
     * like "-12:00".
     *
     * @param string $separator string to place between hours and minutes (":" by default)
     *
     * @return string
     */
    public function getOffsetString($separator = ':')
    {
        $second = $this->getOffset();
        $symbol = $second < 0 ? '-' : '+';
        $minute = abs($second) / static::SECONDS_PER_MINUTE;
        $hour = str_pad(floor($minute / static::MINUTES_PER_HOUR), 2, '0', STR_PAD_LEFT);
        $minute = str_pad($minute % static::MINUTES_PER_HOUR, 2, '0', STR_PAD_LEFT);

        return "$symbol$hour$separator$minute";
    }

    /**
     * Returns a timestamp rounded with the given precision (6 by default).
     *
     * @example getPreciseTimestamp()   1532087464437474 (microsecond maximum precision)
     * @example getPreciseTimestamp(6)  1532087464437474
     * @example getPreciseTimestamp(5)  153208746443747  (1/100000 second precision)
     * @example getPreciseTimestamp(4)  15320874644375   (1/10000 second precision)
     * @example getPreciseTimestamp(3)  1532087464437    (millisecond precision)
     * @example getPreciseTimestamp(2)  153208746444     (1/100 second precision)
     * @example getPreciseTimestamp(1)  15320874644      (1/10 second precision)
     * @example getPreciseTimestamp(0)  1532087464       (second precision)
     * @example getPreciseTimestamp(-1) 153208746        (10 second precision)
     * @example getPreciseTimestamp(-2) 15320875         (100 second precision)
     *
     * @param int $precision
     *
     * @return float
     */
    public function getPreciseTimestamp($precision = 6)
    {
        return round($this->format('Uu') / pow(10, 6 - $precision));
    }

    /**
     * Returns the milliseconds timestamps used amongst other by Date javascript objects.
     *
     * @return float
     */
    public function valueOf()
    {
        return $this->getPreciseTimestamp(3);
    }

    /**
     * @alias getTimestamp
     *
     * Returns the UNIX timestamp for the current date.
     *
     * @return int
     */
    public function unix()
    {
        return $this->getTimestamp();
    }

    /**
     * Set/get the week number of year using given first day of week and first
     * day of year included in the first week. Or use ISO format if no settings
     * given.
     *
     * @param int|null $year      if null, act as a getter, if not null, set the year and return current instance.
     * @param int|null $dayOfWeek first date of week from 0 (Sunday) to 6 (Saturday)
     * @param int|null $dayOfYear first day of year included in the week #1
     *
     * @return int|static
     */
    public function isoWeekYear($year = null, $dayOfWeek = null, $dayOfYear = null)
    {
        return $this->weekYear(
            $year,
            $dayOfWeek ?? $this->getTranslationMessage('first_day_of_week') ?? 1,
            $dayOfYear ?? $this->getTranslationMessage('day_of_first_week_of_year') ?? 4
        );
    }

    /**
     * Set/get the week number of year using given first day of week and first
     * day of year included in the first week. Or use US format if no settings
     * given (Sunday / Jan 6).
     *
     * @param int|null $year      if null, act as a getter, if not null, set the year and return current instance.
     * @param int|null $dayOfWeek first date of week from 0 (Sunday) to 6 (Saturday)
     * @param int|null $dayOfYear first day of year included in the week #1
     *
     * @return int|static
     */
    public function weekYear($year = null, $dayOfWeek = null, $dayOfYear = null)
    {
        $dayOfWeek = $dayOfWeek ?? $this->getTranslationMessage('first_day_of_week') ?? 0;
        $dayOfYear = $dayOfYear ?? $this->getTranslationMessage('day_of_first_week_of_year') ?? 1;

        if ($year !== null) {
            $year = (int) round($year);

            if ($this->weekYear(null, $dayOfWeek, $dayOfYear) === $year) {
                return $this->copy();
            }

            $week = $this->week(null, $dayOfWeek, $dayOfYear);
            $day = $this->dayOfWeek;
            $date = $this->year($year);
            switch ($date->weekYear(null, $dayOfWeek, $dayOfYear) - $year) {
                case 1:
                    $date = $date->subWeeks(26);
                    break;
                case -1:
                    $date = $date->addWeeks(26);
                    break;
            }

            $date = $date->addWeeks($week - $date->week(null, $dayOfWeek, $dayOfYear))->startOfWeek($dayOfWeek);

            if ($date->dayOfWeek === $day) {
                return $date;
            }

            return $date->next($day);
        }

        $year = $this->year;
        $day = $this->dayOfYear;
        $date = $this->copy()->dayOfYear($dayOfYear)->startOfWeek($dayOfWeek);

        if ($date->year === $year && $day < $date->dayOfYear) {
            return $year - 1;
        }

        $date = $this->copy()->addYear()->dayOfYear($dayOfYear)->startOfWeek($dayOfWeek);

        if ($date->year === $year && $day >= $date->dayOfYear) {
            return $year + 1;
        }

        return $year;
    }

    /**
     * Get the number of weeks of the current week-year using given first day of week and first
     * day of year included in the first week. Or use ISO format if no settings
     * given.
     *
     * @param int|null $dayOfWeek first date of week from 0 (Sunday) to 6 (Saturday)
     * @param int|null $dayOfYear first day of year included in the week #1
     *
     * @return int
     */
    public function isoWeeksInYear($dayOfWeek = null, $dayOfYear = null)
    {
        return $this->weeksInYear(
            $dayOfWeek ?? $this->getTranslationMessage('first_day_of_week') ?? 1,
            $dayOfYear ?? $this->getTranslationMessage('day_of_first_week_of_year') ?? 4
        );
    }

    /**
     * Get the number of weeks of the current week-year using given first day of week and first
     * day of year included in the first week. Or use US format if no settings
     * given (Sunday / Jan 6).
     *
     * @param int|null $dayOfWeek first date of week from 0 (Sunday) to 6 (Saturday)
     * @param int|null $dayOfYear first day of year included in the week #1
     *
     * @return int
     */
    public function weeksInYear($dayOfWeek = null, $dayOfYear = null)
    {
        $dayOfWeek = $dayOfWeek ?? $this->getTranslationMessage('first_day_of_week') ?? 0;
        $dayOfYear = $dayOfYear ?? $this->getTranslationMessage('day_of_first_week_of_year') ?? 1;
        $year = $this->year;
        $start = $this->copy()->dayOfYear($dayOfYear)->startOfWeek($dayOfWeek);
        $startDay = $start->dayOfYear;
        if ($start->year !== $year) {
            $startDay -= $start->daysInYear;
        }
        $end = $this->copy()->addYear()->dayOfYear($dayOfYear)->startOfWeek($dayOfWeek);
        $endDay = $end->dayOfYear;
        if ($end->year !== $year) {
            $endDay += $this->daysInYear;
        }

        return (int) round(($endDay - $startDay) / 7);
    }

    public function week($week = null, $dayOfWeek = null, $dayOfYear = null)
    {
        $date = $this;
        $dayOfWeek = $dayOfWeek ?? $this->getTranslationMessage('first_day_of_week') ?? 0;
        $dayOfYear = $dayOfYear ?? $this->getTranslationMessage('day_of_first_week_of_year') ?? 1;

        if ($week !== null) {
            return $date->addWeeks(round($week) - $this->week(null, $dayOfWeek, $dayOfYear));
        }

        $start = $date->copy()->dayOfYear($dayOfYear)->startOfWeek($dayOfWeek);
        $end = $date->copy()->startOfWeek($dayOfWeek);
        if ($start > $end) {
            $start = $start->subWeeks(26)->dayOfYear($dayOfYear)->startOfWeek($dayOfWeek);
        }
        $week = (int) ($start->diffInDays($end) / 7 + 1);

        return $week > $end->weeksInYear($dayOfWeek, $dayOfYear) ? 1 : $week;
    }

    public function isoWeek($week = null, $dayOfWeek = null, $dayOfYear = null)
    {
        return $this->week(
            $week,
            $dayOfWeek ?? $this->getTranslationMessage('first_day_of_week') ?? 1,
            $dayOfYear ?? $this->getTranslationMessage('day_of_first_week_of_year') ?? 4
        );
    }

    ///////////////////////////////////////////////////////////////////
    ////////////////////////// COMPARISONS ////////////////////////////
    ///////////////////////////////////////////////////////////////////

    /**
     * Determines if the instance is equal to another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @return bool
     */
    public function eq($date)
    {
        return $this == $date;
    }

    /**
     * Determines if the instance is equal to another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @see eq()
     *
     * @return bool
     */
    public function equalTo($date)
    {
        return $this->eq($date);
    }

    /**
     * Determines if the instance is not equal to another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @return bool
     */
    public function ne($date)
    {
        return !$this->eq($date);
    }

    /**
     * Determines if the instance is not equal to another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @see ne()
     *
     * @return bool
     */
    public function notEqualTo($date)
    {
        return $this->ne($date);
    }

    /**
     * Determines if the instance is greater (after) than another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @return bool
     */
    public function gt($date)
    {
        return $this > $date;
    }

    /**
     * Determines if the instance is greater (after) than another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @see gt()
     *
     * @return bool
     */
    public function greaterThan($date)
    {
        return $this->gt($date);
    }

    /**
     * Determines if the instance is greater (after) than another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @see gt()
     *
     * @return bool
     */
    public function isAfter($date)
    {
        return $this->gt($date);
    }

    /**
     * Determines if the instance is greater (after) than or equal to another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @return bool
     */
    public function gte($date)
    {
        return $this >= $date;
    }

    /**
     * Determines if the instance is greater (after) than or equal to another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @see gte()
     *
     * @return bool
     */
    public function greaterThanOrEqualTo($date)
    {
        return $this->gte($date);
    }

    /**
     * Determines if the instance is less (before) than another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @return bool
     */
    public function lt($date)
    {
        return $this < $date;
    }

    /**
     * Determines if the instance is less (before) than another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @see lt()
     *
     * @return bool
     */
    public function lessThan($date)
    {
        return $this->lt($date);
    }

    /**
     * Determines if the instance is less (before) than another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @see lt()
     *
     * @return bool
     */
    public function isBefore($date)
    {
        return $this->lt($date);
    }

    /**
     * Determines if the instance is less (before) or equal to another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @return bool
     */
    public function lte($date)
    {
        return $this <= $date;
    }

    /**
     * Determines if the instance is less (before) or equal to another
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date
     *
     * @see lte()
     *
     * @return bool
     */
    public function lessThanOrEqualTo($date)
    {
        return $this->lte($date);
    }

    /**
     * Determines if the instance is between two others
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date1
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date2
     * @param bool                                    $equal Indicates if an equal to comparison should be done
     *
     * @return bool
     */
    public function between($date1, $date2, $equal = true)
    {
        if ($date1->gt($date2)) {
            $temp = $date1;
            $date1 = $date2;
            $date2 = $temp;
        }

        if ($equal) {
            return $this->gte($date1) && $this->lte($date2);
        }

        return $this->gt($date1) && $this->lt($date2);
    }

    /**
     * Determines if the instance is between two others
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date1
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date2
     * @param bool                                    $equal Indicates if an equal to comparison should be done
     *
     * @return bool
     */
    public function isBetween($date1, $date2, $equal = true)
    {
        return $this->between($date1, $date2, $equal);
    }

    /**
     * Get the closest date from the instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date1
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date2
     *
     * @return static
     */
    public function closest($date1, $date2)
    {
        return $this->diffInSeconds($date1) < $this->diffInSeconds($date2) ? $date1 : $date2;
    }

    /**
     * Get the farthest date from the instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date1
     * @param \Carbon\Carbon|\DateTimeInterface|mixed $date2
     *
     * @return static
     */
    public function farthest($date1, $date2)
    {
        return $this->diffInSeconds($date1) > $this->diffInSeconds($date2) ? $date1 : $date2;
    }

    /**
     * Get the minimum instance between a given instance (default now) and the current instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|string|null $date
     *
     * @return static
     */
    public function min($date = null)
    {
        $date = $this->resolveCarbon($date);

        return $this->lt($date) ? $this : $date;
    }

    /**
     * Get the minimum instance between a given instance (default now) and the current instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|string|null $date
     *
     * @see min()
     *
     * @return static
     */
    public function minimum($date = null)
    {
        return $this->min($date);
    }

    /**
     * Get the maximum instance between a given instance (default now) and the current instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|string|null $date
     *
     * @return static
     */
    public function max($date = null)
    {
        $date = $this->resolveCarbon($date);

        return $this->gt($date) ? $this : $date;
    }

    /**
     * Get the maximum instance between a given instance (default now) and the current instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|string|null $date
     *
     * @see max()
     *
     * @return static
     */
    public function maximum($date = null)
    {
        return $this->max($date);
    }

    /**
     * Determines if the instance is a weekday.
     *
     * @return bool
     */
    public function isWeekday()
    {
        return !$this->isWeekend();
    }

    /**
     * Determines if the instance is a weekend day.
     *
     * @return bool
     */
    public function isWeekend()
    {
        return in_array($this->dayOfWeek, static::$weekendDays);
    }

    /**
     * Determines if the instance is yesterday.
     *
     * @return bool
     */
    public function isYesterday()
    {
        return $this->toDateString() === static::yesterday($this->getTimezone())->toDateString();
    }

    /**
     * Determines if the instance is today.
     *
     * @return bool
     */
    public function isToday()
    {
        return $this->toDateString() === $this->nowWithSameTz()->toDateString();
    }

    /**
     * Determines if the instance is tomorrow.
     *
     * @return bool
     */
    public function isTomorrow()
    {
        return $this->toDateString() === static::tomorrow($this->getTimezone())->toDateString();
    }

    /**
     * Determines if the instance is in the future, ie. greater (after) than now.
     *
     * @return bool
     */
    public function isFuture()
    {
        return $this->gt($this->nowWithSameTz());
    }

    /**
     * Determines if the instance is in the past, ie. less (before) than now.
     *
     * @return bool
     */
    public function isPast()
    {
        return $this->lt($this->nowWithSameTz());
    }

    /**
     * Determines if the instance is a leap year.
     *
     * @return bool
     */
    public function isLeapYear()
    {
        return $this->format('L') === '1';
    }

    /**
     * Determines if the instance is a long year
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Week_dates
     *
     * @return bool
     */
    public function isLongYear()
    {
        return static::create($this->year, 12, 28, 0, 0, 0, $this->tz)->weekOfYear === 53;
    }

    /**
     * Compares the formatted values of the two dates.
     *
     * @param string                                 $format date formats to compare.
     * @param \Carbon\Carbon|\DateTimeInterface|null $date   instance to compare with or null to use current day.
     *
     * @throws \InvalidArgumentException
     *
     * @return bool
     */
    public function isSameAs($format, $date = null)
    {
        /** @var DateTimeInterface $date */
        $date = $date ?: static::now($this->tz);

        static::expectDateTime($date, 'null');

        /* @var CarbonInterface $this */
        return $this->format($format) === $date->format($format);
    }

    /**
     * Determines if the instance is in the current unit given.
     *
     * @param string                                 $unit singular unit string
     * @param \Carbon\Carbon|\DateTimeInterface|null $date instance to compare with or null to use current day.
     *
     * @throws \InvalidArgumentException
     *
     * @return bool
     */
    public function isSameUnit($unit, $date = null)
    {
        $units = [
            // @call isSameUnit
            'year' => 'Y',
            // @call isSameUnit
            'week' => 'Y-W',
            // @call isSameUnit
            'day' => 'Y-m-d',
            // @call isSameUnit
            'hour' => 'Y-m-d H',
            // @call isSameUnit
            'minute' => 'Y-m-d H:i',
            // @call isSameUnit
            'second' => 'Y-m-d H:i:s',
            // @call isSameUnit
            'micro' => 'Y-m-d H:i:s.u',
            // @call isSameUnit
            'microsecond' => 'Y-m-d H:i:s.u',
        ];

        if (!isset($units[$unit])) {
            if (isset($this->$unit)) {
                $date = $date ? static::instance($date) : static::now($this->tz);

                static::expectDateTime($date);

                return $this->$unit === $date->$unit;
            }

            if (static::isStrictModeEnabled()) {
                throw new InvalidArgumentException("Bad comparison unit: '$unit'");
            }

            return false;
        }

        return $this->isSameAs($units[$unit], $date);
    }

    /**
     * Determines if the instance is in the current unit given.
     *
     * @param string $unit The unit to test.
     *
     * @throws \ReflectionException
     *
     * @return bool
     */
    public function isCurrentUnit($unit)
    {
        return $this->{'isSame'.ucfirst($unit)}();
    }

    /**
     * Checks if the passed in date is in the same quarter as the instance quarter (and year if needed).
     *
     * @param \Carbon\Carbon|\DateTimeInterface|null $date       The instance to compare with or null to use current day.
     * @param bool                                   $ofSameYear Check if it is the same month in the same year.
     *
     * @return bool
     */
    public function isSameQuarter($date = null, $ofSameYear = true)
    {
        $date = $date ? static::instance($date) : static::now($this->tz);

        static::expectDateTime($date, 'null');

        return $this->quarter === $date->quarter && (!$ofSameYear || $this->isSameYear($date));
    }

    /**
     * Checks if the passed in date is in the same month as the instance´s month.
     *
     * Note that this defaults to only comparing the month while ignoring the year.
     * To test if it is the same exact month of the same year, pass in true as the second parameter.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|null $date       The instance to compare with or null to use the current date.
     * @param bool                                   $ofSameYear Check if it is the same month in the same year.
     *
     * @return bool
     */
    public function isSameMonth($date = null, $ofSameYear = true)
    {
        return $this->isSameAs($ofSameYear ? 'Y-m' : 'm', $date);
    }

    /**
     * Checks if this day is a specific day of the week.
     *
     * @param int $dayOfWeek
     *
     * @return bool
     */
    public function isDayOfWeek($dayOfWeek)
    {
        if (is_string($dayOfWeek) && defined($constant = static::class.'::'.strtoupper($dayOfWeek))) {
            $dayOfWeek = constant($constant);
        }

        return $this->dayOfWeek === $dayOfWeek;
    }

    /**
     * Check if its the birthday. Compares the date/month values of the two dates.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|null $date The instance to compare with or null to use current day.
     *
     * @return bool
     */
    public function isBirthday($date = null)
    {
        return $this->isSameAs('md', $date);
    }

    /**
     * Check if today is the last day of the Month
     *
     * @return bool
     */
    public function isLastOfMonth()
    {
        return $this->day === $this->daysInMonth;
    }

    /**
     * Check if the instance is start of day / midnight.
     *
     * @param bool $checkMicroseconds check time at microseconds precision
     *
     * @return bool
     */
    public function isStartOfDay($checkMicroseconds = false)
    {
        /* @var CarbonInterface $this */
        return $checkMicroseconds
            ? $this->format('H:i:s.u') === '00:00:00.000000'
            : $this->format('H:i:s') === '00:00:00';
    }

    /**
     * Check if the instance is end of day.
     *
     * @param bool $checkMicroseconds check time at microseconds precision
     *
     * @return bool
     */
    public function isEndOfDay($checkMicroseconds = false)
    {
        /* @var CarbonInterface $this */
        return $checkMicroseconds
            ? $this->format('H:i:s.u') === '23:59:59.999999'
            : $this->format('H:i:s') === '23:59:59';
    }

    /**
     * Check if the instance is start of day / midnight.
     *
     * @return bool
     */
    public function isMidnight()
    {
        return $this->isStartOfDay();
    }

    /**
     * Check if the instance is midday.
     *
     * @return bool
     */
    public function isMidday()
    {
        /* @var CarbonInterface $this */
        return $this->format('G:i:s') === static::$midDayAt.':00:00';
    }

    /**
     * Checks if the (date)time string is in a given format.
     *
     * @param string $date
     * @param string $format
     *
     * @return bool
     */
    public static function hasFormat($date, $format)
    {
        try {
            // Try to create a DateTime object. Throws an InvalidArgumentException if the provided time string
            // doesn't match the format in any way.
            static::createFromFormat($format, $date);

            // createFromFormat() is known to handle edge cases silently.
            // E.g. "1975-5-1" (Y-n-j) will still be parsed correctly when "Y-m-d" is supplied as the format.
            // To ensure we're really testing against our desired format, perform an additional regex validation.
            $regex = strtr(
                preg_quote($format, '/'),
                static::$regexFormats
            );

            return (bool) preg_match('/^'.$regex.'$/', $date);
        } catch (InvalidArgumentException $e) {
        }

        return false;
    }

    /**
     * Add seconds to the instance using timestamp. Positive $value travels
     * forward while negative $value travels into the past.
     *
     * @param int $value
     *
     * @return static
     */
    public function addRealUnit($unit, $value = 1)
    {
        switch ($unit) {
            case 'micro':
                // @call addRealUnit
            case 'microsecond':
                /* @var CarbonInterface $this */
                $diff = $this->microsecond + $value;
                $time = $this->getTimestamp();
                $seconds = floor($diff / static::MICROSECONDS_PER_SECOND);
                $time += $seconds;
                $diff -= $seconds * static::MICROSECONDS_PER_SECOND;
                $microtime = str_pad($diff, 6, '0', STR_PAD_LEFT);

                return $this->modify("@$time.$microtime");
            // @call addRealUnit
            case 'second':
                break;
            // @call addRealUnit
            case 'minute':
                $value *= static::SECONDS_PER_MINUTE;
                break;
            // @call addRealUnit
            case 'hour':
                $value *= static::MINUTES_PER_HOUR * static::SECONDS_PER_MINUTE;
                break;
            // @call addRealUnit
            case 'day':
                $value *= static::HOURS_PER_DAY * static::MINUTES_PER_HOUR * static::SECONDS_PER_MINUTE;
                break;
            // @call addRealUnit
            case 'week':
                $value *= static::DAYS_PER_WEEK * static::HOURS_PER_DAY * static::MINUTES_PER_HOUR * static::SECONDS_PER_MINUTE;
                break;
            // @call addRealUnit
            case 'month':
                $value *= 30 * static::HOURS_PER_DAY * static::MINUTES_PER_HOUR * static::SECONDS_PER_MINUTE;
                break;
            // @call addRealUnit
            case 'quarter':
                $value *= static::MONTHS_PER_QUARTER * 30 * static::HOURS_PER_DAY * static::MINUTES_PER_HOUR * static::SECONDS_PER_MINUTE;
                break;
            // @call addRealUnit
            case 'year':
                $value *= 365 * static::HOURS_PER_DAY * static::MINUTES_PER_HOUR * static::SECONDS_PER_MINUTE;
                break;
            // @call addRealUnit
            case 'decade':
                $value *= static::YEARS_PER_DECADE * 365 * static::HOURS_PER_DAY * static::MINUTES_PER_HOUR * static::SECONDS_PER_MINUTE;
                break;
            // @call addRealUnit
            case 'century':
                $value *= static::YEARS_PER_CENTURY * 365 * static::HOURS_PER_DAY * static::MINUTES_PER_HOUR * static::SECONDS_PER_MINUTE;
                break;
            // @call addRealUnit
            case 'millennium':
                $value *= static::YEARS_PER_MILLENNIUM * 365 * static::HOURS_PER_DAY * static::MINUTES_PER_HOUR * static::SECONDS_PER_MINUTE;
                break;
            default:
                if (static::isStrictModeEnabled()) {
                    throw new InvalidArgumentException("Invalid unit for real timestamp add/sub: '$unit'");
                }

                return $this;
        }

        /* @var CarbonInterface $this */
        return $this->setTimestamp($this->getTimestamp() + $value);
    }

    public function subRealUnit($unit, $value = 1)
    {
        return $this->addRealUnit($unit, -$value);
    }

    /**
     * Returns true if a property can be changed via setter.
     *
     * @param string $unit
     *
     * @return bool
     */
    public static function isModifiableUnit($unit)
    {
        static $modifiableUnits = [
            // @call addUnit
            'millennium',
            // @call addUnit
            'century',
            // @call addUnit
            'decade',
            // @call addUnit
            'quarter',
            // @call addUnit
            'week',
            // @call addUnit
            'weekday',
        ];

        return in_array($unit, $modifiableUnits) || in_array($unit, static::$units);
    }

    /**
     * Add given units or interval to the current instance.
     *
     * @example $date->add('hour', 3)
     * @example $date->add(15, 'days')
     * @example $date->add(CarbonInterval::days(4))
     *
     * @param string |DateInterval $unit
     * @param int                  $value
     * @param bool|null            $overflow
     *
     * @return CarbonInterface
     */
    public function add($unit, $value = 1, $overflow = null)
    {
        if (is_string($unit) && func_num_args() === 1) {
            $unit = CarbonInterval::make($unit);
        }

        if ($unit instanceof DateInterval) {
            return parent::add($unit);
        }

        if (is_numeric($unit)) {
            $_unit = $value;
            $value = $unit;
            $unit = $_unit;
            unset($_unit);
        }

        return $this->addUnit($unit, $value, $overflow);
    }

    /**
     * Add given units to the current instance.
     *
     * @param string |DateInterval $unit
     * @param int                  $value
     * @param bool|null            $overflow
     *
     * @return CarbonInterface
     */
    public function addUnit($unit, $value = 1, $overflow = null)
    {
        /** @var CarbonInterface $date */
        $date = $this;

        if (!is_numeric($value) || !floatval($value)) {
            return $date->isMutable() ? $date : $date->copy();
        }

        $metaUnits = [
            'millennium' => [static::YEARS_PER_MILLENNIUM, 'year'],
            'century' => [static::YEARS_PER_CENTURY, 'year'],
            'decade' => [static::YEARS_PER_DECADE, 'year'],
            'quarter' => [static::MONTHS_PER_QUARTER, 'month'],
        ];
        if (isset($metaUnits[$unit])) {
            list($factor, $unit) = $metaUnits[$unit];
            $value *= $factor;
        }

        if ($unit === 'weekday') {
            $weekendDays = static::getWeekendDays();
            if ($weekendDays !== [static::SATURDAY, static::SUNDAY]) {
                $absoluteValue = abs($value);
                $sign = $value / max(1, $absoluteValue);
                $weekDaysCount = 7 - min(6, count(array_unique($weekendDays)));
                $weeks = floor($absoluteValue / $weekDaysCount);
                for ($diff = $absoluteValue % $weekDaysCount; $diff; $diff--) {
                    $date = $date->addDays($sign);
                    while (in_array($date->dayOfWeek, $weekendDays)) {
                        $date = $date->addDays($sign);
                    }
                }

                $value = $weeks * $sign;
                $unit = 'week';
            }

            $timeString = $date->toTimeString();
        } elseif ($canOverflow = in_array($unit, [
            'month',
            'year',
        ]) && ($overflow === false || ($overflow === null && !static::{'shouldOverflow'.ucfirst($unit).'s'}()))) {
            $day = $date->day;
        }

        $value = (int) $value;
        // Wor-around for bug https://bugs.php.net/bug.php?id=75642
        if ($unit === 'micro' || $unit === 'microsecond') {
            $microseconds = $this->micro + $value;
            $second = floor($microseconds / static::MICROSECONDS_PER_SECOND);
            $microseconds %= static::MICROSECONDS_PER_SECOND;
            if ($microseconds < 0) {
                $microseconds += static::MICROSECONDS_PER_SECOND;
            }
            $date = $date->microseconds($microseconds);
            $unit = 'second';
            $value = $second;
        }
        $date = $date->modify("$value $unit");

        if (isset($timeString)) {
            return $date->setTimeFromTimeString($timeString);
        }
        if (isset($canOverflow, $day) && $canOverflow && $day !== $date->day) {
            $date = $date->modify('last day of previous month');
        }

        return $date;
    }

    /**
     * Subtract given units to the current instance.
     *
     * @param string    $unit
     * @param int       $value
     * @param bool|null $overflow
     *
     * @return CarbonInterface
     */
    public function subUnit($unit, $value = 1, $overflow = null)
    {
        return $this->addUnit($unit, -$value, $overflow);
    }

    /**
     * Subtract given units or interval to the current instance.
     *
     * @example $date->sub('hour', 3)
     * @example $date->sub(15, 'days')
     * @example $date->sub(CarbonInterval::days(4))
     *
     * @param string    $unit
     * @param int       $value
     * @param bool|null $overflow
     *
     * @return CarbonInterface
     */
    public function sub($unit, $value = 1, $overflow = null)
    {
        if (is_string($unit) && func_num_args() === 1) {
            $unit = CarbonInterval::make($unit);
        }

        if ($unit instanceof DateInterval) {
            return parent::sub($unit);
        }

        if (is_numeric($unit)) {
            $_unit = $value;
            $value = $unit;
            $unit = $_unit;
            unset($_unit);
        }

        return $this->addUnit($unit, -floatval($value), $overflow);
    }

    /**
     * Subtract given units or interval to the current instance.
     *
     * @see sub()
     *
     * @param string    $unit
     * @param int       $value
     * @param bool|null $overflow
     *
     * @return CarbonInterface
     */
    public function subtract($unit, $value = 1, $overflow = null)
    {
        if (is_string($unit) && func_num_args() === 1) {
            $unit = CarbonInterval::make($unit);
        }

        return $this->sub($unit, $value, $overflow);
    }

    /**
     * Round the current instance at the given unit with given precision if specified and the given function.
     *
     * @param string $unit
     * @param float  $precision
     * @param string $function
     *
     * @return CarbonInterface
     */
    public function roundUnit($unit, $precision = 1, $function = 'round')
    {
        $metaUnits = [
            // @call roundUnit
            'millennium' => [static::YEARS_PER_MILLENNIUM, 'year'],
            // @call roundUnit
            'century' => [static::YEARS_PER_CENTURY, 'year'],
            // @call roundUnit
            'decade' => [static::YEARS_PER_DECADE, 'year'],
            // @call roundUnit
            'quarter' => [static::MONTHS_PER_QUARTER, 'month'],
            // @call roundUnit
            'millisecond' => [1000, 'microsecond'],
        ];
        $normalizedUnit = static::singularUnit($unit);
        $ranges = array_merge(static::getRangesByUnit(), [
            // @call roundUnit
            'microsecond' => [0, 999999],
        ]);
        $factor = 1;
        if (isset($metaUnits[$normalizedUnit])) {
            list($factor, $normalizedUnit) = $metaUnits[$normalizedUnit];
        }
        $precision *= $factor;

        if (!isset($ranges[$normalizedUnit])) {
            throw new InvalidArgumentException("Unknown unit '$unit' to floor");
        }

        $found = false;
        $fraction = 0;
        $arguments = null;
        $factor = $this->year < 0 ? -1 : 1;
        $changes = [];

        foreach ($ranges as $unit => $range) {
            list($minimum, $maximum) = $range;

            if ($normalizedUnit === $unit) {
                $arguments = [$this->$unit, $minimum];
                $fraction = $precision - floor($precision);
                $found = true;

                continue;
            }

            if ($found) {
                $delta = $maximum + 1 - $minimum;
                $factor /= $delta;
                $fraction *= $delta;
                $arguments[0] += $this->$unit * $factor;
                $changes[$unit] = round($minimum + ($fraction ? $fraction * call_user_func($function, ($this->$unit - $minimum) / $fraction) : 0));
                // Cannot use modulo as it lose double precision
                while ($changes[$unit] >= $delta) {
                    $changes[$unit] -= $delta;
                }
                $fraction -= floor($fraction);
            }
        }

        list($value, $minimum) = $arguments;
        /** @var CarbonInterface $result */
        $result = $this->$normalizedUnit(floor(call_user_func($function, ($value - $minimum) / $precision) * $precision + $minimum));
        foreach ($changes as $unit => $value) {
            $result = $result->$unit($value);
        }

        return $result;
    }

    /**
     * Truncate the current instance at the given unit with given precision if specified.
     *
     * @param string $unit
     * @param float  $precision
     *
     * @return CarbonInterface
     */
    public function floorUnit($unit, $precision = 1)
    {
        return $this->roundUnit($unit, $precision, 'floor');
    }

    /**
     * Ceil the current instance at the given unit with given precision if specified.
     *
     * @param string $unit
     * @param float  $precision
     *
     * @return CarbonInterface
     */
    public function ceilUnit($unit, $precision = 1)
    {
        return $this->roundUnit($unit, $precision, 'ceil');
    }

    /**
     * Round the current instance second with given precision if specified.
     *
     * @param float  $precision
     * @param string $function
     *
     * @return CarbonInterface
     */
    public function round($precision = 1, $function = 'round')
    {
        return $this->roundUnit('second', $precision, $function);
    }

    /**
     * Round the current instance second with given precision if specified.
     *
     * @param float $precision
     *
     * @return CarbonInterface
     */
    public function floor($precision = 1)
    {
        return $this->roundUnit('second', $precision, 'floor');
    }

    /**
     * Ceil the current instance second with given precision if specified.
     *
     * @param float $precision
     *
     * @return CarbonInterface
     */
    public function ceil($precision = 1)
    {
        return $this->roundUnit('second', $precision, 'ceil');
    }

    /**
     * Round the current instance week.
     *
     * @param int $weekStartsAt optional start allow you to specify the day of week to use to start the week
     *
     * @return CarbonInterface
     */
    public function roundWeek($weekStartsAt = null)
    {
        return $this->closest($this->copy()->floorWeek($weekStartsAt), $this->copy()->ceilWeek($weekStartsAt));
    }

    /**
     * Truncate the current instance week.
     *
     * @param int $weekStartsAt optional start allow you to specify the day of week to use to start the week
     *
     * @return CarbonInterface
     */
    public function floorWeek($weekStartsAt = null)
    {
        return $this->startOfWeek($weekStartsAt);
    }

    /**
     * Ceil the current instance week.
     *
     * @param int $weekStartsAt optional start allow you to specify the day of week to use to start the week
     *
     * @return CarbonInterface
     */
    public function ceilWeek($weekStartsAt = null)
    {
        if ($this->isMutable()) {
            $startOfWeek = $this->copy()->startOfWeek($weekStartsAt);

            return $startOfWeek != $this ?
                $this->startOfWeek($weekStartsAt)->addWeek() :
                $this;
        }

        $startOfWeek = $this->startOfWeek($weekStartsAt);

        return $startOfWeek != $this ?
            $startOfWeek->addWeek() :
            $this->copy();
    }

    ///////////////////////////////////////////////////////////////////
    //////////////////////////// MODIFIERS ////////////////////////////
    ///////////////////////////////////////////////////////////////////

    /**
     * Modify to midday, default to self::$midDayAt
     *
     * @return static
     */
    public function midDay()
    {
        return $this->setTime(self::$midDayAt, 0, 0, 0);
    }

    /**
     * Modify to the next occurrence of a given day of the week.
     * If no dayOfWeek is provided, modify to the next occurrence
     * of the current day of the week.  Use the supplied constants
     * to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int|null $dayOfWeek
     *
     * @return static
     */
    public function next($dayOfWeek = null)
    {
        if ($dayOfWeek === null) {
            $dayOfWeek = $this->dayOfWeek;
        }

        return $this->startOfDay()->modify('next '.static::$days[$dayOfWeek]);
    }

    /**
     * Go forward or backward to the next week- or weekend-day.
     *
     * @param bool $weekday
     * @param bool $forward
     *
     * @return static
     */
    private function nextOrPreviousDay($weekday = true, $forward = true)
    {
        /** @var CarbonInterface $step */
        $date = $this;
        $step = $forward ? 1 : -1;

        do {
            $date = $date->addDays($step);
        } while ($weekday ? $date->isWeekend() : $date->isWeekday());

        return $date;
    }

    /**
     * Go forward to the next weekday.
     *
     * @return static
     */
    public function nextWeekday()
    {
        return $this->nextOrPreviousDay();
    }

    /**
     * Go backward to the previous weekday.
     *
     * @return static
     */
    public function previousWeekday()
    {
        return $this->nextOrPreviousDay(true, false);
    }

    /**
     * Go forward to the next weekend day.
     *
     * @return static
     */
    public function nextWeekendDay()
    {
        return $this->nextOrPreviousDay(false);
    }

    /**
     * Go backward to the previous weekend day.
     *
     * @return static
     */
    public function previousWeekendDay()
    {
        return $this->nextOrPreviousDay(false, false);
    }

    /**
     * Modify to the previous occurrence of a given day of the week.
     * If no dayOfWeek is provided, modify to the previous occurrence
     * of the current day of the week.  Use the supplied constants
     * to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int|null $dayOfWeek
     *
     * @return static
     */
    public function previous($dayOfWeek = null)
    {
        if ($dayOfWeek === null) {
            $dayOfWeek = $this->dayOfWeek;
        }

        return $this->startOfDay()->modify('last '.static::$days[$dayOfWeek]);
    }

    /**
     * Modify to the first occurrence of a given day of the week
     * in the current month. If no dayOfWeek is provided, modify to the
     * first day of the current month.  Use the supplied constants
     * to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int|null $dayOfWeek
     *
     * @return static
     */
    public function firstOfMonth($dayOfWeek = null)
    {
        $date = $this->startOfDay();

        if ($dayOfWeek === null) {
            return $date->day(1);
        }

        return $date->modify('first '.static::$days[$dayOfWeek].' of '.$date->format('F').' '.$date->year);
    }

    /**
     * Modify to the last occurrence of a given day of the week
     * in the current month. If no dayOfWeek is provided, modify to the
     * last day of the current month.  Use the supplied constants
     * to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int|null $dayOfWeek
     *
     * @return static
     */
    public function lastOfMonth($dayOfWeek = null)
    {
        $date = $this->startOfDay();

        if ($dayOfWeek === null) {
            return $date->day($date->daysInMonth);
        }

        return $date->modify('last '.static::$days[$dayOfWeek].' of '.$date->format('F').' '.$date->year);
    }

    /**
     * Modify to the given occurrence of a given day of the week
     * in the current month. If the calculated occurrence is outside the scope
     * of the current month, then return false and no modifications are made.
     * Use the supplied constants to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int $nth
     * @param int $dayOfWeek
     *
     * @return mixed
     */
    public function nthOfMonth($nth, $dayOfWeek)
    {
        $date = $this->copy()->firstOfMonth();
        $check = $date->format('Y-m');
        $date = $date->modify('+'.$nth.' '.static::$days[$dayOfWeek]);

        return $date->format('Y-m') === $check ? $this->modify($date) : false;
    }

    /**
     * Modify to the first occurrence of a given day of the week
     * in the current quarter. If no dayOfWeek is provided, modify to the
     * first day of the current quarter.  Use the supplied constants
     * to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int|null $dayOfWeek day of the week default null
     *
     * @return static
     */
    public function firstOfQuarter($dayOfWeek = null)
    {
        return $this->setDate($this->year, $this->quarter * static::MONTHS_PER_QUARTER - 2, 1)->firstOfMonth($dayOfWeek);
    }

    /**
     * Modify to the last occurrence of a given day of the week
     * in the current quarter. If no dayOfWeek is provided, modify to the
     * last day of the current quarter.  Use the supplied constants
     * to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int|null $dayOfWeek day of the week default null
     *
     * @return static
     */
    public function lastOfQuarter($dayOfWeek = null)
    {
        return $this->setDate($this->year, $this->quarter * static::MONTHS_PER_QUARTER, 1)->lastOfMonth($dayOfWeek);
    }

    /**
     * Modify to the given occurrence of a given day of the week
     * in the current quarter. If the calculated occurrence is outside the scope
     * of the current quarter, then return false and no modifications are made.
     * Use the supplied constants to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int $nth
     * @param int $dayOfWeek
     *
     * @return mixed
     */
    public function nthOfQuarter($nth, $dayOfWeek)
    {
        $date = $this->copy()->day(1)->month($this->quarter * static::MONTHS_PER_QUARTER);
        $lastMonth = $date->month;
        $year = $date->year;
        $date = $date->firstOfQuarter()->modify('+'.$nth.' '.static::$days[$dayOfWeek]);

        return ($lastMonth < $date->month || $year !== $date->year) ? false : $this->modify($date);
    }

    /**
     * Modify to the first occurrence of a given day of the week
     * in the current year. If no dayOfWeek is provided, modify to the
     * first day of the current year.  Use the supplied constants
     * to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int|null $dayOfWeek day of the week default null
     *
     * @return static
     */
    public function firstOfYear($dayOfWeek = null)
    {
        return $this->month(1)->firstOfMonth($dayOfWeek);
    }

    /**
     * Modify to the last occurrence of a given day of the week
     * in the current year. If no dayOfWeek is provided, modify to the
     * last day of the current year.  Use the supplied constants
     * to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int|null $dayOfWeek day of the week default null
     *
     * @return static
     */
    public function lastOfYear($dayOfWeek = null)
    {
        return $this->month(static::MONTHS_PER_YEAR)->lastOfMonth($dayOfWeek);
    }

    /**
     * Modify to the given occurrence of a given day of the week
     * in the current year. If the calculated occurrence is outside the scope
     * of the current year, then return false and no modifications are made.
     * Use the supplied constants to indicate the desired dayOfWeek, ex. static::MONDAY.
     *
     * @param int $nth
     * @param int $dayOfWeek
     *
     * @return mixed
     */
    public function nthOfYear($nth, $dayOfWeek)
    {
        $date = $this->copy()->firstOfYear()->modify('+'.$nth.' '.static::$days[$dayOfWeek]);

        return $this->year === $date->year ? $this->modify($date) : false;
    }

    /**
     * Modify the current instance to the average of a given instance (default now) and the current instance.
     *
     * @param \Carbon\Carbon|\DateTimeInterface|null $date
     *
     * @return static
     */
    public function average($date = null)
    {
        return $this->addSeconds((int) ($this->diffInSeconds($this->resolveCarbon($date), false) / 2));
    }

    ///////////////////////////////////////////////////////////////////
    /////////////////////////// SERIALIZATION /////////////////////////
    ///////////////////////////////////////////////////////////////////

    /**
     * Return a serialized string of the instance.
     *
     * @return string
     */
    public function serialize()
    {
        return serialize($this);
    }

    /**
     * Create an instance from a serialized string.
     *
     * @param string $value
     *
     * @throws \InvalidArgumentException
     *
     * @return static
     */
    public static function fromSerialized($value)
    {
        $instance = @unserialize($value);

        if (!$instance instanceof static) {
            throw new InvalidArgumentException('Invalid serialized value.');
        }

        return $instance;
    }

    /**
     * The __set_state handler.
     *
     * @param string|array $dump
     *
     * @return static
     */
    public static function __set_state($dump)
    {
        return is_string($dump) ? static::parse($dump) : static::instance(parent::__set_state($dump));
    }

    /**
     * Returns the list of properties to dump on serialize() called on.
     *
     * @return array
     */
    public function __sleep()
    {
        $properties = ['date', 'timezone_type', 'timezone'];
        if ($this->localTranslator) {
            $properties[] = 'dumpLocale';
            $this->dumpLocale = $this->locale;
        }

        return $properties;
    }

    /**
     * Set locale if specified on unserialize() called.
     */
    public function __wakeup()
    {
        if (method_exists(parent::class, '__wakeup')) {
            parent::__wakeup();
        }
        if (isset($this->dumpLocale)) {
            $this->locale($this->dumpLocale);
            $this->dumpLocale = null;
        }
    }

    /**
     * Prepare the object for JSON serialization.
     *
     * @return array|string
     */
    public function jsonSerialize()
    {
        if (static::$serializer) {
            return call_user_func(static::$serializer, $this);
        }

        return $this->toJSON();
    }

    /**
     * JSON serialize all Carbon instances using the given callback.
     *
     * @param callable $callback
     *
     * @return void
     */
    public static function serializeUsing($callback)
    {
        static::$serializer = $callback;
    }

    /**
     * Dynamically handle calls to the class.
     *
     * @param string $method     magic method name called
     * @param array  $parameters parameters list
     *
     * @throws \BadMethodCallException
     *
     * @return mixed
     */
    public static function __callStatic($method, $parameters)
    {
        if (!static::hasMacro($method)) {
            if (static::isStrictModeEnabled()) {
                throw new BadMethodCallException(sprintf(
                    'Method %s::%s does not exist.', static::class, $method
                ));
            }

            return null;
        }

        if (static::$localMacros[$method] instanceof Closure) {
            return call_user_func_array(Closure::bind(static::$localMacros[$method], null, get_called_class()), $parameters);
        }

        return call_user_func_array(static::$localMacros[$method], $parameters);
    }

    /**
     * Set specified unit to new given value.
     *
     * @param string $unit  year, month, day, hour, minute, second or microsecond
     * @param int    $value new value for given unit
     *
     * @return static
     */
    public function setUnit($unit, $value = null)
    {
        $unit = static::singularUnit($unit);
        $dateUnits = ['year', 'month', 'day'];
        if (in_array($unit, $dateUnits)) {
            return $this->setDate(...array_map(function ($name) use ($unit, $value) {
                return $name === $unit ? $value : $this->$name;
            }, $dateUnits));
        }

        $units = ['hour', 'minute', 'second', 'micro'];
        if ($unit === 'microsecond') {
            $unit = 'micro';
        }

        return $this->setTime(...array_map(function ($name) use ($unit, $value) {
            return $name === $unit ? $value : $this->$name;
        }, $units));
    }

    /**
     * Returns standardized singular of a given singular/plural unit name (in English).
     *
     * @param string $unit
     *
     * @return string
     */
    public static function singularUnit(string $unit): string
    {
        $unit = rtrim(strtolower($unit), 's');

        if ($unit === 'centurie') {
            return 'century';
        }

        if ($unit === 'millennia') {
            return 'millennium';
        }

        return $unit;
    }

    /**
     * Returns standardized plural of a given singular/plural unit name (in English).
     *
     * @param string $unit
     *
     * @return string
     */
    public static function pluralUnit(string $unit): string
    {
        $unit = rtrim(strtolower($unit), 's');

        if ($unit === 'century') {
            return 'centuries';
        }

        if ($unit === 'millennium' || $unit === 'millennia') {
            return 'millennia';
        }

        return "${unit}s";
    }

    /**
     * Dynamically handle calls to the class.
     *
     * @param string $method     magic method name called
     * @param array  $parameters parameters list
     *
     * @throws \BadMethodCallException|\ReflectionException
     *
     * @return mixed
     */
    public function __call($method, $parameters)
    {
        $diffSizes = [
            // @mode diffForHumans
            'short' => true,
            // @mode diffForHumans
            'long' => false,
        ];
        $diffSyntaxModes = [
            // @call diffForHumans
            'Absolute' => CarbonInterface::DIFF_ABSOLUTE,
            // @call diffForHumans
            'Relative' => CarbonInterface::DIFF_RELATIVE_AUTO,
            // @call diffForHumans
            'RelativeToNow' => CarbonInterface::DIFF_RELATIVE_TO_NOW,
            // @call diffForHumans
            'RelativeToOther' => CarbonInterface::DIFF_RELATIVE_TO_OTHER,
        ];
        $sizePattern = implode('|', array_keys($diffSizes));
        $syntaxPattern = implode('|', array_keys($diffSyntaxModes));
        if (preg_match("/^(?<size>$sizePattern)(?<syntax>$syntaxPattern)DiffForHumans$/", $method, $match)) {
            $dates = array_filter($parameters, function ($parameter) {
                return $parameter instanceof DateTimeInterface;
            });
            $other = null;
            if (count($dates)) {
                $key = key($dates);
                $other = current($dates);
                array_splice($parameters, $key, 1);
            }

            return $this->diffForHumans($other, $diffSyntaxModes[$match['syntax']], $diffSizes[$match['size']], ...$parameters);
        }

        $action = substr($method, 0, 4);
        if ($action !== 'ceil') {
            $action = substr($method, 0, 5);
        }
        if (in_array($action, ['round', 'floor', 'ceil'])) {
            return $this->{$action.'Unit'}(substr($method, strlen($action)), ...$parameters);
        }

        $unit = rtrim($method, 's');
        if (substr($unit, 0, 2) === 'is') {
            $word = substr($unit, 2);
            if (in_array($word, static::$days)) {
                return $this->isDayOfWeek($word);
            }
            switch ($word) {
                // @call is Check if the current instance has UTC timezone.
                case 'Utc':
                // @call is Check if the current instance has UTC timezone.
                case 'UTC':
                    return $this->utc;
                // @call is Check if the current instance has non-UTC timezone.
                case 'Local':
                    return $this->local;
                // @call is Check if the current instance is a valid date.
                case 'Valid':
                    return $this->year !== 0;
                // @call is Check if the current instance is in a daylight saving time.
                case 'DST':
                    return $this->dst;
            }
        }

        $action = substr($unit, 0, 3);
        $overflow = null;
        if ($action === 'set') {
            $unit = strtolower(substr($unit, 3));
        }

        if (in_array($unit, static::$units)) {
            return $this->setUnit($unit, ...$parameters);
        }

        if ($action === 'add' || $action === 'sub') {
            $unit = substr($unit, 3);
            if (substr($unit, 0, 4) === 'Real') {
                $unit = static::singularUnit(substr($unit, 4));

                return $this->{"${action}RealUnit"}($unit, ...$parameters);
            }

            if (preg_match('/^(Month|Quarter|Year|Decade|Century|Centurie|Millennium|Millennia)s?(No|With|Without|WithNo)Overflow$/', $unit, $match)) {
                $unit = $match[1];
                $overflow = $match[2] === 'With';
            }
            $unit = static::singularUnit($unit);
        }

        if (static::isModifiableUnit($unit)) {
            return $this->{"${action}Unit"}($unit, $parameters[0] ?? 1, $overflow);
        }

        $sixFirstLetters = substr($unit, 0, 6);
        $factor = -1;

        if ($sixFirstLetters === 'isLast') {
            $sixFirstLetters = 'isNext';
            $factor = 1;
        }

        if ($sixFirstLetters === 'isNext') {
            $lowerUnit = strtolower(substr($unit, 6));

            if (static::isModifiableUnit($lowerUnit)) {
                return $this->copy()->addUnit($lowerUnit, $factor, false)->isSameUnit($lowerUnit, ...$parameters);
            }
        }

        if ($sixFirstLetters === 'isSame') {
            try {
                return $this->isSameUnit(strtolower(substr($unit, 6)), ...$parameters);
            } catch (InvalidArgumentException $exception) {
                // Try next
            }
        }

        if (substr($unit, 0, 9) === 'isCurrent') {
            try {
                return $this->isCurrentUnit(strtolower(substr($unit, 9)));
            } catch (ReflectionException | InvalidArgumentException | BadMethodCallException $exception) {
                // Try macros
            }
        }

        if (!static::hasMacro($method)) {
            if (static::isStrictModeEnabled()) {
                throw new BadMethodCallException("Method $method does not exist.");
            }

            return null;
        }

        $macro = static::$localMacros[$method];

        if ($macro instanceof Closure) {
            return call_user_func_array($macro->bindTo($this, static::class), $parameters);
        }

        return call_user_func_array($macro, $parameters);
    }
}
