<?php

/*
 * This file is part of the Alice package.
 *
 * (c) Nelmio <hello@nelm.io>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Nelmio\Alice\Generator\Hydrator\Property\SymfonyPropertyAccessorHydrator;
use Nelmio\Alice\Generator\Hydrator\SimpleHydrator;

return static function (ContainerConfigurator $container): void {
    $services = $container->services();

    $services->alias(
        'nelmio_alice.generator.hydrator',
        'nelmio_alice.generator.hydrator.simple',
    );

    $services
        ->set(
            'nelmio_alice.generator.hydrator.simple',
            SimpleHydrator::class,
        )
        ->args([
            service('nelmio_alice.generator.hydrator.property'),
        ]);

    $services->alias(
        'nelmio_alice.generator.hydrator.property',
        'nelmio_alice.generator.hydrator.property.symfony_property_access',
    );

    $services
        ->set(
            'nelmio_alice.generator.hydrator.property.symfony_property_access',
            SymfonyPropertyAccessorHydrator::class,
        )
        ->args([
            service('nelmio_alice.property_accessor'),
        ]);
};
