<?php

namespace Liip\MonitorBundle\Check;

use Laminas\Diagnostics\Check\CheckCollectionInterface;

/**
 * @author Kevin Bond <kevinbond@gmail.com>
 */
class ExpressionCollection implements CheckCollectionInterface
{
    private $checks = [];

    public function __construct(array $configs)
    {
        foreach ($configs as $alias => $config) {
            $this->checks[sprintf('expression_%s', $alias)] = new Expression(
                $config['label'],
                $config['warning_expression'],
                $config['critical_expression'],
                $config['warning_message'],
                $config['critical_message']
            );
        }
    }

    /**
     * @return array|\Traversable
     */
    public function getChecks()
    {
        return $this->checks;
    }
}
