# PHP GitHub API

![Build Status](https://github.com/KnpLabs/php-github-api/actions/workflows/ci.yml/badge.svg)
[![StyleCI](https://styleci.io/repos/3948501/shield?style=flat)](https://styleci.io/repos/3948501)
[![Latest Stable Version](https://poser.pugx.org/knplabs/github-api/v/stable)](https://packagist.org/packages/knplabs/github-api)
[![Total Downloads](https://poser.pugx.org/knplabs/github-api/downloads)](https://packagist.org/packages/knplabs/github-api)
[![Monthly Downloads](https://poser.pugx.org/knplabs/github-api/d/monthly)](https://packagist.org/packages/knplabs/github-api)
[![Daily Downloads](https://poser.pugx.org/knplabs/github-api/d/daily)](https://packagist.org/packages/knplabs/github-api)

A simple Object Oriented wrapper for GitHub API, written with PHP.

Uses [GitHub API v3](http://developer.github.com/v3/) & supports [GitHub API v4](http://developer.github.com/v4). The object API (v3) is very similar to the RESTful API.

## Features

* Light and fast thanks to lazy loading of API classes
* Extensively tested and documented

## Requirements

* PHP >= 7.2
* A [PSR-17 implementation](https://packagist.org/providers/psr/http-factory-implementation)
* A [PSR-18 implementation](https://packagist.org/providers/psr/http-client-implementation)

## Quick install

Via [Composer](https://getcomposer.org).

This command will get you up and running quickly with a guzzle http client.

```bash
composer require knplabs/github-api:^3.0 guzzlehttp/guzzle:^7.0.1 http-interop/http-factory-guzzle:^1.0
```

## Advanced install

We are decoupled from any HTTP messaging client with help by [HTTPlug](https://httplug.io). 

### Using a different http client

```bash
composer require knplabs/github-api:^3.0 symfony/http-client nyholm/psr7
```

To set up the github client with this http client

```php
use Github\Client;
use Symfony\Component\HttpClient\HttplugClient;

$client = Client::createWithHttpClient(new HttplugClient());
```

Read more about [using different clients in our docs](doc/customize.md).

## Framework integrations

### Laravel

To integrate this library in laravel [Graham Campbell](https://github.com/GrahamCampbell) created [graham-campbell/github](https://github.com/GrahamCampbell/Laravel-GitHub). See the [installation instructions](https://github.com/GrahamCampbell/Laravel-GitHub#installation) to get started in laravel.

## Basic usage of `php-github-api` client

```php
<?php

// This file is generated by Composer
require_once __DIR__ . '/vendor/autoload.php';

$client = new \Github\Client();
$repositories = $client->api('user')->repositories('ornicar');
```

From `$client` object, you have access to all available GitHub api endpoints.

## Cache usage

This example uses the PSR6 cache pool [redis-adapter](https://github.com/php-cache/redis-adapter). See http://www.php-cache.com/ for alternatives.

```php
<?php

// This file is generated by Composer
require_once __DIR__ . '/vendor/autoload.php';

use Cache\Adapter\Redis\RedisCachePool;

$client = new \Redis();
$client->connect('127.0.0.1', 6379);
// Create a PSR6 cache pool
$pool = new RedisCachePool($client);

$client = new \Github\Client();
$client->addCache($pool);

// Do some request

// Stop using cache
$client->removeCache();
```

Using cache, the client will get cached responses if resources haven't changed since last time,
**without** reaching the `X-Rate-Limit` [imposed by github](http://developer.github.com/v3/#rate-limiting).


## Documentation

See the [`doc` directory](doc/) for more detailed documentation.

## License

`php-github-api` is licensed under the MIT License - see the LICENSE file for details

## Maintainers

Please read [this post](https://knplabs.com/en/blog/news-for-our-foss-projects-maintenance) first.

This library is maintained by the following people (alphabetically sorted) :
- [@acrobat](https://github.com/acrobat)
- [@Nyholm](https://github.com/Nyholm)

## Contributors

- Thanks to [Thibault Duplessis aka. ornicar](https://github.com/ornicar) for his first version of this library.
- Thanks to [Joseph Bielawski aka. stloyd](https://github.com/stloyd) for his contributions and support.
- Thanks to [noloh](https://github.com/noloh) for his contribution on the Object API.
- Thanks to [bshaffer](https://github.com/bshaffer) for his contribution on the Repo API.
- Thanks to [Rolf van de Krol](https://github.com/rolfvandekrol) for his countless contributions.
- Thanks to [Nicolas Pastorino](https://github.com/jeanvoye) for his contribution on the Pull Request API.
- Thanks to [Edoardo Rivello](https://github.com/erivello) for his contribution on the Gists API.
- Thanks to [Miguel Piedrafita](https://github.com/m1guelpf) for his contribution to the v4 & Apps API.
- Thanks to [Emre DEGER](https://github.com/lexor) for his contribution to the Actions API.

Thanks to GitHub for the high quality API and documentation.
