---
layout: default
title: Method Reference - Session
---

## Constants

## Methods

### __construct


     SpotifyWebAPI\Session::__construct(string $clientId, string $clientSecret, string $redirectUri, \SpotifyWebAPI\Request $request)

Constructor<br>
Set up client credentials.




### getAuthorizeUrl


    string SpotifyWebAPI\Session::getAuthorizeUrl(array|object $options)

Get the authorization URL.


#### Return values
* **string** The authorization URL.



### getAccessToken


    string SpotifyWebAPI\Session::getAccessToken()

Get the access token.


#### Return values
* **string** The access token.



### getClientId


    string SpotifyWebAPI\Session::getClientId()

Get the client ID.


#### Return values
* **string** The client ID.



### getClientSecret


    string SpotifyWebAPI\Session::getClientSecret()

Get the client secret.


#### Return values
* **string** The client secret.



### getTokenExpiration


    integer SpotifyWebAPI\Session::getTokenExpiration()

Get the access token expiration time.


#### Return values
* **integer** A Unix timestamp indicating the token expiration time.



### getRedirectUri


    string SpotifyWebAPI\Session::getRedirectUri()

Get the client's redirect URI.


#### Return values
* **string** The redirect URI.



### getRefreshToken


    string SpotifyWebAPI\Session::getRefreshToken()

Get the refresh token.


#### Return values
* **string** The refresh token.



### refreshAccessToken


    boolean SpotifyWebAPI\Session::refreshAccessToken(string $refreshToken)

Refresh an access token.


#### Return values
* **boolean** Whether the access token was successfully refreshed.



### requestCredentialsToken


    boolean SpotifyWebAPI\Session::requestCredentialsToken(array $scope)

Request an access token using the Client Credentials Flow.


#### Return values
* **boolean** True when an access token was successfully granted, false otherwise.



### requestAccessToken


    boolean SpotifyWebAPI\Session::requestAccessToken(string $authorizationCode)

Request an access token given an authorization code.


#### Return values
* **boolean** True when the access token was successfully granted, false otherwise.



### setClientId


    void SpotifyWebAPI\Session::setClientId(string $clientId)

Set the client ID.


#### Return values
* **void** 



### setClientSecret


    void SpotifyWebAPI\Session::setClientSecret(string $clientSecret)

Set the client secret.


#### Return values
* **void** 



### setRedirectUri


    void SpotifyWebAPI\Session::setRedirectUri(string $redirectUri)

Set the client's redirect URI.


#### Return values
* **void** 


