<?php

declare(strict_types=1);

/*
 * This file has been auto generated by Jane,
 *
 * Do no edit it directly.
 */

namespace Jane\JsonSchema\Normalizer;

use Jane\JsonSchemaRuntime\Reference;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class JsonSchemaNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;

    public function supportsDenormalization($data, $type, $format = null)
    {
        return $type === 'Jane\\JsonSchema\\Model\\JsonSchema';
    }

    public function supportsNormalization($data, $format = null)
    {
        return $data instanceof \Jane\JsonSchema\Model\JsonSchema;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (!is_object($data)) {
            return null;
        }
        if (isset($data->{'$ref'})) {
            return new Reference($data->{'$ref'}, $context['document-origin']);
        }
        $object = new \Jane\JsonSchema\Model\JsonSchema();
        if (property_exists($data, 'id') && $data->{'id'} !== null) {
            $object->setId($data->{'id'});
        }
        if (property_exists($data, '$schema') && $data->{'$schema'} !== null) {
            $object->setDollarSchema($data->{'$schema'});
        }
        if (property_exists($data, 'title') && $data->{'title'} !== null) {
            $object->setTitle($data->{'title'});
        }
        if (property_exists($data, 'description') && $data->{'description'} !== null) {
            $object->setDescription($data->{'description'});
        }
        if (property_exists($data, 'default') && $data->{'default'} !== null) {
            $object->setDefault($data->{'default'});
        }
        if (property_exists($data, 'multipleOf') && $data->{'multipleOf'} !== null) {
            $object->setMultipleOf($data->{'multipleOf'});
        }
        if (property_exists($data, 'maximum') && $data->{'maximum'} !== null) {
            $object->setMaximum($data->{'maximum'});
        }
        if (property_exists($data, 'exclusiveMaximum') && $data->{'exclusiveMaximum'} !== null) {
            $object->setExclusiveMaximum($data->{'exclusiveMaximum'});
        }
        if (property_exists($data, 'minimum') && $data->{'minimum'} !== null) {
            $object->setMinimum($data->{'minimum'});
        }
        if (property_exists($data, 'exclusiveMinimum') && $data->{'exclusiveMinimum'} !== null) {
            $object->setExclusiveMinimum($data->{'exclusiveMinimum'});
        }
        if (property_exists($data, 'maxLength') && $data->{'maxLength'} !== null) {
            $object->setMaxLength($data->{'maxLength'});
        }
        if (property_exists($data, 'minLength') && $data->{'minLength'} !== null) {
            $object->setMinLength($data->{'minLength'});
        }
        if (property_exists($data, 'pattern') && $data->{'pattern'} !== null) {
            $object->setPattern($data->{'pattern'});
        }
        if (property_exists($data, 'additionalItems') && $data->{'additionalItems'} !== null) {
            $value = $data->{'additionalItems'};
            if (is_bool($data->{'additionalItems'})) {
                $value = $data->{'additionalItems'};
            } elseif (is_object($data->{'additionalItems'})) {
                $value = $this->denormalizer->denormalize($data->{'additionalItems'}, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
            }
            $object->setAdditionalItems($value);
        }
        if (property_exists($data, 'items') && $data->{'items'} !== null) {
            $value_1 = $data->{'items'};
            if (is_object($data->{'items'})) {
                $value_1 = $this->denormalizer->denormalize($data->{'items'}, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
            } elseif (is_array($data->{'items'})) {
                $values = [];
                foreach ($data->{'items'} as $value_2) {
                    $values[] = $this->denormalizer->denormalize($value_2, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
                }
                $value_1 = $values;
            }
            $object->setItems($value_1);
        }
        if (property_exists($data, 'maxItems') && $data->{'maxItems'} !== null) {
            $object->setMaxItems($data->{'maxItems'});
        }
        if (property_exists($data, 'minItems') && $data->{'minItems'} !== null) {
            $object->setMinItems($data->{'minItems'});
        }
        if (property_exists($data, 'uniqueItems') && $data->{'uniqueItems'} !== null) {
            $object->setUniqueItems($data->{'uniqueItems'});
        }
        if (property_exists($data, 'maxProperties') && $data->{'maxProperties'} !== null) {
            $object->setMaxProperties($data->{'maxProperties'});
        }
        if (property_exists($data, 'minProperties') && $data->{'minProperties'} !== null) {
            $object->setMinProperties($data->{'minProperties'});
        }
        if (property_exists($data, 'required') && $data->{'required'} !== null) {
            $values_1 = [];
            foreach ($data->{'required'} as $value_3) {
                $values_1[] = $value_3;
            }
            $object->setRequired($values_1);
        }
        if (property_exists($data, 'additionalProperties') && $data->{'additionalProperties'} !== null) {
            $value_4 = $data->{'additionalProperties'};
            if (is_bool($data->{'additionalProperties'})) {
                $value_4 = $data->{'additionalProperties'};
            } elseif (is_object($data->{'additionalProperties'})) {
                $value_4 = $this->denormalizer->denormalize($data->{'additionalProperties'}, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
            }
            $object->setAdditionalProperties($value_4);
        }
        if (property_exists($data, 'definitions') && $data->{'definitions'} !== null) {
            $values_2 = new \ArrayObject([], \ArrayObject::ARRAY_AS_PROPS);
            foreach ($data->{'definitions'} as $key => $value_5) {
                $values_2[$key] = $this->denormalizer->denormalize($value_5, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
            }
            $object->setDefinitions($values_2);
        }
        if (property_exists($data, 'properties') && $data->{'properties'} !== null) {
            $values_3 = new \ArrayObject([], \ArrayObject::ARRAY_AS_PROPS);
            foreach ($data->{'properties'} as $key_1 => $value_6) {
                $values_3[$key_1] = $this->denormalizer->denormalize($value_6, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
            }
            $object->setProperties($values_3);
        }
        if (property_exists($data, 'patternProperties') && $data->{'patternProperties'} !== null) {
            $values_4 = new \ArrayObject([], \ArrayObject::ARRAY_AS_PROPS);
            foreach ($data->{'patternProperties'} as $key_2 => $value_7) {
                $values_4[$key_2] = $this->denormalizer->denormalize($value_7, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
            }
            $object->setPatternProperties($values_4);
        }
        if (property_exists($data, 'dependencies') && $data->{'dependencies'} !== null) {
            $values_5 = new \ArrayObject([], \ArrayObject::ARRAY_AS_PROPS);
            foreach ($data->{'dependencies'} as $key_3 => $value_8) {
                $value_9 = $value_8;
                if (is_object($value_8)) {
                    $value_9 = $this->denormalizer->denormalize($value_8, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
                } elseif (is_array($value_8)) {
                    $values_6 = [];
                    foreach ($value_8 as $value_10) {
                        $values_6[] = $value_10;
                    }
                    $value_9 = $values_6;
                }
                $values_5[$key_3] = $value_9;
            }
            $object->setDependencies($values_5);
        }
        if (property_exists($data, 'enum') && $data->{'enum'} !== null) {
            $values_7 = [];
            foreach ($data->{'enum'} as $value_11) {
                $values_7[] = $value_11;
            }
            $object->setEnum($values_7);
        }
        if (property_exists($data, 'type') && $data->{'type'} !== null) {
            $value_12 = $data->{'type'};
            if (is_array($data->{'type'})) {
                $values_8 = [];
                foreach ($data->{'type'} as $value_13) {
                    $values_8[] = $value_13;
                }
                $value_12 = $values_8;
            } elseif (isset($data->{'type'})) {
                $value_12 = $data->{'type'};
            }
            $object->setType($value_12);
        }
        if (property_exists($data, 'format') && $data->{'format'} !== null) {
            $object->setFormat($data->{'format'});
        }
        if (property_exists($data, 'allOf') && $data->{'allOf'} !== null) {
            $values_9 = [];
            foreach ($data->{'allOf'} as $value_14) {
                $values_9[] = $this->denormalizer->denormalize($value_14, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
            }
            $object->setAllOf($values_9);
        }
        if (property_exists($data, 'anyOf') && $data->{'anyOf'} !== null) {
            $values_10 = [];
            foreach ($data->{'anyOf'} as $value_15) {
                $values_10[] = $this->denormalizer->denormalize($value_15, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
            }
            $object->setAnyOf($values_10);
        }
        if (property_exists($data, 'oneOf') && $data->{'oneOf'} !== null) {
            $values_11 = [];
            foreach ($data->{'oneOf'} as $value_16) {
                $values_11[] = $this->denormalizer->denormalize($value_16, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context);
            }
            $object->setOneOf($values_11);
        }
        if (property_exists($data, 'not') && $data->{'not'} !== null) {
            $object->setNot($this->denormalizer->denormalize($data->{'not'}, 'Jane\\JsonSchema\\Model\\JsonSchema', 'json', $context));
        }

        return $object;
    }

    public function normalize($object, $format = null, array $context = [])
    {
        $data = new \stdClass();
        if (null !== $object->getId()) {
            $data->{'id'} = $object->getId();
        }
        if (null !== $object->getDollarSchema()) {
            $data->{'$schema'} = $object->getDollarSchema();
        }
        if (null !== $object->getTitle()) {
            $data->{'title'} = $object->getTitle();
        }
        if (null !== $object->getDescription()) {
            $data->{'description'} = $object->getDescription();
        }
        if (null !== $object->getDefault()) {
            $data->{'default'} = $object->getDefault();
        }
        if (null !== $object->getMultipleOf()) {
            $data->{'multipleOf'} = $object->getMultipleOf();
        }
        if (null !== $object->getMaximum()) {
            $data->{'maximum'} = $object->getMaximum();
        }
        if (null !== $object->getExclusiveMaximum()) {
            $data->{'exclusiveMaximum'} = $object->getExclusiveMaximum();
        }
        if (null !== $object->getMinimum()) {
            $data->{'minimum'} = $object->getMinimum();
        }
        if (null !== $object->getExclusiveMinimum()) {
            $data->{'exclusiveMinimum'} = $object->getExclusiveMinimum();
        }
        if (null !== $object->getMaxLength()) {
            $data->{'maxLength'} = $object->getMaxLength();
        }
        if (null !== $object->getMinLength()) {
            $data->{'minLength'} = $object->getMinLength();
        }
        if (null !== $object->getPattern()) {
            $data->{'pattern'} = $object->getPattern();
        }
        if (null !== $object->getAdditionalItems()) {
            $value = $object->getAdditionalItems();
            if (is_bool($object->getAdditionalItems())) {
                $value = $object->getAdditionalItems();
            } elseif (is_object($object->getAdditionalItems())) {
                $value = $this->normalizer->normalize($object->getAdditionalItems(), 'json', $context);
            }
            $data->{'additionalItems'} = $value;
        }
        if (null !== $object->getItems()) {
            $value_1 = $object->getItems();
            if (is_object($object->getItems())) {
                $value_1 = $this->normalizer->normalize($object->getItems(), 'json', $context);
            } elseif (is_array($object->getItems())) {
                $values = [];
                foreach ($object->getItems() as $value_2) {
                    $values[] = $this->normalizer->normalize($value_2, 'json', $context);
                }
                $value_1 = $values;
            }
            $data->{'items'} = $value_1;
        }
        if (null !== $object->getMaxItems()) {
            $data->{'maxItems'} = $object->getMaxItems();
        }
        if (null !== $object->getMinItems()) {
            $data->{'minItems'} = $object->getMinItems();
        }
        if (null !== $object->getUniqueItems()) {
            $data->{'uniqueItems'} = $object->getUniqueItems();
        }
        if (null !== $object->getMaxProperties()) {
            $data->{'maxProperties'} = $object->getMaxProperties();
        }
        if (null !== $object->getMinProperties()) {
            $data->{'minProperties'} = $object->getMinProperties();
        }
        if (null !== $object->getRequired()) {
            $values_1 = [];
            foreach ($object->getRequired() as $value_3) {
                $values_1[] = $value_3;
            }
            $data->{'required'} = $values_1;
        }
        if (null !== $object->getAdditionalProperties()) {
            $value_4 = $object->getAdditionalProperties();
            if (is_bool($object->getAdditionalProperties())) {
                $value_4 = $object->getAdditionalProperties();
            } elseif (is_object($object->getAdditionalProperties())) {
                $value_4 = $this->normalizer->normalize($object->getAdditionalProperties(), 'json', $context);
            }
            $data->{'additionalProperties'} = $value_4;
        }
        if (null !== $object->getDefinitions()) {
            $values_2 = new \stdClass();
            foreach ($object->getDefinitions() as $key => $value_5) {
                $values_2->{$key} = $this->normalizer->normalize($value_5, 'json', $context);
            }
            $data->{'definitions'} = $values_2;
        }
        if (null !== $object->getProperties()) {
            $values_3 = new \stdClass();
            foreach ($object->getProperties() as $key_1 => $value_6) {
                $values_3->{$key_1} = $this->normalizer->normalize($value_6, 'json', $context);
            }
            $data->{'properties'} = $values_3;
        }
        if (null !== $object->getPatternProperties()) {
            $values_4 = new \stdClass();
            foreach ($object->getPatternProperties() as $key_2 => $value_7) {
                $values_4->{$key_2} = $this->normalizer->normalize($value_7, 'json', $context);
            }
            $data->{'patternProperties'} = $values_4;
        }
        if (null !== $object->getDependencies()) {
            $values_5 = new \stdClass();
            foreach ($object->getDependencies() as $key_3 => $value_8) {
                $value_9 = $value_8;
                if (is_object($value_8)) {
                    $value_9 = $this->normalizer->normalize($value_8, 'json', $context);
                } elseif (is_array($value_8)) {
                    $values_6 = [];
                    foreach ($value_8 as $value_10) {
                        $values_6[] = $value_10;
                    }
                    $value_9 = $values_6;
                }
                $values_5->{$key_3} = $value_9;
            }
            $data->{'dependencies'} = $values_5;
        }
        if (null !== $object->getEnum()) {
            $values_7 = [];
            foreach ($object->getEnum() as $value_11) {
                $values_7[] = $value_11;
            }
            $data->{'enum'} = $values_7;
        }
        if (null !== $object->getType()) {
            $value_12 = $object->getType();
            if (is_array($object->getType())) {
                $values_8 = [];
                foreach ($object->getType() as $value_13) {
                    $values_8[] = $value_13;
                }
                $value_12 = $values_8;
            } elseif (!is_null($object->getType())) {
                $value_12 = $object->getType();
            }
            $data->{'type'} = $value_12;
        }
        if (null !== $object->getFormat()) {
            $data->{'format'} = $object->getFormat();
        }
        if (null !== $object->getAllOf()) {
            $values_9 = [];
            foreach ($object->getAllOf() as $value_14) {
                $values_9[] = $this->normalizer->normalize($value_14, 'json', $context);
            }
            $data->{'allOf'} = $values_9;
        }
        if (null !== $object->getAnyOf()) {
            $values_10 = [];
            foreach ($object->getAnyOf() as $value_15) {
                $values_10[] = $this->normalizer->normalize($value_15, 'json', $context);
            }
            $data->{'anyOf'} = $values_10;
        }
        if (null !== $object->getOneOf()) {
            $values_11 = [];
            foreach ($object->getOneOf() as $value_16) {
                $values_11[] = $this->normalizer->normalize($value_16, 'json', $context);
            }
            $data->{'oneOf'} = $values_11;
        }
        if (null !== $object->getNot()) {
            $data->{'not'} = $this->normalizer->normalize($object->getNot(), 'json', $context);
        }

        return $data;
    }
}
