<?php

declare(strict_types=1);

/*
 * This file has been auto generated by Jane,
 *
 * Do no edit it directly.
 */

namespace Jane\JsonSchema\Model;

class JsonSchema
{
    /**
     * @var string|null
     */
    protected $id;
    /**
     * @var string|null
     */
    protected $dollarSchema;
    /**
     * @var string|null
     */
    protected $title;
    /**
     * @var string|null
     */
    protected $description;
    /**
     * @var mixed|null
     */
    protected $default;
    /**
     * @var float|null
     */
    protected $multipleOf;
    /**
     * @var float|null
     */
    protected $maximum;
    /**
     * @var bool|null
     */
    protected $exclusiveMaximum = false;
    /**
     * @var float|null
     */
    protected $minimum;
    /**
     * @var bool|null
     */
    protected $exclusiveMinimum = false;
    /**
     * @var int|null
     */
    protected $maxLength;
    /**
     * @var int|null
     */
    protected $minLength;
    /**
     * @var string|null
     */
    protected $pattern;
    /**
     * @var bool|JsonSchema|null
     */
    protected $additionalItems;
    /**
     * @var JsonSchema|JsonSchema[]|null
     */
    protected $items;
    /**
     * @var int|null
     */
    protected $maxItems;
    /**
     * @var int|null
     */
    protected $minItems;
    /**
     * @var bool|null
     */
    protected $uniqueItems = false;
    /**
     * @var int|null
     */
    protected $maxProperties;
    /**
     * @var int|null
     */
    protected $minProperties;
    /**
     * @var string[]|null
     */
    protected $required;
    /**
     * @var bool|JsonSchema|null
     */
    protected $additionalProperties;
    /**
     * @var JsonSchema[]|null
     */
    protected $definitions;
    /**
     * @var JsonSchema[]|null
     */
    protected $properties;
    /**
     * @var JsonSchema[]|null
     */
    protected $patternProperties;
    /**
     * @var JsonSchema[]|string[][]|null
     */
    protected $dependencies;
    /**
     * @var mixed[]|null
     */
    protected $enum;
    /**
     * @var mixed|mixed[]|null
     */
    protected $type;
    /**
     * @var string|null
     */
    protected $format;
    /**
     * @var JsonSchema[]|null
     */
    protected $allOf;
    /**
     * @var JsonSchema[]|null
     */
    protected $anyOf;
    /**
     * @var JsonSchema[]|null
     */
    protected $oneOf;
    /**
     * Core schema meta-schema.
     *
     * @var JsonSchema|null
     */
    protected $not;

    /**
     * @return string|null
     */
    public function getId(): ?string
    {
        return $this->id;
    }

    /**
     * @param string|null $id
     *
     * @return self
     */
    public function setId(?string $id): self
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDollarSchema(): ?string
    {
        return $this->dollarSchema;
    }

    /**
     * @param string|null $dollarSchema
     *
     * @return self
     */
    public function setDollarSchema(?string $dollarSchema): self
    {
        $this->dollarSchema = $dollarSchema;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @param string|null $title
     *
     * @return self
     */
    public function setTitle(?string $title): self
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     *
     * @return self
     */
    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getDefault()
    {
        return $this->default;
    }

    /**
     * @param mixed $default
     *
     * @return self
     */
    public function setDefault($default): self
    {
        $this->default = $default;

        return $this;
    }

    /**
     * @return float|null
     */
    public function getMultipleOf(): ?float
    {
        return $this->multipleOf;
    }

    /**
     * @param float|null $multipleOf
     *
     * @return self
     */
    public function setMultipleOf(?float $multipleOf): self
    {
        $this->multipleOf = $multipleOf;

        return $this;
    }

    /**
     * @return float|null
     */
    public function getMaximum(): ?float
    {
        return $this->maximum;
    }

    /**
     * @param float|null $maximum
     *
     * @return self
     */
    public function setMaximum(?float $maximum): self
    {
        $this->maximum = $maximum;

        return $this;
    }

    /**
     * @return bool|null
     */
    public function getExclusiveMaximum(): ?bool
    {
        return $this->exclusiveMaximum;
    }

    /**
     * @param bool|null $exclusiveMaximum
     *
     * @return self
     */
    public function setExclusiveMaximum(?bool $exclusiveMaximum): self
    {
        $this->exclusiveMaximum = $exclusiveMaximum;

        return $this;
    }

    /**
     * @return float|null
     */
    public function getMinimum(): ?float
    {
        return $this->minimum;
    }

    /**
     * @param float|null $minimum
     *
     * @return self
     */
    public function setMinimum(?float $minimum): self
    {
        $this->minimum = $minimum;

        return $this;
    }

    /**
     * @return bool|null
     */
    public function getExclusiveMinimum(): ?bool
    {
        return $this->exclusiveMinimum;
    }

    /**
     * @param bool|null $exclusiveMinimum
     *
     * @return self
     */
    public function setExclusiveMinimum(?bool $exclusiveMinimum): self
    {
        $this->exclusiveMinimum = $exclusiveMinimum;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getMaxLength(): ?int
    {
        return $this->maxLength;
    }

    /**
     * @param int|null $maxLength
     *
     * @return self
     */
    public function setMaxLength(?int $maxLength): self
    {
        $this->maxLength = $maxLength;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getMinLength(): ?int
    {
        return $this->minLength;
    }

    /**
     * @param int|null $minLength
     *
     * @return self
     */
    public function setMinLength(?int $minLength): self
    {
        $this->minLength = $minLength;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPattern(): ?string
    {
        return $this->pattern;
    }

    /**
     * @param string|null $pattern
     *
     * @return self
     */
    public function setPattern(?string $pattern): self
    {
        $this->pattern = $pattern;

        return $this;
    }

    /**
     * @return bool|JsonSchema|null
     */
    public function getAdditionalItems()
    {
        return $this->additionalItems;
    }

    /**
     * @param bool|JsonSchema|null $additionalItems
     *
     * @return self
     */
    public function setAdditionalItems($additionalItems): self
    {
        $this->additionalItems = $additionalItems;

        return $this;
    }

    /**
     * @return JsonSchema|JsonSchema[]|null
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * @param JsonSchema|JsonSchema[]|null $items
     *
     * @return self
     */
    public function setItems($items): self
    {
        $this->items = $items;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getMaxItems(): ?int
    {
        return $this->maxItems;
    }

    /**
     * @param int|null $maxItems
     *
     * @return self
     */
    public function setMaxItems(?int $maxItems): self
    {
        $this->maxItems = $maxItems;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getMinItems(): ?int
    {
        return $this->minItems;
    }

    /**
     * @param int|null $minItems
     *
     * @return self
     */
    public function setMinItems(?int $minItems): self
    {
        $this->minItems = $minItems;

        return $this;
    }

    /**
     * @return bool|null
     */
    public function getUniqueItems(): ?bool
    {
        return $this->uniqueItems;
    }

    /**
     * @param bool|null $uniqueItems
     *
     * @return self
     */
    public function setUniqueItems(?bool $uniqueItems): self
    {
        $this->uniqueItems = $uniqueItems;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getMaxProperties(): ?int
    {
        return $this->maxProperties;
    }

    /**
     * @param int|null $maxProperties
     *
     * @return self
     */
    public function setMaxProperties(?int $maxProperties): self
    {
        $this->maxProperties = $maxProperties;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getMinProperties(): ?int
    {
        return $this->minProperties;
    }

    /**
     * @param int|null $minProperties
     *
     * @return self
     */
    public function setMinProperties(?int $minProperties): self
    {
        $this->minProperties = $minProperties;

        return $this;
    }

    /**
     * @return string[]|null
     */
    public function getRequired(): ?array
    {
        return $this->required;
    }

    /**
     * @param string[]|null $required
     *
     * @return self
     */
    public function setRequired(?array $required): self
    {
        $this->required = $required;

        return $this;
    }

    /**
     * @return bool|JsonSchema|null
     */
    public function getAdditionalProperties()
    {
        return $this->additionalProperties;
    }

    /**
     * @param bool|JsonSchema|null $additionalProperties
     *
     * @return self
     */
    public function setAdditionalProperties($additionalProperties): self
    {
        $this->additionalProperties = $additionalProperties;

        return $this;
    }

    /**
     * @return JsonSchema[]|null
     */
    public function getDefinitions(): ?\ArrayObject
    {
        return $this->definitions;
    }

    /**
     * @param JsonSchema[]|null $definitions
     *
     * @return self
     */
    public function setDefinitions(?\ArrayObject $definitions): self
    {
        $this->definitions = $definitions;

        return $this;
    }

    /**
     * @return JsonSchema[]|null
     */
    public function getProperties(): ?\ArrayObject
    {
        return $this->properties;
    }

    /**
     * @param JsonSchema[]|null $properties
     *
     * @return self
     */
    public function setProperties(?\ArrayObject $properties): self
    {
        $this->properties = $properties;

        return $this;
    }

    /**
     * @return JsonSchema[]|null
     */
    public function getPatternProperties(): ?\ArrayObject
    {
        return $this->patternProperties;
    }

    /**
     * @param JsonSchema[]|null $patternProperties
     *
     * @return self
     */
    public function setPatternProperties(?\ArrayObject $patternProperties): self
    {
        $this->patternProperties = $patternProperties;

        return $this;
    }

    /**
     * @return JsonSchema[]|string[][]|null
     */
    public function getDependencies(): ?\ArrayObject
    {
        return $this->dependencies;
    }

    /**
     * @param JsonSchema[]|string[][]|null $dependencies
     *
     * @return self
     */
    public function setDependencies(?\ArrayObject $dependencies): self
    {
        $this->dependencies = $dependencies;

        return $this;
    }

    /**
     * @return mixed[]|null
     */
    public function getEnum(): ?array
    {
        return $this->enum;
    }

    /**
     * @param mixed[]|null $enum
     *
     * @return self
     */
    public function setEnum(?array $enum): self
    {
        $this->enum = $enum;

        return $this;
    }

    /**
     * @return mixed|mixed[]
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param mixed|mixed[] $type
     *
     * @return self
     */
    public function setType($type): self
    {
        $this->type = $type;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getFormat(): ?string
    {
        return $this->format;
    }

    /**
     * @param string|null $format
     *
     * @return self
     */
    public function setFormat(?string $format): self
    {
        $this->format = $format;

        return $this;
    }

    /**
     * @return JsonSchema[]|null
     */
    public function getAllOf(): ?array
    {
        return $this->allOf;
    }

    /**
     * @param JsonSchema[]|null $allOf
     *
     * @return self
     */
    public function setAllOf(?array $allOf): self
    {
        $this->allOf = $allOf;

        return $this;
    }

    /**
     * @return JsonSchema[]|null
     */
    public function getAnyOf(): ?array
    {
        return $this->anyOf;
    }

    /**
     * @param JsonSchema[]|null $anyOf
     *
     * @return self
     */
    public function setAnyOf(?array $anyOf): self
    {
        $this->anyOf = $anyOf;

        return $this;
    }

    /**
     * @return JsonSchema[]|null
     */
    public function getOneOf(): ?array
    {
        return $this->oneOf;
    }

    /**
     * @param JsonSchema[]|null $oneOf
     *
     * @return self
     */
    public function setOneOf(?array $oneOf): self
    {
        $this->oneOf = $oneOf;

        return $this;
    }

    /**
     * Core schema meta-schema.
     *
     * @return JsonSchema|null
     */
    public function getNot(): ?self
    {
        return $this->not;
    }

    /**
     * Core schema meta-schema.
     *
     * @param JsonSchema|null $not
     *
     * @return self
     */
    public function setNot(?self $not): self
    {
        $this->not = $not;

        return $this;
    }
}
