<?php

declare(strict_types=1);

namespace Intervention\Image\Drivers;

use Intervention\Image\Exceptions\DriverException;
use Intervention\Image\Interfaces\ColorInterface;
use Intervention\Image\Interfaces\ImageInterface;
use Intervention\Image\Interfaces\SpecializableInterface;
use Intervention\Image\Traits\CanBeDriverSpecialized;

abstract class SpecializableDecoder extends AbstractDecoder implements SpecializableInterface
{
    use CanBeDriverSpecialized;

    /**
     * {@inheritdoc}
     *
     * @see DecoderInterface::supports()
     *
     * @throws DriverException
     */
    public function supports(mixed $input): bool
    {
        throw new DriverException('Decoder ' . $this::class . ' must be specialized by the driver first');
    }

    /**
     * {@inheritdoc}
     *
     * @see DecoderInterface::decode()
     *
     * @throws DriverException
     */
    public function decode(mixed $input): ImageInterface|ColorInterface
    {
        throw new DriverException('Decoder ' . $this::class . ' must be specialized by the driver first');
    }
}
