<?php

declare(strict_types=1);

namespace Intervention\Gif\Encoders;

use Intervention\Gif\Blocks\TableBasedImage;

class TableBasedImageEncoder extends AbstractEncoder
{
    public function __construct(TableBasedImage $entity)
    {
        $this->entity = $entity;
    }

    public function encode(): string
    {
        return implode('', [
            $this->entity->imageDescriptor()->encode(),
            $this->entity->colorTable() ? $this->entity->colorTable()->encode() : '',
            $this->entity->imageData()->encode(),
        ]);
    }
}
