<?php

/**
 * Copyright 2011-2022 Anthon Pang. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @package WebDriver
 *
 * @author Anthon Pang <apang@softwaredevelopment.ca>
 */

namespace WebDriver;

/**
 * WebDriver\Frame class
 *
 * @package WebDriver
 *
 * @method void parentt() Change focus to the parent context.
 */
final class Frame extends AbstractWebDriver
{
    const WEBDRIVER_FRAME_ID = 'frame-075b-4da1-b6ba-e579c2d3230a';

    /**
     * {@inheritdoc}
     */
    protected function methods()
    {
        return array(
            'parent' => array('POST'),
        );
    }
}
