<?php

/*
 * This file is part of the HWIOAuthBundle package.
 *
 * (c) Hardware Info <opensource@hardware.info>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace HWI\Bundle\OAuthBundle\OAuth\ResourceOwner;

use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Baptiste Clavié <clavie.b@gmail.com>
 */
final class SlackResourceOwner extends GenericOAuth2ResourceOwner
{
    public const TYPE = 'slack';

    /**
     * {@inheritdoc}
     */
    protected array $paths = [
        'identifier' => 'user.id',
        'nickname' => 'user.name',
        'email' => 'user.email',
    ];

    /**
     * {@inheritdoc}
     */
    protected function configureOptions(OptionsResolver $resolver)
    {
        parent::configureOptions($resolver);

        $resolver->setDefaults([
            'authorization_url' => 'https://slack.com/oauth/authorize',
            'access_token_url' => 'https://slack.com/api/oauth.access',
            'infos_url' => 'https://slack.com/api/users.identity',

            'scope' => 'identify',

            'use_bearer_authorization' => false,
            'attr_name' => 'token',
        ]);
    }
}
