<?php
namespace GuzzleHttp\Tests\Command\Guzzle\ResponseLocation;

use GuzzleHttp\Command\Guzzle\Parameter;
use GuzzleHttp\Command\Guzzle\ResponseLocation\StatusCodeLocation;
use GuzzleHttp\Command\Result;
use GuzzleHttp\Psr7\Response;
use PHPUnit\Framework\TestCase;

/**
 * @covers \GuzzleHttp\Command\Guzzle\ResponseLocation\StatusCodeLocation
 * @covers \GuzzleHttp\Command\Guzzle\ResponseLocation\AbstractLocation
 */
class StatusCodeLocationTest extends TestCase
{
    /**
     * @group ResponseLocation
     */
    public function testVisitsLocation()
    {
        $location = new StatusCodeLocation();
        $parameter = new Parameter(['name' => 'val']);
        $response = new Response(200);
        $result = new Result();
        $result = $location->visit($result, $response, $parameter);
        $this->assertEquals(200, $result['val']);
    }
}
