# Upgrade from 1.x to 2.0

## Additions

- Added autoconfiguration support
    - `Gos\Bundle\WebSocketBundle\Periodic\PeriodicInterface` (`gos_web_socket.periodic` tag)
    - `Gos\Bundle\WebSocketBundle\RPC\RpcInterface` (`gos_web_socket.rpc` tag)
    - `Gos\Bundle\WebSocketBundle\Server\Type\ServerInterface` (`gos_web_socket.server` tag)
    - `Gos\Bundle\WebSocketBundle\Topic\TopicInterface` (`gos_web_socket.topic` tag)
- Added `Gos\Bundle\WebSocketBundle\Client\ClientManipulatorInterface::findAllByUsername()`
    - Unlike `Gos\Bundle\WebSocketBundle\Client\ClientManipulatorInterface::findByUsername()` which only returns the first match, the new method returns all matching connections for a username
- Added new `gos_web_socket.ping.services` configuration node to configure pingable periodic services, presently supporting a Doctrine Connection or PDO
    - This is an array node where each value requires two keys: `name` (the container service ID) and `type` (the service type, either "doctrine" or "pdo")
- Added support for env vars on all "host" and "port" config nodes
    
Example configuration of the ping services:

```yaml
gos_web_socket:
    ping:
        services:
            -
                name: 'database_connection' # alias for the default database connection created by the DoctrineBundle
                type: 'doctrine'
            -
                name: 'pdo' # a custom service in your application that is a PDO connection
                type: 'pdo'

```

## Changes

- Renamed the `gos_web_socket_client.js` file to `websocket.js`, in addition the bundle now provides a minified version of this file and a ES2015+ source file
- Enabled `declare(strict_types=1);` in all bundle files
- Added typehints and return types to most classes and interfaces
- Most classes are now final, use decorators or direct implement interfaces to implement custom behaviors
- The dependency to `gos/pubsub-router-bundle` has been raised to `^1.0`, this will require updates to your router resources
- This bundle will now always cause the `gos_pubsub_router.router.websocket` service to be generated by the `GosPubSubRouterBundle`
- `Gos\Bundle\WebSocketBundle\Router\WampRouter` has been modified to account for the updated `GosPubSubRouterBundle`:
    - The `getContext` and `setContext` methods have been removed
    - The `$tokenSeparator` argument of the `generate` and `match` methods has been removed
- Moved all event listener classes to the `Gos\Bundle\WebSocketBundle\EventListener` namespace
- The `Gos\Bundle\WebSocketBundle\Event\Events` class is deprecated, the `Gos\Bundle\WebSocketBundle\GosWebSocketEvents` class should be used instead
- The `Gos\Bundle\WebSocketBundle\Event\ServerEvent` now requires a third argument, `$profile`, indicating if profiling is enabled (i.e. the `--profile` option from the `gos:websocket:server` command)
- `Gos\Bundle\WebSocketBundle\Pusher\PusherInterface` now includes a `setName()` method
- `Gos\Bundle\WebSocketBundle\Pusher\PusherRegistry::addPusher()` and `Gos\Bundle\WebSocketBundle\Pusher\ServerPushHandlerRegistry::addPushHandler()` no longer have a separate `$name` argument, the name from the injected object is used instead
- `Gos\Bundle\WebSocketBundle\Client\ClientManipulatorInterface` has had several changes:
    - The `getClient()` method now returns a `Symfony\Component\Security\Core\Authentication\Token\TokenInterface` object and the return is typehinted (`public function getClient(ConnectionInterface $connection): TokenInterface`)
    - Added a `getUser()` method which is fundamentally similar to the behavior of `getClient()` in 1.x, essentially this is a shortcut for `$manipulator->getClient()->getUser();`
    - Because of the change to `getClient()`, the return types of `findByUsername()`, `findByRoles()`, and `getAll()` have changed to `TokenInterface` objects
    - `findByRoles()` and `getAll()` will now return an empty array when no matching objects are found instead of boolean false
- `Gos\Bundle\WebSocketBundle\Client\ClientStorageInterface` has had the following changes:
    - The `getClient()` method now returns a `Symfony\Component\Security\Core\Authentication\Token\TokenInterface` object and the return is typehinted (`public function getClient(ConnectionInterface $connection): TokenInterface`)
    - The second argument of `addClient()` is now required to be a `TokenInterface` object
    - `findByRoles()` and `getAll()` will now return an empty array when no matching objects are found instead of boolean false
- All bundle services have been explicitly marked public or private
- Registering periodic timers and push handlers in the default websocket server (`Gos\Bundle\WebSocketBundle\Server\Type\WebSocketServer`) has been extracted to event listeners subscribed to the `gos_web_socket.server_launched` event
- Connection related dependencies are now managed by connection factories for the pushers and server push handlers
- The `getConfig()` and `setConfig()` methods of `Gos\Bundle\WebSocketBundle\Pusher\PusherInterface` and `Gos\Bundle\WebSocketBundle\Pusher\ServerPushHandlerInterface` have been removed, as well as the logic in the compiler passes for injecting the configuration from the bundle's services
- The `findByUsername()` method of `Gos\Bundle\WebSocketBundle\Client\ClientManipulatorInterface` is deprecated and will be removed in 3.0, the `findAllByUsername()` method should be used instead.
- The `clientStorageId` property of a connection is no longer set (i.e. `$connection->WAMP->clientStorageId`), if you need this you should get it from the `ClientStorageInterface` (i.e. `$clientStorage->getStorageId($connection)`)
- The router and serializer dependencies of `Gos\Bundle\WebSocketBundle\Pusher\AbstractPusher` and its subclasses are now injected through the constructors
- The first argument of `Gos\Bundle\WebSocketBundle\Pusher\AbstractPusher::doPush()` is now a `Gos\Bundle\WebSocketBundle\Pusher\Message` object instead of a serialized message, subclasses should handle serialization on their own if needed
- The second argument of `Gos\Bundle\WebSocketBundle\Pusher\ServerPushHandlerInterface::handle()` is now typehinted as a `Gos\Bundle\WebSocketBundle\Server\App\PushableWampServerInterface` object
- Server pushers and push handlers now use the `@serializer` service to serialize and deserialize messages instead of a separate `Symfony\Component\Serializer\Serializer` instance
- Renamed a number of bundle services to use a consistent naming convention and deprecated the previous service IDs, please review the `Resources/config/services/deprecated_aliases.yml` file for a list of changes
- The container parameters set by the bundle have been renamed for consistency and to use the bundle's prefix:
    - `web_socket_server.client_storage.ttl` is now `gos_web_socket.client.storage.ttl`
    - `web_socket_server.client_storage.prefix` is now `gos_web_socket.client.storage.prefix`
    - `web_socket_server.port` is now `gos_web_socket.server.port`
    - `web_socket_origin_check` is now `gos_web_socket.server.origin_check`
    - `web_socket_keepalive_ping` is now `gos_web_socket.server.keepalive_ping`
    - `web_socket_keepalive_interval` is now `gos_web_socket.server.keepalive_interval`

Each pusher configuration node now has an `enabled` option, this must be set to true to enable a pusher; for example:

```yaml
gos_web_socket:
    pushers:
        wamp:
            enabled: true
            host: '127.0.0.1'
            port: 1337
```

## Removals

- The minimum supported Symfony version is now 3.4
- Removed support for the [AsseticBundle](https://github.com/symfony/assetic-bundle) as it itself is deprecated
    - The `client.html.twig` file, which loaded assets with Assetic was removed as a result
    - The `ws_client()` Twig function, which rendered the above file, was also removed
    - The `gos_web_socket.assetic` configuration node should be removed from your application
- Removed deprecated classes/traits/interfaces
    - `Gos\Bundle\WebSocketBundle\Client\DoctrineCacheDriverDecorator` was removed, use `Gos\Bundle\WebSocketBundle\Client\Driver\DoctrineCacheDriverDecorator` instead
    - `Gos\Bundle\WebSocketBundle\Client\WebSocketUserTrait` was removed, inject the `@gos_web_socket.client.manipulator` service instead
- Removed the following configuration nodes, these services should be tagged instead
    - `gos_web_socket.periodic`, tag your services with the `gos_web_socket.periodic` tag
    - `gos_web_socket.rpc`, tag your services with the `gos_web_socket.rpc` tag
    - `gos_web_socket.servers`, tag your services with the `gos_web_socket.server` tag
    - `gos_web_socket.topics`, tag your services with the `gos_web_socket.topic` tag
- Removed the `gos_web_socket.pushers.amqp.default` configuration node, it was unused
- The `gos:server` command was removed, use the `gos:websocket:server` command instead
- Removed the `PingableDriverCompilerPass` which previously configured the PDO ping periodic service
- Removed the `gos_web_socket.pdo.periodic_ping` service 
- Removed the `Gos\Bundle\WebSocketBundle\Router\NullPubSubRouter` class and `gos_web_socket.null.pubsub.router` service
- Removed `Gos\Bundle\WebSocketBundle\Pusher\MessageInterface`, the `Gos\Bundle\WebSocketBundle\Pusher\Message` object should be used instead (this is an internal object for building a message for server pushers)
- Removed `Gos\Bundle\WebSocketBundle\Pusher\Serializer\MessageSerializer`, a `Symfony\Component\Serializer\SerializerInterface` implementation should be used instead (generally the `@serializer` service)
- The `Gos\Bundle\WebSocketBundle\Pusher\Amqp\Utils` class has been removed
    - This was an internal helper for building `ext/amqp` related dependencies and should not have been used by package users
- Removed the `gos_web_socket.ws.client` service, a `Gos\Bundle\WebSocketBundle\Pusher\Wamp\WampConnectionFactoryInterface` instance should be used to create the client if needed
- Removed support for ZeroMQ as a push service due to the PHP extension being unmaintained
