<?php declare(strict_types=1);

namespace Gos\Bundle\WebSocketBundle\Event;

use Gos\Bundle\WebSocketBundle\Pusher\ServerPushHandlerInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * @abstract to be declared abstract in 3.0
 */
/*abstract*/ class PushHandlerEvent extends Event
{
    /**
     * @var string
     */
    protected $message;

    /**
     * @var ServerPushHandlerInterface
     */
    protected $pushHandler;

    public function __construct(string $message, ServerPushHandlerInterface $pushHandler)
    {
        $this->message = $message;
        $this->pushHandler = $pushHandler;
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    public function getPushHandler(): ServerPushHandlerInterface
    {
        return $this->pushHandler;
    }
}
