<?php

namespace Gos\Bundle\PubSubRouterBundle\Generator\Dumper;

use Gos\Bundle\PubSubRouterBundle\Matcher\Dumper\CompiledMatcherDumper;

class CompiledGeneratorDumper extends GeneratorDumper
{
    /**
     * @return array<string, array>
     */
    public function getCompiledRoutes(): array
    {
        $compiledRoutes = [];

        foreach ($this->getRoutes()->all() as $name => $route) {
            $compiledRoute = $route->compile();

            $compiledRoutes[$name] = [
                $compiledRoute->getVariables(),
                $route->getDefaults(),
                $route->getRequirements(),
                $compiledRoute->getTokens(),
            ];
        }

        return $compiledRoutes;
    }

    public function dump(array $options = []): string
    {
        return <<<EOF
<?php
// This file has been auto-generated by the PubSubRouterBundle.
return [{$this->generateDeclaredRoutes()}
];
EOF;
    }

    /**
     * Generates PHP code representing an array of defined routes together with the routes properties (e.g. requirements).
     */
    private function generateDeclaredRoutes(): string
    {
        $routes = '';

        foreach ($this->getCompiledRoutes() as $name => $properties) {
            $routes .= sprintf("\n    '%s' => %s,", $name, CompiledMatcherDumper::export($properties));
        }

        return $routes;
    }
}
